from ncei_cruise_schema.orm.cx_oracle import CxOraclePersistenceEngine

from src.mb_cruise_migration.db.oracledb_pooled import OracledbPooledPersistenceEngine
from src.mb_cruise_migration.migration_properties import MigrationProperties


class CruiseDb(object):
    def __init__(self):
        config = MigrationProperties.cruise_db_config
        if config.pooled:
            self.db = OracledbPooledPersistenceEngine(
                host=config.server,
                port=config.port,
                sid=config.sid,
                service_name=config.service,
                user=config.user,
                password=config.password,
                debug_query=True,
                debug_params=True,
            )
        else:
            self.db = CxOraclePersistenceEngine(
                host=config.server,
                port=config.port,
                sid=config.sid,
                service_name=config.service,
                user=config.user,
                password=config.password,
                debug_query=True,
                debug_params=True,
            )
