"""
低代码构建工具.

Usage:
  lesscodeTool (new -d dir [-p project]|sqlacodegen -u url [-s schemas][-t tables][-f file])

Options:
  -h, --help               查看帮助
  -v, --version            展示版本号
  -d, --dir dir            项目目录
  -u, --url url            数据库连接
  -f, --file file          表结构类输出文件
  -p, --project project    项目模板名
  -t, --tables tables      表名，用英文逗号连接多个表
  -s, --schemas schemas    库名，用英文逗号连接多个库
"""
from docopt import docopt

from pkg.tool.new import create_lesscode_project
from pkg.tool.sqlacodegen import sqlacodegen
from pkg.version import __version__


def main():
    arguments = docopt(__doc__, version=__version__)
    new_command_flag = arguments.get("new")
    sqlacodegen_command_flag = arguments.get("sqlacodegen")
    if new_command_flag:
        project = arguments.get("--project")
        project_dir = arguments.get("--dir")
        if project is None:
            project = "lesscode-py"
        if project == "lesscode-py":
            create_lesscode_project(project_dir)
    if sqlacodegen_command_flag:
        url = arguments.get("--url")
        file = arguments.get("--file")
        schema = arguments.get("--schemas")
        table = arguments.get("--tables")
        schemas = None
        tables = None
        if schema is not None:
            schemas = schema.split(",")
        if table is not None:
            tables = table.split(",")
        sqlacodegen(url, schemas, tables, file)


if __name__ == '__main__':
    main()
