#!/usr/bin/env python
# -*- coding: utf-8 -*-

# THIS FILE WAS GENERATED BY generate_classes.py - DO NOT EDIT #
# (Generated on 2020-01-04 18:12:08.660626) #

from .base_classes import Baseevents


class SourceCreated(Baseevents):
    """A source has been created. A source can be an input, a scene or a transition.

    :Returns:
       *sourceName*
            type: String
            Source name
       *sourceType*
            type: String
            Source type. Can be "input", "scene", "transition" or "filter".
       *sourceKind*
            type: String
            Source kind.
       *sourceSettings*
            type: Object
            Source settings
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceCreated'
        self.datain['sourceName'] = None
        self.datain['sourceType'] = None
        self.datain['sourceKind'] = None
        self.datain['sourceSettings'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getSourcetype(self):
        return self.datain['sourceType']

    def getSourcekind(self):
        return self.datain['sourceKind']

    def getSourcesettings(self):
        return self.datain['sourceSettings']


class SourceDestroyed(Baseevents):
    """A source has been destroyed/removed. A source can be an input, a scene or a transition.

    :Returns:
       *sourceName*
            type: String
            Source name
       *sourceType*
            type: String
            Source type. Can be "input", "scene", "transition" or "filter".
       *sourceKind*
            type: String
            Source kind.
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceDestroyed'
        self.datain['sourceName'] = None
        self.datain['sourceType'] = None
        self.datain['sourceKind'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getSourcetype(self):
        return self.datain['sourceType']

    def getSourcekind(self):
        return self.datain['sourceKind']


class SourceVolumeChanged(Baseevents):
    """The volume of a source has changed.

    :Returns:
       *sourceName*
            type: String
            Source name
       *volume*
            type: float
            Source volume
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceVolumeChanged'
        self.datain['sourceName'] = None
        self.datain['volume'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getVolume(self):
        return self.datain['volume']


class SourceMuteStateChanged(Baseevents):
    """A source has been muted or unmuted.

    :Returns:
       *sourceName*
            type: String
            Source name
       *muted*
            type: boolean
            Mute status of the source
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceMuteStateChanged'
        self.datain['sourceName'] = None
        self.datain['muted'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getMuted(self):
        return self.datain['muted']


class SourceAudioSyncOffsetChanged(Baseevents):
    """The audio sync offset of a source has changed.

    :Returns:
       *sourceName*
            type: String
            Source name
       *syncOffset*
            type: int
            Audio sync offset of the source (in nanoseconds)
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceAudioSyncOffsetChanged'
        self.datain['sourceName'] = None
        self.datain['syncOffset'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getSyncoffset(self):
        return self.datain['syncOffset']


class SourceAudioMixersChanged(Baseevents):
    """Audio mixer routing changed on a source.

    :Returns:
       *sourceName*
            type: String
            Source name
       *mixers*
            type: Array<Object>
            Routing status of the source for each audio mixer (array of 6 values)
       *mixers___id*
            type: int
            Mixer number
       *mixers___enabled*
            type: boolean
            Routing status
       *hexMixersValue*
            type: String
            Raw mixer flags (little-endian, one bit per mixer) as an hexadecimal value
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceAudioMixersChanged'
        self.datain['sourceName'] = None
        self.datain['mixers'] = None
        self.datain['mixers.*.id'] = None
        self.datain['mixers.*.enabled'] = None
        self.datain['hexMixersValue'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getMixers(self):
        return self.datain['mixers']

    def getMixers___id(self):
        return self.datain['mixers.*.id']

    def getMixers___enabled(self):
        return self.datain['mixers.*.enabled']

    def getHexmixersvalue(self):
        return self.datain['hexMixersValue']


class SourceRenamed(Baseevents):
    """A source has been renamed.

    :Returns:
       *previousName*
            type: String
            Previous source name
       *newName*
            type: String
            New source name
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceRenamed'
        self.datain['previousName'] = None
        self.datain['newName'] = None

    def getPreviousname(self):
        return self.datain['previousName']

    def getNewname(self):
        return self.datain['newName']


class SourceFilterAdded(Baseevents):
    """A filter was added to a source.

    :Returns:
       *sourceName*
            type: String
            Source name
       *filterName*
            type: String
            Filter name
       *filterType*
            type: String
            Filter type
       *filterSettings*
            type: Object
            Filter settings
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceFilterAdded'
        self.datain['sourceName'] = None
        self.datain['filterName'] = None
        self.datain['filterType'] = None
        self.datain['filterSettings'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getFiltername(self):
        return self.datain['filterName']

    def getFiltertype(self):
        return self.datain['filterType']

    def getFiltersettings(self):
        return self.datain['filterSettings']


class SourceFilterRemoved(Baseevents):
    """A filter was removed from a source.

    :Returns:
       *sourceName*
            type: String
            Source name
       *filterName*
            type: String
            Filter name
       *filterType*
            type: String
            Filter type
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceFilterRemoved'
        self.datain['sourceName'] = None
        self.datain['filterName'] = None
        self.datain['filterType'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getFiltername(self):
        return self.datain['filterName']

    def getFiltertype(self):
        return self.datain['filterType']


class SourceFilterVisibilityChanged(Baseevents):
    """The visibility/enabled state of a filter changed

    :Returns:
       *sourceName*
            type: String
            Source name
       *filterName*
            type: String
            Filter name
       *filterEnabled*
            type: Boolean
            New filter state
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceFilterVisibilityChanged'
        self.datain['sourceName'] = None
        self.datain['filterName'] = None
        self.datain['filterEnabled'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getFiltername(self):
        return self.datain['filterName']

    def getFilterenabled(self):
        return self.datain['filterEnabled']


class SourceFiltersReordered(Baseevents):
    """Filters in a source have been reordered.

    :Returns:
       *sourceName*
            type: String
            Source name
       *filters*
            type: Array<Object>
            Ordered Filters list
       *filters___name*
            type: String
            Filter name
       *filters___type*
            type: String
            Filter type
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceFiltersReordered'
        self.datain['sourceName'] = None
        self.datain['filters'] = None
        self.datain['filters.*.name'] = None
        self.datain['filters.*.type'] = None

    def getSourcename(self):
        return self.datain['sourceName']

    def getFilters(self):
        return self.datain['filters']

    def getFilters___name(self):
        return self.datain['filters.*.name']

    def getFilters___type(self):
        return self.datain['filters.*.type']


class SourceOrderChanged(Baseevents):
    """Scene items have been reordered.

    :Returns:
       *scene_name*
            type: String
            Name of the scene where items have been reordered.
       *scene_items*
            type: Array<Object>
            Ordered list of scene items
       *scene_items___source_name*
            type: String
            Item source name
       *scene_items___item_id*
            type: int
            Scene item unique ID
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SourceOrderChanged'
        self.datain['scene-name'] = None
        self.datain['scene-items'] = None
        self.datain['scene-items.*.source-name'] = None
        self.datain['scene-items.*.item-id'] = None

    def getSceneName(self):
        return self.datain['scene-name']

    def getSceneItems(self):
        return self.datain['scene-items']

    def getSceneItems___sourceName(self):
        return self.datain['scene-items.*.source-name']

    def getSceneItems___itemId(self):
        return self.datain['scene-items.*.item-id']


class SceneItemAdded(Baseevents):
    """An item has been added to the current scene.

    :Returns:
       *scene_name*
            type: String
            Name of the scene.
       *item_name*
            type: String
            Name of the item added to the scene.
       *item_id*
            type: int
            Scene item ID
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SceneItemAdded'
        self.datain['scene-name'] = None
        self.datain['item-name'] = None
        self.datain['item-id'] = None

    def getSceneName(self):
        return self.datain['scene-name']

    def getItemName(self):
        return self.datain['item-name']

    def getItemId(self):
        return self.datain['item-id']


class SceneItemRemoved(Baseevents):
    """An item has been removed from the current scene.

    :Returns:
       *scene_name*
            type: String
            Name of the scene.
       *item_name*
            type: String
            Name of the item removed from the scene.
       *item_id*
            type: int
            Scene item ID
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SceneItemRemoved'
        self.datain['scene-name'] = None
        self.datain['item-name'] = None
        self.datain['item-id'] = None

    def getSceneName(self):
        return self.datain['scene-name']

    def getItemName(self):
        return self.datain['item-name']

    def getItemId(self):
        return self.datain['item-id']


class SceneItemVisibilityChanged(Baseevents):
    """An item's visibility has been toggled.

    :Returns:
       *scene_name*
            type: String
            Name of the scene.
       *item_name*
            type: String
            Name of the item in the scene.
       *item_id*
            type: int
            Scene item ID
       *item_visible*
            type: boolean
            New visibility state of the item.
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SceneItemVisibilityChanged'
        self.datain['scene-name'] = None
        self.datain['item-name'] = None
        self.datain['item-id'] = None
        self.datain['item-visible'] = None

    def getSceneName(self):
        return self.datain['scene-name']

    def getItemName(self):
        return self.datain['item-name']

    def getItemId(self):
        return self.datain['item-id']

    def getItemVisible(self):
        return self.datain['item-visible']


class SceneItemTransformChanged(Baseevents):
    """An item's transform has been changed.

    :Returns:
       *scene_name*
            type: String
            Name of the scene.
       *item_name*
            type: String
            Name of the item in the scene.
       *item_id*
            type: int
            Scene item ID
       *transform*
            type: SceneItemTransform
            Scene item transform properties
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SceneItemTransformChanged'
        self.datain['scene-name'] = None
        self.datain['item-name'] = None
        self.datain['item-id'] = None
        self.datain['transform'] = None

    def getSceneName(self):
        return self.datain['scene-name']

    def getItemName(self):
        return self.datain['item-name']

    def getItemId(self):
        return self.datain['item-id']

    def getTransform(self):
        return self.datain['transform']


class SceneItemSelected(Baseevents):
    """A scene item is selected.

    :Returns:
       *scene_name*
            type: String
            Name of the scene.
       *item_name*
            type: String
            Name of the item in the scene.
       *item_id*
            type: int
            Name of the item in the scene.
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SceneItemSelected'
        self.datain['scene-name'] = None
        self.datain['item-name'] = None
        self.datain['item-id'] = None

    def getSceneName(self):
        return self.datain['scene-name']

    def getItemName(self):
        return self.datain['item-name']

    def getItemId(self):
        return self.datain['item-id']


class SceneItemDeselected(Baseevents):
    """A scene item is deselected.

    :Returns:
       *scene_name*
            type: String
            Name of the scene.
       *item_name*
            type: String
            Name of the item in the scene.
       *item_id*
            type: int
            Name of the item in the scene.
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SceneItemDeselected'
        self.datain['scene-name'] = None
        self.datain['item-name'] = None
        self.datain['item-id'] = None

    def getSceneName(self):
        return self.datain['scene-name']

    def getItemName(self):
        return self.datain['item-name']

    def getItemId(self):
        return self.datain['item-id']


class PreviewSceneChanged(Baseevents):
    """The selected preview scene has changed (only available in Studio Mode).

    :Returns:
       *scene_name*
            type: String
            Name of the scene being previewed.
       *sources*
            type: Array<SceneItem>
            List of sources composing the scene. Same specification as [`GetCurrentScene`](#getcurrentscene).
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'PreviewSceneChanged'
        self.datain['scene-name'] = None
        self.datain['sources'] = None

    def getSceneName(self):
        return self.datain['scene-name']

    def getSources(self):
        return self.datain['sources']


class StudioModeSwitched(Baseevents):
    """Studio Mode has been enabled or disabled.

    :Returns:
       *new_state*
            type: boolean
            The new enabled state of Studio Mode.
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'StudioModeSwitched'
        self.datain['new-state'] = None

    def getNewState(self):
        return self.datain['new-state']


class ReplayStarting(Baseevents):
    """A request to start the replay buffer has been issued.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'ReplayStarting'


class ReplayStarted(Baseevents):
    """Replay Buffer started successfully

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'ReplayStarted'


class ReplayStopping(Baseevents):
    """A request to stop the replay buffer has been issued.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'ReplayStopping'


class ReplayStopped(Baseevents):
    """Replay Buffer stopped successfully

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'ReplayStopped'


class SwitchScenes(Baseevents):
    """Indicates a scene change.

    :Returns:
       *scene_name*
            type: String
            The new scene.
       *sources*
            type: Array<SceneItem>
            List of scene items in the new scene. Same specification as [`GetCurrentScene`](#getcurrentscene).
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SwitchScenes'
        self.datain['scene-name'] = None
        self.datain['sources'] = None

    def getSceneName(self):
        return self.datain['scene-name']

    def getSources(self):
        return self.datain['sources']


class ScenesChanged(Baseevents):
    """The scene list has been modified.
Scenes have been added, removed, or renamed.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'ScenesChanged'


class SceneCollectionChanged(Baseevents):
    """Triggered when switching to another scene collection or when renaming the current scene collection.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SceneCollectionChanged'


class SceneCollectionListChanged(Baseevents):
    """Triggered when a scene collection is created, added, renamed, or removed.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SceneCollectionListChanged'


class ProfileChanged(Baseevents):
    """Triggered when switching to another profile or when renaming the current profile.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'ProfileChanged'


class ProfileListChanged(Baseevents):
    """Triggered when a profile is created, added, renamed, or removed.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'ProfileListChanged'


class Heartbeat(Baseevents):
    """Emitted every 2 seconds after enabling it by calling SetHeartbeat.

    :Returns:
       *pulse*
            type: boolean
            Toggles between every JSON message as an "I am alive" indicator.
       *current_profile*
            type: string (optional)
            Current active profile.
       *current_scene*
            type: string (optional)
            Current active scene.
       *streaming*
            type: boolean (optional)
            Current streaming state.
       *total_stream_time*
            type: int (optional)
            Total time (in seconds) since the stream started.
       *total_stream_bytes*
            type: int (optional)
            Total bytes sent since the stream started.
       *total_stream_frames*
            type: int (optional)
            Total frames streamed since the stream started.
       *recording*
            type: boolean (optional)
            Current recording state.
       *total_record_time*
            type: int (optional)
            Total time (in seconds) since recording started.
       *total_record_bytes*
            type: int (optional)
            Total bytes recorded since the recording started.
       *total_record_frames*
            type: int (optional)
            Total frames recorded since the recording started.
       *stats*
            type: OBSStats
            OBS Stats
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'Heartbeat'
        self.datain['pulse'] = None
        self.datain['current-profile'] = None
        self.datain['current-scene'] = None
        self.datain['streaming'] = None
        self.datain['total-stream-time'] = None
        self.datain['total-stream-bytes'] = None
        self.datain['total-stream-frames'] = None
        self.datain['recording'] = None
        self.datain['total-record-time'] = None
        self.datain['total-record-bytes'] = None
        self.datain['total-record-frames'] = None
        self.datain['stats'] = None

    def getPulse(self):
        return self.datain['pulse']

    def getCurrentProfile(self):
        return self.datain['current-profile']

    def getCurrentScene(self):
        return self.datain['current-scene']

    def getStreaming(self):
        return self.datain['streaming']

    def getTotalStreamTime(self):
        return self.datain['total-stream-time']

    def getTotalStreamBytes(self):
        return self.datain['total-stream-bytes']

    def getTotalStreamFrames(self):
        return self.datain['total-stream-frames']

    def getRecording(self):
        return self.datain['recording']

    def getTotalRecordTime(self):
        return self.datain['total-record-time']

    def getTotalRecordBytes(self):
        return self.datain['total-record-bytes']

    def getTotalRecordFrames(self):
        return self.datain['total-record-frames']

    def getStats(self):
        return self.datain['stats']


class BroadcastCustomMessage(Baseevents):
    """A custom broadcast message was received

    :Returns:
       *realm*
            type: String
            Identifier provided by the sender
       *data*
            type: Object
            User-defined data
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'BroadcastCustomMessage'
        self.datain['realm'] = None
        self.datain['data'] = None

    def getRealm(self):
        return self.datain['realm']

    def getData(self):
        return self.datain['data']


class RecordingStarting(Baseevents):
    """A request to start recording has been issued.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'RecordingStarting'


class RecordingStarted(Baseevents):
    """Recording started successfully.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'RecordingStarted'


class RecordingStopping(Baseevents):
    """A request to stop recording has been issued.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'RecordingStopping'


class RecordingStopped(Baseevents):
    """Recording stopped successfully.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'RecordingStopped'


class RecordingPaused(Baseevents):
    """Current recording paused

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'RecordingPaused'


class RecordingResumed(Baseevents):
    """Current recording resumed

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'RecordingResumed'


class StreamStarting(Baseevents):
    """A request to start streaming has been issued.

    :Returns:
       *preview_only*
            type: boolean
            Always false (retrocompatibility).
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'StreamStarting'
        self.datain['preview-only'] = None

    def getPreviewOnly(self):
        return self.datain['preview-only']


class StreamStarted(Baseevents):
    """Streaming started successfully.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'StreamStarted'


class StreamStopping(Baseevents):
    """A request to stop streaming has been issued.

    :Returns:
       *preview_only*
            type: boolean
            Always false (retrocompatibility).
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'StreamStopping'
        self.datain['preview-only'] = None

    def getPreviewOnly(self):
        return self.datain['preview-only']


class StreamStopped(Baseevents):
    """Streaming stopped successfully.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'StreamStopped'


class StreamStatus(Baseevents):
    """Emit every 2 seconds.

    :Returns:
       *streaming*
            type: boolean
            Current streaming state.
       *recording*
            type: boolean
            Current recording state.
       *replay_buffer_active*
            type: boolean
            Replay Buffer status
       *bytes_per_sec*
            type: int
            Amount of data per second (in bytes) transmitted by the stream encoder.
       *kbits_per_sec*
            type: int
            Amount of data per second (in kilobits) transmitted by the stream encoder.
       *strain*
            type: double
            Percentage of dropped frames.
       *total_stream_time*
            type: int
            Total time (in seconds) since the stream started.
       *num_total_frames*
            type: int
            Total number of frames transmitted since the stream started.
       *num_dropped_frames*
            type: int
            Number of frames dropped by the encoder since the stream started.
       *fps*
            type: double
            Current framerate.
       *render_total_frames*
            type: int
            Number of frames rendered
       *render_missed_frames*
            type: int
            Number of frames missed due to rendering lag
       *output_total_frames*
            type: int
            Number of frames outputted
       *output_skipped_frames*
            type: int
            Number of frames skipped due to encoding lag
       *average_frame_time*
            type: double
            Average frame time (in milliseconds)
       *cpu_usage*
            type: double
            Current CPU usage (percentage)
       *memory_usage*
            type: double
            Current RAM usage (in megabytes)
       *free_disk_space*
            type: double
            Free recording disk space (in megabytes)
       *preview_only*
            type: boolean
            Always false (retrocompatibility).
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'StreamStatus'
        self.datain['streaming'] = None
        self.datain['recording'] = None
        self.datain['replay-buffer-active'] = None
        self.datain['bytes-per-sec'] = None
        self.datain['kbits-per-sec'] = None
        self.datain['strain'] = None
        self.datain['total-stream-time'] = None
        self.datain['num-total-frames'] = None
        self.datain['num-dropped-frames'] = None
        self.datain['fps'] = None
        self.datain['render-total-frames'] = None
        self.datain['render-missed-frames'] = None
        self.datain['output-total-frames'] = None
        self.datain['output-skipped-frames'] = None
        self.datain['average-frame-time'] = None
        self.datain['cpu-usage'] = None
        self.datain['memory-usage'] = None
        self.datain['free-disk-space'] = None
        self.datain['preview-only'] = None

    def getStreaming(self):
        return self.datain['streaming']

    def getRecording(self):
        return self.datain['recording']

    def getReplayBufferActive(self):
        return self.datain['replay-buffer-active']

    def getBytesPerSec(self):
        return self.datain['bytes-per-sec']

    def getKbitsPerSec(self):
        return self.datain['kbits-per-sec']

    def getStrain(self):
        return self.datain['strain']

    def getTotalStreamTime(self):
        return self.datain['total-stream-time']

    def getNumTotalFrames(self):
        return self.datain['num-total-frames']

    def getNumDroppedFrames(self):
        return self.datain['num-dropped-frames']

    def getFps(self):
        return self.datain['fps']

    def getRenderTotalFrames(self):
        return self.datain['render-total-frames']

    def getRenderMissedFrames(self):
        return self.datain['render-missed-frames']

    def getOutputTotalFrames(self):
        return self.datain['output-total-frames']

    def getOutputSkippedFrames(self):
        return self.datain['output-skipped-frames']

    def getAverageFrameTime(self):
        return self.datain['average-frame-time']

    def getCpuUsage(self):
        return self.datain['cpu-usage']

    def getMemoryUsage(self):
        return self.datain['memory-usage']

    def getFreeDiskSpace(self):
        return self.datain['free-disk-space']

    def getPreviewOnly(self):
        return self.datain['preview-only']


class Exiting(Baseevents):
    """OBS is exiting.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'Exiting'


class SwitchTransition(Baseevents):
    """The active transition has been changed.

    :Returns:
       *transition_name*
            type: String
            The name of the new active transition.
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'SwitchTransition'
        self.datain['transition-name'] = None

    def getTransitionName(self):
        return self.datain['transition-name']


class TransitionListChanged(Baseevents):
    """The list of available transitions has been modified.
Transitions have been added, removed, or renamed.

    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'TransitionListChanged'


class TransitionDurationChanged(Baseevents):
    """The active transition duration has been changed.

    :Returns:
       *new_duration*
            type: int
            New transition duration.
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'TransitionDurationChanged'
        self.datain['new-duration'] = None

    def getNewDuration(self):
        return self.datain['new-duration']


class TransitionBegin(Baseevents):
    """A transition (other than "cut") has begun.

    :Returns:
       *name*
            type: String
            Transition name.
       *duration*
            type: int
            Transition duration (in milliseconds).
       *from_scene*
            type: String
            Source scene of the transition
       *to_scene*
            type: String
            Destination scene of the transition
    """

    def __init__(self):
        Baseevents.__init__(self)
        self.name = 'TransitionBegin'
        self.datain['name'] = None
        self.datain['duration'] = None
        self.datain['from-scene'] = None
        self.datain['to-scene'] = None

    def getName(self):
        return self.datain['name']

    def getDuration(self):
        return self.datain['duration']

    def getFromScene(self):
        return self.datain['from-scene']

    def getToScene(self):
        return self.datain['to-scene']


