#!/usr/bin/env python
# -*- coding: utf-8 -*-

# THIS FILE WAS GENERATED BY generate_classes.py - DO NOT EDIT #
# (Generated on 2020-01-04 18:12:08.603284) #

from .base_classes import Baserequests


class GetStreamingStatus(Baserequests):
    """Get current streaming and recording status.

    :Returns:
       *streaming*
            type: boolean
            Current streaming status.
       *recording*
            type: boolean
            Current recording status.
       *stream_timecode*
            type: String (optional)
            Time elapsed since streaming started (only present if currently streaming).
       *rec_timecode*
            type: String (optional)
            Time elapsed since recording started (only present if currently recording).
       *preview_only*
            type: boolean
            Always false. Retrocompatibility with OBSRemote.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetStreamingStatus'
        self.datain['streaming'] = None
        self.datain['recording'] = None
        self.datain['stream-timecode'] = None
        self.datain['rec-timecode'] = None
        self.datain['preview-only'] = None

    def getStreaming(self):
        return self.datain['streaming']

    def getRecording(self):
        return self.datain['recording']

    def getStreamTimecode(self):
        return self.datain['stream-timecode']

    def getRecTimecode(self):
        return self.datain['rec-timecode']

    def getPreviewOnly(self):
        return self.datain['preview-only']


class StartStopStreaming(Baserequests):
    """Toggle streaming on or off.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'StartStopStreaming'


class StartStreaming(Baserequests):
    """Start streaming.
Will return an `error` if streaming is already active.

    :Arguments:
       *stream*
            type: Object (optional)
            Special stream configuration. Please note: these won't be saved to OBS' configuration.
       *stream_type*
            type: String (optional)
            If specified ensures the type of stream matches the given type (usually 'rtmp_custom' or 'rtmp_common'). If the currently configured stream type does not match the given stream type, all settings must be specified in the `settings` object or an error will occur when starting the stream.
       *stream_metadata*
            type: Object (optional)
            Adds the given object parameters as encoded query string parameters to the 'key' of the RTMP stream. Used to pass data to the RTMP service about the streaming. May be any String, Numeric, or Boolean field.
       *stream_settings*
            type: Object (optional)
            Settings for the stream.
       *stream_settings_server*
            type: String (optional)
            The publish URL.
       *stream_settings_key*
            type: String (optional)
            The publish key of the stream.
       *stream_settings_use_auth*
            type: boolean (optional)
            Indicates whether authentication should be used when connecting to the streaming server.
       *stream_settings_username*
            type: String (optional)
            If authentication is enabled, the username for the streaming server. Ignored if `use-auth` is not set to `true`.
       *stream_settings_password*
            type: String (optional)
            If authentication is enabled, the password for the streaming server. Ignored if `use-auth` is not set to `true`.
    """

    def __init__(self, stream=None, stream_type=None, stream_metadata=None, stream_settings=None, stream_settings_server=None, stream_settings_key=None, stream_settings_use_auth=None, stream_settings_username=None, stream_settings_password=None):
        Baserequests.__init__(self)
        self.name = 'StartStreaming'
        self.dataout['stream'] = stream
        self.dataout['stream.type'] = stream_type
        self.dataout['stream.metadata'] = stream_metadata
        self.dataout['stream.settings'] = stream_settings
        self.dataout['stream.settings.server'] = stream_settings_server
        self.dataout['stream.settings.key'] = stream_settings_key
        self.dataout['stream.settings.use-auth'] = stream_settings_use_auth
        self.dataout['stream.settings.username'] = stream_settings_username
        self.dataout['stream.settings.password'] = stream_settings_password


class StopStreaming(Baserequests):
    """Stop streaming.
Will return an `error` if streaming is not active.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'StopStreaming'


class SetStreamSettings(Baserequests):
    """Sets one or more attributes of the current streaming server settings. Any options not passed will remain unchanged. Returns the updated settings in response. If 'type' is different than the current streaming service type, all settings are required. Returns the full settings of the stream (the same as GetStreamSettings).

    :Arguments:
       *type*
            type: String
            The type of streaming service configuration, usually `rtmp_custom` or `rtmp_common`.
       *settings*
            type: Object
            The actual settings of the stream.
       *settings_server*
            type: String (optional)
            The publish URL.
       *settings_key*
            type: String (optional)
            The publish key.
       *settings_use_auth*
            type: boolean (optional)
            Indicates whether authentication should be used when connecting to the streaming server.
       *settings_username*
            type: String (optional)
            The username for the streaming service.
       *settings_password*
            type: String (optional)
            The password for the streaming service.
       *save*
            type: boolean
            Persist the settings to disk.
    """

    def __init__(self, type, settings, save, settings_server=None, settings_key=None, settings_use_auth=None, settings_username=None, settings_password=None):
        Baserequests.__init__(self)
        self.name = 'SetStreamSettings'
        self.dataout['type'] = type
        self.dataout['settings'] = settings
        self.dataout['save'] = save
        self.dataout['settings.server'] = settings_server
        self.dataout['settings.key'] = settings_key
        self.dataout['settings.use-auth'] = settings_use_auth
        self.dataout['settings.username'] = settings_username
        self.dataout['settings.password'] = settings_password


class GetStreamSettings(Baserequests):
    """Get the current streaming server settings.

    :Returns:
       *type*
            type: String
            The type of streaming service configuration. Possible values: 'rtmp_custom' or 'rtmp_common'.
       *settings*
            type: Object
            Stream settings object.
       *settings_server*
            type: String
            The publish URL.
       *settings_key*
            type: String
            The publish key of the stream.
       *settings_use_auth*
            type: boolean
            Indicates whether authentication should be used when connecting to the streaming server.
       *settings_username*
            type: String
            The username to use when accessing the streaming server. Only present if `use-auth` is `true`.
       *settings_password*
            type: String
            The password to use when accessing the streaming server. Only present if `use-auth` is `true`.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetStreamSettings'
        self.datain['type'] = None
        self.datain['settings'] = None
        self.datain['settings.server'] = None
        self.datain['settings.key'] = None
        self.datain['settings.use-auth'] = None
        self.datain['settings.username'] = None
        self.datain['settings.password'] = None

    def getType(self):
        return self.datain['type']

    def getSettings(self):
        return self.datain['settings']

    def getSettings_server(self):
        return self.datain['settings.server']

    def getSettings_key(self):
        return self.datain['settings.key']

    def getSettings_useAuth(self):
        return self.datain['settings.use-auth']

    def getSettings_username(self):
        return self.datain['settings.username']

    def getSettings_password(self):
        return self.datain['settings.password']


class SaveStreamSettings(Baserequests):
    """Save the current streaming server settings to disk.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'SaveStreamSettings'


class SendCaptions(Baserequests):
    """Send the provided text as embedded CEA-608 caption data.
As of OBS Studio 23.1, captions are not yet available on Linux.

    :Arguments:
       *text*
            type: String
            Captions text
    """

    def __init__(self, text):
        Baserequests.__init__(self)
        self.name = 'SendCaptions'
        self.dataout['text'] = text


class GetStudioModeStatus(Baserequests):
    """Indicates if Studio Mode is currently enabled.

    :Returns:
       *studio_mode*
            type: boolean
            Indicates if Studio Mode is enabled.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetStudioModeStatus'
        self.datain['studio-mode'] = None

    def getStudioMode(self):
        return self.datain['studio-mode']


class GetPreviewScene(Baserequests):
    """Get the name of the currently previewed scene and its list of sources.
Will return an `error` if Studio Mode is not enabled.

    :Returns:
       *name*
            type: String
            The name of the active preview scene.
       *sources*
            type: Array<SceneItem>
            
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetPreviewScene'
        self.datain['name'] = None
        self.datain['sources'] = None

    def getName(self):
        return self.datain['name']

    def getSources(self):
        return self.datain['sources']


class SetPreviewScene(Baserequests):
    """Set the active preview scene.
Will return an `error` if Studio Mode is not enabled.

    :Arguments:
       *scene_name*
            type: String
            The name of the scene to preview.
    """

    def __init__(self, scene_name):
        Baserequests.__init__(self)
        self.name = 'SetPreviewScene'
        self.dataout['scene-name'] = scene_name


class TransitionToProgram(Baserequests):
    """Transitions the currently previewed scene to the main output.
Will return an `error` if Studio Mode is not enabled.

    :Arguments:
       *with_transition*
            type: Object (optional)
            Change the active transition before switching scenes. Defaults to the active transition.
       *with_transition_name*
            type: String
            Name of the transition.
       *with_transition_duration*
            type: int (optional)
            Transition duration (in milliseconds).
    """

    def __init__(self, with_transition_name, with_transition=None, with_transition_duration=None):
        Baserequests.__init__(self)
        self.name = 'TransitionToProgram'
        self.dataout['with-transition.name'] = with_transition_name
        self.dataout['with-transition'] = with_transition
        self.dataout['with-transition.duration'] = with_transition_duration


class EnableStudioMode(Baserequests):
    """Enables Studio Mode.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'EnableStudioMode'


class DisableStudioMode(Baserequests):
    """Disables Studio Mode.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'DisableStudioMode'


class ToggleStudioMode(Baserequests):
    """Toggles Studio Mode.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'ToggleStudioMode'


class ListOutputs(Baserequests):
    """List existing outputs

    :Returns:
       *outputs*
            type: Array<Output>
            Outputs list
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'ListOutputs'
        self.datain['outputs'] = None

    def getOutputs(self):
        return self.datain['outputs']


class GetOutputInfo(Baserequests):
    """Get information about a single output

    :Arguments:
       *outputName*
            type: String
            Output name
    :Returns:
       *outputInfo*
            type: Output
            Output info
    """

    def __init__(self, outputName):
        Baserequests.__init__(self)
        self.name = 'GetOutputInfo'
        self.datain['outputInfo'] = None
        self.dataout['outputName'] = outputName

    def getOutputinfo(self):
        return self.datain['outputInfo']


class StartOutput(Baserequests):
    """Start an output

    :Arguments:
       *outputName*
            type: String
            Output name
    """

    def __init__(self, outputName):
        Baserequests.__init__(self)
        self.name = 'StartOutput'
        self.dataout['outputName'] = outputName


class StopOutput(Baserequests):
    """Stop an output

    :Arguments:
       *outputName*
            type: String
            Output name
       *force*
            type: boolean (optional)
            Force stop (default: false)
    """

    def __init__(self, outputName, force=None):
        Baserequests.__init__(self)
        self.name = 'StopOutput'
        self.dataout['outputName'] = outputName
        self.dataout['force'] = force


class StartStopReplayBuffer(Baserequests):
    """Toggle the Replay Buffer on/off.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'StartStopReplayBuffer'


class StartReplayBuffer(Baserequests):
    """Start recording into the Replay Buffer.
Will return an `error` if the Replay Buffer is already active or if the
"Save Replay Buffer" hotkey is not set in OBS' settings.
Setting this hotkey is mandatory, even when triggering saves only
through obs-websocket.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'StartReplayBuffer'


class StopReplayBuffer(Baserequests):
    """Stop recording into the Replay Buffer.
Will return an `error` if the Replay Buffer is not active.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'StopReplayBuffer'


class SaveReplayBuffer(Baserequests):
    """Flush and save the contents of the Replay Buffer to disk. This is
basically the same as triggering the "Save Replay Buffer" hotkey.
Will return an `error` if the Replay Buffer is not active.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'SaveReplayBuffer'


class SetCurrentScene(Baserequests):
    """Switch to the specified scene.

    :Arguments:
       *scene_name*
            type: String
            Name of the scene to switch to.
    """

    def __init__(self, scene_name):
        Baserequests.__init__(self)
        self.name = 'SetCurrentScene'
        self.dataout['scene-name'] = scene_name


class GetCurrentScene(Baserequests):
    """Get the current scene's name and source items.

    :Returns:
       *name*
            type: String
            Name of the currently active scene.
       *sources*
            type: Array<SceneItem>
            Ordered list of the current scene's source items.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetCurrentScene'
        self.datain['name'] = None
        self.datain['sources'] = None

    def getName(self):
        return self.datain['name']

    def getSources(self):
        return self.datain['sources']


class GetSceneList(Baserequests):
    """Get a list of scenes in the currently active profile.

    :Returns:
       *current_scene*
            type: String
            Name of the currently active scene.
       *scenes*
            type: Array<Scene>
            Ordered list of the current profile's scenes (See `[GetCurrentScene](#getcurrentscene)` for more information).
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetSceneList'
        self.datain['current-scene'] = None
        self.datain['scenes'] = None

    def getCurrentScene(self):
        return self.datain['current-scene']

    def getScenes(self):
        return self.datain['scenes']


class ReorderSceneItems(Baserequests):
    """Changes the order of scene items in the requested scene.

    :Arguments:
       *scene*
            type: String (optional)
            Name of the scene to reorder (defaults to current).
       *items*
            type: Array<Scene>
            Ordered list of objects with name and/or id specified. Id preferred due to uniqueness per scene
       *items_id*
            type: int (optional)
            Id of a specific scene item. Unique on a scene by scene basis.
       *items_name*
            type: String (optional)
            Name of a scene item. Sufficiently unique if no scene items share sources within the scene.
    """

    def __init__(self, items, scene=None, items_id=None, items_name=None):
        Baserequests.__init__(self)
        self.name = 'ReorderSceneItems'
        self.dataout['items'] = items
        self.dataout['scene'] = scene
        self.dataout['items[].id'] = items_id
        self.dataout['items[].name'] = items_name


class SetCurrentProfile(Baserequests):
    """Set the currently active profile.

    :Arguments:
       *profile_name*
            type: String
            Name of the desired profile.
    """

    def __init__(self, profile_name):
        Baserequests.__init__(self)
        self.name = 'SetCurrentProfile'
        self.dataout['profile-name'] = profile_name


class GetCurrentProfile(Baserequests):
    """Get the name of the current profile.

    :Returns:
       *profile_name*
            type: String
            Name of the currently active profile.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetCurrentProfile'
        self.datain['profile-name'] = None

    def getProfileName(self):
        return self.datain['profile-name']


class ListProfiles(Baserequests):
    """Get a list of available profiles.

    :Returns:
       *profiles*
            type: Array<Object>
            List of available profiles.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'ListProfiles'
        self.datain['profiles'] = None

    def getProfiles(self):
        return self.datain['profiles']


class GetVersion(Baserequests):
    """Returns the latest version of the plugin and the API.

    :Returns:
       *version*
            type: double
            OBSRemote compatible API version. Fixed to 1.1 for retrocompatibility.
       *obs_websocket_version*
            type: String
            obs-websocket plugin version.
       *obs_studio_version*
            type: String
            OBS Studio program version.
       *available_requests*
            type: String
            List of available request types, formatted as a comma-separated list string (e.g. : "Method1,Method2,Method3").
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetVersion'
        self.datain['version'] = None
        self.datain['obs-websocket-version'] = None
        self.datain['obs-studio-version'] = None
        self.datain['available-requests'] = None

    def getVersion(self):
        return self.datain['version']

    def getObsWebsocketVersion(self):
        return self.datain['obs-websocket-version']

    def getObsStudioVersion(self):
        return self.datain['obs-studio-version']

    def getAvailableRequests(self):
        return self.datain['available-requests']


class GetAuthRequired(Baserequests):
    """Tells the client if authentication is required. If so, returns authentication parameters `challenge`
and `salt` (see "Authentication" for more information).

    :Returns:
       *authRequired*
            type: boolean
            Indicates whether authentication is required.
       *challenge*
            type: String (optional)
            
       *salt*
            type: String (optional)
            
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetAuthRequired'
        self.datain['authRequired'] = None
        self.datain['challenge'] = None
        self.datain['salt'] = None

    def getAuthrequired(self):
        return self.datain['authRequired']

    def getChallenge(self):
        return self.datain['challenge']

    def getSalt(self):
        return self.datain['salt']


class Authenticate(Baserequests):
    """Attempt to authenticate the client to the server.

    :Arguments:
       *auth*
            type: String
            Response to the auth challenge (see "Authentication" for more information).
    """

    def __init__(self, auth):
        Baserequests.__init__(self)
        self.name = 'Authenticate'
        self.dataout['auth'] = auth


class SetHeartbeat(Baserequests):
    """Enable/disable sending of the Heartbeat event

    :Arguments:
       *enable*
            type: boolean
            Starts/Stops emitting heartbeat messages
    """

    def __init__(self, enable):
        Baserequests.__init__(self)
        self.name = 'SetHeartbeat'
        self.dataout['enable'] = enable


class SetFilenameFormatting(Baserequests):
    """Set the filename formatting string

    :Arguments:
       *filename_formatting*
            type: String
            Filename formatting string to set.
    """

    def __init__(self, filename_formatting):
        Baserequests.__init__(self)
        self.name = 'SetFilenameFormatting'
        self.dataout['filename-formatting'] = filename_formatting


class GetFilenameFormatting(Baserequests):
    """Get the filename formatting string

    :Returns:
       *filename_formatting*
            type: String
            Current filename formatting string.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetFilenameFormatting'
        self.datain['filename-formatting'] = None

    def getFilenameFormatting(self):
        return self.datain['filename-formatting']


class GetStats(Baserequests):
    """Get OBS stats (almost the same info as provided in OBS' stats window)

    :Returns:
       *stats*
            type: OBSStats
            OBS stats
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetStats'
        self.datain['stats'] = None

    def getStats(self):
        return self.datain['stats']


class BroadcastCustomMessage(Baserequests):
    """Broadcast custom message to all connected WebSocket clients

    :Arguments:
       *realm*
            type: String
            Identifier to be choosen by the client
       *data*
            type: Object
            User-defined data
    """

    def __init__(self, realm, data):
        Baserequests.__init__(self)
        self.name = 'BroadcastCustomMessage'
        self.dataout['realm'] = realm
        self.dataout['data'] = data


class GetVideoInfo(Baserequests):
    """Get basic OBS video information

    :Returns:
       *baseWidth*
            type: int
            Base (canvas) width
       *baseHeight*
            type: int
            Base (canvas) height
       *outputWidth*
            type: int
            Output width
       *outputHeight*
            type: int
            Output height
       *scaleType*
            type: String
            Scaling method used if output size differs from base size
       *fps*
            type: double
            Frames rendered per second
       *videoFormat*
            type: String
            Video color format
       *colorSpace*
            type: String
            Color space for YUV
       *colorRange*
            type: String
            Color range (full or partial)
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetVideoInfo'
        self.datain['baseWidth'] = None
        self.datain['baseHeight'] = None
        self.datain['outputWidth'] = None
        self.datain['outputHeight'] = None
        self.datain['scaleType'] = None
        self.datain['fps'] = None
        self.datain['videoFormat'] = None
        self.datain['colorSpace'] = None
        self.datain['colorRange'] = None

    def getBasewidth(self):
        return self.datain['baseWidth']

    def getBaseheight(self):
        return self.datain['baseHeight']

    def getOutputwidth(self):
        return self.datain['outputWidth']

    def getOutputheight(self):
        return self.datain['outputHeight']

    def getScaletype(self):
        return self.datain['scaleType']

    def getFps(self):
        return self.datain['fps']

    def getVideoformat(self):
        return self.datain['videoFormat']

    def getColorspace(self):
        return self.datain['colorSpace']

    def getColorrange(self):
        return self.datain['colorRange']


class StartStopRecording(Baserequests):
    """Toggle recording on or off.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'StartStopRecording'


class StartRecording(Baserequests):
    """Start recording.
Will return an `error` if recording is already active.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'StartRecording'


class StopRecording(Baserequests):
    """Stop recording.
Will return an `error` if recording is not active.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'StopRecording'


class PauseRecording(Baserequests):
    """Pause the current recording.
Returns an error if recording is not active or already paused.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'PauseRecording'


class ResumeRecording(Baserequests):
    """Resume/unpause the current recording (if paused).
Returns an error if recording is not active or not paused.

    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'ResumeRecording'


class SetRecordingFolder(Baserequests):
    """

Please note: if `SetRecordingFolder` is called while a recording is
in progress, the change won't be applied immediately and will be
effective on the next recording.

    :Arguments:
       *rec_folder*
            type: String
            Path of the recording folder.
    """

    def __init__(self, rec_folder):
        Baserequests.__init__(self)
        self.name = 'SetRecordingFolder'
        self.dataout['rec-folder'] = rec_folder


class GetRecordingFolder(Baserequests):
    """Get the path of  the current recording folder.

    :Returns:
       *rec_folder*
            type: String
            Path of the recording folder.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetRecordingFolder'
        self.datain['rec-folder'] = None

    def getRecFolder(self):
        return self.datain['rec-folder']


class GetSourcesList(Baserequests):
    """List all sources available in the running OBS instance

    :Returns:
       *sources*
            type: Array<Object>
            Array of sources
       *sources___name*
            type: String
            Unique source name
       *sources___typeId*
            type: String
            Non-unique source internal type (a.k.a type id)
       *sources___type*
            type: String
            Source type. Value is one of the following: "input", "filter", "transition", "scene" or "unknown"
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetSourcesList'
        self.datain['sources'] = None
        self.datain['sources.*.name'] = None
        self.datain['sources.*.typeId'] = None
        self.datain['sources.*.type'] = None

    def getSources(self):
        return self.datain['sources']

    def getSources___name(self):
        return self.datain['sources.*.name']

    def getSources___typeid(self):
        return self.datain['sources.*.typeId']

    def getSources___type(self):
        return self.datain['sources.*.type']


class GetSourceTypesList(Baserequests):
    """Get a list of all available sources types

    :Returns:
       *types*
            type: Array<Object>
            Array of source types
       *types___typeId*
            type: String
            Non-unique internal source type ID
       *types___displayName*
            type: String
            Display name of the source type
       *types___type*
            type: String
            Type. Value is one of the following: "input", "filter", "transition" or "other"
       *types___defaultSettings*
            type: Object
            Default settings of this source type
       *types___caps*
            type: Object
            Source type capabilities
       *types___caps_isAsync*
            type: Boolean
            True if source of this type provide frames asynchronously
       *types___caps_hasVideo*
            type: Boolean
            True if sources of this type provide video
       *types___caps_hasAudio*
            type: Boolean
            True if sources of this type provide audio
       *types___caps_canInteract*
            type: Boolean
            True if interaction with this sources of this type is possible
       *types___caps_isComposite*
            type: Boolean
            True if sources of this type composite one or more sub-sources
       *types___caps_doNotDuplicate*
            type: Boolean
            True if sources of this type should not be fully duplicated
       *types___caps_doNotSelfMonitor*
            type: Boolean
            True if sources of this type may cause a feedback loop if it's audio is monitored and shouldn't be
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetSourceTypesList'
        self.datain['types'] = None
        self.datain['types.*.typeId'] = None
        self.datain['types.*.displayName'] = None
        self.datain['types.*.type'] = None
        self.datain['types.*.defaultSettings'] = None
        self.datain['types.*.caps'] = None
        self.datain['types.*.caps.isAsync'] = None
        self.datain['types.*.caps.hasVideo'] = None
        self.datain['types.*.caps.hasAudio'] = None
        self.datain['types.*.caps.canInteract'] = None
        self.datain['types.*.caps.isComposite'] = None
        self.datain['types.*.caps.doNotDuplicate'] = None
        self.datain['types.*.caps.doNotSelfMonitor'] = None

    def getTypes(self):
        return self.datain['types']

    def getTypes___typeid(self):
        return self.datain['types.*.typeId']

    def getTypes___displayname(self):
        return self.datain['types.*.displayName']

    def getTypes___type(self):
        return self.datain['types.*.type']

    def getTypes___defaultsettings(self):
        return self.datain['types.*.defaultSettings']

    def getTypes___caps(self):
        return self.datain['types.*.caps']

    def getTypes___caps_isasync(self):
        return self.datain['types.*.caps.isAsync']

    def getTypes___caps_hasvideo(self):
        return self.datain['types.*.caps.hasVideo']

    def getTypes___caps_hasaudio(self):
        return self.datain['types.*.caps.hasAudio']

    def getTypes___caps_caninteract(self):
        return self.datain['types.*.caps.canInteract']

    def getTypes___caps_iscomposite(self):
        return self.datain['types.*.caps.isComposite']

    def getTypes___caps_donotduplicate(self):
        return self.datain['types.*.caps.doNotDuplicate']

    def getTypes___caps_donotselfmonitor(self):
        return self.datain['types.*.caps.doNotSelfMonitor']


class GetVolume(Baserequests):
    """Get the volume of the specified source.

    :Arguments:
       *source*
            type: String
            Source name.
    :Returns:
       *name*
            type: String
            Source name.
       *volume*
            type: double
            Volume of the source. Between `0.0` and `1.0`.
       *muted*
            type: boolean
            Indicates whether the source is muted.
    """

    def __init__(self, source):
        Baserequests.__init__(self)
        self.name = 'GetVolume'
        self.datain['name'] = None
        self.datain['volume'] = None
        self.datain['muted'] = None
        self.dataout['source'] = source

    def getName(self):
        return self.datain['name']

    def getVolume(self):
        return self.datain['volume']

    def getMuted(self):
        return self.datain['muted']


class SetVolume(Baserequests):
    """Set the volume of the specified source.

    :Arguments:
       *source*
            type: String
            Source name.
       *volume*
            type: double
            Desired volume. Must be between `0.0` and `1.0`.
    """

    def __init__(self, source, volume):
        Baserequests.__init__(self)
        self.name = 'SetVolume'
        self.dataout['source'] = source
        self.dataout['volume'] = volume


class GetMute(Baserequests):
    """Get the mute status of a specified source.

    :Arguments:
       *source*
            type: String
            Source name.
    :Returns:
       *name*
            type: String
            Source name.
       *muted*
            type: boolean
            Mute status of the source.
    """

    def __init__(self, source):
        Baserequests.__init__(self)
        self.name = 'GetMute'
        self.datain['name'] = None
        self.datain['muted'] = None
        self.dataout['source'] = source

    def getName(self):
        return self.datain['name']

    def getMuted(self):
        return self.datain['muted']


class SetMute(Baserequests):
    """Sets the mute status of a specified source.

    :Arguments:
       *source*
            type: String
            Source name.
       *mute*
            type: boolean
            Desired mute status.
    """

    def __init__(self, source, mute):
        Baserequests.__init__(self)
        self.name = 'SetMute'
        self.dataout['source'] = source
        self.dataout['mute'] = mute


class ToggleMute(Baserequests):
    """Inverts the mute status of a specified source.

    :Arguments:
       *source*
            type: String
            Source name.
    """

    def __init__(self, source):
        Baserequests.__init__(self)
        self.name = 'ToggleMute'
        self.dataout['source'] = source


class SetSyncOffset(Baserequests):
    """Set the audio sync offset of a specified source.

    :Arguments:
       *source*
            type: String
            Source name.
       *offset*
            type: int
            The desired audio sync offset (in nanoseconds).
    """

    def __init__(self, source, offset):
        Baserequests.__init__(self)
        self.name = 'SetSyncOffset'
        self.dataout['source'] = source
        self.dataout['offset'] = offset


class GetSyncOffset(Baserequests):
    """Get the audio sync offset of a specified source.

    :Arguments:
       *source*
            type: String
            Source name.
    :Returns:
       *name*
            type: String
            Source name.
       *offset*
            type: int
            The audio sync offset (in nanoseconds).
    """

    def __init__(self, source):
        Baserequests.__init__(self)
        self.name = 'GetSyncOffset'
        self.datain['name'] = None
        self.datain['offset'] = None
        self.dataout['source'] = source

    def getName(self):
        return self.datain['name']

    def getOffset(self):
        return self.datain['offset']


class GetSourceSettings(Baserequests):
    """Get settings of the specified source

    :Arguments:
       *sourceName*
            type: String
            Source name.
       *sourceType*
            type: String (optional)
            Type of the specified source. Useful for type-checking if you expect a specific settings schema.
    :Returns:
       *sourceName*
            type: String
            Source name
       *sourceType*
            type: String
            Type of the specified source
       *sourceSettings*
            type: Object
            Source settings (varies between source types, may require some probing around).
    """

    def __init__(self, sourceName, sourceType=None):
        Baserequests.__init__(self)
        self.name = 'GetSourceSettings'
        self.datain['sourceName'] = None
        self.datain['sourceType'] = None
        self.datain['sourceSettings'] = None
        self.dataout['sourceName'] = sourceName
        self.dataout['sourceType'] = sourceType

    def getSourcename(self):
        return self.datain['sourceName']

    def getSourcetype(self):
        return self.datain['sourceType']

    def getSourcesettings(self):
        return self.datain['sourceSettings']


class SetSourceSettings(Baserequests):
    """Set settings of the specified source.

    :Arguments:
       *sourceName*
            type: String
            Source name.
       *sourceType*
            type: String (optional)
            Type of the specified source. Useful for type-checking to avoid settings a set of settings incompatible with the actual source's type.
       *sourceSettings*
            type: Object
            Source settings (varies between source types, may require some probing around).
    :Returns:
       *sourceName*
            type: String
            Source name
       *sourceType*
            type: String
            Type of the specified source
       *sourceSettings*
            type: Object
            Updated source settings
    """

    def __init__(self, sourceName, sourceSettings, sourceType=None):
        Baserequests.__init__(self)
        self.name = 'SetSourceSettings'
        self.datain['sourceName'] = None
        self.datain['sourceType'] = None
        self.datain['sourceSettings'] = None
        self.dataout['sourceName'] = sourceName
        self.dataout['sourceSettings'] = sourceSettings
        self.dataout['sourceType'] = sourceType

    def getSourcename(self):
        return self.datain['sourceName']

    def getSourcetype(self):
        return self.datain['sourceType']

    def getSourcesettings(self):
        return self.datain['sourceSettings']


class GetTextGDIPlusProperties(Baserequests):
    """Get the current properties of a Text GDI Plus source.

    :Arguments:
       *source*
            type: String
            Source name.
    :Returns:
       *source*
            type: String
            Source name.
       *align*
            type: String
            Text Alignment ("left", "center", "right").
       *bk_color*
            type: int
            Background color.
       *bk_opacity*
            type: int
            Background opacity (0-100).
       *chatlog*
            type: boolean
            Chat log.
       *chatlog_lines*
            type: int
            Chat log lines.
       *color*
            type: int
            Text color.
       *extents*
            type: boolean
            Extents wrap.
       *extents_cx*
            type: int
            Extents cx.
       *extents_cy*
            type: int
            Extents cy.
       *file*
            type: String
            File path name.
       *read_from_file*
            type: boolean
            Read text from the specified file.
       *font*
            type: Object
            Holds data for the font. Ex: `"font": { "face": "Arial", "flags": 0, "size": 150, "style": "" }`
       *font_face*
            type: String
            Font face.
       *font_flags*
            type: int
            Font text styling flag. `Bold=1, Italic=2, Bold Italic=3, Underline=5, Strikeout=8`
       *font_size*
            type: int
            Font text size.
       *font_style*
            type: String
            Font Style (unknown function).
       *gradient*
            type: boolean
            Gradient enabled.
       *gradient_color*
            type: int
            Gradient color.
       *gradient_dir*
            type: float
            Gradient direction.
       *gradient_opacity*
            type: int
            Gradient opacity (0-100).
       *outline*
            type: boolean
            Outline.
       *outline_color*
            type: int
            Outline color.
       *outline_size*
            type: int
            Outline size.
       *outline_opacity*
            type: int
            Outline opacity (0-100).
       *text*
            type: String
            Text content to be displayed.
       *valign*
            type: String
            Text vertical alignment ("top", "center", "bottom").
       *vertical*
            type: boolean
            Vertical text enabled.
    """

    def __init__(self, source):
        Baserequests.__init__(self)
        self.name = 'GetTextGDIPlusProperties'
        self.datain['source'] = None
        self.datain['align'] = None
        self.datain['bk-color'] = None
        self.datain['bk-opacity'] = None
        self.datain['chatlog'] = None
        self.datain['chatlog_lines'] = None
        self.datain['color'] = None
        self.datain['extents'] = None
        self.datain['extents_cx'] = None
        self.datain['extents_cy'] = None
        self.datain['file'] = None
        self.datain['read_from_file'] = None
        self.datain['font'] = None
        self.datain['font.face'] = None
        self.datain['font.flags'] = None
        self.datain['font.size'] = None
        self.datain['font.style'] = None
        self.datain['gradient'] = None
        self.datain['gradient_color'] = None
        self.datain['gradient_dir'] = None
        self.datain['gradient_opacity'] = None
        self.datain['outline'] = None
        self.datain['outline_color'] = None
        self.datain['outline_size'] = None
        self.datain['outline_opacity'] = None
        self.datain['text'] = None
        self.datain['valign'] = None
        self.datain['vertical'] = None
        self.dataout['source'] = source

    def getSource(self):
        return self.datain['source']

    def getAlign(self):
        return self.datain['align']

    def getBkColor(self):
        return self.datain['bk-color']

    def getBkOpacity(self):
        return self.datain['bk-opacity']

    def getChatlog(self):
        return self.datain['chatlog']

    def getChatlog_lines(self):
        return self.datain['chatlog_lines']

    def getColor(self):
        return self.datain['color']

    def getExtents(self):
        return self.datain['extents']

    def getExtents_cx(self):
        return self.datain['extents_cx']

    def getExtents_cy(self):
        return self.datain['extents_cy']

    def getFile(self):
        return self.datain['file']

    def getRead_from_file(self):
        return self.datain['read_from_file']

    def getFont(self):
        return self.datain['font']

    def getFont_face(self):
        return self.datain['font.face']

    def getFont_flags(self):
        return self.datain['font.flags']

    def getFont_size(self):
        return self.datain['font.size']

    def getFont_style(self):
        return self.datain['font.style']

    def getGradient(self):
        return self.datain['gradient']

    def getGradient_color(self):
        return self.datain['gradient_color']

    def getGradient_dir(self):
        return self.datain['gradient_dir']

    def getGradient_opacity(self):
        return self.datain['gradient_opacity']

    def getOutline(self):
        return self.datain['outline']

    def getOutline_color(self):
        return self.datain['outline_color']

    def getOutline_size(self):
        return self.datain['outline_size']

    def getOutline_opacity(self):
        return self.datain['outline_opacity']

    def getText(self):
        return self.datain['text']

    def getValign(self):
        return self.datain['valign']

    def getVertical(self):
        return self.datain['vertical']


class SetTextGDIPlusProperties(Baserequests):
    """Set the current properties of a Text GDI Plus source.

    :Arguments:
       *source*
            type: String
            Name of the source.
       *align*
            type: String (optional)
            Text Alignment ("left", "center", "right").
       *bk_color*
            type: int (optional)
            Background color.
       *bk_opacity*
            type: int (optional)
            Background opacity (0-100).
       *chatlog*
            type: boolean (optional)
            Chat log.
       *chatlog_lines*
            type: int (optional)
            Chat log lines.
       *color*
            type: int (optional)
            Text color.
       *extents*
            type: boolean (optional)
            Extents wrap.
       *extents_cx*
            type: int (optional)
            Extents cx.
       *extents_cy*
            type: int (optional)
            Extents cy.
       *file*
            type: String (optional)
            File path name.
       *read_from_file*
            type: boolean (optional)
            Read text from the specified file.
       *font*
            type: Object (optional)
            Holds data for the font. Ex: `"font": { "face": "Arial", "flags": 0, "size": 150, "style": "" }`
       *font_face*
            type: String (optional)
            Font face.
       *font_flags*
            type: int (optional)
            Font text styling flag. `Bold=1, Italic=2, Bold Italic=3, Underline=5, Strikeout=8`
       *font_size*
            type: int (optional)
            Font text size.
       *font_style*
            type: String (optional)
            Font Style (unknown function).
       *gradient*
            type: boolean (optional)
            Gradient enabled.
       *gradient_color*
            type: int (optional)
            Gradient color.
       *gradient_dir*
            type: float (optional)
            Gradient direction.
       *gradient_opacity*
            type: int (optional)
            Gradient opacity (0-100).
       *outline*
            type: boolean (optional)
            Outline.
       *outline_color*
            type: int (optional)
            Outline color.
       *outline_size*
            type: int (optional)
            Outline size.
       *outline_opacity*
            type: int (optional)
            Outline opacity (0-100).
       *text*
            type: String (optional)
            Text content to be displayed.
       *valign*
            type: String (optional)
            Text vertical alignment ("top", "center", "bottom").
       *vertical*
            type: boolean (optional)
            Vertical text enabled.
       *render*
            type: boolean (optional)
            Visibility of the scene item.
    """

    def __init__(self, source, align=None, bk_color=None, bk_opacity=None, chatlog=None, chatlog_lines=None, color=None, extents=None, extents_cx=None, extents_cy=None, file=None, read_from_file=None, font=None, font_face=None, font_flags=None, font_size=None, font_style=None, gradient=None, gradient_color=None, gradient_dir=None, gradient_opacity=None, outline=None, outline_color=None, outline_size=None, outline_opacity=None, text=None, valign=None, vertical=None, render=None):
        Baserequests.__init__(self)
        self.name = 'SetTextGDIPlusProperties'
        self.dataout['source'] = source
        self.dataout['align'] = align
        self.dataout['bk-color'] = bk_color
        self.dataout['bk-opacity'] = bk_opacity
        self.dataout['chatlog'] = chatlog
        self.dataout['chatlog_lines'] = chatlog_lines
        self.dataout['color'] = color
        self.dataout['extents'] = extents
        self.dataout['extents_cx'] = extents_cx
        self.dataout['extents_cy'] = extents_cy
        self.dataout['file'] = file
        self.dataout['read_from_file'] = read_from_file
        self.dataout['font'] = font
        self.dataout['font.face'] = font_face
        self.dataout['font.flags'] = font_flags
        self.dataout['font.size'] = font_size
        self.dataout['font.style'] = font_style
        self.dataout['gradient'] = gradient
        self.dataout['gradient_color'] = gradient_color
        self.dataout['gradient_dir'] = gradient_dir
        self.dataout['gradient_opacity'] = gradient_opacity
        self.dataout['outline'] = outline
        self.dataout['outline_color'] = outline_color
        self.dataout['outline_size'] = outline_size
        self.dataout['outline_opacity'] = outline_opacity
        self.dataout['text'] = text
        self.dataout['valign'] = valign
        self.dataout['vertical'] = vertical
        self.dataout['render'] = render


class GetTextFreetype2Properties(Baserequests):
    """Get the current properties of a Text Freetype 2 source.

    :Arguments:
       *source*
            type: String
            Source name.
    :Returns:
       *source*
            type: String
            Source name
       *color1*
            type: int
            Gradient top color.
       *color2*
            type: int
            Gradient bottom color.
       *custom_width*
            type: int
            Custom width (0 to disable).
       *drop_shadow*
            type: boolean
            Drop shadow.
       *font*
            type: Object
            Holds data for the font. Ex: `"font": { "face": "Arial", "flags": 0, "size": 150, "style": "" }`
       *font_face*
            type: String
            Font face.
       *font_flags*
            type: int
            Font text styling flag. `Bold=1, Italic=2, Bold Italic=3, Underline=5, Strikeout=8`
       *font_size*
            type: int
            Font text size.
       *font_style*
            type: String
            Font Style (unknown function).
       *from_file*
            type: boolean
            Read text from the specified file.
       *log_mode*
            type: boolean
            Chat log.
       *outline*
            type: boolean
            Outline.
       *text*
            type: String
            Text content to be displayed.
       *text_file*
            type: String
            File path.
       *word_wrap*
            type: boolean
            Word wrap.
    """

    def __init__(self, source):
        Baserequests.__init__(self)
        self.name = 'GetTextFreetype2Properties'
        self.datain['source'] = None
        self.datain['color1'] = None
        self.datain['color2'] = None
        self.datain['custom_width'] = None
        self.datain['drop_shadow'] = None
        self.datain['font'] = None
        self.datain['font.face'] = None
        self.datain['font.flags'] = None
        self.datain['font.size'] = None
        self.datain['font.style'] = None
        self.datain['from_file'] = None
        self.datain['log_mode'] = None
        self.datain['outline'] = None
        self.datain['text'] = None
        self.datain['text_file'] = None
        self.datain['word_wrap'] = None
        self.dataout['source'] = source

    def getSource(self):
        return self.datain['source']

    def getColor1(self):
        return self.datain['color1']

    def getColor2(self):
        return self.datain['color2']

    def getCustom_width(self):
        return self.datain['custom_width']

    def getDrop_shadow(self):
        return self.datain['drop_shadow']

    def getFont(self):
        return self.datain['font']

    def getFont_face(self):
        return self.datain['font.face']

    def getFont_flags(self):
        return self.datain['font.flags']

    def getFont_size(self):
        return self.datain['font.size']

    def getFont_style(self):
        return self.datain['font.style']

    def getFrom_file(self):
        return self.datain['from_file']

    def getLog_mode(self):
        return self.datain['log_mode']

    def getOutline(self):
        return self.datain['outline']

    def getText(self):
        return self.datain['text']

    def getText_file(self):
        return self.datain['text_file']

    def getWord_wrap(self):
        return self.datain['word_wrap']


class SetTextFreetype2Properties(Baserequests):
    """Set the current properties of a Text Freetype 2 source.

    :Arguments:
       *source*
            type: String
            Source name.
       *color1*
            type: int (optional)
            Gradient top color.
       *color2*
            type: int (optional)
            Gradient bottom color.
       *custom_width*
            type: int (optional)
            Custom width (0 to disable).
       *drop_shadow*
            type: boolean (optional)
            Drop shadow.
       *font*
            type: Object (optional)
            Holds data for the font. Ex: `"font": { "face": "Arial", "flags": 0, "size": 150, "style": "" }`
       *font_face*
            type: String (optional)
            Font face.
       *font_flags*
            type: int (optional)
            Font text styling flag. `Bold=1, Italic=2, Bold Italic=3, Underline=5, Strikeout=8`
       *font_size*
            type: int (optional)
            Font text size.
       *font_style*
            type: String (optional)
            Font Style (unknown function).
       *from_file*
            type: boolean (optional)
            Read text from the specified file.
       *log_mode*
            type: boolean (optional)
            Chat log.
       *outline*
            type: boolean (optional)
            Outline.
       *text*
            type: String (optional)
            Text content to be displayed.
       *text_file*
            type: String (optional)
            File path.
       *word_wrap*
            type: boolean (optional)
            Word wrap.
    """

    def __init__(self, source, color1=None, color2=None, custom_width=None, drop_shadow=None, font=None, font_face=None, font_flags=None, font_size=None, font_style=None, from_file=None, log_mode=None, outline=None, text=None, text_file=None, word_wrap=None):
        Baserequests.__init__(self)
        self.name = 'SetTextFreetype2Properties'
        self.dataout['source'] = source
        self.dataout['color1'] = color1
        self.dataout['color2'] = color2
        self.dataout['custom_width'] = custom_width
        self.dataout['drop_shadow'] = drop_shadow
        self.dataout['font'] = font
        self.dataout['font.face'] = font_face
        self.dataout['font.flags'] = font_flags
        self.dataout['font.size'] = font_size
        self.dataout['font.style'] = font_style
        self.dataout['from_file'] = from_file
        self.dataout['log_mode'] = log_mode
        self.dataout['outline'] = outline
        self.dataout['text'] = text
        self.dataout['text_file'] = text_file
        self.dataout['word_wrap'] = word_wrap


class GetBrowserSourceProperties(Baserequests):
    """Get current properties for a Browser Source.

    :Arguments:
       *source*
            type: String
            Source name.
    :Returns:
       *source*
            type: String
            Source name.
       *is_local_file*
            type: boolean
            Indicates that a local file is in use.
       *local_file*
            type: String
            file path.
       *url*
            type: String
            Url.
       *css*
            type: String
            CSS to inject.
       *width*
            type: int
            Width.
       *height*
            type: int
            Height.
       *fps*
            type: int
            Framerate.
       *shutdown*
            type: boolean
            Indicates whether the source should be shutdown when not visible.
    """

    def __init__(self, source):
        Baserequests.__init__(self)
        self.name = 'GetBrowserSourceProperties'
        self.datain['source'] = None
        self.datain['is_local_file'] = None
        self.datain['local_file'] = None
        self.datain['url'] = None
        self.datain['css'] = None
        self.datain['width'] = None
        self.datain['height'] = None
        self.datain['fps'] = None
        self.datain['shutdown'] = None
        self.dataout['source'] = source

    def getSource(self):
        return self.datain['source']

    def getIs_local_file(self):
        return self.datain['is_local_file']

    def getLocal_file(self):
        return self.datain['local_file']

    def getUrl(self):
        return self.datain['url']

    def getCss(self):
        return self.datain['css']

    def getWidth(self):
        return self.datain['width']

    def getHeight(self):
        return self.datain['height']

    def getFps(self):
        return self.datain['fps']

    def getShutdown(self):
        return self.datain['shutdown']


class SetBrowserSourceProperties(Baserequests):
    """Set current properties for a Browser Source.

    :Arguments:
       *source*
            type: String
            Name of the source.
       *is_local_file*
            type: boolean (optional)
            Indicates that a local file is in use.
       *local_file*
            type: String (optional)
            file path.
       *url*
            type: String (optional)
            Url.
       *css*
            type: String (optional)
            CSS to inject.
       *width*
            type: int (optional)
            Width.
       *height*
            type: int (optional)
            Height.
       *fps*
            type: int (optional)
            Framerate.
       *shutdown*
            type: boolean (optional)
            Indicates whether the source should be shutdown when not visible.
       *render*
            type: boolean (optional)
            Visibility of the scene item.
    """

    def __init__(self, source, is_local_file=None, local_file=None, url=None, css=None, width=None, height=None, fps=None, shutdown=None, render=None):
        Baserequests.__init__(self)
        self.name = 'SetBrowserSourceProperties'
        self.dataout['source'] = source
        self.dataout['is_local_file'] = is_local_file
        self.dataout['local_file'] = local_file
        self.dataout['url'] = url
        self.dataout['css'] = css
        self.dataout['width'] = width
        self.dataout['height'] = height
        self.dataout['fps'] = fps
        self.dataout['shutdown'] = shutdown
        self.dataout['render'] = render


class GetSpecialSources(Baserequests):
    """Get configured special sources like Desktop Audio and Mic/Aux sources.

    :Returns:
       *desktop_1*
            type: String (optional)
            Name of the first Desktop Audio capture source.
       *desktop_2*
            type: String (optional)
            Name of the second Desktop Audio capture source.
       *mic_1*
            type: String (optional)
            Name of the first Mic/Aux input source.
       *mic_2*
            type: String (optional)
            Name of the second Mic/Aux input source.
       *mic_3*
            type: String (optional)
            NAme of the third Mic/Aux input source.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetSpecialSources'
        self.datain['desktop-1'] = None
        self.datain['desktop-2'] = None
        self.datain['mic-1'] = None
        self.datain['mic-2'] = None
        self.datain['mic-3'] = None

    def getDesktop1(self):
        return self.datain['desktop-1']

    def getDesktop2(self):
        return self.datain['desktop-2']

    def getMic1(self):
        return self.datain['mic-1']

    def getMic2(self):
        return self.datain['mic-2']

    def getMic3(self):
        return self.datain['mic-3']


class GetSourceFilters(Baserequests):
    """List filters applied to a source

    :Arguments:
       *sourceName*
            type: String
            Source name
    :Returns:
       *filters*
            type: Array<Object>
            List of filters for the specified source
       *filters___enabled*
            type: Boolean
            Filter status (enabled or not)
       *filters___type*
            type: String
            Filter type
       *filters___name*
            type: String
            Filter name
       *filters___settings*
            type: Object
            Filter settings
    """

    def __init__(self, sourceName):
        Baserequests.__init__(self)
        self.name = 'GetSourceFilters'
        self.datain['filters'] = None
        self.datain['filters.*.enabled'] = None
        self.datain['filters.*.type'] = None
        self.datain['filters.*.name'] = None
        self.datain['filters.*.settings'] = None
        self.dataout['sourceName'] = sourceName

    def getFilters(self):
        return self.datain['filters']

    def getFilters___enabled(self):
        return self.datain['filters.*.enabled']

    def getFilters___type(self):
        return self.datain['filters.*.type']

    def getFilters___name(self):
        return self.datain['filters.*.name']

    def getFilters___settings(self):
        return self.datain['filters.*.settings']


class GetSourceFilterInfo(Baserequests):
    """List filters applied to a source

    :Arguments:
       *sourceName*
            type: String
            Source name
       *filterName*
            type: String
            Source filter name
    :Returns:
       *enabled*
            type: Boolean
            Filter status (enabled or not)
       *type*
            type: String
            Filter type
       *name*
            type: String
            Filter name
       *settings*
            type: Object
            Filter settings
    """

    def __init__(self, sourceName, filterName):
        Baserequests.__init__(self)
        self.name = 'GetSourceFilterInfo'
        self.datain['enabled'] = None
        self.datain['type'] = None
        self.datain['name'] = None
        self.datain['settings'] = None
        self.dataout['sourceName'] = sourceName
        self.dataout['filterName'] = filterName

    def getEnabled(self):
        return self.datain['enabled']

    def getType(self):
        return self.datain['type']

    def getName(self):
        return self.datain['name']

    def getSettings(self):
        return self.datain['settings']


class AddFilterToSource(Baserequests):
    """Add a new filter to a source. Available source types along with their settings properties are available from `GetSourceTypesList`.

    :Arguments:
       *sourceName*
            type: String
            Name of the source on which the filter is added
       *filterName*
            type: String
            Name of the new filter
       *filterType*
            type: String
            Filter type
       *filterSettings*
            type: Object
            Filter settings
    """

    def __init__(self, sourceName, filterName, filterType, filterSettings):
        Baserequests.__init__(self)
        self.name = 'AddFilterToSource'
        self.dataout['sourceName'] = sourceName
        self.dataout['filterName'] = filterName
        self.dataout['filterType'] = filterType
        self.dataout['filterSettings'] = filterSettings


class RemoveFilterFromSource(Baserequests):
    """Remove a filter from a source

    :Arguments:
       *sourceName*
            type: String
            Name of the source from which the specified filter is removed
       *filterName*
            type: String
            Name of the filter to remove
    """

    def __init__(self, sourceName, filterName):
        Baserequests.__init__(self)
        self.name = 'RemoveFilterFromSource'
        self.dataout['sourceName'] = sourceName
        self.dataout['filterName'] = filterName


class ReorderSourceFilter(Baserequests):
    """Move a filter in the chain (absolute index positioning)

    :Arguments:
       *sourceName*
            type: String
            Name of the source to which the filter belongs
       *filterName*
            type: String
            Name of the filter to reorder
       *newIndex*
            type: Integer
            Desired position of the filter in the chain
    """

    def __init__(self, sourceName, filterName, newIndex):
        Baserequests.__init__(self)
        self.name = 'ReorderSourceFilter'
        self.dataout['sourceName'] = sourceName
        self.dataout['filterName'] = filterName
        self.dataout['newIndex'] = newIndex


class MoveSourceFilter(Baserequests):
    """Move a filter in the chain (relative positioning)

    :Arguments:
       *sourceName*
            type: String
            Name of the source to which the filter belongs
       *filterName*
            type: String
            Name of the filter to reorder
       *movementType*
            type: String
            How to move the filter around in the source's filter chain. Either "up", "down", "top" or "bottom".
    """

    def __init__(self, sourceName, filterName, movementType):
        Baserequests.__init__(self)
        self.name = 'MoveSourceFilter'
        self.dataout['sourceName'] = sourceName
        self.dataout['filterName'] = filterName
        self.dataout['movementType'] = movementType


class SetSourceFilterSettings(Baserequests):
    """Update settings of a filter

    :Arguments:
       *sourceName*
            type: String
            Name of the source to which the filter belongs
       *filterName*
            type: String
            Name of the filter to reconfigure
       *filterSettings*
            type: Object
            New settings. These will be merged to the current filter settings.
    """

    def __init__(self, sourceName, filterName, filterSettings):
        Baserequests.__init__(self)
        self.name = 'SetSourceFilterSettings'
        self.dataout['sourceName'] = sourceName
        self.dataout['filterName'] = filterName
        self.dataout['filterSettings'] = filterSettings


class SetSourceFilterVisibility(Baserequests):
    """Change the visibility/enabled state of a filter

    :Arguments:
       *sourceName*
            type: String
            Source name
       *filterName*
            type: String
            Source filter name
       *filterEnabled*
            type: String
            New filter state
    """

    def __init__(self, sourceName, filterName, filterEnabled):
        Baserequests.__init__(self)
        self.name = 'SetSourceFilterVisibility'
        self.dataout['sourceName'] = sourceName
        self.dataout['filterName'] = filterName
        self.dataout['filterEnabled'] = filterEnabled


class TakeSourceScreenshot(Baserequests):
    """

At least `embedPictureFormat` or `saveToFilePath` must be specified.

Clients can specify `width` and `height` parameters to receive scaled pictures. Aspect ratio is
preserved if only one of these two parameters is specified.

    :Arguments:
       *sourceName*
            type: String
            Source name. Note that, since scenes are also sources, you can also provide a scene name.
       *embedPictureFormat*
            type: String (optional)
            Format of the Data URI encoded picture. Can be "png", "jpg", "jpeg" or "bmp" (or any other value supported by Qt's Image module)
       *saveToFilePath*
            type: String (optional)
            Full file path (file extension included) where the captured image is to be saved. Can be in a format different from `pictureFormat`. Can be a relative path.
       *width*
            type: int (optional)
            Screenshot width. Defaults to the source's base width.
       *height*
            type: int (optional)
            Screenshot height. Defaults to the source's base height.
    :Returns:
       *sourceName*
            type: String
            Source name
       *img*
            type: String
            Image Data URI (if `embedPictureFormat` was specified in the request)
       *imageFile*
            type: String
            Absolute path to the saved image file (if `saveToFilePath` was specified in the request)
    """

    def __init__(self, sourceName, embedPictureFormat=None, saveToFilePath=None, width=None, height=None):
        Baserequests.__init__(self)
        self.name = 'TakeSourceScreenshot'
        self.datain['sourceName'] = None
        self.datain['img'] = None
        self.datain['imageFile'] = None
        self.dataout['sourceName'] = sourceName
        self.dataout['embedPictureFormat'] = embedPictureFormat
        self.dataout['saveToFilePath'] = saveToFilePath
        self.dataout['width'] = width
        self.dataout['height'] = height

    def getSourcename(self):
        return self.datain['sourceName']

    def getImg(self):
        return self.datain['img']

    def getImagefile(self):
        return self.datain['imageFile']


class SetCurrentSceneCollection(Baserequests):
    """Change the active scene collection.

    :Arguments:
       *sc_name*
            type: String
            Name of the desired scene collection.
    """

    def __init__(self, sc_name):
        Baserequests.__init__(self)
        self.name = 'SetCurrentSceneCollection'
        self.dataout['sc-name'] = sc_name


class GetCurrentSceneCollection(Baserequests):
    """Get the name of the current scene collection.

    :Returns:
       *sc_name*
            type: String
            Name of the currently active scene collection.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetCurrentSceneCollection'
        self.datain['sc-name'] = None

    def getScName(self):
        return self.datain['sc-name']


class ListSceneCollections(Baserequests):
    """List available scene collections

    :Returns:
       *scene_collections*
            type: Array<String>
            Scene collections list
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'ListSceneCollections'
        self.datain['scene-collections'] = None

    def getSceneCollections(self):
        return self.datain['scene-collections']


class GetTransitionList(Baserequests):
    """List of all transitions available in the frontend's dropdown menu.

    :Returns:
       *current_transition*
            type: String
            Name of the currently active transition.
       *transitions*
            type: Array<Object>
            List of transitions.
       *transitions___name*
            type: String
            Name of the transition.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetTransitionList'
        self.datain['current-transition'] = None
        self.datain['transitions'] = None
        self.datain['transitions.*.name'] = None

    def getCurrentTransition(self):
        return self.datain['current-transition']

    def getTransitions(self):
        return self.datain['transitions']

    def getTransitions___name(self):
        return self.datain['transitions.*.name']


class GetCurrentTransition(Baserequests):
    """Get the name of the currently selected transition in the frontend's dropdown menu.

    :Returns:
       *name*
            type: String
            Name of the selected transition.
       *duration*
            type: int (optional)
            Transition duration (in milliseconds) if supported by the transition.
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetCurrentTransition'
        self.datain['name'] = None
        self.datain['duration'] = None

    def getName(self):
        return self.datain['name']

    def getDuration(self):
        return self.datain['duration']


class SetCurrentTransition(Baserequests):
    """Set the active transition.

    :Arguments:
       *transition_name*
            type: String
            The name of the transition.
    """

    def __init__(self, transition_name):
        Baserequests.__init__(self)
        self.name = 'SetCurrentTransition'
        self.dataout['transition-name'] = transition_name


class SetTransitionDuration(Baserequests):
    """Set the duration of the currently selected transition if supported.

    :Arguments:
       *duration*
            type: int
            Desired duration of the transition (in milliseconds).
    """

    def __init__(self, duration):
        Baserequests.__init__(self)
        self.name = 'SetTransitionDuration'
        self.dataout['duration'] = duration


class GetTransitionDuration(Baserequests):
    """Get the duration of the currently selected transition if supported.

    :Returns:
       *transition_duration*
            type: int
            Duration of the current transition (in milliseconds).
    """

    def __init__(self):
        Baserequests.__init__(self)
        self.name = 'GetTransitionDuration'
        self.datain['transition-duration'] = None

    def getTransitionDuration(self):
        return self.datain['transition-duration']


class GetSceneItemProperties(Baserequests):
    """Gets the scene specific properties of the specified source item.
Coordinates are relative to the item's parent (the scene or group it belongs to).

    :Arguments:
       *scene_name*
            type: String (optional)
            the name of the scene that the source item belongs to. Defaults to the current scene.
       *item*
            type: String
            The name of the source.
    :Returns:
       *name*
            type: String
            The name of the source.
       *position_x*
            type: int
            The x position of the source from the left.
       *position_y*
            type: int
            The y position of the source from the top.
       *position_alignment*
            type: int
            The point on the source that the item is manipulated from.
       *rotation*
            type: double
            The clockwise rotation of the item in degrees around the point of alignment.
       *scale_x*
            type: double
            The x-scale factor of the source.
       *scale_y*
            type: double
            The y-scale factor of the source.
       *crop_top*
            type: int
            The number of pixels cropped off the top of the source before scaling.
       *crop_right*
            type: int
            The number of pixels cropped off the right of the source before scaling.
       *crop_bottom*
            type: int
            The number of pixels cropped off the bottom of the source before scaling.
       *crop_left*
            type: int
            The number of pixels cropped off the left of the source before scaling.
       *visible*
            type: bool
            If the source is visible.
       *locked*
            type: bool
            If the source's transform is locked.
       *bounds_type*
            type: String
            Type of bounding box. Can be "OBS_BOUNDS_STRETCH", "OBS_BOUNDS_SCALE_INNER", "OBS_BOUNDS_SCALE_OUTER", "OBS_BOUNDS_SCALE_TO_WIDTH", "OBS_BOUNDS_SCALE_TO_HEIGHT", "OBS_BOUNDS_MAX_ONLY" or "OBS_BOUNDS_NONE".
       *bounds_alignment*
            type: int
            Alignment of the bounding box.
       *bounds_x*
            type: double
            Width of the bounding box.
       *bounds_y*
            type: double
            Height of the bounding box.
       *sourceWidth*
            type: int
            Base width (without scaling) of the source
       *sourceHeight*
            type: int
            Base source (without scaling) of the source
       *width*
            type: double
            Scene item width (base source width multiplied by the horizontal scaling factor)
       *height*
            type: double
            Scene item height (base source height multiplied by the vertical scaling factor)
    """

    def __init__(self, item, scene_name=None):
        Baserequests.__init__(self)
        self.name = 'GetSceneItemProperties'
        self.datain['name'] = None
        self.datain['position.x'] = None
        self.datain['position.y'] = None
        self.datain['position.alignment'] = None
        self.datain['rotation'] = None
        self.datain['scale.x'] = None
        self.datain['scale.y'] = None
        self.datain['crop.top'] = None
        self.datain['crop.right'] = None
        self.datain['crop.bottom'] = None
        self.datain['crop.left'] = None
        self.datain['visible'] = None
        self.datain['locked'] = None
        self.datain['bounds.type'] = None
        self.datain['bounds.alignment'] = None
        self.datain['bounds.x'] = None
        self.datain['bounds.y'] = None
        self.datain['sourceWidth'] = None
        self.datain['sourceHeight'] = None
        self.datain['width'] = None
        self.datain['height'] = None
        self.dataout['item'] = item
        self.dataout['scene-name'] = scene_name

    def getName(self):
        return self.datain['name']

    def getPosition_x(self):
        return self.datain['position.x']

    def getPosition_y(self):
        return self.datain['position.y']

    def getPosition_alignment(self):
        return self.datain['position.alignment']

    def getRotation(self):
        return self.datain['rotation']

    def getScale_x(self):
        return self.datain['scale.x']

    def getScale_y(self):
        return self.datain['scale.y']

    def getCrop_top(self):
        return self.datain['crop.top']

    def getCrop_right(self):
        return self.datain['crop.right']

    def getCrop_bottom(self):
        return self.datain['crop.bottom']

    def getCrop_left(self):
        return self.datain['crop.left']

    def getVisible(self):
        return self.datain['visible']

    def getLocked(self):
        return self.datain['locked']

    def getBounds_type(self):
        return self.datain['bounds.type']

    def getBounds_alignment(self):
        return self.datain['bounds.alignment']

    def getBounds_x(self):
        return self.datain['bounds.x']

    def getBounds_y(self):
        return self.datain['bounds.y']

    def getSourcewidth(self):
        return self.datain['sourceWidth']

    def getSourceheight(self):
        return self.datain['sourceHeight']

    def getWidth(self):
        return self.datain['width']

    def getHeight(self):
        return self.datain['height']


class SetSceneItemProperties(Baserequests):
    """Sets the scene specific properties of a source. Unspecified properties will remain unchanged.
Coordinates are relative to the item's parent (the scene or group it belongs to).

    :Arguments:
       *scene_name*
            type: String (optional)
            the name of the scene that the source item belongs to. Defaults to the current scene.
       *item*
            type: String
            The name of the source.
       *position_x*
            type: int (optional)
            The new x position of the source.
       *position_y*
            type: int (optional)
            The new y position of the source.
       *position_alignment*
            type: int (optional)
            The new alignment of the source.
       *rotation*
            type: double (optional)
            The new clockwise rotation of the item in degrees.
       *scale_x*
            type: double (optional)
            The new x scale of the item.
       *scale_y*
            type: double (optional)
            The new y scale of the item.
       *crop_top*
            type: int (optional)
            The new amount of pixels cropped off the top of the source before scaling.
       *crop_bottom*
            type: int (optional)
            The new amount of pixels cropped off the bottom of the source before scaling.
       *crop_left*
            type: int (optional)
            The new amount of pixels cropped off the left of the source before scaling.
       *crop_right*
            type: int (optional)
            The new amount of pixels cropped off the right of the source before scaling.
       *visible*
            type: bool (optional)
            The new visibility of the source. 'true' shows source, 'false' hides source.
       *locked*
            type: bool (optional)
            The new locked status of the source. 'true' keeps it in its current position, 'false' allows movement.
       *bounds_type*
            type: String (optional)
            The new bounds type of the source. Can be "OBS_BOUNDS_STRETCH", "OBS_BOUNDS_SCALE_INNER", "OBS_BOUNDS_SCALE_OUTER", "OBS_BOUNDS_SCALE_TO_WIDTH", "OBS_BOUNDS_SCALE_TO_HEIGHT", "OBS_BOUNDS_MAX_ONLY" or "OBS_BOUNDS_NONE".
       *bounds_alignment*
            type: int (optional)
            The new alignment of the bounding box. (0-2, 4-6, 8-10)
       *bounds_x*
            type: double (optional)
            The new width of the bounding box.
       *bounds_y*
            type: double (optional)
            The new height of the bounding box.
    """

    def __init__(self, item, scene_name=None, position_x=None, position_y=None, position_alignment=None, rotation=None, scale_x=None, scale_y=None, crop_top=None, crop_bottom=None, crop_left=None, crop_right=None, visible=None, locked=None, bounds_type=None, bounds_alignment=None, bounds_x=None, bounds_y=None):
        Baserequests.__init__(self)
        self.name = 'SetSceneItemProperties'
        self.dataout['item'] = item
        self.dataout['scene-name'] = scene_name
        self.dataout['position.x'] = position_x
        self.dataout['position.y'] = position_y
        self.dataout['position.alignment'] = position_alignment
        self.dataout['rotation'] = rotation
        self.dataout['scale.x'] = scale_x
        self.dataout['scale.y'] = scale_y
        self.dataout['crop.top'] = crop_top
        self.dataout['crop.bottom'] = crop_bottom
        self.dataout['crop.left'] = crop_left
        self.dataout['crop.right'] = crop_right
        self.dataout['visible'] = visible
        self.dataout['locked'] = locked
        self.dataout['bounds.type'] = bounds_type
        self.dataout['bounds.alignment'] = bounds_alignment
        self.dataout['bounds.x'] = bounds_x
        self.dataout['bounds.y'] = bounds_y


class ResetSceneItem(Baserequests):
    """Reset a scene item.

    :Arguments:
       *scene_name*
            type: String (optional)
            Name of the scene the source belongs to. Defaults to the current scene.
       *item*
            type: String
            Name of the source item.
    """

    def __init__(self, item, scene_name=None):
        Baserequests.__init__(self)
        self.name = 'ResetSceneItem'
        self.dataout['item'] = item
        self.dataout['scene-name'] = scene_name


class SetSceneItemRender(Baserequests):
    """Show or hide a specified source item in a specified scene.

    :Arguments:
       *source*
            type: String
            Scene item name in the specified scene.
       *render*
            type: boolean
            true = shown ; false = hidden
       *scene_name*
            type: String (optional)
            Name of the scene where the source resides. Defaults to the currently active scene.
    """

    def __init__(self, source, render, scene_name=None):
        Baserequests.__init__(self)
        self.name = 'SetSceneItemRender'
        self.dataout['source'] = source
        self.dataout['render'] = render
        self.dataout['scene-name'] = scene_name


class SetSceneItemPosition(Baserequests):
    """Sets the coordinates of a specified source item.

    :Arguments:
       *scene_name*
            type: String (optional)
            The name of the scene that the source item belongs to. Defaults to the current scene.
       *item*
            type: String
            The name of the source item.
       *x*
            type: double
            X coordinate.
       *y*
            type: double
            Y coordinate.
    """

    def __init__(self, item, x, y, scene_name=None):
        Baserequests.__init__(self)
        self.name = 'SetSceneItemPosition'
        self.dataout['item'] = item
        self.dataout['x'] = x
        self.dataout['y'] = y
        self.dataout['scene-name'] = scene_name


class SetSceneItemTransform(Baserequests):
    """Set the transform of the specified source item.

    :Arguments:
       *scene_name*
            type: String (optional)
            The name of the scene that the source item belongs to. Defaults to the current scene.
       *item*
            type: String
            The name of the source item.
       *x_scale*
            type: double
            Width scale factor.
       *y_scale*
            type: double
            Height scale factor.
       *rotation*
            type: double
            Source item rotation (in degrees).
    """

    def __init__(self, item, x_scale, y_scale, rotation, scene_name=None):
        Baserequests.__init__(self)
        self.name = 'SetSceneItemTransform'
        self.dataout['item'] = item
        self.dataout['x-scale'] = x_scale
        self.dataout['y-scale'] = y_scale
        self.dataout['rotation'] = rotation
        self.dataout['scene-name'] = scene_name


class SetSceneItemCrop(Baserequests):
    """Sets the crop coordinates of the specified source item.

    :Arguments:
       *scene_name*
            type: String (optional)
            the name of the scene that the source item belongs to. Defaults to the current scene.
       *item*
            type: String
            The name of the source.
       *top*
            type: int
            Pixel position of the top of the source item.
       *bottom*
            type: int
            Pixel position of the bottom of the source item.
       *left*
            type: int
            Pixel position of the left of the source item.
       *right*
            type: int
            Pixel position of the right of the source item.
    """

    def __init__(self, item, top, bottom, left, right, scene_name=None):
        Baserequests.__init__(self)
        self.name = 'SetSceneItemCrop'
        self.dataout['item'] = item
        self.dataout['top'] = top
        self.dataout['bottom'] = bottom
        self.dataout['left'] = left
        self.dataout['right'] = right
        self.dataout['scene-name'] = scene_name


class DeleteSceneItem(Baserequests):
    """Deletes a scene item.

    :Arguments:
       *scene*
            type: String (optional)
            Name of the scene the source belongs to. Defaults to the current scene.
       *item*
            type: Object
            item to delete (required)
       *item_name*
            type: String
            name of the scene item (prefer `id`, including both is acceptable).
       *item_id*
            type: int
            id of the scene item.
    """

    def __init__(self, item, item_name, item_id, scene=None):
        Baserequests.__init__(self)
        self.name = 'DeleteSceneItem'
        self.dataout['item'] = item
        self.dataout['item.name'] = item_name
        self.dataout['item.id'] = item_id
        self.dataout['scene'] = scene


class DuplicateSceneItem(Baserequests):
    """Duplicates a scene item.

    :Arguments:
       *fromScene*
            type: String (optional)
            Name of the scene to copy the item from. Defaults to the current scene.
       *toScene*
            type: String (optional)
            Name of the scene to create the item in. Defaults to the current scene.
       *item*
            type: Object
            item to duplicate (required)
       *item_name*
            type: String
            name of the scene item (prefer `id`, including both is acceptable).
       *item_id*
            type: int
            id of the scene item.
    :Returns:
       *scene*
            type: String
            Name of the scene where the new item was created
       *item*
            type: Object
            New item info
       *item_id*
            type: int
            New item ID
       *item_name*
            type: String
            New item name
    """

    def __init__(self, item, item_name, item_id, fromScene=None, toScene=None):
        Baserequests.__init__(self)
        self.name = 'DuplicateSceneItem'
        self.datain['scene'] = None
        self.datain['item'] = None
        self.datain['item.id'] = None
        self.datain['item.name'] = None
        self.dataout['item'] = item
        self.dataout['item.name'] = item_name
        self.dataout['item.id'] = item_id
        self.dataout['fromScene'] = fromScene
        self.dataout['toScene'] = toScene

    def getScene(self):
        return self.datain['scene']

    def getItem(self):
        return self.datain['item']

    def getItem_id(self):
        return self.datain['item.id']

    def getItem_name(self):
        return self.datain['item.name']


