# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2018 Dan Tès <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class EditBanned(Object):
    """
    Attributes:
        ID (:obj:`int`): ``0xbfd915cd``

    Args:
        channel: :class:`pyrogram.api.types.InputChannel`
        user_id: :class:`pyrogram.api.types.InputUser`
        banned_rights: :class:`pyrogram.api.types.ChannelBannedRights`

    Returns:
        :class:`pyrogram.api.types.UpdatesTooLong` | :class:`pyrogram.api.types.UpdateShortMessage` | :class:`pyrogram.api.types.UpdateShortChatMessage` | :class:`pyrogram.api.types.UpdateShort` | :class:`pyrogram.api.types.UpdatesCombined` | :class:`pyrogram.api.types.Update` | :class:`pyrogram.api.types.UpdateShortSentMessage`

    Raises:
        :class:`pyrogram.Error`
    """
    ID = 0xbfd915cd

    def __init__(self, channel, user_id, banned_rights):
        self.channel = channel  # InputChannel
        self.user_id = user_id  # InputUser
        self.banned_rights = banned_rights  # ChannelBannedRights

    @staticmethod
    def read(b: BytesIO, *args) -> "EditBanned":
        # No flags
        
        channel = Object.read(b)
        
        user_id = Object.read(b)
        
        banned_rights = Object.read(b)
        
        return EditBanned(channel, user_id, banned_rights)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(self.channel.write())
        
        b.write(self.user_id.write())
        
        b.write(self.banned_rights.write())
        
        return b.getvalue()
