/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// LegalizeTFCommunicationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeTFCommunicationPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = LegalizeTFCommunicationPassBase;

  LegalizeTFCommunicationPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeTFCommunicationPassBase(const LegalizeTFCommunicationPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("xla-legalize-tf-communication");
  }
  ::llvm::StringRef getArgument() const override { return "xla-legalize-tf-communication"; }

  ::llvm::StringRef getDescription() const override { return "Legalize TF/XLA communication ops (TensorFlow dialect) to the HLO dialect"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeTFCommunicationPass");
  }
  ::llvm::StringRef getName() const override { return "LegalizeTFCommunicationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<mhlo::MhloDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// LegalizeTFPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeTFPassBase : public ::mlir::FunctionPass {
public:
  using Base = LegalizeTFPassBase;

  LegalizeTFPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeTFPassBase(const LegalizeTFPassBase &other) : ::mlir::FunctionPass(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("xla-legalize-tf-with-tf2xla");
  }
  ::llvm::StringRef getArgument() const override { return "xla-legalize-tf-with-tf2xla"; }

  ::llvm::StringRef getDescription() const override { return "Legalize from TensorFlow to the HLO dialect using tf2xla kernels"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeTFPass");
  }
  ::llvm::StringRef getName() const override { return "LegalizeTFPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<mhlo::MhloDialect>();

  }

protected:
  ::mlir::Pass::Option<std::string> device_type_{*this, "device-type", ::llvm::cl::desc("XLA device type for execution of TensorFlow ops.")};
  ::mlir::Pass::Option<bool> prefer_tf2xla_{*this, "prefer-tf2xla", ::llvm::cl::desc("Enable legalization when it is not in the list of MLIR-legalized ops.")};
  ::mlir::Pass::Option<bool> legalize_test_only_ops_{*this, "legalize-test-only-ops", ::llvm::cl::desc("Enable tf2xla legalizations for some ops that are enabled only for testing.")};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// LegalizeTFCommunicationPass Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeTFCommunicationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::mhlo::CreateLegalizeTFCommunicationPass();
  });
}

//===----------------------------------------------------------------------===//
// LegalizeTFPass Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeTFPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::mhlo::createLegalizeTfWithTf2XlaPass();
  });
}

//===----------------------------------------------------------------------===//
// TfXla Registration
//===----------------------------------------------------------------------===//

inline void registerTfXlaPasses() {
  registerLegalizeTFCommunicationPassPass();
  registerLegalizeTFPassPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
