from copy import deepcopy

RI49 = {
    'onset': {
        'b': 'ป',
        'c': 'ช',
        'ch': 'ช',
        'd': 'ต',
        'f': 'ฟ',
        'g': 'ก',
        'h': 'ฮ',
        'j': 'จ',
        'k': 'ค',
        'l': 'ล',
        'm': 'ม',
        'n': 'น',
        'ng': 'ง',
        'p': 'พ',
        'q': 'ช',
        'r': 'ร',
        's': 'ซ',
        'sh': 'ช',
        't': 'ท',
        'w': 'ว', ##
        'x': 'ซ',
        'y': 'ย', ##
        'z': 'จ',
        'zh': 'จ',
        '': 'อ'
    },
    'onset_cond': {
        'w': 'อ', # เมื่อตามด้วย u
        'y': 'อ' # เมื่อตามด้วย i
    },
    'rime': {
        # [vowel_onset, vowel, silent_before, coda, phinthu]
        'a': ['อ', 'อา', '', '', False], ##
        'ai': ['อ', 'อาย', '', '', False],
        'an': ['อ', 'อา', '', 'น', False],
        'ang': ['อ', 'อา', '', 'ง', False],
        'ao': ['อ', 'อาว', '', '', False],
        'e': ['อ', 'เออ', '', '', False], ##
        'ei': ['อ', 'เอ', 'ย', '', False],
        'en': ['อ', 'เออ', '', 'น', False],
        'eng': ['อ', 'เออ', '', 'ง', False],
        'er': ['อ', 'เออ', 'ร', '', False],
        'i': ['อ', 'อี', '', '', False], ##
        'ia': ['อ', 'เอีย', '', '', False],
        'ian': ['อ', 'เอีย', '', 'น', False],
        'iang': ['อ', 'เอีย', '', 'ง', False],
        'iao': ['อ', 'เอียว', '', '', False],
        'ie': ['อ', 'เอีย', '', '', False],
        'in': ['อ', 'อิ', '', 'น', False],
        'ing': ['อ', 'อิ', '', 'ง', False],
        'iong': ['ย', 'โอะ', '', 'ง', True],
        'iu': ['อ', 'อิว', '', '', False],
        'o': ['อ', 'โอ', '', '', False], ##
        'ong': ['อ', 'โอะ', '', 'ง', False],
        'ou': ['อ', 'โอว', '', '', False],
        'u': ['อ', 'อู', '', '', False], ##
        'ü': ['ว', 'อี', '', '', True],
        'ua': ['ว', 'อา', '', '', False],
        'uai': ['ว', 'อาย', '', '', False],
        'uan': ['ว', 'อะ', '', 'น', False], ##
        'uang': ['ว', 'อา', '', 'ง', False],
        'ue': ['ว', 'เอ', '', '', True], ##
        'üe': ['ว', 'เอ', '', '', True],
        'ui': ['อ', 'อุย', '', '', False],
        'un': ['อ', 'อุ', '', 'น', False], ##
        'ün': ['ว', 'อิ', '', 'น', True],
        'uo': ['อ', 'อัว', '', '', False],

        'v': ['ว', 'อี', '', '', True],
        've': ['ว', 'เอ', '', '', True],
        'vn': ['ว', 'อิ', '', 'น', True]
        
    },
    'rime_cond': {
        'e': ['อ', 'เอ', '', '', False], # after y
        'i': ['อ', 'อือ', '', '', False], # after c, ch, r, s, sh, z, zh
        'o': ['อ', 'อัว', '', '', False], # after b, f, m, p, w
        'u': ['ว', 'อี', '', '', True], # after j, q, x, y
        'uan': ['ว', 'เอีย', '', 'น', True], # after j, q, x, y
        'un': ['ว', 'อิ', '', 'น', True] # after j, q, x, y
    },
    'cond_rime': {
        'e': ['y'],
        'i': ['c', 'ch', 'r', 's', 'sh', 'z', 'zh'],
        'o': ['b', 'f', 'm', 'p', 'w'],
        'u': ['j', 'q', 'x', 'y'],
        'uan': ['j', 'q', 'x', 'y'],
        'un': ['j', 'q', 'x', 'y']
    },
    'rime_cond2': {
        # tone 0, 5
        'a': '-+ะ',
        'i': '-ึ+' # after c, ch, r, s, sh, z, zh
    },
    'tone': {
        0: -1,
        1: 0,
        2: 4,
        3: 1,
        4: 2,
        5: -1
    }
}

THC43 = deepcopy(RI49)
THC43['onset'].update({
    'sh': 'ซ',
})
THC43['rime'].update({
    'ai': ['อ', 'ไอ', '', '', False],
    'ang': ['อ', 'อะ', '', 'ง', False],
    'ao': ['อ', 'เอา', '', '', False],
    'ia': ['ย', 'อา', '', '', False],
    'iong': ['ย', 'โอะ', '', 'ง', False],
    'ü': ['อ', 'อี', 'ว', '', False],
    'uai': ['ว', 'ไอ', '', '', False],
    'uan': ['อ', 'อัว', '', 'น', False],
    'uang': ['อ', 'อัว', '', 'ง', False],
    'ue': ['อ', 'เอ', 'ว', '', False],
    'üe': ['อ', 'เอ', 'ว', '', False],
    'ün': ['ว', 'อิ', '', 'น', False],

    'v': ['อ', 'อี', 'ว', '', False],
    've': ['อ', 'เอ', 'ว', '', False],
    'vn': ['ว', 'อิ', '', 'น', False]
})
THC43['rime_cond'].update({
    'an': ['อ', 'เอีย', '', 'น', False],
    'e': ['อ', 'เอีย', '', '', False],
    'u': ['อ', 'อี', 'ว', '', False],
    'uan': ['ว', 'เอีย', '', 'น', False],
    'ue': ['ว', 'เอีย', '', '', False],
    'un': ['ว', 'อิ', '', 'น', False]
})
THC43['cond_rime'].update({
    'an': ['y'],
    'e': ['y'],
    'uan': ['j', 'q', 'x'],
    'ue': ['j', 'q', 'x']
})