# Code generated by builder. DO NOT EDIT.
from __future__ import annotations

from typing import Any, Optional, Union

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr

from kelvin.api.base.data_model import DataModelBase

from . import enum


class ErrorObject(DataModelBase):
    """
    ErrorObject object.

    Parameters
    ----------
        name: Optional[StrictStr]
        title: Optional[StrictStr]
        description: Optional[StrictStr]
        solution: Optional[StrictStr]
        payload: Optional[Union[dict[str, Any], list[Union[StrictInt, StrictFloat, StrictStr, StrictBool, dict[str, Any]]]]]

    """

    name: Optional[StrictStr] = Field(default=None, description="ID of the error.")
    title: Optional[StrictStr] = Field(default=None, description="Title of the error.")
    description: Optional[StrictStr] = Field(default=None, description="A description of what the problem may be.")
    solution: Optional[StrictStr] = Field(default=None, description="A possible solution to the problem.")
    payload: Optional[
        Union[dict[str, Any], list[Union[StrictInt, StrictFloat, StrictStr, StrictBool, dict[str, Any]]]]
    ] = Field(
        default=None,
        description="Optional additional information. For example an array of objects listing all the errors that triggered the 4XX response.",
    )


class Error(DataModelBase):
    """
    Error object.

    Parameters
    ----------
        errors: Optional[list[ErrorObject]]

    """

    errors: Optional[list[ErrorObject]] = Field(
        default=None, description="An array of all errors detected during the validation."
    )


class ErrorModel(DataModelBase):
    """
    ErrorModel object.

    Parameters
    ----------
        name: Optional[StrictStr]
        title: Optional[StrictStr]
        description: Optional[StrictStr]
        solution: Optional[StrictStr]
        payload: Optional[list[dict[str, Any]]]
        type: Optional[enum.ErrorLegacyType]

    """

    name: Optional[StrictStr] = Field(default=None, description="Unique identifier name of the error.")
    title: Optional[StrictStr] = Field(default=None, description="The Display name (title) of the error.")
    description: Optional[StrictStr] = Field(default=None, description="Description of what the error is about.")
    solution: Optional[StrictStr] = Field(default=None, description="Possible solutions to resolve the error.")
    payload: Optional[list[dict[str, Any]]] = Field(
        default=None,
        description="A dictionary of all the individual error names, error titles, descriptions and solutions within the submitted information.",
    )
    type: Optional[enum.ErrorLegacyType] = None


class ErrorLegacy(DataModelBase):
    """
    ErrorLegacy object.

    Parameters
    ----------
        errors: Optional[list[ErrorModel]]

    """

    errors: Optional[list[ErrorModel]] = Field(
        default=None, description="An array of all errors detected during the validation."
    )
