# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ntfy_wrapper']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.28.1,<3.0.0', 'typer[all]>=0.7.0,<0.8.0']

entry_points = \
{'console_scripts': ['py-ntfy = ntfy_wrapper.cli:app']}

setup_kwargs = {
    'name': 'ntfy-wrapper',
    'version': '0.1.1',
    'description': 'Fast & Free notifications for your code: Python wrapper around the ntfy.sh notifications service.',
    'long_description': '\n<p align="center">\n    <a href="https://github.com/vict0rsch/ntfy-wrapper" target="_blank">\n        <img src="https://raw.githubusercontent.com/vict0rsch/ntfy-wrapper/main/assets/ntfy-txt.png">\n    </a>\n</p>\n\n`ntfy-wrapper` is a free and hassle-free customizable notifier for Python. No login, no API token, no fees, no bullshit.\n\nIt\'s actually a simple Python wrapper around [`ntfy`](https://ntfy.sh). Kudos to them ❤️\n\nYou can now **send** notification from your Python code and **receive** them on your computer through a [Web App](https://ntfy.sh/app) or a [CLI](https://ntfy.sh/docs/subscribe/cli/), or [on your phone with a dedicated app](https://ntfy.sh/docs/subscribe/phone/)!\n\nAgain, all credit to [`ntfy`](https://ntfy.sh).\n\n## Install\n\nInstall `ntfy-wrapper` (and its 2 dependencies: `requests` and `typer`) with `pip`:\n\n```bash\npip install ntfy-wrapper\n```\n\n## How to use\n\n```python\nfrom ntfy_wrapper import Notifier\n\nif __name__ == "__main__":\n\n    ntfy = Notifier(defaults={"title": "Your Project Name"})\n    # grab the topic id that was just printed here ⬆️ in order\n    # to subscribe to it on the web app or cli or mobile app\n    # (ntfy_wrapper will dump a config file so the same id will be\n    # re-used next time. Remember to *exclude* it from version control)\n\n    ntfy.notify("Job has been allocated, starting Model training")\n\n    try:\n        results = do_some_stuff()\n        if results["metric"] > threshold:\n            ntfy.notify(\n                f"Great model! Its metric is {results[\'metric\']:.3f}",\n                tags="white_check_mark",  # this is the ✅ emoji\n                click=results["online_run_url"],\n            )\n        else:\n            ntfy.notify(f"Done, but not great ({results[\'metric\']:.3f})", tags="disappointed")\n    except Exception as e:\n        ntfy.notify(f"Error! -> {str(e)}", priority=4, emails="you@foo.bar")\n```\n\n### Command-line\n\n`ntfy_wrapper` comes with a command-line interface called `py-ntfy`. It uses the great Python CLI tool [`Typer`](https://typer.tiangolo.com/)\n\n* Get help\n\n    ```bash\n    $ py-ntfy --help\n    Usage: py-ntfy [OPTIONS] COMMAND [ARGS]...\n\n    ╭─ Options ─────────────────────────────────────────────────────────────────────╮\n    │ --install-completion          Install completion for the current shell.       │\n    │ --show-completion             Show completion for the current shell, to copy  │\n    │                               it or customize the installation.               │\n    │ --help                        Show this message and exit.                     │\n    ╰───────────────────────────────────────────────────────────────────────────────╯\n    ╭─ Commands ────────────────────────────────────────────────────────────────────╮\n    │ add     [command sub-group] Add a new notification target or a default        │\n    │         notification value. Run `$ py-ntfy add --help` for more info.         │\n    │ clean   Removes the configuration file. Use --conf-path to specify a path to  │\n    │         the configuration file. Use --force to skip the confirmation prompt.  │\n    │ init    Initializes the configuration file. It should NOT be tracked by       │\n    │         version control in order to protect the topic ID. Use --conf-path to  │\n    │         specify a path to the configuration file. Use --force to overwrite an │\n    │         existing configuration file.                                          │\n    │ remove  [command sub-group] Remove a notification target or a default         │\n    │         notification value. Run `$ py-ntfy remove --help` for more info.      │\n    │ send    Sends a notification to the given emails and topics. Optional         │\n    │         command-line arguments can be passed to override the defaults in the  │\n    │         config file and customize the message options. Refer to               │\n    │         https://ntfy.sh/docs/publish to understand the options. Run           │\n    │         `py-ntfy send --help` to see the available options.                   │\n    ╰───────────────────────────────────────────────────────────────────────────────╯\n\n    $ py-ntfy add --help\n    (similar output)\n\n    $ py-ntfy add default --help\n    (similar output)\n\n    $ py-ntfy remove --help\n    (similar output)\n    ```\n\n* Initialize the configuration file\n\n    ```bash\n    $ py-ntfy init\n    🔑 Your first topic is `f8e34b7a-74a3-49e7-96fc-4d89eaf6ea6c`.\n    Use it to subscribe to notifications!\n    🎉 Config file created at /path/to/repo/.ntfy.conf\n    ```\n\n* Add a topic or an email\n\n    ```bash\n    $ py-ntfy add topic some-secret-string-for-your-topic\n    🎉 Topic `some-secret-string-for-your-topic` added to /path/to/repo/.ntfy.conf\n\n    $ py-ntfy add email you@foo.bar\n    🎉 Email you@foo.bar added to /Users/.../vict0rsch/ntfy-wrapper/.ntfy.conf\n    ```\n\n* Add a default value for the `.notify(...)` calls\n\n    ```bash\n    $ py-ntfy add default key value\n    🎉 Default key=value added to /Users/.../vict0rsch/ntfy-wrapper/.ntfy.conf\n    ```\n\n* Remove items by simply replacing `add` by `remove`\n\n    ```bash\n    $ py-ntfy remove default key\n    🎉 Default key=value removed from /Users/.../vict0rsch/ntfy-wrapper/.ntfy.conf\n\n    $ py-ntfy remove email hello@you.com\n    Email hello@you.com does not exist. Ignoring.\n    ```\n\n* Send a notification from the command-line with `send`\n\n    ```bash\n    $ py-ntfy send "hello" --topics 99e89137-c3a3-47fd-a616-01677b15c5b7 --title "This is Victor" --click "https://9gag.com"\n    🎉 Notification sent to 99e89137-c3a3-47fd-a616-01677b15c5b7, you@foo.bar\n    ```\n\n* Change the default configuration path for any command with the option `--conf-path`\n  * Specify a directory  `--conf-path path/to/conf/directory` and `.ntfy.conf` will be created there\n  * Specify a file `--conf-path path/to/file.conf` and that will be used as a configuration file\n\n## Todo\n\n* [x] Better readme and doc\n* [x] CLI\n* [ ] Screenshots\n* [ ] `requests` timeout or non-blocking\n',
    'author': 'vict0rsch',
    'author_email': 'vsch@pm.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
