# coding: utf-8

"""
    Martlet Organization API

    Create/maintain organizations, access keys, addresses and permissions.   # noqa: E501

    OpenAPI spec version: 0.118.0
    Contact: apiteam@bmbix.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bmb_martlet_organization_client.api_client import ApiClient


class AccessListsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def activate_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """\"create an activation record for this list. Removes any other list's activation record.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListActivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.activate_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.activate_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def activate_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """\"create an activation record for this list. Removes any other list's activation record.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListActivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method activate_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `activate_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `activate_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/activation', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListActivationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_entry(self, body, address_id, list_id, **kwargs):  # noqa: E501
        """Add an entry to an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_entry(body, address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessListEntry body: Entry to add to access list (required)
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_entry_with_http_info(body, address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_entry_with_http_info(body, address_id, list_id, **kwargs)  # noqa: E501
            return data

    def add_entry_with_http_info(self, body, address_id, list_id, **kwargs):  # noqa: E501
        """Add an entry to an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_entry_with_http_info(body, address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessListEntry body: Entry to add to access list (required)
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_entry`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `add_entry`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `add_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/entries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListEntryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_list(self, body, address_id, **kwargs):  # noqa: E501
        """Add an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_list(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessList body: List to add (required)
        :param str address_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_list_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_list_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def add_list_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Add an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_list_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessList body: List to add (required)
        :param str address_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_list`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `add_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deactivate_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete an activation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListDeactivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.deactivate_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.deactivate_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def deactivate_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete an activation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListDeactivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deactivate_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `deactivate_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `deactivate_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/activation', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListDeactivationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_entry(self, address_id, list_id, entry_id, **kwargs):  # noqa: E501
        """Delete an access list entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_entry(address_id, list_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :param str entry_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_entry_with_http_info(address_id, list_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_entry_with_http_info(address_id, list_id, entry_id, **kwargs)  # noqa: E501
            return data

    def delete_entry_with_http_info(self, address_id, list_id, entry_id, **kwargs):  # noqa: E501
        """Delete an access list entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_entry_with_http_info(address_id, list_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :param str entry_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_entry`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `delete_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/entries/{entry_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListEntryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete a list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def delete_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete a list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `delete_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entries(self, address_id, list_id, **kwargs):  # noqa: E501
        """Get list entries  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entries(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entries_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entries_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def get_entries_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """Get list entries  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entries_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_entries`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_entries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/entries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListEntriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """get single access list for owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def get_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """get single access list for owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_lists(self, address_id, **kwargs):  # noqa: E501
        """get access lists for owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lists(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AccessListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_lists_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_lists_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def get_lists_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """get access lists for owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lists_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AccessListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_lists`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
