# coding: utf-8

"""
    Martlet Organization API

    Create/maintain organizations, access keys, addresses and permissions.   # noqa: E501

    OpenAPI spec version: 0.118.0
    Contact: apiteam@bmbix.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bmb_martlet_organization_client.api_client import ApiClient


class OrganizationProxiesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, body, organization_id, **kwargs):  # noqa: E501
        """[create] Create an organization proxy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrganizationProxy body: Organization data (required)
        :param str organization_id: (required)
        :return: OrganizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def create_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """[create] Create an organization proxy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrganizationProxy body: Organization data (required)
        :param str organization_id: (required)
        :return: OrganizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/proxies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, organization_id, proxy_id, **kwargs):  # noqa: E501
        """[delete] Delete a proxy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(organization_id, proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str proxy_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_with_http_info(organization_id, proxy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_with_http_info(organization_id, proxy_id, **kwargs)  # noqa: E501
            return data

    def delete_with_http_info(self, organization_id, proxy_id, **kwargs):  # noqa: E501
        """[delete] Delete a proxy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(organization_id, proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str proxy_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'proxy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `delete`")  # noqa: E501
        # verify the required parameter 'proxy_id' is set
        if ('proxy_id' not in params or
                params['proxy_id'] is None):
            raise ValueError("Missing the required parameter `proxy_id` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'proxy_id' in params:
            path_params['proxy_id'] = params['proxy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/proxies/{proxy_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_proxies(self, organization_id, **kwargs):  # noqa: E501
        """[get_proxies ] Returns the proxies for this organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proxies(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: OrganizationProxiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_proxies_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_proxies_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_proxies_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """[get_proxies ] Returns the proxies for this organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proxies_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: OrganizationProxiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_proxies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `get_proxies`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/proxies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationProxiesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_proxy(self, organization_id, proxy_id, **kwargs):  # noqa: E501
        """[get_proxy] Get details of an individual proxy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proxy(organization_id, proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str proxy_id: (required)
        :return: OrganizationProxyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_proxy_with_http_info(organization_id, proxy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_proxy_with_http_info(organization_id, proxy_id, **kwargs)  # noqa: E501
            return data

    def get_proxy_with_http_info(self, organization_id, proxy_id, **kwargs):  # noqa: E501
        """[get_proxy] Get details of an individual proxy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proxy_with_http_info(organization_id, proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str proxy_id: (required)
        :return: OrganizationProxyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'proxy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_proxy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `get_proxy`")  # noqa: E501
        # verify the required parameter 'proxy_id' is set
        if ('proxy_id' not in params or
                params['proxy_id'] is None):
            raise ValueError("Missing the required parameter `proxy_id` when calling `get_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'proxy_id' in params:
            path_params['proxy_id'] = params['proxy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/proxies/{proxy_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationProxyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
