# coding=utf-8
# Copyright (C) 2020 NumS Development Team.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


from nums.core.application_manager import instance as _instance
from nums.core import linalg


def qr(a, mode="reduced"):
    if mode != "reduced":
        raise NotImplementedError("Only reduced QR decomposition is supported.")
    return linalg.qr(_instance(), a)


def svd(a, full_matrices=True, compute_uv=True, hermitian=False):
    if not (full_matrices and compute_uv and not hermitian):
        raise NotImplementedError("SVD currently supported on default parameters only.")
    return linalg.svd(_instance(), a)
