"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeCluster = exports.ComputeClusterVsanStretchedClusterOutputReference = exports.computeClusterVsanStretchedClusterToHclTerraform = exports.computeClusterVsanStretchedClusterToTerraform = exports.ComputeClusterVsanFaultDomainsList = exports.ComputeClusterVsanFaultDomainsOutputReference = exports.computeClusterVsanFaultDomainsToHclTerraform = exports.computeClusterVsanFaultDomainsToTerraform = exports.ComputeClusterVsanFaultDomainsFaultDomainList = exports.ComputeClusterVsanFaultDomainsFaultDomainOutputReference = exports.computeClusterVsanFaultDomainsFaultDomainToHclTerraform = exports.computeClusterVsanFaultDomainsFaultDomainToTerraform = exports.ComputeClusterVsanDiskGroupList = exports.ComputeClusterVsanDiskGroupOutputReference = exports.computeClusterVsanDiskGroupToHclTerraform = exports.computeClusterVsanDiskGroupToTerraform = exports.ComputeClusterHostImageOutputReference = exports.computeClusterHostImageToHclTerraform = exports.computeClusterHostImageToTerraform = exports.ComputeClusterHostImageComponentList = exports.ComputeClusterHostImageComponentOutputReference = exports.computeClusterHostImageComponentToHclTerraform = exports.computeClusterHostImageComponentToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function computeClusterHostImageComponentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
        version: cdktf.stringToTerraform(struct.version),
    };
}
exports.computeClusterHostImageComponentToTerraform = computeClusterHostImageComponentToTerraform;
function computeClusterHostImageComponentToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        key: {
            value: cdktf.stringToHclTerraform(struct.key),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        version: {
            value: cdktf.stringToHclTerraform(struct.version),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterHostImageComponentToHclTerraform = computeClusterHostImageComponentToHclTerraform;
class ComputeClusterHostImageComponentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._key !== undefined) {
            hasAnyValues = true;
            internalValueResult.key = this._key;
        }
        if (this._version !== undefined) {
            hasAnyValues = true;
            internalValueResult.version = this._version;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._key = undefined;
            this._version = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._key = value.key;
            this._version = value.version;
        }
    }
    get key() {
        return this.getStringAttribute('key');
    }
    set key(value) {
        this._key = value;
    }
    resetKey() {
        this._key = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyInput() {
        return this._key;
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    resetVersion() {
        this._version = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
}
exports.ComputeClusterHostImageComponentOutputReference = ComputeClusterHostImageComponentOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ComputeClusterHostImageComponentOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterHostImageComponentOutputReference", version: "9.3.2" };
class ComputeClusterHostImageComponentList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterHostImageComponentOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterHostImageComponentList = ComputeClusterHostImageComponentList;
_b = JSII_RTTI_SYMBOL_1;
ComputeClusterHostImageComponentList[_b] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterHostImageComponentList", version: "9.3.2" };
function computeClusterHostImageToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        esx_version: cdktf.stringToTerraform(struct.esxVersion),
        component: cdktf.listMapper(computeClusterHostImageComponentToTerraform, true)(struct.component),
    };
}
exports.computeClusterHostImageToTerraform = computeClusterHostImageToTerraform;
function computeClusterHostImageToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        esx_version: {
            value: cdktf.stringToHclTerraform(struct.esxVersion),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        component: {
            value: cdktf.listMapperHcl(computeClusterHostImageComponentToHclTerraform, true)(struct.component),
            isBlock: true,
            type: "list",
            storageClassType: "ComputeClusterHostImageComponentList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterHostImageToHclTerraform = computeClusterHostImageToHclTerraform;
class ComputeClusterHostImageOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // component - computed: false, optional: true, required: false
        this._component = new ComputeClusterHostImageComponentList(this, "component", false);
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._esxVersion !== undefined) {
            hasAnyValues = true;
            internalValueResult.esxVersion = this._esxVersion;
        }
        if (this._component?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.component = this._component?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._esxVersion = undefined;
            this._component.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._esxVersion = value.esxVersion;
            this._component.internalValue = value.component;
        }
    }
    get esxVersion() {
        return this.getStringAttribute('esx_version');
    }
    set esxVersion(value) {
        this._esxVersion = value;
    }
    resetEsxVersion() {
        this._esxVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get esxVersionInput() {
        return this._esxVersion;
    }
    get component() {
        return this._component;
    }
    putComponent(value) {
        this._component.internalValue = value;
    }
    resetComponent() {
        this._component.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get componentInput() {
        return this._component.internalValue;
    }
}
exports.ComputeClusterHostImageOutputReference = ComputeClusterHostImageOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ComputeClusterHostImageOutputReference[_c] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterHostImageOutputReference", version: "9.3.2" };
function computeClusterVsanDiskGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cache: cdktf.stringToTerraform(struct.cache),
        storage: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.storage),
    };
}
exports.computeClusterVsanDiskGroupToTerraform = computeClusterVsanDiskGroupToTerraform;
function computeClusterVsanDiskGroupToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        cache: {
            value: cdktf.stringToHclTerraform(struct.cache),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        storage: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.storage),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterVsanDiskGroupToHclTerraform = computeClusterVsanDiskGroupToHclTerraform;
class ComputeClusterVsanDiskGroupOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cache !== undefined) {
            hasAnyValues = true;
            internalValueResult.cache = this._cache;
        }
        if (this._storage !== undefined) {
            hasAnyValues = true;
            internalValueResult.storage = this._storage;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._cache = undefined;
            this._storage = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._cache = value.cache;
            this._storage = value.storage;
        }
    }
    get cache() {
        return this.getStringAttribute('cache');
    }
    set cache(value) {
        this._cache = value;
    }
    resetCache() {
        this._cache = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacheInput() {
        return this._cache;
    }
    get storage() {
        return cdktf.Fn.tolist(this.getListAttribute('storage'));
    }
    set storage(value) {
        this._storage = value;
    }
    resetStorage() {
        this._storage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageInput() {
        return this._storage;
    }
}
exports.ComputeClusterVsanDiskGroupOutputReference = ComputeClusterVsanDiskGroupOutputReference;
_d = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupOutputReference[_d] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupOutputReference", version: "9.3.2" };
class ComputeClusterVsanDiskGroupList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanDiskGroupOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanDiskGroupList = ComputeClusterVsanDiskGroupList;
_e = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupList[_e] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupList", version: "9.3.2" };
function computeClusterVsanFaultDomainsFaultDomainToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        host_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.hostIds),
        name: cdktf.stringToTerraform(struct.name),
    };
}
exports.computeClusterVsanFaultDomainsFaultDomainToTerraform = computeClusterVsanFaultDomainsFaultDomainToTerraform;
function computeClusterVsanFaultDomainsFaultDomainToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        host_ids: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.hostIds),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
        name: {
            value: cdktf.stringToHclTerraform(struct.name),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterVsanFaultDomainsFaultDomainToHclTerraform = computeClusterVsanFaultDomainsFaultDomainToHclTerraform;
class ComputeClusterVsanFaultDomainsFaultDomainOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._hostIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.hostIds = this._hostIds;
        }
        if (this._name !== undefined) {
            hasAnyValues = true;
            internalValueResult.name = this._name;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._hostIds = undefined;
            this._name = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._hostIds = value.hostIds;
            this._name = value.name;
        }
    }
    get hostIds() {
        return cdktf.Fn.tolist(this.getListAttribute('host_ids'));
    }
    set hostIds(value) {
        this._hostIds = value;
    }
    // Temporarily expose input value. Use with caution.
    get hostIdsInput() {
        return this._hostIds;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
}
exports.ComputeClusterVsanFaultDomainsFaultDomainOutputReference = ComputeClusterVsanFaultDomainsFaultDomainOutputReference;
_f = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsFaultDomainOutputReference[_f] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsFaultDomainOutputReference", version: "9.3.2" };
class ComputeClusterVsanFaultDomainsFaultDomainList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanFaultDomainsFaultDomainOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanFaultDomainsFaultDomainList = ComputeClusterVsanFaultDomainsFaultDomainList;
_g = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsFaultDomainList[_g] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsFaultDomainList", version: "9.3.2" };
function computeClusterVsanFaultDomainsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        fault_domain: cdktf.listMapper(computeClusterVsanFaultDomainsFaultDomainToTerraform, true)(struct.faultDomain),
    };
}
exports.computeClusterVsanFaultDomainsToTerraform = computeClusterVsanFaultDomainsToTerraform;
function computeClusterVsanFaultDomainsToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        fault_domain: {
            value: cdktf.listMapperHcl(computeClusterVsanFaultDomainsFaultDomainToHclTerraform, true)(struct.faultDomain),
            isBlock: true,
            type: "set",
            storageClassType: "ComputeClusterVsanFaultDomainsFaultDomainList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterVsanFaultDomainsToHclTerraform = computeClusterVsanFaultDomainsToHclTerraform;
class ComputeClusterVsanFaultDomainsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
        // fault_domain - computed: false, optional: true, required: false
        this._faultDomain = new ComputeClusterVsanFaultDomainsFaultDomainList(this, "fault_domain", true);
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._faultDomain?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.faultDomain = this._faultDomain?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._faultDomain.internalValue = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._faultDomain.internalValue = value.faultDomain;
        }
    }
    get faultDomain() {
        return this._faultDomain;
    }
    putFaultDomain(value) {
        this._faultDomain.internalValue = value;
    }
    resetFaultDomain() {
        this._faultDomain.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get faultDomainInput() {
        return this._faultDomain.internalValue;
    }
}
exports.ComputeClusterVsanFaultDomainsOutputReference = ComputeClusterVsanFaultDomainsOutputReference;
_h = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsOutputReference[_h] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsOutputReference", version: "9.3.2" };
class ComputeClusterVsanFaultDomainsList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanFaultDomainsOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanFaultDomainsList = ComputeClusterVsanFaultDomainsList;
_j = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanFaultDomainsList[_j] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanFaultDomainsList", version: "9.3.2" };
function computeClusterVsanStretchedClusterToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        preferred_fault_domain_host_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.preferredFaultDomainHostIds),
        preferred_fault_domain_name: cdktf.stringToTerraform(struct.preferredFaultDomainName),
        secondary_fault_domain_host_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.secondaryFaultDomainHostIds),
        secondary_fault_domain_name: cdktf.stringToTerraform(struct.secondaryFaultDomainName),
        witness_node: cdktf.stringToTerraform(struct.witnessNode),
    };
}
exports.computeClusterVsanStretchedClusterToTerraform = computeClusterVsanStretchedClusterToTerraform;
function computeClusterVsanStretchedClusterToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        preferred_fault_domain_host_ids: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.preferredFaultDomainHostIds),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
        preferred_fault_domain_name: {
            value: cdktf.stringToHclTerraform(struct.preferredFaultDomainName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        secondary_fault_domain_host_ids: {
            value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(struct.secondaryFaultDomainHostIds),
            isBlock: false,
            type: "set",
            storageClassType: "stringList",
        },
        secondary_fault_domain_name: {
            value: cdktf.stringToHclTerraform(struct.secondaryFaultDomainName),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        witness_node: {
            value: cdktf.stringToHclTerraform(struct.witnessNode),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.computeClusterVsanStretchedClusterToHclTerraform = computeClusterVsanStretchedClusterToHclTerraform;
class ComputeClusterVsanStretchedClusterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._preferredFaultDomainHostIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.preferredFaultDomainHostIds = this._preferredFaultDomainHostIds;
        }
        if (this._preferredFaultDomainName !== undefined) {
            hasAnyValues = true;
            internalValueResult.preferredFaultDomainName = this._preferredFaultDomainName;
        }
        if (this._secondaryFaultDomainHostIds !== undefined) {
            hasAnyValues = true;
            internalValueResult.secondaryFaultDomainHostIds = this._secondaryFaultDomainHostIds;
        }
        if (this._secondaryFaultDomainName !== undefined) {
            hasAnyValues = true;
            internalValueResult.secondaryFaultDomainName = this._secondaryFaultDomainName;
        }
        if (this._witnessNode !== undefined) {
            hasAnyValues = true;
            internalValueResult.witnessNode = this._witnessNode;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._preferredFaultDomainHostIds = undefined;
            this._preferredFaultDomainName = undefined;
            this._secondaryFaultDomainHostIds = undefined;
            this._secondaryFaultDomainName = undefined;
            this._witnessNode = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._preferredFaultDomainHostIds = value.preferredFaultDomainHostIds;
            this._preferredFaultDomainName = value.preferredFaultDomainName;
            this._secondaryFaultDomainHostIds = value.secondaryFaultDomainHostIds;
            this._secondaryFaultDomainName = value.secondaryFaultDomainName;
            this._witnessNode = value.witnessNode;
        }
    }
    get preferredFaultDomainHostIds() {
        return cdktf.Fn.tolist(this.getListAttribute('preferred_fault_domain_host_ids'));
    }
    set preferredFaultDomainHostIds(value) {
        this._preferredFaultDomainHostIds = value;
    }
    // Temporarily expose input value. Use with caution.
    get preferredFaultDomainHostIdsInput() {
        return this._preferredFaultDomainHostIds;
    }
    get preferredFaultDomainName() {
        return this.getStringAttribute('preferred_fault_domain_name');
    }
    set preferredFaultDomainName(value) {
        this._preferredFaultDomainName = value;
    }
    resetPreferredFaultDomainName() {
        this._preferredFaultDomainName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preferredFaultDomainNameInput() {
        return this._preferredFaultDomainName;
    }
    get secondaryFaultDomainHostIds() {
        return cdktf.Fn.tolist(this.getListAttribute('secondary_fault_domain_host_ids'));
    }
    set secondaryFaultDomainHostIds(value) {
        this._secondaryFaultDomainHostIds = value;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryFaultDomainHostIdsInput() {
        return this._secondaryFaultDomainHostIds;
    }
    get secondaryFaultDomainName() {
        return this.getStringAttribute('secondary_fault_domain_name');
    }
    set secondaryFaultDomainName(value) {
        this._secondaryFaultDomainName = value;
    }
    resetSecondaryFaultDomainName() {
        this._secondaryFaultDomainName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryFaultDomainNameInput() {
        return this._secondaryFaultDomainName;
    }
    get witnessNode() {
        return this.getStringAttribute('witness_node');
    }
    set witnessNode(value) {
        this._witnessNode = value;
    }
    // Temporarily expose input value. Use with caution.
    get witnessNodeInput() {
        return this._witnessNode;
    }
}
exports.ComputeClusterVsanStretchedClusterOutputReference = ComputeClusterVsanStretchedClusterOutputReference;
_k = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanStretchedClusterOutputReference[_k] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanStretchedClusterOutputReference", version: "9.3.2" };
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/compute_cluster vsphere_compute_cluster}
*/
class ComputeCluster extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a ComputeCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ComputeCluster to import
    * @param importFromId The id of the existing ComputeCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/compute_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ComputeCluster to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "vsphere_compute_cluster", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/compute_cluster vsphere_compute_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_compute_cluster',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.9.2',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // host_image - computed: false, optional: true, required: false
        this._hostImage = new ComputeClusterHostImageOutputReference(this, "host_image");
        // vsan_disk_group - computed: false, optional: true, required: false
        this._vsanDiskGroup = new ComputeClusterVsanDiskGroupList(this, "vsan_disk_group", false);
        // vsan_fault_domains - computed: false, optional: true, required: false
        this._vsanFaultDomains = new ComputeClusterVsanFaultDomainsList(this, "vsan_fault_domains", true);
        // vsan_stretched_cluster - computed: false, optional: true, required: false
        this._vsanStretchedCluster = new ComputeClusterVsanStretchedClusterOutputReference(this, "vsan_stretched_cluster");
        this._customAttributes = config.customAttributes;
        this._datacenterId = config.datacenterId;
        this._dpmAutomationLevel = config.dpmAutomationLevel;
        this._dpmEnabled = config.dpmEnabled;
        this._dpmThreshold = config.dpmThreshold;
        this._drsAdvancedOptions = config.drsAdvancedOptions;
        this._drsAutomationLevel = config.drsAutomationLevel;
        this._drsEnablePredictiveDrs = config.drsEnablePredictiveDrs;
        this._drsEnableVmOverrides = config.drsEnableVmOverrides;
        this._drsEnabled = config.drsEnabled;
        this._drsMigrationThreshold = config.drsMigrationThreshold;
        this._drsScaleDescendantsShares = config.drsScaleDescendantsShares;
        this._folder = config.folder;
        this._forceEvacuateOnDestroy = config.forceEvacuateOnDestroy;
        this._haAdmissionControlFailoverHostSystemIds = config.haAdmissionControlFailoverHostSystemIds;
        this._haAdmissionControlHostFailureTolerance = config.haAdmissionControlHostFailureTolerance;
        this._haAdmissionControlPerformanceTolerance = config.haAdmissionControlPerformanceTolerance;
        this._haAdmissionControlPolicy = config.haAdmissionControlPolicy;
        this._haAdmissionControlResourcePercentageAutoCompute = config.haAdmissionControlResourcePercentageAutoCompute;
        this._haAdmissionControlResourcePercentageCpu = config.haAdmissionControlResourcePercentageCpu;
        this._haAdmissionControlResourcePercentageMemory = config.haAdmissionControlResourcePercentageMemory;
        this._haAdmissionControlSlotPolicyExplicitCpu = config.haAdmissionControlSlotPolicyExplicitCpu;
        this._haAdmissionControlSlotPolicyExplicitMemory = config.haAdmissionControlSlotPolicyExplicitMemory;
        this._haAdmissionControlSlotPolicyUseExplicitSize = config.haAdmissionControlSlotPolicyUseExplicitSize;
        this._haAdvancedOptions = config.haAdvancedOptions;
        this._haDatastoreApdRecoveryAction = config.haDatastoreApdRecoveryAction;
        this._haDatastoreApdResponse = config.haDatastoreApdResponse;
        this._haDatastoreApdResponseDelay = config.haDatastoreApdResponseDelay;
        this._haDatastorePdlResponse = config.haDatastorePdlResponse;
        this._haEnabled = config.haEnabled;
        this._haHeartbeatDatastoreIds = config.haHeartbeatDatastoreIds;
        this._haHeartbeatDatastorePolicy = config.haHeartbeatDatastorePolicy;
        this._haHostIsolationResponse = config.haHostIsolationResponse;
        this._haHostMonitoring = config.haHostMonitoring;
        this._haVmComponentProtection = config.haVmComponentProtection;
        this._haVmDependencyRestartCondition = config.haVmDependencyRestartCondition;
        this._haVmFailureInterval = config.haVmFailureInterval;
        this._haVmMaximumFailureWindow = config.haVmMaximumFailureWindow;
        this._haVmMaximumResets = config.haVmMaximumResets;
        this._haVmMinimumUptime = config.haVmMinimumUptime;
        this._haVmMonitoring = config.haVmMonitoring;
        this._haVmRestartAdditionalDelay = config.haVmRestartAdditionalDelay;
        this._haVmRestartPriority = config.haVmRestartPriority;
        this._haVmRestartTimeout = config.haVmRestartTimeout;
        this._hostClusterExitTimeout = config.hostClusterExitTimeout;
        this._hostManaged = config.hostManaged;
        this._hostSystemIds = config.hostSystemIds;
        this._id = config.id;
        this._name = config.name;
        this._proactiveHaAutomationLevel = config.proactiveHaAutomationLevel;
        this._proactiveHaEnabled = config.proactiveHaEnabled;
        this._proactiveHaModerateRemediation = config.proactiveHaModerateRemediation;
        this._proactiveHaProviderIds = config.proactiveHaProviderIds;
        this._proactiveHaSevereRemediation = config.proactiveHaSevereRemediation;
        this._tags = config.tags;
        this._vsanCompressionEnabled = config.vsanCompressionEnabled;
        this._vsanDedupEnabled = config.vsanDedupEnabled;
        this._vsanDitEncryptionEnabled = config.vsanDitEncryptionEnabled;
        this._vsanDitRekeyInterval = config.vsanDitRekeyInterval;
        this._vsanEnabled = config.vsanEnabled;
        this._vsanEsaEnabled = config.vsanEsaEnabled;
        this._vsanNetworkDiagnosticModeEnabled = config.vsanNetworkDiagnosticModeEnabled;
        this._vsanPerformanceEnabled = config.vsanPerformanceEnabled;
        this._vsanRemoteDatastoreIds = config.vsanRemoteDatastoreIds;
        this._vsanUnmapEnabled = config.vsanUnmapEnabled;
        this._vsanVerboseModeEnabled = config.vsanVerboseModeEnabled;
        this._hostImage.internalValue = config.hostImage;
        this._vsanDiskGroup.internalValue = config.vsanDiskGroup;
        this._vsanFaultDomains.internalValue = config.vsanFaultDomains;
        this._vsanStretchedCluster.internalValue = config.vsanStretchedCluster;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    get dpmAutomationLevel() {
        return this.getStringAttribute('dpm_automation_level');
    }
    set dpmAutomationLevel(value) {
        this._dpmAutomationLevel = value;
    }
    resetDpmAutomationLevel() {
        this._dpmAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmAutomationLevelInput() {
        return this._dpmAutomationLevel;
    }
    get dpmEnabled() {
        return this.getBooleanAttribute('dpm_enabled');
    }
    set dpmEnabled(value) {
        this._dpmEnabled = value;
    }
    resetDpmEnabled() {
        this._dpmEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmEnabledInput() {
        return this._dpmEnabled;
    }
    get dpmThreshold() {
        return this.getNumberAttribute('dpm_threshold');
    }
    set dpmThreshold(value) {
        this._dpmThreshold = value;
    }
    resetDpmThreshold() {
        this._dpmThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmThresholdInput() {
        return this._dpmThreshold;
    }
    get drsAdvancedOptions() {
        return this.getStringMapAttribute('drs_advanced_options');
    }
    set drsAdvancedOptions(value) {
        this._drsAdvancedOptions = value;
    }
    resetDrsAdvancedOptions() {
        this._drsAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAdvancedOptionsInput() {
        return this._drsAdvancedOptions;
    }
    get drsAutomationLevel() {
        return this.getStringAttribute('drs_automation_level');
    }
    set drsAutomationLevel(value) {
        this._drsAutomationLevel = value;
    }
    resetDrsAutomationLevel() {
        this._drsAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAutomationLevelInput() {
        return this._drsAutomationLevel;
    }
    get drsEnablePredictiveDrs() {
        return this.getBooleanAttribute('drs_enable_predictive_drs');
    }
    set drsEnablePredictiveDrs(value) {
        this._drsEnablePredictiveDrs = value;
    }
    resetDrsEnablePredictiveDrs() {
        this._drsEnablePredictiveDrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnablePredictiveDrsInput() {
        return this._drsEnablePredictiveDrs;
    }
    get drsEnableVmOverrides() {
        return this.getBooleanAttribute('drs_enable_vm_overrides');
    }
    set drsEnableVmOverrides(value) {
        this._drsEnableVmOverrides = value;
    }
    resetDrsEnableVmOverrides() {
        this._drsEnableVmOverrides = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnableVmOverridesInput() {
        return this._drsEnableVmOverrides;
    }
    get drsEnabled() {
        return this.getBooleanAttribute('drs_enabled');
    }
    set drsEnabled(value) {
        this._drsEnabled = value;
    }
    resetDrsEnabled() {
        this._drsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnabledInput() {
        return this._drsEnabled;
    }
    get drsMigrationThreshold() {
        return this.getNumberAttribute('drs_migration_threshold');
    }
    set drsMigrationThreshold(value) {
        this._drsMigrationThreshold = value;
    }
    resetDrsMigrationThreshold() {
        this._drsMigrationThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsMigrationThresholdInput() {
        return this._drsMigrationThreshold;
    }
    get drsScaleDescendantsShares() {
        return this.getStringAttribute('drs_scale_descendants_shares');
    }
    set drsScaleDescendantsShares(value) {
        this._drsScaleDescendantsShares = value;
    }
    resetDrsScaleDescendantsShares() {
        this._drsScaleDescendantsShares = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsScaleDescendantsSharesInput() {
        return this._drsScaleDescendantsShares;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get forceEvacuateOnDestroy() {
        return this.getBooleanAttribute('force_evacuate_on_destroy');
    }
    set forceEvacuateOnDestroy(value) {
        this._forceEvacuateOnDestroy = value;
    }
    resetForceEvacuateOnDestroy() {
        this._forceEvacuateOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forceEvacuateOnDestroyInput() {
        return this._forceEvacuateOnDestroy;
    }
    get haAdmissionControlFailoverHostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_admission_control_failover_host_system_ids'));
    }
    set haAdmissionControlFailoverHostSystemIds(value) {
        this._haAdmissionControlFailoverHostSystemIds = value;
    }
    resetHaAdmissionControlFailoverHostSystemIds() {
        this._haAdmissionControlFailoverHostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlFailoverHostSystemIdsInput() {
        return this._haAdmissionControlFailoverHostSystemIds;
    }
    get haAdmissionControlHostFailureTolerance() {
        return this.getNumberAttribute('ha_admission_control_host_failure_tolerance');
    }
    set haAdmissionControlHostFailureTolerance(value) {
        this._haAdmissionControlHostFailureTolerance = value;
    }
    resetHaAdmissionControlHostFailureTolerance() {
        this._haAdmissionControlHostFailureTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlHostFailureToleranceInput() {
        return this._haAdmissionControlHostFailureTolerance;
    }
    get haAdmissionControlPerformanceTolerance() {
        return this.getNumberAttribute('ha_admission_control_performance_tolerance');
    }
    set haAdmissionControlPerformanceTolerance(value) {
        this._haAdmissionControlPerformanceTolerance = value;
    }
    resetHaAdmissionControlPerformanceTolerance() {
        this._haAdmissionControlPerformanceTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPerformanceToleranceInput() {
        return this._haAdmissionControlPerformanceTolerance;
    }
    get haAdmissionControlPolicy() {
        return this.getStringAttribute('ha_admission_control_policy');
    }
    set haAdmissionControlPolicy(value) {
        this._haAdmissionControlPolicy = value;
    }
    resetHaAdmissionControlPolicy() {
        this._haAdmissionControlPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPolicyInput() {
        return this._haAdmissionControlPolicy;
    }
    get haAdmissionControlResourcePercentageAutoCompute() {
        return this.getBooleanAttribute('ha_admission_control_resource_percentage_auto_compute');
    }
    set haAdmissionControlResourcePercentageAutoCompute(value) {
        this._haAdmissionControlResourcePercentageAutoCompute = value;
    }
    resetHaAdmissionControlResourcePercentageAutoCompute() {
        this._haAdmissionControlResourcePercentageAutoCompute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageAutoComputeInput() {
        return this._haAdmissionControlResourcePercentageAutoCompute;
    }
    get haAdmissionControlResourcePercentageCpu() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_cpu');
    }
    set haAdmissionControlResourcePercentageCpu(value) {
        this._haAdmissionControlResourcePercentageCpu = value;
    }
    resetHaAdmissionControlResourcePercentageCpu() {
        this._haAdmissionControlResourcePercentageCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageCpuInput() {
        return this._haAdmissionControlResourcePercentageCpu;
    }
    get haAdmissionControlResourcePercentageMemory() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_memory');
    }
    set haAdmissionControlResourcePercentageMemory(value) {
        this._haAdmissionControlResourcePercentageMemory = value;
    }
    resetHaAdmissionControlResourcePercentageMemory() {
        this._haAdmissionControlResourcePercentageMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageMemoryInput() {
        return this._haAdmissionControlResourcePercentageMemory;
    }
    get haAdmissionControlSlotPolicyExplicitCpu() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_cpu');
    }
    set haAdmissionControlSlotPolicyExplicitCpu(value) {
        this._haAdmissionControlSlotPolicyExplicitCpu = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitCpu() {
        this._haAdmissionControlSlotPolicyExplicitCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitCpuInput() {
        return this._haAdmissionControlSlotPolicyExplicitCpu;
    }
    get haAdmissionControlSlotPolicyExplicitMemory() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_memory');
    }
    set haAdmissionControlSlotPolicyExplicitMemory(value) {
        this._haAdmissionControlSlotPolicyExplicitMemory = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitMemory() {
        this._haAdmissionControlSlotPolicyExplicitMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitMemoryInput() {
        return this._haAdmissionControlSlotPolicyExplicitMemory;
    }
    get haAdmissionControlSlotPolicyUseExplicitSize() {
        return this.getBooleanAttribute('ha_admission_control_slot_policy_use_explicit_size');
    }
    set haAdmissionControlSlotPolicyUseExplicitSize(value) {
        this._haAdmissionControlSlotPolicyUseExplicitSize = value;
    }
    resetHaAdmissionControlSlotPolicyUseExplicitSize() {
        this._haAdmissionControlSlotPolicyUseExplicitSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyUseExplicitSizeInput() {
        return this._haAdmissionControlSlotPolicyUseExplicitSize;
    }
    get haAdvancedOptions() {
        return this.getStringMapAttribute('ha_advanced_options');
    }
    set haAdvancedOptions(value) {
        this._haAdvancedOptions = value;
    }
    resetHaAdvancedOptions() {
        this._haAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdvancedOptionsInput() {
        return this._haAdvancedOptions;
    }
    get haDatastoreApdRecoveryAction() {
        return this.getStringAttribute('ha_datastore_apd_recovery_action');
    }
    set haDatastoreApdRecoveryAction(value) {
        this._haDatastoreApdRecoveryAction = value;
    }
    resetHaDatastoreApdRecoveryAction() {
        this._haDatastoreApdRecoveryAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdRecoveryActionInput() {
        return this._haDatastoreApdRecoveryAction;
    }
    get haDatastoreApdResponse() {
        return this.getStringAttribute('ha_datastore_apd_response');
    }
    set haDatastoreApdResponse(value) {
        this._haDatastoreApdResponse = value;
    }
    resetHaDatastoreApdResponse() {
        this._haDatastoreApdResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseInput() {
        return this._haDatastoreApdResponse;
    }
    get haDatastoreApdResponseDelay() {
        return this.getNumberAttribute('ha_datastore_apd_response_delay');
    }
    set haDatastoreApdResponseDelay(value) {
        this._haDatastoreApdResponseDelay = value;
    }
    resetHaDatastoreApdResponseDelay() {
        this._haDatastoreApdResponseDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseDelayInput() {
        return this._haDatastoreApdResponseDelay;
    }
    get haDatastorePdlResponse() {
        return this.getStringAttribute('ha_datastore_pdl_response');
    }
    set haDatastorePdlResponse(value) {
        this._haDatastorePdlResponse = value;
    }
    resetHaDatastorePdlResponse() {
        this._haDatastorePdlResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastorePdlResponseInput() {
        return this._haDatastorePdlResponse;
    }
    get haEnabled() {
        return this.getBooleanAttribute('ha_enabled');
    }
    set haEnabled(value) {
        this._haEnabled = value;
    }
    resetHaEnabled() {
        this._haEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haEnabledInput() {
        return this._haEnabled;
    }
    get haHeartbeatDatastoreIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_heartbeat_datastore_ids'));
    }
    set haHeartbeatDatastoreIds(value) {
        this._haHeartbeatDatastoreIds = value;
    }
    resetHaHeartbeatDatastoreIds() {
        this._haHeartbeatDatastoreIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastoreIdsInput() {
        return this._haHeartbeatDatastoreIds;
    }
    get haHeartbeatDatastorePolicy() {
        return this.getStringAttribute('ha_heartbeat_datastore_policy');
    }
    set haHeartbeatDatastorePolicy(value) {
        this._haHeartbeatDatastorePolicy = value;
    }
    resetHaHeartbeatDatastorePolicy() {
        this._haHeartbeatDatastorePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastorePolicyInput() {
        return this._haHeartbeatDatastorePolicy;
    }
    get haHostIsolationResponse() {
        return this.getStringAttribute('ha_host_isolation_response');
    }
    set haHostIsolationResponse(value) {
        this._haHostIsolationResponse = value;
    }
    resetHaHostIsolationResponse() {
        this._haHostIsolationResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostIsolationResponseInput() {
        return this._haHostIsolationResponse;
    }
    get haHostMonitoring() {
        return this.getStringAttribute('ha_host_monitoring');
    }
    set haHostMonitoring(value) {
        this._haHostMonitoring = value;
    }
    resetHaHostMonitoring() {
        this._haHostMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostMonitoringInput() {
        return this._haHostMonitoring;
    }
    get haVmComponentProtection() {
        return this.getStringAttribute('ha_vm_component_protection');
    }
    set haVmComponentProtection(value) {
        this._haVmComponentProtection = value;
    }
    resetHaVmComponentProtection() {
        this._haVmComponentProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmComponentProtectionInput() {
        return this._haVmComponentProtection;
    }
    get haVmDependencyRestartCondition() {
        return this.getStringAttribute('ha_vm_dependency_restart_condition');
    }
    set haVmDependencyRestartCondition(value) {
        this._haVmDependencyRestartCondition = value;
    }
    resetHaVmDependencyRestartCondition() {
        this._haVmDependencyRestartCondition = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmDependencyRestartConditionInput() {
        return this._haVmDependencyRestartCondition;
    }
    get haVmFailureInterval() {
        return this.getNumberAttribute('ha_vm_failure_interval');
    }
    set haVmFailureInterval(value) {
        this._haVmFailureInterval = value;
    }
    resetHaVmFailureInterval() {
        this._haVmFailureInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmFailureIntervalInput() {
        return this._haVmFailureInterval;
    }
    get haVmMaximumFailureWindow() {
        return this.getNumberAttribute('ha_vm_maximum_failure_window');
    }
    set haVmMaximumFailureWindow(value) {
        this._haVmMaximumFailureWindow = value;
    }
    resetHaVmMaximumFailureWindow() {
        this._haVmMaximumFailureWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumFailureWindowInput() {
        return this._haVmMaximumFailureWindow;
    }
    get haVmMaximumResets() {
        return this.getNumberAttribute('ha_vm_maximum_resets');
    }
    set haVmMaximumResets(value) {
        this._haVmMaximumResets = value;
    }
    resetHaVmMaximumResets() {
        this._haVmMaximumResets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumResetsInput() {
        return this._haVmMaximumResets;
    }
    get haVmMinimumUptime() {
        return this.getNumberAttribute('ha_vm_minimum_uptime');
    }
    set haVmMinimumUptime(value) {
        this._haVmMinimumUptime = value;
    }
    resetHaVmMinimumUptime() {
        this._haVmMinimumUptime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMinimumUptimeInput() {
        return this._haVmMinimumUptime;
    }
    get haVmMonitoring() {
        return this.getStringAttribute('ha_vm_monitoring');
    }
    set haVmMonitoring(value) {
        this._haVmMonitoring = value;
    }
    resetHaVmMonitoring() {
        this._haVmMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMonitoringInput() {
        return this._haVmMonitoring;
    }
    get haVmRestartAdditionalDelay() {
        return this.getNumberAttribute('ha_vm_restart_additional_delay');
    }
    set haVmRestartAdditionalDelay(value) {
        this._haVmRestartAdditionalDelay = value;
    }
    resetHaVmRestartAdditionalDelay() {
        this._haVmRestartAdditionalDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartAdditionalDelayInput() {
        return this._haVmRestartAdditionalDelay;
    }
    get haVmRestartPriority() {
        return this.getStringAttribute('ha_vm_restart_priority');
    }
    set haVmRestartPriority(value) {
        this._haVmRestartPriority = value;
    }
    resetHaVmRestartPriority() {
        this._haVmRestartPriority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartPriorityInput() {
        return this._haVmRestartPriority;
    }
    get haVmRestartTimeout() {
        return this.getNumberAttribute('ha_vm_restart_timeout');
    }
    set haVmRestartTimeout(value) {
        this._haVmRestartTimeout = value;
    }
    resetHaVmRestartTimeout() {
        this._haVmRestartTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartTimeoutInput() {
        return this._haVmRestartTimeout;
    }
    get hostClusterExitTimeout() {
        return this.getNumberAttribute('host_cluster_exit_timeout');
    }
    set hostClusterExitTimeout(value) {
        this._hostClusterExitTimeout = value;
    }
    resetHostClusterExitTimeout() {
        this._hostClusterExitTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostClusterExitTimeoutInput() {
        return this._hostClusterExitTimeout;
    }
    get hostManaged() {
        return this.getBooleanAttribute('host_managed');
    }
    set hostManaged(value) {
        this._hostManaged = value;
    }
    resetHostManaged() {
        this._hostManaged = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostManagedInput() {
        return this._hostManaged;
    }
    get hostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('host_system_ids'));
    }
    set hostSystemIds(value) {
        this._hostSystemIds = value;
    }
    resetHostSystemIds() {
        this._hostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostSystemIdsInput() {
        return this._hostSystemIds;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get proactiveHaAutomationLevel() {
        return this.getStringAttribute('proactive_ha_automation_level');
    }
    set proactiveHaAutomationLevel(value) {
        this._proactiveHaAutomationLevel = value;
    }
    resetProactiveHaAutomationLevel() {
        this._proactiveHaAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaAutomationLevelInput() {
        return this._proactiveHaAutomationLevel;
    }
    get proactiveHaEnabled() {
        return this.getBooleanAttribute('proactive_ha_enabled');
    }
    set proactiveHaEnabled(value) {
        this._proactiveHaEnabled = value;
    }
    resetProactiveHaEnabled() {
        this._proactiveHaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaEnabledInput() {
        return this._proactiveHaEnabled;
    }
    get proactiveHaModerateRemediation() {
        return this.getStringAttribute('proactive_ha_moderate_remediation');
    }
    set proactiveHaModerateRemediation(value) {
        this._proactiveHaModerateRemediation = value;
    }
    resetProactiveHaModerateRemediation() {
        this._proactiveHaModerateRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaModerateRemediationInput() {
        return this._proactiveHaModerateRemediation;
    }
    get proactiveHaProviderIds() {
        return cdktf.Fn.tolist(this.getListAttribute('proactive_ha_provider_ids'));
    }
    set proactiveHaProviderIds(value) {
        this._proactiveHaProviderIds = value;
    }
    resetProactiveHaProviderIds() {
        this._proactiveHaProviderIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaProviderIdsInput() {
        return this._proactiveHaProviderIds;
    }
    get proactiveHaSevereRemediation() {
        return this.getStringAttribute('proactive_ha_severe_remediation');
    }
    set proactiveHaSevereRemediation(value) {
        this._proactiveHaSevereRemediation = value;
    }
    resetProactiveHaSevereRemediation() {
        this._proactiveHaSevereRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaSevereRemediationInput() {
        return this._proactiveHaSevereRemediation;
    }
    // resource_pool_id - computed: true, optional: false, required: false
    get resourcePoolId() {
        return this.getStringAttribute('resource_pool_id');
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get vsanCompressionEnabled() {
        return this.getBooleanAttribute('vsan_compression_enabled');
    }
    set vsanCompressionEnabled(value) {
        this._vsanCompressionEnabled = value;
    }
    resetVsanCompressionEnabled() {
        this._vsanCompressionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanCompressionEnabledInput() {
        return this._vsanCompressionEnabled;
    }
    get vsanDedupEnabled() {
        return this.getBooleanAttribute('vsan_dedup_enabled');
    }
    set vsanDedupEnabled(value) {
        this._vsanDedupEnabled = value;
    }
    resetVsanDedupEnabled() {
        this._vsanDedupEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDedupEnabledInput() {
        return this._vsanDedupEnabled;
    }
    get vsanDitEncryptionEnabled() {
        return this.getBooleanAttribute('vsan_dit_encryption_enabled');
    }
    set vsanDitEncryptionEnabled(value) {
        this._vsanDitEncryptionEnabled = value;
    }
    resetVsanDitEncryptionEnabled() {
        this._vsanDitEncryptionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDitEncryptionEnabledInput() {
        return this._vsanDitEncryptionEnabled;
    }
    get vsanDitRekeyInterval() {
        return this.getNumberAttribute('vsan_dit_rekey_interval');
    }
    set vsanDitRekeyInterval(value) {
        this._vsanDitRekeyInterval = value;
    }
    resetVsanDitRekeyInterval() {
        this._vsanDitRekeyInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDitRekeyIntervalInput() {
        return this._vsanDitRekeyInterval;
    }
    get vsanEnabled() {
        return this.getBooleanAttribute('vsan_enabled');
    }
    set vsanEnabled(value) {
        this._vsanEnabled = value;
    }
    resetVsanEnabled() {
        this._vsanEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanEnabledInput() {
        return this._vsanEnabled;
    }
    get vsanEsaEnabled() {
        return this.getBooleanAttribute('vsan_esa_enabled');
    }
    set vsanEsaEnabled(value) {
        this._vsanEsaEnabled = value;
    }
    resetVsanEsaEnabled() {
        this._vsanEsaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanEsaEnabledInput() {
        return this._vsanEsaEnabled;
    }
    get vsanNetworkDiagnosticModeEnabled() {
        return this.getBooleanAttribute('vsan_network_diagnostic_mode_enabled');
    }
    set vsanNetworkDiagnosticModeEnabled(value) {
        this._vsanNetworkDiagnosticModeEnabled = value;
    }
    resetVsanNetworkDiagnosticModeEnabled() {
        this._vsanNetworkDiagnosticModeEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanNetworkDiagnosticModeEnabledInput() {
        return this._vsanNetworkDiagnosticModeEnabled;
    }
    get vsanPerformanceEnabled() {
        return this.getBooleanAttribute('vsan_performance_enabled');
    }
    set vsanPerformanceEnabled(value) {
        this._vsanPerformanceEnabled = value;
    }
    resetVsanPerformanceEnabled() {
        this._vsanPerformanceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanPerformanceEnabledInput() {
        return this._vsanPerformanceEnabled;
    }
    get vsanRemoteDatastoreIds() {
        return cdktf.Fn.tolist(this.getListAttribute('vsan_remote_datastore_ids'));
    }
    set vsanRemoteDatastoreIds(value) {
        this._vsanRemoteDatastoreIds = value;
    }
    resetVsanRemoteDatastoreIds() {
        this._vsanRemoteDatastoreIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanRemoteDatastoreIdsInput() {
        return this._vsanRemoteDatastoreIds;
    }
    get vsanUnmapEnabled() {
        return this.getBooleanAttribute('vsan_unmap_enabled');
    }
    set vsanUnmapEnabled(value) {
        this._vsanUnmapEnabled = value;
    }
    resetVsanUnmapEnabled() {
        this._vsanUnmapEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanUnmapEnabledInput() {
        return this._vsanUnmapEnabled;
    }
    get vsanVerboseModeEnabled() {
        return this.getBooleanAttribute('vsan_verbose_mode_enabled');
    }
    set vsanVerboseModeEnabled(value) {
        this._vsanVerboseModeEnabled = value;
    }
    resetVsanVerboseModeEnabled() {
        this._vsanVerboseModeEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanVerboseModeEnabledInput() {
        return this._vsanVerboseModeEnabled;
    }
    get hostImage() {
        return this._hostImage;
    }
    putHostImage(value) {
        this._hostImage.internalValue = value;
    }
    resetHostImage() {
        this._hostImage.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostImageInput() {
        return this._hostImage.internalValue;
    }
    get vsanDiskGroup() {
        return this._vsanDiskGroup;
    }
    putVsanDiskGroup(value) {
        this._vsanDiskGroup.internalValue = value;
    }
    resetVsanDiskGroup() {
        this._vsanDiskGroup.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDiskGroupInput() {
        return this._vsanDiskGroup.internalValue;
    }
    get vsanFaultDomains() {
        return this._vsanFaultDomains;
    }
    putVsanFaultDomains(value) {
        this._vsanFaultDomains.internalValue = value;
    }
    resetVsanFaultDomains() {
        this._vsanFaultDomains.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanFaultDomainsInput() {
        return this._vsanFaultDomains.internalValue;
    }
    get vsanStretchedCluster() {
        return this._vsanStretchedCluster;
    }
    putVsanStretchedCluster(value) {
        this._vsanStretchedCluster.internalValue = value;
    }
    resetVsanStretchedCluster() {
        this._vsanStretchedCluster.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanStretchedClusterInput() {
        return this._vsanStretchedCluster.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            dpm_automation_level: cdktf.stringToTerraform(this._dpmAutomationLevel),
            dpm_enabled: cdktf.booleanToTerraform(this._dpmEnabled),
            dpm_threshold: cdktf.numberToTerraform(this._dpmThreshold),
            drs_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._drsAdvancedOptions),
            drs_automation_level: cdktf.stringToTerraform(this._drsAutomationLevel),
            drs_enable_predictive_drs: cdktf.booleanToTerraform(this._drsEnablePredictiveDrs),
            drs_enable_vm_overrides: cdktf.booleanToTerraform(this._drsEnableVmOverrides),
            drs_enabled: cdktf.booleanToTerraform(this._drsEnabled),
            drs_migration_threshold: cdktf.numberToTerraform(this._drsMigrationThreshold),
            drs_scale_descendants_shares: cdktf.stringToTerraform(this._drsScaleDescendantsShares),
            folder: cdktf.stringToTerraform(this._folder),
            force_evacuate_on_destroy: cdktf.booleanToTerraform(this._forceEvacuateOnDestroy),
            ha_admission_control_failover_host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haAdmissionControlFailoverHostSystemIds),
            ha_admission_control_host_failure_tolerance: cdktf.numberToTerraform(this._haAdmissionControlHostFailureTolerance),
            ha_admission_control_performance_tolerance: cdktf.numberToTerraform(this._haAdmissionControlPerformanceTolerance),
            ha_admission_control_policy: cdktf.stringToTerraform(this._haAdmissionControlPolicy),
            ha_admission_control_resource_percentage_auto_compute: cdktf.booleanToTerraform(this._haAdmissionControlResourcePercentageAutoCompute),
            ha_admission_control_resource_percentage_cpu: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageCpu),
            ha_admission_control_resource_percentage_memory: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageMemory),
            ha_admission_control_slot_policy_explicit_cpu: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitCpu),
            ha_admission_control_slot_policy_explicit_memory: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitMemory),
            ha_admission_control_slot_policy_use_explicit_size: cdktf.booleanToTerraform(this._haAdmissionControlSlotPolicyUseExplicitSize),
            ha_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._haAdvancedOptions),
            ha_datastore_apd_recovery_action: cdktf.stringToTerraform(this._haDatastoreApdRecoveryAction),
            ha_datastore_apd_response: cdktf.stringToTerraform(this._haDatastoreApdResponse),
            ha_datastore_apd_response_delay: cdktf.numberToTerraform(this._haDatastoreApdResponseDelay),
            ha_datastore_pdl_response: cdktf.stringToTerraform(this._haDatastorePdlResponse),
            ha_enabled: cdktf.booleanToTerraform(this._haEnabled),
            ha_heartbeat_datastore_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haHeartbeatDatastoreIds),
            ha_heartbeat_datastore_policy: cdktf.stringToTerraform(this._haHeartbeatDatastorePolicy),
            ha_host_isolation_response: cdktf.stringToTerraform(this._haHostIsolationResponse),
            ha_host_monitoring: cdktf.stringToTerraform(this._haHostMonitoring),
            ha_vm_component_protection: cdktf.stringToTerraform(this._haVmComponentProtection),
            ha_vm_dependency_restart_condition: cdktf.stringToTerraform(this._haVmDependencyRestartCondition),
            ha_vm_failure_interval: cdktf.numberToTerraform(this._haVmFailureInterval),
            ha_vm_maximum_failure_window: cdktf.numberToTerraform(this._haVmMaximumFailureWindow),
            ha_vm_maximum_resets: cdktf.numberToTerraform(this._haVmMaximumResets),
            ha_vm_minimum_uptime: cdktf.numberToTerraform(this._haVmMinimumUptime),
            ha_vm_monitoring: cdktf.stringToTerraform(this._haVmMonitoring),
            ha_vm_restart_additional_delay: cdktf.numberToTerraform(this._haVmRestartAdditionalDelay),
            ha_vm_restart_priority: cdktf.stringToTerraform(this._haVmRestartPriority),
            ha_vm_restart_timeout: cdktf.numberToTerraform(this._haVmRestartTimeout),
            host_cluster_exit_timeout: cdktf.numberToTerraform(this._hostClusterExitTimeout),
            host_managed: cdktf.booleanToTerraform(this._hostManaged),
            host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._hostSystemIds),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            proactive_ha_automation_level: cdktf.stringToTerraform(this._proactiveHaAutomationLevel),
            proactive_ha_enabled: cdktf.booleanToTerraform(this._proactiveHaEnabled),
            proactive_ha_moderate_remediation: cdktf.stringToTerraform(this._proactiveHaModerateRemediation),
            proactive_ha_provider_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._proactiveHaProviderIds),
            proactive_ha_severe_remediation: cdktf.stringToTerraform(this._proactiveHaSevereRemediation),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            vsan_compression_enabled: cdktf.booleanToTerraform(this._vsanCompressionEnabled),
            vsan_dedup_enabled: cdktf.booleanToTerraform(this._vsanDedupEnabled),
            vsan_dit_encryption_enabled: cdktf.booleanToTerraform(this._vsanDitEncryptionEnabled),
            vsan_dit_rekey_interval: cdktf.numberToTerraform(this._vsanDitRekeyInterval),
            vsan_enabled: cdktf.booleanToTerraform(this._vsanEnabled),
            vsan_esa_enabled: cdktf.booleanToTerraform(this._vsanEsaEnabled),
            vsan_network_diagnostic_mode_enabled: cdktf.booleanToTerraform(this._vsanNetworkDiagnosticModeEnabled),
            vsan_performance_enabled: cdktf.booleanToTerraform(this._vsanPerformanceEnabled),
            vsan_remote_datastore_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._vsanRemoteDatastoreIds),
            vsan_unmap_enabled: cdktf.booleanToTerraform(this._vsanUnmapEnabled),
            vsan_verbose_mode_enabled: cdktf.booleanToTerraform(this._vsanVerboseModeEnabled),
            host_image: computeClusterHostImageToTerraform(this._hostImage.internalValue),
            vsan_disk_group: cdktf.listMapper(computeClusterVsanDiskGroupToTerraform, true)(this._vsanDiskGroup.internalValue),
            vsan_fault_domains: cdktf.listMapper(computeClusterVsanFaultDomainsToTerraform, true)(this._vsanFaultDomains.internalValue),
            vsan_stretched_cluster: computeClusterVsanStretchedClusterToTerraform(this._vsanStretchedCluster.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            custom_attributes: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._customAttributes),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            datacenter_id: {
                value: cdktf.stringToHclTerraform(this._datacenterId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            dpm_automation_level: {
                value: cdktf.stringToHclTerraform(this._dpmAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            dpm_enabled: {
                value: cdktf.booleanToHclTerraform(this._dpmEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            dpm_threshold: {
                value: cdktf.numberToHclTerraform(this._dpmThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            drs_advanced_options: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._drsAdvancedOptions),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            drs_automation_level: {
                value: cdktf.stringToHclTerraform(this._drsAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            drs_enable_predictive_drs: {
                value: cdktf.booleanToHclTerraform(this._drsEnablePredictiveDrs),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            drs_enable_vm_overrides: {
                value: cdktf.booleanToHclTerraform(this._drsEnableVmOverrides),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            drs_enabled: {
                value: cdktf.booleanToHclTerraform(this._drsEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            drs_migration_threshold: {
                value: cdktf.numberToHclTerraform(this._drsMigrationThreshold),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            drs_scale_descendants_shares: {
                value: cdktf.stringToHclTerraform(this._drsScaleDescendantsShares),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            folder: {
                value: cdktf.stringToHclTerraform(this._folder),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            force_evacuate_on_destroy: {
                value: cdktf.booleanToHclTerraform(this._forceEvacuateOnDestroy),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_admission_control_failover_host_system_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._haAdmissionControlFailoverHostSystemIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            ha_admission_control_host_failure_tolerance: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlHostFailureTolerance),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_performance_tolerance: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlPerformanceTolerance),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_policy: {
                value: cdktf.stringToHclTerraform(this._haAdmissionControlPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_admission_control_resource_percentage_auto_compute: {
                value: cdktf.booleanToHclTerraform(this._haAdmissionControlResourcePercentageAutoCompute),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_admission_control_resource_percentage_cpu: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlResourcePercentageCpu),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_resource_percentage_memory: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlResourcePercentageMemory),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_slot_policy_explicit_cpu: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlSlotPolicyExplicitCpu),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_slot_policy_explicit_memory: {
                value: cdktf.numberToHclTerraform(this._haAdmissionControlSlotPolicyExplicitMemory),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_admission_control_slot_policy_use_explicit_size: {
                value: cdktf.booleanToHclTerraform(this._haAdmissionControlSlotPolicyUseExplicitSize),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_advanced_options: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._haAdvancedOptions),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            ha_datastore_apd_recovery_action: {
                value: cdktf.stringToHclTerraform(this._haDatastoreApdRecoveryAction),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_datastore_apd_response: {
                value: cdktf.stringToHclTerraform(this._haDatastoreApdResponse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_datastore_apd_response_delay: {
                value: cdktf.numberToHclTerraform(this._haDatastoreApdResponseDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_datastore_pdl_response: {
                value: cdktf.stringToHclTerraform(this._haDatastorePdlResponse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_enabled: {
                value: cdktf.booleanToHclTerraform(this._haEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ha_heartbeat_datastore_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._haHeartbeatDatastoreIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            ha_heartbeat_datastore_policy: {
                value: cdktf.stringToHclTerraform(this._haHeartbeatDatastorePolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_host_isolation_response: {
                value: cdktf.stringToHclTerraform(this._haHostIsolationResponse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_host_monitoring: {
                value: cdktf.stringToHclTerraform(this._haHostMonitoring),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_component_protection: {
                value: cdktf.stringToHclTerraform(this._haVmComponentProtection),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_dependency_restart_condition: {
                value: cdktf.stringToHclTerraform(this._haVmDependencyRestartCondition),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_failure_interval: {
                value: cdktf.numberToHclTerraform(this._haVmFailureInterval),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_maximum_failure_window: {
                value: cdktf.numberToHclTerraform(this._haVmMaximumFailureWindow),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_maximum_resets: {
                value: cdktf.numberToHclTerraform(this._haVmMaximumResets),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_minimum_uptime: {
                value: cdktf.numberToHclTerraform(this._haVmMinimumUptime),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_monitoring: {
                value: cdktf.stringToHclTerraform(this._haVmMonitoring),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_restart_additional_delay: {
                value: cdktf.numberToHclTerraform(this._haVmRestartAdditionalDelay),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ha_vm_restart_priority: {
                value: cdktf.stringToHclTerraform(this._haVmRestartPriority),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ha_vm_restart_timeout: {
                value: cdktf.numberToHclTerraform(this._haVmRestartTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            host_cluster_exit_timeout: {
                value: cdktf.numberToHclTerraform(this._hostClusterExitTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            host_managed: {
                value: cdktf.booleanToHclTerraform(this._hostManaged),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            host_system_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._hostSystemIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            proactive_ha_automation_level: {
                value: cdktf.stringToHclTerraform(this._proactiveHaAutomationLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            proactive_ha_enabled: {
                value: cdktf.booleanToHclTerraform(this._proactiveHaEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            proactive_ha_moderate_remediation: {
                value: cdktf.stringToHclTerraform(this._proactiveHaModerateRemediation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            proactive_ha_provider_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._proactiveHaProviderIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            proactive_ha_severe_remediation: {
                value: cdktf.stringToHclTerraform(this._proactiveHaSevereRemediation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            vsan_compression_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanCompressionEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_dedup_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanDedupEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_dit_encryption_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanDitEncryptionEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_dit_rekey_interval: {
                value: cdktf.numberToHclTerraform(this._vsanDitRekeyInterval),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            vsan_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_esa_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanEsaEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_network_diagnostic_mode_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanNetworkDiagnosticModeEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_performance_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanPerformanceEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_remote_datastore_ids: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._vsanRemoteDatastoreIds),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            vsan_unmap_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanUnmapEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vsan_verbose_mode_enabled: {
                value: cdktf.booleanToHclTerraform(this._vsanVerboseModeEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            host_image: {
                value: computeClusterHostImageToHclTerraform(this._hostImage.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "ComputeClusterHostImageList",
            },
            vsan_disk_group: {
                value: cdktf.listMapperHcl(computeClusterVsanDiskGroupToHclTerraform, true)(this._vsanDiskGroup.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "ComputeClusterVsanDiskGroupList",
            },
            vsan_fault_domains: {
                value: cdktf.listMapperHcl(computeClusterVsanFaultDomainsToHclTerraform, true)(this._vsanFaultDomains.internalValue),
                isBlock: true,
                type: "set",
                storageClassType: "ComputeClusterVsanFaultDomainsList",
            },
            vsan_stretched_cluster: {
                value: computeClusterVsanStretchedClusterToHclTerraform(this._vsanStretchedCluster.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "ComputeClusterVsanStretchedClusterList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.ComputeCluster = ComputeCluster;
_l = JSII_RTTI_SYMBOL_1;
ComputeCluster[_l] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeCluster", version: "9.3.2" };
// =================
// STATIC PROPERTIES
// =================
ComputeCluster.tfResourceType = "vsphere_compute_cluster";
//# sourceMappingURL=data:application/json;base64,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