/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CustomAttributeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/custom_attribute#id CustomAttribute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Object type for which the custom attribute is valid. If not specified, the attribute is valid for all managed object types.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/custom_attribute#managed_object_type CustomAttribute#managed_object_type}
    */
    readonly managedObjectType?: string;
    /**
    * The display name of the custom attribute.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/custom_attribute#name CustomAttribute#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/custom_attribute vsphere_custom_attribute}
*/
export declare class CustomAttribute extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_custom_attribute";
    /**
    * Generates CDKTF code for importing a CustomAttribute resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CustomAttribute to import
    * @param importFromId The id of the existing CustomAttribute that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/custom_attribute#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CustomAttribute to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/custom_attribute vsphere_custom_attribute} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CustomAttributeConfig
    */
    constructor(scope: Construct, id: string, config: CustomAttributeConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedObjectType?;
    get managedObjectType(): string;
    set managedObjectType(value: string);
    resetManagedObjectType(): void;
    get managedObjectTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
