/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereGuestOsCustomizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/data-sources/guest_os_customization#id DataVsphereGuestOsCustomization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the customization specification is the unique identifier per vCenter Server instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/data-sources/guest_os_customization#name DataVsphereGuestOsCustomization#name}
    */
    readonly name: string;
}
export interface DataVsphereGuestOsCustomizationSpecLinuxOptions {
}
export declare function dataVsphereGuestOsCustomizationSpecLinuxOptionsToTerraform(struct?: DataVsphereGuestOsCustomizationSpecLinuxOptions): any;
export declare function dataVsphereGuestOsCustomizationSpecLinuxOptionsToHclTerraform(struct?: DataVsphereGuestOsCustomizationSpecLinuxOptions): any;
export declare class DataVsphereGuestOsCustomizationSpecLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVsphereGuestOsCustomizationSpecLinuxOptions | undefined;
    set internalValue(value: DataVsphereGuestOsCustomizationSpecLinuxOptions | undefined);
    get domain(): string;
    get hostName(): string;
    get hwClockUtc(): cdktf.IResolvable;
    get scriptText(): string;
    get timeZone(): string;
}
export declare class DataVsphereGuestOsCustomizationSpecLinuxOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVsphereGuestOsCustomizationSpecLinuxOptionsOutputReference;
}
export interface DataVsphereGuestOsCustomizationSpecNetworkInterface {
}
export declare function dataVsphereGuestOsCustomizationSpecNetworkInterfaceToTerraform(struct?: DataVsphereGuestOsCustomizationSpecNetworkInterface): any;
export declare function dataVsphereGuestOsCustomizationSpecNetworkInterfaceToHclTerraform(struct?: DataVsphereGuestOsCustomizationSpecNetworkInterface): any;
export declare class DataVsphereGuestOsCustomizationSpecNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVsphereGuestOsCustomizationSpecNetworkInterface | undefined;
    set internalValue(value: DataVsphereGuestOsCustomizationSpecNetworkInterface | undefined);
    get dnsDomain(): string;
    get dnsServerList(): string[];
    get ipv4Address(): string;
    get ipv4Netmask(): number;
    get ipv6Address(): string;
    get ipv6Netmask(): number;
}
export declare class DataVsphereGuestOsCustomizationSpecNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVsphereGuestOsCustomizationSpecNetworkInterfaceOutputReference;
}
export interface DataVsphereGuestOsCustomizationSpecWindowsOptions {
}
export declare function dataVsphereGuestOsCustomizationSpecWindowsOptionsToTerraform(struct?: DataVsphereGuestOsCustomizationSpecWindowsOptions): any;
export declare function dataVsphereGuestOsCustomizationSpecWindowsOptionsToHclTerraform(struct?: DataVsphereGuestOsCustomizationSpecWindowsOptions): any;
export declare class DataVsphereGuestOsCustomizationSpecWindowsOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVsphereGuestOsCustomizationSpecWindowsOptions | undefined;
    set internalValue(value: DataVsphereGuestOsCustomizationSpecWindowsOptions | undefined);
    get adminPassword(): string;
    get autoLogon(): cdktf.IResolvable;
    get autoLogonCount(): number;
    get computerName(): string;
    get domainAdminPassword(): string;
    get domainAdminUser(): string;
    get domainOu(): string;
    get joinDomain(): string;
    get runOnceCommandList(): string[];
    get timeZone(): number;
    get workgroup(): string;
}
export declare class DataVsphereGuestOsCustomizationSpecWindowsOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVsphereGuestOsCustomizationSpecWindowsOptionsOutputReference;
}
export interface DataVsphereGuestOsCustomizationSpec {
}
export declare function dataVsphereGuestOsCustomizationSpecToTerraform(struct?: DataVsphereGuestOsCustomizationSpec): any;
export declare function dataVsphereGuestOsCustomizationSpecToHclTerraform(struct?: DataVsphereGuestOsCustomizationSpec): any;
export declare class DataVsphereGuestOsCustomizationSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVsphereGuestOsCustomizationSpec | undefined;
    set internalValue(value: DataVsphereGuestOsCustomizationSpec | undefined);
    get dnsServerList(): string[];
    get dnsSuffixList(): string[];
    private _linuxOptions;
    get linuxOptions(): DataVsphereGuestOsCustomizationSpecLinuxOptionsList;
    private _networkInterface;
    get networkInterface(): DataVsphereGuestOsCustomizationSpecNetworkInterfaceList;
    private _windowsOptions;
    get windowsOptions(): DataVsphereGuestOsCustomizationSpecWindowsOptionsList;
    get windowsSysprepText(): string;
}
export declare class DataVsphereGuestOsCustomizationSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVsphereGuestOsCustomizationSpecOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/data-sources/guest_os_customization vsphere_guest_os_customization}
*/
export declare class DataVsphereGuestOsCustomization extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_guest_os_customization";
    /**
    * Generates CDKTF code for importing a DataVsphereGuestOsCustomization resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereGuestOsCustomization to import
    * @param importFromId The id of the existing DataVsphereGuestOsCustomization that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/data-sources/guest_os_customization#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereGuestOsCustomization to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/data-sources/guest_os_customization vsphere_guest_os_customization} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereGuestOsCustomizationConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereGuestOsCustomizationConfig);
    get changeVersion(): string;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastUpdateTime(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _spec;
    get spec(): DataVsphereGuestOsCustomizationSpecList;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
