/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereLicenseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/data-sources/license#license_key DataVsphereLicense#license_key}
    */
    readonly licenseKey: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/data-sources/license vsphere_license}
*/
export declare class DataVsphereLicense extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_license";
    /**
    * Generates CDKTF code for importing a DataVsphereLicense resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataVsphereLicense to import
    * @param importFromId The id of the existing DataVsphereLicense that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/data-sources/license#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataVsphereLicense to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/data-sources/license vsphere_license} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereLicenseConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereLicenseConfig);
    get editionKey(): string;
    get id(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    private _licenseKey?;
    get licenseKey(): string;
    set licenseKey(value: string);
    get licenseKeyInput(): string | undefined;
    get name(): string;
    get total(): number;
    get used(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
