"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DistributedPortGroup = exports.DistributedPortGroupVlanRangeList = exports.DistributedPortGroupVlanRangeOutputReference = exports.distributedPortGroupVlanRangeToHclTerraform = exports.distributedPortGroupVlanRangeToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function distributedPortGroupVlanRangeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_vlan: cdktf.numberToTerraform(struct.maxVlan),
        min_vlan: cdktf.numberToTerraform(struct.minVlan),
    };
}
exports.distributedPortGroupVlanRangeToTerraform = distributedPortGroupVlanRangeToTerraform;
function distributedPortGroupVlanRangeToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        max_vlan: {
            value: cdktf.numberToHclTerraform(struct.maxVlan),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
        min_vlan: {
            value: cdktf.numberToHclTerraform(struct.minVlan),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.distributedPortGroupVlanRangeToHclTerraform = distributedPortGroupVlanRangeToHclTerraform;
class DistributedPortGroupVlanRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxVlan !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxVlan = this._maxVlan;
        }
        if (this._minVlan !== undefined) {
            hasAnyValues = true;
            internalValueResult.minVlan = this._minVlan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._maxVlan = undefined;
            this._minVlan = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._maxVlan = value.maxVlan;
            this._minVlan = value.minVlan;
        }
    }
    get maxVlan() {
        return this.getNumberAttribute('max_vlan');
    }
    set maxVlan(value) {
        this._maxVlan = value;
    }
    // Temporarily expose input value. Use with caution.
    get maxVlanInput() {
        return this._maxVlan;
    }
    get minVlan() {
        return this.getNumberAttribute('min_vlan');
    }
    set minVlan(value) {
        this._minVlan = value;
    }
    // Temporarily expose input value. Use with caution.
    get minVlanInput() {
        return this._minVlan;
    }
}
exports.DistributedPortGroupVlanRangeOutputReference = DistributedPortGroupVlanRangeOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DistributedPortGroupVlanRangeOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.distributedPortGroup.DistributedPortGroupVlanRangeOutputReference", version: "9.3.2" };
class DistributedPortGroupVlanRangeList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DistributedPortGroupVlanRangeOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DistributedPortGroupVlanRangeList = DistributedPortGroupVlanRangeList;
_b = JSII_RTTI_SYMBOL_1;
DistributedPortGroupVlanRangeList[_b] = { fqn: "@cdktf/provider-vsphere.distributedPortGroup.DistributedPortGroupVlanRangeList", version: "9.3.2" };
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_port_group vsphere_distributed_port_group}
*/
class DistributedPortGroup extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a DistributedPortGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DistributedPortGroup to import
    * @param importFromId The id of the existing DistributedPortGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_port_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DistributedPortGroup to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "vsphere_distributed_port_group", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_port_group vsphere_distributed_port_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DistributedPortGroupConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_distributed_port_group',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.9.2',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // vlan_range - computed: false, optional: true, required: false
        this._vlanRange = new DistributedPortGroupVlanRangeList(this, "vlan_range", true);
        this._activeUplinks = config.activeUplinks;
        this._allowForgedTransmits = config.allowForgedTransmits;
        this._allowMacChanges = config.allowMacChanges;
        this._allowPromiscuous = config.allowPromiscuous;
        this._autoExpand = config.autoExpand;
        this._blockAllPorts = config.blockAllPorts;
        this._blockOverrideAllowed = config.blockOverrideAllowed;
        this._checkBeacon = config.checkBeacon;
        this._customAttributes = config.customAttributes;
        this._description = config.description;
        this._directpathGen2Allowed = config.directpathGen2Allowed;
        this._distributedVirtualSwitchUuid = config.distributedVirtualSwitchUuid;
        this._egressShapingAverageBandwidth = config.egressShapingAverageBandwidth;
        this._egressShapingBurstSize = config.egressShapingBurstSize;
        this._egressShapingEnabled = config.egressShapingEnabled;
        this._egressShapingPeakBandwidth = config.egressShapingPeakBandwidth;
        this._failback = config.failback;
        this._id = config.id;
        this._ingressShapingAverageBandwidth = config.ingressShapingAverageBandwidth;
        this._ingressShapingBurstSize = config.ingressShapingBurstSize;
        this._ingressShapingEnabled = config.ingressShapingEnabled;
        this._ingressShapingPeakBandwidth = config.ingressShapingPeakBandwidth;
        this._lacpEnabled = config.lacpEnabled;
        this._lacpMode = config.lacpMode;
        this._livePortMovingAllowed = config.livePortMovingAllowed;
        this._name = config.name;
        this._netflowEnabled = config.netflowEnabled;
        this._netflowOverrideAllowed = config.netflowOverrideAllowed;
        this._networkResourcePoolKey = config.networkResourcePoolKey;
        this._networkResourcePoolOverrideAllowed = config.networkResourcePoolOverrideAllowed;
        this._notifySwitches = config.notifySwitches;
        this._numberOfPorts = config.numberOfPorts;
        this._portConfigResetAtDisconnect = config.portConfigResetAtDisconnect;
        this._portNameFormat = config.portNameFormat;
        this._portPrivateSecondaryVlanId = config.portPrivateSecondaryVlanId;
        this._securityPolicyOverrideAllowed = config.securityPolicyOverrideAllowed;
        this._shapingOverrideAllowed = config.shapingOverrideAllowed;
        this._standbyUplinks = config.standbyUplinks;
        this._tags = config.tags;
        this._teamingPolicy = config.teamingPolicy;
        this._trafficFilterOverrideAllowed = config.trafficFilterOverrideAllowed;
        this._txUplink = config.txUplink;
        this._type = config.type;
        this._uplinkTeamingOverrideAllowed = config.uplinkTeamingOverrideAllowed;
        this._vlanId = config.vlanId;
        this._vlanOverrideAllowed = config.vlanOverrideAllowed;
        this._vlanRange.internalValue = config.vlanRange;
    }
    get activeUplinks() {
        return this.getListAttribute('active_uplinks');
    }
    set activeUplinks(value) {
        this._activeUplinks = value;
    }
    resetActiveUplinks() {
        this._activeUplinks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get activeUplinksInput() {
        return this._activeUplinks;
    }
    get allowForgedTransmits() {
        return this.getBooleanAttribute('allow_forged_transmits');
    }
    set allowForgedTransmits(value) {
        this._allowForgedTransmits = value;
    }
    resetAllowForgedTransmits() {
        this._allowForgedTransmits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowForgedTransmitsInput() {
        return this._allowForgedTransmits;
    }
    get allowMacChanges() {
        return this.getBooleanAttribute('allow_mac_changes');
    }
    set allowMacChanges(value) {
        this._allowMacChanges = value;
    }
    resetAllowMacChanges() {
        this._allowMacChanges = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMacChangesInput() {
        return this._allowMacChanges;
    }
    get allowPromiscuous() {
        return this.getBooleanAttribute('allow_promiscuous');
    }
    set allowPromiscuous(value) {
        this._allowPromiscuous = value;
    }
    resetAllowPromiscuous() {
        this._allowPromiscuous = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowPromiscuousInput() {
        return this._allowPromiscuous;
    }
    get autoExpand() {
        return this.getBooleanAttribute('auto_expand');
    }
    set autoExpand(value) {
        this._autoExpand = value;
    }
    resetAutoExpand() {
        this._autoExpand = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoExpandInput() {
        return this._autoExpand;
    }
    get blockAllPorts() {
        return this.getBooleanAttribute('block_all_ports');
    }
    set blockAllPorts(value) {
        this._blockAllPorts = value;
    }
    resetBlockAllPorts() {
        this._blockAllPorts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blockAllPortsInput() {
        return this._blockAllPorts;
    }
    get blockOverrideAllowed() {
        return this.getBooleanAttribute('block_override_allowed');
    }
    set blockOverrideAllowed(value) {
        this._blockOverrideAllowed = value;
    }
    resetBlockOverrideAllowed() {
        this._blockOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blockOverrideAllowedInput() {
        return this._blockOverrideAllowed;
    }
    get checkBeacon() {
        return this.getBooleanAttribute('check_beacon');
    }
    set checkBeacon(value) {
        this._checkBeacon = value;
    }
    resetCheckBeacon() {
        this._checkBeacon = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get checkBeaconInput() {
        return this._checkBeacon;
    }
    // config_version - computed: true, optional: false, required: false
    get configVersion() {
        return this.getStringAttribute('config_version');
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get directpathGen2Allowed() {
        return this.getBooleanAttribute('directpath_gen2_allowed');
    }
    set directpathGen2Allowed(value) {
        this._directpathGen2Allowed = value;
    }
    resetDirectpathGen2Allowed() {
        this._directpathGen2Allowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get directpathGen2AllowedInput() {
        return this._directpathGen2Allowed;
    }
    get distributedVirtualSwitchUuid() {
        return this.getStringAttribute('distributed_virtual_switch_uuid');
    }
    set distributedVirtualSwitchUuid(value) {
        this._distributedVirtualSwitchUuid = value;
    }
    // Temporarily expose input value. Use with caution.
    get distributedVirtualSwitchUuidInput() {
        return this._distributedVirtualSwitchUuid;
    }
    get egressShapingAverageBandwidth() {
        return this.getNumberAttribute('egress_shaping_average_bandwidth');
    }
    set egressShapingAverageBandwidth(value) {
        this._egressShapingAverageBandwidth = value;
    }
    resetEgressShapingAverageBandwidth() {
        this._egressShapingAverageBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingAverageBandwidthInput() {
        return this._egressShapingAverageBandwidth;
    }
    get egressShapingBurstSize() {
        return this.getNumberAttribute('egress_shaping_burst_size');
    }
    set egressShapingBurstSize(value) {
        this._egressShapingBurstSize = value;
    }
    resetEgressShapingBurstSize() {
        this._egressShapingBurstSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingBurstSizeInput() {
        return this._egressShapingBurstSize;
    }
    get egressShapingEnabled() {
        return this.getBooleanAttribute('egress_shaping_enabled');
    }
    set egressShapingEnabled(value) {
        this._egressShapingEnabled = value;
    }
    resetEgressShapingEnabled() {
        this._egressShapingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingEnabledInput() {
        return this._egressShapingEnabled;
    }
    get egressShapingPeakBandwidth() {
        return this.getNumberAttribute('egress_shaping_peak_bandwidth');
    }
    set egressShapingPeakBandwidth(value) {
        this._egressShapingPeakBandwidth = value;
    }
    resetEgressShapingPeakBandwidth() {
        this._egressShapingPeakBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get egressShapingPeakBandwidthInput() {
        return this._egressShapingPeakBandwidth;
    }
    get failback() {
        return this.getBooleanAttribute('failback');
    }
    set failback(value) {
        this._failback = value;
    }
    resetFailback() {
        this._failback = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failbackInput() {
        return this._failback;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ingressShapingAverageBandwidth() {
        return this.getNumberAttribute('ingress_shaping_average_bandwidth');
    }
    set ingressShapingAverageBandwidth(value) {
        this._ingressShapingAverageBandwidth = value;
    }
    resetIngressShapingAverageBandwidth() {
        this._ingressShapingAverageBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingAverageBandwidthInput() {
        return this._ingressShapingAverageBandwidth;
    }
    get ingressShapingBurstSize() {
        return this.getNumberAttribute('ingress_shaping_burst_size');
    }
    set ingressShapingBurstSize(value) {
        this._ingressShapingBurstSize = value;
    }
    resetIngressShapingBurstSize() {
        this._ingressShapingBurstSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingBurstSizeInput() {
        return this._ingressShapingBurstSize;
    }
    get ingressShapingEnabled() {
        return this.getBooleanAttribute('ingress_shaping_enabled');
    }
    set ingressShapingEnabled(value) {
        this._ingressShapingEnabled = value;
    }
    resetIngressShapingEnabled() {
        this._ingressShapingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingEnabledInput() {
        return this._ingressShapingEnabled;
    }
    get ingressShapingPeakBandwidth() {
        return this.getNumberAttribute('ingress_shaping_peak_bandwidth');
    }
    set ingressShapingPeakBandwidth(value) {
        this._ingressShapingPeakBandwidth = value;
    }
    resetIngressShapingPeakBandwidth() {
        this._ingressShapingPeakBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressShapingPeakBandwidthInput() {
        return this._ingressShapingPeakBandwidth;
    }
    // key - computed: true, optional: false, required: false
    get key() {
        return this.getStringAttribute('key');
    }
    get lacpEnabled() {
        return this.getBooleanAttribute('lacp_enabled');
    }
    set lacpEnabled(value) {
        this._lacpEnabled = value;
    }
    resetLacpEnabled() {
        this._lacpEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lacpEnabledInput() {
        return this._lacpEnabled;
    }
    get lacpMode() {
        return this.getStringAttribute('lacp_mode');
    }
    set lacpMode(value) {
        this._lacpMode = value;
    }
    resetLacpMode() {
        this._lacpMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lacpModeInput() {
        return this._lacpMode;
    }
    get livePortMovingAllowed() {
        return this.getBooleanAttribute('live_port_moving_allowed');
    }
    set livePortMovingAllowed(value) {
        this._livePortMovingAllowed = value;
    }
    resetLivePortMovingAllowed() {
        this._livePortMovingAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get livePortMovingAllowedInput() {
        return this._livePortMovingAllowed;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get netflowEnabled() {
        return this.getBooleanAttribute('netflow_enabled');
    }
    set netflowEnabled(value) {
        this._netflowEnabled = value;
    }
    resetNetflowEnabled() {
        this._netflowEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowEnabledInput() {
        return this._netflowEnabled;
    }
    get netflowOverrideAllowed() {
        return this.getBooleanAttribute('netflow_override_allowed');
    }
    set netflowOverrideAllowed(value) {
        this._netflowOverrideAllowed = value;
    }
    resetNetflowOverrideAllowed() {
        this._netflowOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netflowOverrideAllowedInput() {
        return this._netflowOverrideAllowed;
    }
    get networkResourcePoolKey() {
        return this.getStringAttribute('network_resource_pool_key');
    }
    set networkResourcePoolKey(value) {
        this._networkResourcePoolKey = value;
    }
    resetNetworkResourcePoolKey() {
        this._networkResourcePoolKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkResourcePoolKeyInput() {
        return this._networkResourcePoolKey;
    }
    get networkResourcePoolOverrideAllowed() {
        return this.getBooleanAttribute('network_resource_pool_override_allowed');
    }
    set networkResourcePoolOverrideAllowed(value) {
        this._networkResourcePoolOverrideAllowed = value;
    }
    resetNetworkResourcePoolOverrideAllowed() {
        this._networkResourcePoolOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkResourcePoolOverrideAllowedInput() {
        return this._networkResourcePoolOverrideAllowed;
    }
    get notifySwitches() {
        return this.getBooleanAttribute('notify_switches');
    }
    set notifySwitches(value) {
        this._notifySwitches = value;
    }
    resetNotifySwitches() {
        this._notifySwitches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifySwitchesInput() {
        return this._notifySwitches;
    }
    get numberOfPorts() {
        return this.getNumberAttribute('number_of_ports');
    }
    set numberOfPorts(value) {
        this._numberOfPorts = value;
    }
    resetNumberOfPorts() {
        this._numberOfPorts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numberOfPortsInput() {
        return this._numberOfPorts;
    }
    get portConfigResetAtDisconnect() {
        return this.getBooleanAttribute('port_config_reset_at_disconnect');
    }
    set portConfigResetAtDisconnect(value) {
        this._portConfigResetAtDisconnect = value;
    }
    resetPortConfigResetAtDisconnect() {
        this._portConfigResetAtDisconnect = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portConfigResetAtDisconnectInput() {
        return this._portConfigResetAtDisconnect;
    }
    get portNameFormat() {
        return this.getStringAttribute('port_name_format');
    }
    set portNameFormat(value) {
        this._portNameFormat = value;
    }
    resetPortNameFormat() {
        this._portNameFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portNameFormatInput() {
        return this._portNameFormat;
    }
    get portPrivateSecondaryVlanId() {
        return this.getNumberAttribute('port_private_secondary_vlan_id');
    }
    set portPrivateSecondaryVlanId(value) {
        this._portPrivateSecondaryVlanId = value;
    }
    resetPortPrivateSecondaryVlanId() {
        this._portPrivateSecondaryVlanId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portPrivateSecondaryVlanIdInput() {
        return this._portPrivateSecondaryVlanId;
    }
    get securityPolicyOverrideAllowed() {
        return this.getBooleanAttribute('security_policy_override_allowed');
    }
    set securityPolicyOverrideAllowed(value) {
        this._securityPolicyOverrideAllowed = value;
    }
    resetSecurityPolicyOverrideAllowed() {
        this._securityPolicyOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityPolicyOverrideAllowedInput() {
        return this._securityPolicyOverrideAllowed;
    }
    get shapingOverrideAllowed() {
        return this.getBooleanAttribute('shaping_override_allowed');
    }
    set shapingOverrideAllowed(value) {
        this._shapingOverrideAllowed = value;
    }
    resetShapingOverrideAllowed() {
        this._shapingOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shapingOverrideAllowedInput() {
        return this._shapingOverrideAllowed;
    }
    get standbyUplinks() {
        return this.getListAttribute('standby_uplinks');
    }
    set standbyUplinks(value) {
        this._standbyUplinks = value;
    }
    resetStandbyUplinks() {
        this._standbyUplinks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get standbyUplinksInput() {
        return this._standbyUplinks;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get teamingPolicy() {
        return this.getStringAttribute('teaming_policy');
    }
    set teamingPolicy(value) {
        this._teamingPolicy = value;
    }
    resetTeamingPolicy() {
        this._teamingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get teamingPolicyInput() {
        return this._teamingPolicy;
    }
    get trafficFilterOverrideAllowed() {
        return this.getBooleanAttribute('traffic_filter_override_allowed');
    }
    set trafficFilterOverrideAllowed(value) {
        this._trafficFilterOverrideAllowed = value;
    }
    resetTrafficFilterOverrideAllowed() {
        this._trafficFilterOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trafficFilterOverrideAllowedInput() {
        return this._trafficFilterOverrideAllowed;
    }
    get txUplink() {
        return this.getBooleanAttribute('tx_uplink');
    }
    set txUplink(value) {
        this._txUplink = value;
    }
    resetTxUplink() {
        this._txUplink = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get txUplinkInput() {
        return this._txUplink;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get uplinkTeamingOverrideAllowed() {
        return this.getBooleanAttribute('uplink_teaming_override_allowed');
    }
    set uplinkTeamingOverrideAllowed(value) {
        this._uplinkTeamingOverrideAllowed = value;
    }
    resetUplinkTeamingOverrideAllowed() {
        this._uplinkTeamingOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uplinkTeamingOverrideAllowedInput() {
        return this._uplinkTeamingOverrideAllowed;
    }
    get vlanId() {
        return this.getNumberAttribute('vlan_id');
    }
    set vlanId(value) {
        this._vlanId = value;
    }
    resetVlanId() {
        this._vlanId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanIdInput() {
        return this._vlanId;
    }
    get vlanOverrideAllowed() {
        return this.getBooleanAttribute('vlan_override_allowed');
    }
    set vlanOverrideAllowed(value) {
        this._vlanOverrideAllowed = value;
    }
    resetVlanOverrideAllowed() {
        this._vlanOverrideAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanOverrideAllowedInput() {
        return this._vlanOverrideAllowed;
    }
    get vlanRange() {
        return this._vlanRange;
    }
    putVlanRange(value) {
        this._vlanRange.internalValue = value;
    }
    resetVlanRange() {
        this._vlanRange.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanRangeInput() {
        return this._vlanRange.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            active_uplinks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._activeUplinks),
            allow_forged_transmits: cdktf.booleanToTerraform(this._allowForgedTransmits),
            allow_mac_changes: cdktf.booleanToTerraform(this._allowMacChanges),
            allow_promiscuous: cdktf.booleanToTerraform(this._allowPromiscuous),
            auto_expand: cdktf.booleanToTerraform(this._autoExpand),
            block_all_ports: cdktf.booleanToTerraform(this._blockAllPorts),
            block_override_allowed: cdktf.booleanToTerraform(this._blockOverrideAllowed),
            check_beacon: cdktf.booleanToTerraform(this._checkBeacon),
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            description: cdktf.stringToTerraform(this._description),
            directpath_gen2_allowed: cdktf.booleanToTerraform(this._directpathGen2Allowed),
            distributed_virtual_switch_uuid: cdktf.stringToTerraform(this._distributedVirtualSwitchUuid),
            egress_shaping_average_bandwidth: cdktf.numberToTerraform(this._egressShapingAverageBandwidth),
            egress_shaping_burst_size: cdktf.numberToTerraform(this._egressShapingBurstSize),
            egress_shaping_enabled: cdktf.booleanToTerraform(this._egressShapingEnabled),
            egress_shaping_peak_bandwidth: cdktf.numberToTerraform(this._egressShapingPeakBandwidth),
            failback: cdktf.booleanToTerraform(this._failback),
            id: cdktf.stringToTerraform(this._id),
            ingress_shaping_average_bandwidth: cdktf.numberToTerraform(this._ingressShapingAverageBandwidth),
            ingress_shaping_burst_size: cdktf.numberToTerraform(this._ingressShapingBurstSize),
            ingress_shaping_enabled: cdktf.booleanToTerraform(this._ingressShapingEnabled),
            ingress_shaping_peak_bandwidth: cdktf.numberToTerraform(this._ingressShapingPeakBandwidth),
            lacp_enabled: cdktf.booleanToTerraform(this._lacpEnabled),
            lacp_mode: cdktf.stringToTerraform(this._lacpMode),
            live_port_moving_allowed: cdktf.booleanToTerraform(this._livePortMovingAllowed),
            name: cdktf.stringToTerraform(this._name),
            netflow_enabled: cdktf.booleanToTerraform(this._netflowEnabled),
            netflow_override_allowed: cdktf.booleanToTerraform(this._netflowOverrideAllowed),
            network_resource_pool_key: cdktf.stringToTerraform(this._networkResourcePoolKey),
            network_resource_pool_override_allowed: cdktf.booleanToTerraform(this._networkResourcePoolOverrideAllowed),
            notify_switches: cdktf.booleanToTerraform(this._notifySwitches),
            number_of_ports: cdktf.numberToTerraform(this._numberOfPorts),
            port_config_reset_at_disconnect: cdktf.booleanToTerraform(this._portConfigResetAtDisconnect),
            port_name_format: cdktf.stringToTerraform(this._portNameFormat),
            port_private_secondary_vlan_id: cdktf.numberToTerraform(this._portPrivateSecondaryVlanId),
            security_policy_override_allowed: cdktf.booleanToTerraform(this._securityPolicyOverrideAllowed),
            shaping_override_allowed: cdktf.booleanToTerraform(this._shapingOverrideAllowed),
            standby_uplinks: cdktf.listMapper(cdktf.stringToTerraform, false)(this._standbyUplinks),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            teaming_policy: cdktf.stringToTerraform(this._teamingPolicy),
            traffic_filter_override_allowed: cdktf.booleanToTerraform(this._trafficFilterOverrideAllowed),
            tx_uplink: cdktf.booleanToTerraform(this._txUplink),
            type: cdktf.stringToTerraform(this._type),
            uplink_teaming_override_allowed: cdktf.booleanToTerraform(this._uplinkTeamingOverrideAllowed),
            vlan_id: cdktf.numberToTerraform(this._vlanId),
            vlan_override_allowed: cdktf.booleanToTerraform(this._vlanOverrideAllowed),
            vlan_range: cdktf.listMapper(distributedPortGroupVlanRangeToTerraform, true)(this._vlanRange.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            active_uplinks: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._activeUplinks),
                isBlock: false,
                type: "list",
                storageClassType: "stringList",
            },
            allow_forged_transmits: {
                value: cdktf.booleanToHclTerraform(this._allowForgedTransmits),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            allow_mac_changes: {
                value: cdktf.booleanToHclTerraform(this._allowMacChanges),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            allow_promiscuous: {
                value: cdktf.booleanToHclTerraform(this._allowPromiscuous),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            auto_expand: {
                value: cdktf.booleanToHclTerraform(this._autoExpand),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            block_all_ports: {
                value: cdktf.booleanToHclTerraform(this._blockAllPorts),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            block_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._blockOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            check_beacon: {
                value: cdktf.booleanToHclTerraform(this._checkBeacon),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            custom_attributes: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._customAttributes),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            description: {
                value: cdktf.stringToHclTerraform(this._description),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            directpath_gen2_allowed: {
                value: cdktf.booleanToHclTerraform(this._directpathGen2Allowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            distributed_virtual_switch_uuid: {
                value: cdktf.stringToHclTerraform(this._distributedVirtualSwitchUuid),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            egress_shaping_average_bandwidth: {
                value: cdktf.numberToHclTerraform(this._egressShapingAverageBandwidth),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            egress_shaping_burst_size: {
                value: cdktf.numberToHclTerraform(this._egressShapingBurstSize),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            egress_shaping_enabled: {
                value: cdktf.booleanToHclTerraform(this._egressShapingEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            egress_shaping_peak_bandwidth: {
                value: cdktf.numberToHclTerraform(this._egressShapingPeakBandwidth),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            failback: {
                value: cdktf.booleanToHclTerraform(this._failback),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ingress_shaping_average_bandwidth: {
                value: cdktf.numberToHclTerraform(this._ingressShapingAverageBandwidth),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ingress_shaping_burst_size: {
                value: cdktf.numberToHclTerraform(this._ingressShapingBurstSize),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ingress_shaping_enabled: {
                value: cdktf.booleanToHclTerraform(this._ingressShapingEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            ingress_shaping_peak_bandwidth: {
                value: cdktf.numberToHclTerraform(this._ingressShapingPeakBandwidth),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            lacp_enabled: {
                value: cdktf.booleanToHclTerraform(this._lacpEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            lacp_mode: {
                value: cdktf.stringToHclTerraform(this._lacpMode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            live_port_moving_allowed: {
                value: cdktf.booleanToHclTerraform(this._livePortMovingAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            netflow_enabled: {
                value: cdktf.booleanToHclTerraform(this._netflowEnabled),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            netflow_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._netflowOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            network_resource_pool_key: {
                value: cdktf.stringToHclTerraform(this._networkResourcePoolKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            network_resource_pool_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._networkResourcePoolOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            notify_switches: {
                value: cdktf.booleanToHclTerraform(this._notifySwitches),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            number_of_ports: {
                value: cdktf.numberToHclTerraform(this._numberOfPorts),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            port_config_reset_at_disconnect: {
                value: cdktf.booleanToHclTerraform(this._portConfigResetAtDisconnect),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            port_name_format: {
                value: cdktf.stringToHclTerraform(this._portNameFormat),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            port_private_secondary_vlan_id: {
                value: cdktf.numberToHclTerraform(this._portPrivateSecondaryVlanId),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            security_policy_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._securityPolicyOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            shaping_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._shapingOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            standby_uplinks: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._standbyUplinks),
                isBlock: false,
                type: "list",
                storageClassType: "stringList",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            teaming_policy: {
                value: cdktf.stringToHclTerraform(this._teamingPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            traffic_filter_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._trafficFilterOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            tx_uplink: {
                value: cdktf.booleanToHclTerraform(this._txUplink),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            type: {
                value: cdktf.stringToHclTerraform(this._type),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            uplink_teaming_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._uplinkTeamingOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vlan_id: {
                value: cdktf.numberToHclTerraform(this._vlanId),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            vlan_override_allowed: {
                value: cdktf.booleanToHclTerraform(this._vlanOverrideAllowed),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            vlan_range: {
                value: cdktf.listMapperHcl(distributedPortGroupVlanRangeToHclTerraform, true)(this._vlanRange.internalValue),
                isBlock: true,
                type: "set",
                storageClassType: "DistributedPortGroupVlanRangeList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.DistributedPortGroup = DistributedPortGroup;
_c = JSII_RTTI_SYMBOL_1;
DistributedPortGroup[_c] = { fqn: "@cdktf/provider-vsphere.distributedPortGroup.DistributedPortGroup", version: "9.3.2" };
// =================
// STATIC PROPERTIES
// =================
DistributedPortGroup.tfResourceType = "vsphere_distributed_port_group";
//# sourceMappingURL=data:application/json;base64,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