/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DistributedVirtualSwitchConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of active uplinks used for load balancing, matching the names of the uplinks assigned in the DVS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#active_uplinks DistributedVirtualSwitch#active_uplinks}
    */
    readonly activeUplinks?: string[];
    /**
    * Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than that of its own.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#allow_forged_transmits DistributedVirtualSwitch#allow_forged_transmits}
    */
    readonly allowForgedTransmits?: boolean | cdktf.IResolvable;
    /**
    * Controls whether or not the Media Access Control (MAC) address can be changed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#allow_mac_changes DistributedVirtualSwitch#allow_mac_changes}
    */
    readonly allowMacChanges?: boolean | cdktf.IResolvable;
    /**
    * Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#allow_promiscuous DistributedVirtualSwitch#allow_promiscuous}
    */
    readonly allowPromiscuous?: boolean | cdktf.IResolvable;
    /**
    * The maximum allowed usage for the backupNfc traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#backupnfc_maximum_mbit DistributedVirtualSwitch#backupnfc_maximum_mbit}
    */
    readonly backupnfcMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the backupNfc traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#backupnfc_reservation_mbit DistributedVirtualSwitch#backupnfc_reservation_mbit}
    */
    readonly backupnfcReservationMbit?: number;
    /**
    * The amount of shares to allocate to the backupNfc traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#backupnfc_share_count DistributedVirtualSwitch#backupnfc_share_count}
    */
    readonly backupnfcShareCount?: number;
    /**
    * The allocation level for the backupNfc traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#backupnfc_share_level DistributedVirtualSwitch#backupnfc_share_level}
    */
    readonly backupnfcShareLevel?: string;
    /**
    * Indicates whether to block all ports by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#block_all_ports DistributedVirtualSwitch#block_all_ports}
    */
    readonly blockAllPorts?: boolean | cdktf.IResolvable;
    /**
    * Enable beacon probing on the ports this policy applies to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#check_beacon DistributedVirtualSwitch#check_beacon}
    */
    readonly checkBeacon?: boolean | cdktf.IResolvable;
    /**
    * The contact detail for this DVS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#contact_detail DistributedVirtualSwitch#contact_detail}
    */
    readonly contactDetail?: string;
    /**
    * The contact name for this DVS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#contact_name DistributedVirtualSwitch#contact_name}
    */
    readonly contactName?: string;
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#custom_attributes DistributedVirtualSwitch#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * The ID of the datacenter to create this virtual switch in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#datacenter_id DistributedVirtualSwitch#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * The description of the DVS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#description DistributedVirtualSwitch#description}
    */
    readonly description?: string;
    /**
    * Allow VMDirectPath Gen2 on the ports this policy applies to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#directpath_gen2_allowed DistributedVirtualSwitch#directpath_gen2_allowed}
    */
    readonly directpathGen2Allowed?: boolean | cdktf.IResolvable;
    /**
    * The average egress bandwidth in bits per second if egress shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#egress_shaping_average_bandwidth DistributedVirtualSwitch#egress_shaping_average_bandwidth}
    */
    readonly egressShapingAverageBandwidth?: number;
    /**
    * The maximum egress burst size allowed in bytes if egress shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#egress_shaping_burst_size DistributedVirtualSwitch#egress_shaping_burst_size}
    */
    readonly egressShapingBurstSize?: number;
    /**
    * True if the traffic shaper is enabled for egress traffic on the port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#egress_shaping_enabled DistributedVirtualSwitch#egress_shaping_enabled}
    */
    readonly egressShapingEnabled?: boolean | cdktf.IResolvable;
    /**
    * The peak egress bandwidth during bursts in bits per second if egress traffic shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#egress_shaping_peak_bandwidth DistributedVirtualSwitch#egress_shaping_peak_bandwidth}
    */
    readonly egressShapingPeakBandwidth?: number;
    /**
    * If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#failback DistributedVirtualSwitch#failback}
    */
    readonly failback?: boolean | cdktf.IResolvable;
    /**
    * The maximum allowed usage for the faultTolerance traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#faulttolerance_maximum_mbit DistributedVirtualSwitch#faulttolerance_maximum_mbit}
    */
    readonly faulttoleranceMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the faultTolerance traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#faulttolerance_reservation_mbit DistributedVirtualSwitch#faulttolerance_reservation_mbit}
    */
    readonly faulttoleranceReservationMbit?: number;
    /**
    * The amount of shares to allocate to the faultTolerance traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#faulttolerance_share_count DistributedVirtualSwitch#faulttolerance_share_count}
    */
    readonly faulttoleranceShareCount?: number;
    /**
    * The allocation level for the faultTolerance traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#faulttolerance_share_level DistributedVirtualSwitch#faulttolerance_share_level}
    */
    readonly faulttoleranceShareLevel?: string;
    /**
    * The folder to create this virtual switch in, relative to the datacenter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#folder DistributedVirtualSwitch#folder}
    */
    readonly folder?: string;
    /**
    * The maximum allowed usage for the hbr traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#hbr_maximum_mbit DistributedVirtualSwitch#hbr_maximum_mbit}
    */
    readonly hbrMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the hbr traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#hbr_reservation_mbit DistributedVirtualSwitch#hbr_reservation_mbit}
    */
    readonly hbrReservationMbit?: number;
    /**
    * The amount of shares to allocate to the hbr traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#hbr_share_count DistributedVirtualSwitch#hbr_share_count}
    */
    readonly hbrShareCount?: number;
    /**
    * The allocation level for the hbr traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#hbr_share_level DistributedVirtualSwitch#hbr_share_level}
    */
    readonly hbrShareLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#id DistributedVirtualSwitch#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether to ignore existing PVLAN mappings not managed by this resource. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#ignore_other_pvlan_mappings DistributedVirtualSwitch#ignore_other_pvlan_mappings}
    */
    readonly ignoreOtherPvlanMappings?: boolean | cdktf.IResolvable;
    /**
    * The average ingress bandwidth in bits per second if ingress shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#ingress_shaping_average_bandwidth DistributedVirtualSwitch#ingress_shaping_average_bandwidth}
    */
    readonly ingressShapingAverageBandwidth?: number;
    /**
    * The maximum ingress burst size allowed in bytes if ingress shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#ingress_shaping_burst_size DistributedVirtualSwitch#ingress_shaping_burst_size}
    */
    readonly ingressShapingBurstSize?: number;
    /**
    * True if the traffic shaper is enabled for ingress traffic on the port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#ingress_shaping_enabled DistributedVirtualSwitch#ingress_shaping_enabled}
    */
    readonly ingressShapingEnabled?: boolean | cdktf.IResolvable;
    /**
    * The peak ingress bandwidth during bursts in bits per second if ingress traffic shaping is enabled on the port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#ingress_shaping_peak_bandwidth DistributedVirtualSwitch#ingress_shaping_peak_bandwidth}
    */
    readonly ingressShapingPeakBandwidth?: number;
    /**
    * The IPv4 address of the switch. This can be used to see the DVS as a unique device with NetFlow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#ipv4_address DistributedVirtualSwitch#ipv4_address}
    */
    readonly ipv4Address?: string;
    /**
    * The maximum allowed usage for the iSCSI traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#iscsi_maximum_mbit DistributedVirtualSwitch#iscsi_maximum_mbit}
    */
    readonly iscsiMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the iSCSI traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#iscsi_reservation_mbit DistributedVirtualSwitch#iscsi_reservation_mbit}
    */
    readonly iscsiReservationMbit?: number;
    /**
    * The amount of shares to allocate to the iSCSI traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#iscsi_share_count DistributedVirtualSwitch#iscsi_share_count}
    */
    readonly iscsiShareCount?: number;
    /**
    * The allocation level for the iSCSI traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#iscsi_share_level DistributedVirtualSwitch#iscsi_share_level}
    */
    readonly iscsiShareLevel?: string;
    /**
    * The Link Aggregation Control Protocol group version in the switch. Can be one of singleLag or multipleLag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#lacp_api_version DistributedVirtualSwitch#lacp_api_version}
    */
    readonly lacpApiVersion?: string;
    /**
    * Whether or not to enable LACP on all uplink ports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#lacp_enabled DistributedVirtualSwitch#lacp_enabled}
    */
    readonly lacpEnabled?: boolean | cdktf.IResolvable;
    /**
    * The uplink LACP mode to use. Can be one of active or passive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#lacp_mode DistributedVirtualSwitch#lacp_mode}
    */
    readonly lacpMode?: string;
    /**
    * Whether to advertise or listen for link discovery. Valid values are advertise, both, listen, and none.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#link_discovery_operation DistributedVirtualSwitch#link_discovery_operation}
    */
    readonly linkDiscoveryOperation?: string;
    /**
    * The discovery protocol type. Valid values are cdp and lldp.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#link_discovery_protocol DistributedVirtualSwitch#link_discovery_protocol}
    */
    readonly linkDiscoveryProtocol?: string;
    /**
    * The maximum allowed usage for the management traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#management_maximum_mbit DistributedVirtualSwitch#management_maximum_mbit}
    */
    readonly managementMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the management traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#management_reservation_mbit DistributedVirtualSwitch#management_reservation_mbit}
    */
    readonly managementReservationMbit?: number;
    /**
    * The amount of shares to allocate to the management traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#management_share_count DistributedVirtualSwitch#management_share_count}
    */
    readonly managementShareCount?: number;
    /**
    * The allocation level for the management traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#management_share_level DistributedVirtualSwitch#management_share_level}
    */
    readonly managementShareLevel?: string;
    /**
    * The maximum MTU on the switch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#max_mtu DistributedVirtualSwitch#max_mtu}
    */
    readonly maxMtu?: number;
    /**
    * The multicast filtering mode on the switch. Can be one of legacyFiltering, or snooping.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#multicast_filtering_mode DistributedVirtualSwitch#multicast_filtering_mode}
    */
    readonly multicastFilteringMode?: string;
    /**
    * The name for the DVS. Must be unique in the folder that it is being created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#name DistributedVirtualSwitch#name}
    */
    readonly name: string;
    /**
    * The number of seconds after which active flows are forced to be exported to the collector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#netflow_active_flow_timeout DistributedVirtualSwitch#netflow_active_flow_timeout}
    */
    readonly netflowActiveFlowTimeout?: number;
    /**
    * IP address for the netflow collector, using IPv4 or IPv6.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#netflow_collector_ip_address DistributedVirtualSwitch#netflow_collector_ip_address}
    */
    readonly netflowCollectorIpAddress?: string;
    /**
    * The port for the netflow collector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#netflow_collector_port DistributedVirtualSwitch#netflow_collector_port}
    */
    readonly netflowCollectorPort?: number;
    /**
    * Indicates whether to enable netflow on all ports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#netflow_enabled DistributedVirtualSwitch#netflow_enabled}
    */
    readonly netflowEnabled?: boolean | cdktf.IResolvable;
    /**
    * The number of seconds after which idle flows are forced to be exported to the collector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#netflow_idle_flow_timeout DistributedVirtualSwitch#netflow_idle_flow_timeout}
    */
    readonly netflowIdleFlowTimeout?: number;
    /**
    * Whether to limit analysis to traffic that has both source and destination served by the same host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#netflow_internal_flows_only DistributedVirtualSwitch#netflow_internal_flows_only}
    */
    readonly netflowInternalFlowsOnly?: boolean | cdktf.IResolvable;
    /**
    * The observation Domain ID for the netflow collector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#netflow_observation_domain_id DistributedVirtualSwitch#netflow_observation_domain_id}
    */
    readonly netflowObservationDomainId?: number;
    /**
    * The ratio of total number of packets to the number of packets analyzed. Set to 0 to disable sampling, meaning that all packets are analyzed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#netflow_sampling_rate DistributedVirtualSwitch#netflow_sampling_rate}
    */
    readonly netflowSamplingRate?: number;
    /**
    * Whether or not to enable network resource control, enabling advanced traffic shaping and resource control features.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#network_resource_control_enabled DistributedVirtualSwitch#network_resource_control_enabled}
    */
    readonly networkResourceControlEnabled?: boolean | cdktf.IResolvable;
    /**
    * The network I/O control version to use. Can be one of version2 or version3.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#network_resource_control_version DistributedVirtualSwitch#network_resource_control_version}
    */
    readonly networkResourceControlVersion?: string;
    /**
    * The maximum allowed usage for the nfs traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#nfs_maximum_mbit DistributedVirtualSwitch#nfs_maximum_mbit}
    */
    readonly nfsMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the nfs traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#nfs_reservation_mbit DistributedVirtualSwitch#nfs_reservation_mbit}
    */
    readonly nfsReservationMbit?: number;
    /**
    * The amount of shares to allocate to the nfs traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#nfs_share_count DistributedVirtualSwitch#nfs_share_count}
    */
    readonly nfsShareCount?: number;
    /**
    * The allocation level for the nfs traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#nfs_share_level DistributedVirtualSwitch#nfs_share_level}
    */
    readonly nfsShareLevel?: string;
    /**
    * If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#notify_switches DistributedVirtualSwitch#notify_switches}
    */
    readonly notifySwitches?: boolean | cdktf.IResolvable;
    /**
    * The secondary VLAN ID for this port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#port_private_secondary_vlan_id DistributedVirtualSwitch#port_private_secondary_vlan_id}
    */
    readonly portPrivateSecondaryVlanId?: number;
    /**
    * List of standby uplinks used for load balancing, matching the names of the uplinks assigned in the DVS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#standby_uplinks DistributedVirtualSwitch#standby_uplinks}
    */
    readonly standbyUplinks?: string[];
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#tags DistributedVirtualSwitch#tags}
    */
    readonly tags?: string[];
    /**
    * The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, failover_explicit, or loadbalance_loadbased.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#teaming_policy DistributedVirtualSwitch#teaming_policy}
    */
    readonly teamingPolicy?: string;
    /**
    * If true, a copy of packets sent to the switch will always be forwarded to an uplink in addition to the regular packet forwarded done by the switch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#tx_uplink DistributedVirtualSwitch#tx_uplink}
    */
    readonly txUplink?: boolean | cdktf.IResolvable;
    /**
    * A list of uplink ports. The contents of this list control both the uplink count and names of the uplinks on the DVS across hosts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#uplinks DistributedVirtualSwitch#uplinks}
    */
    readonly uplinks?: string[];
    /**
    * The maximum allowed usage for the vdp traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vdp_maximum_mbit DistributedVirtualSwitch#vdp_maximum_mbit}
    */
    readonly vdpMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the vdp traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vdp_reservation_mbit DistributedVirtualSwitch#vdp_reservation_mbit}
    */
    readonly vdpReservationMbit?: number;
    /**
    * The amount of shares to allocate to the vdp traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vdp_share_count DistributedVirtualSwitch#vdp_share_count}
    */
    readonly vdpShareCount?: number;
    /**
    * The allocation level for the vdp traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vdp_share_level DistributedVirtualSwitch#vdp_share_level}
    */
    readonly vdpShareLevel?: string;
    /**
    * The version of this virtual switch. Allowed versions are 8.0.0, 7.0.3, 7.0.2, 7.0.0, 6.6.0, 6.5.0, 6.0.0, 5.5.0, 5.1.0, and 5.0.0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#version DistributedVirtualSwitch#version}
    */
    readonly version?: string;
    /**
    * The maximum allowed usage for the virtualMachine traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#virtualmachine_maximum_mbit DistributedVirtualSwitch#virtualmachine_maximum_mbit}
    */
    readonly virtualmachineMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the virtualMachine traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#virtualmachine_reservation_mbit DistributedVirtualSwitch#virtualmachine_reservation_mbit}
    */
    readonly virtualmachineReservationMbit?: number;
    /**
    * The amount of shares to allocate to the virtualMachine traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#virtualmachine_share_count DistributedVirtualSwitch#virtualmachine_share_count}
    */
    readonly virtualmachineShareCount?: number;
    /**
    * The allocation level for the virtualMachine traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#virtualmachine_share_level DistributedVirtualSwitch#virtualmachine_share_level}
    */
    readonly virtualmachineShareLevel?: string;
    /**
    * The VLAN ID for single VLAN mode. 0 denotes no VLAN.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vlan_id DistributedVirtualSwitch#vlan_id}
    */
    readonly vlanId?: number;
    /**
    * The maximum allowed usage for the vmotion traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vmotion_maximum_mbit DistributedVirtualSwitch#vmotion_maximum_mbit}
    */
    readonly vmotionMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the vmotion traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vmotion_reservation_mbit DistributedVirtualSwitch#vmotion_reservation_mbit}
    */
    readonly vmotionReservationMbit?: number;
    /**
    * The amount of shares to allocate to the vmotion traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vmotion_share_count DistributedVirtualSwitch#vmotion_share_count}
    */
    readonly vmotionShareCount?: number;
    /**
    * The allocation level for the vmotion traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vmotion_share_level DistributedVirtualSwitch#vmotion_share_level}
    */
    readonly vmotionShareLevel?: string;
    /**
    * The maximum allowed usage for the vsan traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vsan_maximum_mbit DistributedVirtualSwitch#vsan_maximum_mbit}
    */
    readonly vsanMaximumMbit?: number;
    /**
    * The amount of guaranteed bandwidth for the vsan traffic class, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vsan_reservation_mbit DistributedVirtualSwitch#vsan_reservation_mbit}
    */
    readonly vsanReservationMbit?: number;
    /**
    * The amount of shares to allocate to the vsan traffic class for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vsan_share_count DistributedVirtualSwitch#vsan_share_count}
    */
    readonly vsanShareCount?: number;
    /**
    * The allocation level for the vsan traffic class. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vsan_share_level DistributedVirtualSwitch#vsan_share_level}
    */
    readonly vsanShareLevel?: string;
    /**
    * host block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#host DistributedVirtualSwitch#host}
    */
    readonly host?: DistributedVirtualSwitchHost[] | cdktf.IResolvable;
    /**
    * pvlan_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#pvlan_mapping DistributedVirtualSwitch#pvlan_mapping}
    */
    readonly pvlanMapping?: DistributedVirtualSwitchPvlanMapping[] | cdktf.IResolvable;
    /**
    * vlan_range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#vlan_range DistributedVirtualSwitch#vlan_range}
    */
    readonly vlanRange?: DistributedVirtualSwitchVlanRange[] | cdktf.IResolvable;
}
export interface DistributedVirtualSwitchHost {
    /**
    * Name of the physical NIC to be added to the proxy switch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#devices DistributedVirtualSwitch#devices}
    */
    readonly devices?: string[];
    /**
    * The managed object ID of the host this specification applies to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#host_system_id DistributedVirtualSwitch#host_system_id}
    */
    readonly hostSystemId: string;
}
export declare function distributedVirtualSwitchHostToTerraform(struct?: DistributedVirtualSwitchHost | cdktf.IResolvable): any;
export declare function distributedVirtualSwitchHostToHclTerraform(struct?: DistributedVirtualSwitchHost | cdktf.IResolvable): any;
export declare class DistributedVirtualSwitchHostOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DistributedVirtualSwitchHost | cdktf.IResolvable | undefined;
    set internalValue(value: DistributedVirtualSwitchHost | cdktf.IResolvable | undefined);
    private _devices?;
    get devices(): string[];
    set devices(value: string[]);
    resetDevices(): void;
    get devicesInput(): string[] | undefined;
    private _hostSystemId?;
    get hostSystemId(): string;
    set hostSystemId(value: string);
    get hostSystemIdInput(): string | undefined;
}
export declare class DistributedVirtualSwitchHostList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DistributedVirtualSwitchHost[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DistributedVirtualSwitchHostOutputReference;
}
export interface DistributedVirtualSwitchPvlanMapping {
    /**
    * The primary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#primary_vlan_id DistributedVirtualSwitch#primary_vlan_id}
    */
    readonly primaryVlanId: number;
    /**
    * The private VLAN type. Valid values are promiscuous, community and isolated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#pvlan_type DistributedVirtualSwitch#pvlan_type}
    */
    readonly pvlanType: string;
    /**
    * The secondary VLAN ID. The VLAN IDs of 0 and 4095 are reserved and cannot be used in this property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#secondary_vlan_id DistributedVirtualSwitch#secondary_vlan_id}
    */
    readonly secondaryVlanId: number;
}
export declare function distributedVirtualSwitchPvlanMappingToTerraform(struct?: DistributedVirtualSwitchPvlanMapping | cdktf.IResolvable): any;
export declare function distributedVirtualSwitchPvlanMappingToHclTerraform(struct?: DistributedVirtualSwitchPvlanMapping | cdktf.IResolvable): any;
export declare class DistributedVirtualSwitchPvlanMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DistributedVirtualSwitchPvlanMapping | cdktf.IResolvable | undefined;
    set internalValue(value: DistributedVirtualSwitchPvlanMapping | cdktf.IResolvable | undefined);
    private _primaryVlanId?;
    get primaryVlanId(): number;
    set primaryVlanId(value: number);
    get primaryVlanIdInput(): number | undefined;
    private _pvlanType?;
    get pvlanType(): string;
    set pvlanType(value: string);
    get pvlanTypeInput(): string | undefined;
    private _secondaryVlanId?;
    get secondaryVlanId(): number;
    set secondaryVlanId(value: number);
    get secondaryVlanIdInput(): number | undefined;
}
export declare class DistributedVirtualSwitchPvlanMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DistributedVirtualSwitchPvlanMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DistributedVirtualSwitchPvlanMappingOutputReference;
}
export interface DistributedVirtualSwitchVlanRange {
    /**
    * The minimum VLAN to use in the range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#max_vlan DistributedVirtualSwitch#max_vlan}
    */
    readonly maxVlan: number;
    /**
    * The minimum VLAN to use in the range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#min_vlan DistributedVirtualSwitch#min_vlan}
    */
    readonly minVlan: number;
}
export declare function distributedVirtualSwitchVlanRangeToTerraform(struct?: DistributedVirtualSwitchVlanRange | cdktf.IResolvable): any;
export declare function distributedVirtualSwitchVlanRangeToHclTerraform(struct?: DistributedVirtualSwitchVlanRange | cdktf.IResolvable): any;
export declare class DistributedVirtualSwitchVlanRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DistributedVirtualSwitchVlanRange | cdktf.IResolvable | undefined;
    set internalValue(value: DistributedVirtualSwitchVlanRange | cdktf.IResolvable | undefined);
    private _maxVlan?;
    get maxVlan(): number;
    set maxVlan(value: number);
    get maxVlanInput(): number | undefined;
    private _minVlan?;
    get minVlan(): number;
    set minVlan(value: number);
    get minVlanInput(): number | undefined;
}
export declare class DistributedVirtualSwitchVlanRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DistributedVirtualSwitchVlanRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DistributedVirtualSwitchVlanRangeOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch vsphere_distributed_virtual_switch}
*/
export declare class DistributedVirtualSwitch extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_distributed_virtual_switch";
    /**
    * Generates CDKTF code for importing a DistributedVirtualSwitch resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DistributedVirtualSwitch to import
    * @param importFromId The id of the existing DistributedVirtualSwitch that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DistributedVirtualSwitch to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/distributed_virtual_switch vsphere_distributed_virtual_switch} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DistributedVirtualSwitchConfig
    */
    constructor(scope: Construct, id: string, config: DistributedVirtualSwitchConfig);
    private _activeUplinks?;
    get activeUplinks(): string[];
    set activeUplinks(value: string[]);
    resetActiveUplinks(): void;
    get activeUplinksInput(): string[] | undefined;
    private _allowForgedTransmits?;
    get allowForgedTransmits(): boolean | cdktf.IResolvable;
    set allowForgedTransmits(value: boolean | cdktf.IResolvable);
    resetAllowForgedTransmits(): void;
    get allowForgedTransmitsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowMacChanges?;
    get allowMacChanges(): boolean | cdktf.IResolvable;
    set allowMacChanges(value: boolean | cdktf.IResolvable);
    resetAllowMacChanges(): void;
    get allowMacChangesInput(): boolean | cdktf.IResolvable | undefined;
    private _allowPromiscuous?;
    get allowPromiscuous(): boolean | cdktf.IResolvable;
    set allowPromiscuous(value: boolean | cdktf.IResolvable);
    resetAllowPromiscuous(): void;
    get allowPromiscuousInput(): boolean | cdktf.IResolvable | undefined;
    private _backupnfcMaximumMbit?;
    get backupnfcMaximumMbit(): number;
    set backupnfcMaximumMbit(value: number);
    resetBackupnfcMaximumMbit(): void;
    get backupnfcMaximumMbitInput(): number | undefined;
    private _backupnfcReservationMbit?;
    get backupnfcReservationMbit(): number;
    set backupnfcReservationMbit(value: number);
    resetBackupnfcReservationMbit(): void;
    get backupnfcReservationMbitInput(): number | undefined;
    private _backupnfcShareCount?;
    get backupnfcShareCount(): number;
    set backupnfcShareCount(value: number);
    resetBackupnfcShareCount(): void;
    get backupnfcShareCountInput(): number | undefined;
    private _backupnfcShareLevel?;
    get backupnfcShareLevel(): string;
    set backupnfcShareLevel(value: string);
    resetBackupnfcShareLevel(): void;
    get backupnfcShareLevelInput(): string | undefined;
    private _blockAllPorts?;
    get blockAllPorts(): boolean | cdktf.IResolvable;
    set blockAllPorts(value: boolean | cdktf.IResolvable);
    resetBlockAllPorts(): void;
    get blockAllPortsInput(): boolean | cdktf.IResolvable | undefined;
    private _checkBeacon?;
    get checkBeacon(): boolean | cdktf.IResolvable;
    set checkBeacon(value: boolean | cdktf.IResolvable);
    resetCheckBeacon(): void;
    get checkBeaconInput(): boolean | cdktf.IResolvable | undefined;
    get configVersion(): string;
    private _contactDetail?;
    get contactDetail(): string;
    set contactDetail(value: string);
    resetContactDetail(): void;
    get contactDetailInput(): string | undefined;
    private _contactName?;
    get contactName(): string;
    set contactName(value: string);
    resetContactName(): void;
    get contactNameInput(): string | undefined;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _directpathGen2Allowed?;
    get directpathGen2Allowed(): boolean | cdktf.IResolvable;
    set directpathGen2Allowed(value: boolean | cdktf.IResolvable);
    resetDirectpathGen2Allowed(): void;
    get directpathGen2AllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _egressShapingAverageBandwidth?;
    get egressShapingAverageBandwidth(): number;
    set egressShapingAverageBandwidth(value: number);
    resetEgressShapingAverageBandwidth(): void;
    get egressShapingAverageBandwidthInput(): number | undefined;
    private _egressShapingBurstSize?;
    get egressShapingBurstSize(): number;
    set egressShapingBurstSize(value: number);
    resetEgressShapingBurstSize(): void;
    get egressShapingBurstSizeInput(): number | undefined;
    private _egressShapingEnabled?;
    get egressShapingEnabled(): boolean | cdktf.IResolvable;
    set egressShapingEnabled(value: boolean | cdktf.IResolvable);
    resetEgressShapingEnabled(): void;
    get egressShapingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _egressShapingPeakBandwidth?;
    get egressShapingPeakBandwidth(): number;
    set egressShapingPeakBandwidth(value: number);
    resetEgressShapingPeakBandwidth(): void;
    get egressShapingPeakBandwidthInput(): number | undefined;
    private _failback?;
    get failback(): boolean | cdktf.IResolvable;
    set failback(value: boolean | cdktf.IResolvable);
    resetFailback(): void;
    get failbackInput(): boolean | cdktf.IResolvable | undefined;
    private _faulttoleranceMaximumMbit?;
    get faulttoleranceMaximumMbit(): number;
    set faulttoleranceMaximumMbit(value: number);
    resetFaulttoleranceMaximumMbit(): void;
    get faulttoleranceMaximumMbitInput(): number | undefined;
    private _faulttoleranceReservationMbit?;
    get faulttoleranceReservationMbit(): number;
    set faulttoleranceReservationMbit(value: number);
    resetFaulttoleranceReservationMbit(): void;
    get faulttoleranceReservationMbitInput(): number | undefined;
    private _faulttoleranceShareCount?;
    get faulttoleranceShareCount(): number;
    set faulttoleranceShareCount(value: number);
    resetFaulttoleranceShareCount(): void;
    get faulttoleranceShareCountInput(): number | undefined;
    private _faulttoleranceShareLevel?;
    get faulttoleranceShareLevel(): string;
    set faulttoleranceShareLevel(value: string);
    resetFaulttoleranceShareLevel(): void;
    get faulttoleranceShareLevelInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    private _hbrMaximumMbit?;
    get hbrMaximumMbit(): number;
    set hbrMaximumMbit(value: number);
    resetHbrMaximumMbit(): void;
    get hbrMaximumMbitInput(): number | undefined;
    private _hbrReservationMbit?;
    get hbrReservationMbit(): number;
    set hbrReservationMbit(value: number);
    resetHbrReservationMbit(): void;
    get hbrReservationMbitInput(): number | undefined;
    private _hbrShareCount?;
    get hbrShareCount(): number;
    set hbrShareCount(value: number);
    resetHbrShareCount(): void;
    get hbrShareCountInput(): number | undefined;
    private _hbrShareLevel?;
    get hbrShareLevel(): string;
    set hbrShareLevel(value: string);
    resetHbrShareLevel(): void;
    get hbrShareLevelInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreOtherPvlanMappings?;
    get ignoreOtherPvlanMappings(): boolean | cdktf.IResolvable;
    set ignoreOtherPvlanMappings(value: boolean | cdktf.IResolvable);
    resetIgnoreOtherPvlanMappings(): void;
    get ignoreOtherPvlanMappingsInput(): boolean | cdktf.IResolvable | undefined;
    private _ingressShapingAverageBandwidth?;
    get ingressShapingAverageBandwidth(): number;
    set ingressShapingAverageBandwidth(value: number);
    resetIngressShapingAverageBandwidth(): void;
    get ingressShapingAverageBandwidthInput(): number | undefined;
    private _ingressShapingBurstSize?;
    get ingressShapingBurstSize(): number;
    set ingressShapingBurstSize(value: number);
    resetIngressShapingBurstSize(): void;
    get ingressShapingBurstSizeInput(): number | undefined;
    private _ingressShapingEnabled?;
    get ingressShapingEnabled(): boolean | cdktf.IResolvable;
    set ingressShapingEnabled(value: boolean | cdktf.IResolvable);
    resetIngressShapingEnabled(): void;
    get ingressShapingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ingressShapingPeakBandwidth?;
    get ingressShapingPeakBandwidth(): number;
    set ingressShapingPeakBandwidth(value: number);
    resetIngressShapingPeakBandwidth(): void;
    get ingressShapingPeakBandwidthInput(): number | undefined;
    private _ipv4Address?;
    get ipv4Address(): string;
    set ipv4Address(value: string);
    resetIpv4Address(): void;
    get ipv4AddressInput(): string | undefined;
    private _iscsiMaximumMbit?;
    get iscsiMaximumMbit(): number;
    set iscsiMaximumMbit(value: number);
    resetIscsiMaximumMbit(): void;
    get iscsiMaximumMbitInput(): number | undefined;
    private _iscsiReservationMbit?;
    get iscsiReservationMbit(): number;
    set iscsiReservationMbit(value: number);
    resetIscsiReservationMbit(): void;
    get iscsiReservationMbitInput(): number | undefined;
    private _iscsiShareCount?;
    get iscsiShareCount(): number;
    set iscsiShareCount(value: number);
    resetIscsiShareCount(): void;
    get iscsiShareCountInput(): number | undefined;
    private _iscsiShareLevel?;
    get iscsiShareLevel(): string;
    set iscsiShareLevel(value: string);
    resetIscsiShareLevel(): void;
    get iscsiShareLevelInput(): string | undefined;
    private _lacpApiVersion?;
    get lacpApiVersion(): string;
    set lacpApiVersion(value: string);
    resetLacpApiVersion(): void;
    get lacpApiVersionInput(): string | undefined;
    private _lacpEnabled?;
    get lacpEnabled(): boolean | cdktf.IResolvable;
    set lacpEnabled(value: boolean | cdktf.IResolvable);
    resetLacpEnabled(): void;
    get lacpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _lacpMode?;
    get lacpMode(): string;
    set lacpMode(value: string);
    resetLacpMode(): void;
    get lacpModeInput(): string | undefined;
    private _linkDiscoveryOperation?;
    get linkDiscoveryOperation(): string;
    set linkDiscoveryOperation(value: string);
    resetLinkDiscoveryOperation(): void;
    get linkDiscoveryOperationInput(): string | undefined;
    private _linkDiscoveryProtocol?;
    get linkDiscoveryProtocol(): string;
    set linkDiscoveryProtocol(value: string);
    resetLinkDiscoveryProtocol(): void;
    get linkDiscoveryProtocolInput(): string | undefined;
    private _managementMaximumMbit?;
    get managementMaximumMbit(): number;
    set managementMaximumMbit(value: number);
    resetManagementMaximumMbit(): void;
    get managementMaximumMbitInput(): number | undefined;
    private _managementReservationMbit?;
    get managementReservationMbit(): number;
    set managementReservationMbit(value: number);
    resetManagementReservationMbit(): void;
    get managementReservationMbitInput(): number | undefined;
    private _managementShareCount?;
    get managementShareCount(): number;
    set managementShareCount(value: number);
    resetManagementShareCount(): void;
    get managementShareCountInput(): number | undefined;
    private _managementShareLevel?;
    get managementShareLevel(): string;
    set managementShareLevel(value: string);
    resetManagementShareLevel(): void;
    get managementShareLevelInput(): string | undefined;
    private _maxMtu?;
    get maxMtu(): number;
    set maxMtu(value: number);
    resetMaxMtu(): void;
    get maxMtuInput(): number | undefined;
    private _multicastFilteringMode?;
    get multicastFilteringMode(): string;
    set multicastFilteringMode(value: string);
    resetMulticastFilteringMode(): void;
    get multicastFilteringModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _netflowActiveFlowTimeout?;
    get netflowActiveFlowTimeout(): number;
    set netflowActiveFlowTimeout(value: number);
    resetNetflowActiveFlowTimeout(): void;
    get netflowActiveFlowTimeoutInput(): number | undefined;
    private _netflowCollectorIpAddress?;
    get netflowCollectorIpAddress(): string;
    set netflowCollectorIpAddress(value: string);
    resetNetflowCollectorIpAddress(): void;
    get netflowCollectorIpAddressInput(): string | undefined;
    private _netflowCollectorPort?;
    get netflowCollectorPort(): number;
    set netflowCollectorPort(value: number);
    resetNetflowCollectorPort(): void;
    get netflowCollectorPortInput(): number | undefined;
    private _netflowEnabled?;
    get netflowEnabled(): boolean | cdktf.IResolvable;
    set netflowEnabled(value: boolean | cdktf.IResolvable);
    resetNetflowEnabled(): void;
    get netflowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _netflowIdleFlowTimeout?;
    get netflowIdleFlowTimeout(): number;
    set netflowIdleFlowTimeout(value: number);
    resetNetflowIdleFlowTimeout(): void;
    get netflowIdleFlowTimeoutInput(): number | undefined;
    private _netflowInternalFlowsOnly?;
    get netflowInternalFlowsOnly(): boolean | cdktf.IResolvable;
    set netflowInternalFlowsOnly(value: boolean | cdktf.IResolvable);
    resetNetflowInternalFlowsOnly(): void;
    get netflowInternalFlowsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _netflowObservationDomainId?;
    get netflowObservationDomainId(): number;
    set netflowObservationDomainId(value: number);
    resetNetflowObservationDomainId(): void;
    get netflowObservationDomainIdInput(): number | undefined;
    private _netflowSamplingRate?;
    get netflowSamplingRate(): number;
    set netflowSamplingRate(value: number);
    resetNetflowSamplingRate(): void;
    get netflowSamplingRateInput(): number | undefined;
    private _networkResourceControlEnabled?;
    get networkResourceControlEnabled(): boolean | cdktf.IResolvable;
    set networkResourceControlEnabled(value: boolean | cdktf.IResolvable);
    resetNetworkResourceControlEnabled(): void;
    get networkResourceControlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _networkResourceControlVersion?;
    get networkResourceControlVersion(): string;
    set networkResourceControlVersion(value: string);
    resetNetworkResourceControlVersion(): void;
    get networkResourceControlVersionInput(): string | undefined;
    private _nfsMaximumMbit?;
    get nfsMaximumMbit(): number;
    set nfsMaximumMbit(value: number);
    resetNfsMaximumMbit(): void;
    get nfsMaximumMbitInput(): number | undefined;
    private _nfsReservationMbit?;
    get nfsReservationMbit(): number;
    set nfsReservationMbit(value: number);
    resetNfsReservationMbit(): void;
    get nfsReservationMbitInput(): number | undefined;
    private _nfsShareCount?;
    get nfsShareCount(): number;
    set nfsShareCount(value: number);
    resetNfsShareCount(): void;
    get nfsShareCountInput(): number | undefined;
    private _nfsShareLevel?;
    get nfsShareLevel(): string;
    set nfsShareLevel(value: string);
    resetNfsShareLevel(): void;
    get nfsShareLevelInput(): string | undefined;
    private _notifySwitches?;
    get notifySwitches(): boolean | cdktf.IResolvable;
    set notifySwitches(value: boolean | cdktf.IResolvable);
    resetNotifySwitches(): void;
    get notifySwitchesInput(): boolean | cdktf.IResolvable | undefined;
    private _portPrivateSecondaryVlanId?;
    get portPrivateSecondaryVlanId(): number;
    set portPrivateSecondaryVlanId(value: number);
    resetPortPrivateSecondaryVlanId(): void;
    get portPrivateSecondaryVlanIdInput(): number | undefined;
    private _standbyUplinks?;
    get standbyUplinks(): string[];
    set standbyUplinks(value: string[]);
    resetStandbyUplinks(): void;
    get standbyUplinksInput(): string[] | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _teamingPolicy?;
    get teamingPolicy(): string;
    set teamingPolicy(value: string);
    resetTeamingPolicy(): void;
    get teamingPolicyInput(): string | undefined;
    private _txUplink?;
    get txUplink(): boolean | cdktf.IResolvable;
    set txUplink(value: boolean | cdktf.IResolvable);
    resetTxUplink(): void;
    get txUplinkInput(): boolean | cdktf.IResolvable | undefined;
    private _uplinks?;
    get uplinks(): string[];
    set uplinks(value: string[]);
    resetUplinks(): void;
    get uplinksInput(): string[] | undefined;
    private _vdpMaximumMbit?;
    get vdpMaximumMbit(): number;
    set vdpMaximumMbit(value: number);
    resetVdpMaximumMbit(): void;
    get vdpMaximumMbitInput(): number | undefined;
    private _vdpReservationMbit?;
    get vdpReservationMbit(): number;
    set vdpReservationMbit(value: number);
    resetVdpReservationMbit(): void;
    get vdpReservationMbitInput(): number | undefined;
    private _vdpShareCount?;
    get vdpShareCount(): number;
    set vdpShareCount(value: number);
    resetVdpShareCount(): void;
    get vdpShareCountInput(): number | undefined;
    private _vdpShareLevel?;
    get vdpShareLevel(): string;
    set vdpShareLevel(value: string);
    resetVdpShareLevel(): void;
    get vdpShareLevelInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _virtualmachineMaximumMbit?;
    get virtualmachineMaximumMbit(): number;
    set virtualmachineMaximumMbit(value: number);
    resetVirtualmachineMaximumMbit(): void;
    get virtualmachineMaximumMbitInput(): number | undefined;
    private _virtualmachineReservationMbit?;
    get virtualmachineReservationMbit(): number;
    set virtualmachineReservationMbit(value: number);
    resetVirtualmachineReservationMbit(): void;
    get virtualmachineReservationMbitInput(): number | undefined;
    private _virtualmachineShareCount?;
    get virtualmachineShareCount(): number;
    set virtualmachineShareCount(value: number);
    resetVirtualmachineShareCount(): void;
    get virtualmachineShareCountInput(): number | undefined;
    private _virtualmachineShareLevel?;
    get virtualmachineShareLevel(): string;
    set virtualmachineShareLevel(value: string);
    resetVirtualmachineShareLevel(): void;
    get virtualmachineShareLevelInput(): string | undefined;
    private _vlanId?;
    get vlanId(): number;
    set vlanId(value: number);
    resetVlanId(): void;
    get vlanIdInput(): number | undefined;
    private _vmotionMaximumMbit?;
    get vmotionMaximumMbit(): number;
    set vmotionMaximumMbit(value: number);
    resetVmotionMaximumMbit(): void;
    get vmotionMaximumMbitInput(): number | undefined;
    private _vmotionReservationMbit?;
    get vmotionReservationMbit(): number;
    set vmotionReservationMbit(value: number);
    resetVmotionReservationMbit(): void;
    get vmotionReservationMbitInput(): number | undefined;
    private _vmotionShareCount?;
    get vmotionShareCount(): number;
    set vmotionShareCount(value: number);
    resetVmotionShareCount(): void;
    get vmotionShareCountInput(): number | undefined;
    private _vmotionShareLevel?;
    get vmotionShareLevel(): string;
    set vmotionShareLevel(value: string);
    resetVmotionShareLevel(): void;
    get vmotionShareLevelInput(): string | undefined;
    private _vsanMaximumMbit?;
    get vsanMaximumMbit(): number;
    set vsanMaximumMbit(value: number);
    resetVsanMaximumMbit(): void;
    get vsanMaximumMbitInput(): number | undefined;
    private _vsanReservationMbit?;
    get vsanReservationMbit(): number;
    set vsanReservationMbit(value: number);
    resetVsanReservationMbit(): void;
    get vsanReservationMbitInput(): number | undefined;
    private _vsanShareCount?;
    get vsanShareCount(): number;
    set vsanShareCount(value: number);
    resetVsanShareCount(): void;
    get vsanShareCountInput(): number | undefined;
    private _vsanShareLevel?;
    get vsanShareLevel(): string;
    set vsanShareLevel(value: string);
    resetVsanShareLevel(): void;
    get vsanShareLevelInput(): string | undefined;
    private _host;
    get host(): DistributedVirtualSwitchHostList;
    putHost(value: DistributedVirtualSwitchHost[] | cdktf.IResolvable): void;
    resetHost(): void;
    get hostInput(): cdktf.IResolvable | DistributedVirtualSwitchHost[] | undefined;
    private _pvlanMapping;
    get pvlanMapping(): DistributedVirtualSwitchPvlanMappingList;
    putPvlanMapping(value: DistributedVirtualSwitchPvlanMapping[] | cdktf.IResolvable): void;
    resetPvlanMapping(): void;
    get pvlanMappingInput(): cdktf.IResolvable | DistributedVirtualSwitchPvlanMapping[] | undefined;
    private _vlanRange;
    get vlanRange(): DistributedVirtualSwitchVlanRangeList;
    putVlanRange(value: DistributedVirtualSwitchVlanRange[] | cdktf.IResolvable): void;
    resetVlanRange(): void;
    get vlanRangeInput(): cdktf.IResolvable | DistributedVirtualSwitchVlanRange[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
