/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EntityPermissionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object id or uuid of the entity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions#entity_id EntityPermissions#entity_id}
    */
    readonly entityId: string;
    /**
    * The entity managed object type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions#entity_type EntityPermissions#entity_type}
    */
    readonly entityType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions#id EntityPermissions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions#permissions EntityPermissions#permissions}
    */
    readonly permissions: EntityPermissionsPermissions[] | cdktf.IResolvable;
}
export interface EntityPermissionsPermissions {
    /**
    * Whether user_or_group field refers to a user or a group. True for a group and false for a user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions#is_group EntityPermissions#is_group}
    */
    readonly isGroup: boolean | cdktf.IResolvable;
    /**
    * Whether or not this permission propagates down the hierarchy to sub-entities.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions#propagate EntityPermissions#propagate}
    */
    readonly propagate: boolean | cdktf.IResolvable;
    /**
    * Reference to the role providing the access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions#role_id EntityPermissions#role_id}
    */
    readonly roleId: string;
    /**
    * User or group receiving access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions#user_or_group EntityPermissions#user_or_group}
    */
    readonly userOrGroup: string;
}
export declare function entityPermissionsPermissionsToTerraform(struct?: EntityPermissionsPermissions | cdktf.IResolvable): any;
export declare function entityPermissionsPermissionsToHclTerraform(struct?: EntityPermissionsPermissions | cdktf.IResolvable): any;
export declare class EntityPermissionsPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EntityPermissionsPermissions | cdktf.IResolvable | undefined;
    set internalValue(value: EntityPermissionsPermissions | cdktf.IResolvable | undefined);
    private _isGroup?;
    get isGroup(): boolean | cdktf.IResolvable;
    set isGroup(value: boolean | cdktf.IResolvable);
    get isGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _propagate?;
    get propagate(): boolean | cdktf.IResolvable;
    set propagate(value: boolean | cdktf.IResolvable);
    get propagateInput(): boolean | cdktf.IResolvable | undefined;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    private _userOrGroup?;
    get userOrGroup(): string;
    set userOrGroup(value: string);
    get userOrGroupInput(): string | undefined;
}
export declare class EntityPermissionsPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EntityPermissionsPermissions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EntityPermissionsPermissionsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions vsphere_entity_permissions}
*/
export declare class EntityPermissions extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_entity_permissions";
    /**
    * Generates CDKTF code for importing a EntityPermissions resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EntityPermissions to import
    * @param importFromId The id of the existing EntityPermissions that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EntityPermissions to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/entity_permissions vsphere_entity_permissions} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EntityPermissionsConfig
    */
    constructor(scope: Construct, id: string, config: EntityPermissionsConfig);
    private _entityId?;
    get entityId(): string;
    set entityId(value: string);
    get entityIdInput(): string | undefined;
    private _entityType?;
    get entityType(): string;
    set entityType(value: string);
    get entityTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _permissions;
    get permissions(): EntityPermissionsPermissionsList;
    putPermissions(value: EntityPermissionsPermissions[] | cdktf.IResolvable): void;
    get permissionsInput(): cdktf.IResolvable | EntityPermissionsPermissions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
