/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HostPortGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of active network adapters used for load balancing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#active_nics HostPortGroup#active_nics}
    */
    readonly activeNics?: string[];
    /**
    * Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than that of its own.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#allow_forged_transmits HostPortGroup#allow_forged_transmits}
    */
    readonly allowForgedTransmits?: boolean | cdktf.IResolvable;
    /**
    * Controls whether or not the Media Access Control (MAC) address can be changed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#allow_mac_changes HostPortGroup#allow_mac_changes}
    */
    readonly allowMacChanges?: boolean | cdktf.IResolvable;
    /**
    * Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#allow_promiscuous HostPortGroup#allow_promiscuous}
    */
    readonly allowPromiscuous?: boolean | cdktf.IResolvable;
    /**
    * Enable beacon probing. Requires that the vSwitch has been configured to use a beacon. If disabled, link status is used only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#check_beacon HostPortGroup#check_beacon}
    */
    readonly checkBeacon?: boolean | cdktf.IResolvable;
    /**
    * If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#failback HostPortGroup#failback}
    */
    readonly failback?: boolean | cdktf.IResolvable;
    /**
    * The managed object ID of the host to set the virtual switch up on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#host_system_id HostPortGroup#host_system_id}
    */
    readonly hostSystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#id HostPortGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the port group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#name HostPortGroup#name}
    */
    readonly name: string;
    /**
    * If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#notify_switches HostPortGroup#notify_switches}
    */
    readonly notifySwitches?: boolean | cdktf.IResolvable;
    /**
    * The average bandwidth in bits per second if traffic shaping is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#shaping_average_bandwidth HostPortGroup#shaping_average_bandwidth}
    */
    readonly shapingAverageBandwidth?: number;
    /**
    * The maximum burst size allowed in bytes if traffic shaping is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#shaping_burst_size HostPortGroup#shaping_burst_size}
    */
    readonly shapingBurstSize?: number;
    /**
    * Enable traffic shaping on this virtual switch or port group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#shaping_enabled HostPortGroup#shaping_enabled}
    */
    readonly shapingEnabled?: boolean | cdktf.IResolvable;
    /**
    * The peak bandwidth during bursts in bits per second if traffic shaping is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#shaping_peak_bandwidth HostPortGroup#shaping_peak_bandwidth}
    */
    readonly shapingPeakBandwidth?: number;
    /**
    * List of standby network adapters used for failover.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#standby_nics HostPortGroup#standby_nics}
    */
    readonly standbyNics?: string[];
    /**
    * The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, or failover_explicit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#teaming_policy HostPortGroup#teaming_policy}
    */
    readonly teamingPolicy?: string;
    /**
    * The name of the virtual switch to bind this port group to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#virtual_switch_name HostPortGroup#virtual_switch_name}
    */
    readonly virtualSwitchName: string;
    /**
    * The VLAN ID/trunk mode for this port group. An ID of 0 denotes no tagging, an ID of 1-4094 tags with the specific ID, and an ID of 4095 enables trunk mode, allowing the guest to manage its own tagging.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#vlan_id HostPortGroup#vlan_id}
    */
    readonly vlanId?: number;
}
export interface HostPortGroupPorts {
}
export declare function hostPortGroupPortsToTerraform(struct?: HostPortGroupPorts): any;
export declare function hostPortGroupPortsToHclTerraform(struct?: HostPortGroupPorts): any;
export declare class HostPortGroupPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HostPortGroupPorts | undefined;
    set internalValue(value: HostPortGroupPorts | undefined);
    get key(): string;
    get macAddresses(): string[];
    get type(): string;
}
export declare class HostPortGroupPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HostPortGroupPortsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group vsphere_host_port_group}
*/
export declare class HostPortGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_host_port_group";
    /**
    * Generates CDKTF code for importing a HostPortGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HostPortGroup to import
    * @param importFromId The id of the existing HostPortGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HostPortGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/host_port_group vsphere_host_port_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostPortGroupConfig
    */
    constructor(scope: Construct, id: string, config: HostPortGroupConfig);
    private _activeNics?;
    get activeNics(): string[];
    set activeNics(value: string[]);
    resetActiveNics(): void;
    get activeNicsInput(): string[] | undefined;
    private _allowForgedTransmits?;
    get allowForgedTransmits(): boolean | cdktf.IResolvable;
    set allowForgedTransmits(value: boolean | cdktf.IResolvable);
    resetAllowForgedTransmits(): void;
    get allowForgedTransmitsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowMacChanges?;
    get allowMacChanges(): boolean | cdktf.IResolvable;
    set allowMacChanges(value: boolean | cdktf.IResolvable);
    resetAllowMacChanges(): void;
    get allowMacChangesInput(): boolean | cdktf.IResolvable | undefined;
    private _allowPromiscuous?;
    get allowPromiscuous(): boolean | cdktf.IResolvable;
    set allowPromiscuous(value: boolean | cdktf.IResolvable);
    resetAllowPromiscuous(): void;
    get allowPromiscuousInput(): boolean | cdktf.IResolvable | undefined;
    private _checkBeacon?;
    get checkBeacon(): boolean | cdktf.IResolvable;
    set checkBeacon(value: boolean | cdktf.IResolvable);
    resetCheckBeacon(): void;
    get checkBeaconInput(): boolean | cdktf.IResolvable | undefined;
    private _computedPolicy;
    get computedPolicy(): cdktf.StringMap;
    private _failback?;
    get failback(): boolean | cdktf.IResolvable;
    set failback(value: boolean | cdktf.IResolvable);
    resetFailback(): void;
    get failbackInput(): boolean | cdktf.IResolvable | undefined;
    private _hostSystemId?;
    get hostSystemId(): string;
    set hostSystemId(value: string);
    get hostSystemIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get key(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notifySwitches?;
    get notifySwitches(): boolean | cdktf.IResolvable;
    set notifySwitches(value: boolean | cdktf.IResolvable);
    resetNotifySwitches(): void;
    get notifySwitchesInput(): boolean | cdktf.IResolvable | undefined;
    private _ports;
    get ports(): HostPortGroupPortsList;
    private _shapingAverageBandwidth?;
    get shapingAverageBandwidth(): number;
    set shapingAverageBandwidth(value: number);
    resetShapingAverageBandwidth(): void;
    get shapingAverageBandwidthInput(): number | undefined;
    private _shapingBurstSize?;
    get shapingBurstSize(): number;
    set shapingBurstSize(value: number);
    resetShapingBurstSize(): void;
    get shapingBurstSizeInput(): number | undefined;
    private _shapingEnabled?;
    get shapingEnabled(): boolean | cdktf.IResolvable;
    set shapingEnabled(value: boolean | cdktf.IResolvable);
    resetShapingEnabled(): void;
    get shapingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _shapingPeakBandwidth?;
    get shapingPeakBandwidth(): number;
    set shapingPeakBandwidth(value: number);
    resetShapingPeakBandwidth(): void;
    get shapingPeakBandwidthInput(): number | undefined;
    private _standbyNics?;
    get standbyNics(): string[];
    set standbyNics(value: string[]);
    resetStandbyNics(): void;
    get standbyNicsInput(): string[] | undefined;
    private _teamingPolicy?;
    get teamingPolicy(): string;
    set teamingPolicy(value: string);
    resetTeamingPolicy(): void;
    get teamingPolicyInput(): string | undefined;
    private _virtualSwitchName?;
    get virtualSwitchName(): string;
    set virtualSwitchName(value: string);
    get virtualSwitchNameInput(): string | undefined;
    private _vlanId?;
    get vlanId(): number;
    set vlanId(value: number);
    resetVlanId(): void;
    get vlanIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
