/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NasDatastoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access mode for the mount point. Can be one of readOnly or readWrite.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#access_mode NasDatastore#access_mode}
    */
    readonly accessMode?: string;
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#custom_attributes NasDatastore#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * The managed object ID of the datastore cluster to place the datastore in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#datastore_cluster_id NasDatastore#datastore_cluster_id}
    */
    readonly datastoreClusterId?: string;
    /**
    * The path to the datastore folder to put the datastore in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#folder NasDatastore#folder}
    */
    readonly folder?: string;
    /**
    * The managed object IDs of the hosts to mount the datastore on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#host_system_ids NasDatastore#host_system_ids}
    */
    readonly hostSystemIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#id NasDatastore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the datastore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#name NasDatastore#name}
    */
    readonly name: string;
    /**
    * The hostnames or IP addresses of the remote server or servers. Only one element should be present for NFS v3 but multiple can be present for NFS v4.1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#remote_hosts NasDatastore#remote_hosts}
    */
    readonly remoteHosts: string[];
    /**
    * The remote path of the mount point.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#remote_path NasDatastore#remote_path}
    */
    readonly remotePath: string;
    /**
    * The security type to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#security_type NasDatastore#security_type}
    */
    readonly securityType?: string;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#tags NasDatastore#tags}
    */
    readonly tags?: string[];
    /**
    * The type of NAS volume. Can be one of NFS (to denote v3) or NFS41 (to denote NFS v4.1).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#type NasDatastore#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore vsphere_nas_datastore}
*/
export declare class NasDatastore extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_nas_datastore";
    /**
    * Generates CDKTF code for importing a NasDatastore resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NasDatastore to import
    * @param importFromId The id of the existing NasDatastore that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NasDatastore to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/nas_datastore vsphere_nas_datastore} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NasDatastoreConfig
    */
    constructor(scope: Construct, id: string, config: NasDatastoreConfig);
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    resetAccessMode(): void;
    get accessModeInput(): string | undefined;
    get accessible(): cdktf.IResolvable;
    get capacity(): number;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _datastoreClusterId?;
    get datastoreClusterId(): string;
    set datastoreClusterId(value: string);
    resetDatastoreClusterId(): void;
    get datastoreClusterIdInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    get freeSpace(): number;
    private _hostSystemIds?;
    get hostSystemIds(): string[];
    set hostSystemIds(value: string[]);
    get hostSystemIdsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get maintenanceMode(): string;
    get multipleHostAccess(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get protocolEndpoint(): cdktf.IResolvable;
    private _remoteHosts?;
    get remoteHosts(): string[];
    set remoteHosts(value: string[]);
    get remoteHostsInput(): string[] | undefined;
    private _remotePath?;
    get remotePath(): string;
    set remotePath(value: string);
    get remotePathInput(): string | undefined;
    private _securityType?;
    get securityType(): string;
    set securityType(value: string);
    resetSecurityType(): void;
    get securityTypeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get uncommittedSpace(): number;
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
