/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot#consolidate VirtualMachineSnapshot#consolidate}
    */
    readonly consolidate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot#description VirtualMachineSnapshot#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot#id VirtualMachineSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot#memory VirtualMachineSnapshot#memory}
    */
    readonly memory: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot#quiesce VirtualMachineSnapshot#quiesce}
    */
    readonly quiesce: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot#remove_children VirtualMachineSnapshot#remove_children}
    */
    readonly removeChildren?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot#snapshot_name VirtualMachineSnapshot#snapshot_name}
    */
    readonly snapshotName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot#virtual_machine_uuid VirtualMachineSnapshot#virtual_machine_uuid}
    */
    readonly virtualMachineUuid: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot vsphere_virtual_machine_snapshot}
*/
export declare class VirtualMachineSnapshot extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_virtual_machine_snapshot";
    /**
    * Generates CDKTF code for importing a VirtualMachineSnapshot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualMachineSnapshot to import
    * @param importFromId The id of the existing VirtualMachineSnapshot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualMachineSnapshot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.9.2/docs/resources/virtual_machine_snapshot vsphere_virtual_machine_snapshot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineSnapshotConfig);
    private _consolidate?;
    get consolidate(): boolean | cdktf.IResolvable;
    set consolidate(value: boolean | cdktf.IResolvable);
    resetConsolidate(): void;
    get consolidateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memory?;
    get memory(): boolean | cdktf.IResolvable;
    set memory(value: boolean | cdktf.IResolvable);
    get memoryInput(): boolean | cdktf.IResolvable | undefined;
    private _quiesce?;
    get quiesce(): boolean | cdktf.IResolvable;
    set quiesce(value: boolean | cdktf.IResolvable);
    get quiesceInput(): boolean | cdktf.IResolvable | undefined;
    private _removeChildren?;
    get removeChildren(): boolean | cdktf.IResolvable;
    set removeChildren(value: boolean | cdktf.IResolvable);
    resetRemoveChildren(): void;
    get removeChildrenInput(): boolean | cdktf.IResolvable | undefined;
    private _snapshotName?;
    get snapshotName(): string;
    set snapshotName(value: string);
    get snapshotNameInput(): string | undefined;
    private _virtualMachineUuid?;
    get virtualMachineUuid(): string;
    set virtualMachineUuid(value: string);
    get virtualMachineUuidInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
