
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "cf"

@_ods_cext.register_operation(_Dialect)
class AssertOp(_ods_ir.OpView):
  OPERATION_NAME = "cf.assert"

  _ODS_REGIONS = (0, True)

  def __init__(self, arg, msg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(arg)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["msg"] = (msg if (
    isinstance(msg, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(msg, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def msg(self):
    return self.operation.attributes["msg"]

  @msg.setter
  def msg(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["msg"] = value

def assert_(arg, msg, *, loc=None, ip=None) -> _ods_ir.Operation:
  return AssertOp(arg=arg, msg=msg, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class BranchOp(_ods_ir.OpView):
  OPERATION_NAME = "cf.br"

  _ODS_REGIONS = (0, True)

  def __init__(self, destOperands, dest, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(destOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = []
    _ods_successors.append(dest)
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def destOperands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def br(dest_operands, dest, *, loc=None, ip=None) -> _ods_ir.Operation:
  return BranchOp(destOperands=dest_operands, dest=dest, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class CondBranchOp(_ods_ir.OpView):
  OPERATION_NAME = "cf.cond_br"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, condition, trueDestOperands, falseDestOperands, trueDest, falseDest, *, branch_weights=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(condition)
    operands.append(_get_op_results_or_values(trueDestOperands))
    operands.append(_get_op_results_or_values(falseDestOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if branch_weights is not None: attributes["branch_weights"] = (branch_weights if (
        isinstance(branch_weights, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(branch_weights, context=_ods_context))
    _ods_successors = []
    _ods_successors.append(trueDest)
    _ods_successors.append(falseDest)
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def condition(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def trueDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def falseDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def branch_weights(self):
    if "branch_weights" not in self.operation.attributes:
      return None
    return self.operation.attributes["branch_weights"]

  @branch_weights.setter
  def branch_weights(self, value):
    if value is not None:
      self.operation.attributes["branch_weights"] = value
    elif "branch_weights" in self.operation.attributes:
      del self.operation.attributes["branch_weights"]

  @branch_weights.deleter
  def branch_weights(self):
    del self.operation.attributes["branch_weights"]

def cond_br(condition, true_dest_operands, false_dest_operands, true_dest, false_dest, *, branch_weights=None, loc=None, ip=None) -> _ods_ir.Operation:
  return CondBranchOp(condition=condition, trueDestOperands=true_dest_operands, falseDestOperands=false_dest_operands, trueDest=true_dest, falseDest=false_dest, branch_weights=branch_weights, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SwitchOp(_ods_ir.OpView):
  OPERATION_NAME = "cf.switch"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, flag, defaultOperands, caseOperands, case_operand_segments, defaultDestination, caseDestinations, *, case_values=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(flag)
    operands.append(_get_op_results_or_values(defaultOperands))
    operands.append(_get_op_results_or_values(caseOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if case_values is not None: attributes["case_values"] = (case_values if (
        isinstance(case_values, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AnyIntElementsAttr')) else
          _ods_ir.AttrBuilder.get('AnyIntElementsAttr')(case_values, context=_ods_context))
    attributes["case_operand_segments"] = (case_operand_segments if (
    isinstance(case_operand_segments, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(case_operand_segments, context=_ods_context))
    _ods_successors = []
    _ods_successors.append(defaultDestination)
    _ods_successors.extend(caseDestinations)
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def flag(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def defaultOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def caseOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def case_values(self):
    if "case_values" not in self.operation.attributes:
      return None
    return self.operation.attributes["case_values"]

  @case_values.setter
  def case_values(self, value):
    if value is not None:
      self.operation.attributes["case_values"] = value
    elif "case_values" in self.operation.attributes:
      del self.operation.attributes["case_values"]

  @case_values.deleter
  def case_values(self):
    del self.operation.attributes["case_values"]

  @builtins.property
  def case_operand_segments(self):
    return self.operation.attributes["case_operand_segments"]

  @case_operand_segments.setter
  def case_operand_segments(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["case_operand_segments"] = value

def switch(flag, default_operands, case_operands, case_operand_segments, default_destination, case_destinations, *, case_values=None, loc=None, ip=None) -> _ods_ir.Operation:
  return SwitchOp(flag=flag, defaultOperands=default_operands, caseOperands=case_operands, case_operand_segments=case_operand_segments, defaultDestination=default_destination, caseDestinations=case_destinations, case_values=case_values, loc=loc, ip=ip)
