"""Fix some columns

Revision ID: 35c79626ecb9
Revises: ade87195b0a0
Create Date: 2020-08-21 11:42:07.044762

"""
from alembic import op
from sqlalchemy.exc import OperationalError

# pylint: skip-file

# revision identifiers, used by Alembic.
revision = "35c79626ecb9"
down_revision = "ade87195b0a0"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        op.create_index(
            op.f("ix_pyfunceble_mined_mined"),
            "pyfunceble_mined",
            ["mined"],
            unique=False,
        )
    except OperationalError:
        pass

    try:
        op.drop_index("mined", table_name="pyfunceble_mined")
    except OperationalError:
        pass

    try:
        op.create_index(
            op.f("ix_pyfunceble_status_tested"),
            "pyfunceble_status",
            ["tested"],
            unique=False,
        )
    except OperationalError:
        pass

    try:
        op.drop_index("tested", table_name="pyfunceble_status")
    except OperationalError:
        pass
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        op.create_index("tested", "pyfunceble_status", ["tested"], unique=True)
    except OperationalError:
        pass

    try:
        op.drop_index(
            op.f("ix_pyfunceble_status_tested"), table_name="pyfunceble_status"
        )
    except OperationalError:
        pass

    try:
        op.create_index("mined", "pyfunceble_mined", ["mined"], unique=True)
    except OperationalError:
        pass

    try:
        op.drop_index(op.f("ix_pyfunceble_mined_mined"), table_name="pyfunceble_mined")
    except OperationalError:
        pass
    # ### end Alembic commands ###
