"""
The tool to check the availability or syntax of domain, IP or URL.

::


    ██████╗ ██╗   ██╗███████╗██╗   ██╗███╗   ██╗ ██████╗███████╗██████╗ ██╗     ███████╗
    ██╔══██╗╚██╗ ██╔╝██╔════╝██║   ██║████╗  ██║██╔════╝██╔════╝██╔══██╗██║     ██╔════╝
    ██████╔╝ ╚████╔╝ █████╗  ██║   ██║██╔██╗ ██║██║     █████╗  ██████╔╝██║     █████╗
    ██╔═══╝   ╚██╔╝  ██╔══╝  ██║   ██║██║╚██╗██║██║     ██╔══╝  ██╔══██╗██║     ██╔══╝
    ██║        ██║   ██║     ╚██████╔╝██║ ╚████║╚██████╗███████╗██████╔╝███████╗███████╗
    ╚═╝        ╚═╝   ╚═╝      ╚═════╝ ╚═╝  ╚═══╝ ╚═════╝╚══════╝╚═════╝ ╚══════╝╚══════╝

Provides the base of everything related to the continue logic(s).

Author:
    Nissar Chababy, @funilrys, contactTATAfunilrysTODTODcom

Special thanks:
    https://pyfunceble.github.io/#/special-thanks

Contributors:
    https://pyfunceble.github.io/#/contributors

Project link:
    https://github.com/funilrys/PyFunceble

Project documentation:
    https://pyfunceble.readthedocs.io/en/dev/

Project homepage:
    https://pyfunceble.github.io/

License:
::


    Copyright 2017, 2018, 2019, 2020, 2021 Nissar Chababy

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from typing import Generator, List, Tuple

from PyFunceble.dataset.db_base import DBDatasetBase


class ContinueDatasetBase(DBDatasetBase):
    """
    Provides the base of all continue related interface.
    """

    FIELDS: List[str] = [
        "idna_subject",
        "checker_type",
        "destination",
        "source",
        "tested_at",
        "session_id",
    ]

    COMPARISON_FIELDS: List[str] = [
        "idna_subject",
        "checker_type",
        "destination",
        "source",
        "session_id",
    ]

    @DBDatasetBase.execute_if_authorized(None)
    def get_to_test(self, session_id: str) -> Generator[Tuple[str], str, None]:
        """
        Provides the next subject to test.

        This method provides the dataset directly from the autocontinue dataset.
        This method only compare the `tested_at` field.
        If it older than 20 years, that means that we still have to test
        the subject.

        :param session_id:
            The session ID to work with.
        """

        raise NotImplementedError()
