use std::collections::HashMap;

use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize, Clone)]
pub struct Banzai {
    api_params: HashMap<String, i32>,
}

impl Default for Banzai {
    fn default() -> Self {
        Self::new()
    }
}

impl Banzai {
    pub fn new() -> Self {
        Self {
            api_params: HashMap::new(),
        }
    }

    pub fn get_params(&self, unimplemented_api: &str) -> i32 {
        if self.api_params.contains_key(unimplemented_api) {
            return self.api_params[unimplemented_api];
        }
        panic!("banzai list dont have the params of {}", unimplemented_api);
    }

    pub fn add(&mut self, name: &str, nparams: i32) {
        self.api_params.insert(name.to_string(), nparams);
    }

    pub fn _init() {
        // now this is loaded from maps32/

        /*
        self.add("??2@YAPAXI@Z", 1);
        self.add("??2@YAPEAX_K@Z", 1);
        self.add("??3@YAXPAX@Z", 1);
        self.add("??3@YAXPEAX@Z", 1);
        self.add("abnormal_termination", 0);
        self.add("abort", 0);
        self.add("AbortDoc", 1);
        self.add("AbortPath", 1);
        self.add("AbortPrinter", 1);
        self.add("AbortSystemShutdown", 1);
        self.add("ABProviderInit", 9);
        self.add("abs", 1);
        self.add("abs64", 1);
        self.add("accept", 3);
        self.add("AcceptEx", 8);
        self.add("AcceptSecurityContext", 9);
        self.add("access", 2);
        self.add("AccessCheck", 8);
        self.add("AccessCheckAndAuditAlarm", 11);
        self.add("AccessCheckByType", 11);
        self.add("AccessCheckByTypeAndAuditAlarm", 16);
        self.add("AccessCheckByTypeResultList", 11);
        self.add("AccessCheckByTypeResultListAndAuditAlarm", 16);
        self.add("AccessCheckByTypeResultListAndAuditAlarmByHandle", 17);
        self.add("AccessibleChildren", 5);
        self.add("AccessibleObjectFromEvent", 5);
        self.add("AccessibleObjectFromPoint", 3);
        self.add("AccessibleObjectFromWindow", 4);
        self.add("access_s", 2);
        self.add("AccSetRunningUtilityState", 3);
        self.add("acmDriverAdd", 5);
        self.add("acmDriverClose", 2);
        self.add("acmDriverDetails", 3);
        self.add("acmDriverEnum", 3);
        self.add("acmDriverID", 3);
        self.add("acmDriverMessage", 4);
        self.add("acmDriverOpen", 3);
        self.add("acmDriverPriority", 3);
        self.add("acmDriverRemove", 2);
        self.add("acmFilterChoose", 1);
        self.add("acmFilterDetails", 3);
        self.add("acmFilterEnum", 5);
        self.add("acmFilterTagDetails", 3);
        self.add("acmFilterTagEnum", 5);
        self.add("acmFormatChoose", 1);
        self.add("acmFormatDetails", 3);
        self.add("acmFormatEnum", 5);
        self.add("acmFormatSuggest", 5);
        self.add("acmFormatTagDetails", 3);
        self.add("acmFormatTagEnum", 5);
        self.add("acmGetVersion", 0);
        self.add("acmMetrics", 3);
        self.add("acmStreamClose", 2);
        self.add("acmStreamConvert", 3);
        self.add("acmStreamMessage", 4);
        self.add("acmStreamOpen", 8);
        self.add("acmStreamPrepareHeader", 3);
        self.add("acmStreamReset", 2);
        self.add("acmStreamSize", 4);
        self.add("acmStreamUnprepareHeader", 3);
        self.add("acos", 1);
        self.add("acosf", 1);
        self.add("AcquireCredentialsHandle", 9);
        self.add("AcquireDeveloperLicense", 2);
        self.add("AcquireSRWLockExclusive", 1);
        self.add("AcquireSRWLockShared", 1);
        self.add("ActivateActCtx", 2);
        self.add("ActivateKeyboardLayout", 2);
        self.add("AddAccessAllowedAce", 4);
        self.add("AddAccessAllowedAceEx", 5);
        self.add("AddAccessAllowedObjectAce", 7);
        self.add("AddAccessDeniedAce", 4);
        self.add("AddAccessDeniedAceEx", 5);
        self.add("AddAccessDeniedObjectAce", 7);
        self.add("AddAce", 5);
        self.add("AddAtom", 1);
        self.add("AddAuditAccessAce", 6);
        self.add("AddAuditAccessAceEx", 7);
        self.add("AddAuditAccessObjectAce", 9);
        self.add("AddClipboardFormatListener", 1);
        self.add("AddCommasExportW", 2);
        self.add("AddConditionalAce", 8);
        self.add("AddConsoleAlias", 3);
        self.add("AddDllDirectory", 1);
        self.add("AddERExcludedApplication", 1);
        self.add("AddFontMemResourceEx", 4);
        self.add("AddFontResource", 1);
        self.add("AddFontResourceA", 1);
        self.add("AddFontResourceEx", 3);
        self.add("AddFontResourceExA", 3);
        self.add("AddFontResourceExW", 3);
        self.add("AddFontResourceW", 1);
        self.add("AddForm", 3);
        self.add("AddIntegrityLabelToBoundaryDescriptor", 2);
        self.add("AddIPAddress", 5);
        self.add("AddIScsiConnection", 9);
        self.add("AddIScsiSendTargetPortal", 5);
        self.add("AddIScsiStaticTarget", 7);
        self.add("AddISNSServer", 1);
        self.add("AddJob", 5);
        self.add("AddLocalAlternateComputerName", 2);
        self.add("AddLogContainer", 4);
        self.add("AddLogContainerSet", 5);
        self.add("AddMandatoryAce", 5);
        self.add("AddMonitor", 3);
        self.add("AddMRUStringW", 2);
        self.add("AddPersistentIScsiDevice", 1);
        self.add("AddPointerInteractionContext", 2);
        self.add("AddPort", 3);
        self.add("AddPrinter", 3);
        self.add("AddPrinterConnection", 1);
        self.add("AddPrinterConnection2", 4);
        self.add("AddPrinterDriver", 3);
        self.add("AddPrinterDriverEx", 4);
        self.add("AddPrintProcessor", 4);
        self.add("AddPrintProvidor", 3);
        self.add("AddRadiusServer", 1);
        self.add("AddRefActCtx", 1);
        self.add("AddResourceAttributeAce", 7);
        self.add("AddScopedPolicyIDAce", 5);
        self.add("AddSecureMemoryCacheCallback", 1);
        self.add("AddSecurityPackage", 2);
        self.add("AddSIDToBoundaryDescriptor", 2);
        self.add("AddUsersToEncryptedFile", 2);
        self.add("AddVectoredContinueHandler", 2);
        self.add("AddVectoredExceptionHandler", 2);
        self.add("AddVirtualDiskParent", 2);
        self.add("AdjustCalendarDate", 3);
        self.add("AdjustTokenGroups", 6);
        self.add("AdjustTokenPrivileges", 6);
        self.add("AdjustWindowRect", 3);
        self.add("AdjustWindowRectEx", 4);
        self.add("ADsBuildEnumerator", 2);
        self.add("ADsBuildVarArrayInt", 3);
        self.add("ADsBuildVarArrayStr", 3);
        self.add("ADsEncodeBinaryData", 3);
        self.add("ADsEnumerateNext", 4);
        self.add("ADsFreeEnumerator", 1);
        self.add("ADsGetLastError", 5);
        self.add("ADsGetObject", 3);
        self.add("ADsOpenObject", 6);
        self.add("ADsPropCheckIfWritable", 2);
        self.add("ADsPropCreateNotifyObj", 3);
        self.add("ADsPropGetInitInfo", 2);
        self.add("ADsPropSendErrorMessage", 2);
        self.add("ADsPropSetHwnd", 2);
        self.add("ADsPropSetHwndWithTitle", 3);
        self.add("ADsPropShowErrorDialog", 2);
        self.add("ADsSetLastError", 3);
        self.add("AdvancedDocumentProperties", 5);
        self.add("AdvanceLogBase", 4);
        self.add("aligned_free", 1);
        self.add("aligned_free_dbg", 1);
        self.add("aligned_malloc", 2);
        self.add("aligned_malloc_dbg", 4);
        self.add("aligned_msize", 3);
        self.add("aligned_msize_dbg", 3);
        self.add("aligned_offset_malloc", 3);
        self.add("aligned_offset_malloc_dbg", 5);
        self.add("aligned_offset_realloc", 4);
        self.add("aligned_offset_realloc_dbg", 6);
        self.add("aligned_offset_recalloc", 5);
        self.add("aligned_offset_recalloc_dbg", 7);
        self.add("aligned_realloc", 3);
        self.add("aligned_realloc_dbg", 5);
        self.add("aligned_recalloc", 4);
        self.add("aligned_recalloc_dbg", 6);
        self.add("AlignReservedLog", 4);
        self.add("AllocADsMem", 1);
        self.add("AllocADsStr", 1);
        self.add("AllocateAndGetTcpExTableFromStack", 5);
        self.add("AllocateAndGetUdpExTableFromStack", 5);
        self.add("AllocateAndInitializeSid", 11);
        self.add("AllocateFunctionEx", 4);
        self.add("AllocateLocallyUniqueId", 1);
        self.add("AllocateUserPhysicalPages", 3);
        self.add("AllocateUserPhysicalPagesNuma", 4);
        self.add("AllocateVirtualMemoryExCallback", 8);
        self.add("AllocConsole", 0);
        self.add("AllocReservedLog", 3);
        self.add("AllowActivateDetachQueuesSetFocus", 0);
        self.add("AllowSetForegroundWindow", 1);
        self.add("AlphaBlend", 11);
        self.add("amsg_exit", 1);
        self.add("AngleArc", 6);
        self.add("AnimatePalette", 4);
        self.add("AnimateWindow", 3);
        self.add("AnyPopup", 0);
        self.add("AnyPopup", 1);
        self.add("AppCacheCheckManifest", 8);
        self.add("AppCacheCloseHandle", 1);
        self.add("AppCacheDeleteGroup", 1);
        self.add("AppCacheDeleteIEGroup", 1);
        self.add("AppCacheDuplicateHandle", 2);
        self.add("AppCacheFinalize", 4);
        self.add("AppCacheFreeDownloadList", 1);
        self.add("AppCacheFreeGroupList", 1);
        self.add("AppCacheFreeIESpace", 1);
        self.add("AppCacheGetDownloadList", 2);
        self.add("AppCacheGetFallbackUrl", 3);
        self.add("AppCacheGetGroupList", 1);
        self.add("AppCacheGetIEGroupList", 1);
        self.add("AppCacheGetInfo", 2);
        self.add("AppCacheGetManifestUrl", 2);
        self.add("AppCacheLookup", 3);
        self.add("AppCompat_RunDLLW", 4);
        self.add("AppendMenu", 4);
        self.add("AppendTailList", 2);
        self.add("ApplicationRecoveryFinished", 1);
        self.add("ApplicationRecoveryInProgress", 1);
        self.add("ApplyControlToken", 2);
        self.add("ApplyPatchToFile", 4);
        self.add("ApplyPatchToFileByBuffers", 11);
        self.add("ApplyPatchToFileByHandles", 4);
        self.add("ApplyPatchToFileByHandlesEx", 6);
        self.add("ApplyPatchToFileEx", 6);
        self.add("Arc", 9);
        self.add("ArcTo", 9);
        self.add("AreAllAccessesGranted", 2);
        self.add("AreAnyAccessesGranted", 2);
        self.add("AreFileApisANSI", 0);
        self.add("AreFileApisANSI", 1);
        self.add("ArrangeIconicWindows", 1);
        self.add("asctime", 1);
        self.add("asctime_s", 3);
        self.add("asin", 1);
        self.add("asinf", 1);
        self.add("AssignProcessToJobObject", 2);
        self.add("AssocCreate", 3);
        self.add("AssocCreateForClasses", 4);
        self.add("AssocGetDetailsOfPropKey", 5);
        self.add("AssocGetPerceivedType", 4);
        self.add("AssociateColorProfileWithDevice", 3);
        self.add("AssocIsDangerous", 1);
        self.add("AssocQueryKey", 5);
        self.add("AssocQueryKeyA", 5);
        self.add("AssocQueryKeyW", 5);
        self.add("AssocQueryString", 6);
        self.add("AssocQueryStringA", 6);
        self.add("AssocQueryStringByKey", 6);
        self.add("AssocQueryStringByKeyA", 6);
        self.add("AssocQueryStringByKeyW", 6);
        self.add("AssocQueryStringW", 6);
        self.add("AsyncInstallDistributionUnit", 9);
        self.add("atan", 1);
        self.add("atan2", 2);
        self.add("atan2f", 2);
        self.add("atanf", 1);
        self.add("atexit", 1);
        self.add("atodbl", 2);
        self.add("atodbl_l", 3);
        self.add("atof", 1);
        self.add("atof_l", 2);
        self.add("atoflt", 2);
        self.add("atoflt_l", 3);
        self.add("atoi", 1);
        self.add("atoi64", 1);
        self.add("atoi64_l", 2);
        self.add("atoi_l", 2);
        self.add("atol", 1);
        self.add("atoldbl", 2);
        self.add("atoldbl_l", 3);
        self.add("atol_l", 2);
        self.add("AttachConsole", 1);
        self.add("AttachThreadInput", 3);
        self.add("AttachVirtualDisk", 6);
        self.add("AuditComputeEffectivePolicyBySid", 4);
        self.add("AuditComputeEffectivePolicyByToken", 4);
        self.add("AuditEnumerateCategories", 2);
        self.add("AuditEnumeratePerUserPolicy", 1);
        self.add("AuditEnumerateSubCategories", 4);
        self.add("AuditFree", 1);
        self.add("AuditLookupCategoryGuidFromCategoryId", 2);
        self.add("AuditLookupCategoryIdFromCategoryGuid", 2);
        self.add("AuditLookupCategoryName", 2);
        self.add("AuditLookupSubCategoryName", 2);
        self.add("AuditQueryGlobalSacl", 2);
        self.add("AuditQueryPerUserPolicy", 4);
        self.add("AuditQuerySecurity", 2);
        self.add("AuditQuerySystemPolicy", 3);
        self.add("AuditSetGlobalSacl", 2);
        self.add("AuditSetPerUserPolicy", 3);
        self.add("AuditSetSecurity", 2);
        self.add("AuditSetSystemPolicy", 2);
        self.add("AuthzAccessCheck", 9);
        self.add("AuthzAddSidsToContext", 6);
        self.add("AuthzCachedAccessCheck", 5);
        self.add("AuthzEnumerateSecurityEventSources", 4);
        self.add("AuthzFreeAuditEvent", 1);
        self.add("AuthzFreeCentralAccessPolicyCache", 0);
        self.add("AuthzFreeContext", 1);
        self.add("AuthzFreeHandle", 1);
        self.add("AuthzFreeResourceManager", 1);
        self.add("AuthzGetInformationFromContext", 5);
        self.add("AuthzInitializeCompoundContext", 3);
        self.add("AuthzInitializeContextFromAuthzContext", 6);
        self.add("AuthzInitializeContextFromSid", 7);
        self.add("AuthzInitializeContextFromToken", 7);
        self.add("AuthzInitializeObjectAccessAuditEvent2", 9);
        self.add("AuthzInitializeObjectAccessAuditEvent", 8);
        self.add("AuthzInitializeRemoteResourceManager", 2);
        self.add("AuthzInitializeResourceManager", 6);
        self.add("AuthzInitializeResourceManagerEx", 3);
        self.add("AuthzInstallSecurityEventSource", 2);
        self.add("AuthzModifyClaims", 4);
        self.add("AuthzModifySecurityAttributes", 3);
        self.add("AuthzModifySids", 4);
        self.add("AuthzOpenObjectAudit", 8);
        self.add("AuthzRegisterCapChangeNotification", 3);
        self.add("AuthzRegisterSecurityEventSource", 3);
        self.add("AuthzReportSecurityEvent", 5);
        self.add("AuthzReportSecurityEventFromParams", 5);
        self.add("AuthzSetAppContainerInformation", 4);
        self.add("AuthzUninstallSecurityEventSource", 2);
        self.add("AuthzUnregisterCapChangeNotification", 1);
        self.add("AuthzUnregisterSecurityEventSource", 2);
        self.add("auxGetDevCaps", 3);
        self.add("auxGetNumDevs", 0);
        self.add("auxGetVolume", 2);
        self.add("auxOutMessage", 4);
        self.add("auxSetVolume", 2);
        self.add("AVIBuildFilter", 3);
        self.add("AVIClearClipboard", 0);
        self.add("AVIFileAddRef", 1);
        self.add("AVIFileCreateStream", 3);
        self.add("AVIFileEndRecord", 1);
        self.add("AVIFileExit", 0);
        self.add("AVIFileGetStream", 4);
        self.add("AVIFileInfo", 3);
        self.add("AVIFileInit", 0);
        self.add("AVIFileOpen", 4);
        self.add("AVIFileReadData", 4);
        self.add("AVIFileRelease", 1);
        self.add("AVIFileWriteData", 4);
        self.add("AVIGetFromClipboard", 1);
        self.add("AVIMakeCompressedStream", 4);
        self.add("AVIMakeFileFromStreams", 3);
        self.add("AVIMakeStreamFromClipboard", 3);
        self.add("AVIPutFileOnClipboard", 1);
        self.add("AVISave", 6);
        self.add("AVISaveOptions", 5);
        self.add("AVISaveOptionsFree", 2);
        self.add("AVISaveV", 6);
        self.add("AVIStreamAddRef", 1);
        self.add("AVIStreamBeginStreaming", 4);
        self.add("AVIStreamCreate", 4);
        self.add("AVIStreamEndStreaming", 1);
        self.add("AVIStreamFindSample", 3);
        self.add("AVIStreamGetFrame", 2);
        self.add("AVIStreamGetFrameClose", 1);
        self.add("AVIStreamGetFrameOpen", 2);
        self.add("AVIStreamInfo", 3);
        self.add("AVIStreamLength", 1);
        self.add("AVIStreamOpenFromFile", 6);
        self.add("AVIStreamRead", 7);
        self.add("AVIStreamReadData", 4);
        self.add("AVIStreamReadFormat", 4);
        self.add("AVIStreamRelease", 1);
        self.add("AVIStreamSampleToTime", 2);
        self.add("AVIStreamSetFormat", 4);
        self.add("AVIStreamStart", 1);
        self.add("AVIStreamTimeToSample", 2);
        self.add("AVIStreamWrite", 8);
        self.add("AVIStreamWriteData", 4);
        self.add("AvQuerySystemResponsiveness", 2);
        self.add("AvRevertMmThreadCharacteristics", 1);
        self.add("AvRtCreateThreadOrderingGroup", 4);
        self.add("AvRtCreateThreadOrderingGroupEx", 5);
        self.add("AvRtDeleteThreadOrderingGroup", 1);
        self.add("AvRtJoinThreadOrderingGroup", 3);
        self.add("AvRtLeaveThreadOrderingGroup", 1);
        self.add("AvRtWaitOnThreadOrderingGroup", 1);
        self.add("AvSetMmMaxThreadCharacteristics", 3);
        self.add("AvSetMmThreadCharacteristics", 2);
        self.add("AvSetMmThreadPriority", 2);
        self.add("BackupEventLog", 2);
        self.add("BackupRead", 7);
        self.add("BackupSeek", 6);
        self.add("BackupWrite", 7);
        self.add("BarrierAfterRead", 1);
        self.add("BaseFormatTimeOut", 2);
        self.add("BaseGetNamedObjectDirectory", 1);
        self.add("Basep8BitStringToDynamicUnicodeString", 2);
        self.add("BCryptAddContextFunction", 5);
        self.add("BCryptCloseAlgorithmProvider", 2);
        self.add("BCryptConfigureContext", 3);
        self.add("BCryptConfigureContextFunction", 5);
        self.add("BCryptCreateContext", 3);
        self.add("BCryptCreateHash", 7);
        self.add("BCryptDecrypt", 10);
        self.add("BCryptDeleteContext", 2);
        self.add("BCryptDeriveKey", 7);
        self.add("BCryptDeriveKeyCapi", 5);
        self.add("BCryptDeriveKeyPBKDF2", 9);
        self.add("BCryptDestroyHash", 1);
        self.add("BCryptDestroyKey", 1);
        self.add("BCryptDestroySecret", 1);
        self.add("BCryptDuplicateHash", 5);
        self.add("BCryptDuplicateKey", 5);
        self.add("BCryptEncrypt", 10);
        self.add("BCryptEnumAlgorithms", 4);
        self.add("BCryptEnumContextFunctionProviders", 6);
        self.add("BCryptEnumContextFunctions", 5);
        self.add("BCryptEnumContexts", 3);
        self.add("BCryptEnumProviders", 4);
        self.add("BCryptEnumRegisteredProviders", 2);
        self.add("BCryptExportKey", 7);
        self.add("BCryptFinalizeKeyPair", 2);
        self.add("BCryptFinishHash", 4);
        self.add("BCryptFreeBuffer", 1);
        self.add("BCryptGenerateKeyPair", 4);
        self.add("BCryptGenerateSymmetricKey", 7);
        self.add("BCryptGenRandom", 4);
        self.add("BCryptGetFipsAlgorithmMode", 1);
        self.add("BCryptGetProperty", 6);
        self.add("BCryptHashData", 4);
        self.add("BCryptImportKey", 9);
        self.add("BCryptImportKeyPair", 7);
        self.add("BCryptKeyDerivation", 6);
        self.add("BCryptOpenAlgorithmProvider", 4);
        self.add("BCryptQueryContextConfiguration", 4);
        self.add("BCryptQueryContextFunctionConfiguration", 6);
        self.add("BCryptQueryContextFunctionProperty", 7);
        self.add("BCryptQueryProviderRegistration", 5);
        self.add("BCryptRegisterConfigChangeNotify", 1);
        self.add("BCryptRemoveContextFunction", 4);
        self.add("BCryptResolveProviders", 8);
        self.add("BCryptSecretAgreement", 4);
        self.add("BCryptSetContextFunctionProperty", 7);
        self.add("BCryptSetProperty", 5);
        self.add("BCryptSignHash", 8);
        self.add("BCryptUnregisterConfigChangeNotify", 1);
        self.add("BCryptVerifySignature", 7);
        self.add("beep", 2);
        self.add("Beep", 2);
        self.add("BeginBufferedAnimation", 8);
        self.add("BeginBufferedPaint", 5);
        self.add("BeginDeferWindowPos", 1);
        self.add("BeginIdleDetection", 3);
        self.add("BeginPaint", 2);
        self.add("BeginPanningFeedback", 1);
        self.add("BeginPath", 1);
        self.add("beginthread", 3);
        self.add("beginthreadex", 6);
        self.add("BeginUpdateResource", 2);
        self.add("ber_alloc_t", 1);
        self.add("ber_bvdup", 1);
        self.add("ber_bvecfree", 1);
        self.add("ber_bvfree", 1);
        self.add("ber_first_element", 3);
        self.add("ber_flatten", 2);
        self.add("ber_free", 2);
        self.add("ber_init", 1);
        self.add("ber_next_element", 3);
        self.add("ber_peek_tag", 2);
        self.add("ber_printf", 2);
        self.add("ber_scanf", 2);
        self.add("ber_skip_tag", 2);
        self.add("bind", 3);
        self.add("BindIFilterFromStorage", 3);
        self.add("BindIFilterFromStream", 3);
        self.add("BindImage", 3);
        self.add("BindImageEx", 5);
        self.add("BindIoCompletionCallback", 3);
        self.add("BindMoniker", 4);
        self.add("BitBlt", 9);
        self.add("_BitTest64", 2);
        self.add("_BitTestAndComplement64", 2);
        self.add("_BitTestAndReset64", 2);
        self.add("_BitTestAndSet64", 2);
        self.add("BlockInput", 1);
        self.add("BluetoothAuthenticateDevice", 5);
        self.add("BluetoothAuthenticateDeviceEx", 5);
        self.add("BluetoothAuthenticateMultipleDevices", 4);
        self.add("BluetoothDisplayDeviceProperties", 2);
        self.add("BluetoothEnableDiscovery", 2);
        self.add("BluetoothEnableIncomingConnections", 2);
        self.add("BluetoothEnumerateInstalledServices", 4);
        self.add("BluetoothFindDeviceClose", 1);
        self.add("BluetoothFindFirstDevice", 2);
        self.add("BluetoothFindFirstRadio", 2);
        self.add("BluetoothFindNextDevice", 2);
        self.add("BluetoothFindNextRadio", 2);
        self.add("BluetoothFindRadioClose", 1);
        self.add("BluetoothGetDeviceInfo", 2);
        self.add("BluetoothGetRadioInfo", 2);
        self.add("BluetoothIsConnectable", 1);
        self.add("BluetoothIsDiscoverable", 1);
        self.add("BluetoothIsVersionAvailable", 2);
        self.add("BluetoothRegisterForAuthentication", 4);
        self.add("BluetoothRegisterForAuthenticationEx", 4);
        self.add("BluetoothRemoveDevice", 1);
        self.add("BluetoothSdpEnumAttributes", 4);
        self.add("BluetoothSdpGetAttributeValue", 4);
        self.add("BluetoothSdpGetContainerElementData", 4);
        self.add("BluetoothSdpGetElementData", 3);
        self.add("BluetoothSdpGetString", 6);
        self.add("BluetoothSelectDevices", 1);
        self.add("BluetoothSelectDevicesFree", 1);
        self.add("BluetoothSendAuthenticationResponse", 3);
        self.add("BluetoothSendAuthenticationResponseEx", 2);
        self.add("BluetoothSetLocalServiceInfo", 4);
        self.add("BluetoothSetServiceState", 4);
        self.add("BluetoothUnregisterAuthentication", 1);
        self.add("BluetoothUpdateDeviceRecord", 1);
        self.add("BoundCallback", 1);
        self.add("BreakMirrorVirtualDisk", 1);
        self.add("BringWindowToTop", 1);
        self.add("BroadcastSystemMessage", 5);
        self.add("BroadcastSystemMessageA", 5);
        self.add("BroadcastSystemMessageEx", 6);
        self.add("BroadcastSystemMessageExA", 6);
        self.add("BroadcastSystemMessageExW", 6);
        self.add("BroadcastSystemMessageW", 5);
        self.add("BrowseForGPO", 1);
        self.add("bsearch", 5);
        self.add("bsearch_s", 6);
        self.add("BstrFromVector", 2);
        self.add("BSTR_UserFree", 2);
        self.add("BSTR_UserFree64", 2);
        self.add("BSTR_UserMarshal", 3);
        self.add("BSTR_UserMarshal64", 3);
        self.add("BSTR_UserSize", 3);
        self.add("BSTR_UserSize64", 3);
        self.add("BSTR_UserUnmarshal", 3);
        self.add("BSTR_UserUnmarshal64", 3);
        self.add("btowc", 1);
        self.add("BufferedPaintClear", 2);
        self.add("BufferedPaintInit", 0);
        self.add("BufferedPaintRenderAnimation", 2);
        self.add("BufferedPaintSetAlpha", 3);
        self.add("BufferedPaintStopAllAnimations", 1);
        self.add("BufferedPaintUnInit", 0);
        self.add("BufferPointerPacketsInteractionContext", 3);
        self.add("BuildCommDCB", 2);
        self.add("BuildCommDCBAndTimeouts", 3);
        self.add("BuildDisplayTable", 10);
        self.add("BuildExplicitAccessWithName", 5);
        self.add("BuildImpersonateExplicitAccessWithName", 6);
        self.add("BuildImpersonateTrustee", 2);
        self.add("BuildSecurityDescriptor", 9);
        self.add("BuildTrusteeWithName", 2);
        self.add("BuildTrusteeWithObjectsAndName", 6);
        self.add("BuildTrusteeWithObjectsAndSid", 5);
        self.add("BuildTrusteeWithSid", 2);
        self.add("byteswap_uint64", 1);
        self.add("byteswap_ulong", 1);
        self.add("byteswap_ushort", 1);
        self.add("cabs", 1);
        self.add("CalculatePopupWindowPosition", 5);
        self.add("CallbackMayRunLong", 1);
        self.add("CallCPLEntry16", 6);
        self.add("CallMsgFilter", 2);
        self.add("CallMsgFilterA", 2);
        self.add("CallMsgFilterW", 2);
        self.add("CallNamedPipe", 7);
        self.add("callnewh", 1);
        self.add("CallNextHookEx", 4);
        self.add("CallNtPowerInformation", 5);
        self.add("calloc", 2);
        self.add("calloc_dbg", 5);
        self.add("CallWindowProc", 5);
        self.add("CallWindowProcA", 5);
        self.add("CallWindowProcW", 5);
        self.add("CancelDC", 1);
        self.add("CancelIo", 1);
        self.add("CancelIoEx", 2);
        self.add("CancelIPChangeNotify", 1);
        self.add("CancelMibChangeNotify2", 1);
        self.add("CancelSecurityHealthChangeNotify", 1);
        self.add("CancelSynchronousIo", 1);
        self.add("CancelThreadpoolIo", 1);
        self.add("CancelWaitableTimer", 1);
        self.add("CanSendToFaxRecipient", 0);
        self.add("CanShareFolderW", 1);
        self.add("CanUserWritePwrScheme", 0);
        self.add("CapabilitiesRequestAndCapabilitiesReply", 3);
        self.add("capCreateCaptureWindow", 8);
        self.add("capGetDriverDescription", 5);
        self.add("CascadeWindows", 5);
        self.add("CcCanIWrite", 4);
        self.add("CcCoherencyFlushAndPurgeCache", 5);
        self.add("CcCopyRead", 6);
        self.add("CcCopyReadEx", 7);
        self.add("CcCopyWrite", 5);
        self.add("CcCopyWriteEx", 6);
        self.add("CcCopyWriteWontFlush", 3);
        self.add("CcDeferWrite", 6);
        self.add("CcFastCopyRead", 6);
        self.add("CcFastCopyWrite", 4);
        self.add("CcFlushCache", 4);
        self.add("CcGetCacheFileSize", 1);
        self.add("CcGetDirtyPages", 4);
        self.add("CcGetFileObjectFromBcb", 1);
        self.add("CcGetFileObjectFromSectionPtrs", 1);
        self.add("CcGetFileObjectFromSectionPtrsRef", 1);
        self.add("CcGetFlushedValidData", 2);
        self.add("CcInitializeCacheMap", 5);
        self.add("CcIsThereDirtyData", 1);
        self.add("CcIsThereDirtyDataEx", 2);
        self.add("CcMapData", 6);
        self.add("CcMdlReadComplete", 2);
        self.add("CcMdlWriteAbort", 2);
        self.add("CcMdlWriteComplete", 3);
        self.add("CcPinMappedData", 5);
        self.add("CcPinRead", 6);
        self.add("CcPrepareMdlWrite", 5);
        self.add("CcPreparePinWrite", 7);
        self.add("CcPurgeCacheSection", 4);
        self.add("CcRemapBcb", 1);
        self.add("CcRepinBcb", 1);
        self.add("CcScheduleReadAhead", 3);
        self.add("CcScheduleReadAheadEx", 4);
        self.add("CcSetAdditionalCacheAttributes", 3);
        self.add("CcSetAdditionalCacheAttributesEx", 2);
        self.add("CcSetBcbOwnerPointer", 2);
        self.add("CcSetCacheFileSizes", 2);
        self.add("CcSetDirtyPageThreshold", 2);
        self.add("CcSetDirtyPinnedData", 2);
        self.add("CcSetFileSizes", 2);
        self.add("CcSetLogHandleForFile", 3);
        self.add("CcSetReadAheadGranularity", 2);
        self.add("CcUninitializeCacheMap", 3);
        self.add("CcUnpinData", 1);
        self.add("CcUnpinDataForThread", 2);
        self.add("CcUnpinRepinnedBcb", 3);
        self.add("CcWaitForCurrentLazyWriterActivity", 1);
        self.add("CcZeroData", 4);
        self.add("CDefFolderMenu_Create2", 9);
        self.add("CdromDisableDigitalPlayback", 2);
        self.add("CdromEnableDigitalPlayback", 3);
        self.add("CdromIsDigitalPlaybackEnabled", 3);
        self.add("CdromKnownGoodDigitalPlayback", 2);
        self.add("ceil", 1);
        self.add("ceilf", 1);
        self.add("CertAddCertificateContextToStore", 4);
        self.add("CertAddCertificateLinkToStore", 4);
        self.add("CertAddCRLContextToStore", 4);
        self.add("CertAddCRLLinkToStore", 4);
        self.add("CertAddCTLContextToStore", 4);
        self.add("CertAddCTLLinkToStore", 4);
        self.add("CertAddEncodedCertificateToStore", 6);
        self.add("CertAddEncodedCRLToStore", 6);
        self.add("CertAddEncodedCTLToStore", 6);
        self.add("CertAddEnhancedKeyUsageIdentifier", 2);
        self.add("CertAddRefServerOcspResponse", 1);
        self.add("CertAddRefServerOcspResponseContext", 1);
        self.add("CertAddSerializedElementToStore", 8);
        self.add("CertAddStoreToCollection", 4);
        self.add("CertAlgIdToOID", 1);
        self.add("CertCloseServerOcspResponse", 2);
        self.add("CertCloseStore", 2);
        self.add("CertCompareCertificate", 3);
        self.add("CertCompareCertificateName", 3);
        self.add("CertCompareIntegerBlob", 2);
        self.add("CertComparePublicKeyInfo", 3);
        self.add("CertControlStore", 4);
        self.add("CertCreateCertificateChainEngine", 2);
        self.add("CertCreateCertificateContext", 3);
        self.add("CertCreateContext", 6);
        self.add("CertCreateCRLContext", 3);
        self.add("CertCreateCTLContext", 3);
        self.add("CertCreateCTLEntryFromCertificateContextProperties", 7);
        self.add("CertCreateSelfSignCertificate", 8);
        self.add("CertDeleteCertificateFromStore", 1);
        self.add("CertDeleteCRLFromStore", 1);
        self.add("CertDeleteCTLFromStore", 1);
        self.add("CertDuplicateCertificateChain", 1);
        self.add("CertDuplicateCertificateContext", 1);
        self.add("CertDuplicateCRLContext", 1);
        self.add("CertDuplicateCTLContext", 1);
        self.add("CertDuplicateStore", 1);
        self.add("CertEnumCertificateContextProperties", 2);
        self.add("CertEnumCertificatesInStore", 2);
        self.add("CertEnumCRLContextProperties", 2);
        self.add("CertEnumCRLsInStore", 2);
        self.add("CertEnumCTLContextProperties", 2);
        self.add("CertEnumCTLsInStore", 2);
        self.add("CertEnumPhysicalStore", 4);
        self.add("CertEnumSubjectInSortedCTL", 4);
        self.add("CertEnumSystemStore", 4);
        self.add("CertEnumSystemStoreLocation", 3);
        self.add("CertFindAttribute", 3);
        self.add("CertFindCertificateInCRL", 5);
        self.add("CertFindCertificateInStore", 6);
        self.add("CertFindChainInStore", 6);
        self.add("CertFindCRLInStore", 6);
        self.add("CertFindCTLInStore", 6);
        self.add("CertFindExtension", 3);
        self.add("CertFindRDNAttr", 2);
        self.add("CertFindSubjectInCTL", 5);
        self.add("CertFindSubjectInSortedCTL", 5);
        self.add("CertFreeCertificateChain", 1);
        self.add("CertFreeCertificateChainEngine", 1);
        self.add("CertFreeCertificateChainList", 1);
        self.add("CertFreeCertificateContext", 1);
        self.add("CertFreeCRLContext", 1);
        self.add("CertFreeCTLContext", 1);
        self.add("CertGetCertificateChain", 8);
        self.add("CertGetCertificateContextProperty", 4);
        self.add("CertGetCRLContextProperty", 4);
        self.add("CertGetCRLFromStore", 4);
        self.add("CertGetCTLContextProperty", 4);
        self.add("CertGetEnhancedKeyUsage", 4);
        self.add("CertGetIntendedKeyUsage", 4);
        self.add("CertGetIssuerCertificateFromStore", 4);
        self.add("CertGetNameString", 6);
        self.add("CertGetPublicKeyLength", 2);
        self.add("CertGetServerOcspResponseContext", 3);
        self.add("CertGetStoreProperty", 4);
        self.add("CertGetSubjectCertificateFromStore", 3);
        self.add("CertGetValidUsages", 5);
        self.add("CertIsRDNAttrsInCertificateName", 4);
        self.add("CertIsStrongHashToSign", 3);
        self.add("CertIsValidCRLForCertificate", 4);
        self.add("CertModifyCertificatesToTrust", 6);
        self.add("CertNameToStr", 5);
        self.add("CertOIDToAlgId", 1);
        self.add("CertOpenServerOcspResponse", 3);
        self.add("CertOpenStore", 5);
        self.add("CertOpenSystemStore", 2);
        self.add("CertRDNValueToStr", 4);
        self.add("CertRegisterPhysicalStore", 5);
        self.add("CertRegisterSystemStore", 4);
        self.add("CertRemoveEnhancedKeyUsageIdentifier", 2);
        self.add("CertRemoveStoreFromCollection", 2);
        self.add("CertRetrieveLogoOrBiometricInfo", 9);
        self.add("CertSaveStore", 6);
        self.add("CertSelectCertificate", 1);
        self.add("CertSelectCertificateChains", 8);
        self.add("CertSerializeCertificateStoreElement", 4);
        self.add("CertSerializeCRLStoreElement", 4);
        self.add("CertSerializeCTLStoreElement", 4);
        self.add("CertSetCertificateContextPropertiesFromCTLEntry", 3);
        self.add("CertSetCertificateContextProperty", 4);
        self.add("CertSetCRLContextProperty", 4);
        self.add("CertSetCTLContextProperty", 4);
        self.add("CertSetEnhancedKeyUsage", 2);
        self.add("CertSetStoreProperty", 4);
        self.add("CertSrvBackupClose", 1);
        self.add("CertSrvBackupEnd", 1);
        self.add("CertSrvBackupFree", 1);
        self.add("CertSrvBackupGetBackupLogsW", 3);
        self.add("CertSrvBackupGetDatabaseNamesW", 3);
        self.add("CertSrvBackupGetDynamicFileListW", 3);
        self.add("CertSrvBackupOpenFileW", 4);
        self.add("CertSrvBackupPrepareW", 4);
        self.add("CertSrvBackupRead", 4);
        self.add("CertSrvBackupTruncateLogs", 1);
        self.add("CertSrvIsServerOnlineW", 2);
        self.add("CertSrvRestoreEnd", 1);
        self.add("CertSrvRestoreGetDatabaseLocationsW", 3);
        self.add("CertSrvRestorePrepareW", 3);
        self.add("CertSrvRestoreRegisterComplete", 2);
        self.add("CertSrvRestoreRegisterThroughFile", 8);
        self.add("CertSrvRestoreRegisterW", 8);
        self.add("CertSrvServerControlW", 4);
        self.add("CertStrToName", 7);
        self.add("CertUnregisterPhysicalStore", 3);
        self.add("CertUnregisterSystemStore", 2);
        self.add("CertVerifyCertificateChainPolicy", 4);
        self.add("CertVerifyCRLRevocation", 4);
        self.add("CertVerifyCRLTimeValidity", 2);
        self.add("CertVerifyCTLUsage", 7);
        self.add("CertVerifyRevocation", 7);
        self.add("CertVerifySubjectCertificateContext", 3);
        self.add("CertVerifyTimeValidity", 2);
        self.add("CertVerifyValidityNesting", 2);
        self.add("c_exit", 0);
        self.add("cexit", 0);
        self.add("cgets", 1);
        self.add("cgets_s", 3);
        self.add("cgetws", 1);
        self.add("cgetws_s", 2);
        self.add("ChangeAccountPassword", 8);
        self.add("ChangeClipboardChain", 2);
        self.add("ChangeDisplaySettings", 2);
        self.add("ChangeDisplaySettingsA", 2);
        self.add("ChangeDisplaySettingsEx", 5);
        self.add("ChangeDisplaySettingsExA", 5);
        self.add("ChangeDisplaySettingsExW", 5);
        self.add("ChangeDisplaySettingsW", 2);
        self.add("ChangeIdleRoutine", 7);
        self.add("ChangeServiceConfig", 11);
        self.add("ChangeServiceConfig2", 3);
        self.add("ChangeTimerQueueTimer", 4);
        self.add("ChangeWindowMessageFilter", 2);
        self.add("ChangeWindowMessageFilterEx", 4);
        self.add("CharLower", 1);
        self.add("CharLowerBuff", 2);
        self.add("CharLowerWrapW", 1);
        self.add("CharNext", 1);
        self.add("CharNextExA", 3);
        self.add("CharPrev", 2);
        self.add("CharPrevExA", 4);
        self.add("CharToOem", 2);
        self.add("CharToOemBuff", 3);
        self.add("CharUpper", 1);
        self.add("CharUpperBuff", 2);
        self.add("CharUpperBuffWrapW", 2);
        self.add("chdir", 1);
        self.add("chdrive", 1);
        self.add("CheckBitmapBits", 9);
        self.add("CheckColors", 5);
        self.add("CheckColorsInGamut", 4);
        self.add("CheckDeveloperLicense", 1);
        self.add("CheckDlgButton", 3);
        self.add("CheckElevation", 5);
        self.add("CheckElevationEnabled", 1);
        self.add("CheckMenuItem", 3);
        self.add("CheckMenuRadioItem", 5);
        self.add("CheckNameLegalDOS8Dot3", 5);
        self.add("CheckParms", 2);
        self.add("CheckRadioButton", 4);
        self.add("CheckRemoteDebuggerPresent", 2);
        self.add("CheckStagingArea", 0);
        self.add("CheckSumMappedFile", 4);
        self.add("CheckTokenCapability", 3);
        self.add("CheckTokenMembership", 3);
        self.add("CheckTokenMembershipEx", 4);
        self.add("chgsign", 1);
        self.add("chgsignf", 1);
        self.add("ChildWindowFromPoint", 2);
        self.add("ChildWindowFromPointEx", 3);
        self.add("chmod", 2);
        self.add("ChooseColor", 1);
        self.add("ChooseFont", 1);
        self.add("ChoosePixelFormat", 2);
        self.add("Chord", 9);
        self.add("ChrCmpI", 2);
        self.add("ChrCmpIA", 2);
        self.add("ChrCmpIW", 2);
        self.add("chsize", 2);
        self.add("chsize_s", 2);
        self.add("CIBuildQueryNode", 7);
        self.add("CIBuildQueryTree", 4);
        self.add("CICreateCommand", 5);
        self.add("CIDLData_CreateFromIDArray", 4);
        self.add("CIMakeICommand", 6);
        self.add("CIRestrictionToFullTree", 8);
        self.add("CIState", 3);
        self.add("CITextToFullTree", 8);
        self.add("CITextToFullTreeEx", 9);
        self.add("CITextToSelectTree", 5);
        self.add("CITextToSelectTreeEx", 6);
        self.add("cldap_open", 2);
        self.add("ClearCommBreak", 1);
        self.add("ClearCommError", 3);
        self.add("ClearCustData", 1);
        self.add("clearerr", 1);
        self.add("clearerr_s", 1);
        self.add("ClearEventLog", 2);
        self.add("clearfp", 0);
        self.add("ClearPersistentIScsiDevices", 0);
        self.add("ClfsAddLogContainer", 3);
        self.add("ClfsAddLogContainerSet", 4);
        self.add("ClfsAdvanceLogBase", 3);
        self.add("ClfsAlignReservedLog", 4);
        self.add("ClfsAllocReservedLog", 3);
        self.add("ClfsCloseAndResetLogFile", 1);
        self.add("ClfsCloseLogFileObject", 1);
        self.add("ClfsCreateLogFile", 11);
        self.add("ClfsCreateMarshallingArea", 8);
        self.add("ClfsCreateScanContext", 5);
        self.add("ClfsDeleteLogByPointer", 1);
        self.add("ClfsDeleteLogFile", 5);
        self.add("ClfsDeleteMarshallingArea", 1);
        self.add("ClfsFlushBuffers", 1);
        self.add("ClfsFlushToLsn", 3);
        self.add("ClfsGetContainerName", 4);
        self.add("ClfsGetIoStatistics", 5);
        self.add("ClfsLsnBlockOffset", 1);
        self.add("ClfsLsnContainer", 1);
        self.add("ClfsLsnCreate", 3);
        self.add("ClfsLsnEqual", 2);
        self.add("ClfsLsnGreater", 2);
        self.add("ClfsLsnLess", 2);
        self.add("ClfsLsnNull", 1);
        self.add("ClfsLsnRecordSequence", 1);
        self.add("ClfsMgmtDeregisterManagedClient", 1);
        self.add("ClfsMgmtHandleLogFileFull", 1);
        self.add("ClfsMgmtInstallPolicy", 3);
        self.add("ClfsMgmtQueryPolicy", 4);
        self.add("ClfsMgmtRegisterManagedClient", 3);
        self.add("ClfsMgmtRemovePolicy", 2);
        self.add("ClfsMgmtSetLogFileSize", 5);
        self.add("ClfsMgmtSetLogFileSizeAsClient", 6);
        self.add("ClfsMgmtTailAdvanceFailure", 2);
        self.add("ClfsQueryLogFileInformation", 6);
        self.add("ClfsReadLogRecord", 9);
        self.add("ClfsReadNextLogRecord", 8);
        self.add("ClfsReadPreviousRestartArea", 4);
        self.add("ClfsReadRestartArea", 5);
        self.add("ClfsRemoveLogContainer", 3);
        self.add("ClfsRemoveLogContainerSet", 4);
        self.add("ClfsReserveAndAppendLog", 9);
        self.add("ClfsReserveAndAppendLogAligned", 10);
        self.add("ClfsScanLogContainers", 2);
        self.add("ClfsSetArchiveTail", 2);
        self.add("ClfsSetEndOfLog", 2);
        self.add("ClfsSetLogFileInformation", 4);
        self.add("ClfsTerminateReadLog", 1);
        self.add("ClfsWriteRestartArea", 7);
        self.add("ClientToScreen", 2);
        self.add("ClipCursor", 1);
        self.add("clock", 0);
        self.add("close", 1);
        self.add("CloseAndResetLogFile", 1);
        self.add("CloseClipboard", 0);
        self.add("CloseColorProfile", 1);
        self.add("CloseCompressor", 1);
        self.add("CloseDecompressor", 1);
        self.add("CloseDesktop", 1);
        self.add("CloseDriver", 3);
        self.add("CloseEncryptedFileRaw", 1);
        self.add("CloseEnhMetaFile", 1);
        self.add("CloseEventLog", 1);
        self.add("CloseFigure", 1);
        self.add("CloseGestureInfoHandle", 1);
        self.add("CloseHandle", 1);
        self.add("CloseIMsgSession", 1);
        self.add("CloseMetaFile", 1);
        self.add("ClosePackageInfo", 1);
        self.add("ClosePrinter", 1);
        self.add("ClosePrivateNamespace", 2);
        self.add("CloseServiceHandle", 1);
        self.add("closesocket", 1);
        self.add("CloseThemeData", 1);
        self.add("CloseThreadpool", 1);
        self.add("CloseThreadpoolCleanupGroup", 1);
        self.add("CloseThreadpoolCleanupGroupMembers", 3);
        self.add("CloseThreadpoolIo", 1);
        self.add("CloseThreadpoolTimer", 1);
        self.add("CloseThreadpoolWait", 1);
        self.add("CloseThreadpoolWork", 1);
        self.add("CloseThreadWaitChainSession", 1);
        self.add("CloseTouchInputHandle", 1);
        self.add("CloseTrace", 1);
        self.add("CloseWindow", 1);
        self.add("CloseWindowStation", 1);
        self.add("CLSIDFromProgID", 2);
        self.add("CLSIDFromProgIDEx", 2);
        self.add("CLSIDFromString", 2);
        self.add("CM_Add_Empty_Log_Conf", 4);
        self.add("CM_Add_Empty_Log_Conf_Ex", 5);
        self.add("CM_Add_ID", 3);
        self.add("CM_Add_ID_Ex", 4);
        self.add("CM_Add_Range", 4);
        self.add("CM_Add_Res_Des", 6);
        self.add("CM_Add_Res_Des_Ex", 7);
        self.add("CM_Apply_PowerScheme", 0);
        self.add("CmCallbackGetKeyObjectID", 4);
        self.add("CmCallbackGetKeyObjectIDEx", 5);
        self.add("CmCallbackReleaseKeyObjectIDEx", 1);
        self.add("CMCheckColors", 5);
        self.add("CMCheckColorsInGamut", 4);
        self.add("CMCheckRGBs", 9);
        self.add("CM_Connect_Machine", 2);
        self.add("CMConvertColorNameToIndex", 4);
        self.add("CMConvertIndexToColorName", 4);
        self.add("CMCreateDeviceLinkProfile", 6);
        self.add("CM_Create_DevNode", 4);
        self.add("CM_Create_DevNode_Ex", 5);
        self.add("CMCreateMultiProfileTransform", 5);
        self.add("CMCreateProfile", 2);
        self.add("CM_Create_Range_List", 2);
        self.add("CMCreateTransformExt", 4);
        self.add("CM_Delete_Class_Key", 2);
        self.add("CM_Delete_Class_Key_Ex", 3);
        self.add("CM_Delete_Device_Interface_Key", 2);
        self.add("CM_Delete_Device_Interface_Key_Ex", 3);
        self.add("CM_Delete_DevNode_Key", 3);
        self.add("CM_Delete_DevNode_Key_Ex", 4);
        self.add("CM_Delete_PowerScheme", 2);
        self.add("CM_Delete_Range", 4);
        self.add("CMDeleteTransform", 1);
        self.add("CM_Detect_Resource_Conflict", 6);
        self.add("CM_Detect_Resource_Conflict_Ex", 7);
        self.add("CM_Disable_DevNode", 2);
        self.add("CM_Disable_DevNode_Ex", 3);
        self.add("CM_Disconnect_Machine", 1);
        self.add("CM_Duplicate_PowerScheme", 3);
        self.add("CM_Dup_Range_List", 3);
        self.add("CM_Enable_DevNode", 2);
        self.add("CM_Enable_DevNode_Ex", 3);
        self.add("CM_Enumerate_Classes", 3);
        self.add("CM_Enumerate_Classes_Ex", 4);
        self.add("CM_Enumerate_Enumerators", 4);
        self.add("CM_Enumerate_Enumerators_Ex", 5);
        self.add("CM_Find_Range", 7);
        self.add("CM_First_Range", 5);
        self.add("CmFree", 1);
        self.add("CM_Free_Log_Conf", 2);
        self.add("CM_Free_Log_Conf_Ex", 3);
        self.add("CM_Free_Log_Conf_Handle", 1);
        self.add("CM_Free_Range_List", 2);
        self.add("CM_Free_Res_Des", 3);
        self.add("CM_Free_Res_Des_Ex", 4);
        self.add("CM_Free_Res_Des_Handle", 1);
        self.add("CM_Free_Resource_Conflict_Handle", 1);
        self.add("CmGetBoundTransaction", 2);
        self.add("CmGetCallbackVersion", 2);
        self.add("CM_Get_Child", 3);
        self.add("CM_Get_Child_Ex", 4);
        self.add("CM_Get_Class_Key_Name", 4);
        self.add("CM_Get_Class_Key_Name_Ex", 5);
        self.add("CM_Get_Class_Name", 4);
        self.add("CM_Get_Class_Name_Ex", 5);
        self.add("CM_Get_Class_Property_ExW", 7);
        self.add("CM_Get_Class_Property_Keys", 4);
        self.add("CM_Get_Class_Property_Keys_Ex", 5);
        self.add("CM_Get_Class_PropertyW", 6);
        self.add("CM_Get_Class_Registry_Property", 7);
        self.add("CM_Get_Depth", 3);
        self.add("CM_Get_Depth_Ex", 4);
        self.add("CM_Get_Device_ID", 4);
        self.add("CM_Get_Device_ID_Ex", 5);
        self.add("CM_Get_Device_ID_List", 4);
        self.add("CM_Get_Device_ID_List_Ex", 5);
        self.add("CM_Get_Device_ID_List_Size", 3);
        self.add("CM_Get_Device_ID_List_Size_Ex", 4);
        self.add("CM_Get_Device_ID_Size", 3);
        self.add("CM_Get_Device_ID_Size_Ex", 4);
        self.add("CM_Get_Device_Interface_Alias", 5);
        self.add("CM_Get_Device_Interface_Alias_Ex", 6);
        self.add("CM_Get_Device_Interface_List", 5);
        self.add("CM_Get_Device_Interface_List_Ex", 6);
        self.add("CM_Get_Device_Interface_List_Size", 4);
        self.add("CM_Get_Device_Interface_List_Size_Ex", 5);
        self.add("CM_Get_Device_Interface_Property_ExW", 7);
        self.add("CM_Get_Device_Interface_Property_Keys_ExW", 5);
        self.add("CM_Get_Device_Interface_Property_KeysW", 4);
        self.add("CM_Get_Device_Interface_PropertyW", 6);
        self.add("CM_Get_DevNode_Custom_Property", 6);
        self.add("CM_Get_DevNode_Custom_Property_ExW", 7);
        self.add("CM_Get_DevNode_Property_ExW", 7);
        self.add("CM_Get_DevNode_Property_Keys", 4);
        self.add("CM_Get_DevNode_Property_Keys_Ex", 5);
        self.add("CM_Get_DevNode_PropertyW", 6);
        self.add("CM_Get_DevNode_Registry_Property", 6);
        self.add("CM_Get_DevNode_Registry_Property_Ex", 7);
        self.add("CM_Get_DevNode_Status", 4);
        self.add("CM_Get_DevNode_Status_Ex", 5);
        self.add("CM_Get_First_Log_Conf", 3);
        self.add("CM_Get_First_Log_Conf_Ex", 4);
        self.add("CM_Get_Global_State", 2);
        self.add("CM_Get_Global_State_Ex", 3);
        self.add("CM_Get_Hardware_Profile_Info", 3);
        self.add("CM_Get_Hardware_Profile_Info_Ex", 4);
        self.add("CM_Get_HW_Prof_Flags", 3);
        self.add("CM_Get_HW_Prof_Flags_Ex", 5);
        self.add("CMGetInfo", 1);
        self.add("CM_Get_Log_Conf_Priority", 3);
        self.add("CM_Get_Log_Conf_Priority_Ex", 4);
        self.add("CMGetNamedProfileInfo", 2);
        self.add("CM_Get_Next_Log_Conf", 3);
        self.add("CM_Get_Next_Log_Conf_Ex", 4);
        self.add("CM_Get_Next_Res_Des", 5);
        self.add("CM_Get_Next_Res_Des_Ex", 6);
        self.add("CM_Get_Parent", 3);
        self.add("CM_Get_Parent_Ex", 4);
        self.add("CMGetPS2ColorRenderingDictionary", 5);
        self.add("CMGetPS2ColorRenderingIntent", 4);
        self.add("CMGetPS2ColorSpaceArray", 6);
        self.add("CM_Get_Res_Des_Data", 4);
        self.add("CM_Get_Res_Des_Data_Ex", 5);
        self.add("CM_Get_Res_Des_Data_Size", 3);
        self.add("CM_Get_Res_Des_Data_Size_Ex", 4);
        self.add("CM_Get_Resource_Conflict_Count", 2);
        self.add("CM_Get_Resource_Conflict_Details", 3);
        self.add("CM_Get_Sibling", 3);
        self.add("CM_Get_Sibling_Ex", 4);
        self.add("CM_Get_Version", 0);
        self.add("CM_Get_Version_Ex", 1);
        self.add("CM_Import_PowerScheme", 3);
        self.add("CM_Intersect_Range_List", 4);
        self.add("CM_Invert_Range_List", 4);
        self.add("CM_Is_Dock_Station_Present", 1);
        self.add("CM_Is_Dock_Station_Present_Ex", 2);
        self.add("CMIsProfileValid", 2);
        self.add("CM_Is_Version_Available", 1);
        self.add("CM_Is_Version_Available_Ex", 2);
        self.add("CM_Locate_DevNode", 3);
        self.add("CM_Locate_DevNode_Ex", 4);
        self.add("CmMalloc", 1);
        self.add("CM_Merge_Range_List", 4);
        self.add("CM_Modify_Res_Des", 6);
        self.add("CM_Modify_Res_Des_Ex", 7);
        self.add("CM_Move_DevNode", 3);
        self.add("CM_Move_DevNode_Ex", 4);
        self.add("CM_Next_Range", 4);
        self.add("CM_Open_Class_Key", 6);
        self.add("CM_Open_Class_Key_Ex", 7);
        self.add("CM_Open_Device_Interface_Key", 5);
        self.add("CM_Open_Device_Interface_Key_Ex", 6);
        self.add("CM_Open_DevNode_Key", 6);
        self.add("CM_Open_DevNode_Key_Ex", 7);
        self.add("CMP_WaitNoPendingInstallEvents", 1);
        self.add("CM_Query_And_Remove_SubTree", 5);
        self.add("CM_Query_And_Remove_SubTree_Ex", 5);
        self.add("CM_Query_Arbitrator_Free_Data", 5);
        self.add("CM_Query_Arbitrator_Free_Data_Ex", 6);
        self.add("CM_Query_Arbitrator_Free_Size", 4);
        self.add("CM_Query_Arbitrator_Free_Size_Ex", 5);
        self.add("CM_Query_Remove_SubTree", 2);
        self.add("CM_Query_Remove_SubTree_Ex", 3);
        self.add("CM_Query_Resource_Conflict_List", 7);
        self.add("CM_Reenumerate_DevNode", 2);
        self.add("CM_Reenumerate_DevNode_Ex", 3);
        self.add("CmRegisterCallback", 3);
        self.add("CmRegisterCallbackEx", 6);
        self.add("CM_Register_Device_Driver", 2);
        self.add("CM_Register_Device_Driver_Ex", 3);
        self.add("CM_Register_Device_Interface", 6);
        self.add("CM_Register_Device_Interface_Ex", 7);
        self.add("CM_Register_Notification", 4);
        self.add("CM_Remove_SubTree", 2);
        self.add("CM_Remove_SubTree_Ex", 3);
        self.add("CM_Request_Device_Eject", 5);
        self.add("CM_Request_Device_Eject_Ex", 5);
        self.add("CM_Request_Eject_PC", 0);
        self.add("CM_Request_Eject_PC_Ex", 1);
        self.add("CM_RestoreAll_DefaultPowerSchemes", 1);
        self.add("CM_Restore_DefaultPowerScheme", 2);
        self.add("CM_Run_Detection", 1);
        self.add("CM_Run_Detection_Ex", 2);
        self.add("CM_Set_ActiveScheme", 2);
        self.add("CmSetCallbackObjectContext", 4);
        self.add("CM_Set_Class_Property_ExW", 7);
        self.add("CM_Set_Class_PropertyW", 6);
        self.add("CM_Set_Class_Registry_Property", 6);
        self.add("CM_Set_Device_Interface_Property_ExW", 7);
        self.add("CM_Set_Device_Interface_PropertyW", 6);
        self.add("CM_Set_DevNode_Problem", 3);
        self.add("CM_Set_DevNode_Problem_Ex", 4);
        self.add("CM_Set_DevNode_Property_ExW", 7);
        self.add("CM_Set_DevNode_PropertyW", 6);
        self.add("CM_Set_DevNode_Registry_Property", 5);
        self.add("CM_Set_DevNode_Registry_Property_Ex", 6);
        self.add("CM_Set_HW_Prof", 2);
        self.add("CM_Set_HW_Prof_Ex", 3);
        self.add("CM_Set_HW_Prof_Flags", 4);
        self.add("CM_Set_HW_Prof_Flags_Ex", 5);
        self.add("CM_Setup_DevNode", 2);
        self.add("CM_Setup_DevNode_Ex", 3);
        self.add("CM_Test_Range_Available", 4);
        self.add("CMTranslateColors", 6);
        self.add("CMTranslateRGB", 4);
        self.add("CMTranslateRGBs", 9);
        self.add("CMTranslateRGBsExt", 11);
        self.add("CM_Uninstall_DevNode", 2);
        self.add("CM_Uninstall_DevNode_Ex", 3);
        self.add("CmUnRegisterCallback", 1);
        self.add("CM_Unregister_Device_Interface", 2);
        self.add("CM_Unregister_Device_Interface_Ex", 3);
        self.add("CM_Unregister_Notification", 1);
        self.add("CM_WaitNoPendingInstallEvents", 1);
        self.add("CM_Write_UserPowerKey", 8);
        self.add("CoAddRefServerProcess", 0);
        self.add("CoAllowSetForegroundWindow", 2);
        self.add("CoAllowUnmarshalerCLSID", 1);
        self.add("CoCancelCall", 2);
        self.add("CoCopyProxy", 2);
        self.add("CoCreateFreeThreadedMarshaler", 2);
        self.add("CoCreateGuid", 1);
        self.add("CoCreateInstance", 5);
        self.add("CoCreateInstanceEx", 6);
        self.add("CoCreateInstanceFromApp", 6);
        self.add("CoDecodeProxy", 3);
        self.add("CoDecrementMTAUsage", 1);
        self.add("CoDisableCallCancellation", 1);
        self.add("CoDisconnectContext", 1);
        self.add("CoDisconnectObject", 2);
        self.add("CoDosDateTimeToFileTime", 3);
        self.add("CoEnableCallCancellation", 1);
        self.add("CoEnterApplicationThreadLifetimeLoop", 0);
        self.add("CoFileTimeNow", 1);
        self.add("CoFileTimeToDosDateTime", 3);
        self.add("CoFreeAllLibraries", 0);
        self.add("CoFreeLibrary", 1);
        self.add("CoFreeUnusedLibraries", 0);
        self.add("CoFreeUnusedLibrariesEx", 2);
        self.add("CoGetApartmentType", 2);
        self.add("CoGetApplicationThreadReference", 1);
        self.add("CoGetCallContext", 2);
        self.add("CoGetCallerTID", 1);
        self.add("CoGetCancelObject", 3);
        self.add("CoGetClassObject", 5);
        self.add("CoGetClassObjectFromURL", 10);
        self.add("CoGetContextToken", 1);
        self.add("CoGetCurrentLogicalThreadId", 1);
        self.add("CoGetCurrentProcess", 0);
        self.add("CoGetInstanceFromFile", 8);
        self.add("CoGetInstanceFromIStorage", 7);
        self.add("CoGetInterceptor", 4);
        self.add("CoGetInterfaceAndReleaseStream", 3);
        self.add("CoGetMalloc", 2);
        self.add("CoGetMarshalSizeMax", 6);
        self.add("CoGetModuleType", 2);
        self.add("CoGetObject", 4);
        self.add("CoGetObjectContext", 2);
        self.add("CoGetPSClsid", 2);
        self.add("CoGetStandardMarshal", 6);
        self.add("CoGetStdMarshalEx", 3);
        self.add("CoGetTreatAsClass", 2);
        self.add("CoHandlePriorityEventsFromMessagePump", 0);
        self.add("CoImpersonateClient", 0);
        self.add("CoIncrementMTAUsage", 1);
        self.add("CoInitialize", 1);
        self.add("CoInitializeEx", 2);
        self.add("CoInitializeSecurity", 9);
        self.add("CoInstall", 5);
        self.add("CoInternetCombineIUri", 5);
        self.add("CoInternetCombineUrl", 7);
        self.add("CoInternetCombineUrlEx", 5);
        self.add("CoInternetCompareUrl", 3);
        self.add("CoInternetCreateSecurityManager", 3);
        self.add("CoInternetCreateZoneManager", 3);
        self.add("CoInternetGetProtocolFlags", 3);
        self.add("CoInternetGetSecurityUrl", 4);
        self.add("CoInternetGetSecurityUrlEx", 4);
        self.add("CoInternetGetSession", 3);
        self.add("CoInternetIsFeatureEnabled", 2);
        self.add("CoInternetIsFeatureEnabledForIUri", 4);
        self.add("CoInternetIsFeatureEnabledForUrl", 4);
        self.add("CoInternetIsFeatureZoneElevationEnabled", 4);
        self.add("CoInternetParseIUri", 7);
        self.add("CoInternetParseUrl", 7);
        self.add("CoInternetQueryInfo", 7);
        self.add("CoInternetSetFeatureEnabled", 3);
        self.add("CoInvalidateRemoteMachineBindings", 1);
        self.add("CoIsHandlerConnected", 1);
        self.add("CoIsOle1Class", 1);
        self.add("CoLoadLibrary", 2);
        self.add("CoLockObjectExternal", 3);
        self.add("ColorAdjustLuma", 3);
        self.add("ColorCorrectPalette", 4);
        self.add("ColorHLSToRGB", 3);
        self.add("ColorMatchToTarget", 3);
        self.add("ColorRGBToHLS", 4);
        self.add("CoMarshalHresult", 2);
        self.add("CoMarshalInterface", 6);
        self.add("CoMarshalInterThreadInterfaceInStream", 3);
        self.add("CombineRgn", 4);
        self.add("CombineTransform", 3);
        self.add("CommandLineToArgvW", 2);
        self.add("CommConfigDialog", 3);
        self.add("CommDlgExtendedError", 0);
        self.add("commit", 1);
        self.add("CommitComplete", 2);
        self.add("CommitEnlistment", 2);
        self.add("CommitTransaction", 1);
        self.add("CommitTransactionAsync", 1);
        self.add("CommitUrlCacheEntry", 9);
        self.add("CommitUrlCacheEntryA", 9);
        self.add("CommitUrlCacheEntryBinaryBlob", 6);
        self.add("CommitUrlCacheEntryW", 9);
        self.add("CompactVirtualDisk", 4);
        self.add("CompareFileTime", 2);
        self.add("CompareSecurityIds", 5);
        self.add("CompareString", 6);
        self.add("CompareStringEx", 9);
        self.add("CompareStringOrdinal", 5);
        self.add("CompareStringWrapW", 6);
        self.add("CompatFlagsFromClsid", 3);
        self.add("CompleteAuthToken", 2);
        self.add("Compress", 6);
        self.add("ConfigDriver", 7);
        self.add("ConfigDSN", 4);
        self.add("configthreadlocale", 1);
        self.add("ConfigTranslator", 2);
        self.add("ConfigurePort", 3);
        self.add("connect", 3);
        self.add("ConnectNamedPipe", 2);
        self.add("ConnectToConnectionPoint", 6);
        self.add("ConnectToPrinterDlg", 2);
        self.add("ConsoleMenuControl", 3);
        self.add("ContinueDebugEvent", 3);
        self.add("control87", 2);
        self.add("control87_2", 4);
        self.add("controlfp", 2);
        self.add("controlfp_s", 3);
        self.add("ControlService", 3);
        self.add("ControlServiceEx", 4);
        self.add("ControlTrace", 4);
        self.add("ConvertCalDateTimeToSystemTime", 2);
        self.add("ConvertColorNameToIndex", 4);
        self.add("ConvertDefaultLocale", 1);
        self.add("ConvertFiberToThread", 0);
        self.add("ConvertIndexToColorName", 4);
        self.add("ConvertInterfaceAliasToLuid", 2);
        self.add("ConvertInterfaceGuidToLuid", 2);
        self.add("ConvertInterfaceIndexToLuid", 2);
        self.add("ConvertInterfaceLuidToAlias", 3);
        self.add("ConvertInterfaceLuidToGuid", 2);
        self.add("ConvertInterfaceLuidToIndex", 2);
        self.add("ConvertInterfaceLuidToNameA", 3);
        self.add("ConvertInterfaceLuidToNameW", 3);
        self.add("ConvertInterfaceNameToLuidA", 2);
        self.add("ConvertInterfaceNameToLuidW", 2);
        self.add("ConvertIpv4MaskToLength", 2);
        self.add("ConvertLengthToIpv4Mask", 2);
        self.add("ConvertSecurityDescriptorToStringSecurityDescriptor", 5);
        self.add("ConvertSidToStringSid", 2);
        self.add("ConvertStringSecurityDescriptorToSecurityDescriptor", 4);
        self.add("ConvertStringSidToSid", 2);
        self.add("ConvertSystemTimeToCalDateTime", 3);
        self.add("ConvertThreadToFiber", 1);
        self.add("ConvertThreadToFiberEx", 2);
        self.add("ConvertToAutoInheritPrivateObjectSecurity", 6);
        self.add("CopyAcceleratorTable", 3);
        self.add("CopyBindInfo", 2);
        self.add("CopyContext", 3);
        self.add("CopyCursor", 1);
        self.add("CopyEnhMetaFile", 2);
        self.add("CopyEnhMetaFileA", 2);
        self.add("CopyEnhMetaFileW", 2);
        self.add("CopyExtendedContext", 3);
        self.add("CopyFile2", 3);
        self.add("CopyFile", 3);
        self.add("CopyFileEx", 6);
        self.add("CopyFileTransacted", 7);
        self.add("CopyIcon", 1);
        self.add("CopyImage", 5);
        self.add("CopyLZFile", 2);
        self.add("CopyMetaFile", 2);
        self.add("CopyMetaFileA", 2);
        self.add("CopyMetaFileW", 2);
        self.add("CopyRect", 2);
        self.add("CopySid", 3);
        self.add("copysign", 2);
        self.add("copysignf", 2);
        self.add("CopyStgMedium", 2);
        self.add("CoQueryAuthenticationServices", 2);
        self.add("CoQueryClientBlanket", 7);
        self.add("CoQueryProxyBlanket", 8);
        self.add("CorDllMain", 3);
        self.add("CoRegisterChannelHook", 2);
        self.add("CoRegisterClassObject", 5);
        self.add("CoRegisterInitializeSpy", 2);
        self.add("CoRegisterMallocSpy", 1);
        self.add("CoRegisterMessageFilter", 2);
        self.add("CoRegisterPSClsid", 2);
        self.add("CoRegisterSurrogate", 1);
        self.add("CoReleaseMarshalData", 1);
        self.add("CoReleaseServerProcess", 0);
        self.add("CorePrinterDriverInstalled", 6);
        self.add("CoResumeClassObjects", 0);
        self.add("CoRevertToSelf", 0);
        self.add("CoRevokeClassObject", 1);
        self.add("CoRevokeInitializeSpy", 1);
        self.add("CoRevokeMallocSpy", 0);
        self.add("CorExeMain", 0);
        self.add("CorExeMain2", 5);
        self.add("CorImageUnloading", 1);
        self.add("CorValidateImage", 2);
        self.add("cos", 1);
        self.add("CoSetCancelObject", 1);
        self.add("CoSetMessageDispatcher", 1);
        self.add("CoSetProxyBlanket", 8);
        self.add("cosf", 1);
        self.add("cosh", 1);
        self.add("coshf", 1);
        self.add("CoSuspendClassObjects", 0);
        self.add("CoSwitchCallContext", 2);
        self.add("CoTaskMemAlloc", 1);
        self.add("CoTaskMemFree", 1);
        self.add("CoTaskMemRealloc", 2);
        self.add("CoTestCancel", 0);
        self.add("CoTreatAsClass", 2);
        self.add("CoUninitialize", 0);
        self.add("CoUnmarshalHresult", 2);
        self.add("CoUnmarshalInterface", 3);
        self.add("CountClipboardFormats", 0);
        self.add("CoWaitForMultipleHandles", 5);
        self.add("CoWaitForMultipleObjects", 5);
        self.add("CPlApplet", 4);
        self.add("cprintf", 1);
        self.add("cprintf_l", 2);
        self.add("cprintf_p", 1);
        self.add("cprintf_p_l", 2);
        self.add("cprintf_s", 1);
        self.add("cprintf_s_l", 2);
        self.add("cputs", 1);
        self.add("cputws", 1);
        self.add("creat", 2);
        self.add("CreateAcceleratorTable", 2);
        self.add("CreateActCtx", 1);
        self.add("CreateAntiMoniker", 1);
        self.add("CreateAnycastIpAddressEntry", 1);
        self.add("CreateAppContainerProfile", 6);
        self.add("CreateAssemblyCache", 2);
        self.add("CreateAssemblyNameObject", 4);
        self.add("CreateAsyncBindCtx", 4);
        self.add("CreateAsyncBindCtxEx", 6);
        self.add("CreateAutoListParser", 2);
        self.add("CreateBindCtx", 2);
        self.add("CreateBitmap", 5);
        self.add("CreateBitmapIndirect", 1);
        self.add("CreateBoundaryDescriptor", 2);
        self.add("CreateBrushIndirect", 1);
        self.add("CreateCaret", 4);
        self.add("CreateClassMoniker", 2);
        self.add("CreateColorSpace", 1);
        self.add("CreateColorTransform", 4);
        self.add("CreateCompatibleBitmap", 3);
        self.add("CreateCompatibleDC", 1);
        self.add("CreateCompressor", 3);
        self.add("CreateConsoleScreenBuffer", 5);
        self.add("CreateCursor", 7);
        self.add("CreateDataAdviseHolder", 1);
        self.add("CreateDataCache", 4);
        self.add("CreateDC", 4);
        self.add("CreateDCA", 4);
        self.add("CreateDCW", 4);
        self.add("CreateDecompressor", 3);
        self.add("CreateDesktop", 6);
        self.add("CreateDesktopEx", 8);
        self.add("CreateDeviceLinkProfile", 7);
        self.add("CreateDialogIndirectParam", 5);
        self.add("CreateDialogIndirectParamA", 5);
        self.add("CreateDialogIndirectParamW", 5);
        self.add("CreateDialogParam", 5);
        self.add("CreateDialogParamA", 5);
        self.add("CreateDialogParamW", 5);
        self.add("CreateDIBitmap", 6);
        self.add("CreateDIBPatternBrush", 2);
        self.add("CreateDIBPatternBrushPt", 2);
        self.add("CreateDIBSection", 6);
        self.add("CreateDirectory", 2);
        self.add("CreateDirectoryA", 2);
        self.add("CreateDirectoryEx", 3);
        self.add("CreateDirectoryTransacted", 4);
        self.add("CreateDirectoryW", 2);
        self.add("CreateDiscardableBitmap", 3);
        self.add("CreateDispTypeInfo", 3);
        self.add("CreateEditableStream", 2);
        self.add("CreateEllipticRgn", 4);
        self.add("CreateEllipticRgnIndirect", 1);
        self.add("CreateEnhMetaFile", 4);
        self.add("CreateEnhMetaFileA", 4);
        self.add("CreateEnhMetaFileW", 4);
        self.add("CreateEnlistment", 6);
        self.add("CreateEnvironmentBlock", 3);
        self.add("CreateErrorInfo", 1);
        self.add("CreateEvent", 4);
        self.add("CreateEventA", 4);
        self.add("CreateEventEx", 4);
        self.add("CreateEventExA", 4);
        self.add("CreateEventExW", 4);
        self.add("CreateEventW", 4);
        self.add("CreateFiber", 3);
        self.add("CreateFiberEx", 5);
        self.add("CreateFile2", 5);
        self.add("CreateFile", 7);
        self.add("CreateFileA", 7);
        self.add("CreateFileMapping", 6);
        self.add("CreateFileMappingFromApp", 5);
        self.add("CreateFileMappingNuma", 7);
        self.add("CreateFileMoniker", 2);
        self.add("CreateFileTransacted", 10);
        self.add("CreateFileW", 7);
        self.add("CreateFont", 14);
        self.add("CreateFontA", 14);
        self.add("CreateFontIndirect", 1);
        self.add("CreateFontIndirectA", 1);
        self.add("CreateFontIndirectEx", 1);
        self.add("CreateFontIndirectExA", 1);
        self.add("CreateFontIndirectExW", 1);
        self.add("CreateFontIndirectW", 1);
        self.add("CreateFontW", 14);
        self.add("CreateFormatEnumerator", 3);
        self.add("CreateGenericComposite", 3);
        self.add("CreateGPOLink", 3);
        self.add("CreateHalftonePalette", 1);
        self.add("CreateHardLink", 3);
        self.add("CreateHardLinkTransacted", 4);
        self.add("CreateHardwareEventMoniker", 3);
        self.add("CreateHatchBrush", 2);
        self.add("CreateIC", 4);
        self.add("CreateICA", 4);
        self.add("CreateIcon", 7);
        self.add("CreateIconFromResource", 4);
        self.add("CreateIconFromResourceEx", 7);
        self.add("CreateIconIndirect", 1);
        self.add("CreateICW", 4);
        self.add("CreateILockBytesOnHGlobal", 3);
        self.add("CreateInfoTipFromItem2", 6);
        self.add("CreateInfoTipFromItem", 5);
        self.add("CreateInteractionContext", 1);
        self.add("CreateIoCompletionPort", 4);
        self.add("CreateIpForwardEntry", 1);
        self.add("CreateIpForwardEntry2", 1);
        self.add("CreateIpNetEntry", 1);
        self.add("CreateIpNetEntry2", 1);
        self.add("CreateIProp", 6);
        self.add("CreateItemMoniker", 3);
        self.add("CreateIUriBuilder", 4);
        self.add("CreateJobObject", 2);
        self.add("create_locale", 2);
        self.add("CreateLogContainerScanContext", 6);
        self.add("CreateLogFile", 6);
        self.add("CreateLogMarshallingArea", 8);
        self.add("CreateMailslot", 4);
        self.add("CreateMappedBitmap", 5);
        self.add("CreateMD5SSOHash", 4);
        self.add("CreateMDIWindow", 10);
        self.add("CreateMDIWindowA", 10);
        self.add("CreateMDIWindowW", 10);
        self.add("CreateMemoryResourceNotification", 1);
        self.add("CreateMenu", 0);
        self.add("CreateMetaFile", 1);
        self.add("CreateMetaFileA", 1);
        self.add("CreateMetaFileW", 1);
        self.add("CreateMRUListW", 1);
        self.add("CreateMultiProfileTransform", 6);
        self.add("CreateMutex", 3);
        self.add("CreateMutexA", 3);
        self.add("CreateMutexEx", 4);
        self.add("CreateMutexExA", 4);
        self.add("CreateMutexExW", 4);
        self.add("CreateMutexW", 3);
        self.add("CreateNamedPipe", 8);
        self.add("CreateNamedPropertyStore", 1);
        self.add("CreateObjrefMoniker", 2);
        self.add("CreateOleAdviseHolder", 1);
        self.add("CreatePalette", 1);
        self.add("CreatePatchFile", 5);
        self.add("CreatePatchFileByHandles", 5);
        self.add("CreatePatchFileByHandlesEx", 8);
        self.add("CreatePatchFileEx", 8);
        self.add("CreatePatternBrush", 1);
        self.add("CreatePen", 3);
        self.add("CreatePenIndirect", 1);
        self.add("CreatePersistentTcpPortReservation", 3);
        self.add("CreatePersistentUdpPortReservation", 3);
        self.add("CreatePipe", 4);
        self.add("CreatePointerMoniker", 2);
        self.add("CreatePolygonRgn", 3);
        self.add("CreatePolyPolygonRgn", 4);
        self.add("CreatePopupMenu", 0);
        self.add("CreatePrintAsyncNotifyChannel", 6);
        self.add("CreatePrivateNamespace", 3);
        self.add("CreatePrivateObjectSecurity", 6);
        self.add("CreatePrivateObjectSecurityEx", 8);
        self.add("CreatePrivateObjectSecurityWithMultipleInheritance", 9);
        self.add("CreateProcess", 10);
        self.add("CreateProcessA", 10);
        self.add("CreateProcessAsUser", 11);
        self.add("CreateProcessAsUserA", 11);
        self.add("CreateProcessAsUserW", 11);
        self.add("CreateProcessW", 10);
        self.add("CreateProcessWithLogonW", 11);
        self.add("CreateProcessWithTokenW", 9);
        self.add("CreateProfile", 4);
        self.add("CreateProfileFromLogColorSpace", 2);
        self.add("CreatePropertySheetPage", 1);
        self.add("CreatePropertyStore", 1);
        self.add("CreateProxyArpEntry", 3);
        self.add("CreateRandomAccessStreamOnFile", 4);
        self.add("CreateRandomAccessStreamOverStream", 4);
        self.add("CreateRectRgn", 4);
        self.add("CreateRectRgnIndirect", 1);
        self.add("CreateRemoteThread", 7);
        self.add("CreateRemoteThreadEx", 8);
        self.add("CreateResourceManager", 5);
        self.add("CreateRestrictedToken", 9);
        self.add("CreateRoundRectRgn", 6);
        self.add("CreateScalableFontResource", 4);
        self.add("CreateScalableFontResourceA", 4);
        self.add("CreateScalableFontResourceW", 4);
        self.add("CreateSecurityPage", 1);
        self.add("CreateSemaphore", 4);
        self.add("CreateSemaphoreEx", 6);
        self.add("CreateSemaphoreExW", 6);
        self.add("CreateSemaphoreW", 4);
        self.add("CreateService", 13);
        self.add("CreateSolidBrush", 1);
        self.add("CreateSortedAddressPairs", 7);
        self.add("CreateStatusWindow", 4);
        self.add("CreateStdAccessibleObject", 4);
        self.add("CreateStdAccessibleProxy", 5);
        self.add("CreateStdDispatch", 4);
        self.add("CreateStreamOnHGlobal", 3);
        self.add("CreateStreamOverRandomAccessStream", 3);
        self.add("CreateSymbolicLink", 3);
        self.add("CreateSymbolicLinkTransacted", 4);
        self.add("CreateTable", 9);
        self.add("CreateTapePartition", 4);
        self.add("CreateThread", 6);
        self.add("CreateThreadpool", 1);
        self.add("CreateThreadpoolCleanupGroup", 0);
        self.add("CreateThreadpoolIo", 4);
        self.add("CreateThreadpoolTimer", 3);
        self.add("CreateThreadpoolWait", 3);
        self.add("CreateThreadpoolWork", 3);
        self.add("CreateTimerQueue", 0);
        self.add("CreateTimerQueueTimer", 7);
        self.add("CreateToolbarEx", 13);
        self.add("CreateToolhelp32Snapshot", 2);
        self.add("CreateTraceInstanceId", 2);
        self.add("CreateTransaction", 7);
        self.add("CreateTransactionManager", 4);
        self.add("CreateTypeLib2", 3);
        self.add("CreateTypeLib", 3);
        self.add("CreateUmsCompletionList", 1);
        self.add("CreateUmsThreadContext", 1);
        self.add("CreateUnicastIpAddressEntry", 1);
        self.add("CreateUpDownControl", 12);
        self.add("CreateUri", 4);
        self.add("CreateUriFromMultiByteString", 6);
        self.add("CreateUriWithFragment", 5);
        self.add("CreateURLBinding", 3);
        self.add("CreateUrlCacheContainer", 8);
        self.add("CreateUrlCacheEntry", 5);
        self.add("CreateUrlCacheEntryA", 5);
        self.add("CreateUrlCacheEntryExW", 6);
        self.add("CreateUrlCacheEntryW", 5);
        self.add("CreateUrlCacheGroup", 2);
        self.add("CreateURLMoniker", 3);
        self.add("CreateURLMonikerEx2", 4);
        self.add("CreateURLMonikerEx", 4);
        self.add("CreateUserProfileEx", 6);
        self.add("CreateVirtualDisk", 9);
        self.add("CreateVPNConnection", 6);
        self.add("CreateVssBackupComponentsInternal", 1);
        self.add("?CreateVssBackupComponents@@YAJPEAPEAVIVssBackupComponents@@@Z", 1);
        self.add("?CreateVssBackupComponents@@YGJPAPAVIVssBackupComponents@@@Z", 1);
        self.add("CreateVssExamineWriterMetadataInternal", 2);
        self.add("?CreateVssExamineWriterMetadata@@YAJPEAGPEAPEAVIVssExamineWriterMetadata@@@Z", 2);
        self.add("?CreateVssExamineWriterMetadata@@YGJPAGPAPAVIVssExamineWriterMetadata@@@Z", 2);
        self.add("CreateVssExpressWriterInternal", 1);
        self.add("CreateWaitableTimer", 3);
        self.add("CreateWaitableTimerEx", 4);
        self.add("CreateWaitableTimerExW", 4);
        self.add("CreateWaitableTimerW", 3);
        self.add("CreateWellKnownSid", 4);
        self.add("CreateWindow", 11);
        self.add("CreateWindowEx", 12);
        self.add("CreateWindowExA", 12);
        self.add("CreateWindowExW", 12);
        self.add("CreateWindowStation", 4);
        self.add("CreateWriter", 2);
        self.add("CreateWriterEx", 2);
        self.add("CreateXamlUIPresenter", 2);
        self.add("CredDelete", 3);
        self.add("CredEnumerate", 4);
        self.add("CredFindBestCredential", 4);
        self.add("CredFree", 1);
        self.add("CredGetSessionTypes", 2);
        self.add("CredGetTargetInfo", 3);
        self.add("CredIsMarshaledCredential", 1);
        self.add("CredIsProtected", 2);
        self.add("CredMarshalCredential", 3);
        self.add("CredPackAuthenticationBuffer", 5);
        self.add("CredProtect", 6);
        self.add("CredRead", 4);
        self.add("CredReadDomainCredentials", 4);
        self.add("CredRename", 4);
        self.add("CredUICmdLinePromptForCredentials", 9);
        self.add("CredUIConfirmCredentials", 2);
        self.add("CredUIParseUserName", 5);
        self.add("CredUIPromptForCredentials", 10);
        self.add("CredUIPromptForWindowsCredentials", 9);
        self.add("CredUIReadSSOCredW", 2);
        self.add("CredUIStoreSSOCredW", 4);
        self.add("CredUnmarshalCredential", 3);
        self.add("CredUnPackAuthenticationBuffer", 9);
        self.add("CredUnprotect", 5);
        self.add("CredWrite", 2);
        self.add("CredWriteDomainCredentials", 3);
        self.add("CrtCheckMemory", 0);
        self.add("CrtDbgBreak", 0);
        self.add("CrtDbgReport", 5);
        self.add("CrtDbgReportW", 5);
        self.add("CrtDoForAllClientObjects", 2);
        self.add("CrtDumpMemoryLeaks", 0);
        self.add("CrtGetAllocHook", 0);
        self.add("CrtGetDumpClient", 0);
        self.add("CrtGetReportHook", 0);
        self.add("CrtIsMemoryBlock", 5);
        self.add("CrtIsValidHeapPointer", 1);
        self.add("CrtIsValidPointer", 3);
        self.add("crtLCMapStringW", 6);
        self.add("CrtMemCheckpoint", 1);
        self.add("CrtMemDifference", 3);
        self.add("CrtMemDumpAllObjectsSince", 1);
        self.add("CrtMemDumpStatistics", 1);
        self.add("CrtReportBlockType", 1);
        self.add("CrtSetAllocHook", 1);
        self.add("CrtSetBreakAlloc", 1);
        self.add("CrtSetDbgFlag", 1);
        self.add("CrtSetDebugFillThreshold", 1);
        self.add("CrtSetDumpClient", 1);
        self.add("CrtSetReportFile", 2);
        self.add("CrtSetReportHook", 1);
        self.add("CrtSetReportHook2", 2);
        self.add("CrtSetReportHookW2", 2);
        self.add("CrtSetReportMode", 2);
        self.add("CryptAcquireContext", 5);
        self.add("CryptBinaryToString", 5);
        self.add("CryptCATAdminAcquireContext2", 5);
        self.add("CryptCATAdminAcquireContext", 3);
        self.add("CryptCATAdminAddCatalog", 4);
        self.add("CryptCATAdminCalcHashFromFileHandle2", 5);
        self.add("CryptCATAdminCalcHashFromFileHandle", 4);
        self.add("CryptCATAdminEnumCatalogFromHash", 5);
        self.add("CryptCATAdminReleaseCatalogContext", 3);
        self.add("CryptCATAdminReleaseContext", 2);
        self.add("CryptCATAdminRemoveCatalog", 3);
        self.add("CryptCATAdminResolveCatalogPath", 4);
        self.add("CryptCATCatalogInfoFromContext", 3);
        self.add("CryptCATCDFClose", 1);
        self.add("CryptCATCDFEnumAttributesWithCDFTag", 5);
        self.add("CryptCATCDFEnumCatAttributes", 3);
        self.add("CryptCATCDFEnumMembersByCDFTagEx", 6);
        self.add("CryptCATCDFOpen", 2);
        self.add("CryptCATClose", 1);
        self.add("CryptCATEnumerateAttr", 3);
        self.add("CryptCATEnumerateCatAttr", 2);
        self.add("CryptCATEnumerateMember", 2);
        self.add("CryptCATGetAttrInfo", 3);
        self.add("CryptCATGetMemberInfo", 2);
        self.add("CryptCATOpen", 5);
        self.add("CryptContextAddRef", 3);
        self.add("CryptCreateHash", 5);
        self.add("CryptCreateKeyIdentifierFromCSP", 8);
        self.add("CryptDecodeMessage", 13);
        self.add("CryptDecodeObject", 7);
        self.add("CryptDecodeObjectEx", 8);
        self.add("CryptDecrypt", 6);
        self.add("CryptDecryptAndVerifyMessageSignature", 9);
        self.add("CryptDecryptMessage", 6);
        self.add("CryptDeriveKey", 5);
        self.add("CryptDestroyHash", 1);
        self.add("CryptDestroyKey", 1);
        self.add("CryptDuplicateHash", 4);
        self.add("CryptDuplicateKey", 4);
        self.add("CryptEncodeObject", 5);
        self.add("CryptEncodeObjectEx", 7);
        self.add("CryptEncrypt", 7);
        self.add("CryptEncryptMessage", 7);
        self.add("CryptEnumKeyIdentifierProperties", 7);
        self.add("CryptEnumOIDFunction", 6);
        self.add("CryptEnumOIDInfo", 4);
        self.add("CryptEnumProviders", 6);
        self.add("CryptEnumProviderTypes", 6);
        self.add("CryptExportKey", 6);
        self.add("CryptExportPKCS8", 7);
        self.add("CryptExportPKCS8Ex", 5);
        self.add("CryptExportPublicKeyInfo", 5);
        self.add("CryptExportPublicKeyInfoEx", 8);
        self.add("CryptExportPublicKeyInfoFromBCryptKeyHandle", 7);
        self.add("CryptFindCertificateKeyProvInfo", 3);
        self.add("CryptFindLocalizedName", 1);
        self.add("CryptFindOIDInfo", 3);
        self.add("CryptFormatObject", 9);
        self.add("CryptFreeOIDFunctionAddress", 2);
        self.add("CryptGenKey", 4);
        self.add("CryptGenRandom", 3);
        self.add("CryptGetDefaultOIDDllList", 4);
        self.add("CryptGetDefaultOIDFunctionAddress", 6);
        self.add("CryptGetDefaultProvider", 5);
        self.add("CryptGetHashParam", 5);
        self.add("CryptGetKeyIdentifierProperty", 7);
        self.add("CryptGetKeyParam", 5);
        self.add("CryptGetMessageCertificates", 5);
        self.add("CryptGetMessageSignerCount", 3);
        self.add("CryptGetObjectUrl", 8);
        self.add("CryptGetOIDFunctionAddress", 6);
        self.add("CryptGetOIDFunctionValue", 7);
        self.add("CryptGetProvParam", 5);
        self.add("CryptGetUserKey", 3);
        self.add("CryptHashCertificate2", 7);
        self.add("CryptHashCertificate", 7);
        self.add("CryptHashData", 4);
        self.add("CryptHashMessage", 9);
        self.add("CryptHashPublicKeyInfo", 7);
        self.add("CryptHashSessionKey", 3);
        self.add("CryptHashToBeSigned", 6);
        self.add("CryptImportKey", 6);
        self.add("CryptImportPKCS8", 4);
        self.add("CryptImportPublicKeyInfo", 4);
        self.add("CryptImportPublicKeyInfoEx2", 5);
        self.add("CryptImportPublicKeyInfoEx", 7);
        self.add("CryptInitOIDFunctionSet", 2);
        self.add("CryptInstallDefaultContext", 6);
        self.add("CryptInstallOIDFunctionAddress", 6);
        self.add("CryptMemAlloc", 1);
        self.add("CryptMemFree", 1);
        self.add("CryptMemRealloc", 2);
        self.add("CryptMsgCalculateEncodedLength", 6);
        self.add("CryptMsgClose", 1);
        self.add("CryptMsgControl", 4);
        self.add("CryptMsgCountersign", 4);
        self.add("CryptMsgCountersignEncoded", 7);
        self.add("CryptMsgDuplicate", 1);
        self.add("CryptMsgEncodeAndSignCTL", 6);
        self.add("CryptMsgGetAndVerifySigner", 6);
        self.add("CryptMsgGetParam", 5);
        self.add("CryptMsgOpenToDecode", 6);
        self.add("CryptMsgOpenToEncode", 6);
        self.add("CryptMsgSignCTL", 7);
        self.add("CryptMsgUpdate", 4);
        self.add("CryptMsgVerifyCountersignatureEncoded", 7);
        self.add("CryptMsgVerifyCountersignatureEncodedEx", 10);
        self.add("CryptProtectData", 7);
        self.add("CryptProtectMemory", 3);
        self.add("CryptQueryObject", 11);
        self.add("CryptRegisterDefaultOIDFunction", 4);
        self.add("CryptRegisterOIDFunction", 5);
        self.add("CryptRegisterOIDInfo", 2);
        self.add("CryptReleaseContext", 2);
        self.add("CryptRetrieveObjectByUrl", 9);
        self.add("CryptSetHashParam", 4);
        self.add("CryptSetKeyIdentifierProperty", 6);
        self.add("CryptSetKeyParam", 4);
        self.add("CryptSetOIDFunctionValue", 7);
        self.add("CryptSetProvider", 2);
        self.add("CryptSetProviderEx", 4);
        self.add("CryptSetProvParam", 4);
        self.add("CryptSignAndEncodeCertificate", 9);
        self.add("CryptSignAndEncryptMessage", 8);
        self.add("CryptSignCertificate", 9);
        self.add("CryptSignHash", 6);
        self.add("CryptSignMessage", 7);
        self.add("CryptSignMessageWithKey", 5);
        self.add("CryptSIPAddProvider", 1);
        self.add("CryptSIPCreateIndirectData", 3);
        self.add("CryptSIPGetCaps", 2);
        self.add("CryptSIPGetSignedDataMsg", 5);
        self.add("CryptSIPLoad", 3);
        self.add("CryptSIPPutSignedDataMsg", 5);
        self.add("CryptSIPRemoveProvider", 1);
        self.add("CryptSIPRemoveSignedDataMsg", 2);
        self.add("CryptSIPRetrieveSubjectGuid", 3);
        self.add("CryptSIPRetrieveSubjectGuidForCatalogFile", 3);
        self.add("CryptSIPVerifyIndirectData", 2);
        self.add("CryptStringToBinary", 7);
        self.add("CryptUIDlgCertMgr", 1);
        self.add("CryptUIDlgSelectCertificate", 1);
        self.add("CryptUIDlgSelectCertificateFromStore", 7);
        self.add("CryptUIDlgViewCertificate", 2);
        self.add("CryptUIDlgViewContext", 6);
        self.add("CryptUIDlgViewSignerInfo", 1);
        self.add("CryptUIWizDigitalSign", 5);
        self.add("CryptUIWizExport", 5);
        self.add("CryptUIWizFreeDigitalSignContext", 1);
        self.add("CryptUIWizImport", 5);
        self.add("CryptUninstallDefaultContext", 3);
        self.add("CryptUnprotectData", 7);
        self.add("CryptUnprotectMemory", 3);
        self.add("CryptUnregisterDefaultOIDFunction", 3);
        self.add("CryptUnregisterOIDFunction", 3);
        self.add("CryptUnregisterOIDInfo", 1);
        self.add("CryptUpdateProtectedState", 5);
        self.add("CryptVerifyCertificateSignature", 5);
        self.add("CryptVerifyCertificateSignatureEx", 8);
        self.add("CryptVerifyDetachedMessageHash", 8);
        self.add("CryptVerifyDetachedMessageSignature", 8);
        self.add("CryptVerifyMessageHash", 7);
        self.add("CryptVerifyMessageSignature", 7);
        self.add("CryptVerifyMessageSignatureWithKey", 6);
        self.add("CryptVerifySignature", 6);
        self.add("CryptXmlAddObject", 6);
        self.add("CryptXmlClose", 1);
        self.add("CryptXmlCreateReference", 9);
        self.add("CryptXmlDigestReference", 3);
        self.add("CryptXmlEncode", 6);
        self.add("CryptXmlGetAlgorithmInfo", 3);
        self.add("CryptXmlGetDocContext", 2);
        self.add("CryptXmlGetReference", 2);
        self.add("CryptXmlGetSignature", 2);
        self.add("CryptXmlGetStatus", 2);
        self.add("CryptXmlGetTransforms", 1);
        self.add("CryptXmlImportPublicKey", 3);
        self.add("CryptXmlOpenToDecode", 6);
        self.add("CryptXmlOpenToEncode", 7);
        self.add("CryptXmlSetHMACSecret", 3);
        self.add("CryptXmlSign", 8);
        self.add("CryptXmlVerifySignature", 3);
        self.add("cscanf", 1);
        self.add("cscanf_l", 2);
        self.add("cscanf_s", 1);
        self.add("cscanf_s_l", 2);
        self.add("CscSearchApiGetInterface", 3);
        self.add("CsrAddStaticServerThread", 3);
        self.add("CsrAllocateCaptureBuffer", 2);
        self.add("CsrAllocateMessagePointer", 3);
        self.add("CsrCallServerFromServer", 2);
        self.add("CsrCaptureMessageBuffer", 4);
        self.add("CsrClientCallServer", 4);
        self.add("CsrClientConnectToServer", 5);
        self.add("CsrConnectToUser", 0);
        self.add("CsrCreateProcess", 6);
        self.add("CsrCreateRemoteThread", 2);
        self.add("CsrCreateWait", 6);
        self.add("CsrDebugProcess", 1);
        self.add("CsrDebugProcessStop", 1);
        self.add("CsrDereferenceProcess", 1);
        self.add("CsrDereferenceThread", 1);
        self.add("CsrDereferenceWait", 1);
        self.add("CsrDestroyProcess", 2);
        self.add("CsrDestroyThread", 1);
        self.add("CsrExecServerThread", 2);
        self.add("CsrFreeCaptureBuffer", 1);
        self.add("CsrGetProcessId", 0);
        self.add("CsrGetProcessLuid", 2);
        self.add("CsrIdentifyAlertableThread", 0);
        self.add("CsrImpersonateClient", 1);
        self.add("CsrLockedReferenceProcess", 1);
        self.add("CsrLockProcessByClientId", 2);
        self.add("CsrLockThreadByClientId", 2);
        self.add("CsrMoveSatisfiedWait", 2);
        self.add("CsrNewThread", 0);
        self.add("CsrNotifyWait", 4);
        self.add("CsrPopulateDosDevices", 0);
        self.add("CsrProbeForRead", 3);
        self.add("CsrProbeForWrite", 3);
        self.add("CsrQueryApiPort", 0);
        self.add("CsrReferenceThread", 1);
        self.add("CsrRevertToSelf", 0);
        self.add("CsrServerInitialization", 2);
        self.add("CsrSetBackgroundPriority", 1);
        self.add("CsrSetCallingSpooler", 1);
        self.add("CsrSetForegroundPriority", 1);
        self.add("CsrSetPriorityClass", 2);
        self.add("CsrShutdownProcesses", 2);
        self.add("CsrUnhandledExceptionFilter", 1);
        self.add("CsrUnlockProcess", 1);
        self.add("CsrUnlockThread", 1);
        self.add("CsrValidateMessageBuffer", 4);
        self.add("CsrValidateMessageString", 2);
        self.add("CStdStubBuffer_AddRef", 1);
        self.add("CStdStubBuffer_Connect", 2);
        self.add("CStdStubBuffer_CountRefs", 1);
        self.add("CStdStubBuffer_DebugServerQueryInterface", 2);
        self.add("CStdStubBuffer_DebugServerRelease", 2);
        self.add("CStdStubBuffer_Disconnect", 1);
        self.add("CStdStubBuffer_Invoke", 3);
        self.add("CStdStubBuffer_IsIIDSupported", 2);
        self.add("CStdStubBuffer_QueryInterface", 3);
        self.add("ctime", 1);
        self.add("ctime32", 1);
        self.add("ctime32_s", 3);
        self.add("ctime64", 1);
        self.add("ctime64_s", 3);
        self.add("cwait", 3);
        self.add("cwprintf", 1);
        self.add("cwprintf_l", 2);
        self.add("cwprintf_p", 1);
        self.add("cwprintf_p_l", 2);
        self.add("cwprintf_s", 1);
        self.add("cwprintf_s_l", 2);
        self.add("cwscanf", 1);
        self.add("cwscanf_l", 2);
        self.add("cwscanf_s", 1);
        self.add("cwscanf_s_l", 2);
        self.add("CxxFrameHandler", 4);
        self.add("D3coldRequestAuxPower", 3);
        self.add("D3coldRequestCorePowerRail", 2);
        self.add("D3coldRequestPerstDelay", 2);
        self.add("DAD_AutoScroll", 3);
        self.add("DAD_DragEnterEx", 2);
        self.add("DAD_DragLeave", 0);
        self.add("DAD_DragMove", 1);
        self.add("DAD_SetDragImage", 2);
        self.add("DAD_ShowDragImage", 1);
        self.add("DavAddConnection", 6);
        self.add("DavCancelConnectionsToServer", 2);
        self.add("DavDeleteConnection", 1);
        self.add("DavFlushFile", 1);
        self.add("DavGetExtendedError", 4);
        self.add("DavGetHTTPFromUNCPath", 3);
        self.add("DavGetTheLockOwnerOfTheFile", 3);
        self.add("DavGetUNCFromHTTPPath", 3);
        self.add("DavInvalidateCache", 1);
        self.add("DavRegisterAuthCallback", 2);
        self.add("DavUnregisterAuthCallback", 1);
        self.add("DbgBreakPoint", 0);
        self.add("DbgBreakPointWithStatus", 1);
        self.add("DbgLoadImageSymbols", 3);
        self.add("DbgPrint", 1);
        self.add("DbgPrintEx", 3);
        self.add("DbgPrompt", 3);
        self.add("DbgQueryDebugFilterState", 2);
        self.add("DbgSetDebugFilterState", 3);
        self.add("DbgUiConnectToDbg", 0);
        self.add("DbgUiContinue", 2);
        self.add("DbgUiConvertStateChangeStructure", 2);
        self.add("DbgUiDebugActiveProcess", 1);
        self.add("DbgUiGetThreadDebugObject", 0);
        self.add("DbgUiIssueRemoteBreakin", 1);
        self.add("DbgUiRemoteBreakin", 0);
        self.add("DbgUiStopDebugging", 1);
        self.add("DbgUiWaitStateChange", 2);
        self.add("DbgUnLoadImageSymbols", 3);
        self.add("DbgUserBreakPoint", 0);
        self.add("DceErrorInqText", 2);
        self.add("DdeAbandonTransaction", 3);
        self.add("DdeAccessData", 2);
        self.add("DdeAddData", 4);
        self.add("DdeClientTransaction", 8);
        self.add("DdeCmpStringHandles", 2);
        self.add("DdeConnect", 4);
        self.add("DdeConnectList", 5);
        self.add("DdeCreateDataHandle", 7);
        self.add("DdeCreateStringHandle", 3);
        self.add("DdeDisconnect", 1);
        self.add("DdeDisconnectList", 1);
        self.add("DdeEnableCallback", 3);
        self.add("DdeFreeDataHandle", 1);
        self.add("DdeFreeStringHandle", 2);
        self.add("DdeGetData", 4);
        self.add("DdeGetLastError", 1);
        self.add("DdeImpersonateClient", 1);
        self.add("DdeInitialize", 4);
        self.add("DdeKeepStringHandle", 2);
        self.add("DdeNameService", 4);
        self.add("DdePostAdvise", 3);
        self.add("DdeQueryConvInfo", 3);
        self.add("DdeQueryNextServer", 2);
        self.add("DdeQueryString", 5);
        self.add("DdeReconnect", 1);
        self.add("DdeSetQualityOfService", 3);
        self.add("DdeSetUserHandle", 3);
        self.add("DdeUnaccessData", 1);
        self.add("DdeUninitialize", 1);
        self.add("DeactivateActCtx", 2);
        self.add("DebugActiveProcess", 1);
        self.add("DebugActiveProcessStop", 1);
        self.add("DebugBreak", 0);
        self.add("DebugBreakProcess", 1);
        self.add("DebugSetProcessKillOnExit", 1);
        self.add("DecodePointer", 1);
        self.add("DecodeSystemPointer", 1);
        self.add("Decompress", 6);
        self.add("DecryptFile", 2);
        self.add("DecryptMessage", 4);
        self.add("DefDlgProc", 4);
        self.add("DefDlgProcA", 4);
        self.add("DefDlgProcW", 4);
        self.add("DefDriverProc", 5);
        self.add("DeferWindowPos", 8);
        self.add("DefFrameProc", 5);
        self.add("DefFrameProcA", 5);
        self.add("DefFrameProcW", 5);
        self.add("DefineDosDevice", 3);
        self.add("DefineDosDeviceW", 3);
        self.add("DefMDIChildProc", 4);
        self.add("DefMDIChildProcA", 4);
        self.add("DefMDIChildProcW", 4);
        self.add("DefRawInputProc", 3);
        self.add("DefSubclassProc", 4);
        self.add("DefWindowProc", 4);
        self.add("DefWindowProcA", 4);
        self.add("DefWindowProcW", 4);
        self.add("DegaussMonitor", 1);
        self.add("DeinitMapiUtil", 0);
        self.add("DelayLoadFailureHook", 2);
        self.add("DeleteAce", 2);
        self.add("DeleteAllGPOLinks", 1);
        self.add("DeleteAnycastIpAddressEntry", 1);
        self.add("DeleteAppContainerProfile", 1);
        self.add("DeleteAtom", 1);
        self.add("DeleteBoundaryDescriptor", 1);
        self.add("DeleteColorSpace", 1);
        self.add("DeleteColorTransform", 1);
        self.add("DeleteCriticalSection", 1);
        self.add("DeleteDC", 1);
        self.add("DeleteEnhMetaFile", 1);
        self.add("DeleteExtractedFiles", 1);
        self.add("DeleteFiber", 1);
        self.add("DeleteFile", 1);
        self.add("DeleteFileA", 1);
        self.add("DeleteFileTransacted", 2);
        self.add("DeleteFileW", 1);
        self.add("DeleteForm", 2);
        self.add("DeleteGPOLink", 2);
        self.add("DeleteIE3Cache", 4);
        self.add("DeleteIPAddress", 1);
        self.add("DeleteIpForwardEntry", 1);
        self.add("DeleteIpForwardEntry2", 1);
        self.add("DeleteIpNetEntry", 1);
        self.add("DeleteIpNetEntry2", 1);
        self.add("DeleteLogByHandle", 1);
        self.add("DeleteLogFile", 2);
        self.add("DeleteLogMarshallingArea", 1);
        self.add("DeleteMenu", 3);
        self.add("DeleteMetaFile", 1);
        self.add("DeleteMonitor", 3);
        self.add("DeleteObject", 1);
        self.add("DeletePersistentTcpPortReservation", 2);
        self.add("DeletePersistentUdpPortReservation", 2);
        self.add("DeletePort", 3);
        self.add("DeletePrinter", 1);
        self.add("DeletePrinterConnection", 1);
        self.add("DeletePrinterData", 2);
        self.add("DeletePrinterDataEx", 3);
        self.add("DeletePrinterDriver", 3);
        self.add("DeletePrinterDriverEx", 5);
        self.add("DeletePrinterDriverPackage", 3);
        self.add("DeletePrinterKey", 2);
        self.add("DeletePrintProcessor", 3);
        self.add("DeletePrintProvidor", 3);
        self.add("DeleteProcThreadAttributeList", 1);
        self.add("DeleteProfile", 3);
        self.add("DeleteProxyArpEntry", 3);
        self.add("DeletePwrScheme", 1);
        self.add("DeleteSecurityContext", 1);
        self.add("DeleteSecurityPackage", 1);
        self.add("DeleteService", 1);
        self.add("DeleteSynchronizationBarrier", 1);
        self.add("DeleteTimerQueue", 1);
        self.add("DeleteTimerQueueEx", 2);
        self.add("DeleteTimerQueueTimer", 3);
        self.add("DeleteUmsCompletionList", 1);
        self.add("DeleteUmsThreadContext", 1);
        self.add("DeleteUnicastIpAddressEntry", 1);
        self.add("DeleteUrlCacheContainer", 2);
        self.add("DeleteUrlCacheEntry", 1);
        self.add("DeleteUrlCacheEntryA", 1);
        self.add("DeleteUrlCacheEntryW", 1);
        self.add("DeleteUrlCacheGroup", 3);
        self.add("DeleteVirtualDiskMetadata", 2);
        self.add("DeleteVolumeMountPoint", 1);
        self.add("DeleteVolumeMountPointW", 1);
        self.add("DeleteWpadCacheForNetworks", 1);
        self.add("DequeueUmsCompletionListItems", 3);
        self.add("DeregisterEventSource", 1);
        self.add("DeregisterIdleRoutine", 1);
        self.add("DeregisterManageableLogClient", 1);
        self.add("DeregisterShellHookWindow", 1);
        self.add("DeriveAppContainerSidFromAppContainerName", 2);
        self.add("DescribePixelFormat", 4);
        self.add("DesktopHasWatermarkText", 0);
        self.add("DestroyAcceleratorTable", 1);
        self.add("DestroyCaret", 0);
        self.add("DestroyCursor", 1);
        self.add("DestroyEnvironmentBlock", 1);
        self.add("DestroyIcon", 1);
        self.add("DestroyInteractionContext", 1);
        self.add("DestroyMenu", 1);
        self.add("DestroyPhysicalMonitor", 1);
        self.add("DestroyPhysicalMonitors", 2);
        self.add("DestroyPrivateObjectSecurity", 1);
        self.add("DestroyPropertySheetPage", 1);
        self.add("DestroyWindow", 1);
        self.add("DetachVirtualDisk", 3);
        self.add("DetectAutoProxyUrl", 3);
        self.add("DeviceCapabilities", 5);
        self.add("DeviceIoControl", 8);
        self.add("DevicePowerClose", 0);
        self.add("DevicePowerEnumDevices", 5);
        self.add("DevicePowerOpen", 1);
        self.add("DevicePowerSetDeviceState", 3);
            self.add("DeviceQueryBusSpecificResetHandler", 3);
        self.add("DeviceResetHandler", 4);
        self.add("DhcpAddFilterV4", 3);
        self.add("DhcpAddServer", 5);
        self.add("DhcpAddSubnetElement", 3);
        self.add("DhcpAddSubnetElementV4", 3);
        self.add("DhcpAddSubnetElementV5", 3);
        self.add("DhcpAddSubnetElementV6", 3);
        self.add("DhcpAuditLogGetParams", 6);
        self.add("DhcpAuditLogSetParams", 6);
        self.add("DhcpCApiCleanup", 0);
        self.add("DhcpCApiInitialize", 1);
        self.add("DhcpCreateClass", 3);
        self.add("DhcpCreateClassV6", 3);
        self.add("DhcpCreateClientInfo", 2);
        self.add("DhcpCreateClientInfoV4", 2);
        self.add("DhcpCreateClientInfoVQ", 2);
        self.add("DhcpCreateOption", 3);
        self.add("DhcpCreateOptionV5", 6);
        self.add("DhcpCreateOptionV6", 6);
        self.add("DhcpCreateSubnet", 3);
        self.add("DhcpCreateSubnetV6", 3);
        self.add("DhcpCreateSubnetVQ", 3);
        self.add("DhcpDeleteClass", 3);
        self.add("DhcpDeleteClassV6", 3);
        self.add("DhcpDeleteClientInfo", 2);
        self.add("DhcpDeleteClientInfoV6", 2);
        self.add("DhcpDeleteFilterV4", 2);
        self.add("DhcpDeleteServer", 5);
        self.add("DhcpDeleteSubnet", 3);
        self.add("DhcpDeleteSubnetV6", 3);
        self.add("DhcpDeleteSuperScopeV4", 2);
        self.add("DhcpDeRegisterParamChange", 3);
        self.add("DhcpDsCleanup", 0);
        self.add("DhcpDsInit", 0);
        self.add("DhcpEnumClasses", 7);
        self.add("DhcpEnumClassesV6", 7);
        self.add("DhcpEnumFilterV4", 7);
        self.add("DhcpEnumOptions", 6);
        self.add("DhcpEnumOptionsV5", 9);
        self.add("DhcpEnumOptionsV6", 9);
        self.add("DhcpEnumOptionValues", 7);
        self.add("DhcpEnumOptionValuesV5", 10);
        self.add("DhcpEnumOptionValuesV6", 10);
        self.add("DhcpEnumServers", 5);
        self.add("DhcpEnumSubnetClients", 7);
        self.add("DhcpEnumSubnetClientsFilterStatusInfo", 7);
        self.add("DhcpEnumSubnetClientsV4", 7);
        self.add("DhcpEnumSubnetClientsV5", 7);
        self.add("DhcpEnumSubnetClientsV6", 7);
        self.add("DhcpEnumSubnetClientsVQ", 7);
        self.add("DhcpEnumSubnetElements", 8);
        self.add("DhcpEnumSubnetElementsV4", 8);
        self.add("DhcpEnumSubnetElementsV5", 8);
        self.add("DhcpEnumSubnetElementsV6", 8);
        self.add("DhcpEnumSubnets", 6);
        self.add("DhcpEnumSubnetsV6", 6);
        self.add("DhcpGetAllOptions", 3);
        self.add("DhcpGetAllOptionsV6", 3);
        self.add("DhcpGetAllOptionValues", 4);
        self.add("DhcpGetAllOptionValuesV6", 4);
        self.add("DhcpGetClassInfo", 4);
        self.add("DhcpGetClientInfo", 3);
        self.add("DhcpGetClientInfoV4", 3);
        self.add("DhcpGetClientInfoV6", 3);
        self.add("DhcpGetClientInfoVQ", 3);
        self.add("DhcpGetClientOptions", 4);
        self.add("DhcpGetFilterV4", 2);
        self.add("DhcpGetMibInfoV5", 2);
        self.add("DhcpGetMibInfoV6", 2);
        self.add("DhcpGetOptionInfo", 3);
        self.add("DhcpGetOptionInfoV5", 6);
        self.add("DhcpGetOptionInfoV6", 6);
        self.add("DhcpGetOptionValue", 4);
        self.add("DhcpGetOptionValueV5", 7);
        self.add("DhcpGetOptionValueV6", 7);
        self.add("DhcpGetServerBindingInfo", 3);
        self.add("DhcpGetServerBindingInfoV6", 3);
        self.add("DhcpGetServerSpecificStrings", 2);
        self.add("DhcpGetSubnetDelayOffer", 3);
        self.add("DhcpGetSubnetInfo", 3);
        self.add("DhcpGetSubnetInfoV6", 3);
        self.add("DhcpGetSubnetInfoVQ", 3);
        self.add("DhcpGetSuperScopeInfoV4", 2);
        self.add("DhcpGetThreadOptions", 2);
        self.add("DhcpGetVersion", 3);
        self.add("DhcpHlprAddV4PolicyCondition", 10);
        self.add("DhcpHlprAddV4PolicyExpr", 4);
        self.add("DhcpHlprAddV4PolicyRange", 2);
        self.add("DhcpHlprCreateV4Policy", 8);
        self.add("DhcpHlprFreeV4Policy", 1);
        self.add("DhcpHlprIsV4PolicySingleUC", 1);
        self.add("DhcpHlprIsV4PolicyValid", 1);
        self.add("DhcpHlprIsV4PolicyWellFormed", 1);
        self.add("DhcpHlprModifyV4PolicyExpr", 2);
        self.add("DhcpHlprResetV4PolicyExpr", 1);
        self.add("DhcpModifyClass", 3);
        self.add("DhcpModifyClassV6", 3);
        self.add("DhcpRegisterParamChange", 6);
        self.add("DhcpRemoveDNSRegistrations", 0);
        self.add("DhcpRemoveOption", 2);
        self.add("DhcpRemoveOptionV5", 5);
        self.add("DhcpRemoveOptionV6", 5);
        self.add("DhcpRemoveOptionValue", 3);
        self.add("DhcpRemoveOptionValueV5", 6);
        self.add("DhcpRemoveOptionValueV6", 6);
        self.add("DhcpRemoveSubnetElement", 4);
        self.add("DhcpRemoveSubnetElementV4", 4);
        self.add("DhcpRemoveSubnetElementV5", 4);
        self.add("DhcpRemoveSubnetElementV6", 4);
        self.add("DhcpRequestParams", 9);
        self.add("DhcpRpcFreeMemory", 1);
        self.add("DhcpScanDatabase", 4);
        self.add("DhcpServerBackupDatabase", 2);
        self.add("DhcpServerGetConfig", 2);
        self.add("DhcpServerGetConfigV4", 2);
        self.add("DhcpServerGetConfigV6", 3);
        self.add("DhcpServerGetConfigVQ", 2);
        self.add("DhcpServerQueryAttribute", 4);
        self.add("DhcpServerQueryAttributes", 5);
        self.add("DhcpServerQueryDnsRegCredentials", 5);
        self.add("DhcpServerRedoAuthorization", 2);
        self.add("DhcpServerRestoreDatabase", 2);
        self.add("DhcpServerSetConfig", 3);
        self.add("DhcpServerSetConfigV4", 3);
        self.add("DhcpServerSetConfigV6", 4);
        self.add("DhcpServerSetConfigVQ", 3);
        self.add("DhcpServerSetDnsRegCredentialsV5", 4);
        self.add("DhcpSetClientInfo", 2);
        self.add("DhcpSetClientInfoV4", 2);
        self.add("DhcpSetClientInfoV6", 2);
        self.add("DhcpSetClientInfoVQ", 2);
        self.add("DhcpSetFilterV4", 2);
        self.add("DhcpSetOptionInfo", 3);
        self.add("DhcpSetOptionInfoV5", 6);
        self.add("DhcpSetOptionInfoV6", 6);
        self.add("DhcpSetOptionValue", 4);
        self.add("DhcpSetOptionValues", 3);
        self.add("DhcpSetOptionValuesV5", 6);
        self.add("DhcpSetOptionValueV5", 7);
        self.add("DhcpSetOptionValueV6", 7);
        self.add("DhcpSetServerBindingInfo", 3);
        self.add("DhcpSetServerBindingInfoV6", 3);
        self.add("DhcpSetSubnetDelayOffer", 3);
        self.add("DhcpSetSubnetInfo", 3);
        self.add("DhcpSetSubnetInfoV6", 3);
        self.add("DhcpSetSubnetInfoVQ", 3);
        self.add("DhcpSetSuperScopeV4", 4);
        self.add("DhcpSetThreadOptions", 2);
        self.add("DhcpUndoRequestParams", 4);
        self.add("DhcpV4AddPolicyRange", 4);
        self.add("DhcpV4CreateClientInfo", 2);
        self.add("DhcpV4CreatePolicy", 2);
        self.add("DhcpV4DeletePolicy", 4);
        self.add("DhcpV4EnumPolicies", 8);
        self.add("DhcpV4EnumSubnetClients", 7);
        self.add("DhcpV4EnumSubnetReservations", 7);
        self.add("DhcpV4FailoverAddScopeToRelationship", 2);
        self.add("DhcpV4FailoverCreateRelationship", 2);
        self.add("DhcpV4FailoverDeleteRelationship", 2);
        self.add("DhcpV4FailoverDeleteScopeFromRelationship", 2);
        self.add("DhcpV4FailoverEnumRelationship", 6);
        self.add("DhcpV4FailoverGetAddressStatus", 3);
        self.add("DhcpV4FailoverGetClientInfo", 3);
        self.add("DhcpV4FailoverGetRelationship", 3);
        self.add("DhcpV4FailoverGetScopeRelationship", 3);
        self.add("DhcpV4FailoverGetScopeStatistics", 3);
        self.add("DhcpV4FailoverGetSystemTime", 2);
        self.add("DhcpV4FailoverSetRelationship", 3);
        self.add("DhcpV4FailoverTriggerAddrAllocation", 2);
        self.add("DhcpV4GetAllOptionValues", 4);
        self.add("DhcpV4GetClientInfo", 3);
        self.add("DhcpV4GetFreeIPAddress", 6);
        self.add("DhcpV4GetOptionValue", 7);
        self.add("DhcpV4GetPolicy", 5);
        self.add("DhcpV4QueryPolicyEnforcement", 4);
        self.add("DhcpV4RemoveOptionValue", 6);
        self.add("DhcpV4RemovePolicyRange", 4);
        self.add("DhcpV4SetOptionValue", 7);
        self.add("DhcpV4SetOptionValues", 6);
        self.add("DhcpV4SetPolicy", 6);
        self.add("DhcpV4SetPolicyEnforcement", 4);
        self.add("Dhcpv6CApiCleanup", 0);
        self.add("Dhcpv6CApiInitialize", 1);
        self.add("DhcpV6CreateClientInfo", 2);
        self.add("DhcpV6GetFreeIPAddress", 6);
        self.add("DhcpV6GetStatelessStatistics", 2);
        self.add("DhcpV6GetStatelessStoreParams", 4);
        self.add("Dhcpv6ReleasePrefix", 3);
        self.add("Dhcpv6RenewPrefix", 5);
        self.add("Dhcpv6RequestParams", 7);
        self.add("Dhcpv6RequestPrefix", 4);
        self.add("DhcpV6SetStatelessStoreParams", 5);
        self.add("DialogBoxIndirectParam", 5);
        self.add("DialogBoxIndirectParamA", 5);
        self.add("DialogBoxIndirectParamW", 5);
        self.add("DialogBoxParam", 5);
        self.add("DialogBoxParamA", 5);
        self.add("DialogBoxParamW", 5);
        self.add("difftime", 2);
        self.add("difftime32", 2);
        self.add("difftime64", 2);
        self.add("DiInstallDevice", 6);
        self.add("DiInstallDriver", 4);
        self.add("DiRollbackDriver", 5);
        self.add("DisableMediaSense", 2);
        self.add("DisableThreadLibraryCalls", 1);
        self.add("DisableThreadProfiling", 1);
        self.add("DisassociateColorProfileFromDevice", 3);
        self.add("DisassociateCurrentThreadFromCallback", 1);
        self.add("DisconnectNamedPipe", 1);
        self.add("DisconnectWindowDialog", 1);
        self.add("DiShowUpdateDevice", 5);
        self.add("DispatchMessage", 1);
        self.add("DispatchMessageA", 1);
        self.add("DispatchMessageW", 1);
        self.add("DispCallFunc", 8);
        self.add("DispGetIDsOfNames", 4);
        self.add("DispGetParam", 5);
        self.add("DispInvoke", 8);
        self.add("DiUninstallDevice", 5);
        self.add("div", 2);
        self.add("DlgDirList", 5);
        self.add("DlgDirListComboBox", 5);
        self.add("DlgDirSelectComboBoxEx", 4);
        self.add("DlgDirSelectEx", 4);
        self.add("Dlgproc", 4);
        self.add("DllCanUnloadNow", 0);
        self.add("DllDebugObjectRPCHook", 2);
        self.add("DllGetActivationFactory", 2);
        self.add("DllGetClassObject", 3);
        self.add("DllGetVersion", 1);
        self.add("Dllgetversionproc", 1);
        self.add("DllInstall", 2);
        self.add("DllMain", 3);
        self.add("dllonexit", 3);
        self.add("DllRegisterServer", 0);
        self.add("DllUnregisterServer", 0);
        self.add("DmaCompletionRoutine", 4);
        self.add("DnsAcquireContextHandle_", 3);
        self.add("DnsCancelQuery", 1);
        self.add("DnsExtractRecordsFromMessage_W", 3);
        self.add("DnsFree", 2);
        self.add("DnsFreeProxyName", 1);
        self.add("DnsGetProxyInformation", 5);
        self.add("DnsHostnameToComputerName", 3);
        self.add("DnsModifyRecordsInSet_", 6);
        self.add("DnsNameCompare_", 2);
        self.add("DnsQuery_", 6);
        self.add("DnsQueryConfig", 6);
        self.add("DnsQueryEx", 3);
        self.add("DnsRecordCompare", 2);
        self.add("DnsRecordCopyEx", 3);
        self.add("DnsRecordListFree", 2);
        self.add("DnsRecordSetCompare", 4);
        self.add("DnsRecordSetCopyEx", 3);
        self.add("DnsRecordSetDetach", 1);
        self.add("DnsReleaseContextHandle", 1);
        self.add("DnsReplaceRecordSet", 5);
        self.add("DnsValidateName_", 2);
        self.add("DnsWriteQuestionToBuffer_W", 6);
        self.add("DoConnectoidsExist", 0);
        self.add("DocumentProperties", 6);
        self.add("DoDragDrop", 4);
        self.add("DoEnvironmentSubst", 2);
        self.add("DoEnvironmentSubstA", 2);
        self.add("DoEnvironmentSubstW", 2);
        self.add("DoPrivacyDlg", 4);
        self.add("DoReaderMode", 1);
        self.add("DosDateTimeToFileTime", 3);
        self.add("DosDateTimeToVariantTime", 3);
        self.add("DownlevelGetLocaleScripts", 3);
        self.add("DownlevelGetParentLocaleLCID", 1);
        self.add("DownlevelGetParentLocaleName", 3);
        self.add("DownlevelGetStringScripts", 5);
        self.add("DownlevelLCIDToLocaleName", 4);
        self.add("DownlevelLocaleNameToLCID", 2);
        self.add("DownlevelVerifyScripts", 5);
        self.add("DPA_Clone", 2);
        self.add("DPA_Create", 1);
        self.add("DPA_CreateEx", 2);
        self.add("DPA_DeleteAllPtrs", 1);
        self.add("DPA_DeletePtr", 2);
        self.add("DPA_Destroy", 1);
        self.add("DPA_DestroyCallback", 3);
        self.add("DPA_EnumCallback", 3);
        self.add("DPA_GetPtr", 2);
        self.add("DPA_GetPtrIndex", 2);
        self.add("DPA_GetSize", 1);
        self.add("DPA_Grow", 2);
        self.add("DPA_InsertPtr", 3);
        self.add("DPA_LoadStream", 4);
        self.add("DPA_Merge", 6);
        self.add("DPA_SaveStream", 4);
        self.add("DPA_Search", 6);
        self.add("DPA_SetPtr", 3);
        self.add("DPA_Sort", 3);
        self.add("DPtoLP", 3);
        self.add("DragAcceptFiles", 2);
        self.add("DragDetect", 2);
        self.add("DragFinish", 1);
        self.add("DragQueryFile", 4);
        self.add("DragQueryFileA", 4);
        self.add("DragQueryFileW", 4);
        self.add("DragQueryPoint", 2);
        self.add("DrawAnimatedRects", 4);
        self.add("DrawCaption", 4);
        self.add("DrawDibBegin", 8);
        self.add("DrawDibChangePalette", 4);
        self.add("DrawDibClose", 1);
        self.add("DrawDibDraw", 13);
        self.add("DrawDibEnd", 1);
        self.add("DrawDibGetBuffer", 4);
        self.add("DrawDibGetPalette", 1);
        self.add("DrawDibOpen", 0);
        self.add("DrawDibProfileDisplay", 1);
        self.add("DrawDibRealize", 3);
        self.add("DrawDibSetPalette", 2);
        self.add("DrawDibStart", 2);
        self.add("DrawDibStop", 1);
        self.add("DrawDibTime", 2);
        self.add("DrawEdge", 4);
        self.add("DrawEscape", 4);
        self.add("DrawFocusRect", 2);
        self.add("DrawFrameControl", 4);
        self.add("DrawIcon", 4);
        self.add("DrawIconEx", 9);
        self.add("DrawInsert", 3);
        self.add("DrawMenuBar", 1);
        self.add("DrawShadowText", 9);
        self.add("DrawState", 10);
        self.add("DrawStateA", 10);
        self.add("Drawstateproc", 5);
        self.add("DrawStateW", 10);
        self.add("DrawStatusText", 4);
        self.add("DrawText", 5);
        self.add("DrawTextA", 5);
        self.add("DrawTextEx", 6);
        self.add("DrawTextExA", 6);
        self.add("DrawTextExPrivWrap", 6);
        self.add("DrawTextExW", 6);
        self.add("DrawTextW", 5);
        self.add("DrawTextWrap", 6);
        self.add("DrawThemeBackground", 6);
        self.add("DrawThemeBackgroundEx", 6);
        self.add("DrawThemeEdge", 8);
        self.add("DrawThemeIcon", 7);
        self.add("DrawThemeParentBackground", 3);
        self.add("DrawThemeParentBackgroundEx", 4);
        self.add("DrawThemeText", 9);
        self.add("DrawThemeTextEx", 9);
        self.add("DriverAddDevice", 2);
        self.add("DriverCallback", 7);
        self.add("DriverCancel", 2);
        self.add("DriverControl", 4);
        self.add("DriverDispatch", 2);
        self.add("DriverFsNotification", 2);
        self.add("DriverInitialize", 2);
        self.add("DriverListControl", 4);
        self.add("DriverStartio", 2);
        self.add("DriverUnload", 1);
        self.add("DriveType", 1);
        self.add("DrvGetModuleHandle", 1);
        self.add("DSA_Clone", 1);
        self.add("DSA_Create", 2);
        self.add("DsAddressToSiteNames", 4);
        self.add("DsAddressToSiteNamesEx", 5);
        self.add("DsAddSidHistory", 8);
        self.add("DSA_DeleteAllItems", 1);
        self.add("DSA_DeleteItem", 2);
        self.add("DSA_Destroy", 1);
        self.add("DSA_DestroyCallback", 3);
        self.add("DSA_EnumCallback", 3);
        self.add("DSA_GetItem", 3);
        self.add("DSA_GetItemPtr", 2);
        self.add("DSA_GetSize", 1);
        self.add("DSA_InsertItem", 3);
        self.add("DSA_SetItem", 3);
        self.add("DSA_Sort", 3);
        self.add("DsBackupClose", 1);
        self.add("DsBackupEnd", 1);
        self.add("DsBackupFree", 1);
        self.add("DsBackupGetBackupLogs", 3);
        self.add("DsBackupGetDatabaseNames", 3);
        self.add("DsBackupOpenFile", 4);
        self.add("DsBackupPrepare", 6);
        self.add("DsBackupRead", 4);
        self.add("DsBackupTruncateLogs", 1);
        self.add("DsBind", 3);
        self.add("DsBindingSetTimeout", 2);
        self.add("DsBindToISTG", 2);
        self.add("DsBindWithCred", 4);
        self.add("DsBindWithSpn", 5);
        self.add("DsBindWithSpnEx", 6);
        self.add("DsBrowseForContainer", 1);
        self.add("DsClientMakeSpnForTargetServer", 4);
        self.add("DsCrackNames", 7);
        self.add("DsCrackSpn", 8);
        self.add("DsCrackUnquotedMangledRdn", 4);
        self.add("DSCreateISecurityInfoObject", 6);
        self.add("DSCreateISecurityInfoObjectEx", 10);
        self.add("DSCreateSecurityPage", 7);
        self.add("DsDeregisterDnsHostRecords", 5);
        self.add("DSEditSecurity", 8);
        self.add("DsEnumerateDomainTrusts", 4);
        self.add("DsFreeDomainControllerInfo", 3);
        self.add("DsFreeNameResult", 1);
        self.add("DsFreePasswordCredentials", 1);
        self.add("DsFreeSchemaGuidMap", 1);
        self.add("DsFreeSpnArray", 2);
        self.add("DsGetDcCloseW", 1);
        self.add("DsGetDcName", 6);
        self.add("DsGetDcNext", 4);
        self.add("DsGetDcOpen", 7);
        self.add("DsGetDcSiteCoverage", 3);
        self.add("DsGetDomainControllerInfo", 5);
        self.add("DsGetForestTrustInformationW", 4);
        self.add("DsGetFriendlyClassName", 3);
        self.add("DsGetIcon", 4);
        self.add("DsGetRdnW", 6);
        self.add("DsGetSiteName", 2);
        self.add("DsGetSpn", 9);
        self.add("DsInheritSecurityIdentity", 4);
        self.add("DsIsMangledDn", 2);
        self.add("DsIsMangledRdnValue", 3);
        self.add("DsIsNTDSOnline", 2);
        self.add("DsListDomainsInSite", 3);
        self.add("DsListInfoForServer", 3);
        self.add("DsListRoles", 2);
        self.add("DsListServersForDomainInSite", 4);
        self.add("DsListServersInSite", 3);
        self.add("DsListSites", 2);
        self.add("DsMakePasswordCredentials", 4);
        self.add("DsMakeSpn", 7);
        self.add("DsMapSchemaGuids", 4);
        self.add("DsMergeForestTrustInformationW", 4);
        self.add("DsQuerySitesByCost", 6);
        self.add("DsQuerySitesFree", 1);
        self.add("DsQuoteRdnValue", 4);
        self.add("DsRemoveDsDomain", 2);
        self.add("DsRemoveDsServer", 5);
        self.add("DsReplicaAdd", 7);
        self.add("DsReplicaConsistencyCheck", 3);
        self.add("DsReplicaDel", 4);
        self.add("DsReplicaFreeInfo", 2);
        self.add("DsReplicaGetInfo2W", 9);
        self.add("DsReplicaGetInfoW", 5);
        self.add("DsReplicaModify", 9);
        self.add("DsReplicaSync", 4);
        self.add("DsReplicaSyncAll", 5);
        self.add("DsReplicaUpdateRefs", 5);
        self.add("DsReplicaVerifyObjects", 4);
        self.add("DsRestoreEnd", 1);
        self.add("DsRestoreGetDatabaseLocations", 3);
        self.add("DsRestorePrepare", 5);
        self.add("DsRestoreRegister", 7);
        self.add("DsRestoreRegisterComplete", 2);
        self.add("DsRoleFreeMemory", 1);
        self.add("DsRoleGetPrimaryDomainInformation", 3);
        self.add("DsServerRegisterSpn", 3);
        self.add("DsSetAuthIdentity", 3);
        self.add("DsSetCurrentBackupLog", 2);
        self.add("DsUnBind", 1);
        self.add("DsUnquoteRdnValue", 4);
        self.add("DsValidateSubnetName", 1);
        self.add("DsWriteAccountSpn", 5);
        self.add("DumpLogRecords", 11);
        self.add("dup", 1);
        self.add("dup2", 2);
        self.add("dupenv_s", 3);
        self.add("dupenv_s_dbg", 6);
        self.add("DuplicateEncryptionInfoFile", 5);
        self.add("DuplicateHandle", 7);
        self.add("DuplicateIcon", 2);
        self.add("DuplicateToken", 3);
        self.add("DuplicateTokenEx", 6);
        self.add("DupWideToAnsi", 2);
        self.add("DvdLauncher", 2);
        self.add("DwmAttachMilContent", 1);
        self.add("DwmDefWindowProc", 5);
        self.add("DwmDetachMilContent", 1);
        self.add("DwmEnableBlurBehindWindow", 2);
        self.add("DwmEnableComposition", 1);
        self.add("DwmEnableMMCSS", 1);
        self.add("DwmExtendFrameIntoClientArea", 2);
        self.add("DwmFlush", 0);
        self.add("DwmGetColorizationColor", 2);
        self.add("DwmGetCompositionTimingInfo", 2);
        self.add("DwmGetGraphicsStreamClient", 2);
        self.add("DwmGetGraphicsStreamTransformHint", 2);
        self.add("DwmGetTransportAttributes", 3);
        self.add("DwmGetWindowAttribute", 4);
        self.add("DwmInvalidateIconicBitmaps", 1);
        self.add("DwmIsCompositionEnabled", 1);
        self.add("DwmModifyPreviousDxFrameDuration", 3);
        self.add("DwmQueryThumbnailSourceSize", 2);
        self.add("DwmRegisterThumbnail", 3);
        self.add("DwmRenderGesture", 4);
        self.add("DwmSetDxFrameDuration", 2);
        self.add("DwmSetIconicLivePreviewBitmap", 4);
        self.add("DwmSetIconicThumbnail", 3);
        self.add("DwmSetPresentParameters", 2);
        self.add("DwmSetWindowAttribute", 4);
        self.add("DwmShowContact", 2);
        self.add("DwmTetherContact", 3);
        self.add("DwmTransitionOwnedWindow", 2);
        self.add("DwmUnregisterThumbnail", 1);
        self.add("DwmUpdateThumbnailProperties", 2);
        self.add("DXVA2CreateDirect3DDeviceManager9", 2);
        self.add("DXVA2CreateVideoService", 3);
        self.add("DXVAHD_CreateDevice", 5);
        self.add("EcClose", 1);
        self.add("EcDeleteSubscription", 2);
        self.add("EcEnumNextSubscription", 4);
        self.add("EcGetObjectArrayProperty", 7);
        self.add("EcGetObjectArraySize", 2);
        self.add("EcGetSubscriptionProperty", 6);
        self.add("EcGetSubscriptionRunTimeStatus", 7);
        self.add("EcInsertObjectArrayElement", 2);
        self.add("EcOpenSubscription", 3);
        self.add("EcOpenSubscriptionEnum", 1);
        self.add("EcRemoveObjectArrayElement", 2);
        self.add("EcRetrySubscription", 3);
        self.add("EcSaveSubscription", 2);
        self.add("EcSetObjectArrayProperty", 5);
        self.add("EcSetSubscriptionProperty", 4);
        self.add("ecvt", 4);
        self.add("ecvt_s", 6);
        self.add("EditSecurity", 2);
        self.add("EditSecurityAdvanced", 3);
        self.add("EditStreamClone", 2);
        self.add("EditStreamCopy", 4);
        self.add("EditStreamCut", 4);
        self.add("EditStreamPaste", 6);
        self.add("EditStreamSetInfo", 3);
        self.add("EditStreamSetName", 2);
        self.add("Ellipse", 5);
        self.add("EmptyClipboard", 0);
        self.add("EmptyWorkingSet", 1);
        self.add("EnableIdleRoutine", 2);
        self.add("EnableMenuItem", 3);
        self.add("EnableMouseInPointer", 1);
        self.add("EnableRouter", 2);
        self.add("EnableScrollBar", 3);
        self.add("EnableThemeDialogTexture", 2);
        self.add("EnableTheming", 1);
        self.add("EnableThreadProfiling", 4);
        self.add("EnableTrace", 5);
        self.add("EnableTraceEx2", 8);
        self.add("EnableTraceEx", 9);
        self.add("EnableWindow", 2);
        self.add("EncodePointer", 1);
        self.add("EncodeSystemPointer", 1);
        self.add("EncryptFile", 1);
        self.add("EncryptionDisable", 2);
        self.add("EncryptMessage", 4);
        self.add("EndBufferedAnimation", 2);
        self.add("EndBufferedPaint", 2);
        self.add("EndDeferWindowPos", 1);
        self.add("EndDialog", 2);
        self.add("EndDoc", 1);
        self.add("EndDocPrinter", 1);
        self.add("EndIdleDetection", 1);
        self.add("EndMenu", 0);
        self.add("EndPage", 1);
        self.add("EndPagePrinter", 1);
        self.add("EndPaint", 2);
        self.add("EndPanningFeedback", 2);
        self.add("EndPath", 1);
        self.add("EndTask", 3);
        self.add("endthread", 0);
        self.add("endthreadex", 1);
        self.add("EndUpdateResource", 2);
        self.add("Enhmfenumproc", 5);
        self.add("EnterCriticalPolicySection", 1);
        self.add("EnterCriticalSection", 1);
        self.add("EnterSynchronizationBarrier", 2);
        self.add("EnterUmsSchedulingMode", 1);
        self.add("EnumCalendarInfo", 4);
        self.add("EnumCalendarInfoEx", 4);
        self.add("EnumCalendarInfoExEx", 6);
        self.add("EnumChildWindows", 3);
        self.add("EnumClipboardFormats", 1);
        self.add("EnumColorProfiles", 5);
        self.add("EnumDateFormats", 3);
        self.add("EnumDateFormatsEx", 3);
        self.add("EnumDateFormatsExEx", 4);
        self.add("EnumDependentServices", 6);
        self.add("EnumDesktops", 3);
        self.add("EnumDesktopWindows", 3);
        self.add("EnumDeviceDrivers", 3);
        self.add("EnumDirTree", 6);
        self.add("EnumDisplayDevices", 4);
        self.add("EnumDisplayDevicesA", 4);
        self.add("EnumDisplayDevicesW", 4);
        self.add("EnumDisplayMonitors", 4);
        self.add("EnumDisplaySettings", 3);
        self.add("EnumDisplaySettingsA", 3);
        self.add("EnumDisplaySettingsEx", 4);
        self.add("EnumDisplaySettingsExA", 4);
        self.add("EnumDisplaySettingsExW", 4);
        self.add("EnumDisplaySettingsW", 3);
        self.add("EnumEnabledLayoutOrTip", 3);
        self.add("EnumEnhMetaFile", 5);
        self.add("EnumerateLoadedModules", 3);
        self.add("EnumerateLoadedModules64", 3);
        self.add("EnumerateLoadedModulesEx", 3);
        self.add("EnumerateLoadedModulesW64", 3);
        self.add("EnumerateSecurityPackages", 2);
        self.add("EnumerateTraceGuids", 3);
        self.add("EnumerateTraceGuidsEx", 6);
        self.add("EnumerateVirtualDiskMetadata", 3);
        self.add("EnumFontFamilies", 4);
        self.add("EnumFontFamiliesA", 4);
        self.add("EnumFontFamiliesEx", 5);
        self.add("EnumFontFamiliesExA", 5);
        self.add("EnumFontFamiliesExW", 5);
        self.add("EnumFontFamiliesW", 4);
        self.add("EnumFonts", 4);
        self.add("EnumFontsA", 4);
        self.add("EnumFontsW", 4);
        self.add("EnumForms", 6);
        self.add("EnumICMProfiles", 3);
        self.add("EnumJobs", 8);
        self.add("EnumLanguageGroupLocales", 4);
        self.add("EnumLayoutOrTipForSetup", 4);
        self.add("EnumMetaFile", 4);
        self.add("EnumMonitors", 6);
        self.add("EnumMRUListW", 4);
        self.add("EnumObjects", 4);
        self.add("EnumPageFiles", 2);
        self.add("EnumPorts", 6);
        self.add("EnumPrinterData", 9);
        self.add("EnumPrinterDataEx", 6);
        self.add("EnumPrinterDrivers", 7);
        self.add("EnumPrinterKey", 5);
        self.add("EnumPrinters", 7);
        self.add("EnumPrintProcessorDatatypes", 7);
        self.add("EnumPrintProcessors", 7);
        self.add("EnumProcesses", 3);
        self.add("EnumProcessModules", 4);
        self.add("EnumProcessModulesEx", 5);
        self.add("EnumProps", 2);
        self.add("EnumPropsA", 2);
        self.add("EnumPropsEx", 3);
        self.add("EnumPropsExA", 3);
        self.add("EnumPropsExW", 3);
        self.add("EnumPropsW", 2);
        self.add("EnumProtocols", 3);
        self.add("EnumPwrSchemes", 2);
        self.add("EnumResourceLanguages", 5);
        self.add("EnumResourceLanguagesEx", 7);
        self.add("EnumResourceNames", 4);
        self.add("EnumResourceNamesEx", 6);
        self.add("EnumResourceTypes", 3);
        self.add("EnumResourceTypesEx", 5);
        self.add("EnumServicesStatus", 8);
        self.add("EnumServicesStatusEx", 10);
        self.add("EnumSystemCodePages", 2);
        self.add("EnumSystemFirmwareTables", 3);
        self.add("EnumSystemGeoID", 3);
        self.add("EnumSystemLanguageGroups", 3);
        self.add("EnumSystemLocales", 2);
        self.add("EnumSystemLocalesEx", 4);
        self.add("EnumThreadWindows", 3);
        self.add("EnumTimeFormats", 3);
        self.add("EnumTimeFormatsEx", 4);
        self.add("EnumUILanguages", 3);
        self.add("EnumWindows", 2);
        self.add("EnumWindowStations", 2);
        self.add("eof", 1);
        self.add("EqualDomainSid", 3);
        self.add("EqualPrefixSid", 2);
        self.add("EqualRect", 2);
        self.add("EqualRgn", 2);
        self.add("EqualSid", 2);
        self.add("EraseTape", 3);
        self.add("Escape", 5);
        self.add("EscapeCommFunction", 2);
        self.add("EstimateFileRiskLevel", 4);
        self.add("EvaluateProximityToPolygon", 4);
        self.add("EvaluateProximityToRect", 3);
        self.add("EventAccessControl", 5);
        self.add("EventAccessQuery", 3);
        self.add("EventAccessRemove", 1);
        self.add("EventActivityIdControl", 2);
        self.add("EventEnabled", 2);
        self.add("EventProviderEnabled", 3);
        self.add("EventRegister", 4);
        self.add("EventSetInformation", 4);
        self.add("EventUnregister", 1);
        self.add("EventWrite", 4);
        self.add("EventWriteEx", 8);
        self.add("EventWriteString", 4);
        self.add("EventWriteTransfer", 6);
        self.add("EvtArchiveExportedLog", 4);
        self.add("EvtClearLog", 4);
        self.add("EvtClose", 1);
        self.add("EvtCreateBookmark", 1);
        self.add("EvtCreateRenderContext", 3);
        self.add("EvtExportLog", 5);
        self.add("EvtFormatMessage", 9);
        self.add("EvtGetChannelConfigProperty", 6);
        self.add("EvtGetEventInfo", 5);
        self.add("EvtGetEventMetadataProperty", 6);
        self.add("EvtGetExtendedStatus", 3);
        self.add("EvtGetLogInfo", 5);
        self.add("EvtGetObjectArrayProperty", 7);
        self.add("EvtGetObjectArraySize", 2);
        self.add("EvtGetPublisherMetadataProperty", 6);
        self.add("EvtGetQueryInfo", 5);
        self.add("EvtNext", 6);
        self.add("EvtNextChannelPath", 4);
        self.add("EvtNextEventMetadata", 2);
        self.add("EvtNextPublisherId", 4);
        self.add("EvtOpenChannelConfig", 3);
        self.add("EvtOpenChannelEnum", 2);
        self.add("EvtOpenEventMetadataEnum", 2);
        self.add("EvtOpenLog", 3);
        self.add("EvtOpenPublisherEnum", 2);
        self.add("EvtOpenPublisherMetadata", 5);
        self.add("EvtOpenSession", 4);
        self.add("EvtQuery", 4);
        self.add("EvtRender", 7);
        self.add("EvtSaveChannelConfig", 2);
        self.add("EvtSeek", 5);
        self.add("EvtSetChannelConfigProperty", 4);
        self.add("EvtSubscribe", 8);
        self.add("EvtUpdateBookmark", 2);
        self.add("ExAcquireFastMutex", 1);
        self.add("ExAcquireFastMutexUnsafe", 1);
        self.add("ExAcquireResourceExclusiveLite", 2);
        self.add("ExAcquireResourceSharedLite", 2);
        self.add("ExAcquireRundownProtection", 1);
        self.add("ExAcquireRundownProtectionEx", 2);
        self.add("ExAcquireSharedStarveExclusive", 2);
        self.add("ExAcquireSharedWaitForExclusive", 2);
        self.add("ExAcquireSpinLockExclusive", 1);
            self.add("ExAcquireSpinLockExclusiveAtDpcLevel", 1);
        self.add("ExAcquireSpinLockShared", 1);
            self.add("ExAcquireSpinLockSharedAtDpcLevel", 1);
        self.add("ExAdjustLookasideDepth", 1);
        self.add("ExAllocateFromLookasideListEx", 1);
            self.add("ExAllocateFromNPagedLookasideList", 1);
            self.add("ExAllocateFromPagedLookasideList", 1);
        self.add("ExAllocatePool", 2);
        self.add("ExAllocatePool2", 3);
        self.add("ExAllocatePool3", 5);
            self.add("ExAllocatePoolPriorityUninitialized", 4);
        self.add("ExAllocatePoolPriorityZero", 4);
            self.add("ExAllocatePoolQuotaUninitialized", 3);
        self.add("ExAllocatePoolQuotaZero", 3);
        self.add("ExAllocatePoolUninitialized", 3);
        self.add("ExAllocatePoolWithQuota", 2);
        self.add("ExAllocatePoolWithQuotaTag", 3);
        self.add("ExAllocatePoolWithTag", 3);
        self.add("ExAllocatePoolWithTagPriority", 4);
        self.add("ExAllocatePoolZero", 3);
        self.add("ExAllocateTimer", 3);
        self.add("ExCallbackFunction", 3);
        self.add("ExCancelTimer", 2);
        self.add("except_handler3", 4);
        self.add("ExcludeClipRect", 5);
        self.add("ExcludeUpdateRgn", 2);
        self.add("ExConvertExclusiveToSharedLite", 1);
        self.add("ExCreateCallback", 4);
        self.add("ExCreatePool", 4);
        self.add("ExDeleteLookasideListEx", 1);
        self.add("ExDeleteNPagedLookasideList", 1);
        self.add("ExDeletePagedLookasideList", 1);
        self.add("ExDeleteResourceLite", 1);
        self.add("ExDeleteTimer", 4);
        self.add("ExDestroyPool", 1);
        self.add("ExDisableResourceBoostLite", 1);
        self.add("execl", 2);
        self.add("execle", 2);
        self.add("execlp", 2);
        self.add("execlpe", 2);
        self.add("ExecuteUmsThread", 1);
        self.add("execv", 2);
        self.add("execve", 3);
        self.add("execvp", 2);
        self.add("execvpe", 3);
            self.add("ExEnterCriticalRegionAndAcquireResourceExclusive", 1);
        self.add("ExFlushLookasideListEx", 1);
        self.add("ExFreePool", 1);
        self.add("ExFreePool2", 4);
        self.add("ExFreePoolWithTag", 2);
        self.add("ExFreeToLookasideListEx", 2);
        self.add("ExFreeToNPagedLookasideList", 2);
        self.add("ExFreeToPagedLookasideList", 2);
        self.add("ExGetExclusiveWaiterCount", 1);
            self.add("ExGetFirmwareEnvironmentVariable", 5);
        self.add("ExGetFirmwareType", 1);
        self.add("ExGetPreviousMode", 1);
        self.add("ExGetSharedWaiterCount", 1);
            self.add("ExInitializeDeleteTimerParameters", 1);
        self.add("ExInitializeDeviceAts", 2);
        self.add("ExInitializeDriverRuntime", 1);
        self.add("ExInitializeFastMutex", 1);
        self.add("ExInitializeLookasideListEx", 8);
        self.add("ExInitializeNPagedLookasideList", 7);
        self.add("ExInitializePagedLookasideList", 7);
        self.add("ExInitializePushLock", 1);
        self.add("ExInitializeResourceLite", 1);
        self.add("ExInitializeRundownProtection", 1);
        self.add("ExInitializeSetTimerParameters", 1);
        self.add("ExInterlockedAddLargeInteger", 3);
        self.add("ExInterlockedAddUlong", 3);
        self.add("ExInterlockedInsertHeadList", 3);
        self.add("ExInterlockedInsertTailList", 3);
        self.add("ExInterlockedPopEntryList", 2);
        self.add("ExInterlockedPushEntryList", 3);
        self.add("ExInterlockedRemoveHeadList", 2);
        self.add("ExIsProcessorFeaturePresent", 1);
            self.add("ExIsResourceAcquiredExclusiveLite", 1);
        self.add("ExIsResourceAcquiredSharedLite", 1);
        self.add("ExIsSoftBoot", 1);
        self.add("exit", 1);
        self.add("ExitProcess", 1);
        self.add("ExitThread", 1);
        self.add("ExitWindowsEx", 2);
        self.add("ExLocalTimeToSystemTime", 2);
        self.add("ExNotifyCallback", 3);
        self.add("exp", 1);
        self.add("expand", 2);
        self.add("expand_dbg", 5);
        self.add("ExpandEnvironmentStrings", 3);
        self.add("ExpandEnvironmentStringsForUser", 4);
        self.add("ExpandVirtualDisk", 4);
        self.add("expf", 1);
        self.add("ExpInterlockedPopEntrySList", 1);
        self.add("ExpInterlockedPushEntrySList", 2);
        self.add("ExportCookieFile", 2);
        self.add("ExportRSoPData", 2);
        self.add("ExportSecurityContext", 4);
        self.add("ExQueryDepthSList", 1);
        self.add("ExQueryPoolBlockSize", 2);
        self.add("ExQueryTimerResolution", 3);
        self.add("ExRaiseStatus", 1);
        self.add("ExRegisterCallback", 3);
        self.add("ExReinitializeResourceLite", 1);
        self.add("ExReInitializeRundownProtection", 1);
        self.add("ExReleaseFastMutex", 1);
        self.add("ExReleaseFastMutexUnsafe", 1);
            self.add("ExReleaseResourceAndLeaveCriticalRegion", 1);
        self.add("ExReleaseResourceForThreadLite", 2);
        self.add("ExReleaseResourceLite", 1);
        self.add("ExReleaseRundownProtection", 1);
        self.add("ExReleaseRundownProtectionEx", 2);
        self.add("ExReleaseSpinLockExclusive", 2);
            self.add("ExReleaseSpinLockExclusiveFromDpcLevel", 1);
        self.add("ExReleaseSpinLockShared", 2);
            self.add("ExReleaseSpinLockSharedFromDpcLevel", 1);
        self.add("ExRundownCompleted", 1);
        self.add("ExSecurePoolUpdate", 7);
        self.add("ExSecurePoolValidate", 4);
            self.add("ExSetFirmwareEnvironmentVariable", 5);
        self.add("ExSetResourceOwnerPointer", 2);
        self.add("ExSetResourceOwnerPointerEx", 3);
        self.add("ExSetTimer", 4);
        self.add("ExSetTimerResolution", 2);
        self.add("ExSystemTimeToLocalTime", 2);
        self.add("ExtCallback", 2);
        self.add("ExtCreatePen", 5);
        self.add("ExtCreateRegion", 3);
        self.add("ExtDeleteCallback", 1);
        self.add("ExtEscape", 6);
        self.add("ExtFloodFill", 5);
        self.add("Extract", 2);
        self.add("ExtractAssociatedIcon", 3);
        self.add("ExtractAssociatedIconA", 3);
        self.add("ExtractAssociatedIconEx", 4);
        self.add("ExtractAssociatedIconExA", 4);
        self.add("ExtractAssociatedIconExW", 4);
        self.add("ExtractAssociatedIconW", 3);
        self.add("ExtractIcon", 3);
        self.add("ExtractIconA", 3);
        self.add("ExtractIconEx", 5);
        self.add("ExtractIconExA", 5);
        self.add("ExtractIconExW", 5);
        self.add("ExtractIconW", 3);
        self.add("ExtractPatchHeaderToFile", 2);
        self.add("ExtractPatchHeaderToFileByHandles", 2);
            self.add("ExTryConvertSharedSpinLockExclusive", 1);
        self.add("ExTryToAcquireFastMutex", 1);
        self.add("ExtSelectClipRgn", 3);
        self.add("ExtTextOut", 8);
        self.add("ExtTextOutA", 8);
        self.add("ExtTextOutW", 8);
        self.add("ExtTextOutWrap", 8);
        self.add("ExUnregisterCallback", 1);
            self.add("ExWaitForRundownProtectionRelease", 1);
        self.add("fabs", 1);
        self.add("FatalAppExit", 2);
        self.add("FatalExit", 1);
        self.add("FaultInIEFeature", 4);
        self.add("FaxAbort", 2);
        self.add("FaxAccessCheck", 2);
        self.add("FaxClose", 1);
        self.add("FaxCompleteJobParams", 2);
        self.add("FaxConnectFaxServer", 2);
        self.add("FaxEnableRoutingMethod", 3);
        self.add("FaxEnumGlobalRoutingInfo", 3);
        self.add("FaxEnumJobs", 3);
        self.add("FaxEnumPorts", 3);
        self.add("FaxEnumRoutingMethods", 3);
        self.add("FaxFreeBuffer", 1);
        self.add("FaxGetConfiguration", 2);
        self.add("FaxGetDeviceStatus", 2);
        self.add("FaxGetJob", 3);
        self.add("FaxGetLoggingCategories", 3);
        self.add("FaxGetPageData", 6);
        self.add("FaxGetPort", 2);
        self.add("FaxGetRoutingInfo", 4);
        self.add("FaxInitializeEventQueue", 5);
        self.add("FaxOpenPort", 4);
        self.add("FaxPrintCoverPage", 2);
        self.add("FaxRegisterRoutingExtensionW", 6);
        self.add("FaxRegisterServiceProviderW", 4);
        self.add("FaxSendDocument", 5);
        self.add("FaxSendDocumentForBroadcast", 5);
        self.add("FaxSetConfiguration", 2);
        self.add("FaxSetGlobalRoutingInfo", 2);
        self.add("FaxSetJob", 4);
        self.add("FaxSetLoggingCategories", 3);
        self.add("FaxSetPort", 2);
        self.add("FaxSetRoutingInfo", 4);
        self.add("FaxStartPrintJob", 4);
        self.add("FBadColumnSet", 1);
        self.add("FBadEntryList", 1);
        self.add("FBadProp", 1);
        self.add("FBadPropTag", 1);
        self.add("FBadRestriction", 1);
        self.add("FBadRglpNameID", 2);
        self.add("FBadRglpszW", 2);
        self.add("FBadRow", 1);
        self.add("FBadRowSet", 1);
        self.add("FBadSortOrderSet", 1);
        self.add("FBinFromHex", 2);
        self.add("FCIAddFile", 8);
        self.add("FCICreate", 13);
        self.add("FCIDestroy", 1);
        self.add("FCIFlushCabinet", 4);
        self.add("FCIFlushFolder", 3);
        self.add("fclose", 1);
        self.add("fcloseall", 0);
        self.add("fclose_nolock", 1);
        self.add("fcvt", 4);
        self.add("fcvt_s", 6);
        self.add("FDICopy", 7);
        self.add("FDICreate", 9);
        self.add("FDIDestroy", 1);
        self.add("FDIIsCabinet", 3);
        self.add("FDITruncateCabinet", 3);
        self.add("fdopen", 2);
        self.add("feof", 1);
        self.add("FEqualNames", 2);
        self.add("ferror", 1);
        self.add("fflush", 1);
        self.add("fflush_nolock", 1);
        self.add("fgetc", 1);
        self.add("fgetchar", 0);
        self.add("FGetComponentPath", 5);
        self.add("fgetpos", 2);
        self.add("fgets", 3);
        self.add("fgetwc", 1);
        self.add("fgetwchar", 0);
        self.add("fgetwc_nolock", 1);
        self.add("fgetws", 3);
        self.add("FileEncryptionStatus", 2);
        self.add("FileIconInit", 1);
        self.add("filelength", 1);
        self.add("filelengthi64", 1);
        self.add("fileno", 1);
        self.add("FileTimeToDosDateTime", 3);
        self.add("FileTimeToLocalFileTime", 2);
        self.add("FileTimeToSystemTime", 2);
        self.add("FillConsoleOutputAttribute", 5);
        self.add("FillConsoleOutputCharacter", 5);
        self.add("FillPath", 1);
        self.add("FillRect", 3);
        self.add("FillRgn", 3);
        self.add("FindActCtxSectionGuid", 5);
        self.add("FindActCtxSectionString", 5);
        self.add("FindAtom", 1);
        self.add("findclose", 1);
        self.add("FindClose", 1);
        self.add("FindCloseChangeNotification", 1);
        self.add("FindClosePrinterChangeNotification", 1);
        self.add("FindCloseUrlCache", 1);
        self.add("FindDebugInfoFile", 3);
        self.add("FindDebugInfoFileEx", 5);
        self.add("FindExecutable", 3);
        self.add("FindExecutableA", 3);
        self.add("FindExecutableImage", 3);
        self.add("FindExecutableImageEx", 5);
        self.add("FindExecutableW", 3);
        self.add("findfirst", 2);
        self.add("findfirst32", 2);
        self.add("findfirst32i64", 2);
        self.add("findfirst64", 2);
        self.add("findfirst64i32", 2);
        self.add("FindFirstChangeNotification", 3);
        self.add("FindFirstChangeNotificationA", 3);
        self.add("FindFirstChangeNotificationW", 3);
        self.add("FindFirstFile", 2);
        self.add("FindFirstFileA", 2);
        self.add("FindFirstFileEx", 6);
        self.add("FindFirstFileExA", 6);
        self.add("FindFirstFileExW", 6);
        self.add("FindFirstFileNameTransactedW", 5);
        self.add("FindFirstFileNameW", 4);
        self.add("FindFirstFileTransacted", 7);
        self.add("FindFirstFileW", 2);
        self.add("FindFirstFreeAce", 2);
        self.add("findfirsti64", 2);
        self.add("FindFirstPrinterChangeNotification", 4);
        self.add("FindFirstStreamTransactedW", 5);
        self.add("FindFirstStreamW", 4);
        self.add("FindFirstUrlCacheContainer", 4);
        self.add("FindFirstUrlCacheEntry", 3);
        self.add("FindFirstUrlCacheEntryA", 3);
        self.add("FindFirstUrlCacheEntryEx", 9);
        self.add("FindFirstUrlCacheEntryExA", 9);
        self.add("FindFirstUrlCacheEntryExW", 9);
        self.add("FindFirstUrlCacheEntryW", 3);
        self.add("FindFirstUrlCacheGroup", 6);
        self.add("FindFirstVolume", 2);
        self.add("FindFirstVolumeMountPoint", 3);
        self.add("FindFirstVolumeW", 2);
        self.add("FindMediaType", 2);
        self.add("FindMediaTypeClass", 4);
        self.add("FindMimeFromData", 8);
        self.add("findnext", 2);
        self.add("findnext32", 2);
        self.add("findnext32i64", 2);
        self.add("findnext64", 2);
        self.add("findnext64i32", 2);
        self.add("FindNextChangeNotification", 1);
        self.add("FindNextFile", 2);
        self.add("FindNextFileA", 2);
        self.add("FindNextFileNameW", 3);
        self.add("FindNextFileW", 2);
        self.add("findnexti64", 2);
        self.add("FindNextPrinterChangeNotification", 4);
        self.add("FindNextStreamW", 2);
        self.add("FindNextUrlCacheContainer", 3);
        self.add("FindNextUrlCacheEntry", 3);
        self.add("FindNextUrlCacheEntryA", 3);
        self.add("FindNextUrlCacheEntryEx", 6);
        self.add("FindNextUrlCacheEntryExA", 6);
        self.add("FindNextUrlCacheEntryExW", 6);
        self.add("FindNextUrlCacheEntryW", 3);
        self.add("FindNextUrlCacheGroup", 3);
        self.add("FindNextVolume", 3);
        self.add("FindNextVolumeMountPoint", 3);
        self.add("FindNextVolumeW", 3);
        self.add("FindNLSString", 7);
        self.add("FindNLSStringEx", 10);
        self.add("FindP3PPolicySymbol", 1);
        self.add("FindResource", 3);
        self.add("FindResourceEx", 4);
        self.add("FindResourceWrapW", 3);
        self.add("FindStringOrdinal", 6);
        self.add("FindText", 1);
        self.add("FindVolumeClose", 1);
        self.add("FindVolumeMountPointClose", 1);
        self.add("FindWindow", 2);
        self.add("FindWindowA", 2);
        self.add("FindWindowEx", 4);
        self.add("FindWindowExA", 4);
        self.add("FindWindowExW", 4);
        self.add("FindWindowW", 2);
        self.add("finite", 1);
        self.add("FirstEntrySList", 1);
        self.add("FlashWindow", 2);
        self.add("FlashWindowEx", 1);
        self.add("FlatSB_EnableScrollBar", 3);
        self.add("FlatSB_GetScrollInfo", 3);
        self.add("FlatSB_GetScrollPos", 2);
        self.add("FlatSB_GetScrollProp", 3);
        self.add("FlatSB_GetScrollPropPtr", 3);
        self.add("FlatSB_GetScrollRange", 4);
        self.add("FlatSB_SetScrollInfo", 4);
        self.add("FlatSB_SetScrollPos", 4);
        self.add("FlatSB_SetScrollProp", 4);
        self.add("FlatSB_SetScrollRange", 5);
        self.add("FlatSB_ShowScrollBar", 3);
        self.add("FlattenPath", 1);
        self.add("FloodFill", 4);
        self.add("floor", 1);
        self.add("floorf", 1);
        self.add("FlsAlloc", 1);
        self.add("FlsFree", 1);
        self.add("FlsGetValue", 1);
        self.add("FlsSetValue", 2);
        self.add("FltAcknowledgeEcp", 2);
        self.add("FltAcquirePushLockExclusive", 1);
        self.add("FltAcquirePushLockExclusiveEx", 2);
        self.add("FltAcquirePushLockShared", 1);
        self.add("FltAcquirePushLockSharedEx", 2);
        self.add("FltAddOpenReparseEntry", 3);
            self.add("FltAdjustDeviceStackSizeForIoRedirection", 3);
        self.add("FltAllocateCallbackData", 3);
        self.add("FltAllocateCallbackDataEx", 4);
        self.add("FltAllocateContext", 5);
        self.add("FltAllocateDeferredIoWorkItem", 1);
        self.add("FltAllocateExtraCreateParameter", 7);
            self.add("FltAllocateExtraCreateParameterFromLookasideList", 7);
            self.add("FltAllocateExtraCreateParameterList", 3);
        self.add("FltAllocateFileLock", 2);
        self.add("FltAllocateGenericWorkItem", 1);
        self.add("FltAllocatePoolAlignedWithTag", 4);
        self.add("FltApplyPriorityInfoThread", 3);
        self.add("FltAttachVolume", 4);
        self.add("FltAttachVolumeAtAltitude", 5);
            self.add("FltBuildDefaultSecurityDescriptor", 2);
        self.add("FltCancelFileOpen", 2);
        self.add("FltCancelIo", 1);
            self.add("FltCancellableWaitForMultipleObjects", 6);
            self.add("FltCancellableWaitForSingleObject", 3);
        self.add("FltCbdqDisable", 1);
        self.add("FltCbdqEnable", 1);
        self.add("FltCbdqInitialize", 8);
        self.add("FltCbdqInsertIo", 4);
        self.add("FltCbdqRemoveIo", 2);
        self.add("FltCbdqRemoveNextIo", 2);
        self.add("FltCheckAndGrowNameControl", 2);
        self.add("FltCheckLockForReadAccess", 2);
        self.add("FltCheckLockForWriteAccess", 2);
        self.add("FltCheckOplock", 5);
        self.add("FltCheckOplockEx", 6);
        self.add("FltClearCallbackDataDirty", 1);
        self.add("FltClearCancelCompletion", 1);
        self.add("FltClose", 1);
        self.add("FltCloseClientPort", 2);
        self.add("FltCloseCommunicationPort", 1);
        self.add("FltCloseSectionForDataScan", 1);
        self.add("FltCommitComplete", 3);
        self.add("FltCommitFinalizeComplete", 3);
        self.add("FltCompareInstanceAltitudes", 2);
        self.add("FltCompletePendedPostOperation", 1);
        self.add("FltCompletePendedPreOperation", 3);
        self.add("FltCopyOpenReparseList", 3);
        self.add("FltCreateCommunicationPort", 8);
        self.add("FltCreateFile", 14);
        self.add("FltCreateFileEx", 15);
        self.add("FltCreateFileEx2", 16);
        self.add("FltCreateMailslotFile", 12);
        self.add("FltCreateNamedPipeFile", 18);
        self.add("FltCreateSectionForDataScan", 12);
            self.add("FltCreateSystemVolumeInformationFolder", 1);
        self.add("FltCurrentBatchOplock", 1);
        self.add("FltCurrentOplock", 1);
        self.add("FltCurrentOplockH", 1);
        self.add("FltDecodeParameters", 5);
        self.add("FltDeleteContext", 1);
            self.add("FltDeleteExtraCreateParameterLookasideList", 3);
        self.add("FltDeleteFileContext", 3);
        self.add("FltDeleteInstanceContext", 2);
        self.add("FltDeletePushLock", 1);
        self.add("FltDeleteStreamContext", 3);
        self.add("FltDeleteStreamHandleContext", 3);
        self.add("FltDeleteTransactionContext", 3);
        self.add("FltDeleteVolumeContext", 3);
        self.add("FltDetachVolume", 3);
        self.add("FltDeviceIoControlFile", 8);
            self.add("FltDoCompletionProcessingWhenSafe", 6);
        self.add("FltEnlistInTransaction", 4);
        self.add("FltEnumerateFilterInformation", 5);
        self.add("FltEnumerateFilters", 3);
            self.add("FltEnumerateInstanceInformationByDeviceObject", 6);
            self.add("FltEnumerateInstanceInformationByFilter", 6);
            self.add("FltEnumerateInstanceInformationByVolume", 6);
            self.add("FltEnumerateInstanceInformationByVolumeName", 6);
        self.add("FltEnumerateInstances", 5);
        self.add("FltEnumerateVolumeInformation", 6);
        self.add("FltEnumerateVolumes", 4);
        self.add("FltFastIoMdlRead", 7);
        self.add("FltFastIoMdlReadComplete", 3);
        self.add("FltFastIoMdlWriteComplete", 4);
        self.add("FltFastIoPrepareMdlWrite", 7);
        self.add("FltFindExtraCreateParameter", 5);
        self.add("FltFlushBuffers", 2);
        self.add("FltFlushBuffers2", 4);
        self.add("FltFreeCallbackData", 1);
        self.add("FltFreeDeferredIoWorkItem", 1);
        self.add("FltFreeExtraCreateParameter", 2);
        self.add("FltFreeExtraCreateParameterList", 2);
        self.add("FltFreeFileLock", 1);
        self.add("FltFreeGenericWorkItem", 1);
        self.add("FltFreeOpenReparseList", 2);
        self.add("FltFreePoolAlignedWithTag", 3);
        self.add("FltFreeSecurityDescriptor", 1);
        self.add("FltFsControlFile", 8);
        self.add("FltGetActivityIdCallbackData", 2);
        self.add("FltGetBottomInstance", 2);
        self.add("FltGetContexts", 3);
        self.add("FltGetContextsEx", 4);
            self.add("FltGetCopyInformationFromCallbackData", 2);
            self.add("FltGetDestinationFileNameInformation", 7);
        self.add("FltGetDeviceObject", 2);
        self.add("FltGetDiskDeviceObject", 2);
        self.add("FltGetEcpListFromCallbackData", 3);
        self.add("FltGetFileContext", 3);
        self.add("FltGetFileNameInformation", 3);
        self.add("FltGetFileNameInformationUnsafe", 4);
        self.add("FltGetFileSystemType", 2);
        self.add("FltGetFilterFromInstance", 2);
        self.add("FltGetFilterFromName", 2);
        self.add("FltGetFilterInformation", 5);
        self.add("FltGetInstanceContext", 2);
        self.add("FltGetInstanceInformation", 5);
        self.add("FltGetIoPriorityHint", 1);
            self.add("FltGetIoPriorityHintFromCallbackData", 1);
            self.add("FltGetIoPriorityHintFromFileObject", 1);
        self.add("FltGetIoPriorityHintFromThread", 1);
        self.add("FltGetIrpName", 1);
        self.add("FltGetLowerInstance", 2);
        self.add("FltGetNewSystemBufferAddress", 1);
        self.add("FltGetNextExtraCreateParameter", 6);
        self.add("FltGetRequestorProcess", 1);
        self.add("FltGetRequestorProcessId", 1);
        self.add("FltGetRequestorProcessIdEx", 1);
        self.add("FltGetRequestorSessionId", 2);
        self.add("FltGetRoutineAddress", 1);
        self.add("FltGetSectionContext", 3);
        self.add("FltGetStreamContext", 3);
        self.add("FltGetStreamHandleContext", 3);
        self.add("FltGetSwappedBufferMdlAddress", 1);
        self.add("FltGetTopInstance", 2);
        self.add("FltGetTransactionContext", 3);
        self.add("FltGetTunneledName", 3);
        self.add("FltGetUpperInstance", 2);
        self.add("FltGetVolumeContext", 3);
        self.add("FltGetVolumeFromDeviceObject", 3);
        self.add("FltGetVolumeFromFileObject", 3);
        self.add("FltGetVolumeFromInstance", 2);
        self.add("FltGetVolumeFromName", 3);
        self.add("FltGetVolumeGuidName", 3);
        self.add("FltGetVolumeInformation", 5);
        self.add("FltGetVolumeInstanceFromName", 4);
        self.add("FltGetVolumeName", 3);
        self.add("FltGetVolumeProperties", 4);
            self.add("FltInitExtraCreateParameterLookasideList", 5);
        self.add("FltInitializeFileLock", 1);
        self.add("FltInitializeOplock", 1);
        self.add("FltInitializePushLock", 1);
        self.add("FltInsertExtraCreateParameter", 3);
        self.add("FltIs32bitProcess", 1);
        self.add("FltIsCallbackDataDirty", 1);
        self.add("FltIsDirectory", 3);
        self.add("FltIsEcpAcknowledged", 2);
        self.add("FltIsEcpFromUserMode", 2);
        self.add("FltIsFltMgrVolumeDeviceObject", 1);
        self.add("FltIsIoCanceled", 1);
        self.add("FltIsIoRedirectionAllowed", 3);
            self.add("FltIsIoRedirectionAllowedForOperation", 4);
        self.add("FltIsOperationSynchronous", 1);
        self.add("FltIsVolumeSnapshot", 2);
        self.add("FltIsVolumeWritable", 2);
        self.add("FltLoadFilter", 1);
        self.add("FltLockUserBuffer", 1);
        self.add("FltNotifyFilterChangeDirectory", 11);
        self.add("FltObjectDereference", 1);
        self.add("FltObjectReference", 1);
        self.add("FltOpenVolume", 3);
        self.add("FltOplockBreakH", 6);
        self.add("FltOplockBreakToNone", 5);
        self.add("FltOplockBreakToNoneEx", 6);
        self.add("FltOplockFsctrl", 3);
        self.add("FltOplockFsctrlEx", 4);
        self.add("FltOplockIsFastIoPossible", 1);
        self.add("FltOplockIsSharedRequest", 1);
        self.add("FltOplockKeysEqual", 2);
        self.add("FltParseFileName", 4);
        self.add("FltParseFileNameInformation", 1);
        self.add("FltPerformAsynchronousIo", 3);
        self.add("FltPerformSynchronousIo", 1);
        self.add("FltPrepareComplete", 3);
        self.add("FltPrepareToReuseEcp", 2);
        self.add("FltPrePrepareComplete", 3);
        self.add("FltProcessFileLock", 3);
        self.add("FltPropagateActivityIdToThread", 3);
        self.add("FltPropagateIrpExtension", 3);
            self.add("FltPurgeFileNameInformationCache", 2);
        self.add("FltQueryDirectoryFile", 9);
        self.add("FltQueryDirectoryFileEx", 8);
        self.add("FltQueryEaFile", 10);
        self.add("FltQueryInformationByName", 8);
        self.add("FltQueryInformationFile", 6);
        self.add("FltQueryQuotaInformationFile", 11);
        self.add("FltQuerySecurityObject", 6);
        self.add("FltQueryVolumeInformation", 5);
        self.add("FltQueryVolumeInformationFile", 6);
        self.add("FltQueueDeferredIoWorkItem", 5);
        self.add("FltQueueGenericWorkItem", 5);
        self.add("FltReadFile", 9);
        self.add("FltReadFileEx", 11);
        self.add("FltReferenceContext", 1);
        self.add("FltReferenceFileNameInformation", 1);
        self.add("FltRegisterFilter", 3);
        self.add("FltRegisterForDataScan", 1);
        self.add("FltReissueSynchronousIo", 2);
        self.add("FltReleaseContext", 1);
        self.add("FltReleaseContexts", 1);
        self.add("FltReleaseContextsEx", 2);
        self.add("FltReleaseFileNameInformation", 1);
        self.add("FltReleasePushLock", 1);
        self.add("FltReleasePushLockEx", 2);
        self.add("FltRemoveExtraCreateParameter", 5);
        self.add("FltRemoveOpenReparseEntry", 3);
            self.add("FltRequestFileInfoOnCreateCompletion", 3);
            self.add("FltRequestOperationStatusCallback", 3);
            self.add("FltRetainSwappedBufferMdlAddress", 1);
            self.add("FltRetrieveFileInfoOnCreateCompletion", 4);
            self.add("FltRetrieveFileInfoOnCreateCompletionEx", 5);
        self.add("FltRetrieveIoPriorityInfo", 4);
        self.add("FltReuseCallbackData", 1);
        self.add("FltRollbackComplete", 3);
        self.add("FltRollbackEnlistment", 3);
        self.add("FltSendMessage", 7);
        self.add("FltSetActivityIdCallbackData", 2);
        self.add("FltSetCallbackDataDirty", 1);
        self.add("FltSetCancelCompletion", 2);
        self.add("FltSetEaFile", 4);
        self.add("FltSetEcpListIntoCallbackData", 3);
        self.add("FltSetFileContext", 5);
        self.add("FltSetInformationFile", 5);
        self.add("FltSetInstanceContext", 4);
            self.add("FltSetIoPriorityHintIntoCallbackData", 2);
            self.add("FltSetIoPriorityHintIntoFileObject", 2);
        self.add("FltSetIoPriorityHintIntoThread", 2);
        self.add("FltSetQuotaInformationFile", 4);
        self.add("FltSetSecurityObject", 4);
        self.add("FltSetStreamContext", 5);
        self.add("FltSetStreamHandleContext", 5);
        self.add("FltSetTransactionContext", 5);
        self.add("FltSetVolumeContext", 4);
        self.add("FltSetVolumeInformation", 5);
        self.add("FltStartFiltering", 1);
        self.add("FltSupportsFileContexts", 1);
        self.add("FltSupportsFileContextsEx", 2);
        self.add("FltSupportsStreamContexts", 1);
        self.add("FltSupportsStreamHandleContexts", 1);
        self.add("FltTagFile", 6);
        self.add("FltTagFileEx", 9);
        self.add("FltUninitializeFileLock", 1);
        self.add("FltUninitializeOplock", 1);
        self.add("FltUnloadFilter", 1);
        self.add("FltUnregisterFilter", 1);
        self.add("FltUntagFile", 4);
        self.add("FltVetoBypassIo", 4);
        self.add("FltWriteFile", 9);
        self.add("FltWriteFileEx", 11);
        self.add("flushall", 0);
        self.add("FlushConsoleInputBuffer", 1);
        self.add("FlushFileBuffers", 1);
        self.add("FlushInstructionCache", 3);
        self.add("FlushIpNetTable", 1);
        self.add("FlushIpNetTable2", 2);
        self.add("FlushIpPathTable", 1);
        self.add("FlushLogBuffers", 2);
        self.add("FlushLogToLsn", 4);
        self.add("FlushPrinter", 5);
        self.add("FlushProcessWriteBuffers", 0);
        self.add("FlushProcessWriteBuffers", 1);
        self.add("FlushTrace", 3);
        self.add("FlushViewOfFile", 2);
        self.add("fmod", 2);
        self.add("fmodf", 2);
        self.add("FmtIdToPropStgName", 2);
        self.add("FoldString", 5);
        self.add("fopen", 2);
        self.add("fopen_s", 3);
        self.add("FormatMessage", 7);
        self.add("fpclass", 1);
        self.add("FpgaBusScan", 1);
        self.add("FpgaControlConfigSpace", 2);
        self.add("FpgaControlErrorReporting", 4);
        self.add("FpgaControlLink", 2);
        self.add("fpieee_flt", 3);
        self.add("fpreset", 0);
        self.add("fprintf", 2);
        self.add("fprintf_l", 3);
        self.add("fprintf_p", 2);
        self.add("fprintf_p_l", 3);
        self.add("fprintf_s", 2);
        self.add("fprintf_s_l", 3);
        self.add("FPropCompareProp", 3);
        self.add("FPropContainsProp", 3);
        self.add("FPropExists", 2);
        self.add("fputc", 2);
        self.add("fputchar", 1);
        self.add("fputs", 2);
        self.add("fputwc", 2);
        self.add("fputwchar", 1);
        self.add("fputwc_nolock", 2);
        self.add("fputws", 2);
        self.add("FrameRect", 3);
        self.add("FrameRgn", 5);
        self.add("fread", 4);
        self.add("fread_nolock", 4);
        self.add("free", 1);
        self.add("freea", 1);
        self.add("freeaddrinfo", 1);
        self.add("FreeAddrInfoEx", 1);
        self.add("FreeAddrInfoW", 1);
        self.add("FreeADsMem", 1);
        self.add("FreeADsStr", 1);
        self.add("FreeConsole", 0);
        self.add("FreeContextBuffer", 1);
        self.add("FreeCredentialsHandle", 1);
        self.add("FreeCryptProvFromCert", 5);
        self.add("FreeCryptProvFromCertEx", 6);
        self.add("free_dbg", 2);
        self.add("FreeDDElParam", 2);
        self.add("FreeEncryptionCertificateHashList", 1);
        self.add("FreeEnvironmentStrings", 1);
        self.add("FreeFunctionEx", 2);
        self.add("FreeGPOList", 1);
        self.add("FreeInheritedFromArray", 3);
        self.add("FreeLibrary", 1);
        self.add("FreeLibraryAndExitThread", 2);
        self.add("FreeLibraryWhenCallbackReturns", 2);
        self.add("free_locale", 1);
        self.add("FreeMibTable", 1);
        self.add("FreeMRUList", 1);
        self.add("FreeP3PObject", 1);
        self.add("FreePadrlist", 1);
        self.add("FreePrinterNotifyInfo", 1);
        self.add("FreePropVariantArray", 2);
        self.add("FreeProws", 1);
        self.add("FreeReservedLog", 3);
        self.add("FreeResource", 1);
        self.add("FreeSid", 1);
        self.add("FreeUrlCacheSpace", 3);
        self.add("FreeUserPhysicalPages", 3);
        self.add("FreeVirtualMemoryExCallback", 5);
        self.add("freopen", 3);
        self.add("freopen_s", 4);
        self.add("frexp", 2);
        self.add("FrostCrashedWindow", 2);
        self.add("fscanf", 2);
        self.add("fscanf_l", 3);
        self.add("fscanf_s", 2);
        self.add("fscanf_s_l", 3);
        self.add("fseek", 3);
        self.add("fseeki64", 3);
        self.add("fseeki64_nolock", 3);
        self.add("fseek_nolock", 3);
        self.add("fsetpos", 2);
        self.add("fsopen", 3);
        self.add("FsRtlAcknowledgeEcp", 1);
        self.add("FsRtlAcquireFileExclusive", 1);
        self.add("FsRtlAddBaseMcbEntryEx", 4);
        self.add("FsRtlAddLargeMcbEntry", 4);
        self.add("FsRtlAddMcbEntry", 4);
        self.add("FsRtlAddToTunnelCache", 7);
        self.add("FsRtlAllocateAePushLock", 2);
            self.add("FsRtlAllocateExtraCreateParameter", 6);
            self.add("FsRtlAllocateExtraCreateParameterFromLookasideList", 6);
            self.add("FsRtlAllocateExtraCreateParameterList", 2);
        self.add("FsRtlAllocateFileLock", 2);
        self.add("FsRtlAllocateResource", 1);
        self.add("FsRtlAreNamesEqual", 4);
            self.add("FsRtlAreThereCurrentOrInProgressFileLocks", 1);
        self.add("FsRtlAreThereWaitingFileLocks", 1);
            self.add("FsRtlAreVolumeStartupApplicationsComplete", 1);
        self.add("FsRtlBalanceReads", 1);
            self.add("FsRtlCancellableWaitForMultipleObjects", 6);
            self.add("FsRtlCancellableWaitForSingleObject", 3);
        self.add("FsRtlChangeBackingFileObject", 4);
        self.add("FsRtlCheckLockForOplockRequest", 2);
        self.add("FsRtlCheckLockForReadAccess", 2);
        self.add("FsRtlCheckLockForWriteAccess", 2);
        self.add("FsRtlCheckOplock", 5);
        self.add("FsRtlCheckOplockEx2", 10);
        self.add("FsRtlCheckOplockEx", 6);
        self.add("FsRtlCheckUpperOplock", 6);
        self.add("FsRtlCopyRead", 8);
        self.add("FsRtlCopyWrite", 8);
        self.add("FsRtlCreateSectionForDataScan", 10);
        self.add("FsRtlCurrentBatchOplock", 1);
        self.add("FsRtlCurrentOplock", 1);
        self.add("FsRtlCurrentOplockH", 1);
            self.add("FsRtlDeleteExtraCreateParameterLookasideList", 2);
        self.add("FsRtlDeleteKeyFromTunnelCache", 2);
        self.add("FsRtlDeleteTunnelCache", 1);
        self.add("FsRtlDeregisterUncProvider", 1);
        self.add("FsRtlDissectDbcs", 3);
        self.add("FsRtlDissectName", 3);
        self.add("FsRtlDoesDbcsContainWildCards", 1);
        self.add("FsRtlDoesNameContainWildCards", 1);
        self.add("FsRtlFastCheckLockForRead", 6);
        self.add("FsRtlFastCheckLockForWrite", 6);
        self.add("FsRtlFastUnlockAll", 4);
        self.add("FsRtlFastUnlockAllByKey", 5);
        self.add("FsRtlFastUnlockSingle", 8);
        self.add("FsRtlFindExtraCreateParameter", 4);
        self.add("FsRtlFindInTunnelCache", 7);
        self.add("FsRtlFreeAePushLock", 1);
        self.add("FsRtlFreeExtraCreateParameter", 1);
            self.add("FsRtlFreeExtraCreateParameterList", 1);
        self.add("FsRtlFreeFileLock", 1);
        self.add("FsRtlGetEcpListFromIrp", 2);
        self.add("FsRtlGetFileSize", 2);
            self.add("FsRtlGetNextExtraCreateParameter", 5);
        self.add("FsRtlGetNextFileLock", 2);
        self.add("FsRtlGetNextLargeMcbEntry", 5);
        self.add("FsRtlGetNextMcbEntry", 5);
        self.add("FsRtlGetSectorSizeInformation", 2);
        self.add("FsRtlGetSupportedFeatures", 2);
        self.add("FsRtlIncrementCcFastMdlReadWait", 1);
            self.add("FsRtlIncrementCcFastReadNotPossible", 1);
        self.add("FsRtlIncrementCcFastReadNoWait", 1);
            self.add("FsRtlIncrementCcFastReadResourceMiss", 1);
        self.add("FsRtlIncrementCcFastReadWait", 1);
            self.add("FsRtlInitExtraCreateParameterLookasideList", 4);
        self.add("FsRtlInitializeBaseMcb", 2);
        self.add("FsRtlInitializeBaseMcbEx", 3);
            self.add("FsRtlInitializeExtraCreateParameter", 6);
            self.add("FsRtlInitializeExtraCreateParameterList", 1);
        self.add("FsRtlInitializeFileLock", 3);
        self.add("FsRtlInitializeLargeMcb", 2);
        self.add("FsRtlInitializeMcb", 2);
        self.add("FsRtlInitializeOplock", 1);
        self.add("FsRtlInitializeTunnelCache", 1);
        self.add("FsRtlInsertExtraCreateParameter", 2);
        self.add("FsRtlInsertPerFileContext", 2);
        self.add("FsRtlInsertPerFileObjectContext", 2);
        self.add("FsRtlInsertPerStreamContext", 2);
        self.add("FsRtlIsDaxVolume", 1);
        self.add("FsRtlIsDbcsInExpression", 2);
        self.add("FsRtlIsEcpAcknowledged", 1);
        self.add("FsRtlIsEcpFromUserMode", 1);
        self.add("FsRtlIsFatDbcsLegal", 4);
        self.add("FsRtlIsHpfsDbcsLegal", 4);
        self.add("FsRtlIsNameInExpression", 4);
            self.add("FsRtlIsNameInUnUpcasedExpression", 4);
        self.add("FsRtlIsNtstatusExpected", 1);
        self.add("FsRtlIsPagingFile", 1);
        self.add("FsRtlIssueDeviceIoControl", 8);
        self.add("FsRtlIsSystemPagingFile", 1);
        self.add("FsRtlIsTotalDeviceFailure", 1);
        self.add("FsRtlKernelFsControlFile", 7);
        self.add("FsRtlLogCcFlushError", 5);
        self.add("FsRtlLookupBaseMcbEntry", 7);
        self.add("FsRtlLookupLargeMcbEntry", 7);
        self.add("FsRtlLookupLastLargeMcbEntry", 3);
            self.add("FsRtlLookupLastLargeMcbEntryAndIndex", 4);
        self.add("FsRtlLookupLastMcbEntry", 3);
        self.add("FsRtlLookupMcbEntry", 5);
        self.add("FsRtlLookupPerFileContext", 3);
        self.add("FsRtlLookupPerFileObjectContext", 3);
            self.add("FsRtlLookupPerStreamContextInternal", 3);
        self.add("FsRtlMdlReadCompleteDev", 3);
        self.add("FsRtlMdlReadDev", 7);
        self.add("FsRtlMdlReadEx", 6);
        self.add("FsRtlMdlWriteCompleteDev", 4);
        self.add("FsRtlMupGetProviderIdFromName", 2);
            self.add("FsRtlMupGetProviderInfoFromFileObject", 4);
        self.add("FsRtlNormalizeNtstatus", 2);
        self.add("FsRtlNotifyCleanup", 3);
        self.add("FsRtlNotifyCleanupAll", 2);
            self.add("FsRtlNotifyFilterChangeDirectory", 11);
        self.add("FsRtlNotifyFilterReportChange", 10);
        self.add("FsRtlNotifyFullChangeDirectory", 10);
        self.add("FsRtlNotifyFullReportChange", 9);
        self.add("FsRtlNotifyInitializeSync", 1);
        self.add("FsRtlNotifyUninitializeSync", 1);
        self.add("FsRtlNotifyVolumeEvent", 2);
        self.add("FsRtlNotifyVolumeEventEx", 3);
        self.add("FsRtlNumberOfRunsInLargeMcb", 1);
        self.add("FsRtlNumberOfRunsInMcb", 1);
        self.add("FsRtlOplockBreakH", 6);
        self.add("FsRtlOplockBreakToNone", 6);
        self.add("FsRtlOplockBreakToNoneEx", 6);
        self.add("FsRtlOplockFsctrl", 3);
        self.add("FsRtlOplockFsctrlEx", 4);
        self.add("FsRtlOplockIsFastIoPossible", 1);
        self.add("FsRtlOplockIsSharedRequest", 1);
        self.add("FsRtlOplockKeysEqual", 2);
            self.add("FsRtlPostPagingFileStackOverflow", 3);
        self.add("FsRtlPostStackOverflow", 3);
        self.add("FsRtlPrepareMdlWriteDev", 7);
        self.add("FsRtlPrepareMdlWriteEx", 6);
        self.add("FsRtlPrepareToReuseEcp", 1);
        self.add("FsRtlPrivateLock", 12);
        self.add("FsRtlProcessFileLock", 3);
        self.add("FsRtlQueryCachedVdl", 2);
        self.add("FsRtlQueryKernelEaFile", 9);
            self.add("FsRtlRegisterFileSystemFilterCallbacks", 2);
        self.add("FsRtlRegisterUncProvider", 3);
        self.add("FsRtlRegisterUncProviderEx", 4);
        self.add("FsRtlReleaseFile", 1);
        self.add("FsRtlRemoveBaseMcbEntry", 3);
        self.add("FsRtlRemoveDotsFromPath", 3);
        self.add("FsRtlRemoveExtraCreateParameter", 4);
        self.add("FsRtlRemoveLargeMcbEntry", 3);
        self.add("FsRtlRemoveMcbEntry", 3);
        self.add("FsRtlRemovePerFileContext", 3);
        self.add("FsRtlRemovePerFileObjectContext", 3);
        self.add("FsRtlRemovePerStreamContext", 3);
        self.add("FsRtlResetLargeMcb", 2);
        self.add("FsRtlSetEcpListIntoIrp", 2);
        self.add("FsRtlSetKernelEaFile", 3);
        self.add("FsRtlSetupAdvancedHeader", 2);
        self.add("FsRtlSplitLargeMcb", 3);
        self.add("FsRtlTeardownPerFileContexts", 1);
        self.add("FsRtlTeardownPerStreamContexts", 1);
        self.add("FsRtlTruncateLargeMcb", 2);
        self.add("FsRtlTruncateMcb", 2);
        self.add("FsRtlUninitializeBaseMcb", 1);
        self.add("FsRtlUninitializeFileLock", 1);
        self.add("FsRtlUninitializeLargeMcb", 1);
        self.add("FsRtlUninitializeMcb", 1);
        self.add("FsRtlUninitializeOplock", 1);
        self.add("FsRtlUpperOplockFsctrl", 5);
        self.add("FsRtlValidateReparsePointBuffer", 2);
        self.add("fstat", 2);
        self.add("fstat32", 2);
        self.add("fstat32i64", 2);
        self.add("fstat64", 2);
        self.add("fstat64i32", 2);
        self.add("fstati64", 2);
        self.add("FtAddFt", 2);
        self.add("ftell", 1);
        self.add("ftelli64", 1);
        self.add("ftelli64_nolock", 1);
        self.add("ftell_nolock", 1);
        self.add("FtgRegisterIdleRoutine", 5);
        self.add("ftime", 1);
        self.add("ftime32", 1);
        self.add("ftime32_s", 1);
        self.add("ftime64", 1);
        self.add("ftime64_s", 1);
        self.add("FtMulDw", 2);
        self.add("FtMulDwDw", 2);
        self.add("FtNegFt", 1);
        self.add("FtpCommand", 6);
        self.add("FtpCommandA", 6);
        self.add("FtpCommandW", 6);
        self.add("FtpCreateDirectory", 2);
        self.add("FtpCreateDirectoryA", 2);
        self.add("FtpCreateDirectoryW", 2);
        self.add("FtpDeleteFile", 2);
        self.add("FtpDeleteFileA", 2);
        self.add("FtpDeleteFileW", 2);
        self.add("FtpFindFirstFile", 5);
        self.add("FtpFindFirstFileA", 5);
        self.add("FtpFindFirstFileW", 5);
        self.add("FtpGetCurrentDirectory", 3);
        self.add("FtpGetCurrentDirectoryA", 3);
        self.add("FtpGetCurrentDirectoryW", 3);
        self.add("FtpGetFile", 7);
        self.add("FtpGetFileA", 7);
        self.add("FtpGetFileEx", 7);
        self.add("FtpGetFileSize", 2);
        self.add("FtpGetFileW", 7);
        self.add("FtpOpenFile", 5);
        self.add("FtpOpenFileA", 5);
        self.add("FtpOpenFileW", 5);
        self.add("FtpPutFile", 5);
        self.add("FtpPutFileA", 5);
        self.add("FtpPutFileEx", 5);
        self.add("FtpPutFileW", 5);
        self.add("FtpRemoveDirectory", 2);
        self.add("FtpRemoveDirectoryA", 2);
        self.add("FtpRemoveDirectoryW", 2);
        self.add("FtpRenameFile", 3);
        self.add("FtpRenameFileA", 3);
        self.add("FtpRenameFileW", 3);
        self.add("FtpSetCurrentDirectory", 2);
        self.add("FtpSetCurrentDirectoryA", 2);
        self.add("FtpSetCurrentDirectoryW", 2);
        self.add("FtSubFt", 2);
        self.add("fullpath", 3);
        self.add("fullpath_dbg", 6);
        self.add("futime", 2);
        self.add("futime32", 2);
        self.add("futime64", 2);
        self.add("fwprintf", 2);
        self.add("fwprintf_l", 3);
        self.add("fwprintf_p", 2);
        self.add("fwprintf_p_l", 3);
        self.add("fwprintf_s", 2);
        self.add("fwprintf_s_l", 3);
        self.add("fwrite", 4);
        self.add("fwrite_nolock", 4);
        self.add("fwscanf", 2);
        self.add("fwscanf_l", 3);
        self.add("fwscanf_s", 2);
        self.add("fwscanf_s_l", 3);
        self.add("gcvt", 3);
        self.add("gcvt_s", 4);
        self.add("GdiAlphaBlend", 11);
        self.add("GdiComment", 3);
        self.add("GdiFlush", 0);
        self.add("GdiFlush", 1);
        self.add("GdiGetBatchLimit", 0);
        self.add("GdiGetBatchLimit", 1);
        self.add("GdiGradientFill", 6);
        self.add("GdipAddPathArc", 7);
        self.add("GdipAddPathArcI", 7);
        self.add("GdipAddPathBezier", 9);
        self.add("GdipAddPathBezierI", 9);
        self.add("GdipAddPathBeziers", 3);
        self.add("GdipAddPathBeziersI", 3);
        self.add("GdipAddPathClosedCurve2", 4);
        self.add("GdipAddPathClosedCurve2I", 4);
        self.add("GdipAddPathClosedCurve", 3);
        self.add("GdipAddPathClosedCurveI", 3);
        self.add("GdipAddPathCurve2", 4);
        self.add("GdipAddPathCurve2I", 4);
        self.add("GdipAddPathCurve", 3);
        self.add("GdipAddPathCurve3", 6);
        self.add("GdipAddPathCurve3I", 6);
        self.add("GdipAddPathCurveI", 3);
        self.add("GdipAddPathEllipse", 5);
        self.add("GdipAddPathEllipseI", 5);
        self.add("GdipAddPathLine2", 3);
        self.add("GdipAddPathLine2I", 3);
        self.add("GdipAddPathLine", 5);
        self.add("GdipAddPathLineI", 5);
        self.add("GdipAddPathPath", 3);
        self.add("GdipAddPathPie", 7);
        self.add("GdipAddPathPieI", 7);
        self.add("GdipAddPathPolygon", 3);
        self.add("GdipAddPathPolygonI", 3);
        self.add("GdipAddPathRectangle", 5);
        self.add("GdipAddPathRectangleI", 5);
        self.add("GdipAddPathRectangles", 3);
        self.add("GdipAddPathRectanglesI", 3);
        self.add("GdipAddPathString", 8);
        self.add("GdipAddPathStringI", 8);
        self.add("GdipBeginContainer2", 2);
        self.add("GdipBeginContainer", 5);
        self.add("GdipBeginContainerI", 5);
        self.add("GdipBitmapApplyEffect", 6);
        self.add("GdipBitmapConvertFormat", 6);
        self.add("GdipBitmapCreateApplyEffect", 9);
        self.add("GdipBitmapGetHistogram", 7);
        self.add("GdipBitmapGetHistogramSize", 2);
        self.add("GdipBitmapGetPixel", 4);
        self.add("GdipBitmapLockBits", 5);
        self.add("GdipBitmapSetPixel", 4);
        self.add("GdipBitmapSetResolution", 3);
        self.add("GdipBitmapUnlockBits", 2);
        self.add("GdipClearPathMarkers", 1);
        self.add("GdipCloneBitmapArea", 7);
        self.add("GdipCloneBitmapAreaI", 7);
        self.add("GdipCloneBrush", 2);
        self.add("GdipCloneCustomLineCap", 2);
        self.add("GdipCloneFont", 2);
        self.add("GdipCloneFontFamily", 2);
        self.add("GdipCloneImage", 2);
        self.add("GdipCloneImageAttributes", 2);
        self.add("GdipCloneMatrix", 2);
        self.add("GdipClonePath", 2);
        self.add("GdipClonePen", 2);
        self.add("GdipCloneRegion", 2);
        self.add("GdipCloneStringFormat", 2);
        self.add("GdipClosePathFigure", 1);
        self.add("GdipClosePathFigures", 1);
        self.add("GdipCombineRegionPath", 3);
        self.add("GdipCombineRegionRect", 3);
        self.add("GdipCombineRegionRectI", 3);
        self.add("GdipCombineRegionRegion", 3);
        self.add("GdipComment", 3);
        self.add("GdipConvertToEmfPlus", 6);
        self.add("GdipConvertToEmfPlusToFile", 7);
        self.add("GdipConvertToEmfPlusToStream", 7);
        self.add("GdipCreateAdjustableArrowCap", 4);
        self.add("GdipCreateBitmapFromDirectDrawSurface", 2);
        self.add("GdipCreateBitmapFromFile", 2);
        self.add("GdipCreateBitmapFromFileICM", 2);
        self.add("GdipCreateBitmapFromGdiDib", 3);
        self.add("GdipCreateBitmapFromGraphics", 4);
        self.add("GdipCreateBitmapFromHBITMAP", 3);
        self.add("GdipCreateBitmapFromHICON", 2);
        self.add("GdipCreateBitmapFromResource", 3);
        self.add("GdipCreateBitmapFromScan0", 6);
        self.add("GdipCreateBitmapFromStream", 2);
        self.add("GdipCreateBitmapFromStreamICM", 2);
        self.add("GdipCreateCachedBitmap", 3);
        self.add("GdipCreateCustomLineCap", 5);
        self.add("GdipCreateFont", 5);
        self.add("GdipCreateFontFamilyFromName", 3);
        self.add("GdipCreateFontFromDC", 2);
        self.add("GdipCreateFontFromLogfont", 3);
        self.add("GdipCreateFromHDC", 2);
        self.add("GdipCreateFromHDC2", 3);
        self.add("GdipCreateFromHWND", 2);
        self.add("GdipCreateFromHWNDICM", 2);
        self.add("GdipCreateHalftonePalette", 0);
        self.add("GdipCreateHatchBrush", 4);
        self.add("GdipCreateHBITMAPFromBitmap", 3);
        self.add("GdipCreateHICONFromBitmap", 2);
        self.add("GdipCreateImageAttributes", 1);
        self.add("GdipCreateLineBrush", 6);
        self.add("GdipCreateLineBrushFromRect", 6);
        self.add("GdipCreateLineBrushFromRectI", 6);
        self.add("GdipCreateLineBrushFromRectWithAngle", 7);
        self.add("GdipCreateLineBrushFromRectWithAngleI", 7);
        self.add("GdipCreateLineBrushI", 6);
        self.add("GdipCreateMatrix", 1);
        self.add("GdipCreateMatrix2", 7);
        self.add("GdipCreateMatrix3", 3);
        self.add("GdipCreateMatrix3I", 3);
        self.add("GdipCreateMetafileFromEmf", 3);
        self.add("GdipCreateMetafileFromFile", 2);
        self.add("GdipCreateMetafileFromStream", 2);
        self.add("GdipCreateMetafileFromWmf", 4);
        self.add("GdipCreateMetafileFromWmfFile", 3);
        self.add("GdipCreatePath", 2);
        self.add("GdipCreatePath2", 5);
        self.add("GdipCreatePath2I", 5);
        self.add("GdipCreatePathGradient", 4);
        self.add("GdipCreatePathGradientFromPath", 2);
        self.add("GdipCreatePathGradientI", 4);
        self.add("GdipCreatePathIter", 2);
        self.add("GdipCreatePen1", 4);
        self.add("GdipCreatePen2", 4);
        self.add("GdipCreateRegion", 1);
        self.add("GdipCreateRegionHrgn", 2);
        self.add("GdipCreateRegionPath", 2);
        self.add("GdipCreateRegionRect", 2);
        self.add("GdipCreateRegionRectI", 2);
        self.add("GdipCreateRegionRgnData", 3);
        self.add("GdipCreateSolidFill", 2);
        self.add("GdipCreateStreamOnFile", 3);
        self.add("GdipCreateStringFormat", 3);
        self.add("GdipCreateTexture2", 7);
        self.add("GdipCreateTexture2I", 7);
        self.add("GdipCreateTexture", 3);
        self.add("GdipCreateTextureIA", 7);
        self.add("GdipCreateTextureIAI", 7);
        self.add("GdipDeleteBrush", 1);
        self.add("GdipDeleteCachedBitmap", 1);
        self.add("GdipDeleteCustomLineCap", 1);
        self.add("GdipDeleteFont", 1);
        self.add("GdipDeleteFontFamily", 1);
        self.add("GdipDeleteGraphics", 1);
        self.add("GdipDeleteMatrix", 1);
        self.add("GdipDeletePath", 1);
        self.add("GdipDeletePathIter", 1);
        self.add("GdipDeletePen", 1);
        self.add("GdipDeletePrivateFontCollection", 1);
        self.add("GdipDeleteRegion", 1);
        self.add("GdipDeleteStringFormat", 1);
        self.add("GdipDisposeImage", 1);
        self.add("GdipDisposeImageAttributes", 1);
        self.add("GdipDrawArc", 8);
        self.add("GdipDrawArcI", 8);
        self.add("GdipDrawBezier", 10);
        self.add("GdipDrawBezierI", 10);
        self.add("GdipDrawBeziers", 4);
        self.add("GdipDrawBeziersI", 4);
        self.add("GdipDrawCachedBitmap", 4);
        self.add("GdipDrawClosedCurve2", 5);
        self.add("GdipDrawClosedCurve2I", 5);
        self.add("GdipDrawClosedCurve", 4);
        self.add("GdipDrawClosedCurveI", 4);
        self.add("GdipDrawCurve2", 5);
        self.add("GdipDrawCurve2I", 5);
        self.add("GdipDrawCurve3", 7);
        self.add("GdipDrawCurve3I", 7);
        self.add("GdipDrawCurve", 4);
        self.add("GdipDrawCurveI", 4);
        self.add("GdipDrawDriverString", 8);
        self.add("GdipDrawEllipse", 6);
        self.add("GdipDrawEllipseI", 6);
        self.add("GdipDrawImage", 4);
        self.add("GdipDrawImageFX", 7);
        self.add("GdipDrawImageI", 4);
        self.add("GdipDrawImagePointRect", 9);
        self.add("GdipDrawImagePointRectI", 9);
        self.add("GdipDrawImagePoints", 4);
        self.add("GdipDrawImagePointsI", 4);
        self.add("GdipDrawImagePointsRect", 12);
        self.add("GdipDrawImagePointsRectI", 12);
        self.add("GdipDrawImageRect", 6);
        self.add("GdipDrawImageRectI", 6);
        self.add("GdipDrawImageRectRect", 14);
        self.add("GdipDrawImageRectRectI", 14);
        self.add("GdipDrawLine", 6);
        self.add("GdipDrawLineI", 6);
        self.add("GdipDrawLines", 4);
        self.add("GdipDrawLinesI", 4);
        self.add("GdipDrawPath", 3);
        self.add("GdipDrawPie", 8);
        self.add("GdipDrawPieI", 8);
        self.add("GdipDrawPolygon", 4);
        self.add("GdipDrawPolygonI", 4);
        self.add("GdipDrawRectangle", 6);
        self.add("GdipDrawRectangleI", 6);
        self.add("GdipDrawRectangles", 4);
        self.add("GdipDrawRectanglesI", 4);
        self.add("GdipDrawString", 7);
        self.add("GdipEmfToWmfBits", 5);
        self.add("GdipEndContainer", 2);
        self.add("GdipEnumerateMetafileDestPoint", 5);
        self.add("GdipEnumerateMetafileDestPointI", 5);
        self.add("GdipEnumerateMetafileDestPoints", 7);
        self.add("GdipEnumerateMetafileDestPointsI", 7);
        self.add("GdipEnumerateMetafileDestRect", 5);
        self.add("GdipEnumerateMetafileDestRectI", 5);
        self.add("GdipEnumerateMetafileSrcRectDestPoint", 6);
        self.add("GdipEnumerateMetafileSrcRectDestPointI", 6);
        self.add("GdipEnumerateMetafileSrcRectDestPoints", 8);
        self.add("GdipEnumerateMetafileSrcRectDestPointsI", 8);
        self.add("GdipEnumerateMetafileSrcRectDestRect", 6);
        self.add("GdipEnumerateMetafileSrcRectDestRectI", 6);
        self.add("GdipFillClosedCurve2", 6);
        self.add("GdipFillClosedCurve2I", 6);
        self.add("GdipFillClosedCurve", 4);
        self.add("GdipFillClosedCurveI", 4);
        self.add("GdipFillEllipse", 6);
        self.add("GdipFillEllipseI", 6);
        self.add("GdipFillPath", 3);
        self.add("GdipFillPie", 8);
        self.add("GdipFillPieI", 8);
        self.add("GdipFillPolygon2", 4);
        self.add("GdipFillPolygon2I", 4);
        self.add("GdipFillPolygon", 5);
        self.add("GdipFillPolygonI", 5);
        self.add("GdipFillRectangle", 6);
        self.add("GdipFillRectangleI", 6);
        self.add("GdipFillRectangles", 4);
        self.add("GdipFillRectanglesI", 4);
        self.add("GdipFillRegion", 3);
        self.add("GdipFindFirstImageItem", 2);
        self.add("GdipFindNextImageItem", 2);
        self.add("GdipFlattenPath", 3);
        self.add("GdipFlush", 2);
        self.add("GdipFontCollectionEnumerable", 3);
        self.add("GdipFontCollectionEnumerate", 5);
        self.add("GdipGetAdjustableArrowCapFillState", 2);
        self.add("GdipGetAdjustableArrowCapHeight", 2);
        self.add("GdipGetAdjustableArrowCapMiddleInset", 2);
        self.add("GdipGetAdjustableArrowCapWidth", 2);
        self.add("GdipGetAllPropertyItems", 4);
        self.add("GdipGetBrushType", 2);
        self.add("GdipGetCellAscent", 3);
        self.add("GdipGetCellDescent", 3);
        self.add("GdipGetClip", 2);
        self.add("GdipGetClipBounds", 2);
        self.add("GdipGetClipBoundsI", 2);
        self.add("GdipGetCompositingMode", 2);
        self.add("GdipGetCompositingQuality", 2);
        self.add("GdipGetCustomLineCapBaseCap", 2);
        self.add("GdipGetCustomLineCapBaseInset", 2);
        self.add("GdipGetCustomLineCapStrokeCaps", 3);
        self.add("GdipGetCustomLineCapStrokeJoin", 2);
        self.add("GdipGetCustomLineCapType", 2);
        self.add("GdipGetCustomLineCapWidthScale", 2);
        self.add("GdipGetDC", 2);
        self.add("GdipGetDpiX", 2);
        self.add("GdipGetDpiY", 2);
        self.add("GdipGetEmHeight", 3);
        self.add("GdipGetEncoderParameterList", 4);
        self.add("GdipGetEncoderParameterListSize", 3);
        self.add("GdipGetFamily", 2);
        self.add("GdipGetFamilyName", 3);
        self.add("GdipGetFontCollectionFamilyCount", 2);
        self.add("GdipGetFontCollectionFamilyList", 4);
        self.add("GdipGetFontHeight", 3);
        self.add("GdipGetFontHeightGivenDPI", 3);
        self.add("GdipGetFontSize", 2);
        self.add("GdipGetFontStyle", 2);
        self.add("GdipGetFontUnit", 2);
        self.add("GdipGetGenericFontFamilyMonospace", 1);
        self.add("GdipGetGenericFontFamilySansSerif", 1);
        self.add("GdipGetGenericFontFamilySerif", 1);
        self.add("GdipGetHatchBackgroundColor", 2);
        self.add("GdipGetHatchForegroundColor", 2);
        self.add("GdipGetHatchStyle", 2);
        self.add("GdipGetHemfFromMetafile", 2);
        self.add("GdipGetImageAttributesAdjustedPalette", 3);
        self.add("GdipGetImageBounds", 3);
        self.add("GdipGetImageDecoders", 3);
        self.add("GdipGetImageDecodersSize", 2);
        self.add("GdipGetImageDimension", 3);
        self.add("GdipGetImageEncoders", 3);
        self.add("GdipGetImageEncodersSize", 2);
        self.add("GdipGetImageFlags", 2);
        self.add("GdipGetImageGraphicsContext", 2);
        self.add("GdipGetImageHeight", 2);
        self.add("GdipGetImageHorizontalResolution", 2);
        self.add("GdipGetImageItemData", 2);
        self.add("GdipGetImagePalette", 3);
        self.add("GdipGetImagePaletteSize", 2);
        self.add("GdipGetImagePixelFormat", 2);
        self.add("GdipGetImageRawFormat", 2);
        self.add("GdipGetImageThumbnail", 6);
        self.add("GdipGetImageType", 2);
        self.add("GdipGetImageVerticalResolution", 2);
        self.add("GdipGetImageWidth", 2);
        self.add("GdipGetInterpolationMode", 2);
        self.add("GdipGetLineBlend", 4);
        self.add("GdipGetLineBlendCount", 2);
        self.add("GdipGetLineColors", 2);
        self.add("GdipGetLineGammaCorrection", 2);
        self.add("GdipGetLinePresetBlend", 4);
        self.add("GdipGetLinePresetBlendCount", 2);
        self.add("GdipGetLineRect", 2);
        self.add("GdipGetLineRectI", 2);
        self.add("GdipGetLineSpacing", 3);
        self.add("GdipGetLineTransform", 2);
        self.add("GdipGetLineWrapMode", 2);
        self.add("GdipGetLogFont", 3);
        self.add("GdipGetMatrixElements", 2);
        self.add("GdipGetMetafileDownLevelRasterizationLimit", 2);
        self.add("GdipGetMetafileHeaderFromEmf", 2);
        self.add("GdipGetMetafileHeaderFromFile", 2);
        self.add("GdipGetMetafileHeaderFromMetafile", 2);
        self.add("GdipGetMetafileHeaderFromStream", 2);
        self.add("GdipGetMetafileHeaderFromWmf", 3);
        self.add("GdipGetNearestColor", 2);
        self.add("GdipGetPageScale", 2);
        self.add("GdipGetPageUnit", 2);
        self.add("GdipGetPathData", 2);
        self.add("GdipGetPathFillMode", 2);
        self.add("GdipGetPathGradientBlend", 4);
        self.add("GdipGetPathGradientBlendCount", 2);
        self.add("GdipGetPathGradientCenterColor", 2);
        self.add("GdipGetPathGradientCenterPoint", 2);
        self.add("GdipGetPathGradientCenterPointI", 2);
        self.add("GdipGetPathGradientFocusScales", 3);
        self.add("GdipGetPathGradientGammaCorrection", 2);
        self.add("GdipGetPathGradientPath", 2);
        self.add("GdipGetPathGradientPointCount", 2);
        self.add("GdipGetPathGradientPresetBlend", 4);
        self.add("GdipGetPathGradientPresetBlendCount", 2);
        self.add("GdipGetPathGradientRect", 2);
        self.add("GdipGetPathGradientRectI", 2);
        self.add("GdipGetPathGradientSurroundColorCount", 2);
        self.add("GdipGetPathGradientSurroundColorsWithCount", 3);
        self.add("GdipGetPathGradientTransform", 2);
        self.add("GdipGetPathGradientWrapMode", 2);
        self.add("GdipGetPathLastPoint", 2);
        self.add("GdipGetPathPoints", 3);
        self.add("GdipGetPathPointsI", 3);
        self.add("GdipGetPathTypes", 3);
        self.add("GdipGetPathWorldBounds", 4);
        self.add("GdipGetPathWorldBoundsI", 4);
        self.add("GdipGetPenBrushFill", 2);
        self.add("GdipGetPenColor", 2);
        self.add("GdipGetPenCompoundArray", 3);
        self.add("GdipGetPenCompoundCount", 2);
        self.add("GdipGetPenCustomEndCap", 2);
        self.add("GdipGetPenCustomStartCap", 2);
        self.add("GdipGetPenDashArray", 3);
        self.add("GdipGetPenDashCap197819", 2);
        self.add("GdipGetPenDashCount", 2);
        self.add("GdipGetPenDashOffset", 2);
        self.add("GdipGetPenDashStyle", 2);
        self.add("GdipGetPenEndCap", 2);
        self.add("GdipGetPenFillType", 2);
        self.add("GdipGetPenLineJoin", 2);
        self.add("GdipGetPenMiterLimit", 2);
        self.add("GdipGetPenMode", 2);
        self.add("GdipGetPenStartCap", 2);
        self.add("GdipGetPenTransform", 2);
        self.add("GdipGetPenUnit", 2);
        self.add("GdipGetPenWidth", 2);
        self.add("GdipGetPixelOffsetMode", 2);
        self.add("GdipGetPointCount", 2);
        self.add("GdipGetPropertyCount", 2);
        self.add("GdipGetPropertyIdList", 3);
        self.add("GdipGetPropertyItem", 3);
        self.add("GdipGetPropertyItemSize", 3);
        self.add("GdipGetPropertySize", 3);
        self.add("GdipGetRegionBounds", 3);
        self.add("GdipGetRegionBoundsI", 3);
        self.add("GdipGetRegionData", 4);
        self.add("GdipGetRegionDataSize", 2);
        self.add("GdipGetRegionHRgn", 3);
        self.add("GdipGetRegionScans", 4);
        self.add("GdipGetRegionScansCount", 3);
        self.add("GdipGetRegionScansI", 4);
        self.add("GdipGetRenderingOrigin", 3);
        self.add("GdipGetSmoothingMode", 2);
        self.add("GdipGetSolidFillColor", 2);
        self.add("GdipGetStringFormatAlign", 2);
        self.add("GdipGetStringFormatDigitSubstitution", 3);
        self.add("GdipGetStringFormatFlags", 2);
        self.add("GdipGetStringFormatHotkeyPrefix", 2);
        self.add("GdipGetStringFormatLineAlign", 2);
        self.add("GdipGetStringFormatMeasurableCharacterRangeCount", 2);
        self.add("GdipGetStringFormatTabStopCount", 2);
        self.add("GdipGetStringFormatTabStops", 4);
        self.add("GdipGetStringFormatTrimming", 2);
        self.add("GdipGetTextContrast", 2);
        self.add("GdipGetTextRenderingHint", 2);
        self.add("GdipGetTextureImage", 2);
        self.add("GdipGetTextureTransform", 2);
        self.add("GdipGetTextureWrapMode", 2);
        self.add("GdipGetVisibleClipBounds", 2);
        self.add("GdipGetVisibleClipBoundsI", 2);
        self.add("GdipGetWorldTransform", 2);
        self.add("GdipGraphicsClear", 2);
        self.add("GdipGraphicsSetAbort", 2);
        self.add("GdipImageForceValidation", 1);
        self.add("GdipImageGetFrameCount", 3);
        self.add("GdipImageGetFrameDimensionsCount", 2);
        self.add("GdipImageGetFrameDimensionsList", 3);
        self.add("GdipImageRotateFlip", 2);
        self.add("GdipImageSelectActiveFrame", 3);
        self.add("GdipImageSetAbort", 2);
        self.add("GdipInitializePalette", 5);
        self.add("GdipInvertMatrix", 1);
        self.add("GdipIsClipEmpty", 2);
        self.add("GdipIsEmptyRegion", 3);
        self.add("GdipIsEqualRegion", 4);
        self.add("GdipIsInfiniteRegion", 3);
        self.add("GdipIsMatrixEqual", 3);
        self.add("GdipIsMatrixIdentity", 2);
        self.add("GdipIsMatrixInvertible", 2);
        self.add("GdipIsOutlineVisiblePathPoint", 6);
        self.add("GdipIsOutlineVisiblePathPointI", 6);
        self.add("GdipIsStyleAvailable", 3);
        self.add("GdipIsVisibleClipEmpty", 2);
        self.add("GdipIsVisiblePathPoint", 5);
        self.add("GdipIsVisiblePathPointI", 5);
        self.add("GdipIsVisiblePoint", 4);
        self.add("GdipIsVisiblePointI", 4);
        self.add("GdipIsVisibleRect", 6);
        self.add("GdipIsVisibleRectI", 6);
        self.add("GdipIsVisibleRegionPoint", 5);
        self.add("GdipIsVisibleRegionPointI", 5);
        self.add("GdipIsVisibleRegionRect", 7);
        self.add("GdipIsVisibleRegionRectI", 7);
        self.add("GdipLoadImageFromFile", 2);
        self.add("GdipLoadImageFromFileICM", 2);
        self.add("GdipLoadImageFromStream", 2);
        self.add("GdipLoadImageFromStreamICM", 2);
        self.add("GdiplusNotificationHook", 1);
        self.add("GdiplusNotificationUnhook", 1);
        self.add("GdiplusShutdown", 1);
        self.add("GdiplusStartup", 3);
        self.add("GdipMeasureCharacterRanges", 7);
        self.add("GdipMeasureDriverString", 8);
        self.add("GdipMeasureString", 9);
        self.add("GdipMultiplyLineTransform", 3);
        self.add("GdipMultiplyMatrix", 3);
        self.add("GdipMultiplyPathGradientTransform", 3);
        self.add("GdipMultiplyPenTransform", 3);
        self.add("GdipMultiplyTextureTransform", 3);
        self.add("GdipMultiplyWorldTransform", 3);
        self.add("GdipNewInstalledFontCollection", 1);
        self.add("GdipNewPrivateFontCollection", 1);
        self.add("GdipPathIterCopyData", 6);
        self.add("GdipPathIterEnumerate", 5);
        self.add("GdipPathIterGetCount", 2);
        self.add("GdipPathIterGetSubpathCount", 2);
        self.add("GdipPathIterHasCurve", 2);
        self.add("GdipPathIterIsValid", 2);
        self.add("GdipPathIterNextMarker", 4);
        self.add("GdipPathIterNextMarkerPath", 3);
        self.add("GdipPathIterNextPathType", 5);
        self.add("GdipPathIterNextSubpath", 5);
        self.add("GdipPathIterNextSubpathPath", 4);
        self.add("GdipPathIterRewind", 1);
        self.add("GdipPlayMetafileRecord", 5);
        self.add("GdipPrivateAddFontFile", 2);
        self.add("GdipPrivateAddMemoryFont", 3);
        self.add("GdipRecordMetafile", 6);
        self.add("GdipRecordMetafileFileName", 7);
        self.add("GdipRecordMetafileFileNameI", 7);
        self.add("GdipRecordMetafileI", 6);
        self.add("GdipRecordMetafileStream", 7);
        self.add("GdipRecordMetafileStreamI", 7);
        self.add("GdipReleaseDC", 2);
        self.add("GdipRemovePropertyItem", 2);
        self.add("GdipResetClip", 1);
        self.add("GdipResetImageAttributes", 2);
        self.add("GdipResetLineTransform", 1);
        self.add("GdipResetPageTransform", 1);
        self.add("GdipResetPath", 1);
        self.add("GdipResetPathGradientTransform", 1);
        self.add("GdipResetPenTransform", 1);
        self.add("GdipResetTextureTransform", 1);
        self.add("GdipResetWorldTransform", 1);
        self.add("GdipRestoreGraphics", 2);
        self.add("GdipReversePath", 1);
        self.add("GdipRotateLineTransform", 3);
        self.add("GdipRotateMatrix", 3);
        self.add("GdipRotatePathGradientTransform", 3);
        self.add("GdipRotatePenTransform", 3);
        self.add("GdipRotateTextureTransform", 3);
        self.add("GdipRotateWorldTransform", 3);
        self.add("GdipSaveAdd", 2);
        self.add("GdipSaveAddImage", 3);
        self.add("GdipSaveGraphics", 2);
        self.add("GdipSaveImageToFile", 4);
        self.add("GdipSaveImageToStream", 4);
        self.add("GdipScaleLineTransform", 4);
        self.add("GdipScaleMatrix", 4);
        self.add("GdipScalePathGradientTransform", 4);
        self.add("GdipScalePenTransform", 4);
        self.add("GdipScaleTextureTransform", 4);
        self.add("GdipScaleWorldTransform", 4);
        self.add("GdipSetAdjustableArrowCapFillState", 2);
        self.add("GdipSetAdjustableArrowCapHeight", 2);
        self.add("GdipSetAdjustableArrowCapMiddleInset", 2);
        self.add("GdipSetAdjustableArrowCapWidth", 2);
        self.add("GdipSetClipGraphics", 3);
        self.add("GdipSetClipHrgn", 3);
        self.add("GdipSetClipPath", 3);
        self.add("GdipSetClipRect", 6);
        self.add("GdipSetClipRectI", 6);
        self.add("GdipSetClipRegion", 3);
        self.add("GdipSetCompositingMode", 2);
        self.add("GdipSetCompositingQuality", 2);
        self.add("GdipSetCustomLineCapBaseCap", 2);
        self.add("GdipSetCustomLineCapBaseInset", 2);
        self.add("GdipSetCustomLineCapStrokeCaps", 3);
        self.add("GdipSetCustomLineCapStrokeJoin", 2);
        self.add("GdipSetCustomLineCapWidthScale", 2);
        self.add("GdipSetEmpty", 1);
        self.add("GdipSetImageAttributesCachedBackground", 2);
        self.add("GdipSetImageAttributesColorKeys", 5);
        self.add("GdipSetImageAttributesColorMatrix", 6);
        self.add("GdipSetImageAttributesGamma", 4);
        self.add("GdipSetImageAttributesICMMode", 2);
        self.add("GdipSetImageAttributesNoOp", 3);
        self.add("GdipSetImageAttributesOutputChannel", 4);
        self.add("GdipSetImageAttributesOutputChannelColorProfile", 4);
        self.add("GdipSetImageAttributesRemapTable", 5);
        self.add("GdipSetImageAttributesThreshold", 4);
        self.add("GdipSetImageAttributesToIdentity", 2);
        self.add("GdipSetImageAttributesWrapMode", 4);
        self.add("GdipSetImagePalette", 2);
        self.add("GdipSetInfinite", 1);
        self.add("GdipSetInterpolationMode", 2);
        self.add("GdipSetLineBlend", 4);
        self.add("GdipSetLineColors", 3);
        self.add("GdipSetLineGammaCorrection", 2);
        self.add("GdipSetLineLinearBlend", 3);
        self.add("GdipSetLinePresetBlend", 4);
        self.add("GdipSetLineSigmaBlend", 3);
        self.add("GdipSetLineTransform", 2);
        self.add("GdipSetLineWrapMode", 2);
        self.add("GdipSetMatrixElements", 7);
        self.add("GdipSetMetafileDownLevelRasterizationLimit", 2);
        self.add("GdipSetPageScale", 2);
        self.add("GdipSetPageUnit", 2);
        self.add("GdipSetPathFillMode", 2);
        self.add("GdipSetPathGradientBlend", 4);
        self.add("GdipSetPathGradientCenterColor", 2);
        self.add("GdipSetPathGradientCenterPoint", 2);
        self.add("GdipSetPathGradientCenterPointI", 2);
        self.add("GdipSetPathGradientFocusScales", 3);
        self.add("GdipSetPathGradientGammaCorrection", 2);
        self.add("GdipSetPathGradientLinearBlend", 3);
        self.add("GdipSetPathGradientPath", 2);
        self.add("GdipSetPathGradientPresetBlend", 4);
        self.add("GdipSetPathGradientSigmaBlend", 3);
        self.add("GdipSetPathGradientSurroundColorsWithCount", 3);
        self.add("GdipSetPathGradientTransform", 2);
        self.add("GdipSetPathGradientWrapMode", 2);
        self.add("GdipSetPathMarker", 1);
        self.add("GdipSetPenBrushFill", 2);
        self.add("GdipSetPenColor", 2);
        self.add("GdipSetPenCompoundArray", 3);
        self.add("GdipSetPenCustomEndCap", 2);
        self.add("GdipSetPenCustomStartCap", 2);
        self.add("GdipSetPenDashArray", 3);
        self.add("GdipSetPenDashCap197819", 2);
        self.add("GdipSetPenDashOffset", 2);
        self.add("GdipSetPenDashStyle", 2);
        self.add("GdipSetPenEndCap", 2);
        self.add("GdipSetPenLineCap197819", 4);
        self.add("GdipSetPenLineJoin", 2);
        self.add("GdipSetPenMiterLimit", 2);
        self.add("GdipSetPenMode", 2);
        self.add("GdipSetPenStartCap", 2);
        self.add("GdipSetPenTransform", 2);
        self.add("GdipSetPenUnit", 2);
        self.add("GdipSetPenWidth", 2);
        self.add("GdipSetPixelOffsetMode", 2);
        self.add("GdipSetPropertyItem", 2);
        self.add("GdipSetRenderingOrigin", 3);
        self.add("GdipSetSmoothingMode", 2);
        self.add("GdipSetSolidFillColor", 2);
        self.add("GdipSetStringFormatAlign", 2);
        self.add("GdipSetStringFormatDigitSubstitution", 3);
        self.add("GdipSetStringFormatFlags", 2);
        self.add("GdipSetStringFormatHotkeyPrefix", 2);
        self.add("GdipSetStringFormatLineAlign", 2);
        self.add("GdipSetStringFormatMeasurableCharacterRanges", 3);
        self.add("GdipSetStringFormatTabStops", 4);
        self.add("GdipSetStringFormatTrimming", 2);
        self.add("GdipSetTextContrast", 2);
        self.add("GdipSetTextRenderingHint", 2);
        self.add("GdipSetTextureTransform", 2);
        self.add("GdipSetTextureWrapMode", 2);
        self.add("GdipSetWorldTransform", 2);
        self.add("GdipShearMatrix", 4);
        self.add("GdipStartPathFigure", 1);
        self.add("GdipStringFormatGetGenericDefault", 1);
        self.add("GdipStringFormatGetGenericTypographic", 1);
        self.add("GdipTestControl", 2);
        self.add("GdipTransformMatrixPoints", 3);
        self.add("GdipTransformMatrixPointsI", 3);
        self.add("GdipTransformPath", 2);
        self.add("GdipTransformPoints", 5);
        self.add("GdipTransformPointsI", 5);
        self.add("GdipTransformRegion", 2);
        self.add("GdipTranslateClip", 3);
        self.add("GdipTranslateClipI", 3);
        self.add("GdipTranslateLineTransform", 4);
        self.add("GdipTranslateMatrix", 4);
        self.add("GdipTranslatePathGradientTransform", 4);
        self.add("GdipTranslatePenTransform", 4);
        self.add("GdipTranslateRegion", 3);
        self.add("GdipTranslateRegionI", 3);
        self.add("GdipTranslateTextureTransform", 4);
        self.add("GdipTranslateWorldTransform", 4);
        self.add("GdipVectorTransformMatrixPoints", 3);
        self.add("GdipVectorTransformMatrixPointsI", 3);
        self.add("GdipWarpPath", 10);
        self.add("GdipWidenPath", 4);
        self.add("GdipWindingModeOutline", 3);
        self.add("GdiSetBatchLimit", 1);
        self.add("GdiTransparentBlt", 11);
        self.add("GenerateConsoleCtrlEvent", 2);
        self.add("GetAcceptExSockaddrs", 8);
        self.add("GetAcceptLanguages", 2);
        self.add("GetAcceptLanguagesA", 2);
        self.add("GetAcceptLanguagesW", 2);
        self.add("GetAce", 3);
        self.add("GetAclInformation", 4);
        self.add("GetACP", 0);
        self.add("GetActiveObject", 3);
        self.add("GetActiveProcessorCount", 1);
        self.add("GetActiveProcessorGroupCount", 0);
        self.add("GetActivePwrScheme", 1);
        self.add("GetActiveWindow", 0);
        self.add("GetAdapterIndex", 2);
        self.add("GetAdapterOrderMap", 0);
        self.add("GetAdaptersAddresses", 5);
        self.add("GetAdaptersInfo", 2);
        self.add("GetAddressByName", 10);
        self.add("getaddrinfo", 4);
        self.add("GetAddrInfoEx", 10);
        self.add("GetAddrInfoExCancel", 1);
        self.add("GetAddrInfoExOverlappedResult", 1);
        self.add("GetAddrInfoW", 4);
        self.add("GetAllUsersProfileDirectory", 2);
        self.add("GetAltMonthNames", 2);
        self.add("GetAltTabInfo", 5);
        self.add("GetAltTabInfoA", 5);
        self.add("GetAltTabInfoW", 5);
        self.add("get_amblksiz", 1);
        self.add("GetAncestor", 2);
        self.add("GetAnycastIpAddressEntry", 1);
        self.add("GetAnycastIpAddressTable", 2);
        self.add("GetAppContainerFolderPath", 2);
        self.add("GetAppContainerNamedObjectPath", 5);
        self.add("GetAppContainerRegistryLocation", 2);
        self.add("GetApplicationRecoveryCallback", 5);
        self.add("GetApplicationRestartSettings", 4);
        self.add("GetApplicationUserModelId", 3);
        self.add("GetAppliedGPOList", 5);
        self.add("GetAppPathFromLink", 3);
        self.add("GetArcDirection", 1);
        self.add("GetAspectRatioFilterEx", 2);
        self.add("GetAsyncKeyState", 1);
        self.add("GetAtomName", 3);
        self.add("GetAttribIMsgOnIStg", 3);
        self.add("GetAuditedPermissionsFromAcl", 4);
        self.add("GetBestInterface", 2);
        self.add("GetBestInterfaceEx", 2);
        self.add("GetBestRoute2", 7);
        self.add("GetBestRoute", 3);
        self.add("GetBinaryType", 2);
        self.add("GetBitmapBits", 3);
        self.add("GetBitmapDimensionEx", 2);
        self.add("GetBkColor", 1);
        self.add("GetBkMode", 1);
        self.add("GetBoundsRect", 3);
        self.add("GetBrushOrgEx", 2);
        self.add("GetBufferedPaintBits", 3);
        self.add("GetBufferedPaintDC", 1);
        self.add("GetBufferedPaintTargetDC", 1);
        self.add("GetBufferedPaintTargetRect", 2);
        self.add("getc", 1);
        self.add("GetCalendarDateFormatEx", 6);
        self.add("GetCalendarInfo", 6);
        self.add("GetCalendarInfoEx", 7);
        self.add("GetCalendarSupportedDateRange", 3);
        self.add("GetCapabilitiesStringLength", 2);
        self.add("GetCapture", 0);
        self.add("GetCaretBlinkTime", 0);
        self.add("GetCaretPos", 1);
        self.add("getch", 0);
        self.add("getchar", 0);
        self.add("GetCharABCWidths", 4);
        self.add("GetCharABCWidthsA", 4);
        self.add("GetCharABCWidthsFloat", 4);
        self.add("GetCharABCWidthsFloatA", 4);
        self.add("GetCharABCWidthsFloatW", 4);
        self.add("GetCharABCWidthsI", 5);
        self.add("GetCharABCWidthsW", 4);
        self.add("GetCharacterPlacement", 6);
        self.add("GetCharacterPlacementA", 6);
        self.add("GetCharacterPlacementW", 6);
        self.add("GetCharWidth32", 4);
        self.add("GetCharWidth32A", 4);
        self.add("GetCharWidth32W", 4);
        self.add("GetCharWidth", 4);
        self.add("GetCharWidthA", 4);
        self.add("GetCharWidthFloat", 4);
        self.add("GetCharWidthFloatA", 4);
        self.add("GetCharWidthFloatW", 4);
        self.add("GetCharWidthI", 5);
        self.add("GetCharWidthW", 4);
        self.add("getche", 0);
        self.add("getche_nolock", 0);
        self.add("getch_nolock", 0);
        self.add("GetCIMSSM", 1);
        self.add("GetClassFile", 2);
        self.add("GetClassFileOrMime", 7);
        self.add("GetClassInfo", 3);
        self.add("GetClassInfoA", 3);
        self.add("GetClassInfoEx", 3);
        self.add("GetClassInfoExA", 3);
        self.add("GetClassInfoExW", 3);
        self.add("GetClassInfoW", 3);
        self.add("GetClassLong", 2);
        self.add("GetClassLongA", 2);
        self.add("GetClassLongPtrA", 2);
        self.add("GetClassLongPtrW", 2);
        self.add("GetClassLongW", 2);
        self.add("GetClassName", 3);
        self.add("GetClassNameA", 3);
        self.add("GetClassNameW", 3);
        self.add("GetClassURL", 2);
        self.add("GetClassWord", 2);
        self.add("GetClientRect", 2);
        self.add("GetClipboardData", 1);
        self.add("GetClipboardFormatName", 3);
        self.add("GetClipboardOwner", 0);
        self.add("GetClipboardSequenceNumber", 0);
        self.add("GetClipboardViewer", 0);
        self.add("GetClipBox", 2);
        self.add("GetClipCursor", 1);
        self.add("GetClipRgn", 2);
        self.add("GetCMMInfo", 2);
        self.add("getc_nolock", 1);
        self.add("GetColorAdjustment", 2);
        self.add("GetColorDirectory", 3);
        self.add("GetColorProfileElement", 6);
        self.add("GetColorProfileElementTag", 3);
        self.add("GetColorProfileFromHandle", 3);
        self.add("GetColorProfileHeader", 2);
        self.add("GetColorSpace", 1);
        self.add("GetComboBoxInfo", 2);
        self.add("GetCommandLine", 0);
        self.add("GetCommConfig", 3);
        self.add("GetCommMask", 2);
        self.add("GetCommModemStatus", 2);
        self.add("GetCommProperties", 2);
        self.add("GetCommState", 2);
        self.add("GetCommTimeouts", 2);
        self.add("GetComponentIDFromCLSSPEC", 2);
        self.add("GetCompressedFileSize", 2);
        self.add("GetCompressedFileSizeA", 2);
        self.add("GetCompressedFileSizeTransacted", 3);
        self.add("GetCompressedFileSizeW", 2);
        self.add("GetComputerName", 2);
        self.add("GetComputerNameEx", 3);
        self.add("GetComputerObjectName", 3);
        self.add("GetConsoleAlias", 4);
        self.add("GetConsoleAliases", 3);
        self.add("GetConsoleAliasesLength", 1);
        self.add("GetConsoleAliasExes", 2);
        self.add("GetConsoleAliasExesLength", 0);
        self.add("GetConsoleCP", 0);
        self.add("GetConsoleCursorInfo", 2);
        self.add("GetConsoleDisplayMode", 1);
        self.add("GetConsoleFontSize", 2);
        self.add("GetConsoleHistoryInfo", 1);
        self.add("GetConsoleMode", 2);
        self.add("GetConsoleOriginalTitle", 2);
        self.add("GetConsoleOutputCP", 0);
        self.add("GetConsoleProcessList", 2);
        self.add("GetConsoleScreenBufferInfo", 2);
        self.add("GetConsoleScreenBufferInfoEx", 2);
        self.add("GetConsoleSelectionInfo", 1);
        self.add("GetConsoleTitle", 2);
        self.add("GetConsoleWindow", 0);
        self.add("GetConvertStg", 1);
        self.add("GetCorePrinterDrivers", 5);
        self.add("GetCountColorProfileElements", 2);
        self.add("GetCPInfo", 2);
        self.add("GetCPInfoEx", 3);
        self.add("GetCrossSlideParameterInteractionContext", 3);
        self.add("GetCryptProvFromCert", 8);
        self.add("GetCurrencyFormat", 6);
        self.add("GetCurrencyFormatEx", 6);
        self.add("GetCurrentActCtx", 1);
        self.add("GetCurrentApplicationUserModelId", 2);
        self.add("GetCurrentClockTransactionManager", 2);
        self.add("GetCurrentConsoleFont", 3);
        self.add("GetCurrentConsoleFontEx", 3);
        self.add("GetCurrentDirectory", 2);
        self.add("GetCurrentHwProfile", 1);
        self.add("GetCurrentInputMessageSource", 1);
        self.add("get_current_locale", 0);
        self.add("GetCurrentObject", 2);
        self.add("GetCurrentPackageFamilyName", 2);
        self.add("GetCurrentPackageFullName", 2);
        self.add("GetCurrentPackageId", 2);
        self.add("GetCurrentPackageInfo", 4);
        self.add("GetCurrentPackagePath", 2);
        self.add("GetCurrentPositionEx", 2);
        self.add("GetCurrentPowerPolicies", 2);
        self.add("GetCurrentProcess", 0);
        self.add("GetCurrentProcess", 1);
        self.add("GetCurrentProcessExplicitAppUserModelID", 1);
        self.add("GetCurrentProcessId", 0);
        self.add("GetCurrentProcessId", 1);
        self.add("GetCurrentProcessorNumber", 0);
        self.add("GetCurrentProcessorNumber", 1);
        self.add("GetCurrentProcessorNumberEx", 1);
        self.add("GetCurrentThemeName", 6);
        self.add("GetCurrentThread", 0);
        self.add("GetCurrentThread", 1);
        self.add("GetCurrentThreadId", 0);
        self.add("GetCurrentThreadId", 1);
        self.add("GetCurrentThreadStackLimits", 2);
        self.add("GetCurrentUmsThread", 0);
        self.add("GetCursor", 0);
        self.add("GetCursorInfo", 1);
        self.add("GetCursorPos", 1);
        self.add("getcwd", 2);
        self.add("getcwd_dbg", 5);
        self.add("GetD3coldCapability", 2);
        self.add("GetD3coldLastTransitionStatus", 2);
        self.add("GetDateFormat", 6);
        self.add("GetDateFormatEx", 7);
        self.add("GetDateFormatWrapW", 6);
        self.add("get_daylight", 1);
        self.add("GetDC", 1);
        self.add("GetDCBrushColor", 1);
        self.add("GetDCEx", 3);
        self.add("GetDCOrgEx", 2);
        self.add("GetDCPenColor", 1);
        self.add("getdcwd", 3);
        self.add("getdcwd_dbg", 6);
        self.add("getdcwd_nolock", 3);
        self.add("GetDefaultCommConfig", 3);
        self.add("GetDefaultPrinter", 2);
        self.add("GetDefaultUserProfileDirectory", 2);
        self.add("GetDesktopWindow", 0);
        self.add("GetDesktopWindow", 1);
        self.add("GetDeviceCaps", 2);
        self.add("GetDeviceDriverBaseName", 3);
        self.add("GetDeviceDriverFileName", 3);
        self.add("GetDeviceGammaRamp", 2);
        self.add("GetDevicePowerState", 2);
        self.add("GetDeviceResetStatus", 4);
        self.add("GetDevicesForIScsiSession", 3);
        self.add("GetDialogBaseUnits", 0);
        self.add("GetDialogBaseUnits", 1);
        self.add("GetDIBColorTable", 4);
        self.add("GetDIBits", 7);
        self.add("getdiskfree", 2);
        self.add("GetDiskFreeSpace", 5);
        self.add("GetDiskFreeSpaceA", 5);
        self.add("GetDiskFreeSpaceEx", 4);
        self.add("GetDiskFreeSpaceExA", 4);
        self.add("GetDiskFreeSpaceExW", 4);
        self.add("GetDiskFreeSpaceW", 5);
        self.add("GetDiskInfoA", 4);
        self.add("GetDlgCtrlID", 1);
        self.add("GetDlgItem", 2);
        self.add("GetDlgItemInt", 4);
        self.add("GetDlgItemText", 4);
        self.add("GetDlgItemTextA", 4);
        self.add("GetDlgItemTextW", 4);
        self.add("GetDllDirectory", 2);
        self.add("getdllprocaddr", 3);
        self.add("GetDllVersion", 0);
        self.add("GetDmaAdapter", 3);
        self.add("get_doserrno", 1);
        self.add("GetDoubleClickTime", 0);
        self.add("getdrive", 0);
        self.add("GetDriverModuleHandle", 1);
        self.add("getdrives", 0);
        self.add("GetDriveType", 1);
        self.add("GetDriveTypeA", 1);
        self.add("GetDriveTypeW", 1);
        self.add("get_dstbias", 1);
        self.add("GetDurationFormat", 7);
        self.add("GetDurationFormatEx", 7);
        self.add("GetDynamicTimeZoneInformation", 1);
        self.add("GetEffectiveClientRect", 3);
        self.add("GetEffectiveRightsFromAcl", 3);
        self.add("GetEnabledExtendedFeatures", 1);
        self.add("GetEnabledXStateFeatures", 0);
        self.add("GetEnhMetaFile", 1);
        self.add("GetEnhMetaFileA", 1);
        self.add("GetEnhMetaFileBits", 3);
        self.add("GetEnhMetaFileDescription", 3);
        self.add("GetEnhMetaFileDescriptionA", 3);
        self.add("GetEnhMetaFileDescriptionW", 3);
        self.add("GetEnhMetaFileHeader", 3);
        self.add("GetEnhMetaFilePaletteEntries", 3);
        self.add("GetEnhMetaFilePixelFormat", 3);
        self.add("GetEnhMetaFileW", 1);
        self.add("GetEnlistmentId", 2);
        self.add("GetEnlistmentRecoveryInformation", 4);
        self.add("getenv", 1);
        self.add("GetEnvironmentStrings", 0);
        self.add("GetEnvironmentVariable", 3);
        self.add("getenv_s", 4);
        self.add("get_errno", 1);
        self.add("GetErrorInfo", 2);
        self.add("GetErrorMode", 0);
        self.add("GetEventLogInformation", 5);
        self.add("GetExitCodeProcess", 2);
        self.add("GetExitCodeThread", 2);
        self.add("GetExpandedName", 2);
        self.add("GetExplicitEntriesFromAcl", 3);
        self.add("GetExtendedContextLength", 2);
        self.add("GetExtendedFeaturesMask", 1);
        self.add("GetExtendedTcpTable", 6);
        self.add("GetExtendedUdpTable", 6);
        self.add("GetFileAttributes", 1);
        self.add("GetFileAttributesA", 1);
        self.add("GetFileAttributesEx", 3);
        self.add("GetFileAttributesExA", 3);
        self.add("GetFileAttributesExW", 3);
        self.add("GetFileAttributesTransacted", 4);
        self.add("GetFileAttributesW", 1);
        self.add("GetFileBandwidthReservation", 6);
        self.add("GetFileExtensionFromUrl", 4);
        self.add("get_fileinfo", 1);
        self.add("GetFileInformationByHandle", 2);
        self.add("GetFileInformationByHandleEx", 4);
        self.add("GetFileMUIInfo", 4);
        self.add("GetFileMUIPath", 7);
        self.add("GetFileNameFromBrowse", 7);
        self.add("GetFilePatchSignature", 9);
        self.add("GetFilePatchSignatureByBuffer", 9);
        self.add("GetFilePatchSignatureByHandle", 9);
        self.add("GetFileSecurity", 5);
        self.add("GetFileSize", 2);
        self.add("GetFileSizeEx", 2);
        self.add("GetFileTime", 4);
        self.add("GetFileTitle", 3);
        self.add("GetFileType", 1);
        self.add("GetFileVersionInfo", 4);
        self.add("GetFileVersionInfoExW", 5);
        self.add("GetFileVersionInfoSize", 2);
        self.add("GetFileVersionInfoSizeExW", 3);
        self.add("GetFinalPathNameByHandle", 4);
        self.add("GetFinalPathNameByHandleA", 4);
        self.add("GetFinalPathNameByHandleW", 4);
        self.add("GetFirmwareEnvironmentVariable", 4);
        self.add("GetFirmwareEnvironmentVariableEx", 5);
        self.add("GetFirmwareType", 1);
        self.add("get_fmode", 1);
        self.add("GetFocus", 0);
        self.add("GetFontData", 5);
        self.add("GetFontLanguageInfo", 1);
        self.add("GetFontUnicodeRanges", 2);
        self.add("GetForegroundWindow", 0);
        self.add("GetForegroundWindow", 1);
        self.add("GetForm", 6);
        self.add("GetFriendlyIfIndex", 1);
        self.add("GetFriendlyNameOfCert", 3);
        self.add("GetFullPathName", 4);
        self.add("GetFullPathNameA", 4);
        self.add("GetFullPathNameTransacted", 5);
        self.add("GetFullPathNameW", 4);
        self.add("GetGeoInfo", 5);
        self.add("GetGestureConfig", 6);
        self.add("GetGestureExtraArgs", 3);
        self.add("GetGestureInfo", 2);
        self.add("GetGlyphIndices", 5);
        self.add("GetGlyphIndicesA", 5);
        self.add("GetGlyphIndicesW", 5);
        self.add("GetGlyphOutline", 7);
        self.add("GetGlyphOutlineA", 7);
        self.add("GetGlyphOutlineW", 7);
        self.add("GetGPOList", 6);
        self.add("GetGraphicsMode", 1);
        self.add("GetGuiResources", 2);
        self.add("GetGUIThreadInfo", 2);
        self.add("GetHandleInformation", 2);
        self.add("get_heap_handle", 0);
        self.add("GetHGlobalFromILockBytes", 2);
        self.add("GetHGlobalFromStream", 2);
        self.add("gethostbyaddr", 3);
        self.add("gethostbyname", 1);
        self.add("gethostname", 2);
        self.add("GetHostNameW", 2);
        self.add("GetICMProfile", 3);
        self.add("GetIcmpStatistics", 1);
        self.add("GetIcmpStatisticsEx", 2);
        self.add("GetIconInfo", 2);
        self.add("GetIconInfoEx", 2);
        self.add("GetIdleMinutes", 1);
        self.add("GetIdleWakeInfo", 3);
        self.add("GetIfEntry", 1);
        self.add("GetIfEntry2", 1);
        self.add("GetIfStackTable", 1);
        self.add("GetIfTable2", 1);
        self.add("GetIfTable2Ex", 2);
        self.add("GetIfTable", 3);
        self.add("GetImageConfigInformation", 2);
        self.add("GetImageUnusedHeaderBytes", 2);
        self.add("GetInertiaParameterInteractionContext", 3);
        self.add("GetInheritanceSource", 10);
        self.add("GetInputState", 0);
        self.add("GetInputState", 1);
        self.add("GetInstance", 3);
        self.add("GetInteractionConfigurationInteractionContext", 3);
        self.add("GetInterfaceInfo", 2);
        self.add("GetInternetConnected", 6);
        self.add("get_invalid_parameter_handler", 0);
        self.add("GetInvertedIfStackTable", 1);
        self.add("GetIpAddrTable", 3);
        self.add("GetIpErrorString", 3);
        self.add("GetIpForwardEntry2", 1);
        self.add("GetIpForwardTable2", 2);
        self.add("GetIpForwardTable", 3);
        self.add("GetIpInterfaceEntry", 1);
        self.add("GetIpInterfaceTable", 2);
        self.add("GetIpNetEntry2", 1);
        self.add("GetIpNetTable2", 2);
        self.add("GetIpNetTable", 3);
        self.add("GetIpNetworkConnectionBandwidthEstimates", 3);
        self.add("GetIpPathEntry", 1);
        self.add("GetIpPathTable", 2);
        self.add("GetIpStatistics", 1);
        self.add("GetIpStatisticsEx", 2);
        self.add("GetIScsiIKEInfo", 4);
        self.add("GetIScsiInitiatorNodeName", 1);
        self.add("GetIScsiSessionList", 3);
        self.add("GetIScsiTargetInformation", 5);
        self.add("GetIScsiVersionInformation", 1);
        self.add("GetJob", 6);
        self.add("GetKBCodePage", 0);
        self.add("GetKernelObjectSecurity", 5);
        self.add("GetKerningPairs", 3);
        self.add("GetKerningPairsA", 3);
        self.add("GetKerningPairsW", 3);
        self.add("GetKeyboardLayout", 1);
        self.add("GetKeyboardLayoutList", 2);
        self.add("GetKeyboardLayoutName", 1);
        self.add("GetKeyboardState", 1);
        self.add("GetKeyboardType", 1);
        self.add("GetKeyNameText", 3);
        self.add("GetKeyState", 1);
        self.add("GetLargePageMinimum", 0);
        self.add("GetLargestConsoleWindowSize", 1);
        self.add("GetLastActivePopup", 1);
        self.add("GetLastError", 0);
        self.add("GetLastErrors", 1);
        self.add("GetLastInputInfo", 1);
        self.add("GetLayeredWindowAttributes", 4);
        self.add("GetLayout", 1);
        self.add("GetLengthSid", 1);
        self.add("GetListBoxInfo", 1);
        self.add("GetLocaleInfo", 4);
        self.add("GetLocaleInfoEx", 4);
        self.add("GetLocaleInfoW", 4);
        self.add("GetLocalManagedApplications", 3);
        self.add("GetLocalTime", 1);
        self.add("GetLogColorSpace", 3);
        self.add("GetLogContainerName", 5);
        self.add("GetLogFileInformation", 3);
        self.add("GetLogicalDrives", 0);
        self.add("GetLogicalDrives", 1);
        self.add("GetLogicalDriveStrings", 2);
        self.add("GetLogicalDriveStringsW", 2);
        self.add("GetLogicalProcessorInformation", 2);
        self.add("GetLogicalProcessorInformationEx", 3);
        self.add("GetLogIoStatistics", 5);
        self.add("GetLogReservationInfo", 4);
        self.add("GetLongPathName", 3);
        self.add("GetLongPathNameA", 3);
        self.add("GetLongPathNameTransacted", 4);
        self.add("GetLongPathNameW", 3);
        self.add("GetMailslotInfo", 5);
        self.add("getmainargs", 5);
        self.add("GetManagedApplicationCategories", 2);
        self.add("GetManagedApplications", 5);
        self.add("GetMapMode", 1);
        self.add("GetMappedFileName", 4);
        self.add("GetMaximumProcessorCount", 1);
        self.add("GetMaximumProcessorGroupCount", 0);
        self.add("getmaxstdio", 0);
        self.add("getmbcp", 0);
        self.add("GetMemoryErrorHandlingCapabilities", 1);
        self.add("GetMenu", 1);
        self.add("GetMenuBarInfo", 4);
        self.add("GetMenuCheckMarkDimensions", 0);
        self.add("GetMenuContextHelpId", 1);
        self.add("GetMenuDefaultItem", 3);
        self.add("GetMenuInfo", 2);
        self.add("GetMenuItemCount", 1);
        self.add("GetMenuItemID", 2);
        self.add("GetMenuItemInfo", 4);
        self.add("GetMenuItemRect", 4);
        self.add("GetMenuPosFromID", 2);
        self.add("GetMenuState", 3);
        self.add("GetMenuString", 5);
        self.add("GetMessage", 4);
        self.add("GetMessageA", 4);
        self.add("GetMessageExtraInfo", 0);
        self.add("GetMessageExtraInfo", 1);
        self.add("GetMessagePos", 0);
        self.add("GetMessagePos", 1);
        self.add("GetMessageTime", 0);
        self.add("GetMessageTime", 1);
        self.add("GetMessageW", 4);
        self.add("GetMetaFileA", 1);
        self.add("GetMetaFileBitsEx", 3);
        self.add("GetMetaFileW", 1);
        self.add("GetMetaRgn", 2);
        self.add("GetMiterLimit", 2);
        self.add("GetModuleBaseName", 4);
        self.add("GetModuleFileName", 3);
        self.add("GetModuleFileNameA", 3);
        self.add("GetModuleFileNameEx", 4);
        self.add("GetModuleFileNameW", 3);
        self.add("GetModuleHandle", 1);
        self.add("GetModuleHandleA", 1);
        self.add("GetModuleHandleEx", 3);
        self.add("GetModuleHandleExA", 3);
        self.add("GetModuleHandleExW", 3);
        self.add("GetModuleHandleW", 1);
        self.add("GetModuleInformation", 4);
        self.add("GetMonitorBrightness", 4);
        self.add("GetMonitorCapabilities", 3);
        self.add("GetMonitorColorTemperature", 2);
        self.add("GetMonitorContrast", 4);
        self.add("GetMonitorDisplayAreaPosition", 5);
        self.add("GetMonitorDisplayAreaSize", 5);
        self.add("GetMonitorInfo", 2);
        self.add("GetMonitorInfoA", 2);
        self.add("GetMonitorInfoW", 2);
        self.add("GetMonitorRedGreenOrBlueDrive", 5);
        self.add("GetMonitorRedGreenOrBlueGain", 5);
        self.add("GetMonitorTechnologyType", 2);
        self.add("GetMouseMovePointsEx", 5);
        self.add("GetMouseWheelParameterInteractionContext", 3);
        self.add("GetMUILanguage", 0);
        self.add("GetMulticastIpAddressEntry", 1);
        self.add("GetMulticastIpAddressTable", 2);
        self.add("GetMultipleTrustee", 1);
        self.add("GetMultipleTrusteeOperation", 1);
        self.add("GetNameByType", 3);
        self.add("GetNamedPipeClientComputerName", 3);
        self.add("GetNamedPipeClientProcessId", 2);
        self.add("GetNamedPipeClientSessionId", 2);
        self.add("GetNamedPipeHandleState", 7);
        self.add("GetNamedPipeInfo", 5);
        self.add("GetNamedPipeServerProcessId", 2);
        self.add("GetNamedPipeServerSessionId", 2);
        self.add("GetNamedProfileInfo", 2);
        self.add("GetNamedSecurityInfo", 8);
        self.add("getnameinfo", 7);
        self.add("GetNameInfoW", 7);
        self.add("GetNativeSystemInfo", 1);
        self.add("GetNearestColor", 2);
        self.add("GetNearestPaletteIndex", 2);
        self.add("GetNetScheduleAccountInformation", 3);
        self.add("GetNetworkConnected", 6);
        self.add("GetNetworkParams", 2);
        self.add("GetNextDlgGroupItem", 3);
        self.add("GetNextDlgTabItem", 3);
        self.add("GetNextLogArchiveExtent", 4);
        self.add("GetNextUmsListItem", 1);
        self.add("GetNLSVersion", 3);
        self.add("GetNLSVersionEx", 3);
        self.add("GetNotificationResourceManager", 5);
        self.add("GetNotificationResourceManagerAsync", 5);
        self.add("GetNumaAvailableMemoryNode", 2);
        self.add("GetNumaAvailableMemoryNodeEx", 2);
        self.add("GetNumaHighestNodeNumber", 1);
        self.add("GetNumaNodeNumberFromHandle", 2);
        self.add("GetNumaNodeProcessorMask", 2);
        self.add("GetNumaNodeProcessorMaskEx", 2);
        self.add("GetNumaProcessorNode", 2);
        self.add("GetNumaProcessorNodeEx", 2);
        self.add("GetNumaProximityNode", 2);
        self.add("GetNumaProximityNodeEx", 2);
        self.add("GetNumberFormat", 6);
        self.add("GetNumberFormatEx", 6);
        self.add("GetNumberOfConsoleInputEvents", 2);
        self.add("GetNumberOfConsoleMouseButtons", 1);
        self.add("GetNumberOfEventLogRecords", 2);
        self.add("GetNumberOfInterfaces", 1);
        self.add("GetNumberOfPhysicalMonitorsFromHMONITOR", 2);
        self.add("GetNumberOfPhysicalMonitorsFromIDirect3DDevice9", 2);
        self.add("GetObject", 3);
        self.add("GetObjectA", 3);
        self.add("GetObjectType", 1);
        self.add("GetObjectW", 3);
        self.add("GetOEMCP", 0);
        self.add("GetOldestEventLogRecord", 2);
        self.add("GetOleaccVersionInfo", 2);
        self.add("GetOpenCardName", 1);
        self.add("GetOpenClipboardWindow", 0);
        self.add("GetOpenFileName", 1);
        self.add("GetOpenFileNamePreview", 1);
        self.add("get_osfhandle", 1);
        self.add("GetOutlineTextMetrics", 3);
        self.add("GetOutlineTextMetricsA", 3);
        self.add("GetOutlineTextMetricsW", 3);
        self.add("get_output_format", 0);
        self.add("GetOverlappedResult", 4);
        self.add("GetOverlappedResultEx", 5);
        self.add("GetOwnerModuleFromTcp6Entry", 4);
        self.add("GetOwnerModuleFromTcpEntry", 4);
        self.add("GetOwnerModuleFromUdp6Entry", 4);
        self.add("GetOwnerModuleFromUdpEntry", 4);
        self.add("GetP3PPolicy", 4);
        self.add("GetP3PRequestStatus", 1);
        self.add("GetPackageFamilyName", 3);
        self.add("GetPackageFullName", 3);
        self.add("GetPackageId", 3);
        self.add("GetPackageInfo", 5);
        self.add("GetPackagePath", 4);
        self.add("GetPackagesByPackageFamily", 5);
        self.add("GetPaletteEntries", 4);
        self.add("GetParent", 1);
        self.add("GetPath", 4);
        self.add("getpeername", 3);
        self.add("GetPerAdapterInfo", 3);
        self.add("GetPerformanceInfo", 2);
        self.add("GetPerTcp6ConnectionEStats", 11);
        self.add("GetPerTcpConnectionEStats", 11);
        self.add("get_pgmptr", 1);
        self.add("GetPhysicalCursorPos", 1);
        self.add("GetPhysicallyInstalledSystemMemory", 1);
        self.add("GetPhysicalMonitorsFromHMONITOR", 3);
        self.add("GetPhysicalMonitorsFromIDirect3DDevice9", 3);
        self.add("getpid", 0);
        self.add("GetPixel", 3);
        self.add("GetPixelFormat", 1);
        self.add("GetPointerCursorId", 2);
        self.add("GetPointerDevice", 2);
        self.add("GetPointerDeviceCursors", 3);
        self.add("GetPointerDeviceProperties", 3);
        self.add("GetPointerDeviceRects", 3);
        self.add("GetPointerDevices", 2);
        self.add("GetPointerFrameInfo", 3);
        self.add("GetPointerFrameInfoHistory", 4);
        self.add("GetPointerFramePenInfo", 3);
        self.add("GetPointerFramePenInfoHistory", 4);
        self.add("GetPointerFrameTouchInfo", 3);
        self.add("GetPointerFrameTouchInfoHistory", 4);
        self.add("GetPointerInfo", 2);
        self.add("GetPointerInfoHistory", 3);
        self.add("GetPointerPenInfo", 2);
        self.add("GetPointerPenInfoHistory", 3);
        self.add("GetPointerTouchInfo", 2);
        self.add("GetPointerTouchInfoHistory", 3);
        self.add("GetPointerType", 2);
        self.add("GetPolyFillMode", 1);
        self.add("GetPrinter", 5);
        self.add("GetPrinterData", 6);
        self.add("GetPrinterDataEx", 7);
        self.add("GetPrinterDriver2", 7);
        self.add("GetPrinterDriver", 6);
        self.add("GetPrinterDriverDirectory", 6);
        self.add("GetPrinterDriverPackagePath", 7);
        self.add("get_printf_count_output", 0);
        self.add("GetPrintProcessorDirectory", 6);
        self.add("GetPriorityClass", 1);
        self.add("GetPriorityClipboardFormat", 2);
        self.add("GetPrivateObjectSecurity", 5);
        self.add("GetPrivateProfileInt", 4);
        self.add("GetPrivateProfileSection", 4);
        self.add("GetPrivateProfileSectionNames", 3);
        self.add("GetPrivateProfileString", 6);
        self.add("GetPrivateProfileStruct", 5);
        self.add("GetProcAddress", 2);
        self.add("GetProcessAffinityMask", 3);
        self.add("GetProcessDefaultLayout", 1);
        self.add("GetProcessDEPPolicy", 3);
        self.add("GetProcessGroupAffinity", 3);
        self.add("GetProcessHandleCount", 2);
        self.add("GetProcessHandleFromHwnd", 1);
        self.add("GetProcessHeap", 0);
        self.add("GetProcessHeap", 1);
        self.add("GetProcessHeaps", 2);
        self.add("GetProcessId", 1);
        self.add("GetProcessIdOfThread", 1);
        self.add("GetProcessImageFileName", 3);
        self.add("GetProcessInformation", 4);
        self.add("GetProcessIoCounters", 2);
        self.add("GetProcessMemoryInfo", 3);
        self.add("GetProcessMitigationPolicy", 4);
        self.add("GetProcessorSystemCycleTime", 3);
        self.add("GetProcessPreferredUILanguages", 4);
        self.add("GetProcessPriorityBoost", 2);
        self.add("GetProcessReference", 1);
        self.add("GetProcessShutdownParameters", 2);
        self.add("GetProcessTimes", 5);
        self.add("GetProcessVersion", 1);
        self.add("GetProcessWindowStation", 0);
        self.add("GetProcessWorkingSetSize", 3);
        self.add("GetProcessWorkingSetSizeEx", 4);
        self.add("GetProductInfo", 5);
        self.add("GetProfileInt", 3);
        self.add("GetProfilesDirectory", 2);
        self.add("GetProfileSection", 3);
        self.add("GetProfileString", 5);
        self.add("GetProfileType", 1);
        self.add("GetProp", 2);
        self.add("GetPropA", 2);
        self.add("GetPropertyInteractionContext", 3);
        self.add("GetPropW", 2);
        self.add("getprotobyname", 1);
        self.add("getprotobynumber", 1);
        self.add("GetPS2ColorRenderingDictionary", 5);
        self.add("GetPS2ColorRenderingIntent", 4);
        self.add("GetPS2ColorSpaceArray", 6);
        self.add("GetPwrCapabilities", 1);
        self.add("GetPwrDiskSpindownRange", 2);
        self.add("GetQueuedCompletionStatus", 5);
        self.add("GetQueuedCompletionStatusEx", 6);
        self.add("GetQueueStatus", 1);
        self.add("GetRandomRgn", 3);
        self.add("GetRasterizerCaps", 2);
        self.add("GetRawInputBuffer", 3);
        self.add("GetRawInputData", 5);
        self.add("GetRawInputDeviceInfo", 4);
        self.add("GetRawInputDeviceList", 3);
        self.add("GetRawPointerDeviceData", 5);
        self.add("GetRecordInfoFromGuids", 6);
        self.add("GetRecordInfoFromTypeInfo", 2);
        self.add("GetRegionData", 3);
        self.add("GetRegisteredRawInputDevices", 3);
        self.add("GetRestrictedErrorInfo", 1);
        self.add("GetRgnBox", 2);
        self.add("GetRoleText", 3);
        self.add("GetROP2", 1);
        self.add("GetRTTAndHopCount", 4);
        self.add("GetRunningObjectTable", 2);
        self.add("gets", 1);
        self.add("GetSaveFileName", 1);
        self.add("GetSaveFileNamePreview", 1);
        self.add("get_sbh_threshold", 0);
        self.add("GetScaleFactorForDevice", 1);
        self.add("GetScrollBarInfo", 3);
        self.add("GetScrollInfo", 3);
        self.add("GetScrollPos", 2);
        self.add("GetScrollRange", 4);
        self.add("GetSCSIAddress", 4);
        self.add("GetSdevIdentifier", 1);
        self.add("GetSecurityDescriptorControl", 3);
        self.add("GetSecurityDescriptorDacl", 4);
        self.add("GetSecurityDescriptorGroup", 3);
        self.add("GetSecurityDescriptorLength", 1);
        self.add("GetSecurityDescriptorOwner", 3);
        self.add("GetSecurityDescriptorRMControl", 2);
        self.add("GetSecurityDescriptorSacl", 4);
        self.add("GetSecurityInfo", 8);
        self.add("GetSecurityUserInfo", 3);
        self.add("GetSendMessageReceiver", 1);
        self.add("getservbyname", 2);
        self.add("getservbyport", 2);
        self.add("GetService", 7);
        self.add("GetServiceDisplayName", 4);
        self.add("GetServiceKeyName", 4);
        self.add("GetSetDeviceData", 5);
        self.add("GetShellWindow", 0);
        self.add("GetShellWindow", 1);
        self.add("GetShortPathName", 3);
        self.add("GetShortPathNameW", 3);
        self.add("GetSidIdentifierAuthority", 1);
        self.add("GetSidLengthRequired", 1);
        self.add("GetSidSubAuthority", 2);
        self.add("GetSidSubAuthorityCount", 1);
        self.add("getsockname", 3);
        self.add("getsockopt", 5);
        self.add("GetSqmableFileName", 3);
        self.add("gets_s", 2);
        self.add("GetStandardColorSpaceProfile", 4);
        self.add("GetStartupInfo", 1);
        self.add("GetStartupInfoW", 1);
        self.add("GetStateInteractionContext", 3);
        self.add("GetStateText", 3);
        self.add("GetStdHandle", 1);
        self.add("GetStockObject", 1);
        self.add("GetStorageDependencyInformation", 5);
        self.add("GetStretchBltMode", 1);
        self.add("GetStringScripts", 5);
        self.add("GetStringTypeA", 5);
        self.add("GetStringTypeEx", 5);
        self.add("GetStringTypeW", 4);
        self.add("GetSubMenu", 2);
        self.add("GetSysColor", 1);
        self.add("GetSysColorBrush", 1);
        self.add("GetSystemDefaultLangID", 0);
        self.add("GetSystemDefaultLCID", 0);
        self.add("GetSystemDefaultLocaleName", 2);
        self.add("GetSystemDefaultUILanguage", 0);
        self.add("GetSystemDEPPolicy", 0);
        self.add("GetSystemDirectory", 2);
        self.add("GetSystemFileCacheSize", 3);
        self.add("GetSystemFirmwareTable", 4);
        self.add("GetSystemInfo", 1);
        self.add("GetSystemMenu", 2);
        self.add("GetSystemMetrics", 1);
        self.add("GetSystemPaletteEntries", 4);
        self.add("GetSystemPaletteUse", 1);
        self.add("GetSystemPowerStatus", 1);
        self.add("GetSystemPreferredUILanguages", 4);
        self.add("GetSystemRegistryQuota", 2);
        self.add("GetSystemTime", 1);
        self.add("GetSystemTimeAdjustment", 3);
        self.add("GetSystemTimeAsFileTime", 1);
        self.add("GetSystemTimePreciseAsFileTime", 1);
        self.add("GetSystemTimes", 3);
        self.add("GetSystemWindowsDirectory", 2);
        self.add("GetSystemWow64Directory", 2);
        self.add("getsystime", 1);
        self.add("GetTabbedTextExtent", 5);
        self.add("GetTabbedTextExtentA", 5);
        self.add("GetTabbedTextExtentW", 5);
        self.add("GetTapeParameters", 4);
        self.add("GetTapePosition", 5);
        self.add("GetTapeStatus", 1);
        self.add("GetTcp6Table2", 3);
        self.add("GetTcp6Table", 3);
        self.add("GetTcpStatistics", 1);
        self.add("GetTcpStatisticsEx", 2);
        self.add("GetTcpTable2", 3);
        self.add("GetTcpTable", 3);
        self.add("GetTempFileName", 4);
        self.add("GetTempFileNameA", 4);
        self.add("GetTempFileNameW", 4);
        self.add("GetTempPath", 2);
        self.add("GetTempPath2A", 2);
        self.add("GetTempPath2W", 2);
        self.add("GetTempPathA", 2);
        self.add("GetTempPathW", 2);
        self.add("GetTeredoPort", 1);
        self.add("get_terminate", 0);
        self.add("GetTextAlign", 1);
        self.add("GetTextCharacterExtra", 1);
        self.add("GetTextCharset", 1);
        self.add("GetTextCharsetInfo", 3);
        self.add("GetTextColor", 1);
        self.add("GetTextExtentExPoint", 7);
        self.add("GetTextExtentExPointA", 7);
        self.add("GetTextExtentExPointI", 7);
        self.add("GetTextExtentExPointW", 7);
        self.add("GetTextExtentPoint32", 4);
        self.add("GetTextExtentPoint32A", 4);
        self.add("GetTextExtentPoint32W", 4);
        self.add("GetTextExtentPoint32Wrap", 4);
        self.add("GetTextExtentPoint", 4);
        self.add("GetTextExtentPointA", 4);
        self.add("GetTextExtentPointI", 4);
        self.add("GetTextExtentPointW", 4);
        self.add("GetTextFace", 3);
        self.add("GetTextFaceA", 3);
        self.add("GetTextFaceW", 3);
        self.add("GetTextMetrics", 2);
        self.add("GetTextMetricsA", 2);
        self.add("GetTextMetricsW", 2);
        self.add("GetThemeAnimationProperty", 7);
        self.add("GetThemeAnimationTransform", 7);
        self.add("GetThemeAppProperties", 0);
        self.add("GetThemeBackgroundContentRect", 6);
        self.add("GetThemeBackgroundExtent", 6);
        self.add("GetThemeBackgroundRegion", 6);
        self.add("GetThemeBitmap", 6);
        self.add("GetThemeBool", 5);
        self.add("GetThemeColor", 5);
        self.add("GetThemeDocumentationProperty", 4);
        self.add("GetThemeEnumValue", 5);
        self.add("GetThemeFilename", 6);
        self.add("GetThemeFont", 6);
        self.add("GetThemeInt", 5);
        self.add("GetThemeIntList", 5);
        self.add("GetThemeMargins", 7);
        self.add("GetThemeMetric", 6);
        self.add("GetThemePartSize", 7);
        self.add("GetThemePosition", 5);
        self.add("GetThemePropertyOrigin", 5);
        self.add("GetThemeRect", 5);
        self.add("GetThemeStream", 7);
        self.add("GetThemeString", 6);
        self.add("GetThemeSysBool", 2);
        self.add("GetThemeSysColor", 2);
        self.add("GetThemeSysColorBrush", 2);
        self.add("GetThemeSysFont", 3);
        self.add("GetThemeSysInt", 3);
        self.add("GetThemeSysSize", 2);
        self.add("GetThemeSysString", 4);
        self.add("GetThemeTextExtent", 9);
        self.add("GetThemeTextMetrics", 5);
        self.add("GetThemeTimingFunction", 5);
        self.add("GetThemeTransitionDuration", 6);
        self.add("GetThreadContext", 2);
        self.add("GetThreadDescription", 2);
        self.add("GetThreadDesktop", 1);
        self.add("GetThreadErrorMode", 0);
        self.add("GetThreadGroupAffinity", 2);
        self.add("GetThreadId", 1);
        self.add("GetThreadIdealProcessorEx", 2);
        self.add("GetThreadInformation", 4);
        self.add("GetThreadIOPendingFlag", 2);
        self.add("GetThreadLocale", 0);
        self.add("GetThreadPreferredUILanguages", 4);
        self.add("GetThreadPriority", 1);
        self.add("GetThreadPriorityBoost", 2);
        self.add("GetThreadSelectorEntry", 3);
        self.add("GetThreadTimes", 5);
        self.add("GetThreadUILanguage", 0);
        self.add("GetThreadWaitChain", 7);
        self.add("GetTickCount", 0);
        self.add("GetTickCount64", 0);
        self.add("GetTimeFormat", 6);
        self.add("GetTimeFormatEx", 6);
        self.add("GetTimeFormatWrapW", 6);
        self.add("GetTimestampForLoadedLibrary", 1);
        self.add("get_timezone", 1);
        self.add("GetTimeZoneInformation", 1);
        self.add("GetTimeZoneInformationForYear", 3);
        self.add("GetTimingReport", 2);
        self.add("GetTitleBarInfo", 2);
        self.add("GetTokenInformation", 5);
        self.add("GetTopWindow", 1);
        self.add("GetTouchInputInfo", 4);
        self.add("GetTraceEnableFlags", 1);
        self.add("GetTraceEnableLevel", 1);
        self.add("GetTraceLoggerHandle", 1);
        self.add("GetTransactionId", 2);
        self.add("GetTransactionInformation", 7);
        self.add("GetTransactionManagerId", 2);
        self.add("GetTrusteeForm", 1);
        self.add("GetTrusteeName", 1);
        self.add("GetTrusteeType", 1);
        self.add("GetTypeByName", 2);
        self.add("get_tzname", 4);
        self.add("GetUdp6Table", 3);
        self.add("GetUdpStatistics", 1);
        self.add("GetUdpStatisticsEx", 2);
        self.add("GetUdpTable", 3);
        self.add("GetUILanguageInfo", 5);
        self.add("GetUmsCompletionListEvent", 2);
        self.add("GetUmsSystemThreadInformation", 2);
        self.add("get_unexpected", 0);
        self.add("GetUnicastIpAddressEntry", 1);
        self.add("GetUnicastIpAddressTable", 2);
        self.add("GetUniDirectionalAdapterInfo", 2);
        self.add("GetUnpredictedMessagePos", 0);
        self.add("GetUpdatedBusResource", 3);
        self.add("GetUpdatedClipboardFormats", 3);
        self.add("GetUpdateRect", 3);
        self.add("GetUpdateRgn", 3);
        self.add("GetUrlCacheConfigInfo", 3);
        self.add("GetUrlCacheContainerInfo", 4);
        self.add("GetUrlCacheEntryBinaryBlob", 7);
        self.add("GetUrlCacheEntryInfo", 3);
        self.add("GetUrlCacheEntryInfoA", 3);
        self.add("GetUrlCacheEntryInfoEx", 7);
        self.add("GetUrlCacheEntryInfoExA", 7);
        self.add("GetUrlCacheEntryInfoExW", 7);
        self.add("GetUrlCacheEntryInfoW", 3);
        self.add("GetUrlCacheGroupAttribute", 6);
        self.add("GetUrlCacheGroupAttributeA", 6);
        self.add("GetUrlCacheGroupAttributeW", 6);
        self.add("GetUrlCacheHeaderData", 2);
        self.add("GetUserDefaultLangID", 0);
        self.add("GetUserDefaultLCID", 0);
        self.add("GetUserDefaultLocaleName", 2);
        self.add("GetUserDefaultUILanguage", 0);
        self.add("GetUserGeoID", 1);
        self.add("GetUserName", 2);
        self.add("GetUserNameEx", 3);
        self.add("GetUserObjectInformation", 5);
        self.add("GetUserObjectSecurity", 5);
        self.add("GetUserPreferredUILanguages", 4);
        self.add("GetUserProfileDirectory", 3);
        self.add("GetVarConversionLocaleSetting", 1);
        self.add("GetVCPFeatureAndVCPFeatureReply", 5);
        self.add("GetVersion", 0);
        self.add("GetVersionEx", 1);
        self.add("GetViewportExtEx", 2);
        self.add("GetViewportOrgEx", 2);
        self.add("GetVirtualDiskInformation", 4);
        self.add("GetVirtualDiskMetadata", 4);
        self.add("GetVirtualDiskOperationProgress", 3);
        self.add("GetVirtualDiskPhysicalPath", 3);
        self.add("GetVolumeInformation", 8);
        self.add("GetVolumeInformationA", 8);
        self.add("GetVolumeInformationByHandleW", 8);
        self.add("GetVolumeInformationW", 8);
        self.add("GetVolumeNameForVolumeMountPoint", 3);
            self.add("GetVolumeNameForVolumeMountPointW", 3);
        self.add("GetVolumePathName", 3);
        self.add("GetVolumePathNamesForVolumeName", 4);
            self.add("GetVolumePathNamesForVolumeNameW", 4);
        self.add("GetVolumePathNameW", 3);
        self.add("GetVPNConnected", 6);
        self.add("getw", 1);
        self.add("getwc", 1);
        self.add("getwch", 0);
        self.add("getwchar", 0);
        self.add("getwche", 0);
        self.add("getwche_nolock", 0);
        self.add("getwch_nolock", 0);
        self.add("GetWindow", 2);
        self.add("GetWindowCompositionAttribute", 2);
        self.add("GetWindowContextHelpId", 1);
        self.add("GetWindowDC", 1);
        self.add("GetWindowDisplayAffinity", 2);
        self.add("GetWindowExtEx", 2);
        self.add("GetWindowFeedbackSetting", 5);
        self.add("GetWindowInfo", 2);
        self.add("GetWindowLong", 2);
        self.add("GetWindowLongA", 2);
        self.add("GetWindowLongPtrA", 2);
        self.add("GetWindowLongPtrW", 2);
        self.add("GetWindowLongW", 2);
        self.add("GetWindowMinimizeRect", 2);
        self.add("GetWindowModuleFileName", 3);
        self.add("GetWindowModuleFileNameA", 3);
        self.add("GetWindowModuleFileNameW", 3);
        self.add("GetWindowOrgEx", 2);
        self.add("GetWindowPlacement", 2);
        self.add("GetWindowRect", 2);
        self.add("GetWindowRgn", 2);
        self.add("GetWindowRgnBox", 2);
        self.add("GetWindowsAccountDomainSid", 3);
        self.add("GetWindowsDirectory", 2);
        self.add("GetWindowSubclass", 4);
        self.add("GetWindowText", 3);
        self.add("GetWindowTextA", 3);
        self.add("GetWindowTextLength", 1);
        self.add("GetWindowTextLengthA", 1);
        self.add("GetWindowTextLengthW", 1);
        self.add("GetWindowTextW", 3);
        self.add("GetWindowTheme", 1);
        self.add("GetWindowThreadProcessId", 2);
        self.add("GetWinMetaFileBits", 5);
        self.add("GetWorldTransform", 2);
        self.add("get_wpgmptr", 1);
        self.add("GetWriteWatch", 6);
        self.add("getws", 1);
        self.add("GetWsChanges", 3);
        self.add("GetWsChangesEx", 3);
        self.add("getws_s", 2);
        self.add("GetXStateFeaturesMask", 2);
        self.add("GhostWindowFromHungWindow", 1);
        self.add("GlobalAddAtom", 1);
        self.add("GlobalAlloc", 2);
        self.add("GlobalDeleteAtom", 1);
        self.add("GlobalFindAtom", 1);
        self.add("GlobalFlags", 1);
        self.add("GlobalFree", 1);
        self.add("GlobalGetAtomName", 3);
        self.add("GlobalHandle", 1);
        self.add("GlobalLock", 1);
        self.add("GlobalMemoryStatus", 1);
        self.add("GlobalMemoryStatusEx", 1);
        self.add("GlobalReAlloc", 3);
        self.add("GlobalSize", 1);
        self.add("GlobalUnlock", 1);
        self.add("gmtime", 1);
        self.add("gmtime32", 1);
        self.add("gmtime32_s", 2);
        self.add("gmtime64", 1);
        self.add("gmtime64_s", 2);
        self.add("Gobjenumproc", 2);
        self.add("GopherAttributeEnumerator", 2);
        self.add("GopherCreateLocator", 7);
        self.add("GopherCreateLocatorA", 7);
        self.add("GopherCreateLocatorW", 7);
        self.add("GopherFindFirstFile", 6);
        self.add("GopherFindFirstFileA", 6);
        self.add("GopherFindFirstFileW", 6);
        self.add("GopherGetAttribute", 8);
        self.add("GopherGetAttributeA", 8);
        self.add("GopherGetAttributeW", 8);
        self.add("GopherGetLocatorType", 2);
        self.add("GopherGetLocatorTypeA", 2);
        self.add("GopherGetLocatorTypeW", 2);
        self.add("GopherOpenFile", 5);
        self.add("GopherOpenFileA", 5);
        self.add("GopherOpenFileW", 5);
        self.add("GradientFill", 6);
        self.add("GrayString", 9);
        self.add("GrayStringA", 9);
        self.add("Graystringproc", 3);
        self.add("GrayStringW", 9);
        self.add("GUIDFromString", 2);
        self.add("HandleLogFull", 1);
        self.add("HashData", 4);
        self.add("Heap32First", 3);
        self.add("Heap32ListFirst", 2);
        self.add("Heap32ListNext", 2);
        self.add("Heap32Next", 1);
        self.add("heapadd", 2);
        self.add("HeapAlloc", 3);
        self.add("heapchk", 0);
        self.add("HeapCompact", 2);
        self.add("HeapCreate", 3);
        self.add("HeapDestroy", 1);
        self.add("HeapFree", 3);
        self.add("HeapLock", 1);
        self.add("heapmin", 0);
        self.add("HeapQueryInformation", 5);
        self.add("HeapReAlloc", 4);
        self.add("heapset", 1);
        self.add("HeapSetInformation", 4);
        self.add("HeapSize", 3);
        self.add("HeapSummary", 3);
        self.add("HeapUnlock", 1);
        self.add("HeapValidate", 3);
        self.add("heapwalk", 1);
        self.add("HeapWalk", 2);
        self.add("HexFromBin", 3);
        self.add("HidD_FlushQueue", 1);
        self.add("HidD_FreePreparsedData", 1);
        self.add("HidD_GetAttributes", 2);
        self.add("HidD_GetConfiguration", 3);
        self.add("HidD_GetFeature", 3);
        self.add("HidD_GetHidGuid", 1);
        self.add("HidD_GetIndexedString", 4);
        self.add("HidD_GetInputReport", 3);
        self.add("HidD_GetManufacturerString", 3);
        self.add("HidD_GetMsGenreDescriptor", 3);
        self.add("HidD_GetNumInputBuffers", 2);
        self.add("HidD_GetPhysicalDescriptor", 3);
        self.add("HidD_GetPreparsedData", 2);
        self.add("HidD_GetProductString", 3);
        self.add("HidD_GetSerialNumberString", 3);
        self.add("HidD_Hello", 2);
        self.add("HidD_SetConfiguration", 3);
        self.add("HidD_SetFeature", 3);
        self.add("HidD_SetNumInputBuffers", 2);
        self.add("HidD_SetOutputReport", 3);
        self.add("HideCaret", 1);
        self.add("HidP_GetButtonCaps", 4);
        self.add("HidP_GetCaps", 2);
        self.add("HidP_GetData", 6);
        self.add("HidP_GetExtendedAttributes", 5);
        self.add("HidP_GetLinkCollectionNodes", 3);
        self.add("HidP_GetScaledUsageValue", 8);
        self.add("HidP_GetSpecificButtonCaps", 7);
        self.add("HidP_GetSpecificValueCaps", 7);
        self.add("HidP_GetUsages", 8);
        self.add("HidP_GetUsagesEx", 7);
        self.add("HidP_GetUsageValue", 8);
        self.add("HidP_GetUsageValueArray", 9);
        self.add("HidP_GetValueCaps", 4);
        self.add("HidP_InitializeReportForID", 5);
        self.add("HidP_IsSameUsageAndPage", 2);
        self.add("HidP_MaxDataListLength", 2);
        self.add("HidP_MaxUsageListLength", 3);
        self.add("HidP_SetData", 6);
        self.add("HidP_SetScaledUsageValue", 8);
        self.add("HidP_SetUsages", 8);
        self.add("HidP_SetUsageValue", 8);
        self.add("HidP_SetUsageValueArray", 9);
        self.add("HidP_TranslateUsagesToI8042ScanCodes", 6);
        self.add("HidP_UnsetUsages", 8);
        self.add("HidP_UsageListDifference", 5);
        self.add("HiliteMenuItem", 4);
        self.add("HIMAGELIST_QueryInterface", 3);
        self.add("HitTestThemeBackground", 9);
        self.add("Hookproc", 3);
        self.add("HrAddColumnsEx", 5);
        self.add("HrAllocAdviseSink", 3);
        self.add("HrComposeEID", 7);
        self.add("HrComposeMsgID", 6);
        self.add("HrDecomposeEID", 7);
        self.add("HrDecomposeMsgID", 6);
        self.add("HrDispatchNotifications", 1);
        self.add("hread", 3);
        self.add("HrEntryIDFromSz", 3);
        self.add("HrGetOneProp", 3);
        self.add("HrIStorageFromStream", 4);
        self.add("HrQueryAllRows", 6);
        self.add("HrSetOneProp", 2);
        self.add("HrSzFromEntryID", 3);
        self.add("HrThisThreadAdviseSink", 2);
        self.add("HrValidateIPMSubtree", 5);
        self.add("HSTRING_UserFree", 2);
        self.add("HSTRING_UserFree64", 2);
        self.add("HSTRING_UserMarshal", 3);
        self.add("HSTRING_UserMarshal64", 3);
        self.add("HSTRING_UserSize", 3);
        self.add("HSTRING_UserSize64", 3);
        self.add("HSTRING_UserUnmarshal", 3);
        self.add("HSTRING_UserUnmarshal64", 3);
        self.add("htond", 1);
        self.add("htonf", 1);
        self.add("htonl", 1);
        self.add("htonll", 1);
        self.add("htons", 1);
        self.add("HttpAddFragmentToCache", 5);
        self.add("HttpAddRequestHeaders", 4);
        self.add("HttpAddRequestHeadersA", 4);
        self.add("HttpAddRequestHeadersW", 4);
        self.add("HttpAddUrl", 3);
        self.add("HttpAddUrlToUrlGroup", 4);
        self.add("HttpCheckDavCompliance", 5);
        self.add("HttpCloseDependencyHandle", 1);
        self.add("HttpCloseRequestQueue", 1);
        self.add("HttpCloseServerSession", 1);
        self.add("HttpCloseUrlGroup", 1);
        self.add("HttpCreateHttpHandle", 2);
        self.add("HttpCreateRequestQueue", 5);
        self.add("HttpCreateServerSession", 3);
        self.add("HttpCreateUrlGroup", 3);
        self.add("HttpDeleteServiceConfiguration", 5);
        self.add("HttpDuplicateDependencyHandle", 2);
        self.add("HttpEndRequest", 4);
        self.add("HttpEndRequestA", 4);
        self.add("HttpEndRequestW", 4);
        self.add("HttpFlushResponseCache", 4);
        self.add("HttpInitialize", 3);
        self.add("HttpOpenDependencyHandle", 3);
        self.add("HttpOpenRequest", 8);
        self.add("HttpOpenRequestA", 8);
        self.add("HttpOpenRequestW", 8);
        self.add("HttpPrepareUrl", 4);
        self.add("HttpPushClose", 1);
        self.add("HttpPushEnable", 3);
        self.add("HttpPushWait", 3);
        self.add("HttpQueryInfo", 5);
        self.add("HttpQueryInfoA", 5);
        self.add("HttpQueryInfoW", 5);
        self.add("HttpQueryServerSessionProperty", 5);
        self.add("HttpQueryServiceConfiguration", 8);
        self.add("HttpQueryUrlGroupProperty", 5);
        self.add("HttpReadFragmentFromCache", 7);
        self.add("HttpReceiveClientCertificate", 7);
        self.add("HttpReceiveHttpRequest", 7);
        self.add("HttpReceiveRequestEntityBody", 7);
        self.add("HttpRemoveUrl", 2);
        self.add("HttpRemoveUrlFromUrlGroup", 3);
        self.add("HttpSendHttpResponse", 10);
        self.add("HttpSendRequest", 5);
        self.add("HttpSendRequestA", 5);
        self.add("HttpSendRequestEx", 5);
        self.add("HttpSendRequestExA", 5);
        self.add("HttpSendRequestExW", 5);
        self.add("HttpSendRequestW", 5);
        self.add("HttpSendResponseEntityBody", 10);
        self.add("HttpSetRequestQueueProperty", 6);
        self.add("HttpSetServerSessionProperty", 4);
        self.add("HttpSetServiceConfiguration", 5);
        self.add("HttpSetUrlGroupProperty", 4);
        self.add("HttpTerminate", 2);
        self.add("HttpWaitForDemandStart", 2);
        self.add("HttpWaitForDisconnect", 3);
        self.add("HttpWebSocketClose", 4);
        self.add("HttpWebSocketCompleteUpgrade", 2);
        self.add("HttpWebSocketQueryCloseStatus", 5);
        self.add("HttpWebSocketReceive", 5);
        self.add("HttpWebSocketSend", 4);
        self.add("HttpWebSocketShutdown", 4);
        self.add("HungWindowFromGhostWindow", 1);
        self.add("hwrite", 3);
        self.add("hypot", 2);
        self.add("hypotf", 2);
        self.add("i64toa", 3);
        self.add("i64toa_s", 4);
        self.add("i64tow", 3);
        self.add("i64tow_s", 4);
        self.add("ICClose", 1);
        self.add("ICCompress", 13);
        self.add("ICCompressorChoose", 6);
        self.add("ICCompressorFree", 1);
        self.add("ICDecompress", 6);
        self.add("ICDraw", 6);
        self.add("ICDrawBegin", 16);
        self.add("ICGetDisplayFormat", 6);
        self.add("ICGetInfo", 3);
        self.add("ICImageCompress", 7);
        self.add("ICImageDecompress", 5);
        self.add("ICInfo", 3);
        self.add("ICInstall", 5);
        self.add("ICLocate", 5);
        self.add("Icmp6CreateFile", 0);
        self.add("Icmp6ParseReplies", 2);
        self.add("Icmp6SendEcho2", 12);
        self.add("IcmpCloseHandle", 1);
        self.add("IcmpCreateFile", 0);
        self.add("IcmpParseReplies", 2);
        self.add("IcmpSendEcho2", 11);
        self.add("IcmpSendEcho2Ex", 12);
        self.add("IcmpSendEcho", 8);
        self.add("ICOpen", 3);
        self.add("ICOpenFunction", 4);
        self.add("ICRemove", 3);
        self.add("ICSendMessage", 4);
        self.add("ICSeqCompressFrame", 5);
        self.add("ICSeqCompressFrameEnd", 1);
        self.add("ICSeqCompressFrameStart", 2);
        self.add("IdnToAscii", 5);
        self.add("IdnToNameprepUnicode", 5);
        self.add("IdnToUnicode", 5);
        self.add("IECancelSaveFile", 1);
        self.add("IECreateDirectory", 2);
        self.add("IECreateFile", 7);
        self.add("IEDeleteFile", 1);
        self.add("IEFindFirstFile", 2);
        self.add("IEGetFileAttributesEx", 3);
        self.add("IEGetProtectedModeCookie", 5);
        self.add("IEGetWriteableFolderPath", 2);
        self.add("IEGetWriteableHKCU", 1);
        self.add("IEInstallScope", 1);
        self.add("IEIsProtectedModeProcess", 1);
        self.add("IEIsProtectedModeURL", 1);
        self.add("IELaunchURL", 3);
        self.add("IEMoveFileEx", 3);
        self.add("IERefreshElevationPolicy", 0);
        self.add("IERegCreateKeyEx", 8);
        self.add("IERegisterWritableRegistryKey", 3);
        self.add("IERegisterWritableRegistryValue", 6);
        self.add("IERegSetValueEx", 6);
        self.add("IERemoveDirectory", 1);
        self.add("IESaveFile", 2);
        self.add("IESetProtectedModeCookie", 4);
        self.add("IEShowSaveFileDialog", 9);
        self.add("IEUnregisterWritableRegistry", 1);
        self.add("if_indextoname", 2);
        self.add("if_nametoindex", 1);
        self.add("IIDFromString", 2);
        self.add("ILAppendID", 3);
        self.add("ILClone", 1);
        self.add("ILCloneFirst", 1);
        self.add("ILCombine", 2);
        self.add("ILCreateFromPath", 1);
        self.add("ILFindChild", 2);
        self.add("ILFindLastID", 1);
        self.add("ILFree", 1);
        self.add("ILGetNext", 1);
        self.add("ILGetSize", 1);
        self.add("ILIsEqual", 2);
        self.add("ILIsParent", 3);
        self.add("ILLoadFromStream", 2);
        self.add("ILRemoveLastID", 1);
        self.add("ILSaveToStream", 2);
        self.add("ImageAddCertificate", 3);
        self.add("ImageDirectoryEntryToData", 4);
        self.add("ImageDirectoryEntryToDataEx", 5);
        self.add("ImageEnumerateCertificates", 5);
        self.add("ImageGetCertificateData", 4);
        self.add("ImageGetCertificateHeader", 3);
        self.add("ImageGetDigestStream", 4);
        self.add("ImagehlpApiVersion", 0);
        self.add("ImagehlpApiVersionEx", 1);
        self.add("ImageList_Add", 3);
        self.add("ImageList_AddMasked", 3);
        self.add("ImageList_BeginDrag", 4);
        self.add("ImageList_CoCreateInstance", 4);
        self.add("ImageList_Copy", 5);
        self.add("ImageList_Create", 5);
        self.add("ImageList_Destroy", 1);
        self.add("ImageList_DragEnter", 3);
        self.add("ImageList_DragLeave", 1);
        self.add("ImageList_DragMove", 2);
        self.add("ImageList_DragShowNolock", 1);
        self.add("ImageList_Draw", 6);
        self.add("ImageList_DrawEx", 10);
        self.add("ImageList_DrawIndirect", 1);
        self.add("ImageList_Duplicate", 1);
        self.add("ImageList_EndDrag", 0);
        self.add("ImageList_GetBkColor", 1);
        self.add("ImageList_GetDragImage", 2);
        self.add("ImageList_GetIcon", 3);
        self.add("ImageList_GetIconSize", 3);
        self.add("ImageList_GetImageCount", 1);
        self.add("ImageList_GetImageInfo", 3);
        self.add("ImageList_LoadImage", 7);
        self.add("ImageList_Merge", 6);
        self.add("ImageList_Read", 1);
        self.add("ImageList_ReadEx", 4);
        self.add("ImageList_Remove", 2);
        self.add("ImageList_Replace", 4);
        self.add("ImageList_ReplaceIcon", 3);
        self.add("ImageList_SetBkColor", 2);
        self.add("ImageList_SetColorTable", 4);
        self.add("ImageList_SetDragCursorImage", 4);
        self.add("ImageList_SetIconSize", 3);
        self.add("ImageList_SetImageCount", 2);
        self.add("ImageList_SetOverlayImage", 3);
        self.add("ImageList_Write", 2);
        self.add("ImageList_WriteEx", 3);
        self.add("ImageLoad", 2);
        self.add("ImageNtHeader", 1);
        self.add("ImageRemoveCertificate", 2);
        self.add("ImageRvaToSection", 3);
        self.add("ImageRvaToVa", 4);
        self.add("ImageUnload", 1);
        self.add("ImmAssociateContext", 2);
        self.add("ImmAssociateContextEx", 3);
        self.add("ImmConfigureIME", 4);
        self.add("ImmCreateContext", 0);
        self.add("ImmDestroyContext", 1);
        self.add("ImmDisableIME", 1);
        self.add("IMMDisableLegacyIME", 0);
        self.add("ImmDisableTextFrameService", 1);
        self.add("ImmEnumInputContext", 3);
        self.add("ImmEnumRegisterWord", 6);
        self.add("ImmEscape", 4);
        self.add("ImmGetCandidateList", 4);
        self.add("ImmGetCandidateListCount", 2);
        self.add("ImmGetCandidateWindow", 3);
        self.add("ImmGetCompositionFont", 2);
        self.add("ImmGetCompositionString", 4);
        self.add("ImmGetCompositionWindow", 2);
        self.add("ImmGetContext", 1);
        self.add("ImmGetConversionList", 6);
        self.add("ImmGetConversionStatus", 3);
        self.add("ImmGetDefaultIMEWnd", 1);
        self.add("ImmGetDescription", 3);
        self.add("ImmGetGuideLine", 4);
        self.add("ImmGetIMEFileName", 3);
        self.add("ImmGetImeMenuItems", 6);
        self.add("ImmGetOpenStatus", 1);
        self.add("ImmGetProperty", 2);
        self.add("ImmGetRegisterWordStyle", 3);
        self.add("ImmGetStatusWindowPos", 2);
        self.add("ImmGetVirtualKey", 1);
        self.add("ImmInstallIME", 2);
        self.add("ImmIsIME", 1);
        self.add("ImmIsUIMessage", 4);
        self.add("ImmNotifyIME", 4);
        self.add("ImmRegisterWord", 4);
        self.add("ImmReleaseContext", 2);
        self.add("ImmRequestMessage", 3);
        self.add("ImmSetCandidateWindow", 2);
        self.add("ImmSetCompositionFont", 2);
        self.add("ImmSetCompositionString", 6);
        self.add("ImmSetCompositionWindow", 2);
        self.add("ImmSetConversionStatus", 3);
        self.add("ImmSetOpenStatus", 2);
        self.add("ImmSetStatusWindowPos", 2);
        self.add("ImmSimulateHotKey", 2);
        self.add("ImmUnregisterWord", 4);
        self.add("ImpersonateAnonymousToken", 1);
        self.add("ImpersonateDdeClientWindow", 2);
        self.add("ImpersonateLoggedOnUser", 1);
        self.add("ImpersonateNamedPipeClient", 1);
        self.add("ImpersonateSecurityContext", 1);
        self.add("ImpersonateSelf", 1);
        self.add("ImportCookieFile", 1);
        self.add("ImportPrivacySettings", 3);
        self.add("ImportRSoPData", 2);
        self.add("ImportSecurityContext", 4);
        self.add("IncrementUrlCacheHeaderData", 2);
        self.add("inet_addr", 1);
        self.add("InetIsOffline", 1);
        self.add("inet_ntoa", 1);
        self.add("inet_ntop", 4);
        self.add("InetNtopW", 4);
        self.add("inet_pton", 3);
        self.add("InetPtonW", 3);
        self.add("InflateRect", 3);
        self.add("InitAtomTable", 1);
        self.add("InitCommonControls", 0);
        self.add("InitCommonControlsEx", 1);
        self.add("InitializeAcl", 3);
        self.add("InitializeConditionVariable", 1);
        self.add("InitializeContext", 4);
        self.add("InitializeCriticalSection", 1);
            self.add("InitializeCriticalSectionAndSpinCount", 2);
        self.add("InitializeCriticalSectionAndSpinCount", 2);
        self.add("InitializeCriticalSectionEx", 3);
        self.add("InitializeExtendedContext", 3);
        self.add("InitializeFlatSB", 1);
        self.add("InitializeIpForwardEntry", 1);
        self.add("InitializeIpInterfaceEntry", 1);
        self.add("InitializeListHead", 1);
        self.add("InitializeProcessForWsWatch", 1);
            self.add("InitializeProcThreadAttributeList", 4);
        self.add("InitializeProcThreadAttributeList", 4);
        self.add("InitializeSecurityContext", 12);
        self.add("InitializeSecurityDescriptor", 2);
        self.add("InitializeSid", 3);
        self.add("InitializeSListHead", 1);
        self.add("InitializeSRWLock", 1);
            self.add("InitializeSynchronizationBarrier", 3);
        self.add("InitializeSynchronizationBarrier", 3);
        self.add("InitializeTouchInjection", 2);
        self.add("InitializeUnicastIpAddressEntry", 1);
        self.add("InitiateShutdown", 5);
        self.add("InitiateSystemShutdown", 5);
        self.add("InitiateSystemShutdownEx", 6);
        self.add("InitLocalMsCtfMonitor", 1);
        self.add("InitMUILanguage", 1);
        self.add("InitNetworkAddressControl", 0);
        self.add("InitNetworkAddressControl", 1);
        self.add("InitOnceBeginInitialize", 4);
        self.add("InitOnceComplete", 3);
        self.add("InitOnceExecuteOnce", 4);
        self.add("InitOnceInitialize", 1);
        self.add("InitPropVariantFromGUIDAsBuffer", 2);
        self.add("InitPropVariantFromGUIDAsString", 2);
        self.add("InitSecurityInterface", 0);
        self.add("initterm", 2);
        self.add("initterm_e", 2);
        self.add("InitVariantFromGUIDAsBuffer", 2);
        self.add("InitVariantFromGUIDAsString", 2);
        self.add("InjectTouchInput", 2);
        self.add("inp", 1);
        self.add("inpd", 1);
        self.add("inpw", 1);
        self.add("InSendMessage", 0);
        self.add("InSendMessage", 1);
        self.add("InSendMessageEx", 1);
        self.add("InsertHeadList", 2);
        self.add("InsertMenu", 5);
        self.add("InsertMenuItem", 4);
        self.add("InsertTailList", 2);
        self.add("InstallApplication", 1);
        self.add("InstallColorProfile", 2);
        self.add("InstallHinfSection", 4);
        self.add("InstallLayoutOrTip", 2);
        self.add("InstallLayoutOrTipUserReg", 5);
        self.add("InstallLogPolicy", 2);
        self.add("InstallNewDevice", 3);
        self.add("InstallPrinterDriverFromPackage", 5);
        self.add("InstallSelectedDriver", 5);
        self.add("Int64ToString", 6);
        self.add("InterlockedAnd", 2);
        self.add("InterlockedCompareExchange", 3);
        self.add("InterlockedCompareExchange64", 3);
            self.add("InterlockedCompareExchangePointer", 3);
        self.add("InterlockedDecrement", 1);
        self.add("InterlockedExchange", 2);
        self.add("InterlockedExchangeAdd", 2);
        self.add("InterlockedExchangePointer", 2);
        self.add("InterlockedFlushSList", 1);
        self.add("InterlockedIncrement", 1);
        self.add("InterlockedOr", 2);
        self.add("InterlockedPopEntrySList", 1);
        self.add("InterlockedPushEntrySList", 2);
        self.add("InterlockedPushListSList", 4);
        self.add("InterlockedPushListSListEx", 4);
        self.add("InterlockedXor", 2);
        self.add("InternalGetWindowText", 3);
        self.add("InternalInternetGetCookie", 3);
        self.add("InternetAlgIdToString", 4);
        self.add("InternetAttemptConnect", 1);
        self.add("InternetAutodial", 2);
        self.add("InternetAutodialHangup", 1);
        self.add("InternetCanonicalizeUrl", 4);
        self.add("InternetCanonicalizeUrlA", 4);
        self.add("InternetCanonicalizeUrlW", 4);
        self.add("InternetCheckConnection", 3);
        self.add("InternetCheckConnectionA", 3);
        self.add("InternetCheckConnectionW", 3);
        self.add("InternetClearAllPerSiteCookieDecisions", 0);
            self.add("InternetClearAllPerSiteCookieDecisions", 1);
        self.add("InternetCloseHandle", 1);
        self.add("InternetCombineUrl", 5);
        self.add("InternetCombineUrlA", 5);
        self.add("InternetCombineUrlW", 5);
        self.add("InternetConfirmZoneCrossing", 4);
        self.add("InternetConfirmZoneCrossingA", 4);
        self.add("InternetConfirmZoneCrossingW", 4);
        self.add("InternetConnect", 8);
        self.add("InternetConnectA", 8);
        self.add("InternetConnectW", 8);
        self.add("InternetCrackUrl", 4);
        self.add("InternetCrackUrlA", 4);
        self.add("InternetCrackUrlW", 4);
        self.add("InternetCreateUrl", 4);
        self.add("InternetCreateUrlA", 4);
        self.add("InternetCreateUrlW", 4);
        self.add("InternetDebugGetLocalTime", 2);
        self.add("InternetDeInitializeAutoProxyDll", 2);
        self.add("InternetDial", 5);
        self.add("InternetDialA", 5);
        self.add("InternetDialW", 5);
        self.add("InternetEnumPerSiteCookieDecision", 4);
            self.add("InternetEnumPerSiteCookieDecisionA", 4);
            self.add("InternetEnumPerSiteCookieDecisionW", 4);
        self.add("InternetErrorDlg", 5);
        self.add("InternetFindNextFile", 2);
        self.add("InternetFindNextFileA", 2);
        self.add("InternetFindNextFileW", 2);
        self.add("InternetFortezzaCommand", 3);
        self.add("InternetFreeCookies", 2);
        self.add("InternetFreeProxyInfoList", 1);
        self.add("InternetGetCertByURL", 3);
        self.add("InternetGetCertByURLA", 3);
        self.add("InternetGetConnectedState", 2);
        self.add("InternetGetConnectedStateEx", 4);
        self.add("InternetGetConnectedStateExA", 4);
        self.add("InternetGetConnectedStateExW", 4);
        self.add("InternetGetCookie", 4);
        self.add("InternetGetCookieA", 4);
        self.add("InternetGetCookieEx2", 5);
        self.add("InternetGetCookieEx", 6);
        self.add("InternetGetCookieExA", 6);
        self.add("InternetGetCookieExW", 6);
        self.add("InternetGetCookieW", 4);
        self.add("InternetGetDialBrandingW", 2);
        self.add("InternetGetDialEngineW", 3);
        self.add("InternetGetLastResponseInfo", 3);
        self.add("InternetGetLastResponseInfoA", 3);
        self.add("InternetGetLastResponseInfoW", 3);
        self.add("InternetGetPerSiteCookieDecision", 2);
            self.add("InternetGetPerSiteCookieDecisionA", 2);
            self.add("InternetGetPerSiteCookieDecisionW", 2);
        self.add("InternetGetProxyForUrl", 3);
        self.add("InternetGetProxyInfo", 6);
        self.add("InternetGetSecurityInfoByURL", 3);
        self.add("InternetGoOnline", 3);
        self.add("InternetGoOnlineA", 3);
        self.add("InternetGoOnlineW", 3);
        self.add("InternetHangUp", 2);
        self.add("InternetInitializeAutoProxyDll", 1);
        self.add("InternetLockRequestFile", 2);
        self.add("InternetOpen", 5);
        self.add("InternetOpenA", 5);
        self.add("InternetOpenUrl", 6);
        self.add("InternetOpenUrlA", 6);
        self.add("InternetOpenUrlW", 6);
        self.add("InternetOpenW", 5);
        self.add("InternetQueryDataAvailable", 4);
        self.add("InternetQueryFortezzaStatus", 2);
        self.add("InternetQueryOption", 4);
        self.add("InternetQueryOptionA", 4);
        self.add("InternetQueryOptionW", 4);
        self.add("InternetReadFile", 4);
        self.add("InternetReadFileEx", 4);
        self.add("InternetReadFileExA", 4);
        self.add("InternetReadFileExW", 4);
        self.add("InternetSecurityProtocolToString", 4);
        self.add("InternetSetCookie", 3);
        self.add("InternetSetCookieA", 3);
        self.add("InternetSetCookieEx2", 5);
        self.add("InternetSetCookieEx", 5);
        self.add("InternetSetCookieExA", 5);
        self.add("InternetSetCookieExW", 5);
        self.add("InternetSetCookieW", 3);
        self.add("InternetSetDialState", 3);
        self.add("InternetSetDialStateA", 3);
        self.add("InternetSetDialStateW", 3);
        self.add("InternetSetFilePointer", 5);
        self.add("InternetSetOption", 4);
        self.add("InternetSetOptionA", 4);
        self.add("InternetSetOptionEx", 5);
        self.add("InternetSetOptionExA", 5);
        self.add("InternetSetOptionExW", 5);
        self.add("InternetSetOptionW", 4);
        self.add("InternetSetPerSiteCookieDecision", 2);
            self.add("InternetSetPerSiteCookieDecisionA", 2);
            self.add("InternetSetPerSiteCookieDecisionW", 2);
        self.add("InternetSetStatusCallback", 2);
        self.add("InternetShowSecurityInfoByURL", 2);
        self.add("InternetStatusCallback", 5);
        self.add("InternetTimeFromSystemTime", 4);
        self.add("InternetTimeFromSystemTimeA", 4);
        self.add("InternetTimeFromSystemTimeW", 4);
        self.add("InternetTimeToSystemTime", 3);
        self.add("InternetTimeToSystemTimeA", 3);
        self.add("InternetTimeToSystemTimeW", 3);
        self.add("InternetUnlockRequestFile", 1);
        self.add("InternetWriteFile", 4);
        self.add("InternetWriteFileEx", 4);
        self.add("IntersectClipRect", 5);
        self.add("IntersectRect", 3);
        self.add("IntlStrEqN", 3);
        self.add("IntlStrEqNI", 3);
        self.add("IntlStrEqWorker", 4);
        self.add("IntlStrEqWorkerA", 4);
        self.add("IntlStrEqWorkerW", 4);
        self.add("InvalidateRect", 3);
        self.add("InvalidateRgn", 3);
        self.add("InvertRect", 2);
        self.add("InvertRgn", 2);
        self.add("IoAcquireCancelSpinLock", 1);
        self.add("IoAcquireKsrPersistentMemory", 4);
        self.add("IoAcquireKsrPersistentMemoryEx", 7);
        self.add("IoAcquireVpbSpinLock", 1);
        self.add("IoAllocateDriverObjectExtension", 4);
        self.add("IoAllocateErrorLogEntry", 2);
        self.add("IoAllocateIrp", 2);
        self.add("IoAllocateIrpEx", 3);
        self.add("IoAllocateMdl", 5);
        self.add("IoAllocateWorkItem", 1);
        self.add("IoAttachDevice", 3);
        self.add("IoAttachDeviceToDeviceStack", 2);
        self.add("IoBuildAsynchronousFsdRequest", 6);
        self.add("IoBuildDeviceIoControlRequest", 9);
        self.add("IoBuildPartialMdl", 4);
        self.add("IoBuildSynchronousFsdRequest", 7);
        self.add("IoCancelIrp", 1);
        self.add("IoCheckDesiredAccess", 2);
        self.add("IoCheckEaBufferValidity", 3);
        self.add("IoCheckFunctionAccess", 6);
        self.add("IoCheckLinkShareAccess", 6);
        self.add("IoCheckQuerySetFileInformation", 3);
            self.add("IoCheckQuerySetVolumeInformation", 3);
        self.add("IoCheckQuotaBufferValidity", 3);
        self.add("IoCheckShareAccess", 5);
        self.add("IoCheckShareAccessEx", 6);
        self.add("IoCompletionRoutine", 3);
        self.add("IoConnectInterrupt", 11);
        self.add("IoConnectInterruptEx", 1);
            self.add("IoCopyCurrentIrpStackLocationToNext", 1);
        self.add("IoCreateDevice", 7);
        self.add("IoCreateFile", 14);
        self.add("IoCreateNotificationEvent", 2);
        self.add("IoCreateStreamFileObject", 2);
        self.add("IoCreateStreamFileObjectEx2", 5);
        self.add("IoCreateStreamFileObjectEx", 3);
        self.add("IoCreateStreamFileObjectLite", 2);
        self.add("IoCreateSymbolicLink", 2);
        self.add("IoCreateSynchronizationEvent", 2);
        self.add("IoCreateSystemThread", 8);
        self.add("IoCreateUnprotectedSymbolicLink", 2);
        self.add("IoCsqAcquireLock", 2);
        self.add("IoCsqCompleteCanceledIrp", 2);
        self.add("IoCsqInitialize", 7);
        self.add("IoCsqInitializeEx", 7);
        self.add("IoCsqInsertIrp", 2);
        self.add("IoCsqInsertIrp", 3);
        self.add("IoCsqInsertIrpEx", 3);
        self.add("IoCsqInsertIrpEx", 4);
        self.add("IoCsqPeekNextIrp", 3);
        self.add("IoCsqReleaseLock", 2);
        self.add("IoCsqRemoveIrp", 2);
        self.add("IoCsqRemoveNextIrp", 2);
        self.add("ioctlsocket", 3);
        self.add("IoDeleteDevice", 1);
        self.add("IoDeleteSymbolicLink", 1);
        self.add("IoDetachDevice", 1);
        self.add("IoDisconnectInterrupt", 1);
        self.add("IoDisconnectInterruptEx", 1);
        self.add("IoDpcRoutine", 4);
        self.add("IoEnumerateDeviceObjectList", 4);
            self.add("IoEnumerateKsrPersistentMemoryEx", 5);
            self.add("IoEnumerateRegisteredFiltersList", 3);
        self.add("IoFastQueryNetworkAttributes", 5);
        self.add("IofCallDriver", 2);
        self.add("IofCompleteRequest", 2);
        self.add("IoForwardIrpSynchronously", 2);
        self.add("IoFreeErrorLogEntry", 1);
        self.add("IoFreeIrp", 1);
        self.add("IoFreeKsrPersistentMemory", 1);
        self.add("IoFreeMdl", 1);
        self.add("IoFreeWorkItem", 1);
        self.add("IoGetAffinityInterrupt", 2);
        self.add("IoGetAttachedDevice", 1);
        self.add("IoGetAttachedDeviceReference", 1);
        self.add("IoGetBaseFileSystemDeviceObject", 1);
        self.add("IoGetBootDiskInformation", 2);
        self.add("IoGetContainerInformation", 4);
        self.add("IoGetCurrentIrpStackLocation", 1);
        self.add("IoGetCurrentProcess", 1);
        self.add("IoGetDeviceAttachmentBaseRef", 1);
        self.add("IoGetDeviceDirectory", 5);
        self.add("IoGetDeviceInterfaceAlias", 3);
            self.add("IoGetDeviceInterfacePropertyData", 8);
        self.add("IoGetDeviceInterfaces", 4);
        self.add("IoGetDeviceNumaNode", 2);
        self.add("IoGetDeviceObjectPointer", 4);
        self.add("IoGetDeviceProperty", 5);
        self.add("IoGetDevicePropertyData", 8);
        self.add("IoGetDeviceToVerify", 1);
        self.add("IoGetDiskDeviceObject", 2);
        self.add("IoGetDmaAdapter", 3);
        self.add("IoGetDriverDirectory", 4);
        self.add("IoGetDriverObjectExtension", 2);
        self.add("IoGetInitialStack", 1);
        self.add("IoGetIommuInterface", 2);
        self.add("IoGetIommuInterfaceEx", 3);
        self.add("IoGetIoPriorityHint", 1);
        self.add("IoGetLowerDeviceObject", 1);
        self.add("IoGetNextIrpStackLocation", 1);
        self.add("IoGetRelatedDeviceObject", 1);
        self.add("IoGetRemainingStackSize", 1);
        self.add("IoGetRequestorProcess", 1);
        self.add("IoGetRequestorProcessId", 1);
        self.add("IoGetRequestorSessionId", 2);
        self.add("IoGetStackLimits", 2);
        self.add("IoGetTopLevelIrp", 1);
        self.add("IoInitializeDpcRequest", 2);
        self.add("IoInitializeIrp", 3);
        self.add("IoInitializePriorityInfo", 1);
        self.add("IoInitializeTimer", 3);
        self.add("IoInitializeWorkItem", 2);
        self.add("IoInvalidateDeviceRelations", 2);
        self.add("IoInvalidateDeviceState", 1);
        self.add("IoIs32bitProcess", 1);
        self.add("IoIsOperationSynchronous", 1);
        self.add("IoIsSystemThread", 1);
        self.add("IoIsValidNameGraftingBuffer", 2);
        self.add("IoIsWdmVersionAvailable", 2);
        self.add("IoMarkIrpPending", 1);
        self.add("IommuDeviceCreate", 3);
        self.add("IommuDeviceDelete", 1);
        self.add("IommuDeviceFaultHandler", 2);
        self.add("IommuDeviceQueryDomainTypes", 2);
        self.add("IommuDomainAttachDevice", 4);
        self.add("IommuDomainAttachDeviceEx", 2);
        self.add("IommuDomainConfigure", 2);
        self.add("IommuDomainCreate", 2);
        self.add("IommuDomainCreateEx", 5);
        self.add("IommuDomainDelete", 1);
        self.add("IommuDomainDetachDevice", 3);
        self.add("IommuDomainDetachDeviceEx", 1);
        self.add("IommuFlushDomain", 1);
        self.add("IommuFlushDomainVaList", 4);
            self.add("IommuFreeReservedLogicalAddressRange", 1);
            self.add("IommuInterfaceStateChangeCallback", 2);
        self.add("IommuMapIdentityRange", 3);
        self.add("IommuMapIdentityRangeEx", 3);
        self.add("IommuMapLogicalRange", 4);
        self.add("IommuMapLogicalRangeEx", 7);
        self.add("IommuMapReservedLogicalRange", 5);
        self.add("IommuQueryInputMappings", 4);
            self.add("IommuRegisterInterfaceStateChangeCallback", 4);
        self.add("IommuReserveLogicalAddressRange", 6);
        self.add("IommuSetDeviceFaultReporting", 4);
        self.add("IommuSetDeviceFaultReportingEx", 4);
        self.add("IommuUnmapIdentityRange", 2);
        self.add("IommuUnmapIdentityRangeEx", 2);
        self.add("IommuUnmapLogicalRange", 3);
        self.add("IommuUnmapReservedLogicalRange", 1);
            self.add("IommuUnregisterInterfaceStateChangeCallback", 2);
            self.add("IoOpenDeviceInterfaceRegistryKey", 3);
        self.add("IoOpenDeviceRegistryKey", 4);
        self.add("IoOpenDriverRegistryKey", 5);
        self.add("IoPageRead", 5);
        self.add("IoQueryFileDosDeviceName", 2);
        self.add("IoQueryFileInformation", 5);
        self.add("IoQueryKsrPersistentMemorySize", 3);
            self.add("IoQueryKsrPersistentMemorySizeEx", 6);
        self.add("IoQueryVolumeInformation", 5);
        self.add("IoQueueThreadIrp", 1);
        self.add("IoQueueWorkItem", 4);
        self.add("IoQueueWorkItemEx", 4);
        self.add("IoRegisterContainerNotification", 5);
        self.add("IoRegisterDeviceInterface", 4);
        self.add("IoRegisterFileSystem", 1);
        self.add("IoRegisterFsRegistrationChange", 2);
            self.add("IoRegisterFsRegistrationChangeEx", 2);
            self.add("IoRegisterFsRegistrationChangeMountAware", 3);
            self.add("IoRegisterLastChanceShutdownNotification", 1);
        self.add("IoRegisterPlugPlayNotification", 7);
        self.add("IoRegisterShutdownNotification", 1);
        self.add("IoReleaseCancelSpinLock", 1);
        self.add("IoReleaseVpbSpinLock", 1);
        self.add("IoRemoveLinkShareAccess", 3);
        self.add("IoRemoveShareAccess", 2);
        self.add("IoReplaceFileObjectName", 3);
        self.add("IoReportInterruptActive", 1);
        self.add("IoReportInterruptInactive", 1);
        self.add("IoReportTargetDeviceChange", 2);
            self.add("IoReportTargetDeviceChangeAsynchronous", 4);
        self.add("IoRequestDeviceEject", 1);
        self.add("IoRequestDpc", 3);
        self.add("IoReserveKsrPersistentMemory", 5);
        self.add("IoReserveKsrPersistentMemoryEx", 8);
        self.add("IoReuseIrp", 2);
        self.add("IoSessionNotificationFunction", 6);
        self.add("IoSetCancelRoutine", 2);
        self.add("IoSetCompletionRoutine", 6);
        self.add("IoSetCompletionRoutineEx", 7);
            self.add("IoSetDeviceInterfacePropertyData", 7);
        self.add("IoSetDeviceInterfaceState", 2);
        self.add("IoSetDevicePropertyData", 7);
        self.add("IoSetDeviceToVerify", 2);
        self.add("IoSetInformation", 4);
        self.add("IoSetIoPriorityHint", 2);
        self.add("IoSetLinkShareAccess", 6);
        self.add("IoSetNextIrpStackLocation", 1);
        self.add("IoSetShareAccess", 4);
        self.add("IoSetShareAccessEx", 5);
        self.add("IoSetStartIoAttributes", 3);
        self.add("IoSetTopLevelIrp", 1);
        self.add("IoSizeofWorkItem", 1);
        self.add("IoStartNextPacket", 2);
        self.add("IoStartNextPacketByKey", 3);
        self.add("IoStartPacket", 4);
        self.add("IoStartTimer", 1);
        self.add("IoStopTimer", 1);
        self.add("IoSynchronousPageWrite", 5);
        self.add("IoThreadToProcess", 1);
        self.add("IoTimerRoutine", 2);
        self.add("IoUninitializeWorkItem", 1);
            self.add("IoUnregisterContainerNotification", 1);
        self.add("IoUnregisterFileSystem", 1);
            self.add("IoUnregisterFsRegistrationChange", 2);
            self.add("IoUnregisterPlugPlayNotification", 1);
            self.add("IoUnregisterPlugPlayNotificationEx", 1);
            self.add("IoUnregisterShutdownNotification", 1);
        self.add("IoUpdateLinkShareAccess", 3);
        self.add("IoUpdateLinkShareAccessEx", 4);
        self.add("IoUpdateShareAccess", 2);
        self.add("IoValidateDeviceIoControlAccess", 2);
        self.add("IoVerifyVolume", 2);
        self.add("IoWithinStackLimits", 2);
        self.add("IoWMIAllocateInstanceIds", 3);
        self.add("IoWMIDeviceObjectToInstanceName", 3);
        self.add("IoWMIDeviceObjectToProviderId", 1);
        self.add("IoWMIExecuteMethod", 6);
        self.add("IoWMIHandleToInstanceName", 3);
        self.add("IoWMIOpenBlock", 3);
        self.add("IoWMIQueryAllData", 3);
        self.add("IoWMIQueryAllDataMultiple", 4);
        self.add("IoWMIQuerySingleInstance", 4);
            self.add("IoWMIQuerySingleInstanceMultiple", 5);
        self.add("IoWMIRegistrationControl", 2);
        self.add("IoWMISetNotificationCallback", 3);
        self.add("IoWMISetSingleInstance", 5);
        self.add("IoWMISetSingleItem", 6);
        self.add("IoWMISuggestInstanceName", 4);
        self.add("IoWMIWriteEvent", 1);
        self.add("IoWorkitemRoutine", 2);
        self.add("IoWorkitemRoutineEx", 3);
        self.add("IoWriteErrorLogEntry", 1);
        self.add("IoWriteKsrPersistentMemory", 3);
        self.add("IpReleaseAddress", 1);
        self.add("IpRenewAddress", 1);
        self.add("I_RpcAllocate", 1);
        self.add("I_RpcAsyncAbortCall", 2);
        self.add("I_RpcAsyncSetHandle", 2);
        self.add("I_RpcBindingCopy", 2);
        self.add("I_RpcBindingCreateNP", 4);
        self.add("I_RpcBindingHandleToAsyncHandle", 2);
        self.add("I_RpcBindingInqDynamicEndpoint", 2);
        self.add("I_RpcBindingInqLocalClientPID", 2);
        self.add("I_RpcBindingInqMarshalledTargetInfo", 3);
        self.add("I_RpcBindingInqSecurityContext", 2);
        self.add("I_RpcBindingInqSecurityContextKeyInfo", 2);
        self.add("I_RpcBindingInqTransportType", 2);
        self.add("I_RpcBindingInqWireIdForSnego", 2);
        self.add("I_RpcBindingIsClientLocal", 2);
        self.add("I_RpcBindingToStaticStringBindingW", 2);
        self.add("I_RpcClearMutex", 1);
        self.add("I_RpcConnectionInqSockBuffSize", 2);
        self.add("I_RpcConnectionSetSockBuffSize", 2);
        self.add("I_RpcDeleteMutex", 1);
        self.add("I_RpcFree", 1);
        self.add("I_RpcFreeBuffer", 1);
        self.add("I_RpcFreePipeBuffer", 1);
        self.add("I_RpcGetBuffer", 1);
        self.add("I_RpcGetBufferWithObject", 2);
        self.add("I_RpcGetCurrentCallHandle", 0);
        self.add("I_RpcGetExtendedError", 0);
        self.add("I_RpcIfInqTransferSyntaxes", 4);
        self.add("I_RpcMapWin32Status", 1);
        self.add("I_RpcMgmtEnableDedicatedThreadPool", 0);
        self.add("I_RpcNegotiateTransferSyntax", 1);
        self.add("I_RpcNsBindingSetEntryName", 3);
        self.add("I_RpcNsInterfaceExported", 3);
        self.add("I_RpcNsInterfaceUnexported", 3);
        self.add("I_RpcOpenClientProcess", 3);
        self.add("I_RpcPauseExecution", 1);
        self.add("I_RpcReallocPipeBuffer", 2);
        self.add("I_RpcReceive", 2);
        self.add("I_RpcRecordCalloutFailure", 3);
        self.add("I_RpcRequestMutex", 1);
        self.add("I_RpcSend", 1);
        self.add("I_RpcSendReceive", 1);
        self.add("I_RpcServerCheckClientRestriction", 1);
        self.add("I_RpcServerInqAddressChangeFn", 0);
        self.add("I_RpcServerInqLocalConnAddress", 4);
        self.add("I_RpcServerInqRemoteConnAddress", 4);
        self.add("I_RpcServerInqTransportType", 1);
        self.add("I_RpcServerRegisterForwardFunction", 1);
        self.add("I_RpcServerSetAddressChangeFn", 1);
        self.add("I_RpcServerStartService", 3);
        self.add("I_RpcServerUseProtseq2", 5);
        self.add("I_RpcServerUseProtseqEp2", 6);
        self.add("I_RpcSessionStrictContextHandle", 0);
        self.add("I_RpcSsDontSerializeContext", 0);
        self.add("I_RpcTurnOnEEInfoPropagation", 0);
        self.add("IsAccelerator", 4);
        self.add("isalnum", 1);
        self.add("isalnum_l", 2);
        self.add("isalpha", 1);
        self.add("isalpha_l", 2);
        self.add("IsAlreadyGenuine", 0);
        self.add("IsAppThemed", 0);
        self.add("isascii", 1);
        self.add("IsAsyncMoniker", 1);
        self.add("isatty", 1);
        self.add("IsBadCodePtr", 1);
        self.add("IsBadReadPtr", 2);
        self.add("IsBadStringPtr", 2);
        self.add("IsBadWritePtr", 2);
        self.add("IsCalendarLeapYear", 3);
        self.add("IsCatalogFile", 2);
        self.add("IsCharAlpha", 1);
        self.add("IsCharAlphaNumeric", 1);
        self.add("IsCharAlphaNumericWrapW", 1);
        self.add("IsCharLower", 1);
        self.add("IsCharSpace", 1);
        self.add("IsCharSpaceA", 1);
        self.add("IsCharSpaceW", 1);
        self.add("IsCharUpper", 1);
        self.add("IsChild", 2);
        self.add("IsClipboardFormatAvailable", 1);
        self.add("iscntrl", 1);
        self.add("iscntrl_l", 2);
        self.add("IsColorProfileTagPresent", 3);
        self.add("IsColorProfileValid", 2);
        self.add("IsCompositionActive", 0);
        self.add("iscsym", 1);
        self.add("iscsymf", 1);
        self.add("isctype", 2);
        self.add("isctype_l", 3);
        self.add("IsDBCSLeadByte", 1);
        self.add("IsDBCSLeadByteEx", 2);
        self.add("IsDebuggerPresent", 0);
        self.add("IsDestinationReachable", 2);
        self.add("IsDialogMessage", 2);
        self.add("IsDialogMessageA", 2);
        self.add("IsDialogMessageW", 2);
        self.add("isdigit", 1);
        self.add("isdigit_l", 2);
        self.add("IsDlgButtonChecked", 2);
        self.add("IsDomainLegalCookieDomain", 2);
        self.add("IsElevationRequired", 1);
        self.add("IsEqualGUID", 2);
        self.add("isgraph", 1);
        self.add("isgraph_l", 2);
        self.add("IsGUIThread", 1);
        self.add("IsHostInProxyBypassList", 3);
        self.add("IsHungAppWindow", 1);
        self.add("IsIconic", 1);
        self.add("IsImmersiveProcess", 1);
        self.add("IsInternetConnected", 0);
        self.add("IsInternetESCEnabled", 0);
        self.add("IsInternetESCEnabled", 1);
        self.add("isleadbyte", 1);
        self.add("isleadbyte_l", 2);
        self.add("IsListEmpty", 1);
        self.add("islower", 1);
        self.add("islower_l", 2);
        self.add("ismbbalnum", 1);
        self.add("ismbbalnum_l", 1);
        self.add("ismbbalpha", 1);
        self.add("ismbbalpha_l", 1);
        self.add("ismbbgraph", 1);
        self.add("ismbbgraph_l", 2);
        self.add("ismbbkalnum", 1);
        self.add("ismbbkalnum_l", 2);
        self.add("ismbbkana", 1);
        self.add("ismbbkana_l", 2);
        self.add("ismbbkprint", 1);
        self.add("ismbbkprint_l", 2);
        self.add("ismbbkpunct", 1);
        self.add("ismbbkpunct_l", 2);
        self.add("ismbblead", 1);
        self.add("ismbblead_l", 2);
        self.add("ismbbprint", 1);
        self.add("ismbbprint_l", 2);
        self.add("ismbbpunct", 1);
        self.add("ismbbpunct_l", 2);
        self.add("ismbbtrail", 1);
        self.add("ismbbtrail_l", 2);
        self.add("ismbcalnum", 1);
        self.add("ismbcalnum_l", 2);
        self.add("ismbcalpha", 1);
        self.add("ismbcalpha_l", 2);
        self.add("ismbcdigit", 1);
        self.add("ismbcdigit_l", 2);
        self.add("ismbcgraph", 1);
        self.add("ismbcgraph_l", 2);
        self.add("ismbchira", 1);
        self.add("ismbchira_l", 2);
        self.add("ismbckata", 1);
        self.add("ismbckata_l", 2);
        self.add("ismbcl0", 1);
        self.add("ismbcl0_l", 2);
        self.add("ismbcl1", 1);
        self.add("ismbcl1_l", 2);
        self.add("ismbcl2", 1);
        self.add("ismbcl2_l", 2);
        self.add("ismbclegal", 1);
        self.add("ismbclegal_l", 2);
        self.add("ismbclower", 1);
        self.add("ismbclower_l", 2);
        self.add("ismbcprint", 1);
        self.add("ismbcprint_l", 2);
        self.add("ismbcpunct", 1);
        self.add("ismbcpunct_l", 2);
        self.add("ismbcspace", 1);
        self.add("ismbcspace_l", 2);
        self.add("ismbcsymbol", 1);
        self.add("ismbcsymbol_l", 2);
        self.add("ismbcupper", 1);
        self.add("ismbcupper_l", 2);
        self.add("ismbslead", 2);
        self.add("ismbslead_l", 3);
        self.add("ismbstrail", 2);
        self.add("ismbstrail_l", 3);
        self.add("IsMenu", 1);
        self.add("IsMouseInPointerEnabled", 0);
        self.add("isnan", 1);
        self.add("IsNetDrive", 1);
        self.add("IsNetworkAlive", 1);
        self.add("IsNLSDefinedString", 5);
        self.add("IsNormalizedString", 3);
        self.add("IsOS", 1);
        self.add("isprint", 1);
        self.add("isprint_l", 2);
        self.add("IsProcessCritical", 2);
        self.add("IsProcessDPIAware", 0);
        self.add("IsProcessDPIAware", 1);
        self.add("IsProcessInJob", 3);
        self.add("IsProcessorFeaturePresent", 1);
        self.add("IsProfilesEnabled", 0);
        self.add("ispunct", 1);
        self.add("ispunct_l", 2);
        self.add("IsPwrHibernateAllowed", 0);
        self.add("IsPwrShutdownAllowed", 0);
        self.add("IsPwrSuspendAllowed", 0);
        self.add("IsRectEmpty", 1);
        self.add("IsSearchEnabled", 0);
        self.add("IsServerSideWindow", 1);
        self.add("IsSETEnabled", 0);
        self.add("isspace", 1);
        self.add("isspace_l", 2);
        self.add("IsSystemResumeAutomatic", 0);
        self.add("IsTextUnicode", 3);
        self.add("IsThemeActive", 0);
        self.add("IsThemeBackgroundPartiallyTransparent", 3);
        self.add("IsThemeDialogTextureEnabled", 1);
        self.add("IsThemePartDefined", 3);
        self.add("IsThreadAFiber", 0);
        self.add("IsThreadDesktopComposited", 0);
        self.add("IsThreadpoolTimerSet", 1);
        self.add("IsTokenRestricted", 1);
        self.add("IsTouchWindow", 2);
        self.add("IStream_Copy", 3);
        self.add("IStream_Read", 3);
        self.add("IStream_ReadPidl", 2);
        self.add("IStream_ReadStr", 2);
        self.add("IStream_ReadStrLong", 2);
        self.add("IStream_Reset", 1);
        self.add("IStream_Size", 2);
        self.add("IStream_Write", 3);
        self.add("IStream_WritePidl", 2);
        self.add("IStream_WriteStr", 2);
        self.add("IStream_WriteStrLong", 2);
        self.add("isupper", 1);
        self.add("isupper_l", 2);
        self.add("IsUrlCacheEntryExpired", 3);
        self.add("IsUserAnAdmin", 0);
        self.add("IsValidAcl", 1);
        self.add("IsValidCodePage", 1);
        self.add("IsValidLanguageGroup", 2);
        self.add("IsValidLocale", 2);
        self.add("IsValidLocaleName", 1);
        self.add("IsValidNLSVersion", 3);
        self.add("IsValidSecurityDescriptor", 1);
        self.add("IsValidSid", 1);
        self.add("IsValidURL", 3);
        self.add("IsVolumeSnapshotted", 3);
        self.add("IsVolumeSnapshottedInternal", 3);
        self.add("iswalnum", 1);
        self.add("iswalnum_l", 2);
        self.add("iswalpha", 1);
        self.add("iswalpha_l", 2);
        self.add("iswascii", 1);
        self.add("iswcntrl", 1);
        self.add("iswcntrl_l", 2);
        self.add("iswcsym", 1);
        self.add("iswcsymf", 1);
        self.add("iswcsymf_l", 2);
        self.add("iswcsym_l", 2);
        self.add("is_wctype", 2);
        self.add("iswctype", 2);
        self.add("iswctype_l", 3);
        self.add("iswdigit", 1);
        self.add("iswdigit_l", 2);
        self.add("IsWellKnownSid", 2);
        self.add("iswgraph", 1);
        self.add("iswgraph_l", 2);
        self.add("IsWindow", 1);
        self.add("IsWindowEnabled", 1);
        self.add("IsWindowInDestroy", 1);
        self.add("IsWindowUnicode", 1);
        self.add("IsWindowVisible", 1);
        self.add("IsWinEventHookInstalled", 1);
        self.add("iswlower", 1);
        self.add("iswlower_l", 2);
        self.add("IsWow64Message", 0);
        self.add("IsWow64Process", 2);
        self.add("iswprint", 1);
        self.add("iswprint_l", 2);
        self.add("iswpunct", 1);
        self.add("iswpunct_l", 2);
        self.add("iswspace", 1);
        self.add("iswspace_l", 2);
        self.add("iswupper", 1);
        self.add("iswupper_l", 2);
        self.add("iswxdigit", 1);
        self.add("iswxdigit_l", 2);
        self.add("isxdigit", 1);
        self.add("isxdigit_l", 2);
        self.add("IsZoomed", 1);
        self.add("itoa", 3);
        self.add("itoa_s", 4);
        self.add("itow", 3);
        self.add("itow_s", 4);
        self.add("IUnknown_AddRef_Proxy", 1);
        self.add("IUnknown_AtomicRelease", 1);
        self.add("IUnknown_GetSite", 3);
        self.add("IUnknown_GetWindow", 2);
        self.add("IUnknown_QueryInterface_Proxy", 3);
        self.add("IUnknown_QueryService", 4);
        self.add("IUnknown_Release_Proxy", 1);
        self.add("IUnknown_RemoveBackReferences", 1);
        self.add("IUnknown_Set", 2);
        self.add("IUnknown_SetSite", 2);
        self.add("IUnknown_TranslateAcceleratorGlobal", 2);
        self.add("IUnknown_TranslateAcceleratorIO", 2);
        self.add("I_UuidCreate", 1);
        self.add("j0", 1);
        self.add("j1", 1);
        self.add("JetAddColumn", 7);
        self.add("JetAttachDatabase2", 4);
        self.add("JetAttachDatabase", 3);
        self.add("JetBackup", 3);
        self.add("JetBackupInstance", 4);
        self.add("JetBeginExternalBackup", 1);
        self.add("JetBeginExternalBackupInstance", 2);
        self.add("JetBeginSession", 4);
        self.add("JetBeginTransaction", 1);
        self.add("JetBeginTransaction2", 2);
        self.add("JetBeginTransaction3", 3);
        self.add("JetCloseDatabase", 3);
        self.add("JetCloseFile", 1);
        self.add("JetCloseFileInstance", 2);
        self.add("JetCloseTable", 2);
        self.add("JetCommitTransaction", 2);
        self.add("JetCommitTransaction2", 4);
        self.add("JetCompact", 6);
        self.add("JetComputeStats", 2);
        self.add("JetCreateDatabase2", 5);
        self.add("JetCreateDatabase", 5);
        self.add("JetCreateIndex2", 4);
        self.add("JetCreateIndex3", 4);
        self.add("JetCreateIndex4", 4);
        self.add("JetCreateIndex", 7);
        self.add("JetCreateInstance", 2);
        self.add("JetCreateInstance2", 4);
        self.add("JetCreateTable", 6);
        self.add("JetCreateTableColumnIndex2", 3);
        self.add("JetCreateTableColumnIndex", 3);
        self.add("JetCreateTableColumnIndex3", 3);
        self.add("JetCreateTableColumnIndex4", 3);
        self.add("JetDefragment2", 7);
        self.add("JetDefragment3", 8);
        self.add("JetDefragment", 6);
        self.add("JetDelete", 2);
        self.add("JetDeleteColumn2", 4);
        self.add("JetDeleteColumn", 3);
        self.add("JetDeleteIndex", 3);
        self.add("JetDeleteTable", 3);
        self.add("JetDetachDatabase", 2);
        self.add("JetDetachDatabase2", 3);
        self.add("JetDupCursor", 4);
        self.add("JetDupSession", 2);
        self.add("JetEnableMultiInstance", 3);
        self.add("JetEndExternalBackup", 0);
        self.add("JetEndExternalBackupInstance", 1);
        self.add("JetEndExternalBackupInstance2", 2);
        self.add("JetEndSession", 2);
        self.add("JetEnumerateColumns", 10);
        self.add("JetEscrowUpdate", 9);
        self.add("JetExternalRestore2", 10);
        self.add("JetExternalRestore", 8);
        self.add("JetFreeBuffer", 1);
        self.add("JetGetAttachInfo", 3);
        self.add("JetGetAttachInfoInstance", 4);
        self.add("JetGetBookmark", 5);
        self.add("JetGetColumnInfo", 7);
        self.add("JetGetCurrentIndex", 4);
        self.add("JetGetCursorInfo", 5);
        self.add("JetGetDatabaseFileInfo", 4);
        self.add("JetGetDatabaseInfo", 5);
        self.add("JetGetErrorInfoW", 5);
        self.add("JetGetIndexInfo", 7);
        self.add("JetGetInstanceInfo", 2);
        self.add("JetGetInstanceMiscInfo", 4);
        self.add("JetGetLock", 3);
        self.add("JetGetLogInfo", 3);
        self.add("JetGetLogInfoInstance2", 5);
        self.add("JetGetLogInfoInstance", 4);
        self.add("JetGetLS", 4);
        self.add("JetGetObjectInfo", 8);
        self.add("JetGetRecordPosition", 4);
        self.add("JetGetRecordSize2", 4);
        self.add("JetGetRecordSize", 4);
        self.add("JetGetSecondaryIndexBookmark", 9);
        self.add("JetGetSessionParameter", 5);
        self.add("JetGetSystemParameter", 6);
        self.add("JetGetTableColumnInfo", 6);
        self.add("JetGetTableIndexInfo", 6);
        self.add("JetGetTableInfo", 5);
        self.add("JetGetThreadStats", 2);
        self.add("JetGetTruncateLogInfoInstance", 4);
        self.add("JetGetVersion", 2);
        self.add("JetGotoBookmark", 4);
        self.add("JetGotoPosition", 3);
        self.add("JetGotoSecondaryIndexBookmark", 7);
        self.add("JetGrowDatabase", 4);
        self.add("JetIdle", 2);
        self.add("JetIndexRecordCount", 4);
        self.add("JetInit", 1);
        self.add("JetInit2", 2);
        self.add("JetInit3", 3);
        self.add("JetIntersectIndexes", 5);
        self.add("JetMakeKey", 5);
        self.add("JetMove", 4);
        self.add("JetOpenDatabase", 5);
        self.add("JetOpenFile", 4);
        self.add("JetOpenFileInstance", 5);
        self.add("JetOpenTable", 7);
        self.add("JetOpenTemporaryTable", 2);
        self.add("JetOpenTemporaryTable2", 2);
        self.add("JetOpenTempTable2", 7);
        self.add("JetOpenTempTable3", 7);
        self.add("JetOpenTempTable", 6);
        self.add("JetOSSnapshotAbort", 2);
        self.add("JetOSSnapshotEnd", 2);
        self.add("JetOSSnapshotFreeze", 4);
        self.add("JetOSSnapshotGetFreezeInfo", 4);
        self.add("JetOSSnapshotPrepare", 2);
        self.add("JetOSSnapshotPrepareInstance", 3);
        self.add("JetOSSnapshotThaw", 2);
        self.add("JetOSSnapshotTruncateLog", 2);
        self.add("JetOSSnapshotTruncateLogInstance", 3);
        self.add("JetPrepareUpdate", 3);
        self.add("JetPrereadIndexRanges", 8);
        self.add("JetPrereadKeys", 7);
        self.add("JetReadFile", 4);
        self.add("JetReadFileInstance", 5);
        self.add("JetRegisterCallback", 6);
        self.add("JetRenameColumn", 5);
        self.add("JetRenameTable", 4);
        self.add("JetResetSessionContext", 1);
        self.add("JetResetTableSequential", 3);
        self.add("JetResizeDatabase", 5);
        self.add("JetRestore", 2);
        self.add("JetRestore2", 3);
        self.add("JetRestoreInstance", 4);
        self.add("JetRetrieveColumn", 8);
        self.add("JetRetrieveColumns", 4);
        self.add("JetRetrieveKey", 6);
        self.add("JetRollback", 2);
        self.add("JetSeek", 3);
        self.add("JetSetColumn", 7);
        self.add("JetSetColumnDefaultValue", 7);
        self.add("JetSetColumns", 4);
        self.add("JetSetCurrentIndex2", 4);
        self.add("JetSetCurrentIndex", 3);
        self.add("JetSetCurrentIndex3", 5);
        self.add("JetSetCurrentIndex4", 6);
        self.add("JetSetCursorFilter", 5);
        self.add("JetSetDatabaseSize", 4);
        self.add("JetSetIndexRange", 3);
        self.add("JetSetLS", 4);
        self.add("JetSetSessionContext", 2);
        self.add("JetSetSessionParameter", 4);
        self.add("JetSetSystemParameter", 5);
        self.add("JetSetTableSequential", 3);
        self.add("JetStopBackup", 0);
        self.add("JetStopBackupInstance", 1);
        self.add("JetStopService", 0);
        self.add("JetStopServiceInstance", 1);
        self.add("JetStopServiceInstance2", 1);
        self.add("JetTerm", 1);
        self.add("JetTerm2", 2);
        self.add("JetTruncateLog", 0);
        self.add("JetTruncateLogInstance", 1);
        self.add("JetUnregisterCallback", 4);
        self.add("JetUpdate2", 6);
        self.add("JetUpdate", 5);
        self.add("jn", 2);
        self.add("joyConfigChanged", 1);
        self.add("joyGetDevCaps", 3);
        self.add("joyGetNumDevs", 0);
        self.add("joyGetPos", 2);
        self.add("joyGetPosEx", 2);
        self.add("joyGetThreshold", 2);
        self.add("joyReleaseCapture", 1);
        self.add("joySetCapture", 4);
        self.add("joySetThreshold", 2);
        self.add("K32EmptyWorkingSet", 1);
        self.add("K32EnumDeviceDrivers", 3);
        self.add("K32EnumPageFiles", 2);
        self.add("K32EnumProcesses", 3);
        self.add("K32EnumProcessModules", 4);
        self.add("K32EnumProcessModulesEx", 5);
        self.add("K32GetDeviceDriverBaseName", 3);
        self.add("K32GetDeviceDriverFileName", 3);
        self.add("K32GetMappedFileName", 4);
        self.add("K32GetModuleBaseName", 4);
        self.add("K32GetModuleFileNameEx", 4);
        self.add("K32GetModuleInformation", 4);
        self.add("K32GetPerformanceInfo", 2);
        self.add("K32GetProcessImageFileName", 3);
        self.add("K32GetProcessMemoryInfo", 3);
        self.add("K32GetWsChanges", 3);
        self.add("K32GetWsChangesEx", 3);
        self.add("K32InitializeProcessForWsWatch", 1);
        self.add("K32QueryWorkingSet", 3);
        self.add("K32QueryWorkingSetEx", 3);
        self.add("kbhit", 0);
        self.add("KbugcheckCallbackRoutine", 2);
        self.add("KbugcheckReasonCallbackRoutine", 4);
        self.add("KdeferredRoutine", 4);
        self.add("KeAcquireGuardedMutex", 1);
        self.add("KeAcquireGuardedMutexUnsafe", 1);
        self.add("KeAcquireInStackQueuedSpinLock", 2);
            self.add("KeAcquireInStackQueuedSpinLockAtDpcLevel", 2);
            self.add("KeAcquireInStackQueuedSpinLockForDpc", 2);
        self.add("KeAcquireInterruptSpinLock", 1);
        self.add("KeAcquireSpinLockAtDpcLevel", 1);
        self.add("KeAcquireSpinLockForDpc", 1);
        self.add("KeAcquireSpinLockRaiseToDpc", 1);
        self.add("KeAddTriageDumpDataBlock", 3);
        self.add("KeAreAllApcsDisabled", 1);
        self.add("KeAreApcsDisabled", 1);
        self.add("KeAttachProcess", 1);
        self.add("KeBugCheckEx", 5);
        self.add("KeCancelTimer", 1);
        self.add("KeClearEvent", 1);
            self.add("KeConvertAuxiliaryCounterToPerformanceCounter", 3);
            self.add("KeConvertPerformanceCounterToAuxiliaryCounter", 3);
        self.add("KeDelayExecutionThread", 3);
        self.add("KeDeregisterBoundCallback", 1);
        self.add("KeDeregisterBugCheckCallback", 1);
            self.add("KeDeregisterBugCheckReasonCallback", 1);
        self.add("KeDeregisterNmiCallback", 1);
            self.add("KeDeregisterProcessorChangeCallback", 1);
        self.add("KeDetachProcess", 1);
        self.add("KeEnterCriticalRegion", 1);
        self.add("KeEnterGuardedRegion", 1);
        self.add("KeFlushIoBuffers", 3);
        self.add("KeFlushQueuedDpcs", 1);
        self.add("KefReleaseSpinLockFromDpcLevel", 1);
        self.add("KeGetCurrentIrql", 1);
        self.add("KeGetCurrentNodeNumber", 1);
        self.add("KeGetCurrentProcessorNumberEx", 1);
        self.add("KeGetCurrentThread", 1);
        self.add("KeGetProcessorIndexFromNumber", 1);
        self.add("KeGetProcessorNumberFromIndex", 2);
            self.add("KeGetRecommendedSharedDataAlignment", 1);
        self.add("KeInitializeCrashDumpHeader", 5);
        self.add("KeInitializeDeviceQueue", 1);
        self.add("KeInitializeDpc", 3);
        self.add("KeInitializeEvent", 3);
        self.add("KeInitializeGuardedMutex", 1);
        self.add("KeInitializeMutant", 2);
        self.add("KeInitializeMutex", 2);
        self.add("KeInitializeQueue", 2);
        self.add("KeInitializeSemaphore", 3);
        self.add("KeInitializeSpinLock", 1);
        self.add("KeInitializeThreadedDpc", 3);
        self.add("KeInitializeTimer", 1);
        self.add("KeInitializeTimerEx", 2);
        self.add("KeInsertByKeyDeviceQueue", 3);
        self.add("KeInsertDeviceQueue", 2);
        self.add("KeInsertHeadQueue", 2);
        self.add("KeInsertQueue", 2);
        self.add("KeInsertQueueDpc", 3);
        self.add("KeIpiGenericCall", 2);
        self.add("KeIsExecutingDpc", 1);
        self.add("KeLeaveCriticalRegion", 1);
        self.add("KeLeaveGuardedRegion", 1);
        self.add("KeLowerIrql", 1);
        self.add("KeMemoryBarrier", 1);
        self.add("KeQueryActiveGroupCount", 1);
        self.add("KeQueryActiveProcessorCount", 1);
        self.add("KeQueryActiveProcessorCountEx", 1);
        self.add("KeQueryActiveProcessors", 1);
            self.add("KeQueryAuxiliaryCounterFrequency", 1);
        self.add("KeQueryDpcWatchdogInformation", 1);
        self.add("KeQueryGroupAffinity", 1);
        self.add("KeQueryHighestNodeNumber", 1);
        self.add("KeQueryInterruptTime", 1);
        self.add("KeQueryInterruptTimePrecise", 1);
            self.add("KeQueryLogicalProcessorRelationship", 4);
        self.add("KeQueryMaximumGroupCount", 1);
        self.add("KeQueryMaximumProcessorCount", 1);
        self.add("KeQueryMaximumProcessorCountEx", 1);
        self.add("KeQueryNodeActiveAffinity2", 4);
        self.add("KeQueryNodeActiveAffinity", 3);
        self.add("KeQueryNodeActiveProcessorCount", 1);
            self.add("KeQueryNodeMaximumProcessorCount", 1);
        self.add("KeQueryPerformanceCounter", 1);
        self.add("KeQueryPriorityThread", 1);
        self.add("KeQueryRuntimeThread", 2);
        self.add("KeQuerySystemTime", 1);
        self.add("KeQuerySystemTimePrecise", 1);
        self.add("KeQueryTimeIncrement", 1);
        self.add("KeQueryTotalCycleTimeThread", 2);
        self.add("KeQueryUnbiasedInterruptTime", 1);
        self.add("KeRaiseIrqlToDpcLevel", 1);
        self.add("KeReadStateEvent", 1);
        self.add("KeReadStateMutant", 1);
        self.add("KeReadStateMutex", 1);
        self.add("KeReadStateQueue", 1);
        self.add("KeReadStateSemaphore", 1);
        self.add("KeReadStateTimer", 1);
        self.add("KeRegisterBoundCallback", 1);
        self.add("KeRegisterBugCheckCallback", 5);
            self.add("KeRegisterBugCheckReasonCallback", 4);
        self.add("KeRegisterNmiCallback", 2);
            self.add("KeRegisterProcessorChangeCallback", 3);
        self.add("KeReleaseGuardedMutex", 1);
        self.add("KeReleaseGuardedMutexUnsafe", 1);
        self.add("KeReleaseInStackQueuedSpinLock", 1);
            self.add("KeReleaseInStackQueuedSpinLockForDpc", 1);
            self.add("KeReleaseInStackQueuedSpinLockFromDpcLevel", 1);
        self.add("KeReleaseInterruptSpinLock", 2);
        self.add("KeReleaseMutant", 4);
        self.add("KeReleaseMutex", 2);
        self.add("KeReleaseQueuedSpinLock", 2);
        self.add("KeReleaseSemaphore", 4);
        self.add("KeReleaseSpinLockForDpc", 2);
        self.add("KeReleaseSpinLockFromDpcLevel", 1);
        self.add("KeRemoveByKeyDeviceQueue", 2);
        self.add("KeRemoveDeviceQueue", 1);
        self.add("KeRemoveEntryDeviceQueue", 2);
        self.add("KeRemoveQueue", 3);
        self.add("KeRemoveQueueDpc", 1);
        self.add("KeResetEvent", 1);
        self.add("KeRestoreExtendedProcessorState", 1);
        self.add("KeRestoreFloatingPointState", 1);
        self.add("KeRevertToUserAffinityThreadEx", 1);
            self.add("KeRevertToUserGroupAffinityThread", 1);
        self.add("KeRundownQueue", 1);
        self.add("KeSaveExtendedProcessorState", 2);
        self.add("KeSaveFloatingPointState", 1);
        self.add("KeSetCoalescableTimer", 5);
        self.add("KeSetEvent", 3);
        self.add("KeSetIdealProcessorThread", 2);
        self.add("KeSetImportanceDpc", 2);
        self.add("KeSetPriorityThread", 2);
        self.add("KeSetSystemAffinityThread", 1);
        self.add("KeSetSystemAffinityThreadEx", 1);
        self.add("KeSetSystemGroupAffinityThread", 2);
        self.add("KeSetTargetProcessorDpc", 2);
        self.add("KeSetTargetProcessorDpcEx", 2);
        self.add("KeSetTimer", 3);
        self.add("KeSetTimerEx", 4);
        self.add("KeShouldYieldProcessor", 1);
        self.add("KeStackAttachProcess", 2);
        self.add("KeStallExecutionProcessor", 1);
        self.add("KeSynchronizeExecution", 3);
        self.add("KeTestSpinLock", 1);
        self.add("KeTryToAcquireGuardedMutex", 1);
        self.add("KeTryToAcquireQueuedSpinLock", 2);
            self.add("KeTryToAcquireSpinLockAtDpcLevel", 1);
        self.add("KeUnstackDetachProcess", 1);
        self.add("keybd_event", 4);
        self.add("KillTimer", 2);
        self.add("KipiBroadcastWorker", 1);
        self.add("KmessageServiceRoutine", 3);
        self.add("KserviceRoutine", 2);
        self.add("KstartRoutine", 1);
        self.add("KsynchronizeRoutine", 1);
        self.add("KzLowerIrql", 1);
        self.add("KzRaiseIrql", 1);
        self.add("labs", 1);
        self.add("LargeIntegerToString", 6);
        self.add("LBItemFromPt", 3);
        self.add("lc_codepage_func", 0);
        self.add("lc_handle_func", 0);
        self.add("LCIDToLocaleName", 4);
        self.add("lclose", 1);
        self.add("LCMapString", 6);
        self.add("LCMapStringEx", 9);
        self.add("lcreat", 2);
        self.add("ldap_abandon", 2);
        self.add("ldap_add", 3);
        self.add("ldap_add_ext", 6);
        self.add("ldap_add_ext_s", 5);
        self.add("ldap_add_s", 3);
        self.add("ldap_bind", 4);
        self.add("ldap_bind_s", 4);
        self.add("ldap_check_filter", 2);
        self.add("ldap_close_extended_op", 2);
        self.add("ldap_compare", 4);
        self.add("ldap_compare_ext", 8);
        self.add("ldap_compare_ext_s", 7);
        self.add("ldap_compare_s", 4);
        self.add("ldap_connect", 2);
        self.add("ldap_conn_from_msg", 2);
        self.add("ldap_control_free", 1);
        self.add("ldap_controls_free", 1);
        self.add("ldap_count_entries", 2);
        self.add("ldap_count_references", 2);
        self.add("ldap_count_values", 1);
        self.add("ldap_count_values_len", 1);
        self.add("ldap_create_page_control", 5);
        self.add("ldap_create_sort_control", 4);
        self.add("ldap_create_vlv_control", 4);
        self.add("ldap_delete", 2);
        self.add("ldap_delete_ext", 5);
        self.add("ldap_delete_ext_s", 4);
        self.add("ldap_delete_s", 2);
        self.add("ldap_dn2ufn", 1);
        self.add("ldap_encode_sort_control", 4);
        self.add("ldap_err2string", 1);
        self.add("ldap_escape_filter_element", 4);
        self.add("ldap_explode_dn", 2);
        self.add("ldap_extended_operation", 6);
        self.add("ldap_extended_operation_s", 7);
        self.add("ldap_first_attribute", 3);
        self.add("ldap_first_entry", 2);
        self.add("ldap_first_reference", 2);
        self.add("ldap_get_dn", 2);
        self.add("LdapGetLastError", 0);
        self.add("ldap_get_next_page", 4);
        self.add("ldap_get_next_page_s", 6);
        self.add("ldap_get_option", 3);
        self.add("ldap_get_paged_count", 4);
        self.add("ldap_get_values", 3);
        self.add("ldap_get_values_len", 3);
        self.add("ldap_init", 2);
        self.add("LdapMapErrorToWin32", 1);
        self.add("ldap_memfree", 1);
        self.add("ldap_modify", 3);
        self.add("ldap_modify_ext", 6);
        self.add("ldap_modify_ext_s", 5);
        self.add("ldap_modify_s", 3);
        self.add("ldap_modrdn2", 4);
        self.add("ldap_modrdn2_s", 4);
        self.add("ldap_msgfree", 1);
        self.add("ldap_next_attribute", 3);
        self.add("ldap_next_entry", 2);
        self.add("ldap_next_reference", 2);
        self.add("ldap_open", 2);
        self.add("ldap_parse_extended_result", 5);
        self.add("ldap_parse_page_control", 4);
        self.add("ldap_parse_reference", 3);
        self.add("ldap_parse_result", 8);
        self.add("ldap_parse_sort_control", 4);
        self.add("ldap_parse_vlv_control", 6);
        self.add("ldap_rename_ext", 8);
        self.add("ldap_rename_ext_s", 7);
        self.add("ldap_result2error", 3);
        self.add("ldap_result", 5);
        self.add("ldap_sasl_bind", 7);
        self.add("ldap_sasl_bind_s", 7);
        self.add("ldap_search", 5);
        self.add("ldap_search_abandon_page", 2);
        self.add("ldap_search_ext", 10);
        self.add("ldap_search_ext_s", 10);
        self.add("ldap_search_init_page", 10);
        self.add("ldap_search_s", 6);
        self.add("ldap_search_st", 7);
        self.add("ldap_set_option", 3);
        self.add("ldap_simple_bind", 3);
        self.add("ldap_simple_bind_s", 3);
        self.add("ldap_sslinit", 3);
        self.add("ldap_ufn2dn", 2);
        self.add("ldap_unbind", 1);
        self.add("ldap_unbind_s", 1);
        self.add("LdapUnicodeToUTF8", 4);
        self.add("LdapUTF8ToUnicode", 4);
        self.add("ldap_value_free", 1);
        self.add("ldap_value_free_len", 1);
        self.add("ldexp", 2);
        self.add("ldiv", 2);
        self.add("LdrAccessResource", 4);
        self.add("LdrAddRefDll", 2);
        self.add("LdrDisableThreadCalloutsForDll", 1);
        self.add("LdrFindEntryForAddress", 2);
        self.add("LdrFindResourceDirectory_U", 4);
        self.add("LdrFindResource_U", 4);
        self.add("LdrGetDllHandle", 4);
        self.add("LdrGetDllHandleEx", 5);
        self.add("LdrGetProcedureAddress", 4);
        self.add("LdrInitializeThunk", 4);
        self.add("LdrLoadDll", 4);
        self.add("LdrLockLoaderLock", 3);
        self.add("LdrProcessRelocationBlock", 4);
        self.add("LdrQueryImageFileExecutionOptions", 6);
        self.add("LdrQueryProcessModuleInformation", 3);
        self.add("LdrRegisterDllNotification", 4);
        self.add("LdrRelocateImage", 5);
        self.add("LdrRelocateImageWithBias", 6);
        self.add("LdrResFindResourceDirectory", 7);
        self.add("LdrShutdownThread", 0);
        self.add("LdrUnloadAlternateResourceModule", 1);
        self.add("LdrUnloadDll", 1);
        self.add("LdrUnlockLoaderLock", 2);
        self.add("LdrUnregisterDllNotification", 1);
        self.add("LdrVerifyImageMatchesChecksum", 4);
        self.add("LdrVerifyMappedImageMatchesChecksum", 3);
        self.add("LeaveCriticalPolicySection", 1);
        self.add("LeaveCriticalSection", 1);
        self.add("LeaveCriticalSectionWhenCallbackReturns", 2);
        self.add("LegitCheck", 0);
        self.add("lfind", 5);
        self.add("lfind_s", 6);
        self.add("LHashValOfNameSys", 3);
        self.add("LHashValOfNameSysA", 3);
        self.add("LineDDA", 6);
        self.add("Lineddaproc", 3);
        self.add("LineTo", 3);
        self.add("LinkWindow_RegisterClass", 0);
        self.add("LinkWindow_UnregisterClass", 0);
        self.add("listen", 2);
        self.add("llseek", 3);
        self.add("LoadAccelerators", 2);
        self.add("LoadBitmap", 2);
        self.add("LoadBitmapA", 2);
        self.add("LoadBitmapW", 2);
        self.add("LoadCursor", 2);
        self.add("LoadCursorFromFile", 1);
        self.add("loaddll", 1);
        self.add("LoadIcon", 2);
        self.add("LoadIconMetric", 4);
        self.add("LoadIconWithScaleDown", 5);
        self.add("LoadIFilter", 3);
        self.add("LoadImage", 6);
        self.add("LoadKeyboardLayout", 2);
        self.add("LoadLibrary", 1);
        self.add("LoadLibraryA", 1);
        self.add("LoadLibraryEx", 3);
        self.add("LoadLibraryExA", 3);
        self.add("LoadLibraryExW", 3);
        self.add("LoadLibraryW", 1);
        self.add("LoadMenu", 2);
        self.add("LoadMenuIndirect", 1);
        self.add("LoadModule", 2);
        self.add("LoadPackagedLibrary", 2);
        self.add("LoadPerfCounterTextStrings", 2);
        self.add("LoadRegTypeLib", 5);
        self.add("LoadResource", 2);
        self.add("LoadString", 4);
        self.add("LoadStringByReference", 7);
        self.add("LoadTypeLib", 2);
        self.add("LoadTypeLibEx", 3);
        self.add("LoadUrlCacheContent", 0);
        self.add("LoadUserProfile", 2);
        self.add("LocalAlloc", 2);
        self.add("localeconv", 0);
        self.add("LocaleNameToLCID", 2);
        self.add("LocalFileTimeToFileTime", 2);
        self.add("LocalFlags", 1);
        self.add("LocalFree", 1);
        self.add("LocalHandle", 1);
        self.add("LocalLock", 1);
        self.add("LocalReAlloc", 3);
        self.add("LocalSize", 1);
        self.add("localtime", 1);
        self.add("localtime32", 1);
        self.add("localtime32_s", 2);
        self.add("localtime64", 1);
        self.add("localtime64_s", 2);
        self.add("LocalUnlock", 1);
        self.add("LocateCatalogs", 6);
        self.add("LocateExtendedFeature", 3);
        self.add("LocateLegacyContext", 2);
        self.add("LocateXStateFeature", 3);
        self.add("lock", 1);
        self.add("lock_file", 1);
        self.add("LockFile", 5);
        self.add("LockFileEx", 6);
        self.add("locking", 3);
        self.add("LockResource", 1);
        self.add("LockServiceDatabase", 1);
        self.add("LockSetForegroundWindow", 1);
        self.add("LockWindowUpdate", 1);
        self.add("LockWorkStation", 0);
        self.add("log", 1);
        self.add("log10", 1);
        self.add("log10f", 1);
        self.add("logb", 1);
        self.add("logf", 1);
        self.add("LogicalToPhysicalPoint", 2);
        self.add("LoginIScsiTarget", 13);
        self.add("LogonUser", 6);
        self.add("LogonUserEx", 10);
        self.add("LogonUserExExW", 11);
        self.add("LogoutIScsiTarget", 1);
        self.add("LogTailAdvanceFailure", 2);
        self.add("LookupAccountName", 7);
        self.add("LookupAccountNameLocal", 6);
        self.add("LookupAccountSid", 7);
        self.add("LookupAccountSidLocal", 6);
        self.add("LookupIconIdFromDirectory", 2);
        self.add("LookupIconIdFromDirectoryEx", 5);
        self.add("LookupPersistentTcpPortReservation", 3);
        self.add("LookupPersistentUdpPortReservation", 3);
        self.add("LookupPrivilegeDisplayName", 5);
        self.add("LookupPrivilegeName", 4);
        self.add("LookupPrivilegeValue", 3);
        self.add("LookupSecurityDescriptorParts", 7);
        self.add("lopen", 2);
        self.add("LPropCompareProp", 2);
        self.add("LPSAFEARRAY_Marshal", 4);
        self.add("LPSAFEARRAY_Size", 4);
        self.add("LPSAFEARRAY_Unmarshal", 4);
        self.add("LPSAFEARRAY_UserFree", 2);
        self.add("LPSAFEARRAY_UserMarshal", 3);
        self.add("LPSAFEARRAY_UserSize", 3);
        self.add("LPSAFEARRAY_UserUnmarshal", 3);
        self.add("LPtoDP", 3);
            self.add("LpwsaoverlappedCompletionRoutine", 4);
        self.add("lread", 3);
        self.add("LresultFromObject", 3);
        self.add("lrotl", 2);
        self.add("lrotr", 2);
        self.add("LsaAddAccountRights", 4);
        self.add("LsaCallAuthenticationPackage", 7);
        self.add("LsaClose", 1);
        self.add("LsaConnectUntrusted", 1);
        self.add("LsaCreateTrustedDomainEx", 5);
        self.add("LsaDeleteTrustedDomain", 2);
        self.add("LsaDeregisterLogonProcess", 1);
        self.add("LsaEnumerateAccountRights", 4);
        self.add("LsaEnumerateAccountsWithUserRight", 4);
        self.add("LsaEnumerateLogonSessions", 2);
        self.add("LsaEnumerateTrustedDomains", 5);
        self.add("LsaEnumerateTrustedDomainsEx", 5);
        self.add("LsaFreeMemory", 1);
        self.add("LsaFreeReturnBuffer", 1);
        self.add("LsaGetAppliedCAPIDs", 3);
        self.add("LsaGetLogonSessionData", 2);
        self.add("LsaLogonUser", 14);
        self.add("LsaLookupAuthenticationPackage", 3);
        self.add("LsaLookupClose", 1);
        self.add("LsaLookupFreeMemory", 1);
        self.add("LsaLookupGetDomainInfo", 3);
        self.add("LsaLookupNames2", 6);
        self.add("LsaLookupNames", 5);
        self.add("LsaLookupOpenLocalPolicy", 3);
        self.add("LsaLookupPrivilegeValue", 3);
        self.add("LsaLookupSids2", 6);
        self.add("LsaLookupSids", 5);
        self.add("LsaLookupTranslateNames", 6);
        self.add("LsaLookupTranslateSids", 5);
        self.add("LsaNtStatusToWinError", 1);
        self.add("LsaOpenPolicy", 4);
        self.add("LsaOpenSecret", 4);
        self.add("LsaOpenTrustedDomainByName", 4);
        self.add("LsaQueryCAPs", 4);
        self.add("LsaQueryDomainInformationPolicy", 3);
        self.add("LsaQueryForestTrustInformation", 3);
        self.add("LsaQueryInformationPolicy", 3);
        self.add("LsaQuerySecret", 5);
        self.add("LsaQueryTrustedDomainInfo", 4);
        self.add("LsaQueryTrustedDomainInfoByName", 4);
        self.add("LsaRegisterLogonProcess", 3);
        self.add("LsaRegisterPolicyChangeNotification", 2);
        self.add("LsaRemoveAccountRights", 5);
        self.add("LsaRetrievePrivateData", 3);
        self.add("LsaSetCAPs", 3);
        self.add("LsaSetDomainInformationPolicy", 3);
        self.add("LsaSetForestTrustInformation", 5);
        self.add("LsaSetInformationPolicy", 3);
        self.add("LsaSetSecret", 3);
        self.add("LsaSetTrustedDomainInfoByName", 4);
        self.add("LsaSetTrustedDomainInformation", 4);
        self.add("LsaStorePrivateData", 3);
        self.add("LsaUnregisterPolicyChangeNotification", 2);
        self.add("lsearch", 5);
        self.add("lsearch_s", 6);
        self.add("lseek", 3);
        self.add("lseeki64", 3);
        self.add("LsnBlockOffset", 1);
        self.add("LsnContainer", 1);
        self.add("LsnCreate", 3);
        self.add("LsnDecrement", 1);
        self.add("LsnEqual", 2);
        self.add("LsnGreater", 2);
        self.add("LsnIncrement", 1);
        self.add("LsnInvalid", 1);
        self.add("LsnLess", 2);
        self.add("LsnNull", 1);
        self.add("LsnRecordSequence", 1);
        self.add("lstrcat", 2);
        self.add("lstrcmp", 2);
        self.add("lstrcmpi", 2);
        self.add("lstrcpy", 2);
        self.add("lstrcpyn", 3);
        self.add("lstrlen", 1);
        self.add("ltoa", 3);
        self.add("ltoa_s", 4);
        self.add("ltow", 3);
        self.add("ltow_s", 4);
        self.add("lwrite", 3);
        self.add("LZClose", 1);
        self.add("LZCloseFile", 1);
        self.add("LZCopy", 2);
        self.add("LZCreateFileW", 4);
        self.add("LZDone", 0);
        self.add("LZInit", 1);
        self.add("LZOpenFile", 3);
        self.add("LZRead", 3);
        self.add("LZSeek", 3);
        self.add("LZStart", 0);
        self.add("MagGetColorEffect", 2);
        self.add("MagGetFullscreenColorEffect", 1);
        self.add("MagGetFullscreenTransform", 3);
        self.add("MagGetImageScalingCallback", 1);
        self.add("MagGetInputTransform", 3);
        self.add("MagGetWindowFilterList", 4);
        self.add("MagGetWindowSource", 2);
        self.add("MagGetWindowTransform", 2);
        self.add("MagInitialize", 0);
        self.add("MagSetColorEffect", 2);
        self.add("MagSetFullscreenColorEffect", 1);
        self.add("MagSetFullscreenTransform", 3);
        self.add("MagSetImageScalingCallback", 2);
        self.add("MagSetInputTransform", 3);
        self.add("MagSetWindowFilterList", 4);
        self.add("MagSetWindowSource", 2);
        self.add("MagSetWindowTransform", 2);
        self.add("MagShowSystemCursor", 1);
        self.add("MagUninitialize", 0);
        self.add("MakeAbsoluteSD", 11);
        self.add("MakeDragList", 1);
        self.add("makepath", 5);
        self.add("makepath_s", 6);
        self.add("MakeSelfRelativeSD", 3);
        self.add("MakeSignature", 4);
        self.add("MakeSureDirectoryPathExists", 1);
        self.add("malloc", 1);
        self.add("malloc_dbg", 4);
        self.add("MapAndLoad", 5);
        self.add("MapDebugInformation", 4);
        self.add("MapDialogRect", 2);
        self.add("MapFileAndCheckSum", 3);
        self.add("MapGenericMask", 2);
        self.add("MAPIAddress", 11);
        self.add("MAPIAdminProfiles", 2);
        self.add("MAPIAllocateBuffer", 2);
        self.add("MAPIAllocateMore", 3);
        self.add("MAPIDeInitIdle", 0);
        self.add("MAPIDeleteMail", 5);
        self.add("MAPIDetails", 5);
        self.add("MAPIFindNext", 7);
        self.add("MAPIFreeBuffer", 1);
        self.add("MAPIGetDefaultMalloc", 0);
        self.add("MAPIInitialize", 1);
        self.add("MAPIInitIdle", 1);
        self.add("MAPILogoff", 4);
        self.add("MAPILogon", 6);
        self.add("MAPILogonEx", 5);
        self.add("MAPIOpenFormMgr", 2);
        self.add("MAPIOpenLocalFormContainer", 1);
        self.add("MAPIReadMail", 6);
        self.add("MAPIResolveName", 6);
        self.add("MAPISaveMail", 6);
        self.add("MAPISendDocuments", 5);
        self.add("MAPISendMail", 5);
        self.add("MAPISendMailHelper", 5);
        self.add("MAPISendMailW", 5);
        self.add("MAPIUninitialize", 0);
        self.add("MapResourceToPolicy", 4);
        self.add("MapSecurityError", 1);
        self.add("MapStorageSCode", 1);
        self.add("MapUserPhysicalPages", 3);
        self.add("MapUserPhysicalPagesScatter", 3);
        self.add("MapViewOfFile", 5);
        self.add("MapViewOfFileEx", 6);
        self.add("MapViewOfFileExNuma", 7);
        self.add("MapViewOfFileFromApp", 4);
        self.add("MapVirtualKey", 2);
        self.add("MapVirtualKeyEx", 3);
        self.add("MapWin32ErrorToSTG", 1);
        self.add("MapWindowPoints", 4);
        self.add("MaskBlt", 12);
        self.add("matherr", 1);
        self.add("mbbtombc", 1);
        self.add("mbbtombc_l", 2);
        self.add("mbbtype", 2);
        self.add("mbbtype_l", 3);
        self.add("mbccpy", 2);
        self.add("mbccpy_l", 3);
        self.add("mbccpy_s", 4);
        self.add("mbccpy_s_l", 5);
        self.add("mbcjistojms", 1);
        self.add("mbcjistojms_l", 2);
        self.add("mbcjmstojis", 1);
        self.add("mbcjmstojis_l", 2);
        self.add("mbclen", 1);
        self.add("mbctohira", 1);
        self.add("mbctohira_l", 2);
        self.add("mbctokata", 1);
        self.add("mbctokata_l", 2);
        self.add("mbctolower", 1);
        self.add("mbctolower_l", 2);
        self.add("mbctombb", 1);
        self.add("mbctombb_l", 2);
        self.add("mbctoupper", 1);
        self.add("mbctoupper_l", 2);
        self.add("mb_cur_max", 0);
        self.add("mb_cur_max_func", 0);
        self.add("MB_GetString", 1);
        self.add("mblen", 2);
        self.add("mblen_l", 3);
        self.add("mbrlen", 3);
        self.add("mbrtowc", 4);
        self.add("mbsbtype", 2);
        self.add("mbsbtype_l", 3);
        self.add("mbscat", 2);
        self.add("mbscat_s", 3);
        self.add("mbschr", 2);
        self.add("mbschr_l", 3);
        self.add("mbscmp", 2);
        self.add("mbscoll", 2);
        self.add("mbscoll_l", 3);
        self.add("mbscpy", 2);
        self.add("mbscpy_s", 3);
        self.add("mbscspn", 2);
        self.add("mbscspn_l", 3);
        self.add("mbsdec", 2);
        self.add("mbsdec_l", 3);
        self.add("mbsdup", 1);
        self.add("mbsicmp", 2);
        self.add("mbsicmp_l", 3);
        self.add("mbsicoll", 2);
        self.add("mbsicoll_l", 3);
        self.add("mbsinc", 1);
        self.add("mbsinc_l", 2);
        self.add("mbslen", 1);
        self.add("mbslen_l", 2);
        self.add("mbslwr", 1);
        self.add("mbslwr_l", 2);
        self.add("mbslwr_s", 2);
        self.add("mbslwr_s_l", 3);
        self.add("mbsnbcat", 3);
        self.add("mbsnbcat_l", 4);
        self.add("mbsnbcat_s", 4);
        self.add("mbsnbcat_s_l", 5);
        self.add("mbsnbcmp", 3);
        self.add("mbsnbcmp_l", 4);
        self.add("mbsnbcnt", 2);
        self.add("mbsnbcnt_l", 3);
        self.add("mbsnbcoll", 3);
        self.add("mbsnbcoll_l", 4);
        self.add("mbsnbcpy", 3);
        self.add("mbsnbcpy_l", 4);
        self.add("mbsnbcpy_s", 4);
        self.add("mbsnbcpy_s_l", 5);
        self.add("mbsnbicmp", 3);
        self.add("mbsnbicoll", 3);
        self.add("mbsnbicoll_l", 4);
        self.add("mbsnbset", 3);
        self.add("mbsnbset_l", 4);
        self.add("mbsnbset_s", 4);
        self.add("mbsnbset_s_l", 5);
        self.add("mbsncat", 3);
        self.add("mbsncat_l", 4);
        self.add("mbsncat_s", 4);
        self.add("mbsncat_s_l", 5);
        self.add("mbsnccnt", 2);
        self.add("mbsnccnt_l", 3);
        self.add("mbsncmp", 3);
        self.add("mbsncmp_l", 4);
        self.add("mbsncoll", 3);
        self.add("mbsncoll_l", 4);
        self.add("mbsncpy", 3);
        self.add("mbsncpy_l", 4);
        self.add("mbsncpy_s", 4);
        self.add("mbsncpy_s_l", 5);
        self.add("mbsnextc", 1);
        self.add("mbsnextc_l", 2);
        self.add("mbsnicmp", 3);
        self.add("mbsnicmp_l", 4);
        self.add("mbsnicoll", 3);
        self.add("mbsnicoll_l", 4);
        self.add("mbsninc", 2);
        self.add("mbsninc_l", 3);
        self.add("mbsnlen", 2);
        self.add("mbsnlen_l", 3);
        self.add("mbsnset", 3);
        self.add("mbsnset_l", 4);
        self.add("mbsnset_s", 4);
        self.add("mbsnset_s_l", 5);
        self.add("mbspbrk", 2);
        self.add("mbspbrk_l", 3);
        self.add("mbsrchr", 2);
        self.add("mbsrchr_l", 3);
        self.add("mbsrev", 1);
        self.add("mbsrev_l", 2);
        self.add("mbsrtowcs", 4);
        self.add("mbsrtowcs_s", 6);
        self.add("mbsset", 2);
        self.add("mbsset_l", 3);
        self.add("mbsset_s", 3);
        self.add("mbsset_s_l", 4);
        self.add("mbsspn", 2);
        self.add("mbsspn_l", 3);
        self.add("mbsspnp", 2);
        self.add("mbsspnp_l", 3);
        self.add("mbsstr", 2);
        self.add("mbsstr_l", 3);
        self.add("mbstok", 2);
        self.add("mbstok_l", 3);
        self.add("mbstok_s", 3);
        self.add("mbstok_s_l", 4);
        self.add("mbstowcs", 3);
        self.add("mbstowcs_l", 4);
        self.add("mbstowcs_s", 5);
        self.add("mbstowcs_s_l", 6);
        self.add("mbstrlen", 1);
        self.add("mbstrlen_l", 2);
        self.add("mbstrnlen", 2);
        self.add("mbstrnlen_l", 3);
        self.add("mbsupr", 1);
        self.add("mbsupr_l", 2);
        self.add("mbsupr_s", 2);
        self.add("mbsupr_s_l", 3);
        self.add("mbtowc", 3);
        self.add("mbtowc_l", 4);
        self.add("McastApiCleanup", 0);
        self.add("McastApiStartup", 1);
        self.add("McastEnumerateScopes", 5);
        self.add("McastGenUID", 1);
        self.add("McastReleaseAddress", 3);
        self.add("McastRenewAddress", 4);
        self.add("McastRequestAddress", 5);
        self.add("mciExecute", 1);
        self.add("mciGetCreatorTask", 1);
        self.add("mciGetDeviceID", 1);
        self.add("mciGetDeviceIDFromElementID", 2);
        self.add("mciGetErrorString", 3);
        self.add("mciGetYieldProc", 2);
        self.add("mciSendCommand", 4);
        self.add("mciSendString", 4);
        self.add("mciSetYieldProc", 3);
        self.add("MCIWndCreate", 4);
        self.add("MCIWndRegisterClass", 1);
        self.add("memccpy", 4);
        self.add("memchr", 3);
        self.add("memcmp", 3);
        self.add("memcpy", 3);
        self.add("memcpy_s", 4);
        self.add("memicmp", 3);
        self.add("memicmp_l", 4);
        self.add("memmove", 3);
        self.add("memmove_s", 4);
        self.add("memset", 3);
        self.add("MenuHelp", 7);
        self.add("MenuItemFromPoint", 3);
        self.add("MergeVirtualDisk", 4);
        self.add("MesBufferHandleReset", 6);
        self.add("MesDecodeBufferHandleCreate", 3);
        self.add("MesDecodeIncrementalHandleCreate", 3);
        self.add("MesEncodeDynBufferHandleCreate", 3);
        self.add("MesEncodeFixedBufferHandleCreate", 4);
        self.add("MesEncodeIncrementalHandleCreate", 4);
        self.add("MesHandleFree", 1);
        self.add("MesIncrementalHandleReset", 6);
        self.add("MesInqProcEncodingId", 3);
        self.add("MessageBeep", 1);
        self.add("MessageBox", 4);
        self.add("MessageBoxA", 4);
        self.add("MessageBoxEx", 5);
        self.add("MessageBoxExA", 5);
        self.add("MessageBoxExW", 5);
        self.add("MessageBoxIndirect", 1);
        self.add("MessageBoxIndirectA", 1);
        self.add("MessageBoxIndirectW", 1);
        self.add("MessageBoxTimeout", 6);
        self.add("MessageBoxW", 4);
        self.add("MFAddPeriodicCallback", 3);
        self.add("MFAllocateSerialWorkQueue", 2);
        self.add("MFAllocateWorkQueue", 1);
        self.add("MFAllocateWorkQueueEx", 2);
        self.add("MFAverageTimePerFrameToFrameRate", 3);
        self.add("MFBeginCreateFile", 7);
        self.add("MFBeginRegisterWorkQueueWithMMCSS", 5);
        self.add("MFBeginRegisterWorkQueueWithMMCSSEx", 6);
        self.add("MFBeginUnregisterWorkQueueWithMMCSS", 3);
        self.add("MFCalculateBitmapImageSize", 4);
        self.add("MFCalculateImageSize", 4);
        self.add("MFCancelCreateFile", 1);
        self.add("MFCancelWorkItem", 1);
        self.add("MFCompareFullToPartialMediaType", 2);
        self.add("MFConvertColorInfoFromDXVA", 2);
        self.add("MFConvertColorInfoToDXVA", 2);
        self.add("MFConvertFromFP16Array", 3);
        self.add("MFConvertToFP16Array", 3);
        self.add("MFCopyImage", 6);
        self.add("MFCreate2DMediaBuffer", 5);
        self.add("MFCreate3GPMediaSink", 4);
        self.add("MFCreateAC3MediaSink", 3);
        self.add("MFCreateADTSMediaSink", 3);
        self.add("MFCreateAggregateSource", 2);
        self.add("MFCreateAlignedMemoryBuffer", 3);
        self.add("MFCreateAMMediaTypeFromMFMediaType", 3);
        self.add("MFCreateASFContentInfo", 1);
        self.add("MFCreateASFIndexer", 1);
        self.add("MFCreateASFIndexerByteStream", 3);
        self.add("MFCreateASFMediaSink", 2);
        self.add("MFCreateASFMediaSinkActivate", 3);
        self.add("MFCreateASFMultiplexer", 1);
        self.add("MFCreateASFProfile", 1);
        self.add("MFCreateASFProfileFromPresentationDescriptor", 2);
        self.add("MFCreateASFSplitter", 1);
        self.add("MFCreateASFStreamingMediaSink", 2);
        self.add("MFCreateASFStreamingMediaSinkActivate", 3);
        self.add("MFCreateASFStreamSelector", 2);
        self.add("MFCreateAsyncResult", 4);
        self.add("MFCreateAttributes", 2);
        self.add("MFCreateAudioMediaType", 2);
        self.add("MFCreateAudioRenderer", 2);
        self.add("MFCreateAudioRendererActivate", 1);
        self.add("MFCreateCaptureEngine", 1);
        self.add("MFCreateCollection", 1);
        self.add("MFCreateCredentialCache", 1);
        self.add("MFCreateDeviceSource", 2);
        self.add("MFCreateDeviceSourceActivate", 2);
        self.add("MFCreateDXGISurfaceBuffer", 5);
        self.add("MFCreateEventQueue", 1);
        self.add("MFCreateFile", 5);
        self.add("MFCreateFMPEG4MediaSink", 4);
        self.add("MFCreateLegacyMediaBufferOnMFMediaBuffer", 4);
        self.add("MFCreateMediaBufferFromMediaType", 5);
        self.add("MFCreateMediaBufferWrapper", 4);
        self.add("MFCreateMediaEvent", 5);
        self.add("MFCreateMediaExtensionActivate", 4);
        self.add("MFCreateMediaSession", 2);
        self.add("MFCreateMediaType", 1);
        self.add("MFCreateMediaTypeFromProperties", 2);
        self.add("MFCreateMediaTypeFromRepresentation", 3);
        self.add("MFCreateMemoryBuffer", 2);
        self.add("MFCreateMFByteStreamOnStream", 2);
        self.add("MFCreateMFByteStreamOnStreamEx", 2);
        self.add("MFCreateMFByteStreamWrapper", 2);
        self.add("MFCreateMFVideoFormatFromMFMediaType", 3);
        self.add("MFCreateMP3ByteStreamPlugin", 2);
        self.add("MFCreateMP3MediaSink", 2);
        self.add("MFCreateMPEG4MediaSink", 4);
        self.add("MFCreateMuxSink", 4);
        self.add("MFCreateNetSchemePlugin", 2);
        self.add("MFCreatePathFromURL", 2);
        self.add("MFCreatePMPMediaSession", 4);
        self.add("MFCreatePMPServer", 2);
        self.add("MFCreatePresentationClock", 1);
        self.add("MFCreatePresentationDescriptor", 3);
        self.add("MFCreatePresentationDescriptorFromASFProfile", 2);
        self.add("MFCreatePropertiesFromMediaType", 3);
        self.add("MFCreateProtectedEnvironmentAccess", 1);
        self.add("MFCreateProxyLocator", 3);
        self.add("MFCreateRemoteDesktopPlugin", 1);
        self.add("MFCreateSample", 1);
        self.add("MFCreateSampleCopierMFT", 1);
        self.add("MFCreateSampleGrabberSinkActivate", 3);
        self.add("MFCreateSequencerSegmentOffset", 3);
        self.add("MFCreateSequencerSource", 2);
        self.add("MFCreateSimpleTypeHandler", 1);
        self.add("MFCreateSinkWriterFromMediaSink", 3);
        self.add("MFCreateSinkWriterFromURL", 4);
        self.add("MFCreateSourceReaderFromByteStream", 3);
        self.add("MFCreateSourceReaderFromMediaSource", 3);
        self.add("MFCreateSourceReaderFromURL", 3);
        self.add("MFCreateSourceResolver", 1);
        self.add("MFCreateStandardQualityManager", 1);
        self.add("MFCreateStreamDescriptor", 4);
        self.add("MFCreateStreamOnMFByteStream", 2);
        self.add("MFCreateStreamOnMFByteStreamEx", 3);
        self.add("MFCreateSystemTimeSource", 1);
        self.add("MFCreateTempFile", 4);
        self.add("MFCreateTopoLoader", 1);
        self.add("MFCreateTopology", 1);
        self.add("MFCreateTopologyNode", 2);
        self.add("MFCreateTrackedSample", 1);
        self.add("MFCreateTranscodeProfile", 1);
        self.add("MFCreateTranscodeSinkActivate", 1);
        self.add("MFCreateTranscodeTopology", 4);
        self.add("MFCreateTranscodeTopologyFromByteStream", 4);
        self.add("MFCreateTransformActivate", 1);
        self.add("MFCreateURLFromPath", 2);
        self.add("MFCreateVideoMediaType", 2);
        self.add("MFCreateVideoMediaTypeFromBitMapInfoHeader", 9);
        self.add("MFCreateVideoMediaTypeFromBitMapInfoHeaderEx", 10);
        self.add("MFCreateVideoMediaTypeFromSubtype", 2);
        self.add("MFCreateVideoMediaTypeFromVideoInfoHeader2", 5);
        self.add("MFCreateVideoMediaTypeFromVideoInfoHeader", 8);
        self.add("MFCreateVideoRenderer", 2);
        self.add("MFCreateVideoRendererActivate", 2);
        self.add("MFCreateVideoSampleAllocatorEx", 2);
        self.add("MFCreateWaveFormatExFromMFMediaType", 4);
        self.add("MFCreateWICBitmapBuffer", 3);
        self.add("MFCreateWMAEncoderActivate", 3);
        self.add("MFCreateWMVEncoderActivate", 3);
        self.add("MFDeserializeAttributesFromStream", 3);
        self.add("MFDeserializePresentationDescriptor", 3);
        self.add("MFEndCreateFile", 2);
        self.add("MFEndRegisterWorkQueueWithMMCSS", 2);
        self.add("MFEndUnregisterWorkQueueWithMMCSS", 1);
        self.add("MFEnumDeviceSources", 3);
        self.add("Mfenumproc", 5);
        self.add("MFFrameRateToAverageTimePerFrame", 3);
        self.add("MFGetAttributesAsBlob", 3);
        self.add("MFGetAttributesAsBlobSize", 2);
        self.add("MFGetContentProtectionSystemCLSID", 2);
        self.add("MFGetLocalId", 3);
        self.add("MFGetMFTMerit", 4);
        self.add("MFGetPlaneSize", 4);
        self.add("MFGetPluginControl", 1);
        self.add("MFGetService", 4);
        self.add("MFGetStrideForBitmapInfoHeader", 3);
        self.add("MFGetSupportedMimeTypes", 1);
        self.add("MFGetSupportedSchemes", 1);
        self.add("MFGetSystemId", 1);
        self.add("MFGetSystemTime", 0);
        self.add("MFGetTimerPeriodicity", 1);
        self.add("MFGetTopoNodeCurrentType", 4);
        self.add("MFGetUncompressedVideoFormat", 1);
        self.add("MFGetWorkQueueMMCSSClass", 3);
        self.add("MFGetWorkQueueMMCSSPriority", 2);
        self.add("MFGetWorkQueueMMCSSTaskId", 2);
        self.add("MFHeapAlloc", 5);
        self.add("MFHeapFree", 1);
        self.add("MFInitAMMediaTypeFromMFMediaType", 3);
        self.add("MFInitAttributesFromBlob", 3);
        self.add("MFInitMediaTypeFromAMMediaType", 2);
        self.add("MFInitMediaTypeFromMFVideoFormat", 3);
        self.add("MFInitMediaTypeFromMPEG1VideoInfo", 4);
        self.add("MFInitMediaTypeFromMPEG2VideoInfo", 4);
        self.add("MFInitMediaTypeFromVideoInfoHeader2", 4);
        self.add("MFInitMediaTypeFromVideoInfoHeader", 4);
        self.add("MFInitMediaTypeFromWaveFormatEx", 3);
        self.add("MFInitVideoFormat", 2);
        self.add("MFInitVideoFormat_RGB", 4);
        self.add("MFInvokeCallback", 1);
        self.add("MFllMulDiv", 4);
        self.add("MFLoadSignedLibrary", 2);
        self.add("MFLockDXGIDeviceManager", 2);
        self.add("MFLockPlatform", 0);
        self.add("MFLockSharedWorkQueue", 4);
        self.add("MFLockWorkQueue", 1);
        self.add("MFMapDX9FormatToDXGIFormat", 1);
        self.add("MFMapDXGIFormatToDX9Format", 1);
        self.add("MFPCreateMediaPlayer", 6);
        self.add("MFPutWaitingWorkItem", 4);
        self.add("MFPutWorkItem2", 4);
        self.add("MFPutWorkItem", 3);
        self.add("MFPutWorkItemEx", 2);
        self.add("MFPutWorkItemEx2", 3);
        self.add("MFRegisterLocalByteStreamHandler", 3);
        self.add("MFRegisterLocalSchemeHandler", 2);
        self.add("MFRegisterPlatformWithMMCSS", 3);
        self.add("MFRemovePeriodicCallback", 1);
        self.add("MFRequireProtectedEnvironment", 1);
        self.add("MFScheduleWorkItem", 4);
        self.add("MFScheduleWorkItemEx", 3);
        self.add("MFSerializeAttributesToStream", 3);
        self.add("MFSerializePresentationDescriptor", 3);
        self.add("MFShutdown", 0);
        self.add("MFShutdownObject", 1);
        self.add("MFStartup", 2);
        self.add("MFTEnum", 7);
        self.add("MFTEnumEx", 6);
        self.add("MFTGetInfo", 7);
        self.add("MFTranscodeGetAudioOutputAvailableTypes", 4);
        self.add("MFTRegister", 9);
        self.add("MFTRegisterLocal", 8);
        self.add("MFTRegisterLocalByCLSID", 8);
        self.add("MFTUnregister", 1);
        self.add("MFTUnregisterLocal", 1);
        self.add("MFTUnregisterLocalByCLSID", 1);
        self.add("MFUnlockDXGIDeviceManager", 0);
        self.add("MFUnlockPlatform", 0);
        self.add("MFUnlockWorkQueue", 1);
        self.add("MFUnregisterPlatformFromMMCSS", 0);
        self.add("MFUnwrapMediaType", 2);
        self.add("MFValidateMediaTypeSize", 3);
        self.add("MFWrapMediaType", 4);
        self.add("midiConnect", 3);
        self.add("midiDisconnect", 3);
        self.add("midiInAddBuffer", 3);
        self.add("midiInClose", 1);
        self.add("midiInGetDevCaps", 3);
        self.add("midiInGetErrorText", 3);
        self.add("midiInGetID", 2);
        self.add("midiInGetNumDevs", 0);
        self.add("midiInMessage", 4);
        self.add("midiInOpen", 5);
        self.add("midiInPrepareHeader", 3);
        self.add("midiInReset", 1);
        self.add("midiInStart", 1);
        self.add("midiInStop", 1);
        self.add("midiInUnprepareHeader", 3);
        self.add("midiOutCacheDrumPatches", 4);
        self.add("midiOutCachePatches", 4);
        self.add("midiOutClose", 1);
        self.add("midiOutGetDevCaps", 3);
        self.add("midiOutGetErrorText", 3);
        self.add("midiOutGetID", 2);
        self.add("midiOutGetNumDevs", 0);
        self.add("midiOutGetVolume", 2);
        self.add("midiOutLongMsg", 3);
        self.add("midiOutMessage", 4);
        self.add("midiOutOpen", 5);
        self.add("midiOutPrepareHeader", 3);
        self.add("midiOutReset", 1);
        self.add("midiOutSetVolume", 2);
        self.add("midiOutShortMsg", 2);
        self.add("midiOutUnprepareHeader", 3);
        self.add("midiStreamClose", 1);
        self.add("midiStreamOpen", 6);
        self.add("midiStreamOut", 3);
        self.add("midiStreamPause", 1);
        self.add("midiStreamPosition", 3);
        self.add("midiStreamProperty", 3);
        self.add("midiStreamRestart", 1);
        self.add("midiStreamStop", 1);
        self.add("MIMEAssociationDialog", 6);
        self.add("MiniDumpReadDumpStream", 5);
        self.add("MiniDumpWriteDump", 7);
        self.add("MirrorIcon", 2);
        self.add("MirrorVirtualDisk", 4);
        self.add("mixerClose", 1);
        self.add("mixerGetControlDetails", 3);
        self.add("mixerGetDevCaps", 3);
        self.add("mixerGetID", 3);
        self.add("mixerGetLineControls", 3);
        self.add("mixerGetLineInfo", 3);
        self.add("mixerGetNumDevs", 0);
        self.add("mixerMessage", 4);
        self.add("mixerOpen", 5);
        self.add("mixerSetControlDetails", 3);
        self.add("mkdir", 1);
        self.add("mkgmtime", 1);
        self.add("mkgmtime32", 1);
        self.add("mkgmtime64", 1);
        self.add("MkParseDisplayName", 4);
        self.add("MkParseDisplayNameEx", 4);
        self.add("mktemp", 1);
        self.add("mktemp_s", 2);
        self.add("mktime", 1);
        self.add("mktime32", 1);
        self.add("mktime64", 1);
        self.add("MLFreeLibrary", 1);
        self.add("MLHtmlHelp", 5);
        self.add("MLLoadLibrary", 3);
        self.add("MLWinHelp", 4);
        self.add("MmAdvanceMdl", 2);
        self.add("MmAllocateContiguousMemory", 2);
        self.add("MmAllocateContiguousMemoryEx", 10);
            self.add("MmAllocateContiguousMemorySpecifyCache", 5);
            self.add("MmAllocateContiguousMemorySpecifyCacheNode", 6);
        self.add("MmAllocateContiguousNodeMemory", 6);
        self.add("MmAllocateMappingAddress", 2);
        self.add("MmAllocateMappingAddressEx", 3);
        self.add("MmAllocateMdlForIoSpace", 3);
        self.add("MmAllocateNodePagesForMdlEx", 7);
        self.add("MmAllocatePagesForMdl", 4);
        self.add("MmAllocatePagesForMdlEx", 6);
        self.add("MmBuildMdlForNonPagedPool", 1);
        self.add("MmCanFileBeTruncated", 2);
            self.add("MmDoesFileHaveUserWritableReferences", 1);
        self.add("mmDrvInstall", 4);
        self.add("MmFlushImageSection", 2);
        self.add("MmForceSectionClosed", 2);
        self.add("MmForceSectionClosedEx", 2);
        self.add("MmFreeContiguousMemory", 1);
            self.add("MmFreeContiguousMemorySpecifyCache", 3);
        self.add("MmFreeMappingAddress", 2);
        self.add("MmFreePagesFromMdl", 1);
        self.add("mmGetCurrentTask", 0);
        self.add("MmGetMaximumFileSectionSize", 1);
        self.add("MmGetSystemRoutineAddress", 1);
        self.add("MmGetSystemRoutineAddressEx", 2);
        self.add("mmioAdvance", 3);
        self.add("mmioAscend", 3);
        self.add("mmioClose", 2);
        self.add("mmioCreateChunk", 3);
        self.add("mmioDescend", 4);
        self.add("mmioFlush", 2);
        self.add("mmioGetInfo", 3);
        self.add("mmioInstallIOProc", 3);
        self.add("mmioOpen", 3);
        self.add("mmioRead", 3);
        self.add("mmioRename", 4);
        self.add("mmioSeek", 3);
        self.add("mmioSendMessage", 4);
        self.add("mmioSetBuffer", 4);
        self.add("mmioSetInfo", 3);
        self.add("mmioStringToFOURCC", 2);
        self.add("mmioWrite", 3);
        self.add("MmIsDriverSuspectForVerifier", 1);
        self.add("MmIsDriverVerifying", 1);
        self.add("MmIsDriverVerifyingByAddress", 1);
        self.add("MmIsRecursiveIoFault", 1);
        self.add("MmLockPagableDataSection", 1);
        self.add("MmMapIoSpace", 3);
        self.add("MmMapIoSpaceEx", 3);
        self.add("MmMapLockedPages", 3);
        self.add("MmMapLockedPagesSpecifyCache", 7);
            self.add("MmMapLockedPagesWithReservedMapping", 4);
        self.add("MmMapMdl", 4);
        self.add("MmMapMemoryDumpMdlEx", 4);
        self.add("MmMdlRoutine", 2);
        self.add("MmPageEntireDriver", 1);
        self.add("MmPrefetchPages", 2);
        self.add("MmProbeAndLockPages", 3);
        self.add("MmProbeAndLockSelectedPages", 4);
        self.add("MmProtectDriverSection", 3);
        self.add("MmProtectMdlSystemAddress", 2);
        self.add("MmQuerySystemSize", 1);
        self.add("MmResetDriverPaging", 1);
        self.add("MmSetAddressRangeModified", 2);
        self.add("MmSizeOfMdl", 2);
        self.add("mmTaskBlock", 1);
        self.add("mmTaskCreate", 3);
        self.add("mmTaskSignal", 1);
        self.add("mmTaskYield", 0);
        self.add("MmUnlockPagableImageSection", 1);
        self.add("MmUnlockPages", 1);
        self.add("MmUnmapIoSpace", 2);
        self.add("MmUnmapLockedPages", 2);
        self.add("MmUnmapReservedMapping", 3);
        self.add("ModeToCreateFileFlags", 5);
        self.add("modf", 2);
        self.add("modff", 2);
        self.add("ModifyMenu", 5);
        self.add("ModifyWorldTransform", 3);
        self.add("Module32First", 2);
        self.add("Module32Next", 2);
        self.add("MonikerCommonPrefixWith", 3);
        self.add("MonikerRelativePathTo", 4);
        self.add("Monitorenumproc", 4);
        self.add("MonitorFromPoint", 2);
        self.add("MonitorFromRect", 2);
        self.add("MonitorFromWindow", 2);
        self.add("MountVHD", 2);
        self.add("mouse_event", 5);
        self.add("MoveFile", 2);
        self.add("MoveFileEx", 3);
        self.add("MoveFileTransacted", 6);
        self.add("MoveFileWithProgress", 5);
        self.add("MoveToEx", 4);
        self.add("MoveWindow", 6);
        self.add("MprAdminBufferFree", 1);
        self.add("MprAdminConnectionClearStats", 2);
        self.add("MprAdminConnectionGetInfo", 4);
        self.add("MprAdminConnectionRemoveQuarantine", 3);
        self.add("MprAdminDeregisterConnectionNotification", 2);
        self.add("MprAdminDeviceEnum", 4);
        self.add("MprAdminEstablishDomainRasServer", 3);
        self.add("MprAdminGetErrorString", 2);
        self.add("MprAdminGetPDCServer", 3);
        self.add("MprAdminInterfaceConnect", 4);
        self.add("MprAdminInterfaceCreate", 4);
        self.add("MprAdminInterfaceDelete", 2);
        self.add("MprAdminInterfaceDeviceGetInfo", 5);
        self.add("MprAdminInterfaceDeviceSetInfo", 5);
        self.add("MprAdminInterfaceDisconnect", 2);
        self.add("MprAdminInterfaceEnum", 7);
        self.add("MprAdminInterfaceGetCredentials", 5);
        self.add("MprAdminInterfaceGetCredentialsEx", 4);
        self.add("MprAdminInterfaceGetHandle", 4);
        self.add("MprAdminInterfaceGetInfo", 4);
        self.add("MprAdminInterfaceQueryUpdateResult", 4);
        self.add("MprAdminInterfaceSetCredentials", 5);
        self.add("MprAdminInterfaceSetCredentialsEx", 4);
        self.add("MprAdminInterfaceSetInfo", 4);
        self.add("MprAdminInterfaceTransportAdd", 5);
        self.add("MprAdminInterfaceTransportGetInfo", 5);
        self.add("MprAdminInterfaceTransportRemove", 3);
        self.add("MprAdminInterfaceTransportSetInfo", 5);
        self.add("MprAdminInterfaceUpdatePhonebookInfo", 2);
        self.add("MprAdminInterfaceUpdateRoutes", 4);
        self.add("MprAdminIsDomainRasServer", 3);
        self.add("MprAdminIsServiceRunning", 1);
        self.add("MprAdminMIBBufferFree", 1);
        self.add("MprAdminMIBEntryCreate", 5);
        self.add("MprAdminMIBEntryDelete", 5);
        self.add("MprAdminMIBEntryGet", 7);
        self.add("MprAdminMIBEntryGetFirst", 7);
        self.add("MprAdminMIBEntryGetNext", 7);
        self.add("MprAdminMIBEntrySet", 5);
        self.add("MprAdminMIBGetTrapInfo", 7);
        self.add("MprAdminMIBServerConnect", 2);
        self.add("MprAdminMIBServerDisconnect", 1);
        self.add("MprAdminMIBSetTrapInfo", 7);
        self.add("MprAdminPortClearStats", 2);
        self.add("MprAdminPortDisconnect", 2);
        self.add("MprAdminPortEnum", 8);
        self.add("MprAdminPortGetInfo", 4);
        self.add("MprAdminPortReset", 2);
        self.add("MprAdminRegisterConnectionNotification", 2);
        self.add("MprAdminSendUserMessage", 3);
        self.add("MprAdminServerConnect", 2);
        self.add("MprAdminServerDisconnect", 1);
        self.add("MprAdminServerGetCredentials", 3);
        self.add("MprAdminServerGetInfo", 3);
        self.add("MprAdminServerSetCredentials", 3);
        self.add("MprAdminServerSetInfo", 3);
        self.add("MprAdminTransportCreate", 8);
        self.add("MprAdminTransportGetInfo", 6);
        self.add("MprAdminTransportSetInfo", 6);
        self.add("MprAdminUserGetInfo", 4);
        self.add("MprAdminUserSetInfo", 4);
        self.add("MprConfigBufferFree", 1);
        self.add("MprConfigFilterGetInfo", 3);
        self.add("MprConfigFilterSetInfo", 3);
        self.add("MprConfigGetFriendlyName", 4);
        self.add("MprConfigGetGuidName", 4);
        self.add("MprConfigInterfaceCreate", 4);
        self.add("MprConfigInterfaceDelete", 2);
        self.add("MprConfigInterfaceEnum", 7);
        self.add("MprConfigInterfaceGetHandle", 3);
        self.add("MprConfigInterfaceGetInfo", 5);
        self.add("MprConfigInterfaceSetInfo", 4);
        self.add("MprConfigInterfaceTransportAdd", 7);
        self.add("MprConfigInterfaceTransportEnum", 8);
        self.add("MprConfigInterfaceTransportGetHandle", 4);
        self.add("MprConfigInterfaceTransportGetInfo", 5);
        self.add("MprConfigInterfaceTransportRemove", 3);
        self.add("MprConfigInterfaceTransportSetInfo", 5);
        self.add("MprConfigServerBackup", 2);
        self.add("MprConfigServerConnect", 2);
        self.add("MprConfigServerDisconnect", 1);
        self.add("MprConfigServerGetInfo", 3);
        self.add("MprConfigServerInstall", 2);
        self.add("MprConfigServerRefresh", 1);
        self.add("MprConfigServerRestore", 2);
        self.add("MprConfigServerSetInfo", 3);
        self.add("MprConfigTransportCreate", 9);
        self.add("MprConfigTransportDelete", 2);
        self.add("MprConfigTransportEnum", 7);
        self.add("MprConfigTransportGetHandle", 3);
        self.add("MprConfigTransportGetInfo", 7);
        self.add("MprConfigTransportSetInfo", 7);
        self.add("MprInfoBlockAdd", 6);
        self.add("MprInfoBlockFind", 5);
        self.add("MprInfoBlockQuerySize", 1);
        self.add("MprInfoBlockRemove", 3);
        self.add("MprInfoBlockSet", 6);
        self.add("MprInfoCreate", 2);
        self.add("MprInfoDelete", 1);
        self.add("MprInfoDuplicate", 2);
        self.add("MprInfoRemoveAll", 2);
        self.add("MprSetupIpInIpInterfaceFriendlyNameCreate", 2);
        self.add("MprSetupIpInIpInterfaceFriendlyNameDelete", 2);
        self.add("MprSetupIpInIpInterfaceFriendlyNameEnum", 3);
        self.add("MprSetupIpInIpInterfaceFriendlyNameFree", 1);
        self.add("MQADsPathToFormatName", 1);
        self.add("MQBeginTransaction", 1);
        self.add("MQCloseCursor", 1);
        self.add("MQCloseQueue", 1);
        self.add("MQCreateCursor", 2);
        self.add("MQCreateQueue", 4);
        self.add("MQDeleteQueue", 1);
        self.add("MQFreeMemory", 1);
        self.add("MQFreeSecurityContext", 1);
        self.add("MQGetMachineProperties", 3);
        self.add("MQGetOverlappedResult", 1);
        self.add("MQGetPrivateComputerInformation", 2);
        self.add("MQGetQueueProperties", 2);
        self.add("MQGetQueueSecurity", 5);
        self.add("MQGetSecurityContext", 3);
        self.add("MQGetSecurityContextEx", 3);
        self.add("MQHandleToFormatName", 3);
        self.add("MQInstanceToFormatName", 3);
        self.add("MQLocateBegin", 5);
        self.add("MQLocateEnd", 1);
        self.add("MQLocateNext", 3);
        self.add("MQMarkMessageRejected", 2);
        self.add("MQMgmtAction", 3);
        self.add("MQMgmtGetInfo", 3);
        self.add("MQMoveMessage", 3);
        self.add("MQOpenQueue", 4);
        self.add("MQPathNameToFormatName", 3);
        self.add("MQPurgeQueue", 1);
        self.add("MQReceiveMessage", 8);
        self.add("MQReceiveMessageByLookupId", 7);
        self.add("MQRegisterCertificate", 3);
        self.add("MQSendMessage", 3);
        self.add("MQSetQueueProperties", 2);
        self.add("MQSetQueueSecurity", 3);
        self.add("Msgboxcallback", 1);
        self.add("MsgWaitForMultipleObjects", 5);
        self.add("MsgWaitForMultipleObjectsEx", 5);
        self.add("MsiAdvertiseProduct", 4);
        self.add("MsiAdvertiseProductEx", 6);
        self.add("MsiAdvertiseScript", 4);
        self.add("MsiApplyMultiplePatches", 3);
        self.add("MsiApplyPatch", 4);
        self.add("MsiBeginTransaction", 4);
        self.add("MsiCloseAllHandles", 0);
        self.add("MsiCloseHandle", 1);
        self.add("MsiCollectUserInfo", 1);
        self.add("MsiConfigureFeature", 3);
        self.add("MsiConfigureProduct", 3);
        self.add("MsiConfigureProductEx", 4);
        self.add("MsiCreateRecord", 1);
        self.add("MsiCreateTransformSummaryInfo", 5);
        self.add("MsiDatabaseApplyTransform", 3);
        self.add("MsiDatabaseCommit", 1);
        self.add("MsiDatabaseExport", 4);
        self.add("MsiDatabaseGenerateTransform", 5);
        self.add("MsiDatabaseGetPrimaryKeys", 3);
        self.add("MsiDatabaseImport", 3);
        self.add("MsiDatabaseIsTablePersistent", 2);
        self.add("MsiDatabaseMerge", 3);
        self.add("MsiDatabaseOpenView", 3);
        self.add("MsiDetermineApplicablePatches", 3);
        self.add("MsiDeterminePatchSequence", 5);
        self.add("MsiDoAction", 2);
        self.add("MsiEnableLog", 3);
        self.add("MsiEnableUIPreview", 2);
        self.add("MsiEndTransaction", 1);
        self.add("MsiEnumClients", 3);
        self.add("MsiEnumClientsEx", 8);
        self.add("MsiEnumComponentCosts", 8);
        self.add("MsiEnumComponentQualifiers", 6);
        self.add("MsiEnumComponents", 2);
        self.add("MsiEnumComponentsEx", 7);
        self.add("MsiEnumFeatures", 4);
        self.add("MsiEnumPatches", 5);
        self.add("MsiEnumPatchesEx", 10);
        self.add("MsiEnumProducts", 2);
        self.add("MsiEnumProductsEx", 8);
        self.add("MsiEnumRelatedProducts", 4);
        self.add("MsiEvaluateCondition", 2);
        self.add("MsiExtractPatchXMLData", 4);
        self.add("MsiFormatRecord", 4);
        self.add("MsiGetActiveDatabase", 1);
        self.add("MsiGetComponentPath", 4);
        self.add("MsiGetComponentPathEx", 6);
        self.add("MsiGetComponentState", 4);
        self.add("MsiGetDatabaseState", 1);
        self.add("MsiGetFeatureCost", 5);
        self.add("MsiGetFeatureInfo", 7);
        self.add("MsiGetFeatureState", 4);
        self.add("MsiGetFeatureUsage", 4);
        self.add("MsiGetFeatureValidStates", 3);
        self.add("MsiGetFileHash", 3);
        self.add("MsiGetFileSignatureInformation", 5);
        self.add("MsiGetFileVersion", 5);
        self.add("MsiGetLanguage", 1);
        self.add("MsiGetLastErrorRecord", 0);
        self.add("MsiGetMode", 2);
        self.add("MsiGetPatchFileList", 4);
        self.add("MsiGetPatchInfo", 4);
        self.add("MsiGetPatchInfoEx", 7);
        self.add("MsiGetProductCode", 2);
        self.add("MsiGetProductInfo", 4);
        self.add("MsiGetProductInfoEx", 6);
        self.add("MsiGetProductInfoFromScript", 8);
        self.add("MsiGetProductProperty", 4);
        self.add("MsiGetProperty", 4);
        self.add("MsiGetShortcutTarget", 4);
        self.add("MsiGetSourcePath", 4);
        self.add("MsiGetSummaryInformation", 4);
        self.add("MsiGetTargetPath", 4);
        self.add("MsiGetUserInfo", 7);
        self.add("MsiInstallMissingComponent", 3);
        self.add("MsiInstallMissingFile", 2);
        self.add("MsiInstallProduct", 2);
        self.add("MsiIsProductElevated", 2);
        self.add("MsiJoinTransaction", 3);
        self.add("MsiLocateComponent", 3);
        self.add("MsimtfIsWindowFiltered", 1);
        self.add("MsiNotifySidChange", 2);
        self.add("MsiOpenDatabase", 3);
        self.add("MsiOpenPackage", 2);
        self.add("MsiOpenPackageEx", 3);
        self.add("MsiOpenProduct", 2);
        self.add("MsiPreviewBillboard", 3);
        self.add("MsiPreviewDialog", 2);
        self.add("MsiProcessAdvertiseScript", 5);
        self.add("MsiProcessMessage", 3);
        self.add("MsiProvideAssembly", 6);
        self.add("MsiProvideComponent", 6);
        self.add("MsiProvideQualifiedComponent", 5);
        self.add("MsiProvideQualifiedComponentEx", 8);
        self.add("MsiQueryComponentState", 5);
        self.add("MsiQueryFeatureState", 2);
        self.add("MsiQueryFeatureStateEx", 5);
        self.add("MsiQueryProductState", 1);
        self.add("MsiRecordClearData", 1);
        self.add("MsiRecordDataSize", 2);
        self.add("MsiRecordGetFieldCount", 1);
        self.add("MsiRecordGetInteger", 2);
        self.add("MsiRecordGetString", 4);
        self.add("MsiRecordIsNull", 2);
        self.add("MsiRecordReadStream", 4);
        self.add("MsiRecordSetInteger", 3);
        self.add("MsiRecordSetStream", 3);
        self.add("MsiRecordSetString", 3);
        self.add("MsiReinstallFeature", 3);
        self.add("MsiReinstallProduct", 2);
        self.add("MsiRemovePatches", 4);
        self.add("MsiSequence", 3);
        self.add("MsiSetComponentState", 3);
        self.add("MsiSetExternalUI", 3);
        self.add("MsiSetExternalUIRecord", 4);
        self.add("MsiSetFeatureAttributes", 3);
        self.add("MsiSetFeatureState", 3);
        self.add("MsiSetInstallLevel", 2);
        self.add("MsiSetInternalUI", 2);
        self.add("MsiSetMode", 3);
        self.add("MsiSetProperty", 3);
        self.add("MsiSetTargetPath", 3);
        self.add("MsiSourceListAddMediaDisk", 7);
        self.add("MsiSourceListAddSource", 4);
        self.add("MsiSourceListAddSourceEx", 6);
        self.add("MsiSourceListClearAll", 3);
        self.add("MsiSourceListClearAllEx", 4);
        self.add("MsiSourceListClearMediaDisk", 5);
        self.add("MsiSourceListClearSource", 5);
        self.add("MsiSourceListEnumMediaDisks", 10);
        self.add("MsiSourceListEnumSources", 7);
        self.add("MsiSourceListForceResolution", 3);
        self.add("MsiSourceListForceResolutionEx", 4);
        self.add("MsiSourceListGetInfo", 7);
        self.add("MsiSourceListSetInfo", 6);
        self.add("MsiSummaryInfoGetProperty", 7);
        self.add("MsiSummaryInfoGetPropertyCount", 2);
        self.add("MsiSummaryInfoPersist", 1);
        self.add("MsiSummaryInfoSetProperty", 6);
        self.add("MsiUseFeature", 2);
        self.add("MsiUseFeatureEx", 4);
        self.add("MsiVerifyDiskSpace", 1);
        self.add("MsiVerifyPackage", 1);
        self.add("MsiViewClose", 1);
        self.add("MsiViewExecute", 2);
        self.add("MsiViewFetch", 2);
        self.add("MsiViewGetColumnInfo", 3);
        self.add("MsiViewGetError", 3);
        self.add("MsiViewModify", 3);
        self.add("msize", 1);
        self.add("msize_dbg", 2);
        self.add("MSProviderInit", 9);
        self.add("MulDiv", 3);
        self.add("MultiByteToWideChar", 6);
        self.add("MultinetGetConnectionPerformance", 2);
        self.add("NCryptCloseProtectionDescriptor", 1);
        self.add("NCryptCreatePersistedKey", 6);
        self.add("NCryptCreateProtectionDescriptor", 3);
        self.add("NCryptDecrypt", 8);
        self.add("NCryptDeleteKey", 2);
        self.add("NCryptDeriveKey", 7);
        self.add("NCryptEncrypt", 8);
        self.add("NCryptEnumAlgorithms", 5);
        self.add("NCryptEnumKeys", 5);
        self.add("NCryptEnumStorageProviders", 3);
        self.add("NCryptExportKey", 8);
        self.add("NCryptFinalizeKey", 2);
        self.add("NCryptFreeBuffer", 1);
        self.add("NCryptFreeObject", 1);
        self.add("NCryptGetProperty", 6);
        self.add("NCryptGetProtectionDescriptorInfo", 4);
        self.add("NCryptImportKey", 8);
        self.add("NCryptIsAlgSupported", 3);
        self.add("NCryptIsKeyHandle", 1);
        self.add("NCryptKeyDerivation", 6);
        self.add("NCryptNotifyChangeKey", 3);
        self.add("NCryptOpenKey", 5);
        self.add("NCryptOpenStorageProvider", 3);
        self.add("NCryptProtectSecret", 8);
        self.add("NCryptQueryProtectionDescriptorName", 4);
        self.add("NCryptRegisterProtectionDescriptorName", 3);
        self.add("NCryptSecretAgreement", 4);
        self.add("NCryptSetProperty", 5);
        self.add("NCryptSignHash", 8);
        self.add("NCryptStreamClose", 1);
        self.add("NCryptStreamOpenToProtect", 5);
        self.add("NCryptStreamOpenToUnprotect", 4);
        self.add("NCryptStreamUpdate", 4);
        self.add("NCryptTranslateHandle", 6);
        self.add("NCryptUnprotectSecret", 8);
        self.add("NCryptVerifySignature", 7);
        self.add("NdfCloseIncident", 1);
        self.add("NdfCreateConnectivityIncident", 1);
        self.add("NdfCreateDNSIncident", 3);
        self.add("NdfCreateIncident", 4);
        self.add("NdfCreateNetConnectionIncident", 2);
        self.add("NdfCreateSharingIncident", 2);
        self.add("NdfCreateWebIncident", 2);
        self.add("NdfCreateWebIncidentEx", 4);
        self.add("NdfCreateWinSockIncident", 6);
        self.add("NdfExecuteDiagnosis", 2);
        self.add("Ndr64AsyncClientCall", 3);
        self.add("Ndr64AsyncServerCall64", 1);
        self.add("Ndr64AsyncServerCallAll", 1);
        self.add("Ndr64DcomAsyncClientCall", 3);
        self.add("Ndr64DcomAsyncStubCall", 4);
        self.add("NdrAllocate", 2);
        self.add("NdrAsyncClientCall", 2);
        self.add("NdrAsyncServerCall", 1);
        self.add("NdrAsyncStubCall", 4);
        self.add("NdrByteCountPointerBufferSize", 3);
        self.add("NdrByteCountPointerFree", 3);
        self.add("NdrByteCountPointerMarshall", 3);
        self.add("NdrByteCountPointerUnmarshall", 4);
        self.add("NDRCContextBinding", 1);
        self.add("NDRCContextMarshall", 2);
        self.add("NDRCContextUnmarshall", 4);
        self.add("NdrClearOutParameters", 3);
        self.add("NdrClientCall", 2);
        self.add("NdrClientCall2", 2);
        self.add("NdrClientContextMarshall", 3);
        self.add("NdrClientContextUnmarshall", 3);
        self.add("NdrClientInitialize", 4);
        self.add("NdrClientInitializeNew", 4);
        self.add("NdrComplexArrayBufferSize", 3);
        self.add("NdrComplexArrayFree", 3);
        self.add("NdrComplexArrayMarshall", 3);
        self.add("NdrComplexArrayMemorySize", 2);
        self.add("NdrComplexArrayUnmarshall", 4);
        self.add("NdrComplexStructBufferSize", 3);
        self.add("NdrComplexStructFree", 3);
        self.add("NdrComplexStructMarshall", 3);
        self.add("NdrComplexStructMemorySize", 2);
        self.add("NdrComplexStructUnmarshall", 4);
        self.add("NdrConformantArrayBufferSize", 3);
        self.add("NdrConformantArrayFree", 3);
        self.add("NdrConformantArrayMarshall", 3);
        self.add("NdrConformantArrayMemorySize", 2);
        self.add("NdrConformantArrayUnmarshall", 4);
        self.add("NdrConformantStringBufferSize", 3);
        self.add("NdrConformantStringMarshall", 3);
        self.add("NdrConformantStringMemorySize", 2);
        self.add("NdrConformantStringUnmarshall", 4);
        self.add("NdrConformantStructBufferSize", 3);
        self.add("NdrConformantStructFree", 3);
        self.add("NdrConformantStructMarshall", 3);
        self.add("NdrConformantStructMemorySize", 2);
        self.add("NdrConformantStructUnmarshall", 4);
        self.add("NdrConformantVaryingArrayBufferSize", 3);
        self.add("NdrConformantVaryingArrayFree", 3);
        self.add("NdrConformantVaryingArrayMarshall", 3);
        self.add("NdrConformantVaryingArrayMemorySize", 2);
        self.add("NdrConformantVaryingArrayUnmarshall", 4);
        self.add("NdrConformantVaryingStructBufferSize", 3);
        self.add("NdrConformantVaryingStructFree", 3);
        self.add("NdrConformantVaryingStructMarshall", 3);
        self.add("NdrConformantVaryingStructMemorySize", 2);
        self.add("NdrConformantVaryingStructUnmarshall", 4);
        self.add("NdrContextHandleInitialize", 2);
        self.add("NdrContextHandleMemorySize", 2);
        self.add("NdrContextHandleSize", 3);
        self.add("NdrConvert", 2);
        self.add("NdrConvert2", 3);
        self.add("NdrCorrelationFree", 1);
        self.add("NdrCorrelationInitialize", 4);
        self.add("NdrCorrelationPass", 1);
        self.add("NdrCreateServerInterfaceFromStub", 2);
        self.add("NdrCStdStubBuffer2_Release", 2);
        self.add("NdrCStdStubBuffer_Release", 2);
        self.add("NdrDcomAsyncClientCall", 2);
        self.add("NdrDcomAsyncStubCall", 4);
        self.add("NdrDllCanUnloadNow", 1);
        self.add("NdrDllGetClassObject", 6);
        self.add("NdrDllRegisterProxy", 3);
        self.add("NdrDllUnregisterProxy", 3);
        self.add("NdrEncapsulatedUnionBufferSize", 3);
        self.add("NdrEncapsulatedUnionFree", 3);
        self.add("NdrEncapsulatedUnionMarshall", 3);
        self.add("NdrEncapsulatedUnionMemorySize", 2);
        self.add("NdrEncapsulatedUnionUnmarshall", 4);
        self.add("NdrFixedArrayBufferSize", 3);
        self.add("NdrFixedArrayFree", 3);
        self.add("NdrFixedArrayMarshall", 3);
        self.add("NdrFixedArrayMemorySize", 2);
        self.add("NdrFixedArrayUnmarshall", 4);
        self.add("NdrFreeBuffer", 1);
        self.add("NdrFullPointerFree", 2);
        self.add("NdrFullPointerInsertRefId", 3);
        self.add("NdrFullPointerQueryPointer", 4);
        self.add("NdrFullPointerQueryRefId", 4);
        self.add("NdrFullPointerXlatFree", 1);
        self.add("NdrFullPointerXlatInit", 2);
        self.add("NdrGetBuffer", 3);
        self.add("NdrGetDcomProtocolVersion", 2);
        self.add("NdrGetUserMarshalInfo", 3);
        self.add("NdrInterfacePointerBufferSize", 3);
        self.add("NdrInterfacePointerFree", 3);
        self.add("NdrInterfacePointerMarshall", 3);
        self.add("NdrInterfacePointerMemorySize", 2);
        self.add("NdrInterfacePointerUnmarshall", 4);
        self.add("NdrMapCommAndFaultStatus", 4);
        self.add("NdrMesProcEncodeDecode2", 3);
        self.add("NdrMesProcEncodeDecode", 3);
        self.add("NdrMesSimpleTypeAlignSize", 1);
        self.add("NdrMesSimpleTypeDecode", 3);
        self.add("NdrMesSimpleTypeEncode", 4);
        self.add("NdrMesTypeAlignSize2", 5);
        self.add("NdrMesTypeAlignSize", 4);
        self.add("NdrMesTypeDecode2", 5);
        self.add("NdrMesTypeDecode", 4);
        self.add("NdrMesTypeEncode2", 5);
        self.add("NdrMesTypeEncode", 4);
        self.add("NdrMesTypeFree2", 5);
        self.add("NdrNonConformantStringBufferSize", 3);
        self.add("NdrNonConformantStringMarshall", 3);
        self.add("NdrNonConformantStringMemorySize", 2);
        self.add("NdrNonConformantStringUnmarshall", 4);
        self.add("NdrNonEncapsulatedUnionBufferSize", 3);
        self.add("NdrNonEncapsulatedUnionFree", 3);
        self.add("NdrNonEncapsulatedUnionMarshall", 3);
        self.add("NdrNonEncapsulatedUnionMemorySize", 2);
        self.add("NdrNonEncapsulatedUnionUnmarshall", 4);
        self.add("NdrNsGetBuffer", 3);
        self.add("NdrNsSendReceive", 3);
        self.add("NdrOleAllocate", 1);
        self.add("NdrOleFree", 1);
        self.add("NdrPartialIgnoreClientBufferSize", 2);
        self.add("NdrPartialIgnoreClientMarshall", 2);
        self.add("NdrPartialIgnoreServerInitialize", 3);
        self.add("NdrPartialIgnoreServerUnmarshall", 2);
        self.add("NdrPointerBufferSize", 3);
        self.add("NdrPointerFree", 3);
        self.add("NdrPointerMarshall", 3);
        self.add("NdrPointerMemorySize", 2);
        self.add("NdrPointerUnmarshall", 4);
        self.add("NdrProxyErrorHandler", 1);
        self.add("NdrProxyFreeBuffer", 2);
        self.add("NdrProxyGetBuffer", 2);
        self.add("NdrProxyInitialize", 5);
        self.add("NdrProxySendReceive", 2);
        self.add("NdrRangeUnmarshall", 4);
        self.add("NdrRpcSmClientAllocate", 1);
        self.add("NdrRpcSmClientFree", 1);
        self.add("NdrRpcSmSetClientToOsf", 1);
        self.add("NdrRpcSsDefaultAllocate", 1);
        self.add("NdrRpcSsDefaultFree", 1);
        self.add("NdrRpcSsDisableAllocate", 1);
        self.add("NdrRpcSsEnableAllocate", 1);
        self.add("NDRSContextMarshall2", 6);
        self.add("NDRSContextMarshall", 3);
        self.add("NDRSContextMarshallEx", 4);
        self.add("NDRSContextUnmarshall", 2);
        self.add("NDRSContextUnmarshall2", 5);
        self.add("NDRSContextUnmarshallEx", 3);
        self.add("NdrSendReceive", 2);
        self.add("NdrServerCall", 1);
        self.add("NdrServerCall2", 1);
        self.add("NdrServerCallAll", 1);
        self.add("NdrServerCallNdr64", 1);
        self.add("NdrServerContextMarshall", 3);
        self.add("NdrServerContextNewMarshall", 4);
        self.add("NdrServerContextNewUnmarshall", 2);
        self.add("NdrServerContextUnmarshall", 1);
        self.add("NdrServerInitialize", 3);
        self.add("NdrServerInitializeMarshall", 2);
        self.add("NdrServerInitializeNew", 3);
        self.add("NdrServerInitializePartial", 4);
        self.add("NdrServerInitializeUnmarshall", 3);
        self.add("NdrServerMarshall", 4);
        self.add("NdrServerUnmarshall", 6);
        self.add("NdrSimpleStructBufferSize", 3);
        self.add("NdrSimpleStructFree", 3);
        self.add("NdrSimpleStructMarshall", 3);
        self.add("NdrSimpleStructMemorySize", 2);
        self.add("NdrSimpleStructUnmarshall", 4);
        self.add("NdrSimpleTypeMarshall", 3);
        self.add("NdrSimpleTypeUnmarshall", 3);
        self.add("NdrStubCall2", 4);
        self.add("NdrStubCall3", 4);
        self.add("NdrStubCall", 4);
        self.add("NdrStubForwardingFunction", 4);
        self.add("NdrStubGetBuffer", 3);
        self.add("NdrStubInitialize", 4);
        self.add("NdrUserMarshalBufferSize", 3);
        self.add("NdrUserMarshalFree", 3);
        self.add("NdrUserMarshalMarshall", 3);
        self.add("NdrUserMarshalMemorySize", 2);
        self.add("NdrUserMarshalSimpleTypeConvert", 3);
        self.add("NdrUserMarshalUnmarshall", 4);
        self.add("NdrVaryingArrayBufferSize", 3);
        self.add("NdrVaryingArrayFree", 3);
        self.add("NdrVaryingArrayMarshall", 3);
        self.add("NdrVaryingArrayMemorySize", 2);
        self.add("NdrVaryingArrayUnmarshall", 4);
        self.add("NdrXmitOrRepAsBufferSize", 3);
        self.add("NdrXmitOrRepAsFree", 3);
        self.add("NdrXmitOrRepAsMarshall", 3);
        self.add("NdrXmitOrRepAsMemorySize", 2);
        self.add("NdrXmitOrRepAsUnmarshall", 4);
        self.add("NeedCurrentDirectoryForExePath", 1);
        self.add("NetAccessAdd", 4);
        self.add("NetAccessCheck", 5);
        self.add("NetAccessDel", 2);
        self.add("NetAccessEnum", 9);
        self.add("NetAccessGetInfo", 4);
        self.add("NetAccessGetUserPerms", 4);
        self.add("NetAccessSetInfo", 5);
        self.add("NetAddAlternateComputerName", 5);
        self.add("NetAddServiceAccount", 4);
        self.add("NetAlertRaise", 3);
        self.add("NetAlertRaiseEx", 4);
        self.add("NetApiBufferAllocate", 2);
        self.add("NetApiBufferFree", 1);
        self.add("NetApiBufferReallocate", 3);
        self.add("NetApiBufferSize", 2);
        self.add("NetapipBufferAllocate", 2);
        self.add("NetAuditClear", 3);
        self.add("NetAuditRead", 11);
        self.add("NetAuditWrite", 5);
        self.add("NetConfigGet", 5);
        self.add("NetConfigGetAll", 4);
        self.add("NetConfigSet", 7);
        self.add("NetConnectionEnum", 8);
        self.add("NetCreateProvisioningPackage", 4);
        self.add("NetDfsAdd", 5);
        self.add("NetDfsAddFtRoot", 5);
        self.add("NetDfsAddRootTarget", 5);
        self.add("NetDfsAddStdRoot", 4);
        self.add("NetDfsAddStdRootForced", 4);
        self.add("NetDfsEnum", 6);
        self.add("NetDfsGetClientInfo", 5);
        self.add("NetDfsGetFtContainerSecurity", 4);
        self.add("NetDfsGetInfo", 5);
        self.add("NetDfsGetSecurity", 4);
        self.add("NetDfsGetStdContainerSecurity", 4);
        self.add("NetDfsGetSupportedNamespaceVersion", 3);
        self.add("NetDfsManagerInitialize", 2);
        self.add("NetDfsMove", 3);
        self.add("NetDfsRemove", 3);
        self.add("NetDfsRemoveFtRoot", 4);
        self.add("NetDfsRemoveFtRootForced", 5);
        self.add("NetDfsRemoveRootTarget", 3);
        self.add("NetDfsRemoveStdRoot", 3);
        self.add("NetDfsSetClientInfo", 5);
        self.add("NetDfsSetFtContainerSecurity", 3);
        self.add("NetDfsSetInfo", 5);
        self.add("NetDfsSetSecurity", 3);
        self.add("NetDfsSetStdContainerSecurity", 3);
        self.add("NetEnumerateComputerNames", 5);
        self.add("NetEnumerateServiceAccounts", 4);
        self.add("NetErrorLogClear", 3);
        self.add("NetErrorLogRead", 11);
        self.add("NetErrorLogWrite", 8);
        self.add("NetFileClose", 2);
        self.add("NetFileEnum", 9);
        self.add("NetFileGetInfo", 4);
        self.add("NetGetAnyDCName", 3);
        self.add("NetGetDCName", 3);
        self.add("NetGetDisplayInformationIndex", 4);
        self.add("NetGetJoinableOUs", 6);
        self.add("NetGetJoinInformation", 3);
        self.add("NetGroupAdd", 4);
        self.add("NetGroupAddUser", 3);
        self.add("NetGroupDel", 2);
        self.add("NetGroupDelUser", 3);
        self.add("NetGroupEnum", 7);
        self.add("NetGroupGetInfo", 4);
        self.add("NetGroupGetUsers", 8);
        self.add("NetGroupSetInfo", 5);
        self.add("NetGroupSetUsers", 5);
        self.add("NetIsServiceAccount", 3);
        self.add("NetJoinDomain", 6);
        self.add("NetLocalGroupAdd", 4);
        self.add("NetLocalGroupAddMember", 3);
        self.add("NetLocalGroupAddMembers", 5);
        self.add("NetLocalGroupDel", 2);
        self.add("NetLocalGroupDelMember", 3);
        self.add("NetLocalGroupDelMembers", 5);
        self.add("NetLocalGroupEnum", 7);
        self.add("NetLocalGroupGetInfo", 4);
        self.add("NetLocalGroupGetMembers", 8);
        self.add("NetLocalGroupSetInfo", 5);
        self.add("NetLocalGroupSetMembers", 5);
        self.add("NetLogonSetServiceBits", 3);
        self.add("NetMessageBufferSend", 5);
        self.add("NetMessageNameAdd", 2);
        self.add("NetMessageNameDel", 2);
        self.add("NetMessageNameEnum", 7);
        self.add("NetMessageNameGetInfo", 4);
        self.add("NetProvisionComputerAccount", 8);
        self.add("NetQueryDisplayInformation", 7);
        self.add("NetRemoteComputerSupports", 3);
        self.add("NetRemoteTOD", 2);
        self.add("NetRemoveAlternateComputerName", 5);
        self.add("NetRemoveServiceAccount", 3);
        self.add("NetRenameMachineInDomain", 5);
        self.add("NetRequestOfflineDomainJoin", 4);
        self.add("NetRequestProvisioningPackageInstall", 5);
        self.add("NetScheduleJobAdd", 3);
        self.add("NetScheduleJobDel", 3);
        self.add("NetScheduleJobEnum", 6);
        self.add("NetScheduleJobGetInfo", 3);
        self.add("NetServerAliasAdd", 3);
        self.add("NetServerAliasDel", 3);
        self.add("NetServerAliasEnum", 7);
        self.add("NetServerComputerNameAdd", 3);
        self.add("NetServerComputerNameDel", 2);
        self.add("NetServerDiskEnum", 7);
        self.add("NetServerEnum", 9);
        self.add("NetServerEnumEx", 9);
        self.add("NetServerGetInfo", 3);
        self.add("NetServerSetInfo", 4);
        self.add("NetServerSetInfoCommandLine", 2);
        self.add("NetServerTransportAdd", 3);
        self.add("NetServerTransportAddEx", 3);
        self.add("NetServerTransportDel", 3);
        self.add("NetServerTransportEnum", 7);
        self.add("NetServiceControl", 5);
        self.add("NetServiceEnum", 7);
        self.add("NetServiceGetInfo", 4);
        self.add("NetServiceInstall", 5);
        self.add("NetSessionDel", 3);
        self.add("NetSessionEnum", 9);
        self.add("NetSessionGetInfo", 5);
        self.add("NetSetPrimaryComputerName", 5);
        self.add("NetShareAdd", 4);
        self.add("NetShareCheck", 3);
        self.add("NetShareDel", 3);
        self.add("NetShareDelEx", 3);
        self.add("NetShareDelSticky", 3);
        self.add("NetShareEnum", 7);
        self.add("NetShareEnumSticky", 7);
        self.add("NetShareGetInfo", 4);
        self.add("NetShareSetInfo", 5);
        self.add("NetStatisticsGet", 5);
        self.add("NetUnjoinDomain", 4);
        self.add("NetUseAdd", 4);
        self.add("NetUseDel", 3);
        self.add("NetUseEnum", 7);
        self.add("NetUseGetInfo", 4);
        self.add("NetUserAdd", 4);
        self.add("NetUserChangePassword", 4);
        self.add("NetUserDel", 2);
        self.add("NetUserEnum", 8);
        self.add("NetUserGetGroups", 7);
        self.add("NetUserGetInfo", 4);
        self.add("NetUserGetLocalGroups", 8);
        self.add("NetUserModalsGet", 3);
        self.add("NetUserModalsSet", 4);
        self.add("NetUserSetGroups", 5);
        self.add("NetUserSetInfo", 5);
        self.add("NetValidateName", 5);
        self.add("NetValidatePasswordPolicy", 5);
        self.add("NetValidatePasswordPolicyFree", 1);
        self.add("NetWkstaGetInfo", 3);
        self.add("NetWkstaSetInfo", 4);
        self.add("NetWkstaTransportAdd", 4);
        self.add("NetWkstaTransportDel", 3);
        self.add("NetWkstaTransportEnum", 7);
        self.add("NetWkstaUserEnum", 7);
        self.add("NetWkstaUserGetInfo", 3);
        self.add("NetWkstaUserSetInfo", 4);
        self.add("NetworkIsolationDiagnoseConnectFailureAndGetInfo", 2);
        self.add("NetworkIsolationEnumAppContainers", 3);
        self.add("NetworkIsolationEnumerateAppContainerRules", 1);
        self.add("NetworkIsolationFreeAppContainers", 1);
        self.add("NetworkIsolationGetAppContainerConfig", 2);
        self.add("NetworkIsolationRegisterForAppContainerChanges", 4);
        self.add("NetworkIsolationSetAppContainerConfig", 2);
        self.add("NetworkIsolationSetupAppContainerBinaries", 7);
        self.add("NetworkIsolationUnregisterForAppContainerChanges", 1);
        self.add("nextafter", 2);
        self.add("NhpAllocateAndGetInterfaceInfoFromStack", 5);
        self.add("NormalizeFileForPatchSignature", 10);
        self.add("NormalizeString", 5);
        self.add("NotifyAddrChange", 2);
        self.add("NotifyBootConfigStatus", 1);
        self.add("NotifyChangeEventLog", 2);
        self.add("NotifyIpInterfaceChange", 5);
        self.add("NotifyRouteChange", 2);
        self.add("NotifyRouteChange2", 5);
        self.add("NotifySecurityHealthChange", 3);
        self.add("NotifyServiceStatusChange", 3);
        self.add("NotifyStableUnicastIpAddressTable", 5);
        self.add("NotifyTeredoPortChange", 4);
        self.add("NotifyUILanguageChange", 5);
        self.add("NotifyUnicastIpAddressChange", 5);
        self.add("NotifyWinEvent", 4);
        self.add("NSS_GetClientAuthData", 5);
        self.add("NSS_Init", 1);
        self.add("NSS_InitReadWrite", 1);
        self.add("NSS_NoDB_Init", 1);
        self.add("NSS_SetDomesticPolicy", 0);
        self.add("NSS_SetExportPolicy", 0);
        self.add("NSS_SetFrancePolicy", 0);
        self.add("NSS_Shutdown", 0);
        self.add("NtAcceptConnectPort", 6);
        self.add("NtAccessCheck", 8);
        self.add("NtAccessCheckAndAuditAlarm", 11);
        self.add("NtAccessCheckByType", 11);
        self.add("NtAccessCheckByTypeAndAuditAlarm", 16);
        self.add("NtAccessCheckByTypeResultList", 11);
        self.add("NtAccessCheckByTypeResultListAndAuditAlarm", 16);
        self.add("NtAccessCheckByTypeResultListAndAuditAlarmByHandle", 17);
        self.add("NtAddAtom", 3);
        self.add("NtAddBootEntry", 2);
        self.add("NtAddDriverEntry", 2);
        self.add("NtAdjustGroupsToken", 6);
        self.add("NtAdjustPrivilegesToken", 6);
        self.add("NtAlertResumeThread", 2);
        self.add("NtAlertThread", 1);
        self.add("NtAllocateLocallyUniqueId", 1);
        self.add("NtAllocateUserPhysicalPages", 3);
        self.add("NtAllocateUuids", 4);
        self.add("NtAllocateVirtualMemory", 6);
        self.add("NtApphelpCacheControl", 2);
        self.add("NtAreMappedFilesTheSame", 2);
        self.add("NtAssignProcessToJobObject", 2);
        self.add("NtCancelIoFile", 2);
        self.add("NtCancelTimer", 2);
        self.add("NtClearEvent", 1);
        self.add("NtClose", 1);
        self.add("NtCloseObjectAuditAlarm", 3);
        self.add("NtCommitComplete", 2);
        self.add("NtCommitEnlistment", 2);
        self.add("NtCommitTransaction", 2);
        self.add("NtCompactKeys", 2);
        self.add("NtCompareTokens", 3);
        self.add("NtCompleteConnectPort", 1);
        self.add("NtCompressKey", 1);
        self.add("NtConnectPort", 8);
        self.add("NtContinue", 2);
        self.add("NtCreateDebugObject", 4);
        self.add("NtCreateDirectoryObject", 3);
        self.add("NtCreateEnlistment", 8);
        self.add("NtCreateEvent", 5);
        self.add("NtCreateEventPair", 3);
        self.add("NtCreateFile", 11);
        self.add("NtCreateIoCompletion", 4);
        self.add("NtCreateJobObject", 3);
        self.add("NtCreateJobSet", 3);
        self.add("NtCreateKey", 7);
        self.add("NtCreateKeyedEvent", 4);
        self.add("NtCreateKeyTransacted", 8);
        self.add("NtCreateMailslotFile", 8);
        self.add("NtCreateMutant", 4);
        self.add("NtCreateNamedPipeFile", 14);
        self.add("NtCreatePagingFile", 4);
        self.add("NtCreatePort", 5);
        self.add("NtCreateProcess", 8);
        self.add("NtCreateProcessEx", 9);
        self.add("NtCreateProfile", 9);
        self.add("NtCreateResourceManager", 7);
        self.add("NtCreateSection", 7);
        self.add("NtCreateSemaphore", 5);
        self.add("NtCreateSymbolicLinkObject", 4);
        self.add("NtCreateThread", 8);
        self.add("NtCreateThreadEx", 11);
        self.add("NtCreateTimer", 4);
        self.add("NtCreateToken", 13);
        self.add("NtCreateTransaction", 10);
        self.add("NtCreateTransactionManager", 6);
        self.add("NtCreateUserProcess", 11);
        self.add("NtCreateWaitablePort", 5);
        self.add("NtCurrentTeb", 0);
        self.add("NtDebugActiveProcess", 2);
        self.add("NtDebugContinue", 3);
        self.add("NtDelayExecution", 2);
        self.add("NtDeleteAtom", 1);
        self.add("NtDeleteBootEntry", 1);
        self.add("NtDeleteDriverEntry", 1);
        self.add("NtDeleteFile", 1);
        self.add("NtDeleteKey", 1);
        self.add("NtDeleteObjectAuditAlarm", 3);
        self.add("NtDeleteValueKey", 2);
        self.add("NtDeviceIoControlFile", 10);
        self.add("NtDisplayString", 1);
        self.add("NtDuplicateObject", 7);
        self.add("NtDuplicateToken", 6);
        self.add("NtEnumerateBootEntries", 2);
        self.add("NtEnumerateDriverEntries", 2);
        self.add("NtEnumerateKey", 6);
        self.add("NtEnumerateSystemEnvironmentValuesEx", 3);
        self.add("NtEnumerateTransactionObject", 5);
        self.add("NtEnumerateValueKey", 6);
        self.add("NtExtendSection", 2);
        self.add("NtFindAtom", 3);
        self.add("NtFlushBuffersFile", 2);
        self.add("NtFlushBuffersFileEx", 3);
        self.add("NtFlushInstructionCache", 3);
        self.add("NtFlushKey", 1);
        self.add("NtFlushVirtualMemory", 4);
        self.add("NtFlushWriteBuffer", 0);
        self.add("NtFreeUserPhysicalPages", 3);
        self.add("NtFreeVirtualMemory", 4);
        self.add("NtFreezeRegistry", 1);
        self.add("NtFreezeTransactions", 2);
        self.add("NtFsControlFile", 10);
        self.add("NtGetContextThread", 2);
        self.add("NtGetCurrentProcessorNumber", 0);
            self.add("NtGetNotificationResourceManager", 7);
        self.add("NtGetNotificationResourceManager", 7);
        self.add("NtGetPlugPlayEvent", 4);
        self.add("NtGetTickCount", 0);
        self.add("NtGetWriteWatch", 7);
        self.add("NtImpersonateAnonymousToken", 1);
        self.add("NtImpersonateClientOfPort", 2);
        self.add("NtImpersonateThread", 3);
        self.add("NtInitializeRegistry", 1);
        self.add("NtInitiatePowerAction", 4);
        self.add("NtIsProcessInJob", 2);
        self.add("NtListenPort", 2);
        self.add("NtLoadDriver", 1);
        self.add("NtLoadKey", 2);
        self.add("NtLoadKey2", 3);
        self.add("NtLockFile", 10);
        self.add("NtLockProductActivationKeys", 2);
        self.add("NtLockRegistryKey", 1);
        self.add("NtLockVirtualMemory", 4);
        self.add("NtMakePermanentObject", 1);
        self.add("NtMakeTemporaryObject", 1);
        self.add("NtManagePartition", 5);
        self.add("NtMapUserPhysicalPages", 3);
        self.add("NtMapUserPhysicalPagesScatter", 3);
        self.add("NtMapViewOfSection", 10);
        self.add("NtModifyBootEntry", 1);
        self.add("NtModifyDriverEntry", 1);
        self.add("NtNotifyChangeDirectoryFile", 9);
        self.add("NtNotifyChangeKey", 10);
        self.add("NtNotifyChangeMultipleKeys", 12);
        self.add("ntohd", 1);
        self.add("ntohf", 1);
        self.add("ntohl", 1);
        self.add("ntohll", 1);
        self.add("ntohs", 1);
        self.add("NtOpenDirectoryObject", 3);
        self.add("NtOpenEnlistment", 5);
        self.add("NtOpenEvent", 3);
        self.add("NtOpenEventPair", 3);
        self.add("NtOpenFile", 6);
        self.add("NtOpenIoCompletion", 3);
        self.add("NtOpenJobObject", 3);
        self.add("NtOpenKey", 3);
        self.add("NtOpenKeyedEvent", 3);
        self.add("NtOpenKeyEx", 4);
        self.add("NtOpenKeyTransacted", 4);
        self.add("NtOpenKeyTransactedEx", 5);
        self.add("NtOpenMutant", 3);
        self.add("NtOpenObjectAuditAlarm", 12);
        self.add("NtOpenProcess", 4);
        self.add("NtOpenProcessToken", 3);
        self.add("NtOpenProcessTokenEx", 4);
        self.add("NtOpenResourceManager", 5);
        self.add("NtOpenSection", 3);
        self.add("NtOpenSemaphore", 3);
        self.add("NtOpenSymbolicLinkObject", 3);
        self.add("NtOpenThread", 4);
        self.add("NtOpenThreadToken", 4);
        self.add("NtOpenThreadTokenEx", 5);
        self.add("NtOpenTimer", 3);
        self.add("NtOpenTransaction", 5);
        self.add("NtOpenTransactionManager", 6);
        self.add("NtPlugPlayControl", 3);
        self.add("NtPowerInformation", 5);
        self.add("NtPrepareComplete", 2);
        self.add("NtPrepareEnlistment", 2);
        self.add("NtPrePrepareComplete", 2);
        self.add("NtPrePrepareEnlistment", 2);
        self.add("NtPrivilegeCheck", 3);
        self.add("NtPrivilegedServiceAuditAlarm", 5);
        self.add("NtPrivilegeObjectAuditAlarm", 6);
        self.add("NtProtectVirtualMemory", 5);
        self.add("NtPulseEvent", 2);
        self.add("NtQueryAttributesFile", 2);
        self.add("NtQueryBootEntryOrder", 2);
        self.add("NtQueryBootOptions", 2);
        self.add("NtQueryDebugFilterState", 2);
        self.add("NtQueryDefaultLocale", 2);
        self.add("NtQueryDefaultUILanguage", 1);
        self.add("NtQueryDirectoryFile", 11);
        self.add("NtQueryDirectoryObject", 7);
        self.add("NtQueryDriverEntryOrder", 2);
        self.add("NtQueryEaFile", 9);
        self.add("NtQueryEvent", 5);
        self.add("NtQueryFullAttributesFile", 2);
        self.add("NtQueryInformationAtom", 5);
        self.add("NtQueryInformationByName", 5);
        self.add("NtQueryInformationEnlistment", 5);
        self.add("NtQueryInformationFile", 5);
        self.add("NtQueryInformationJobObject", 5);
        self.add("NtQueryInformationPort", 5);
        self.add("NtQueryInformationProcess", 5);
            self.add("NtQueryInformationResourceManager", 5);
        self.add("NtQueryInformationResourceManager", 5);
        self.add("NtQueryInformationThread", 5);
        self.add("NtQueryInformationToken", 5);
        self.add("NtQueryInformationTransaction", 5);
            self.add("NtQueryInformationTransactionManager", 5);
        self.add("NtQueryInformationTransactionManager", 5);
        self.add("NtQueryInstallUILanguage", 1);
        self.add("NtQueryIntervalProfile", 2);
        self.add("NtQueryIoCompletion", 5);
        self.add("NtQueryKey", 5);
        self.add("NtQueryMultipleValueKey", 6);
        self.add("NtQueryMutant", 5);
        self.add("NtQueryObject", 5);
        self.add("NtQueryOleDirectoryFile", 11);
        self.add("NtQueryOpenSubKeys", 2);
        self.add("NtQueryOpenSubKeysEx", 4);
        self.add("NtQueryPerformanceCounter", 2);
        self.add("NtQueryPortInformationProcess", 0);
        self.add("NtQueryQuotaInformationFile", 9);
        self.add("NtQuerySection", 5);
        self.add("NtQuerySecurityObject", 5);
        self.add("NtQuerySemaphore", 5);
        self.add("NtQuerySymbolicLinkObject", 3);
        self.add("NtQuerySystemEnvironmentValue", 4);
        self.add("NtQuerySystemEnvironmentValueEx", 5);
        self.add("NtQuerySystemInformation", 4);
        self.add("NtQuerySystemTime", 1);
        self.add("NtQueryTimer", 5);
        self.add("NtQueryTimerResolution", 3);
        self.add("NtQueryValueKey", 6);
        self.add("NtQueryVirtualMemory", 6);
        self.add("NtQueryVolumeInformationFile", 5);
        self.add("NtQueueApcThread", 5);
        self.add("NtRaiseHardError", 6);
        self.add("NtReadFile", 9);
        self.add("NtReadFileScatter", 9);
        self.add("NtReadOnlyEnlistment", 2);
        self.add("NtReadRequestData", 6);
        self.add("NtReadVirtualMemory", 5);
        self.add("NtRecoverEnlistment", 2);
        self.add("NtRecoverResourceManager", 1);
        self.add("NtRecoverTransactionManager", 1);
        self.add("NtRegisterThreadTerminatePort", 1);
        self.add("NtReleaseKeyedEvent", 4);
        self.add("NtReleaseMutant", 2);
        self.add("NtReleaseSemaphore", 3);
        self.add("NtRemoveIoCompletion", 5);
        self.add("NtRemoveProcessDebug", 2);
        self.add("NtRenameKey", 2);
        self.add("NtRenameTransactionManager", 2);
        self.add("NtReplaceKey", 3);
        self.add("NtReplyPort", 2);
        self.add("NtReplyWaitReceivePort", 4);
        self.add("NtReplyWaitReceivePortEx", 5);
        self.add("NtReplyWaitReplyPort", 2);
        self.add("NtRequestPort", 2);
        self.add("NtRequestWaitReplyPort", 3);
        self.add("NtResetEvent", 2);
        self.add("NtResetWriteWatch", 3);
        self.add("NtRestoreKey", 3);
        self.add("NtResumeProcess", 1);
        self.add("NtResumeThread", 2);
        self.add("NtRollbackComplete", 2);
        self.add("NtRollbackEnlistment", 2);
        self.add("NtRollbackTransaction", 2);
        self.add("NtRollforwardTransactionManager", 2);
        self.add("NtSaveKey", 2);
        self.add("NtSaveKeyEx", 3);
        self.add("NtSaveMergedKeys", 3);
        self.add("NtSecureConnectPort", 9);
        self.add("NtSetBootEntryOrder", 2);
        self.add("NtSetBootOptions", 2);
        self.add("NtSetContextThread", 2);
        self.add("NtSetDebugFilterState", 3);
        self.add("NtSetDefaultHardErrorPort", 1);
        self.add("NtSetDefaultLocale", 2);
        self.add("NtSetDefaultUILanguage", 1);
        self.add("NtSetDriverEntryOrder", 2);
        self.add("NtSetEaFile", 4);
        self.add("NtSetEvent", 2);
        self.add("NtSetEventBoostPriority", 1);
        self.add("NtSetHighEventPair", 1);
        self.add("NtSetHighWaitLowEventPair", 1);
        self.add("NtSetHighWaitLowThread", 0);
        self.add("NtSetInformationDebugObject", 5);
        self.add("NtSetInformationEnlistment", 4);
        self.add("NtSetInformationFile", 5);
        self.add("NtSetInformationJobObject", 4);
        self.add("NtSetInformationKey", 4);
        self.add("NtSetInformationObject", 4);
        self.add("NtSetInformationProcess", 4);
        self.add("NtSetInformationResourceManager", 4);
        self.add("NtSetInformationThread", 4);
        self.add("NtSetInformationToken", 4);
        self.add("NtSetInformationTransaction", 4);
            self.add("NtSetInformationTransactionManager", 4);
        self.add("NtSetInformationTransactionManager", 4);
        self.add("NtSetIntervalProfile", 2);
        self.add("NtSetIoCompletion", 5);
        self.add("NtSetLowEventPair", 1);
        self.add("NtSetLowWaitHighEventPair", 1);
        self.add("NtSetLowWaitHighThread", 0);
        self.add("NtSetQuotaInformationFile", 4);
        self.add("NtSetSecurityObject", 3);
        self.add("NtSetSystemEnvironmentValue", 2);
        self.add("NtSetSystemEnvironmentValueEx", 2);
        self.add("NtSetSystemInformation", 3);
        self.add("NtSetSystemPowerState", 3);
        self.add("NtSetSystemTime", 2);
        self.add("NtSetTimer", 7);
        self.add("NtSetTimerResolution", 3);
        self.add("NtSetUuidSeed", 1);
        self.add("NtSetValueKey", 6);
        self.add("NtSetVolumeInformationFile", 5);
        self.add("NTSHChangeNotifyDeregister", 1);
        self.add("NTSHChangeNotifyRegister", 6);
        self.add("NtShutdownSystem", 1);
        self.add("NtSignalAndWaitForSingleObject", 4);
        self.add("NtSinglePhaseReject", 2);
        self.add("NtStartProfile", 1);
        self.add("NtStopProfile", 1);
        self.add("NtSuspendProcess", 1);
        self.add("NtSuspendThread", 2);
        self.add("NtSystemDebugControl", 6);
        self.add("NtTerminateJobObject", 2);
        self.add("NtTerminateThread", 2);
        self.add("NtTestAlert", 0);
        self.add("NtThawRegistry", 0);
        self.add("NtThawTransactions", 0);
        self.add("NtTraceEvent", 4);
        self.add("NtTranslateFilePath", 4);
        self.add("NtUnloadDriver", 1);
        self.add("NtUnloadKey", 1);
        self.add("NtUnloadKey2", 2);
        self.add("NtUnloadKeyEx", 2);
        self.add("NtUnlockFile", 5);
        self.add("NtUnlockVirtualMemory", 4);
        self.add("NtUnmapViewOfSection", 2);
        self.add("NtUserSetChildWindowNoActivate", 1);
        self.add("NtWaitForDebugEvent", 4);
        self.add("NtWaitForKeyedEvent", 4);
        self.add("NtWaitForMultipleObjects32", 5);
        self.add("NtWaitForMultipleObjects", 5);
        self.add("NtWaitForSingleObject", 3);
        self.add("NtWaitHighEventPair", 1);
        self.add("NtWaitLowEventPair", 1);
        self.add("NtWow64GetNativeSystemInformation", 4);
        self.add("NtWriteFile", 9);
        self.add("NtWriteFileGather", 9);
        self.add("NtWriteRequestData", 6);
        self.add("NtWriteVirtualMemory", 5);
        self.add("NtYieldExecution", 0);
        self.add("OaBuildVersion", 0);
        self.add("OACreateTypeLib2", 3);
        self.add("OaEnablePerUserTLibRegistration", 0);
        self.add("ObCloseHandle", 2);
        self.add("ObDereferenceObjectDeferDelete", 1);
            self.add("ObDereferenceObjectDeferDeleteWithTag", 2);
        self.add("ObfReferenceObject", 1);
        self.add("ObGetObjectSecurity", 3);
        self.add("ObInsertObject", 6);
        self.add("ObIsKernelHandle", 1);
        self.add("ObjectCloseAuditAlarm", 3);
        self.add("ObjectDeleteAuditAlarm", 3);
        self.add("ObjectFromLresult", 4);
        self.add("ObjectOpenAuditAlarm", 12);
        self.add("ObjectPrivilegeAuditAlarm", 6);
        self.add("ObMakeTemporaryObject", 1);
        self.add("ObOpenObjectByPointer", 7);
        self.add("ObQueryNameString", 4);
        self.add("ObQueryObjectAuditingByHandle", 2);
        self.add("ObReferenceObjectByHandle", 6);
            self.add("ObReferenceObjectByHandleWithTag", 7);
        self.add("ObReferenceObjectByPointer", 4);
            self.add("ObReferenceObjectByPointerWithTag", 5);
        self.add("ObReferenceObjectSafe", 1);
        self.add("ObRegisterCallbacks", 2);
        self.add("ObReleaseObjectSecurity", 2);
        self.add("ObtainUserAgentString", 3);
        self.add("ObUnRegisterCallbacks", 1);
        self.add("OemKeyScan", 1);
        self.add("OemToChar", 2);
        self.add("OemToCharBuff", 3);
        self.add("OfflineFilesEnable", 2);
        self.add("OfflineFilesQueryStatus", 2);
        self.add("OfflineFilesQueryStatusEx", 3);
        self.add("OfflineFilesStart", 0);
        self.add("OffsetClipRgn", 3);
        self.add("OffsetRect", 3);
        self.add("OffsetRgn", 3);
        self.add("OffsetViewportOrgEx", 4);
        self.add("OffsetWindowOrgEx", 4);
        self.add("OleConvertIStorageToOLESTREAM", 2);
        self.add("OleConvertIStorageToOLESTREAMEx", 7);
        self.add("OleConvertOLESTREAMToIStorage", 3);
        self.add("OleConvertOLESTREAMToIStorageEx", 7);
        self.add("OleCreate", 7);
        self.add("OleCreateDefaultHandler", 4);
        self.add("OleCreateEmbeddingHelper", 6);
        self.add("OleCreateEx", 12);
        self.add("OleCreateFontIndirect", 3);
        self.add("OleCreateFromData", 7);
        self.add("OleCreateFromDataEx", 12);
        self.add("OleCreateFromFile", 8);
        self.add("OleCreateFromFileEx", 13);
        self.add("OleCreateLink", 7);
        self.add("OleCreateLinkEx", 12);
        self.add("OleCreateLinkFromData", 7);
        self.add("OleCreateLinkFromDataEx", 12);
        self.add("OleCreateLinkToFile", 7);
        self.add("OleCreateLinkToFileEx", 12);
        self.add("OleCreateMenuDescriptor", 2);
        self.add("OleCreatePictureIndirect", 4);
        self.add("OleCreatePropertyFrame", 11);
        self.add("OleCreatePropertyFrameIndirect", 1);
        self.add("OleCreateStaticFromData", 7);
        self.add("OleDestroyMenuDescriptor", 1);
        self.add("OleDoAutoConvert", 2);
        self.add("OleDraw", 4);
        self.add("OleDuplicateData", 3);
        self.add("OleFlushClipboard", 0);
        self.add("OleGetAutoConvert", 2);
        self.add("OleGetClipboard", 1);
        self.add("OleGetIconOfClass", 3);
        self.add("OleGetIconOfFile", 2);
        self.add("OleIconToCursor", 2);
        self.add("OleInitialize", 1);
        self.add("OleIsCurrentClipboard", 1);
        self.add("OleIsRunning", 1);
        self.add("OleLoad", 5);
        self.add("OleLoadFromStream", 3);
        self.add("OleLoadPicture", 5);
        self.add("OleLoadPictureEx", 8);
        self.add("OleLoadPictureFile", 2);
        self.add("OleLoadPictureFileEx", 5);
        self.add("OleLoadPicturePath", 6);
        self.add("OleLockRunning", 3);
        self.add("OleMetafilePictFromIconAndLabel", 4);
        self.add("OleNoteObjectVisible", 2);
        self.add("OleQueryCreateFromData", 1);
        self.add("OleQueryLinkFromData", 1);
        self.add("OleRegEnumFormatEtc", 3);
        self.add("OleRegEnumVerbs", 2);
        self.add("OleRegGetMiscStatus", 3);
        self.add("OleRegGetUserType", 3);
        self.add("OleRun", 1);
        self.add("OleSave", 3);
        self.add("OleSavePictureFile", 2);
        self.add("OleSaveToStream", 2);
        self.add("OleSetAutoConvert", 2);
        self.add("OleSetClipboard", 1);
        self.add("OleSetContainedObject", 2);
        self.add("OleSetMenuDescriptor", 5);
        self.add("OleTranslateAccelerator", 3);
        self.add("OleTranslateColor", 3);
        self.add("OleUIAddVerbMenu", 9);
        self.add("OleUIBusy", 1);
        self.add("OleUICanConvertOrActivateAs", 3);
        self.add("OleUIChangeIcon", 1);
        self.add("OleUIChangeSource", 1);
        self.add("OleUIConvert", 1);
        self.add("OleUIEditLinks", 1);
        self.add("OleUIInsertObject", 1);
        self.add("OleUIObjectProperties", 1);
        self.add("OleUIPasteSpecial", 1);
        self.add("OleUIPromptUser", 2);
        self.add("OleUIUpdateLinks", 4);
        self.add("OleUninitialize", 0);
        self.add("onexit", 1);
        self.add("open", 3);
        self.add("OpenBackupEventLog", 2);
        self.add("OpenClipboard", 1);
        self.add("OpenColorProfile", 4);
        self.add("OpenDesktop", 4);
        self.add("OpenDriver", 3);
        self.add("OpenEncryptedFileRaw", 3);
        self.add("OpenEnlistment", 3);
        self.add("OpenEvent", 3);
        self.add("OpenEventA", 3);
        self.add("OpenEventLog", 2);
        self.add("OpenEventW", 3);
        self.add("OpenFile", 3);
        self.add("OpenFileById", 6);
        self.add("OpenFileMapping", 3);
        self.add("OpenIcon", 1);
        self.add("OpenIMsgOnIStg", 11);
        self.add("OpenIMsgSession", 3);
        self.add("OpenInputDesktop", 3);
        self.add("OpenJobObject", 3);
        self.add("OpenMutex", 3);
        self.add("OpenMutexW", 3);
        self.add("open_osfhandle", 2);
        self.add("OpenPackageInfoByFullName", 3);
        self.add("OpenPersonalTrustDBDialog", 1);
        self.add("OpenPersonalTrustDBDialogEx", 3);
        self.add("OpenPrinter2", 4);
        self.add("OpenPrinter", 3);
        self.add("OpenPrivateNamespace", 2);
        self.add("OpenProcess", 3);
        self.add("OpenProcessToken", 3);
        self.add("OpenRegStream", 4);
        self.add("OpenResourceManager", 3);
        self.add("OpenSCManager", 3);
        self.add("OpenSemaphore", 3);
        self.add("OpenSemaphoreW", 3);
        self.add("OpenService", 3);
        self.add("OpenStreamOnFile", 6);
        self.add("OpenThemeData", 2);
        self.add("OpenThemeDataEx", 3);
        self.add("OpenThread", 3);
        self.add("OpenThreadToken", 4);
        self.add("OpenThreadWaitChainSession", 2);
        self.add("OpenTnefStream", 7);
        self.add("OpenTnefStreamEx", 8);
        self.add("OpenTrace", 1);
        self.add("OpenTransaction", 2);
        self.add("OpenTransactionManager", 3);
        self.add("OpenTransactionManagerById", 3);
        self.add("OpenVirtualDisk", 6);
        self.add("OpenWaitableTimer", 3);
        self.add("OpenWaitableTimerW", 3);
        self.add("OpenWindowStation", 3);
        self.add("outp", 2);
        self.add("outpd", 2);
        self.add("OutputDebugString", 1);
        self.add("OutputDebugStringWrapW", 1);
        self.add("outpw", 2);
        self.add("PackageFamilyNameFromFullName", 3);
        self.add("PackageFamilyNameFromId", 3);
        self.add("PackageFullNameFromId", 3);
        self.add("PackageIdFromFullName", 4);
        self.add("PackageNameAndPublisherIdFromFamilyName", 5);
        self.add("PackDDElParam", 3);
        self.add("PackTouchHitTestingProximityEvaluation", 2);
        self.add("PageSetupDlg", 1);
        self.add("PaintDesktop", 1);
        self.add("PaintRgn", 2);
        self.add("PallocateAdapterChannel", 5);
        self.add("PallocateAdapterChannelEx", 8);
        self.add("PallocateCommonBuffer", 4);
        self.add("PallocateCommonBufferEx", 6);
        self.add("PallocateCommonBufferVector", 9);
        self.add("PallocateCommonBufferWithBounds", 8);
        self.add("PallocateDomainCommonBuffer", 9);
        self.add("ParseField", 4);
        self.add("ParseNetworkString", 5);
        self.add("ParseURL", 2);
        self.add("ParseURLA", 2);
        self.add("ParseURLW", 2);
        self.add("ParseX509EncodedCertificateForListBoxEntry", 4);
        self.add("PatBlt", 6);
        self.add("PathAddBackslash", 1);
        self.add("PathAddBackslashA", 1);
        self.add("PathAddBackslashW", 1);
        self.add("PathAddExtension", 2);
        self.add("PathAddExtensionA", 2);
        self.add("PathAddExtensionW", 2);
        self.add("PathAppend", 2);
        self.add("PathAppendA", 2);
        self.add("PathAppendW", 2);
        self.add("PathBuildRoot", 2);
        self.add("PathBuildRootA", 2);
        self.add("PathBuildRootW", 2);
        self.add("PathCanonicalize", 2);
        self.add("PathCanonicalizeA", 2);
        self.add("PathCanonicalizeW", 2);
        self.add("PathCleanupSpec", 2);
        self.add("PathCombine", 3);
        self.add("PathCombineA", 3);
        self.add("PathCombineW", 3);
        self.add("PathCommonPrefix", 3);
        self.add("PathCommonPrefixA", 3);
        self.add("PathCommonPrefixW", 3);
        self.add("PathCompactPath", 3);
        self.add("PathCompactPathA", 3);
        self.add("PathCompactPathEx", 4);
        self.add("PathCompactPathExA", 4);
        self.add("PathCompactPathExW", 4);
        self.add("PathCompactPathW", 3);
        self.add("PathCreateFromUrl", 4);
        self.add("PathCreateFromUrlA", 4);
        self.add("PathCreateFromUrlAlloc", 3);
        self.add("PathCreateFromUrlW", 4);
        self.add("PathFileExists", 1);
        self.add("PathFileExistsA", 1);
        self.add("PathFileExistsW", 1);
        self.add("PathFindExtension", 1);
        self.add("PathFindExtensionA", 1);
        self.add("PathFindExtensionW", 1);
        self.add("PathFindFileName", 1);
        self.add("PathFindFileNameA", 1);
        self.add("PathFindFileNameW", 1);
        self.add("PathFindNextComponent", 1);
        self.add("PathFindNextComponentA", 1);
        self.add("PathFindNextComponentW", 1);
        self.add("PathFindOnPath", 2);
        self.add("PathFindOnPathA", 2);
        self.add("PathFindOnPathW", 2);
        self.add("PathFindSuffixArray", 3);
        self.add("PathFindSuffixArrayA", 3);
        self.add("PathFindSuffixArrayW", 3);
        self.add("PathGetArgs", 1);
        self.add("PathGetArgsA", 1);
        self.add("PathGetArgsW", 1);
        self.add("PathGetCharType", 1);
        self.add("PathGetCharTypeA", 1);
        self.add("PathGetCharTypeW", 1);
        self.add("PathGetDriveNumber", 1);
        self.add("PathGetDriveNumberA", 1);
        self.add("PathGetDriveNumberW", 1);
        self.add("PathGetPathDisplayName", 3);
        self.add("PathGetShortPath", 1);
        self.add("PathIsContentType", 2);
        self.add("PathIsContentTypeA", 2);
        self.add("PathIsContentTypeW", 2);
        self.add("PathIsDirectory", 1);
        self.add("PathIsDirectoryA", 1);
        self.add("PathIsDirectoryEmpty", 1);
        self.add("PathIsDirectoryEmptyA", 1);
        self.add("PathIsDirectoryEmptyW", 1);
        self.add("PathIsDirectoryW", 1);
        self.add("PathIsExe", 1);
        self.add("PathIsFileSpec", 1);
        self.add("PathIsFileSpecA", 1);
        self.add("PathIsFileSpecW", 1);
        self.add("PathIsHTMLFile", 1);
        self.add("PathIsLFNFileSpec", 1);
        self.add("PathIsLFNFileSpecA", 1);
        self.add("PathIsLFNFileSpecW", 1);
        self.add("PathIsNetworkPath", 1);
        self.add("PathIsNetworkPathA", 1);
        self.add("PathIsNetworkPathW", 1);
        self.add("PathIsPrefix", 2);
        self.add("PathIsPrefixA", 2);
        self.add("PathIsPrefixW", 2);
        self.add("PathIsRelative", 1);
        self.add("PathIsRelativeA", 1);
        self.add("PathIsRelativeW", 1);
        self.add("PathIsRoot", 1);
        self.add("PathIsRootA", 1);
        self.add("PathIsRootW", 1);
        self.add("PathIsSameRoot", 2);
        self.add("PathIsSameRootA", 2);
        self.add("PathIsSameRootW", 2);
        self.add("PathIsSlow", 2);
        self.add("PathIsSystemFolder", 2);
        self.add("PathIsSystemFolderA", 2);
        self.add("PathIsSystemFolderW", 2);
        self.add("PathIsTemporary", 1);
        self.add("PathIsUNC", 1);
        self.add("PathIsUNCA", 1);
        self.add("PathIsUNCServer", 1);
        self.add("PathIsUNCServerA", 1);
        self.add("PathIsUNCServerShare", 1);
        self.add("PathIsUNCServerShareA", 1);
        self.add("PathIsUNCServerShareW", 1);
        self.add("PathIsUNCServerW", 1);
        self.add("PathIsUNCW", 1);
        self.add("PathIsURL", 1);
        self.add("PathIsURLA", 1);
        self.add("PathIsURLW", 1);
        self.add("PathMakePretty", 1);
        self.add("PathMakePrettyA", 1);
        self.add("PathMakePrettyW", 1);
        self.add("PathMakeSystemFolder", 1);
        self.add("PathMakeSystemFolderA", 1);
        self.add("PathMakeSystemFolderW", 1);
        self.add("PathMakeUniqueName", 5);
        self.add("PathMatchSpec", 2);
        self.add("PathMatchSpecA", 2);
        self.add("PathMatchSpecEx", 3);
        self.add("PathMatchSpecExA", 3);
        self.add("PathMatchSpecExW", 3);
        self.add("PathMatchSpecW", 2);
        self.add("PathParseIconLocation", 1);
        self.add("PathParseIconLocationA", 1);
        self.add("PathParseIconLocationW", 1);
        self.add("PathProcessCommand", 4);
        self.add("PathQuoteSpaces", 1);
        self.add("PathQuoteSpacesA", 1);
        self.add("PathQuoteSpacesW", 1);
        self.add("PathRelativePathTo", 5);
        self.add("PathRelativePathToA", 5);
        self.add("PathRelativePathToW", 5);
        self.add("PathRemoveArgs", 1);
        self.add("PathRemoveArgsA", 1);
        self.add("PathRemoveArgsW", 1);
        self.add("PathRemoveBackslash", 1);
        self.add("PathRemoveBackslashA", 1);
        self.add("PathRemoveBackslashW", 1);
        self.add("PathRemoveBlanks", 1);
        self.add("PathRemoveBlanksA", 1);
        self.add("PathRemoveBlanksW", 1);
        self.add("PathRemoveExtension", 1);
        self.add("PathRemoveExtensionA", 1);
        self.add("PathRemoveExtensionW", 1);
        self.add("PathRemoveFileSpec", 1);
        self.add("PathRemoveFileSpecA", 1);
        self.add("PathRemoveFileSpecW", 1);
        self.add("PathRenameExtension", 2);
        self.add("PathRenameExtensionA", 2);
        self.add("PathRenameExtensionW", 2);
        self.add("PathResolve", 3);
        self.add("PathSearchAndQualify", 3);
        self.add("PathSearchAndQualifyA", 3);
        self.add("PathSearchAndQualifyW", 3);
        self.add("PathSetDlgItemPath", 3);
        self.add("PathSetDlgItemPathA", 3);
        self.add("PathSetDlgItemPathW", 3);
        self.add("PathSkipRoot", 1);
        self.add("PathSkipRootA", 1);
        self.add("PathSkipRootW", 1);
        self.add("PathStripPath", 1);
        self.add("PathStripPathA", 1);
        self.add("PathStripPathW", 1);
        self.add("PathStripToRoot", 1);
        self.add("PathStripToRootA", 1);
        self.add("PathStripToRootW", 1);
        self.add("PathToRegion", 1);
        self.add("PathUndecorate", 1);
        self.add("PathUndecorateA", 1);
        self.add("PathUndecorateW", 1);
        self.add("PathUnExpandEnvStrings", 3);
        self.add("PathUnExpandEnvStringsA", 3);
        self.add("PathUnExpandEnvStringsForUserW", 4);
        self.add("PathUnExpandEnvStringsW", 3);
        self.add("PathUnExpandSystemEnvStringsW", 3);
        self.add("PathUnmakeSystemFolder", 1);
        self.add("PathUnmakeSystemFolderA", 1);
        self.add("PathUnmakeSystemFolderW", 1);
        self.add("PathUnquoteSpaces", 1);
        self.add("PathUnquoteSpacesA", 1);
        self.add("PathUnquoteSpacesW", 1);
        self.add("PathYetAnotherMakeUniqueName", 4);
        self.add("PbuildMdlFromScatterGatherList", 4);
        self.add("PbuildScatterGatherList", 10);
        self.add("PbuildScatterGatherListEx", 15);
        self.add("PcalculateScatterGatherListSize", 6);
        self.add("PcancelAdapterChannel", 3);
        self.add("PcancelMappedTransfer", 2);
        self.add("PciMsixMaskunmaskEntry", 2);
        self.add("PciMsixSetEntry", 3);
        self.add("PclfsClientAdvanceTailCallback", 3);
            self.add("PclfsClientLffHandlerCompleteCallback", 4);
        self.add("PclfsClientLogUnpinnedCallback", 2);
        self.add("pclose", 1);
        self.add("p__commode", 0);
        self.add("PconfigureAdapterChannel", 3);
        self.add("pctype_func", 0);
        self.add("PdhAddCounter", 4);
        self.add("PdhAddEnglishCounter", 4);
        self.add("PdhBindInputDataSource", 2);
        self.add("PdhBrowseCounters", 1);
        self.add("PdhBrowseCountersH", 1);
        self.add("PdhCalculateCounterFromRawValue", 5);
        self.add("PdhCloseLog", 2);
        self.add("PdhCloseQuery", 1);
        self.add("PdhCollectQueryData", 1);
        self.add("PdhCollectQueryDataEx", 3);
        self.add("PdhCollectQueryDataWithTime", 2);
        self.add("PdhComputeCounterStatistics", 6);
        self.add("PdhConnectMachine", 1);
        self.add("PdhEnumLogSetNames", 3);
        self.add("PdhEnumMachines", 3);
        self.add("PdhEnumMachinesH", 3);
        self.add("PdhEnumObjectItems", 9);
        self.add("PdhEnumObjectItemsH", 9);
        self.add("PdhEnumObjects", 6);
        self.add("PdhEnumObjectsH", 6);
        self.add("PdhExpandCounterPath", 3);
        self.add("PdhExpandWildCardPath", 5);
        self.add("PdhExpandWildCardPathH", 5);
        self.add("PdhFormatFromRawValue", 6);
        self.add("PdhGetCounterInfo", 4);
        self.add("PdhGetCounterTimeBase", 2);
        self.add("PdhGetDataSourceTimeRange", 4);
        self.add("PdhGetDataSourceTimeRangeH", 4);
        self.add("PdhGetDefaultPerfCounter", 5);
        self.add("PdhGetDefaultPerfCounterH", 5);
        self.add("PdhGetDefaultPerfObject", 4);
        self.add("PdhGetDefaultPerfObjectH", 4);
        self.add("PdhGetDllVersion", 1);
        self.add("PdhGetFormattedCounterArray", 5);
        self.add("PdhGetFormattedCounterValue", 4);
        self.add("PdhGetLogFileSize", 2);
        self.add("PdhGetRawCounterArray", 4);
        self.add("PdhGetRawCounterValue", 3);
        self.add("PdhIsRealTimeQuery", 1);
        self.add("PdhLookupPerfIndexByName", 3);
        self.add("PdhLookupPerfNameByIndex", 4);
        self.add("PdhMakeCounterPath", 4);
        self.add("PdhOpenLog", 7);
        self.add("PdhOpenQuery", 3);
        self.add("PdhOpenQueryH", 3);
        self.add("PdhParseCounterPath", 4);
        self.add("PdhParseInstanceName", 6);
        self.add("PdhReadRawLogRecord", 4);
        self.add("PdhRemoveCounter", 1);
        self.add("PdhSelectDataSource", 4);
        self.add("PdhSetCounterScaleFactor", 2);
        self.add("PdhSetDefaultRealTimeDataSource", 1);
        self.add("PdhSetQueryTimeRange", 2);
        self.add("PdhUpdateLog", 2);
        self.add("PdhUpdateLogFileCatalog", 1);
        self.add("PdhValidatePath", 1);
        self.add("PdhValidatePathEx", 2);
        self.add("PeekConsoleInput", 4);
        self.add("PeekMessage", 5);
        self.add("PeekMessageA", 5);
        self.add("PeekMessageW", 5);
        self.add("PeekNamedPipe", 6);
        self.add("PeerDistClientAddContentInformation", 5);
        self.add("PeerDistClientAddData", 5);
        self.add("PeerDistClientBlockRead", 6);
        self.add("PeerDistClientCancelAsyncOperation", 3);
        self.add("PeerDistClientCloseContent", 2);
        self.add("PeerDistClientCompleteContentInformation", 3);
        self.add("PeerDistClientFlushContent", 5);
        self.add("PeerDistClientGetInformationByHandle", 5);
        self.add("PeerDistClientOpenContent", 5);
        self.add("PeerDistClientStreamRead", 6);
        self.add("PeerDistGetOverlappedResult", 3);
        self.add("PeerDistGetStatus", 2);
        self.add("PeerDistGetStatusEx", 2);
        self.add("PeerDistRegisterForStatusChangeNotification", 5);
        self.add("PeerDistRegisterForStatusChangeNotificationEx", 5);
        self.add("PeerDistServerCancelAsyncOperation", 4);
        self.add("PeerDistServerCloseContentInformation", 2);
        self.add("PeerDistServerCloseStreamHandle", 2);
        self.add("PeerDistServerOpenContentInformation", 8);
        self.add("PeerDistServerOpenContentInformationEx", 9);
        self.add("PeerDistServerPublishAddToStream", 5);
        self.add("PeerDistServerPublishCompleteStream", 3);
        self.add("PeerDistServerPublishStream", 8);
        self.add("PeerDistServerRetrieveContentInformation", 5);
        self.add("PeerDistServerUnpublish", 3);
        self.add("PeerDistShutdown", 1);
        self.add("PeerDistStartup", 3);
        self.add("PeerDistUnregisterForStatusChangeNotification", 1);
        self.add("PerfCreateInstance", 4);
        self.add("PerfDecrementULongCounterValue", 4);
        self.add("PerfDecrementULongLongCounterValue", 4);
        self.add("PerfDeleteInstance", 2);
        self.add("PerfIncrementULongCounterValue", 4);
        self.add("PerfIncrementULongLongCounterValue", 4);
        self.add("PerformOperationOverUrlCacheA", 9);
        self.add("PerfQueryInstance", 4);
        self.add("PerfSetCounterRefValue", 4);
        self.add("PerfSetCounterSetInfo", 3);
        self.add("PerfSetULongCounterValue", 4);
        self.add("PerfSetULongLongCounterValue", 4);
        self.add("PerfStartProvider", 3);
        self.add("PerfStartProviderEx", 3);
        self.add("PerfStopProvider", 1);
        self.add("perror", 1);
        self.add("PerUserInit", 0);
        self.add("PfltCompletedAsyncIoCallback", 2);
            self.add("PfltCompleteLockCallbackDataRoutine", 2);
        self.add("PfltContextAllocateCallback", 3);
        self.add("PfltContextCleanupCallback", 2);
        self.add("PfltContextFreeCallback", 2);
        self.add("PfltFilterUnloadCallback", 1);
        self.add("PfltGenerateFileName", 6);
        self.add("PfltGetOperationStatusCallback", 4);
            self.add("PfltInstanceQueryTeardownCallback", 2);
        self.add("PfltInstanceSetupCallback", 4);
        self.add("PfltInstanceTeardownCallback", 2);
        self.add("PfltNormalizeContextCleanup", 1);
        self.add("PfltNormalizeNameComponent", 8);
        self.add("PfltNormalizeNameComponentEx", 9);
        self.add("PfltPostOperationCallback", 4);
        self.add("PfltPreOperationCallback", 3);
            self.add("PfltSectionConflictNotificationCallback", 3);
            self.add("PfltTransactionNotificationCallback", 3);
        self.add("PflushAdapterBuffers", 6);
        self.add("PflushAdapterBuffersEx", 6);
        self.add("PflushDmaBuffer", 3);
        self.add("p__fmode", 0);
        self.add("PfreeAdapterChannel", 1);
        self.add("PfreeAdapterObject", 2);
        self.add("PfreeCommonBuffer", 5);
        self.add("PfreeCommonBufferFromVector", 3);
        self.add("PfreeCommonBufferVector", 2);
        self.add("PfreeMapRegisters", 3);
            self.add("PfsrtlExtraCreateParameterCleanupCallback", 2);
        self.add("PFXExportCertStore", 4);
        self.add("PFXExportCertStoreEx", 5);
        self.add("PfxFindPrefix", 2);
        self.add("PFXImportCertStore", 3);
        self.add("PfxInitialize", 1);
        self.add("PfxInsertPrefix", 3);
        self.add("PFXIsPFXBlob", 1);
        self.add("PfxRemovePrefix", 2);
        self.add("PFXVerifyPassword", 3);
            self.add("PgetCommonBufferFromVectorByIndex", 5);
        self.add("PgetDmaAdapterInfo", 2);
        self.add("PgetDmaAlignment", 1);
        self.add("PgetDmaDomain", 1);
        self.add("PgetDmaTransferInfo", 6);
        self.add("PgetScatterGatherList", 8);
        self.add("PgetScatterGatherListEx", 13);
        self.add("PhysicalToLogicalPoint", 2);
        self.add("PickIconDlg", 4);
        self.add("Pie", 9);
        self.add("PifMgr_CloseProperties", 2);
        self.add("PifMgr_GetProperties", 5);
        self.add("PifMgr_OpenProperties", 4);
        self.add("PifMgr_SetProperties", 5);
        self.add("PinitializeDmaTransferContext", 2);
        self.add("PinitOnceFn", 3);
        self.add("PinterfaceDereference", 1);
        self.add("PinterfaceReference", 1);
        self.add("pipe", 3);
        self.add("PjoinDmaDomain", 2);
        self.add("PlayEnhMetaFile", 3);
        self.add("PlayEnhMetaFileRecord", 4);
        self.add("PlayMetaFile", 2);
        self.add("PlayMetaFileRecord", 4);
        self.add("PlaySound", 3);
        self.add("PL_CompareStrings", 2);
        self.add("PL_CompareValues", 2);
        self.add("PleaveDmaDomain", 1);
        self.add("PlgBlt", 10);
        self.add("PL_HashString", 1);
        self.add("PL_HashTableAdd", 3);
        self.add("PL_HashTableDestroy", 1);
        self.add("PL_HashTableEnumerateEntries", 3);
        self.add("PL_HashTableLookup", 2);
        self.add("PL_HashTableRemove", 2);
        self.add("PL_NewHashTable", 6);
        self.add("PlogFullHandlerCallback", 4);
        self.add("PlogTailAdvanceCallback", 3);
        self.add("PlogUnpinnedCallback", 2);
        self.add("PL_strcpy", 2);
        self.add("PL_strdup", 1);
        self.add("PL_strfree", 1);
        self.add("PL_strlen", 1);
        self.add("PmapTransfer", 6);
        self.add("PmapTransferEx", 11);
        self.add("PobPostOperationCallback", 2);
        self.add("PobPreOperationCallback", 2);
        self.add("PoCallDriver", 2);
        self.add("PoClearPowerRequest", 2);
        self.add("PoCreatePowerRequest", 3);
        self.add("PoDeletePowerRequest", 1);
        self.add("PoEndDeviceBusy", 1);
        self.add("PoFxActivateComponent", 3);
            self.add("PoFxCompleteDevicePowerNotRequired", 1);
        self.add("PoFxCompleteDirectedPowerDown", 1);
        self.add("PoFxCompleteIdleCondition", 2);
        self.add("PoFxCompleteIdleState", 2);
            self.add("PoFxComponentActiveConditionCallback", 2);
            self.add("PoFxComponentCriticalTransitionCallback", 3);
            self.add("PoFxComponentIdleConditionCallback", 2);
        self.add("PoFxComponentIdleStateCallback", 3);
        self.add("PoFxComponentPerfStateCallback", 4);
            self.add("PoFxDevicePowerNotRequiredCallback", 1);
        self.add("PoFxDevicePowerRequiredCallback", 1);
        self.add("PoFxDirectedPowerDownCallback", 2);
        self.add("PoFxDirectedPowerUpCallback", 2);
        self.add("PoFxIdleComponent", 3);
            self.add("PoFxIssueComponentPerfStateChange", 5);
            self.add("PoFxIssueComponentPerfStateChangeMultiple", 6);
        self.add("PoFxNotifySurprisePowerOn", 1);
        self.add("PoFxPowerControl", 7);
        self.add("PoFxPowerControlCallback", 7);
        self.add("PoFxPowerOnCrashdumpDevice", 2);
            self.add("PoFxQueryCurrentComponentPerfState", 5);
        self.add("PoFxRegisterComponentPerfStates", 6);
        self.add("PoFxRegisterCrashdumpDevice", 1);
        self.add("PoFxRegisterDevice", 3);
        self.add("PoFxReportDevicePoweredOn", 1);
        self.add("PoFxSetComponentLatency", 3);
        self.add("PoFxSetComponentResidency", 3);
        self.add("PoFxSetComponentWake", 3);
        self.add("PoFxSetDeviceIdleTimeout", 2);
            self.add("PoFxSetTargetDripsDevicePowerState", 2);
        self.add("PoFxStartDevicePowerManagement", 1);
        self.add("PoFxUnregisterDevice", 1);
        self.add("PoGetSystemWake", 1);
        self.add("PolyBezier", 3);
        self.add("PolyBezierTo", 3);
        self.add("PolyDraw", 4);
        self.add("Polygon", 3);
        self.add("Polyline", 3);
        self.add("PolylineTo", 3);
        self.add("PolyPolygon", 4);
        self.add("PolyPolyline", 4);
        self.add("PolyTextOut", 3);
        self.add("PolyTextOutA", 3);
        self.add("PolyTextOutW", 3);
        self.add("popen", 2);
        self.add("PopEntryList", 1);
        self.add("PoQueryWatchdogTime", 2);
            self.add("PoRegisterDeviceForIdleDetection", 4);
        self.add("PoRegisterPowerSettingCallback", 5);
        self.add("PoRegisterSystemState", 2);
        self.add("PoRequestPowerIrp", 6);
        self.add("PoSetDeviceBusyEx", 1);
        self.add("PoSetPowerRequest", 2);
        self.add("PoSetPowerState", 3);
        self.add("PoSetSystemState", 1);
        self.add("PoSetSystemWake", 1);
        self.add("PoSetSystemWakeDevice", 1);
        self.add("PoStartDeviceBusy", 1);
        self.add("PoStartNextPowerIrp", 1);
        self.add("PostMessage", 4);
        self.add("PostMessageA", 4);
        self.add("PostMessageW", 4);
        self.add("PostQueuedCompletionStatus", 4);
        self.add("PostQuitMessage", 1);
        self.add("PostThreadMessage", 4);
        self.add("PostThreadMessageA", 4);
        self.add("PostThreadMessageW", 4);
            self.add("PoUnregisterPowerSettingCallback", 1);
        self.add("PoUnregisterSystemState", 1);
        self.add("pow", 2);
        self.add("PowerCanRestoreIndividualDefaultPowerScheme", 1);
        self.add("PowerClearRequest", 2);
        self.add("PowerCreatePossibleSetting", 4);
        self.add("PowerCreateRequest", 1);
        self.add("PowerCreateSetting", 3);
        self.add("PowerDeleteScheme", 2);
        self.add("PowerDeterminePlatformRole", 0);
        self.add("PowerDeterminePlatformRoleEx", 1);
        self.add("PowerDuplicateScheme", 3);
        self.add("PowerEnumerate", 7);
        self.add("PowerGetActiveScheme", 2);
        self.add("PowerImportPowerScheme", 3);
        self.add("PowerIsSettingRangeDefined", 2);
        self.add("PowerReadACDefaultIndex", 5);
        self.add("PowerReadACValue", 7);
        self.add("PowerReadACValueIndex", 5);
        self.add("PowerReadDCDefaultIndex", 5);
        self.add("PowerReadDCValue", 7);
        self.add("PowerReadDCValueIndex", 5);
        self.add("PowerReadDescription", 6);
        self.add("PowerReadFriendlyName", 6);
        self.add("PowerReadIconResourceSpecifier", 6);
        self.add("PowerReadPossibleDescription", 6);
        self.add("PowerReadPossibleFriendlyName", 6);
        self.add("PowerReadPossibleValue", 7);
        self.add("PowerReadSettingAttributes", 2);
        self.add("PowerReadValueIncrement", 4);
        self.add("PowerReadValueMax", 4);
        self.add("PowerReadValueMin", 4);
        self.add("PowerReadValueUnitsSpecifier", 5);
        self.add("PowerRegisterSuspendResumeNotification", 3);
        self.add("PowerRemovePowerSetting", 2);
        self.add("PowerReplaceDefaultPowerSchemes", 0);
        self.add("PowerRestoreDefaultPowerSchemes", 0);
        self.add("PowerRestoreIndividualDefaultPowerScheme", 1);
        self.add("PowerSetActiveScheme", 2);
        self.add("PowerSetRequest", 2);
        self.add("PowerSettingAccessCheck", 2);
        self.add("PowerSettingAccessCheckEx", 3);
        self.add("PowerSettingRegisterNotification", 4);
        self.add("PowerSettingUnregisterNotification", 1);
        self.add("PowerUnregisterSuspendResumeNotification", 1);
        self.add("PowerWriteACDefaultIndex", 5);
        self.add("PowerWriteACValueIndex", 5);
        self.add("PowerWriteDCDefaultIndex", 5);
        self.add("PowerWriteDCValueIndex", 5);
        self.add("PowerWriteDescription", 6);
        self.add("PowerWriteFriendlyName", 6);
        self.add("PowerWriteIconResourceSpecifier", 6);
        self.add("PowerWritePossibleDescription", 6);
        self.add("PowerWritePossibleFriendlyName", 6);
        self.add("PowerWritePossibleValue", 7);
        self.add("PowerWriteSettingAttributes", 3);
        self.add("PowerWriteValueIncrement", 4);
        self.add("PowerWriteValueMax", 4);
        self.add("PowerWriteValueMin", 4);
        self.add("PowerWriteValueUnitsSpecifier", 5);
        self.add("powf", 2);
        self.add("PpropFindProp", 3);
        self.add("PputDmaAdapter", 1);
        self.add("PputScatterGatherList", 3);
        self.add("PR_Accept", 3);
        self.add("PR_AcceptRead", 6);
        self.add("PR_Access", 2);
        self.add("PR_AtomicAdd", 2);
        self.add("PR_AtomicDecrement", 1);
        self.add("PR_AtomicIncrement", 1);
        self.add("PR_AtomicSet", 2);
        self.add("PR_AttachSharedMemory", 2);
        self.add("PR_AttachThread", 3);
        self.add("PR_Available", 1);
        self.add("PR_Available64", 1);
        self.add("PR_Bind", 2);
        self.add("PR_Calloc", 2);
        self.add("PR_CEnterMonitor", 1);
        self.add("PR_CExitMonitor", 1);
        self.add("PR_ClearInterrupt", 0);
        self.add("PR_Close", 1);
        self.add("PR_CloseDir", 1);
        self.add("PR_CloseFileMap", 1);
        self.add("PR_CloseSemaphore", 1);
        self.add("PR_CloseSharedMemory", 1);
        self.add("PR_CNotify", 1);
        self.add("PR_CNotifyAll", 1);
        self.add("PR_cnvtf", 4);
        self.add("PR_Connect", 3);
        self.add("PR_CreateFileMap", 3);
        self.add("PR_CreateIOLayerStub", 2);
        self.add("PR_CreatePipe", 2);
        self.add("PR_CreateProcess", 4);
        self.add("PR_CreateStack", 1);
        self.add("PR_CreateThread", 7);
        self.add("PR_CWait", 2);
        self.add("PR_DeleteSemaphore", 1);
        self.add("PR_DeleteSharedMemory", 1);
        self.add("PR_DestroyCondVar", 1);
        self.add("PR_DestroyLock", 1);
        self.add("PR_DestroyMonitor", 1);
        self.add("PR_DestroyPollableEvent", 1);
        self.add("PR_DestroyProcessAttr", 1);
        self.add("PR_DestroyStack", 1);
        self.add("PR_DetachProcess", 1);
        self.add("PR_DetachSharedMemory", 2);
        self.add("PR_DetachThread", 0);
        self.add("PR_dtoa", 8);
        self.add("PreadDmaCounter", 1);
        self.add("PreenumerateSelf", 1);
        self.add("PrefetchVirtualMemory", 4);
        self.add("PR_EnterMonitor", 1);
        self.add("PR_EnumerateHostEnt", 4);
        self.add("PrepareComplete", 2);
        self.add("PrepareEnlistment", 2);
        self.add("PrepareLogArchive", 12);
        self.add("PrepareTape", 3);
        self.add("PrePrepareComplete", 2);
        self.add("PrePrepareEnlistment", 2);
        self.add("PreprocessMessage", 10);
        self.add("PR_ExitMonitor", 1);
        self.add("PR_ExplodeTime", 3);
        self.add("PR_ExportFileMapAsString", 3);
        self.add("PR_FindSymbol", 2);
        self.add("PR_FindSymbolAndLibrary", 2);
        self.add("PR_Free", 1);
        self.add("PR_FreeLibraryName", 1);
        self.add("PR_GetConnectStatus", 1);
        self.add("PR_GetCurrentThread", 0);
        self.add("PR_GetDefaultIOMethods", 0);
        self.add("PR_GetDescType", 1);
        self.add("PR_GetError", 0);
        self.add("PR_GetErrorText", 1);
        self.add("PR_GetErrorTextLength", 0);
        self.add("PR_GetFileInfo", 2);
        self.add("PR_GetFileInfo64", 2);
        self.add("PR_GetHostByAddr", 4);
        self.add("PR_GetHostByName", 4);
        self.add("PR_GetIdentitiesLayer", 2);
        self.add("PR_GetInheritedFileMap", 1);
        self.add("PR_GetLayersIdentity", 1);
        self.add("PR_GetLibraryName", 2);
        self.add("PR_GetLibraryPath", 0);
        self.add("PR_GetNameForIdentity", 1);
        self.add("PR_GetOpenFileInfo", 2);
        self.add("PR_GetOpenFileInfo64", 2);
        self.add("PR_GetOSError", 0);
        self.add("PR_GetPeerName", 2);
        self.add("PR_GetProtoByName", 4);
        self.add("PR_GetProtoByNumber", 4);
        self.add("PR_GetRandomNoise", 2);
        self.add("PR_GetSocketOption", 2);
        self.add("PR_GetSockName", 2);
        self.add("PR_GetSpecialFD", 1);
        self.add("PR_GetThreadPriority", 1);
        self.add("PR_GetThreadPrivate", 1);
        self.add("PR_GetThreadScope", 0);
        self.add("PR_GetUniqueIdentity", 1);
        self.add("PR_GMTParameters", 1);
        self.add("PR_htonl", 1);
        self.add("PR_htons", 1);
        self.add("PR_ImplodeTime", 1);
        self.add("PR_ImportFileMapFromString", 1);
        self.add("PR_InitializeNetAddr", 3);
        self.add("PrintDlg", 1);
        self.add("PrintDlgEx", 1);
        self.add("Printer_AddPrinterPropPages", 2);
        self.add("Printer_LoadIconsW", 3);
        self.add("PrinterProperties", 2);
        self.add("PR_Interrupt", 1);
        self.add("Printers_RegisterWindowW", 4);
        self.add("Printers_UnregisterWindow", 2);
        self.add("PR_IntervalNow", 0);
        self.add("PR_IntervalToMicroseconds", 1);
        self.add("PR_IntervalToMilliseconds", 1);
        self.add("PR_IntervalToSeconds", 1);
        self.add("printf", 1);
        self.add("printf_l", 2);
        self.add("printf_p", 1);
        self.add("printf_p_l", 2);
        self.add("printf_s", 1);
        self.add("printf_s_l", 2);
        self.add("PrintWindow", 3);
        self.add("PrivacyGetZonePreferenceW", 5);
        self.add("PrivacySetZonePreferenceW", 4);
        self.add("PrivateExtractIcons", 8);
        self.add("PrivilegeCheck", 3);
        self.add("PrivilegedServiceAuditAlarm", 5);
        self.add("PR_JoinThread", 1);
        self.add("PR_KillProcess", 1);
        self.add("PR_Listen", 2);
        self.add("PR_LoadLibrary", 1);
        self.add("PR_LocalTimeParameters", 1);
        self.add("PR_Lock", 1);
        self.add("PR_MemMap", 3);
        self.add("PR_MemUnmap", 2);
        self.add("PR_MicrosecondsToInterval", 1);
        self.add("PR_MillisecondsToInterval", 1);
        self.add("PR_MkDir", 2);
        self.add("PR_NetAddrToString", 3);
        self.add("PR_NewCondVar", 1);
        self.add("PR_NewLock", 0);
        self.add("PR_NewMonitor", 0);
        self.add("PR_NewPollableEvent", 0);
        self.add("PR_NewProcessAttr", 0);
        self.add("PR_NewTCPSocket", 0);
        self.add("PR_NewThreadPrivateIndex", 2);
        self.add("PR_NewUDPSocket", 0);
        self.add("PR_NormalizeTime", 2);
        self.add("PR_Notify", 1);
        self.add("PR_NotifyAll", 1);
        self.add("PR_NotifyAllCondVar", 1);
        self.add("PR_NotifyCondVar", 1);
        self.add("PR_Now", 0);
        self.add("PR_ntohl", 1);
        self.add("PR_ntohs", 1);
        self.add("ProbeForRead", 3);
        self.add("ProbeForWrite", 3);
        self.add("Process32First", 2);
        self.add("Process32Next", 2);
        self.add("ProcessBufferedPacketsInteractionContext", 1);
        self.add("ProcessGroupPolicyCompleted", 3);
        self.add("ProcessGroupPolicyCompletedEx", 4);
        self.add("ProcessIdToSessionId", 2);
        self.add("ProcessInertiaInteractionContext", 1);
        self.add("ProcessorHaltRoutine", 1);
        self.add("ProcessPointerFramesInteractionContext", 4);
        self.add("ProcessSocketNotifications", 7);
        self.add("ProcessTrace", 4);
        self.add("ProgIDFromCLSID", 2);
        self.add("PropCopyMore", 4);
        self.add("PR_Open", 3);
        self.add("PR_OpenAnonFileMap", 3);
        self.add("PR_OpenDir", 1);
        self.add("PR_OpenSemaphore", 4);
        self.add("PR_OpenSharedMemory", 4);
        self.add("PR_OpenTCPSocket", 1);
        self.add("PR_OpenUDPSocket", 1);
        self.add("Propenumproca", 3);
        self.add("Propenumprocexa", 4);
        self.add("Propenumprocexw", 4);
        self.add("Propenumprocw", 3);
        self.add("PropertySheet", 1);
        self.add("PropStgNameToFmtId", 2);
        self.add("PropVariantClear", 1);
        self.add("PropVariantCopy", 2);
        self.add("PR_Poll", 3);
        self.add("PR_PopIOLayer", 2);
        self.add("PR_PostSemaphore", 1);
        self.add("PR_ProcessAttrSetCurrentDirectory", 2);
        self.add("PR_ProcessAttrSetInheritableFD", 3);
        self.add("PR_ProcessAttrSetInheritableFileMap", 3);
        self.add("PR_ProcessAttrSetStdioRedirect", 3);
        self.add("PR_PushIOLayer", 3);
        self.add("PR_Read", 3);
        self.add("PR_ReadDir", 2);
        self.add("PR_Realloc", 2);
        self.add("PR_Recv", 5);
        self.add("PR_RecvFrom", 6);
        self.add("PR_Rename", 2);
        self.add("PR_ResetProcessAttr", 1);
        self.add("PR_RmDir", 1);
        self.add("PR_SecondsToInterval", 1);
        self.add("PR_Seek", 3);
        self.add("PR_Seek64", 3);
        self.add("PR_Send", 5);
        self.add("PR_SendTo", 6);
        self.add("PR_SetConcurrency", 1);
        self.add("PR_SetError", 2);
        self.add("PR_SetErrorText", 2);
        self.add("PR_SetLibraryPath", 1);
        self.add("PR_SetPollableEvent", 1);
        self.add("PR_SetSocketOption", 2);
        self.add("PR_SetThreadPriority", 2);
        self.add("PR_SetThreadPrivate", 2);
        self.add("PR_Shutdown", 2);
        self.add("PR_Sleep", 1);
        self.add("PR_StackPop", 1);
        self.add("PR_StackPush", 2);
        self.add("PR_StringToNetAddr", 2);
        self.add("PR_strtod", 2);
        self.add("PR_Sync", 1);
        self.add("PR_TicksPerSecond", 0);
        self.add("PR_TransmitFile", 6);
        self.add("PR_UnloadLibrary", 1);
        self.add("PR_Unlock", 1);
        self.add("PR_Wait", 2);
        self.add("PR_WaitCondVar", 2);
        self.add("PR_WaitForPollableEvent", 1);
        self.add("PR_WaitProcess", 2);
        self.add("PR_WaitSemaphore", 1);
        self.add("PR_Write", 3);
        self.add("PR_Writev", 4);
        self.add("PsAllocateAffinityToken", 1);
        self.add("PsChargePoolQuota", 3);
        self.add("PSCoerceToCanonicalValue", 2);
        self.add("PSCreateAdapterFromPropertyStore", 3);
        self.add("PSCreateDelayedMultiplexPropertyStore", 6);
        self.add("PSCreateMemoryPropertyStore", 2);
        self.add("PSCreateMultiplexPropertyStore", 4);
        self.add("PSCreatePropertyChangeArray", 6);
        self.add("PSCreatePropertyStoreFromObject", 4);
        self.add("PSCreatePropertyStoreFromPropertySetStorage", 4);
        self.add("PSCreateSimplePropertyChange", 5);
        self.add("PsCreateSystemThread", 7);
        self.add("PsDereferenceImpersonationToken", 1);
        self.add("PsDereferencePrimaryToken", 1);
        self.add("PSEnumeratePropertyDescriptions", 3);
        self.add("PSFormatForDisplay", 5);
        self.add("PSFormatForDisplayAlloc", 4);
        self.add("PSFormatPropertyValue", 4);
        self.add("PsFreeAffinityToken", 1);
        self.add("PsGetCurrentThread", 1);
        self.add("PSGetItemPropertyHandler", 4);
        self.add("PSGetItemPropertyHandlerWithCreateObject", 5);
        self.add("PSGetNamedPropertyFromPropertyStorage", 4);
        self.add("PSGetNameFromPropertyKey", 2);
        self.add("PsGetProcessExitTime", 1);
        self.add("PSGetPropertyDescription", 3);
        self.add("PSGetPropertyDescriptionByName", 3);
        self.add("PSGetPropertyDescriptionListFromString", 3);
        self.add("PSGetPropertyFromPropertyStorage", 4);
        self.add("PSGetPropertyKeyFromName", 2);
        self.add("PSGetPropertySystem", 2);
        self.add("PSGetPropertyValue", 3);
        self.add("PsGetVersion", 4);
        self.add("PsImpersonateClient", 5);
        self.add("PsIsDiskCountersEnabled", 1);
        self.add("PsIsThreadTerminating", 1);
        self.add("PsLookupProcessByProcessId", 2);
        self.add("PSLookupPropertyHandlerCLSID", 2);
        self.add("PsLookupThreadByThreadId", 2);
        self.add("PSPropertyKeyFromString", 2);
        self.add("PsQueryTotalCycleTimeProcess", 2);
        self.add("PsReferenceImpersonationToken", 4);
        self.add("PsReferencePrimaryToken", 1);
        self.add("PSRegisterPropertySchema", 1);
        self.add("PsReturnPoolQuota", 3);
        self.add("PsRevertToSelf", 1);
            self.add("PsRevertToUserMultipleGroupAffinityThread", 1);
        self.add("PSSetPropertyValue", 3);
            self.add("PsSetSystemMultipleGroupAffinityThread", 3);
        self.add("PSStringFromPropertyKey", 3);
        self.add("PsTerminateSystemThread", 1);
        self.add("PSUnregisterPropertySchema", 1);
        self.add("PsUpdateDiskCounters", 6);
        self.add("PTCloseProvider", 1);
        self.add("PTConvertDevModeToPrintTicket", 5);
        self.add("PTConvertPrintTicketToDevMode", 7);
        self.add("PTGetPrintCapabilities", 4);
        self.add("Ptimerapcroutine", 3);
        self.add("PtInRect", 2);
        self.add("PtInRegion", 3);
        self.add("PTMergeAndValidatePrintTicket", 6);
        self.add("PtmRmNotification", 7);
        self.add("PTOpenProvider", 3);
        self.add("PTOpenProviderEx", 5);
        self.add("PTQuerySchemaVersionSupport", 2);
        self.add("PTReleaseMemory", 1);
        self.add("PtVisible", 3);
        self.add("PulseEvent", 1);
        self.add("purecall", 0);
        self.add("PurgeComm", 2);
        self.add("PushEntryList", 2);
        self.add("putc", 2);
        self.add("putch", 1);
        self.add("putchar", 1);
        self.add("putch_nolock", 1);
        self.add("putenv", 1);
        self.add("putenv_s", 2);
        self.add("puts", 1);
        self.add("putw", 2);
        self.add("putwc", 2);
        self.add("putwch", 1);
        self.add("putwchar", 1);
        self.add("putwch_nolock", 1);
        self.add("putws", 1);
        self.add("PvkFreeCryptProv", 4);
        self.add("PvkGetCryptProv", 9);
        self.add("PvkPrivateKeyAcquireContextFromMemory", 9);
        self.add("PvkPrivateKeySave", 6);
        self.add("PxeAsyncRecvDone", 2);
        self.add("PxeDhcpAppendOption", 6);
        self.add("PxeDhcpGetOptionValue", 6);
        self.add("PxeDhcpGetVendorOptionValue", 6);
        self.add("PxeDhcpInitialize", 5);
        self.add("PxeDhcpIsValid", 4);
        self.add("PxeDhcpv6AppendOption", 6);
        self.add("PxeDhcpv6AppendOptionRaw", 5);
        self.add("PxeDhcpv6CreateRelayRepl", 7);
        self.add("PxeDhcpv6GetOptionValue", 6);
        self.add("PxeDhcpv6GetVendorOptionValue", 7);
        self.add("PxeDhcpv6Initialize", 5);
        self.add("PxeDhcpv6IsValid", 4);
        self.add("PxeDhcpv6ParseRelayForw", 7);
        self.add("PxeGetServerInfo", 3);
        self.add("PxeGetServerInfoEx", 4);
        self.add("PxePacketAllocate", 3);
        self.add("PxePacketFree", 3);
        self.add("PxeProviderEnumClose", 1);
        self.add("PxeProviderEnumFirst", 1);
        self.add("PxeProviderEnumNext", 2);
        self.add("PxeProviderFreeInfo", 1);
        self.add("PxeProviderQueryIndex", 2);
        self.add("PxeProviderRegister", 5);
        self.add("PxeProviderSetAttribute", 4);
        self.add("PxeProviderUnRegister", 1);
        self.add("PxeRegisterCallback", 4);
        self.add("PxeSendReply", 4);
        self.add("PxeTrace", 3);
        self.add("QISearch", 4);
        self.add("qsort", 4);
        self.add("qsort_s", 5);
        self.add("QueryActCtxSettingsW", 7);
        self.add("QueryActCtxW", 7);
        self.add("QueryAllTraces", 3);
        self.add("QueryCompressorInformation", 4);
        self.add("QueryContextAttributes", 3);
        self.add("QueryCredentialsAttributes", 3);
        self.add("QueryDecompressorInformation", 4);
        self.add("QueryDepthSList", 1);
        self.add("QueryDosDevice", 3);
        self.add("QueryDosDeviceW", 3);
        self.add("QueryFullProcessImageName", 4);
        self.add("QueryIdleProcessorCycleTime", 2);
        self.add("QueryIdleProcessorCycleTimeEx", 3);
        self.add("QueryInformationJobObject", 5);
        self.add("QueryLayoutOrTipString", 2);
        self.add("QueryLayoutOrTipStringUserReg", 5);
        self.add("QueryLogPolicy", 4);
        self.add("QueryMemoryResourceNotification", 2);
        self.add("?_query_new_handler@@YAP6AHI@ZXZ", 0);
        self.add("?_query_new_mode@@YAHXZ", 0);
        self.add("QueryPathOfRegTypeLib", 5);
        self.add("QueryPerformanceCounter", 1);
        self.add("QueryPerformanceFrequency", 1);
        self.add("QueryProcessAffinityUpdateMode", 2);
        self.add("QueryProcessCycleTime", 2);
        self.add("QueryProtectedPolicy", 2);
        self.add("QueryRecoveryAgentsOnEncryptedFile", 2);
        self.add("QuerySecurityAccessMask", 2);
        self.add("QuerySecurityContextToken", 2);
        self.add("QuerySecurityPackageInfo", 2);
        self.add("QuerySendMessage", 1);
        self.add("QueryServiceConfig2", 5);
        self.add("QueryServiceConfig", 4);
        self.add("QueryServiceDynamicInformation", 3);
        self.add("QueryServiceLockStatus", 4);
        self.add("QueryServiceObjectSecurity", 5);
        self.add("QueryServiceStatus", 2);
        self.add("QueryServiceStatusEx", 5);
        self.add("QuerySourceCreateFromKey", 5);
        self.add("QuerySourceCreateFromKeyEx", 6);
        self.add("QueryThreadCycleTime", 2);
        self.add("QueryThreadpoolStackInformation", 2);
        self.add("QueryThreadProfiling", 2);
        self.add("QueryTrace", 3);
        self.add("QueryUmsThreadInformation", 5);
        self.add("QueryUnbiasedInterruptTime", 1);
        self.add("QueryUsersOnEncryptedFile", 2);
        self.add("QueryVirtualMemoryCallback", 7);
        self.add("QueryWorkingSet", 3);
        self.add("QueryWorkingSetEx", 3);
        self.add("QueueUserAPC2", 4);
        self.add("QueueUserAPC", 3);
        self.add("QueueUserWorkItem", 3);
        self.add("raise", 1);
        self.add("RaiseException", 4);
        self.add("RaiseFailFastException", 3);
        self.add("rand", 0);
        self.add("rand_s", 1);
        self.add("RasClearConnectionStatistics", 1);
        self.add("RasClearLinkStatistics", 2);
        self.add("RasConnectionNotification", 3);
        self.add("RasCreatePhonebookEntry", 2);
        self.add("RasDeleteEntry", 2);
        self.add("RasDeleteSubEntry", 3);
        self.add("RasDial", 6);
        self.add("RasDialDlg", 4);
        self.add("RasEditPhonebookEntry", 3);
        self.add("RasEntryDlg", 3);
        self.add("RasEnumAutodialAddresses", 3);
        self.add("RasEnumConnections", 3);
        self.add("RasEnumDevices", 3);
        self.add("RasEnumEntries", 5);
        self.add("RasFreeEapUserIdentity", 1);
        self.add("RasGetAutodialAddress", 5);
        self.add("RasGetAutodialEnable", 2);
        self.add("RasGetAutodialParam", 3);
        self.add("RasGetConnectionStatistics", 2);
        self.add("RasGetConnectStatus", 2);
        self.add("RasGetCountryInfo", 2);
        self.add("RasGetCredentials", 3);
        self.add("RasGetCustomAuthData", 4);
        self.add("RasGetEapUserData", 5);
        self.add("RasGetEapUserIdentity", 5);
        self.add("RasGetEntryDialParams", 3);
        self.add("RasGetEntryProperties", 6);
        self.add("RasGetErrorString", 3);
        self.add("RasGetLinkStatistics", 3);
        self.add("RasGetNapStatus", 2);
        self.add("RasGetProjectionInfo", 4);
        self.add("RasGetProjectionInfoEx", 3);
        self.add("RasGetQuarantineConnectionId", 2);
        self.add("RasGetSubEntryHandle", 3);
        self.add("RasGetSubEntryProperties", 7);
        self.add("RasHangUp", 1);
        self.add("RasInvokeEapUI", 4);
        self.add("RasMonitorDlg", 2);
        self.add("RasPhonebookDlg", 3);
        self.add("RasRenameEntry", 3);
        self.add("RasSetAutodialAddress", 5);
        self.add("RasSetAutodialEnable", 2);
        self.add("RasSetAutodialParam", 3);
        self.add("RasSetCredentials", 4);
        self.add("RasSetCustomAuthData", 4);
        self.add("RasSetEapUserData", 5);
        self.add("RasSetEntryDialParams", 3);
        self.add("RasSetEntryProperties", 6);
        self.add("RasSetSubEntryProperties", 7);
        self.add("RasUpdateConnection", 2);
        self.add("RasValidateEntryName", 2);
        self.add("RatingAccessDeniedDialog2", 3);
        self.add("RatingAccessDeniedDialog", 4);
        self.add("RatingCheckUserAccess", 6);
        self.add("RatingEnable", 3);
        self.add("RatingEnabledQuery", 0);
        self.add("RatingFreeDetails", 1);
        self.add("RatingObtainCancel", 1);
        self.add("RatingObtainQuery", 6);
        self.add("RatingSetupUI", 2);
        self.add("read", 3);
        self.add("ReadBooleanRaw", 1);
        self.add("ReadCabinetState", 2);
        self.add("ReadClassStg", 2);
        self.add("ReadClassStm", 2);
        self.add("ReadConsole", 5);
        self.add("ReadConsoleInput", 4);
        self.add("ReadConsoleOutput", 5);
        self.add("ReadConsoleOutputAttribute", 5);
        self.add("ReadConsoleOutputCharacter", 5);
        self.add("ReadDirectoryChangesW", 8);
        self.add("ReadEncryptedFileRaw", 3);
        self.add("ReadEventLog", 7);
        self.add("ReadFile", 5);
        self.add("ReadFileEx", 5);
        self.add("ReadFileScatter", 5);
        self.add("ReadFmtUserTypeStg", 3);
        self.add("ReadGlobalPwrPolicy", 1);
        self.add("ReadGuidsForConnectedNetworks", 6);
        self.add("ReadInt32Acquire", 1);
        self.add("ReadInt32NoFence", 1);
        self.add("ReadInt32Raw", 1);
        self.add("ReadLogArchiveMetadata", 5);
        self.add("ReadLogNotification", 3);
        self.add("ReadLogRecord", 10);
        self.add("ReadLogRestartArea", 6);
        self.add("ReadNextLogRecord", 9);
        self.add("ReadOnlyEnlistment", 2);
        self.add("READ_PORT_BUFFER_UCHAR", 3);
        self.add("READ_PORT_BUFFER_ULONG", 3);
        self.add("READ_PORT_BUFFER_USHORT", 3);
        self.add("READ_PORT_UCHAR", 1);
        self.add("READ_PORT_ULONG", 1);
        self.add("READ_PORT_USHORT", 1);
        self.add("ReadPreviousLogRestartArea", 5);
        self.add("ReadPrinter", 4);
        self.add("ReadProcessMemory", 5);
        self.add("ReadProcessorPwrScheme", 2);
        self.add("ReadPwrScheme", 2);
        self.add("READ_REGISTER_BUFFER_UCHAR", 3);
        self.add("READ_REGISTER_BUFFER_ULONG", 3);
        self.add("READ_REGISTER_BUFFER_ULONG64", 3);
        self.add("READ_REGISTER_BUFFER_USHORT", 3);
        self.add("READ_REGISTER_UCHAR", 1);
        self.add("READ_REGISTER_ULONG", 1);
        self.add("READ_REGISTER_ULONG64", 1);
        self.add("READ_REGISTER_USHORT", 1);
        self.add("ReadThreadProfilingData", 3);
        self.add("ReadUInt32Acquire", 1);
        self.add("ReadUInt32NoFence", 1);
        self.add("ReadUInt32Raw", 1);
        self.add("ReadUrlCacheEntryStream", 5);
        self.add("ReadUrlCacheEntryStreamEx", 4);
        self.add("_ReadWriteBarrier", 1);
        self.add("RealChildWindowFromPoint", 2);
        self.add("RealDriveType", 2);
        self.add("RealGetWindowClass", 3);
        self.add("RealGetWindowClassA", 3);
        self.add("RealGetWindowClassW", 3);
        self.add("RealizePalette", 1);
        self.add("realloc", 2);
        self.add("ReallocADsMem", 3);
        self.add("ReallocADsStr", 2);
        self.add("realloc_dbg", 5);
        self.add("ReBaseImage", 11);
        self.add("recalloc", 2);
        self.add("recalloc_dbg", 6);
        self.add("RecoverEnlistment", 2);
        self.add("RecoverResourceManager", 1);
        self.add("RecoverTransactionManager", 1);
        self.add("Rectangle", 5);
        self.add("RectInRegion", 2);
        self.add("RectVisible", 2);
        self.add("recv", 4);
        self.add("recvfrom", 6);
        self.add("RedrawWindow", 4);
        self.add("RefreshBrowserLayout", 1);
        self.add("RefreshIScsiSendTargetPortal", 3);
        self.add("RefreshISNSServer", 1);
        self.add("RefreshPolicy", 1);
        self.add("RefreshPolicyEx", 2);
        self.add("RegCloseKey", 1);
        self.add("RegConnectRegistry", 3);
        self.add("RegConnectRegistryA", 3);
        self.add("RegConnectRegistryW", 3);
        self.add("RegCopyTree", 3);
        self.add("RegCopyTreeA", 3);
        self.add("RegCopyTreeW", 3);
        self.add("RegCreateKey", 3);
        self.add("RegCreateKeyA", 3);
        self.add("RegCreateKeyEx", 9);
        self.add("RegCreateKeyExA", 9);
        self.add("RegCreateKeyExW", 9);
        self.add("RegCreateKeyTransacted", 11);
        self.add("RegCreateKeyTransactedA", 11);
        self.add("RegCreateKeyTransactedW", 11);
        self.add("RegCreateKeyW", 3);
        self.add("RegDeleteKey", 2);
        self.add("RegDeleteKeyA", 2);
        self.add("RegDeleteKeyEx", 4);
        self.add("RegDeleteKeyExA", 4);
        self.add("RegDeleteKeyExW", 4);
        self.add("RegDeleteKeyTransacted", 6);
        self.add("RegDeleteKeyTransactedA", 6);
        self.add("RegDeleteKeyTransactedW", 6);
        self.add("RegDeleteKeyValue", 3);
        self.add("RegDeleteKeyValueA", 3);
        self.add("RegDeleteKeyValueW", 3);
        self.add("RegDeleteKeyW", 2);
        self.add("RegDeleteTree", 2);
        self.add("RegDeleteTreeA", 2);
        self.add("RegDeleteTreeW", 2);
        self.add("RegDeleteValue", 2);
        self.add("RegDeleteValueA", 2);
        self.add("RegDeleteValueW", 2);
        self.add("RegDisablePredefinedCache", 0);
        self.add("RegDisablePredefinedCache", 1);
        self.add("RegDisablePredefinedCacheEx", 0);
        self.add("RegDisablePredefinedCacheEx", 1);
        self.add("RegDisableReflectionKey", 1);
        self.add("RegEnableReflectionKey", 1);
        self.add("RegEnumKey", 4);
        self.add("RegEnumKeyA", 4);
        self.add("RegEnumKeyEx", 8);
        self.add("RegEnumKeyExA", 8);
        self.add("RegEnumKeyExW", 8);
        self.add("RegEnumKeyW", 4);
        self.add("RegEnumValue", 8);
        self.add("RegEnumValueA", 8);
        self.add("RegEnumValueW", 8);
        self.add("RegFlushKey", 1);
        self.add("RegGetKeySecurity", 4);
        self.add("RegGetValue", 7);
        self.add("RegGetValueA", 7);
        self.add("RegGetValueW", 7);
        self.add("RegisterActiveObject", 4);
        self.add("RegisterApplicationRecoveryCallback", 4);
        self.add("RegisterApplicationRestart", 2);
        self.add("RegisterBadMemoryNotification", 1);
        self.add("RegisterBindStatusCallback", 4);
        self.add("RegisterClass", 1);
        self.add("RegisterClassA", 1);
        self.add("RegisterClassEx", 1);
        self.add("RegisterClassExA", 1);
        self.add("RegisterClassExW", 1);
        self.add("RegisterClassW", 1);
        self.add("RegisterClipboardFormat", 1);
        self.add("RegisterCMM", 3);
        self.add("RegisterDeviceNotification", 3);
        self.add("RegisterDragDrop", 2);
        self.add("RegisterEventSource", 2);
        self.add("RegisterForLogWriteNotification", 3);
        self.add("RegisterFormatEnumerator", 3);
        self.add("RegisterForPrintAsyncNotifications", 6);
        self.add("RegisterGPNotification", 2);
        self.add("RegisterHotKey", 4);
        self.add("RegisterManageableLogClient", 2);
        self.add("RegisterMediaTypeClass", 5);
        self.add("RegisterMediaTypes", 3);
        self.add("RegisterOutputCallbackInteractionContext", 3);
        self.add("RegisterPageWithPage", 7);
        self.add("RegisterPointerDeviceNotifications", 2);
        self.add("RegisterPowerSettingNotification", 3);
        self.add("RegisterRawInputDevices", 3);
        self.add("RegisterScaleChangeNotifications", 4);
        self.add("RegisterServiceCtrlHandler", 2);
        self.add("RegisterServiceCtrlHandlerEx", 3);
        self.add("RegisterShellHookWindow", 1);
        self.add("RegisterSuspendResumeNotification", 2);
        self.add("RegisterTouchHitTestingWindow", 2);
        self.add("RegisterTouchWindow", 2);
        self.add("RegisterTraceGuids", 8);
        self.add("RegisterTypeLib", 3);
        self.add("RegisterTypeLibForUser", 3);
        self.add("RegisterUrlCacheNotification", 5);
        self.add("RegisterWaitChainCOMCallback", 2);
        self.add("RegisterWaitForSingleObject", 6);
        self.add("RegisterWindowMessage", 1);
        self.add("RegisterWindowMessageA", 1);
        self.add("RegisterWindowMessageW", 1);
        self.add("RegLoadAppKey", 5);
        self.add("RegLoadAppKeyA", 5);
        self.add("RegLoadAppKeyW", 5);
        self.add("RegLoadKey", 3);
        self.add("RegLoadKeyA", 3);
        self.add("RegLoadKeyW", 3);
        self.add("RegLoadMUIString", 7);
        self.add("RegLoadMUIStringA", 7);
        self.add("RegLoadMUIStringW", 7);
        self.add("RegNotifyChangeKeyValue", 5);
        self.add("RegOpenCurrentUser", 2);
        self.add("RegOpenKey", 3);
        self.add("RegOpenKeyA", 3);
        self.add("RegOpenKeyEx", 5);
        self.add("RegOpenKeyExA", 5);
        self.add("RegOpenKeyExW", 5);
        self.add("RegOpenKeyTransacted", 7);
        self.add("RegOpenKeyTransactedA", 7);
        self.add("RegOpenKeyTransactedW", 7);
        self.add("RegOpenKeyW", 3);
        self.add("RegOpenUserClassesRoot", 4);
        self.add("RegOverridePredefKey", 2);
        self.add("RegQueryInfoKey", 12);
        self.add("RegQueryInfoKeyA", 12);
        self.add("RegQueryInfoKeyW", 12);
        self.add("RegQueryMultipleValues", 5);
        self.add("RegQueryMultipleValuesA", 5);
        self.add("RegQueryMultipleValuesW", 5);
        self.add("RegQueryReflectionKey", 2);
        self.add("RegQueryValue", 4);
        self.add("RegQueryValueA", 4);
        self.add("RegQueryValueEx", 6);
        self.add("RegQueryValueExA", 6);
        self.add("RegQueryValueExW", 6);
        self.add("RegQueryValueW", 4);
        self.add("RegRenameKey", 3);
        self.add("RegReplaceKey", 4);
        self.add("RegReplaceKeyA", 4);
        self.add("RegReplaceKeyW", 4);
        self.add("RegRestoreKey", 3);
        self.add("RegRestoreKeyA", 3);
        self.add("RegRestoreKeyW", 3);
        self.add("RegSaveKey", 3);
        self.add("RegSaveKeyA", 3);
        self.add("RegSaveKeyEx", 4);
        self.add("RegSaveKeyExA", 4);
        self.add("RegSaveKeyExW", 4);
        self.add("RegSaveKeyW", 3);
        self.add("RegSetKeySecurity", 3);
        self.add("RegSetKeyValue", 6);
        self.add("RegSetKeyValueA", 6);
        self.add("RegSetKeyValueW", 6);
        self.add("RegSetValue", 5);
        self.add("RegSetValueA", 5);
        self.add("RegSetValueEx", 6);
        self.add("RegSetValueExA", 6);
        self.add("RegSetValueExW", 6);
        self.add("RegSetValueW", 5);
        self.add("RegUnLoadKey", 2);
        self.add("RegUnLoadKeyA", 2);
        self.add("RegUnLoadKeyW", 2);
        self.add("ReleaseActCtx", 1);
        self.add("ReleaseBindInfo", 1);
        self.add("ReleaseCapture", 0);
        self.add("ReleaseDC", 2);
        self.add("ReleaseMutex", 1);
        self.add("ReleaseMutexWhenCallbackReturns", 2);
        self.add("ReleaseSemaphore", 3);
        self.add("ReleaseSemaphoreWhenCallbackReturns", 3);
        self.add("ReleaseSRWLockExclusive", 1);
        self.add("ReleaseSRWLockShared", 1);
        self.add("ReleaseStgMedium", 1);
        self.add("remove", 1);
        self.add("RemoveClipboardFormatListener", 1);
        self.add("RemoveDeveloperLicense", 1);
        self.add("RemoveDirectory", 1);
        self.add("RemoveDirectoryA", 1);
        self.add("RemoveDirectoryTransacted", 2);
        self.add("RemoveDirectoryW", 1);
        self.add("RemoveDllDirectory", 1);
        self.add("RemoveEntryList", 1);
        self.add("RemoveFontMemResourceEx", 1);
        self.add("RemoveFontResource", 1);
        self.add("RemoveFontResourceA", 1);
        self.add("RemoveFontResourceEx", 3);
        self.add("RemoveFontResourceExA", 3);
        self.add("RemoveFontResourceExW", 3);
        self.add("RemoveFontResourceW", 1);
        self.add("RemoveHeadList", 1);
        self.add("RemoveIScsiConnection", 2);
        self.add("RemoveIScsiPersistentTarget", 4);
        self.add("RemoveIScsiSendTargetPortal", 3);
        self.add("RemoveIScsiStaticTarget", 1);
        self.add("RemoveISNSServer", 1);
        self.add("RemoveLogContainer", 4);
        self.add("RemoveLogContainerSet", 5);
        self.add("RemoveLogPolicy", 2);
        self.add("RemoveMenu", 3);
        self.add("RemovePersistentIScsiDevice", 1);
        self.add("RemovePointerInteractionContext", 2);
        self.add("RemovePreprocessInfo", 1);
        self.add("RemoveProp", 2);
        self.add("RemovePropA", 2);
        self.add("RemovePropW", 2);
        self.add("RemoveRadiusServer", 1);
        self.add("RemoveSecureMemoryCacheCallback", 1);
        self.add("RemoveTailList", 1);
        self.add("RemoveTraceCallback", 1);
        self.add("RemoveUsersFromEncryptedFile", 2);
        self.add("RemoveVectoredContinueHandler", 1);
        self.add("RemoveVectoredExceptionHandler", 1);
        self.add("RemoveWindowSubclass", 3);
        self.add("rename", 2);
        self.add("RenameTransactionManager", 2);
        self.add("ReOpenFile", 4);
        self.add("ReplaceFile", 6);
        self.add("ReplaceText", 1);
        self.add("ReplyMessage", 1);
        self.add("ReportActiveIScsiTargetMappings", 3);
        self.add("ReportEvent", 9);
        self.add("ReportFault", 2);
        self.add("ReportIScsiInitiatorList", 2);
        self.add("ReportIScsiPersistentLogins", 3);
        self.add("ReportIScsiSendTargetPortals", 2);
        self.add("ReportIScsiSendTargetPortalsEx", 3);
        self.add("ReportIScsiTargetPortals", 5);
        self.add("ReportIScsiTargets", 3);
        self.add("ReportISNSServerList", 2);
        self.add("ReportJobProcessingProgress", 4);
        self.add("ReportPersistentIScsiDevices", 2);
        self.add("ReportRadiusServerList", 2);
        self.add("RequestPowerComplete", 5);
        self.add("RequestWakeupLatency", 1);
        self.add("ReserveAndAppendLog", 10);
        self.add("ReserveAndAppendLogAligned", 11);
        self.add("ResetCompressor", 1);
        self.add("ResetDC", 2);
        self.add("ResetDCA", 2);
        self.add("ResetDCW", 2);
        self.add("ResetDecompressor", 1);
        self.add("ResetEvent", 1);
        self.add("ResetInteractionContext", 1);
        self.add("ResetPrinter", 2);
        self.add("resetstkoflw", 0);
        self.add("ResetWriteWatch", 2);
        self.add("ResizePalette", 2);
        self.add("ResizeVirtualDisk", 4);
        self.add("ResolveDelayLoadedAPI", 6);
        self.add("ResolveDelayLoadsFromDll", 3);
        self.add("ResolveIpNetEntry2", 2);
        self.add("ResolveLocaleName", 3);
        self.add("ResolveNeighbor", 3);
        self.add("RestartDialog", 3);
        self.add("RestartDialogEx", 4);
        self.add("RestoreDC", 2);
        self.add("RestoreMediaSense", 2);
        self.add("RestoreMonitorFactoryColorDefaults", 1);
        self.add("RestoreMonitorFactoryDefaults", 1);
        self.add("ResumeSuspendedDownload", 2);
        self.add("ResumeThread", 1);
        self.add("RetrieveUrlCacheEntryFile", 4);
        self.add("RetrieveUrlCacheEntryFileA", 4);
        self.add("RetrieveUrlCacheEntryFileW", 4);
        self.add("RetrieveUrlCacheEntryStream", 5);
        self.add("RetrieveUrlCacheEntryStreamA", 5);
        self.add("RetrieveUrlCacheEntryStreamW", 5);
        self.add("ReuseDDElParam", 5);
        self.add("RevertSecurityContext", 1);
        self.add("RevertToSelf", 0);
        self.add("RevokeActiveObject", 2);
        self.add("RevokeBindStatusCallback", 2);
        self.add("RevokeDragDrop", 1);
        self.add("RevokeFormatEnumerator", 2);
        self.add("RevokeScaleChangeNotifications", 2);
        self.add("rewind", 1);
        self.add("RIOCloseCompletionQueue", 1);
        self.add("RIOCreateCompletionQueue", 2);
        self.add("RIOCreateRequestQueue", 8);
        self.add("RIODequeueCompletion", 3);
        self.add("RIODeregisterBuffer", 1);
        self.add("RIONotify", 1);
        self.add("RIOReceive", 5);
        self.add("RIOReceiveEx", 9);
        self.add("RIORegisterBuffer", 2);
        self.add("RIOResizeCompletionQueue", 2);
        self.add("RIOResizeRequestQueue", 3);
        self.add("RIOSend", 5);
        self.add("RIOSendEx", 9);
        self.add("RmAddFilter", 5);
        self.add("RmCancelCurrentTask", 1);
        self.add("rmdir", 1);
        self.add("RmEndSession", 1);
        self.add("RmGetFilterList", 4);
        self.add("RmGetList", 5);
        self.add("RmJoinSession", 2);
        self.add("RmRegisterResources", 7);
        self.add("RmRemoveFilter", 4);
        self.add("RmRestart", 3);
        self.add("RmShutdown", 3);
        self.add("RmStartSession", 3);
        self.add("rmtmp", 0);
        self.add("RoActivateInstance", 2);
        self.add("RoCaptureErrorContext", 1);
        self.add("RoFailFastWithErrorContext", 1);
        self.add("RoFreeParameterizedTypeExtra", 1);
        self.add("RoGetActivatableClassRegistration", 2);
        self.add("RoGetActivationFactory", 3);
        self.add("RoGetApartmentIdentifier", 1);
        self.add("RoGetBufferMarshaler", 1);
        self.add("RoGetErrorReportingFlags", 1);
        self.add("RoGetMetaDataFile", 5);
        self.add("RoGetParameterizedTypeInstanceIID", 5);
        self.add("RoGetServerActivatableClasses", 3);
        self.add("RoInitialize", 1);
        self.add("RollbackComplete", 2);
        self.add("RollbackEnlistment", 2);
        self.add("RollbackTransaction", 1);
        self.add("RollbackTransactionAsync", 1);
        self.add("RollforwardTransactionManager", 2);
        self.add("RoOriginateError", 2);
        self.add("RoOriginateErrorW", 3);
        self.add("RoParameterizedTypeExtraGetTypeSignature", 1);
        self.add("RoParseTypeName", 3);
        self.add("RoRegisterActivationFactories", 4);
        self.add("RoRegisterForApartmentShutdown", 3);
        self.add("RoResolveNamespace", 8);
        self.add("RoResolveRestrictedErrorInfoReference", 2);
        self.add("RoRevokeActivationFactories", 1);
        self.add("RoSetErrorReportingFlags", 1);
        self.add("rotl", 2);
        self.add("rotl64", 2);
        self.add("rotr", 2);
        self.add("rotr64", 2);
        self.add("RoTransformError", 3);
        self.add("RoTransformErrorW", 4);
        self.add("RoundRect", 7);
        self.add("RoUninitialize", 0);
        self.add("RoUnregisterForApartmentShutdown", 1);
        self.add("RpcAsyncAbortCall", 2);
        self.add("RpcAsyncCancelCall", 2);
        self.add("RpcAsyncCompleteCall", 2);
        self.add("RpcAsyncGetCallStatus", 1);
        self.add("RpcAsyncInitializeHandle", 2);
        self.add("RpcAsyncRegisterInfo", 0);
        self.add("RpcBindingBind", 3);
        self.add("RpcBindingCopy", 2);
        self.add("RpcBindingCreate", 4);
        self.add("RpcBindingFree", 1);
        self.add("RpcBindingFromStringBinding", 2);
        self.add("RpcBindingInqAuthClient", 6);
        self.add("RpcBindingInqAuthClientEx", 7);
        self.add("RpcBindingInqAuthInfo", 6);
        self.add("RpcBindingInqAuthInfoEx", 8);
        self.add("RpcBindingInqObject", 2);
        self.add("RpcBindingInqOption", 3);
        self.add("RpcBindingReset", 1);
        self.add("RpcBindingServerFromClient", 2);
        self.add("RpcBindingSetAuthInfo", 6);
        self.add("RpcBindingSetAuthInfoEx", 7);
        self.add("RpcBindingSetObject", 2);
        self.add("RpcBindingSetOption", 3);
        self.add("RpcBindingToStringBinding", 2);
        self.add("RpcBindingUnbind", 1);
        self.add("RpcBindingVectorFree", 1);
        self.add("RpcCancelThread", 1);
        self.add("RpcCancelThreadEx", 2);
        self.add("RpcCertGeneratePrincipalName", 3);
        self.add("RpcDiagnoseError", 6);
        self.add("RpcEpRegister", 4);
        self.add("RpcEpRegisterNoReplace", 4);
        self.add("RpcEpResolveBinding", 2);
        self.add("RpcEpUnregister", 3);
        self.add("RpcErrorAddRecord", 1);
        self.add("RpcErrorClearInformation", 0);
        self.add("RpcErrorEndEnumeration", 1);
        self.add("RpcErrorGetNextRecord", 3);
        self.add("RpcErrorGetNumberOfRecords", 2);
        self.add("RpcErrorLoadErrorInfo", 3);
        self.add("RpcErrorResetEnumeration", 1);
        self.add("RpcErrorSaveErrorInfo", 3);
        self.add("RpcErrorStartEnumeration", 1);
        self.add("RpcFreeAuthorizationContext", 1);
        self.add("RpcGetAuthorizationContextForClient", 8);
        self.add("RpcIfIdVectorFree", 1);
        self.add("RpcIfInqId", 2);
        self.add("RpcImpersonateClient", 1);
        self.add("RpcMgmtEnableIdleCleanup", 0);
        self.add("RpcMgmtEpEltInqBegin", 6);
        self.add("RpcMgmtEpEltInqDone", 1);
        self.add("RpcMgmtEpEltInqNext", 5);
        self.add("RpcMgmtEpUnregister", 4);
        self.add("RpcMgmtInqComTimeout", 2);
        self.add("RpcMgmtInqDefaultProtectLevel", 2);
        self.add("RpcMgmtInqIfIds", 2);
        self.add("RpcMgmtInqServerPrincName", 3);
        self.add("RpcMgmtInqStats", 2);
        self.add("RpcMgmtIsServerListening", 1);
        self.add("RpcMgmtSetAuthorizationFn", 1);
        self.add("RpcMgmtSetCancelTimeout", 1);
        self.add("RpcMgmtSetComTimeout", 2);
        self.add("RpcMgmtSetServerStackSize", 1);
        self.add("RpcMgmtStatsVectorFree", 1);
        self.add("RpcMgmtStopServerListening", 1);
        self.add("RpcMgmtWaitServerListen", 0);
        self.add("RpcNetworkInqProtseqs", 1);
        self.add("RpcNetworkIsProtseqValid", 1);
        self.add("RpcNsBindingExport", 5);
        self.add("RpcNsBindingExportPnP", 4);
        self.add("RpcNsBindingImportBegin", 5);
        self.add("RpcNsBindingImportDone", 1);
        self.add("RpcNsBindingImportNext", 2);
        self.add("RpcNsBindingInqEntryName", 3);
        self.add("RpcNsBindingLookupBegin", 6);
        self.add("RpcNsBindingLookupDone", 1);
        self.add("RpcNsBindingLookupNext", 2);
        self.add("RpcNsBindingSelect", 2);
        self.add("RpcNsBindingUnexport", 4);
        self.add("RpcNsBindingUnexportPnP", 4);
        self.add("RpcNsEntryExpandName", 3);
        self.add("RpcNsEntryObjectInqBegin", 3);
        self.add("RpcNsEntryObjectInqDone", 1);
        self.add("RpcNsEntryObjectInqNext", 2);
        self.add("RpcNsGroupDelete", 2);
        self.add("RpcNsGroupMbrAdd", 4);
        self.add("RpcNsGroupMbrInqBegin", 4);
        self.add("RpcNsGroupMbrInqDone", 1);
        self.add("RpcNsGroupMbrInqNext", 2);
        self.add("RpcNsGroupMbrRemove", 4);
        self.add("RpcNsMgmtBindingUnexport", 5);
        self.add("RpcNsMgmtEntryCreate", 2);
        self.add("RpcNsMgmtEntryDelete", 2);
        self.add("RpcNsMgmtEntryInqIfIds", 3);
        self.add("RpcNsMgmtHandleSetExpAge", 2);
        self.add("RpcNsMgmtInqExpAge", 1);
        self.add("RpcNsMgmtSetExpAge", 1);
        self.add("RpcNsProfileDelete", 2);
        self.add("RpcNsProfileEltAdd", 7);
        self.add("RpcNsProfileEltInqBegin", 8);
        self.add("RpcNsProfileEltInqDone", 1);
        self.add("RpcNsProfileEltInqNext", 5);
        self.add("RpcNsProfileEltRemove", 5);
        self.add("RpcObjectInqType", 2);
        self.add("RpcObjectSetInqFn", 1);
        self.add("RpcObjectSetType", 2);
        self.add("RpcProtseqVectorFree", 1);
        self.add("RpcRevertToSelf", 0);
        self.add("RpcRevertToSelfEx", 1);
        self.add("RpcServerCompleteSecurityCallback", 2);
        self.add("RpcServerInqBindingHandle", 1);
        self.add("RpcServerInqBindings", 1);
        self.add("RpcServerInqCallAttributes", 2);
        self.add("RpcServerInqDefaultPrincName", 2);
        self.add("RpcServerInqIf", 3);
        self.add("RpcServerInterfaceGroupActivate", 1);
        self.add("RpcServerInterfaceGroupClose", 1);
        self.add("RpcServerInterfaceGroupCreate", 8);
        self.add("RpcServerInterfaceGroupDeactivate", 2);
        self.add("RpcServerInterfaceGroupInqBindings", 2);
        self.add("RpcServerListen", 3);
        self.add("RpcServerRegisterAuthInfo", 4);
        self.add("RpcServerRegisterIf2", 7);
        self.add("RpcServerRegisterIf", 3);
        self.add("RpcServerRegisterIf3", 8);
        self.add("RpcServerRegisterIfEx", 6);
        self.add("RpcServerSubscribeForNotification", 4);
        self.add("RpcServerTestCancel", 1);
        self.add("RpcServerUnregisterIf", 3);
        self.add("RpcServerUnregisterIfEx", 3);
        self.add("RpcServerUnsubscribeForNotification", 3);
        self.add("RpcServerUseAllProtseqs", 2);
        self.add("RpcServerUseAllProtseqsEx", 3);
        self.add("RpcServerUseAllProtseqsIf", 3);
        self.add("RpcServerUseAllProtseqsIfEx", 4);
        self.add("RpcServerUseProtseq", 3);
        self.add("RpcServerUseProtseqEp", 4);
        self.add("RpcServerUseProtseqEpEx", 5);
        self.add("RpcServerUseProtseqEx", 4);
        self.add("RpcServerUseProtseqIf", 4);
        self.add("RpcServerUseProtseqIfEx", 5);
        self.add("RpcServerYield", 0);
        self.add("RpcSmAllocate", 2);
        self.add("RpcSmClientFree", 1);
        self.add("RpcSmDestroyClientContext", 1);
        self.add("RpcSmDisableAllocate", 0);
        self.add("RpcSmEnableAllocate", 0);
        self.add("RpcSmFree", 1);
        self.add("RpcSmGetThreadHandle", 1);
        self.add("RpcSmSetClientAllocFree", 2);
        self.add("RpcSmSetThreadHandle", 1);
        self.add("RpcSmSwapClientAllocFree", 4);
        self.add("RpcSsAllocate", 1);
        self.add("RpcSsContextLockExclusive", 2);
        self.add("RpcSsContextLockShared", 2);
        self.add("RpcSsDestroyClientContext", 1);
        self.add("RpcSsDisableAllocate", 0);
        self.add("RpcSsDontSerializeContext", 0);
        self.add("RpcSsEnableAllocate", 0);
        self.add("RpcSsFree", 1);
        self.add("RpcSsGetContextBinding", 2);
        self.add("RpcSsGetThreadHandle", 0);
        self.add("RpcSsSetClientAllocFree", 2);
        self.add("RpcSsSetThreadHandle", 1);
        self.add("RpcSsSwapClientAllocFree", 4);
        self.add("RpcStringBindingCompose", 6);
        self.add("RpcStringBindingParse", 6);
        self.add("RpcStringFree", 1);
        self.add("RpcTestCancel", 0);
        self.add("RpcUserFree", 2);
        self.add("RsopAccessCheckByType", 11);
        self.add("RsopFileAccessCheck", 5);
        self.add("RsopResetPolicySettingStatus", 3);
        self.add("RsopSetPolicySettingStatus", 5);
        self.add("RTDynamicCast", 5);
        self.add("RTFSync", 3);
        self.add("RtlAbsoluteToSelfRelativeSD", 3);
        self.add("RtlAcquirePebLock", 0);
        self.add("RtlAcquirePrivilege", 4);
        self.add("RtlAcquireReleaseSRWLockExclusive", 1);
        self.add("RtlAcquireResourceExclusive", 2);
        self.add("RtlAcquireResourceShared", 2);
        self.add("RtlAcquireSRWLockExclusive", 1);
        self.add("RtlAcquireSRWLockShared", 1);
        self.add("RtlActivateActivationContext", 3);
        self.add("RtlAddAccessAllowedAce", 4);
        self.add("RtlAddAccessAllowedAceEx", 5);
        self.add("RtlAddAccessAllowedObjectAce", 7);
        self.add("RtlAddAccessDeniedAce", 4);
        self.add("RtlAddAccessDeniedAceEx", 5);
        self.add("RtlAddAccessDeniedObjectAce", 7);
        self.add("RtlAddAce", 5);
        self.add("RtlAddAtomToAtomTable", 3);
        self.add("RtlAddAuditAccessAce", 6);
        self.add("RtlAddAuditAccessAceEx", 7);
        self.add("RtlAddAuditAccessObjectAce", 9);
        self.add("RtlAddCompoundAce", 6);
        self.add("RtlAddFunctionTable", 3);
        self.add("RtlAddGrowableFunctionTable", 6);
        self.add("RtlAddIntegrityLabelToBoundaryDescriptor", 2);
        self.add("RtlAddMandatoryAce", 6);
        self.add("RtlAddRefActivationContext", 1);
        self.add("RtlAddressInSectionTable", 3);
        self.add("RtlAddSIDToBoundaryDescriptor", 2);
        self.add("RtlAddVectoredContinueHandler", 2);
        self.add("RtlAddVectoredExceptionHandler", 2);
        self.add("RtlAdjustPrivilege", 4);
        self.add("RtlAllocateActivationContextStack", 1);
        self.add("RtlAllocateAndInitializeSid", 11);
        self.add("RtlAllocateFromPeb", 2);
        self.add("RtlAllocateHandle", 2);
        self.add("RtlAllocateHeap", 3);
        self.add("RtlAllocateMemoryBlockLookaside", 3);
        self.add("RtlAllocateMemoryZone", 3);
        self.add("RtlAnsiCharToUnicodeChar", 1);
        self.add("RtlAnsiStringToUnicodeSize", 1);
        self.add("RtlAnsiStringToUnicodeString", 3);
        self.add("RtlAppendAsciizToString", 2);
        self.add("RtlAppendPathElement", 3);
        self.add("RtlAppendStringToString", 2);
        self.add("RtlAppendUnicodeStringToString", 2);
        self.add("RtlAppendUnicodeToString", 2);
        self.add("RtlAreAllAccessesGranted", 2);
        self.add("RtlAreAnyAccessesGranted", 2);
        self.add("RtlAreBitsClear", 3);
        self.add("RtlAreBitsSet", 3);
        self.add("RtlAssert", 4);
        self.add("RtlBarrier", 2);
        self.add("RtlBarrierForDelete", 2);
        self.add("RtlCaptureContext", 1);
        self.add("RtlCaptureStackBackTrace", 4);
        self.add("RtlCharToInteger", 3);
        self.add("RtlCheckBit", 2);
        self.add("RtlCheckForOrphanedCriticalSections", 1);
        self.add("RtlCheckRegistryKey", 2);
        self.add("RtlCleanUpTEBLangLists", 0);
        self.add("RtlClearAllBits", 1);
        self.add("RtlClearBit", 2);
        self.add("RtlClearBits", 3);
        self.add("RtlCloneUserProcess", 5);
        self.add("RtlCmDecodeMemIoResource", 2);
        self.add("RtlCmEncodeMemIoResource", 4);
        self.add("RtlCommitDebugInfo", 2);
        self.add("RtlCompactHeap", 2);
        self.add("RtlCompareAltitudes", 2);
        self.add("RtlCompareMemory", 3);
        self.add("RtlCompareMemoryUlong", 3);
        self.add("RtlCompareString", 3);
        self.add("RtlCompareUnicodeString", 3);
        self.add("RtlCompareUnicodeStrings", 5);
        self.add("RtlCompressBuffer", 8);
        self.add("RtlCompressChunks", 7);
        self.add("RtlComputeCrc32", 3);
        self.add("RtlComputeImportTableHash", 3);
        self.add("RtlComputePrivatizedDllName_U", 3);
        self.add("RtlConsoleMultiByteToUnicodeN", 6);
        self.add("RtlConstantTimeEqualMemory", 3);
        self.add("RtlContractHashTable", 1);
        self.add("RtlConvertExclusiveToShared", 1);
        self.add("RtlConvertLCIDToString", 5);
        self.add("RtlConvertLongToLargeInteger", 1);
        self.add("RtlConvertSharedToExclusive", 1);
        self.add("RtlConvertSidToUnicodeString", 3);
        self.add("RtlConvertToAutoInheritSecurityObject", 6);
        self.add("RtlConvertUlongToLargeInteger", 1);
        self.add("RtlCopyLuid", 2);
        self.add("RtlCopyLuidAndAttributesArray", 3);
        self.add("RtlCopyMappedMemory", 3);
        self.add("RtlCopyMemory", 3);
        self.add("RtlCopyMemoryNonTemporal", 3);
        self.add("RtlCopySecurityDescriptor", 2);
        self.add("RtlCopySid", 3);
        self.add("RtlCopySidAndAttributesArray", 7);
        self.add("RtlCopyString", 2);
        self.add("RtlCopyUnicodeString", 2);
        self.add("RtlCreateAcl", 3);
        self.add("RtlCreateActivationContext", 6);
        self.add("RtlCreateAtomTable", 2);
        self.add("RtlCreateBoundaryDescriptor", 2);
        self.add("RtlCreateEnvironment", 2);
        self.add("RtlCreateEnvironmentEx", 3);
        self.add("RtlCreateHashTable", 3);
        self.add("RtlCreateHeap", 6);
        self.add("RtlCreateMemoryBlockLookaside", 5);
        self.add("RtlCreateMemoryZone", 3);
        self.add("RtlCreateProcessParameters", 10);
        self.add("RtlCreateProcessParametersEx", 11);
        self.add("RtlCreateProcessReflection", 6);
        self.add("RtlCreateQueryDebugBuffer", 2);
        self.add("RtlCreateRegistryKey", 2);
        self.add("RtlCreateSecurityDescriptor", 2);
            self.add("RtlCreateSecurityDescriptorRelative", 2);
        self.add("RtlCreateSecurityDescriptorRelative", 2);
        self.add("RtlCreateServiceSid", 3);
            self.add("RtlCreateSystemVolumeInformationFolder", 1);
        self.add("RtlCreateTagHeap", 4);
        self.add("RtlCreateTimer", 7);
        self.add("RtlCreateTimerQueue", 1);
        self.add("RtlCreateUnicodeString", 2);
        self.add("RtlCreateUnicodeStringFromAsciiz", 2);
        self.add("RtlCreateUserProcess", 10);
        self.add("RtlCreateUserStack", 6);
        self.add("RtlCreateUserThread", 10);
        self.add("RtlCreateVirtualAccountSid", 4);
        self.add("RtlCultureNameToLCID", 2);
        self.add("RtlCustomCPToUnicodeN", 6);
        self.add("RtlCutoverTimeToSystemTime", 4);
        self.add("RtlDeactivateActivationContext", 2);
        self.add("RtlDebugCreateHeap", 6);
        self.add("RtlDecodePointer", 1);
        self.add("RtlDecodeSystemPointer", 1);
        self.add("RtlDeCommitDebugInfo", 3);
        self.add("RtlDecompressBuffer", 6);
        self.add("RtlDecompressBufferEx2", 8);
        self.add("RtlDecompressBufferEx", 7);
        self.add("RtlDecompressChunks", 7);
        self.add("RtlDecompressFragment", 8);
        self.add("RtlDecompressFragmentEx", 9);
        self.add("RtlDelete", 1);
        self.add("RtlDeleteAce", 2);
        self.add("RtlDeleteAtomFromAtomTable", 2);
        self.add("RtlDeleteBarrier", 1);
        self.add("RtlDeleteBoundaryDescriptor", 1);
        self.add("RtlDeleteCriticalSection", 1);
        self.add("RtlDeleteElementGenericTable", 2);
        self.add("RtlDeleteElementGenericTableAvl", 2);
        self.add("RtlDeleteFunctionTable", 1);
        self.add("RtlDeleteGrowableFunctionTable", 1);
        self.add("RtlDeleteHashTable", 1);
        self.add("RtlDeleteNoSplay", 2);
        self.add("RtlDeleteRegistryValue", 3);
        self.add("RtlDeleteResource", 1);
        self.add("RtlDeleteSecurityObject", 1);
        self.add("RtlDeleteTimer", 3);
        self.add("RtlDeleteTimerQueue", 1);
        self.add("RtlDeleteTimerQueueEx", 2);
        self.add("RtlDeNormalizeProcessParams", 1);
        self.add("RtlDeregisterWait", 1);
        self.add("RtlDeregisterWaitEx", 2);
        self.add("RtlDescribeChunk", 5);
        self.add("RtlDestroyAtomTable", 1);
        self.add("RtlDestroyEnvironment", 1);
        self.add("RtlDestroyHandleTable", 1);
        self.add("RtlDestroyHeap", 1);
        self.add("RtlDestroyMemoryBlockLookaside", 1);
        self.add("RtlDestroyMemoryZone", 1);
        self.add("RtlDestroyProcessParameters", 1);
        self.add("RtlDestroyQueryDebugBuffer", 1);
        self.add("RtlDetectHeapLeaks", 0);
        self.add("RtlDetermineDosPathNameType_U", 1);
        self.add("RtlDetermineDosPathNameType_Ustr", 1);
        self.add("RtlDisableThreadProfiling", 1);
        self.add("RtlDispatchException", 2);
        self.add("RtlDnsHostNameToComputerName", 3);
        self.add("RtlDoesFileExists_U", 1);
        self.add("RtlDoesFileExists_UstrEx", 2);
        self.add("RtlDosApplyFileIsolationRedirection_Ustr", 9);
        self.add("RtlDosPathNameToNtPathName_U", 4);
        self.add("RtlDosPathNameToNtPathName_U_WithStatus", 4);
        self.add("RtlDosPathNameToRelativeNtPathName_U", 4);
        self.add("RtlDosPathNameToRelativeNtPathName_U_WithStatus", 4);
        self.add("RtlDosSearchPath_U", 6);
        self.add("RtlDosSearchPath_Ustr", 9);
        self.add("RtlDowncaseUnicodeChar", 1);
        self.add("RtlDowncaseUnicodeString", 3);
        self.add("RtlDumpResource", 1);
        self.add("RtlDuplicateUnicodeString", 3);
        self.add("RtlEmptyAtomTable", 2);
        self.add("RtlEnableThreadProfiling", 4);
        self.add("RtlEncodePointer", 1);
        self.add("RtlEncodeSystemPointer", 1);
        self.add("RtlEndEnumerationHashTable", 2);
        self.add("RtlEndWeakEnumerationHashTable", 2);
        self.add("RtlEnlargedIntegerMultiply", 2);
        self.add("RtlEnlargedUnsignedDivide", 3);
        self.add("RtlEnlargedUnsignedMultiply", 2);
        self.add("RtlEnterCriticalSection", 1);
        self.add("RtlEnumerateEntryHashTable", 2);
        self.add("RtlEnumerateGenericTable", 2);
        self.add("RtlEnumerateGenericTableAvl", 2);
        self.add("RtlEnumerateGenericTableLikeADirectory", 7);
        self.add("RtlEnumerateGenericTableWithoutSplaying", 2);
        self.add("RtlEnumerateGenericTableWithoutSplayingAvl", 2);
        self.add("RtlEnumProcessHeaps", 2);
        self.add("RtlEqualComputerName", 2);
        self.add("RtlEqualDomainName", 2);
        self.add("RtlEqualPrefixSid", 2);
        self.add("RtlEqualSid", 2);
        self.add("RtlEqualString", 3);
        self.add("RtlEqualUnicodeString", 3);
        self.add("RtlEraseUnicodeString", 1);
        self.add("RtlExitUserProcess", 1);
        self.add("RtlExitUserThread", 1);
        self.add("RtlExpandEnvironmentStrings", 6);
        self.add("RtlExpandEnvironmentStrings_U", 4);
        self.add("RtlExpandHashTable", 1);
        self.add("RtlExtendedIntegerMultiply", 2);
        self.add("RtlExtendedLargeIntegerDivide", 3);
        self.add("RtlExtendedMagicDivide", 3);
        self.add("RtlExtendHeap", 4);
        self.add("RtlExtendMemoryBlockLookaside", 2);
        self.add("RtlFillMemory", 3);
        self.add("RtlFillMemoryNonTemporal", 3);
        self.add("RtlFillMemoryUlong", 3);
        self.add("RtlFillMemoryUlonglong", 3);
        self.add("RtlFindAceByType", 3);
        self.add("RtlFindActivationContextSectionString", 5);
        self.add("RtlFindCharInUnicodeString", 4);
        self.add("RtlFindClearBits", 3);
        self.add("RtlFindClearBitsAndSet", 3);
        self.add("RtlFindClearRuns", 4);
        self.add("RtlFindFirstRunClear", 2);
        self.add("RtlFindLastBackwardRunClear", 3);
        self.add("RtlFindLeastSignificantBit", 1);
        self.add("RtlFindLongestRunClear", 2);
        self.add("RtlFindMessage", 5);
        self.add("RtlFindMostSignificantBit", 1);
        self.add("RtlFindNextForwardRunClear", 3);
        self.add("RtlFindSetBits", 3);
        self.add("RtlFindSetBitsAndClear", 3);
        self.add("RtlFindUnicodePrefix", 3);
        self.add("RtlFirstEntrySList", 1);
        self.add("RtlFirstFreeAce", 2);
        self.add("RtlFlushSecureMemoryCache", 2);
        self.add("RtlFormatCurrentUserKeyPath", 1);
        self.add("RtlFormatMessage", 9);
        self.add("RtlFormatMessageEx", 10);
        self.add("RtlFreeAnsiString", 1);
        self.add("RtlFreeHandle", 2);
        self.add("RtlFreeHeap", 3);
        self.add("RtlFreeMemoryBlockLookaside", 2);
        self.add("RtlFreeOemString", 1);
        self.add("RtlFreeRangeList", 1);
        self.add("RtlFreeSid", 1);
        self.add("RtlFreeToPeb", 2);
        self.add("RtlFreeUnicodeString", 1);
        self.add("RtlFreeUTF8String", 1);
        self.add("RtlGenerate8dot3Name", 4);
        self.add("RtlGetAce", 3);
        self.add("RtlGetActiveActivationContext", 1);
        self.add("RtlGetCallersAddress", 2);
        self.add("RtlGetCompressionWorkSpaceSize", 3);
        self.add("RtlGetControlSecurityDescriptor", 3);
        self.add("RtlGetCriticalSectionRecursionCount", 1);
        self.add("RtlGetCurrentDirectory_U", 2);
        self.add("RtlGetCurrentPeb", 0);
        self.add("RtlGetCurrentProcessorNumber", 0);
        self.add("RtlGetCurrentTransaction", 0);
        self.add("RtlGetDaclSecurityDescriptor", 4);
        self.add("RtlGetDefaultCodePage", 2);
        self.add("RtlGetElementGenericTable", 2);
        self.add("RtlGetElementGenericTableAvl", 2);
        self.add("RtlGetEnabledExtendedFeatures", 1);
        self.add("RtlGetFullPathName_U", 4);
        self.add("RtlGetFullPathName_UEx", 5);
        self.add("RtlGetFullPathName_Ustr", 6);
        self.add("RtlGetFullPathName_UstrEx", 8);
        self.add("RtlGetFunctionTableListHead", 0);
        self.add("RtlGetGroupSecurityDescriptor", 3);
        self.add("RtlGetIntegerAtom", 2);
        self.add("RtlGetLastNtStatus", 0);
        self.add("RtlGetLastWin32Error", 0);
        self.add("RtlGetLengthWithoutLastFullDosOrNtPathElement", 3);
        self.add("RtlGetLocaleFileMappingAddress", 3);
        self.add("RtlGetLongestNtPathLength", 0);
        self.add("RtlGetNativeSystemInformation", 4);
        self.add("RtlGetNextEntryHashTable", 2);
        self.add("RtlGetNtGlobalFlags", 0);
        self.add("RtlGetNtProductType", 1);
        self.add("RtlGetNtVersionNumbers", 3);
        self.add("RtlGetOwnerSecurityDescriptor", 3);
        self.add("RtlGetParentLocaleName", 4);
        self.add("RtlGetProcessHeaps", 2);
        self.add("RtlGetSaclSecurityDescriptor", 4);
        self.add("RtlGetSecurityDescriptorRMControl", 2);
        self.add("RtlGetThreadErrorMode", 0);
        self.add("RtlGetUnloadEventTrace", 0);
        self.add("RtlGetUnloadEventTraceEx", 3);
        self.add("RtlGetUserInfoHeap", 5);
        self.add("RtlGetVersion", 1);
        self.add("RtlGrowFunctionTable", 2);
        self.add("RtlGUIDFromString", 2);
        self.add("RtlHashUnicodeString", 4);
        self.add("RtlHeapCommitRoutine", 3);
        self.add("RtlIdentifierAuthoritySid", 1);
        self.add("RtlImageDirectoryEntryToData", 4);
        self.add("RtlImageNtHeader", 1);
        self.add("RtlImageNtHeaderEx", 4);
        self.add("RtlImageRvaToSection", 3);
        self.add("RtlImageRvaToVa", 4);
        self.add("RtlImpersonateSelf", 1);
        self.add("RtlImpersonateSelfEx", 3);
        self.add("RtlInitAnsiString", 2);
        self.add("RtlInitAnsiStringEx", 2);
        self.add("RtlInitBarrier", 3);
        self.add("RtlInitCodePageTable", 2);
        self.add("RtlInitEnumerationHashTable", 2);
        self.add("RtlInitializeBitMap", 3);
        self.add("RtlInitializeConditionVariable", 1);
        self.add("RtlInitializeContext", 5);
        self.add("RtlInitializeCriticalSection", 1);
        self.add("RtlInitializeCriticalSectionAndSpinCount", 2);
        self.add("RtlInitializeGenericTable", 5);
        self.add("RtlInitializeGenericTableAvl", 5);
        self.add("RtlInitializeHandleTable", 3);
        self.add("RtlInitializeResource", 1);
        self.add("RtlInitializeSid", 3);
        self.add("RtlInitializeSidEx", 4);
        self.add("RtlInitializeSListHead", 1);
        self.add("RtlInitializeSRWLock", 1);
        self.add("RtlInitializeUnicodePrefix", 1);
        self.add("RtlInitNlsTables", 4);
        self.add("RtlInitString", 2);
        self.add("RtlInitStringEx", 2);
        self.add("RtlInitUnicodeString", 2);
        self.add("RtlInitUnicodeStringEx", 2);
        self.add("RtlInitUTF8String", 2);
        self.add("RtlInitUTF8StringEx", 2);
        self.add("RtlInitWeakEnumerationHashTable", 2);
        self.add("RtlInsertElementGenericTable", 4);
        self.add("RtlInsertElementGenericTableAvl", 4);
        self.add("RtlInsertElementGenericTableFull", 6);
        self.add("RtlInsertElementGenericTableFullAvl", 6);
        self.add("RtlInsertEntryHashTable", 4);
        self.add("RtlInsertUnicodePrefix", 3);
        self.add("RtlInstallFunctionTableCallback", 6);
        self.add("RtlInt64ToUnicodeString", 3);
        self.add("RtlIntegerToChar", 4);
        self.add("RtlIntegerToUnicode", 4);
        self.add("RtlIntegerToUnicodeString", 3);
        self.add("RtlInterlockedClearBitRun", 3);
        self.add("RtlInterlockedFlushSList", 1);
        self.add("RtlInterlockedPopEntrySList", 1);
        self.add("RtlInterlockedPushEntrySList", 2);
        self.add("RtlInterlockedSetBitRun", 3);
        self.add("RtlIoDecodeMemIoResource", 4);
        self.add("RtlIoEncodeMemIoResource", 6);
        self.add("RtlIpv4AddressToString", 2);
        self.add("RtlIpv4AddressToStringEx", 4);
        self.add("RtlIpv4StringToAddress", 4);
        self.add("RtlIpv4StringToAddressEx", 4);
        self.add("RtlIpv6AddressToString", 2);
        self.add("RtlIpv6AddressToStringEx", 5);
        self.add("RtlIpv6StringToAddress", 3);
        self.add("RtlIpv6StringToAddressEx", 4);
        self.add("RtlIsCloudFilesPlaceholder", 2);
        self.add("RtlIsCriticalSectionLocked", 1);
        self.add("RtlIsCriticalSectionLockedByThread", 1);
        self.add("RtlIsDosDeviceName_U", 1);
        self.add("RtlIsDosDeviceName_Ustr", 1);
        self.add("RtlIsGenericTableEmpty", 1);
        self.add("RtlIsGenericTableEmptyAvl", 1);
        self.add("RtlIsNameInExpression", 4);
        self.add("RtlIsNameLegalDOS8Dot3", 3);
        self.add("RtlIsNormalizedString", 4);
        self.add("RtlIsNtDdiVersionAvailable", 1);
        self.add("RtlIsPartialPlaceholder", 2);
            self.add("RtlIsPartialPlaceholderFileHandle", 2);
        self.add("RtlIsPartialPlaceholderFileInfo", 3);
            self.add("RtlIsServicePackVersionInstalled", 1);
        self.add("RtlIsTextUnicode", 3);
        self.add("RtlIsThreadWithinLoaderCallout", 0);
        self.add("RtlIsValidHandle", 2);
        self.add("RtlIsValidIndexHandle", 3);
        self.add("RtlIsValidLocaleName", 2);
        self.add("RtlIsValidOemCharacter", 1);
        self.add("RtlLargeIntegerAdd", 2);
        self.add("RtlLargeIntegerArithmeticShift", 2);
        self.add("RtlLargeIntegerDivide", 3);
        self.add("RtlLargeIntegerNegate", 1);
        self.add("RtlLargeIntegerShiftLeft", 2);
        self.add("RtlLargeIntegerShiftRight", 2);
        self.add("RtlLargeIntegerSubtract", 2);
        self.add("RtlLargeIntegerToChar", 4);
        self.add("RtlLCIDToCultureName", 2);
        self.add("RtlLcidToLocaleName", 4);
        self.add("RtlLeaveCriticalSection", 1);
        self.add("RtlLengthRequiredSid", 1);
        self.add("RtlLengthSecurityDescriptor", 1);
        self.add("RtlLengthSid", 1);
        self.add("RtlLocaleNameToLcid", 3);
        self.add("RtlLocalTimeToSystemTime", 2);
        self.add("RtlLockCurrentThread", 0);
        self.add("RtlLockHeap", 1);
        self.add("RtlLockMemoryBlockLookaside", 1);
        self.add("RtlLockMemoryZone", 1);
        self.add("RtlLockModuleSection", 1);
        self.add("RtlLogStackBackTrace", 0);
        self.add("RtlLookupAtomInAtomTable", 3);
        self.add("RtlLookupElementGenericTable", 2);
        self.add("RtlLookupElementGenericTableAvl", 2);
        self.add("RtlLookupElementGenericTableFull", 4);
        self.add("RtlLookupElementGenericTableFullAvl", 4);
        self.add("RtlLookupEntryHashTable", 3);
        self.add("RtlLookupFirstMatchingElementGenericTableAvl", 3);
        self.add("RtlLookupFunctionEntry", 3);
        self.add("RtlMakeSelfRelativeSD", 3);
        self.add("RtlMapGenericMask", 2);
        self.add("RtlMoveMemory", 3);
        self.add("RtlMultiAppendUnicodeStringBuffer", 3);
        self.add("RtlMultiByteToUnicodeN", 5);
        self.add("RtlMultiByteToUnicodeSize", 3);
        self.add("RtlMultipleAllocateHeap", 5);
        self.add("RtlMultipleFreeHeap", 4);
        self.add("RtlNewInstanceSecurityObject", 10);
        self.add("RtlNewSecurityObject", 6);
        self.add("RtlNewSecurityObjectEx", 8);
        self.add("RtlNewSecurityObjectWithMultipleInheritance", 9);
        self.add("RtlNextUnicodePrefix", 2);
        self.add("RtlNormalizeProcessParams", 1);
        self.add("RtlNormalizeString", 5);
        self.add("RtlNtStatusToDosError", 1);
        self.add("RtlNtStatusToDosErrorNoTeb", 1);
        self.add("RtlNumberGenericTableElements", 1);
        self.add("RtlNumberGenericTableElementsAvl", 1);
        self.add("RtlNumberOfClearBits", 1);
        self.add("RtlNumberOfSetBits", 1);
        self.add("RtlNumberOfSetBitsUlongPtr", 1);
            self.add("RtlOemStringToCountedUnicodeString", 3);
        self.add("RtlOemStringToCountedUnicodeString", 3);
        self.add("RtlOemStringToUnicodeString", 3);
        self.add("RtlOemToUnicodeN", 5);
        self.add("RtlOpenCurrentUser", 2);
        self.add("RtlOwnerAcesPresent", 1);
        self.add("RtlPcToFileHeader", 2);
        self.add("RtlpEnsureBufferSize", 3);
        self.add("RtlPinAtomInAtomTable", 2);
        self.add("RtlpNtOpenKey", 4);
        self.add("RtlPrefetchMemoryNonTemporal", 2);
        self.add("RtlPrefixString", 3);
        self.add("RtlPrefixUnicodeString", 3);
        self.add("RtlProtectHeap", 2);
        self.add("RtlpUnWaitCriticalSection", 1);
        self.add("RtlpWaitForCriticalSection", 1);
        self.add("RtlQueryAtomInAtomTable", 6);
        self.add("RtlQueryCriticalSectionOwner", 1);
        self.add("RtlQueryDepthSList", 1);
        self.add("RtlQueryElevationFlags", 1);
        self.add("RtlQueryEnvironmentVariable", 6);
        self.add("RtlQueryEnvironmentVariable_U", 3);
        self.add("RtlQueryHeapInformation", 5);
        self.add("RtlQueryInformationAcl", 4);
        self.add("RtlQueryInformationActivationContext", 7);
        self.add("RtlQueryPackageIdentity", 6);
        self.add("RtlQueryPackageIdentityEx", 7);
        self.add("RtlQueryPerformanceCounter", 1);
        self.add("RtlQueryPerformanceFrequency", 1);
        self.add("RtlQueryProcessDebugInformation", 3);
            self.add("RtlQueryProcessPlaceholderCompatibilityMode", 1);
        self.add("RtlQueryRegistryRoutine", 6);
        self.add("RtlQueryRegistryValues", 5);
        self.add("RtlQuerySecurityObject", 5);
        self.add("RtlQueryTagHeap", 5);
            self.add("RtlQueryThreadPlaceholderCompatibilityMode", 1);
        self.add("RtlQueryThreadProfiling", 2);
        self.add("RtlQueryTimeZoneInformation", 1);
        self.add("RtlQueueWorkItem", 3);
        self.add("RtlRaiseStatus", 1);
        self.add("RtlRandom", 1);
        self.add("RtlRandomEx", 1);
        self.add("RtlRbInsertNodeEx", 4);
        self.add("RtlRbRemoveNode", 2);
        self.add("RtlReadThreadProfilingData", 3);
        self.add("RtlReAllocateHeap", 4);
        self.add("RtlRealPredecessor", 1);
        self.add("RtlRealSuccessor", 1);
        self.add("RtlRegisterSecureMemoryCacheCallback", 1);
        self.add("RtlRegisterThreadWithCsrss", 0);
        self.add("RtlRegisterWait", 6);
        self.add("RtlReleaseActivationContext", 1);
        self.add("RtlReleasePebLock", 0);
        self.add("RtlReleasePrivilege", 1);
        self.add("RtlReleaseRelativeName", 1);
        self.add("RtlReleaseResource", 1);
        self.add("RtlReleaseSRWLockExclusive", 1);
        self.add("RtlReleaseSRWLockShared", 1);
        self.add("RtlRemoteCall", 7);
        self.add("RtlRemoveEntryHashTable", 3);
        self.add("RtlRemovePrivileges", 3);
        self.add("RtlRemoveUnicodePrefix", 2);
        self.add("RtlRemoveVectoredContinueHandler", 1);
        self.add("RtlRemoveVectoredExceptionHandler", 1);
        self.add("RtlReplaceSidInSd", 4);
        self.add("RtlReportException", 3);
        self.add("RtlReportSilentProcessExit", 2);
        self.add("RtlReserveChunk", 5);
        self.add("RtlResetMemoryBlockLookaside", 1);
        self.add("RtlResetMemoryZone", 1);
        self.add("RtlResetRtlTranslations", 1);
        self.add("RtlRestoreContext", 2);
        self.add("RtlRestoreLastWin32Error", 1);
        self.add("RtlRunDecodeUnicodeString", 2);
        self.add("RtlRunEncodeUnicodeString", 2);
        self.add("RtlRunOnceBeginInitialize", 3);
        self.add("RtlRunOnceComplete", 3);
        self.add("RtlRunOnceExecuteOnce", 4);
        self.add("RtlRunOnceInitialize", 1);
        self.add("RtlSanitizeUnicodeStringPadding", 1);
        self.add("RtlSecondsSince1970ToTime", 2);
        self.add("RtlSecondsSince1980ToTime", 2);
        self.add("RtlSectionTableFromVirtualAddress", 3);
        self.add("RtlSecureZeroMemory", 2);
        self.add("RtlSelfRelativeToAbsoluteSD", 11);
        self.add("RtlSelfRelativeToAbsoluteSD2", 2);
        self.add("RtlSetAllBits", 1);
        self.add("RtlSetAttributesSecurityDescriptor", 3);
        self.add("RtlSetBit", 2);
        self.add("RtlSetBits", 3);
        self.add("RtlSetControlSecurityDescriptor", 3);
        self.add("RtlSetCriticalSectionSpinCount", 2);
        self.add("RtlSetCurrentDirectory_U", 1);
        self.add("RtlSetCurrentEnvironment", 2);
        self.add("RtlSetCurrentTransaction", 1);
        self.add("RtlSetDaclSecurityDescriptor", 4);
        self.add("RtlSetEnvironmentStrings", 2);
        self.add("RtlSetEnvironmentVar", 5);
        self.add("RtlSetEnvironmentVariable", 3);
        self.add("RtlSetGroupSecurityDescriptor", 3);
        self.add("RtlSetHeapInformation", 4);
        self.add("RtlSetInformationAcl", 4);
        self.add("RtlSetIoCompletionCallback", 3);
        self.add("RtlSetLastWin32Error", 1);
        self.add("RtlSetLastWin32ErrorAndNtStatusFromNtStatus", 1);
        self.add("RtlSetOwnerSecurityDescriptor", 3);
        self.add("RtlSetProcessIsCritical", 3);
            self.add("RtlSetProcessPlaceholderCompatibilityMode", 1);
        self.add("RtlSetSaclSecurityDescriptor", 4);
        self.add("RtlSetSecurityDescriptorRMControl", 2);
        self.add("RtlSetSecurityObject", 5);
        self.add("RtlSetSecurityObjectEx", 6);
        self.add("RtlSetThreadErrorMode", 2);
        self.add("RtlSetThreadIsCritical", 3);
            self.add("RtlSetThreadPlaceholderCompatibilityMode", 1);
        self.add("RtlSetTimeZoneInformation", 1);
        self.add("RtlSetUnhandledExceptionFilter", 1);
        self.add("RtlSetUserFlagsHeap", 4);
        self.add("RtlSetUserValueHeap", 4);
        self.add("RtlSidDominates", 3);
        self.add("RtlSidEqualLevel", 3);
        self.add("RtlSidHashInitialize", 3);
        self.add("RtlSidHashLookup", 2);
        self.add("RtlSidIsHigherLevel", 3);
        self.add("RtlSizeHeap", 3);
        self.add("RtlSleepConditionVariableCS", 3);
        self.add("RtlSleepConditionVariableSRW", 4);
        self.add("RtlSplay", 1);
        self.add("RtlStringFromGUID", 2);
        self.add("RtlSubAuthorityCountSid", 1);
        self.add("RtlSubAuthoritySid", 2);
        self.add("RtlSubtreePredecessor", 1);
        self.add("RtlSubtreeSuccessor", 1);
        self.add("RtlSystemTimeToLocalTime", 2);
        self.add("RtlTestBit", 2);
        self.add("RtlTimeFieldsToTime", 2);
        self.add("RtlTimeToElapsedTimeFields", 2);
        self.add("RtlTimeToSecondsSince1970", 2);
        self.add("RtlTimeToSecondsSince1980", 2);
        self.add("RtlTimeToTimeFields", 2);
        self.add("RtlTraceDatabaseAdd", 4);
        self.add("RtlTraceDatabaseCreate", 5);
        self.add("RtlTraceDatabaseDestroy", 1);
        self.add("RtlTraceDatabaseEnumerate", 3);
        self.add("RtlTraceDatabaseFind", 4);
        self.add("RtlTraceDatabaseLock", 1);
        self.add("RtlTraceDatabaseUnlock", 1);
        self.add("RtlTraceDatabaseValidate", 1);
        self.add("RtlTryAcquirePebLock", 0);
        self.add("RtlTryAcquireSRWLockExclusive", 1);
        self.add("RtlTryAcquireSRWLockShared", 1);
        self.add("RtlTryEnterCriticalSection", 1);
        self.add("RtlUlongByteSwap", 1);
        self.add("RtlUlonglongByteSwap", 1);
        self.add("RtlUnhandledExceptionFilter", 1);
        self.add("RtlUnicodeStringToAnsiSize", 1);
        self.add("RtlUnicodeStringToAnsiString", 3);
            self.add("RtlUnicodeStringToCountedOemString", 3);
        self.add("RtlUnicodeStringToCountedOemString", 3);
        self.add("RtlUnicodeStringToInteger", 3);
        self.add("RtlUnicodeStringToOemString", 3);
        self.add("RtlUnicodeStringToUTF8String", 3);
        self.add("RtlUnicodeToCustomCPN", 6);
        self.add("RtlUnicodeToMultiByteN", 5);
        self.add("RtlUnicodeToMultiByteSize", 3);
        self.add("RtlUnicodeToOemN", 5);
        self.add("RtlUnicodeToUTF8N", 5);
        self.add("RtlUniform", 1);
        self.add("RtlUnlockCurrentThread", 0);
        self.add("RtlUnlockHeap", 1);
        self.add("RtlUnlockMemoryBlockLookaside", 1);
        self.add("RtlUnlockMemoryZone", 1);
        self.add("RtlUnlockModuleSection", 1);
        self.add("RtlUpcaseUnicodeChar", 1);
        self.add("RtlUpcaseUnicodeString", 3);
        self.add("RtlUpcaseUnicodeStringToAnsiString", 3);
            self.add("RtlUpcaseUnicodeStringToCountedOemString", 3);
        self.add("RtlUpcaseUnicodeStringToCountedOemString", 3);
            self.add("RtlUpcaseUnicodeStringToOemString", 3);
        self.add("RtlUpcaseUnicodeStringToOemString", 3);
        self.add("RtlUpcaseUnicodeToCustomCPN", 6);
        self.add("RtlUpcaseUnicodeToMultiByteN", 5);
        self.add("RtlUpcaseUnicodeToOemN", 5);
        self.add("RtlUpdateClonedCriticalSection", 1);
        self.add("RtlUpdateClonedSRWLock", 2);
        self.add("RtlUpdateTimer", 4);
        self.add("RtlUpperChar", 1);
        self.add("RtlUpperString", 2);
        self.add("RtlUsageHeap", 3);
        self.add("RtlUshortByteSwap", 1);
        self.add("RtlUTF8StringToUnicodeString", 3);
        self.add("RtlUTF8ToUnicodeN", 5);
        self.add("RtlValidAcl", 1);
        self.add("RtlValidateHeap", 3);
        self.add("RtlValidateProcessHeaps", 0);
        self.add("RtlValidateUnicodeString", 2);
            self.add("RtlValidRelativeSecurityDescriptor", 3);
        self.add("RtlValidRelativeSecurityDescriptor", 3);
        self.add("RtlValidSecurityDescriptor", 1);
        self.add("RtlValidSid", 1);
        self.add("RtlVerifyVersionInfo", 3);
        self.add("RtlWakeAllConditionVariable", 1);
        self.add("RtlWakeConditionVariable", 1);
        self.add("RtlWalkFrameChain", 3);
        self.add("RtlWalkHeap", 2);
        self.add("RtlWeaklyEnumerateEntryHashTable", 2);
        self.add("RtlWerpReportException", 4);
        self.add("RtlWow64GetThreadContext", 2);
        self.add("RtlWow64SetThreadContext", 2);
        self.add("RtlWriteRegistryValue", 6);
        self.add("RtlxAnsiStringToUnicodeSize", 1);
        self.add("RtlxOemStringToUnicodeSize", 1);
        self.add("RtlxUnicodeStringToAnsiSize", 1);
        self.add("RtlxUnicodeStringToOemSize", 1);
        self.add("RtlZeroHeap", 2);
        self.add("RtlZeroMemory", 2);
        self.add("RtlZombifyActivationContext", 1);
        self.add("RunAsNewUser_RunDLLW", 4);
        self.add("RunFileDlg", 6);
        self.add("RunOnceUrlCache", 4);
        self.add("RxCreateNetFcb", 4);
        self.add("RxCreateNetFobx", 2);
        self.add("RxCreateNetRoot", 4);
        self.add("RxCreateSrvCall", 4);
        self.add("RxCreateSrvOpen", 2);
        self.add("RxCreateVNetRoot", 6);
        self.add("RxFinalizeNetFobx", 3);
        self.add("RxFinalizeNetRoot", 3);
        self.add("RxFinalizeSrvCall", 2);
        self.add("RxFinalizeSrvOpen", 3);
        self.add("RxFinalizeVNetRoot", 3);
        self.add("RxFinishFcbInitialization", 3);
        self.add("RxGetFileSizeWithLock", 2);
        self.add("RxInferFileType", 1);
        self.add("RxpDereferenceAndFinalizeNetFcb", 4);
        self.add("RxpDereferenceNetFcb", 1);
        self.add("RxpReferenceNetFcb", 1);
        self.add("RxpTrackDereference", 4);
        self.add("RxpTrackReference", 4);
        self.add("SafeArrayAccessData", 2);
        self.add("SafeArrayAllocData", 1);
        self.add("SafeArrayAllocDescriptor", 2);
        self.add("SafeArrayAllocDescriptorEx", 3);
        self.add("SafeArrayCopy", 2);
        self.add("SafeArrayCopyData", 2);
        self.add("SafeArrayCreate", 3);
        self.add("SafeArrayCreateEx", 4);
        self.add("SafeArrayCreateVector", 3);
        self.add("SafeArrayCreateVectorEx", 4);
        self.add("SafeArrayDestroy", 1);
        self.add("SafeArrayDestroyData", 1);
        self.add("SafeArrayDestroyDescriptor", 1);
        self.add("SafeArrayGetDim", 1);
        self.add("SafeArrayGetElement", 3);
        self.add("SafeArrayGetElemsize", 1);
        self.add("SafeArrayGetIID", 2);
        self.add("SafeArrayGetLBound", 3);
        self.add("SafeArrayGetRecordInfo", 2);
        self.add("SafeArrayGetUBound", 3);
        self.add("SafeArrayGetVartype", 2);
        self.add("SafeArrayLock", 1);
        self.add("SafeArrayPtrOfIndex", 3);
        self.add("SafeArrayPutElement", 3);
        self.add("SafeArrayRedim", 2);
        self.add("SafeArraySetIID", 2);
        self.add("SafeArraySetRecordInfo", 2);
        self.add("SafeArrayUnaccessData", 1);
        self.add("SafeArrayUnlock", 1);
        self.add("SaferCloseLevel", 1);
        self.add("SaferComputeTokenFromLevel", 5);
        self.add("SaferCreateLevel", 5);
        self.add("SaferGetLevelInformation", 5);
        self.add("SaferGetPolicyInformation", 6);
        self.add("SaferIdentifyLevel", 4);
        self.add("SaferiIsExecutableFileType", 2);
        self.add("SaferRecordEventLogEntry", 3);
        self.add("SaslAcceptSecurityContext", 9);
        self.add("SaslEnumerateProfiles", 2);
        self.add("SaslGetContextOption", 5);
        self.add("SaslGetProfilePackage", 2);
        self.add("SaslIdentifyPackage", 2);
        self.add("SaslInitializeSecurityContext", 12);
        self.add("SaslSetContextOption", 4);
        self.add("SaveCurrentMonitorSettings", 1);
        self.add("SaveCurrentSettings", 1);
        self.add("SaveDC", 1);
        self.add("SaveDefaultUserInputSettings", 2);
        self.add("SaveSystemAcctInputSettings", 2);
        self.add("scalb", 2);
        self.add("ScaleViewportExtEx", 6);
        self.add("ScaleWindowExtEx", 6);
        self.add("scanf", 1);
        self.add("scanf_l", 2);
        self.add("scanf_s", 1);
        self.add("scanf_s_l", 2);
        self.add("ScanLogContainers", 3);
        self.add("SCardAccessStartedEvent", 0);
        self.add("SCardAddReaderToGroup", 3);
        self.add("SCardAudit", 2);
        self.add("SCardBeginTransaction", 1);
        self.add("SCardCancel", 1);
        self.add("SCardConnect", 6);
        self.add("SCardControl", 7);
        self.add("SCardDisconnect", 2);
        self.add("SCardDlgExtendedError", 0);
        self.add("SCardEndTransaction", 2);
        self.add("SCardEstablishContext", 4);
        self.add("SCardForgetCardType", 2);
        self.add("SCardForgetReader", 2);
        self.add("SCardForgetReaderGroup", 2);
        self.add("SCardFreeMemory", 2);
        self.add("SCardGetAttrib", 4);
        self.add("SCardGetCardTypeProviderName", 5);
        self.add("SCardGetDeviceTypeId", 3);
        self.add("SCardGetProviderId", 3);
        self.add("SCardGetReaderDeviceInstanceId", 4);
        self.add("SCardGetReaderIcon", 4);
        self.add("SCardGetStatusChange", 4);
        self.add("SCardGetTransmitCount", 2);
        self.add("SCardIntroduceCardType", 8);
        self.add("SCardIntroduceReader", 3);
        self.add("SCardIntroduceReaderGroup", 2);
        self.add("SCardIsValidContext", 1);
        self.add("SCardListCards", 6);
        self.add("SCardListInterfaces", 4);
        self.add("SCardListReaderGroups", 3);
        self.add("SCardListReaders", 4);
        self.add("SCardListReadersWithDeviceInstanceId", 4);
        self.add("SCardLocateCards", 4);
        self.add("SCardLocateCardsByATR", 5);
        self.add("SCardReadCache", 6);
        self.add("SCardReconnect", 5);
        self.add("SCardReleaseContext", 1);
        self.add("SCardReleaseStartedEvent", 0);
        self.add("SCardRemoveReaderFromGroup", 3);
        self.add("SCardSetAttrib", 4);
        self.add("SCardSetCardTypeProviderName", 4);
        self.add("SCardState", 5);
        self.add("SCardStatus", 7);
        self.add("SCardTransmit", 7);
        self.add("SCardUIDlgSelectCard", 1);
        self.add("SCardWriteCache", 6);
        self.add("ScBinFromHexBounded", 3);
        self.add("ScCopyNotifications", 4);
        self.add("ScCopyProps", 4);
        self.add("ScCountNotifications", 3);
        self.add("ScCountProps", 3);
        self.add("ScCreateConversationIndex", 4);
        self.add("ScDupPropset", 4);
        self.add("ScheduleJob", 2);
        self.add("ScInitMapiUtil", 1);
        self.add("ScLocalPathFromUNC", 3);
        self.add("scprintf", 1);
        self.add("scprintf_l", 2);
        self.add("scprintf_p", 1);
        self.add("scprintf_p_l", 2);
        self.add("ScreenToClient", 2);
        self.add("ScRelocNotifications", 5);
        self.add("ScRelocProps", 5);
        self.add("ScriptApplyDigitSubstitution", 3);
        self.add("ScriptApplyLogicalWidth", 9);
        self.add("ScriptBreak", 4);
        self.add("ScriptCacheGetHeight", 3);
        self.add("ScriptCPtoX", 9);
        self.add("ScriptFreeCache", 1);
        self.add("ScriptGetCMap", 6);
        self.add("ScriptGetFontAlternateGlyphs", 10);
        self.add("ScriptGetFontFeatureTags", 8);
        self.add("ScriptGetFontLanguageTags", 7);
        self.add("ScriptGetFontProperties", 3);
        self.add("ScriptGetFontScriptTags", 6);
        self.add("ScriptGetGlyphABCWidth", 4);
        self.add("ScriptGetLogicalWidths", 7);
        self.add("ScriptGetProperties", 2);
        self.add("ScriptIsComplex", 3);
        self.add("ScriptItemize", 7);
        self.add("ScriptItemizeOpenType", 8);
        self.add("ScriptJustify", 6);
        self.add("ScriptLayout", 4);
        self.add("ScriptPlace", 9);
        self.add("ScriptPlaceOpenType", 18);
        self.add("ScriptPositionSingleGlyph", 12);
        self.add("ScriptRecordDigitSubstitution", 2);
        self.add("ScriptShape", 10);
        self.add("ScriptShapeOpenType", 16);
        self.add("ScriptStringAnalyse", 13);
        self.add("ScriptStringCPtoX", 4);
        self.add("ScriptStringFree", 1);
        self.add("ScriptStringGetLogicalWidths", 2);
        self.add("ScriptStringGetOrder", 2);
        self.add("ScriptStringOut", 8);
        self.add("ScriptString_pcOutChars", 1);
        self.add("ScriptString_pLogAttr", 1);
        self.add("ScriptString_pSize", 1);
        self.add("ScriptStringValidate", 1);
        self.add("ScriptStringXtoCP", 4);
        self.add("ScriptSubstituteSingleGlyph", 9);
        self.add("ScriptTextOut", 14);
        self.add("ScriptXtoCP", 9);
        self.add("ScrollConsoleScreenBuffer", 5);
        self.add("ScrollDC", 7);
        self.add("ScrollWindow", 5);
        self.add("ScrollWindowEx", 8);
        self.add("ScUNCFromLocalPath", 3);
        self.add("scwprintf", 1);
        self.add("scwprintf_l", 2);
        self.add("scwprintf_p", 1);
        self.add("scwprintf_p_l", 2);
        self.add("SeAccessCheck", 10);
        self.add("SeAppendPrivileges", 2);
        self.add("searchenv", 3);
        self.add("searchenv_s", 4);
        self.add("SearchPath", 6);
        self.add("SearchTreeForFile", 3);
        self.add("SeAssignSecurity", 7);
        self.add("SeAssignSecurityEx", 9);
        self.add("SeAuditHardLinkCreation", 3);
        self.add("SeAuditingFileEvents", 2);
        self.add("SeAuditingFileOrGlobalEvents", 3);
        self.add("SeAuditingHardLinkEvents", 2);
        self.add("SeCaptureSubjectContext", 1);
        self.add("SecLookupAccountName", 6);
        self.add("SecLookupAccountSid", 6);
        self.add("SecLookupWellKnownSid", 4);
        self.add("SecMakeSPN", 8);
        self.add("SecMakeSPNEx2", 10);
        self.add("SecMakeSPNEx", 9);
        self.add("SeCreateClientSecurity", 4);
            self.add("SeCreateClientSecurityFromSubjectContext", 4);
        self.add("SeDeassignSecurity", 1);
        self.add("SeDeleteClientSecurity", 1);
        self.add("SeDeleteObjectAuditAlarm", 2);
        self.add("SeFilterToken", 6);
        self.add("SeImpersonateClient", 2);
        self.add("SeImpersonateClientEx", 2);
        self.add("select", 5);
        self.add("SelectClipPath", 2);
        self.add("SelectClipRgn", 2);
        self.add("SelectCMM", 1);
        self.add("SelectObject", 2);
        self.add("SelectPalette", 3);
        self.add("SeLockSubjectContext", 1);
            self.add("SeMarkLogonSessionForTerminationNotification", 1);
        self.add("send", 4);
        self.add("SendARP", 4);
        self.add("Sendasyncproc", 4);
        self.add("SendDlgItemMessage", 5);
        self.add("SendDlgItemMessageA", 5);
        self.add("SendDlgItemMessageW", 5);
        self.add("SendDriverMessage", 4);
        self.add("SendInput", 3);
        self.add("SendMessage", 4);
        self.add("SendMessageA", 4);
        self.add("SendMessageCallback", 6);
        self.add("SendMessageCallbackA", 6);
        self.add("SendMessageCallbackW", 6);
        self.add("SendMessageTimeout", 7);
        self.add("SendMessageTimeoutA", 7);
        self.add("SendMessageTimeoutW", 7);
        self.add("SendMessageW", 4);
        self.add("SendNotifyMessage", 4);
        self.add("SendNotifyMessageA", 4);
        self.add("SendNotifyMessageW", 4);
        self.add("SendScsiInquiry", 9);
        self.add("SendScsiReadCapacity", 7);
        self.add("SendScsiReportLuns", 6);
        self.add("sendto", 6);
        self.add("SendToFaxRecipient", 2);
        self.add("SeOpenObjectAuditAlarm", 9);
        self.add("SeOpenObjectForDeleteAuditAlarm", 9);
        self.add("SePrivilegeCheck", 3);
        self.add("SeQueryAuthenticationIdToken", 2);
        self.add("SeQueryInformationToken", 3);
        self.add("SeQuerySecurityDescriptorInfo", 4);
        self.add("SeQuerySessionIdToken", 2);
            self.add("SeRegisterLogonSessionTerminatedRoutine", 1);
        self.add("SeReleaseSubjectContext", 1);
        self.add("SeSetAccessStateGenericMapping", 2);
        self.add("SeSetSecurityDescriptorInfo", 6);
        self.add("SeSetSecurityDescriptorInfoEx", 7);
        self.add("SeSetSessionIdToken", 2);
        self.add("set_abort_behavior", 2);
        self.add("SetAbortProc", 2);
        self.add("SetAclInformation", 4);
        self.add("SetActivePwrScheme", 3);
        self.add("SetActiveWindow", 1);
            self.add("SetAdditionalForegroundBoostProcesses", 3);
        self.add("SetAddrInfoEx", 12);
        self.add("set_amblksiz", 1);
        self.add("set_app_type", 1);
        self.add("SetArcDirection", 2);
        self.add("SetAttribIMsgOnIStg", 4);
        self.add("SetBitmapBits", 3);
        self.add("SetBitmapDimensionEx", 4);
        self.add("SetBkColor", 2);
        self.add("SetBkMode", 2);
        self.add("SetBoundsRect", 3);
        self.add("SetBrushOrgEx", 4);
        self.add("setbuf", 2);
        self.add("SetCalendarInfo", 4);
        self.add("SetCapture", 1);
        self.add("SetCaretBlinkTime", 1);
        self.add("SetCaretPos", 2);
        self.add("SetCatalogState", 4);
        self.add("SetClassLong", 3);
        self.add("SetClassLongA", 3);
        self.add("SetClassLongPtrA", 3);
        self.add("SetClassLongPtrW", 3);
        self.add("SetClassLongW", 3);
        self.add("SetClassWord", 3);
        self.add("SetClipboardData", 2);
        self.add("SetClipboardViewer", 1);
        self.add("SetCoalescableTimer", 5);
        self.add("SetColorAdjustment", 2);
        self.add("SetColorProfileElement", 5);
        self.add("SetColorProfileElementReference", 3);
        self.add("SetColorProfileElementSize", 3);
        self.add("SetColorProfileHeader", 2);
        self.add("SetColorSpace", 2);
        self.add("SetCommBreak", 1);
        self.add("SetCommConfig", 3);
        self.add("SetCommMask", 2);
        self.add("SetCommState", 2);
        self.add("SetCommTimeouts", 2);
        self.add("SetCompressorInformation", 4);
        self.add("SetComputerName", 1);
        self.add("SetComputerNameEx", 2);
        self.add("SetConsoleActiveScreenBuffer", 1);
        self.add("SetConsoleCP", 1);
        self.add("SetConsoleCtrlHandler", 2);
        self.add("SetConsoleCursor", 2);
        self.add("SetConsoleCursorInfo", 2);
        self.add("SetConsoleCursorPosition", 2);
        self.add("SetConsoleDisplayMode", 3);
        self.add("SetConsoleHistoryInfo", 1);
        self.add("SetConsoleInputExeName", 1);
        self.add("SetConsoleMaximumWindowSize", 2);
        self.add("SetConsoleMode", 2);
        self.add("SetConsoleOutputCP", 1);
        self.add("SetConsoleScreenBufferInfoEx", 2);
        self.add("SetConsoleScreenBufferSize", 2);
        self.add("SetConsoleTextAttribute", 2);
        self.add("SetConsoleTitle", 1);
        self.add("SetConsoleWindowInfo", 3);
        self.add("SetContextAttributes", 4);
        self.add("set_controlfp", 2);
        self.add("SetConvertStg", 2);
        self.add("SetCriticalSectionSpinCount", 2);
        self.add("SetCrossSlideParametersInteractionContext", 3);
        self.add("SetCurrentConsoleFontEx", 3);
        self.add("SetCurrentDirectory", 1);
        self.add("SetCurrentDirectoryW", 1);
        self.add("SetCurrentProcessExplicitAppUserModelID", 1);
        self.add("SetCursor", 1);
        self.add("SetCursorPos", 2);
        self.add("SetD3coldSupport", 2);
        self.add("SetDCBrushColor", 2);
        self.add("SetDCPenColor", 2);
        self.add("SetDecompressorInformation", 4);
        self.add("SetDefaultCommConfig", 3);
        self.add("SetDefaultDllDirectories", 1);
        self.add("SetDefaultLayoutOrTip", 2);
        self.add("SetDefaultLayoutOrTipUserReg", 5);
        self.add("SetDefaultPrinter", 1);
        self.add("SetDeviceGammaRamp", 2);
        self.add("SetDIBColorTable", 4);
        self.add("SetDIBits", 7);
        self.add("SetDIBitsToDevice", 12);
        self.add("SetDlgItemInt", 4);
        self.add("SetDlgItemText", 3);
        self.add("SetDlgItemTextA", 3);
        self.add("SetDlgItemTextW", 3);
        self.add("SetDllDirectory", 1);
        self.add("SetDllDirectoryW", 1);
        self.add("set_doserrno", 1);
        self.add("SetDoubleClickTime", 1);
        self.add("SetDynamicTimeZoneInformation", 1);
        self.add("SetEndOfFile", 1);
        self.add("SetEndOfLog", 3);
        self.add("SetEnhMetaFileBits", 2);
        self.add("SetEnlistmentRecoveryInformation", 3);
        self.add("SetEntriesInAcl", 4);
        self.add("SetEnvironmentVariable", 2);
        self.add("set_errno", 1);
        self.add("SetErrorInfo", 2);
        self.add("set_error_mode", 1);
        self.add("seterrormode", 1);
        self.add("SetErrorMode", 1);
        self.add("SetEvent", 1);
        self.add("SetEventWhenCallbackReturns", 2);
        self.add("SetExtendedFeaturesMask", 2);
        self.add("SetFileApisToANSI", 0);
        self.add("SetFileApisToANSI", 1);
        self.add("SetFileApisToOEM", 0);
        self.add("SetFileApisToOEM", 1);
        self.add("SetFileAttributes", 2);
        self.add("SetFileAttributesA", 2);
        self.add("SetFileAttributesTransacted", 3);
        self.add("SetFileAttributesW", 2);
        self.add("SetFileBandwidthReservation", 6);
        self.add("SetFileCompletionNotificationModes", 2);
        self.add("set_fileinfo", 1);
        self.add("SetFileInformationByHandle", 4);
        self.add("SetFileIoOverlappedRange", 3);
        self.add("SetFilePointer", 4);
        self.add("SetFilePointerEx", 4);
        self.add("SetFileSecurity", 3);
        self.add("SetFileShortName", 2);
        self.add("SetFileTime", 4);
        self.add("SetFileValidData", 2);
        self.add("SetFirmwareEnvironmentVariable", 4);
        self.add("set_fmode", 1);
        self.add("SetFocus", 1);
        self.add("SetForegroundWindow", 1);
        self.add("SetForm", 4);
        self.add("SetGestureConfig", 5);
        self.add("SetGraphicsMode", 2);
        self.add("SetHandleCount", 1);
        self.add("SetHandleInformation", 3);
        self.add("SetICMMode", 2);
        self.add("SetICMProfile", 2);
        self.add("SetIfEntry", 1);
        self.add("SetImageConfigInformation", 2);
        self.add("SetInertiaParameterInteractionContext", 3);
        self.add("SetInformationJobObject", 4);
        self.add("SetInputScope", 2);
        self.add("SetInputScopes2", 6);
        self.add("SetInputScopes", 7);
        self.add("SetInputScopeXML", 0);
        self.add("SetInteractionConfigurationInteractionContext", 3);
        self.add("set_invalid_parameter_handler", 1);
        self.add("SetIpForwardEntry", 1);
        self.add("SetIpForwardEntry2", 1);
        self.add("SetIpInterfaceEntry", 1);
        self.add("SetIpNetEntry", 1);
        self.add("SetIpNetEntry2", 1);
        self.add("SetIpStatistics", 1);
        self.add("SetIpStatisticsEx", 2);
        self.add("SetIpTTL", 1);
        self.add("SetIScsiGroupPresharedKey", 3);
        self.add("SetIScsiIKEInfo", 4);
        self.add("SetIScsiInitiatorCHAPSharedSecret", 2);
        self.add("SetIScsiInitiatorNodeName", 1);
        self.add("SetIScsiInitiatorRADIUSSharedSecret", 2);
        self.add("SetIScsiTunnelModeOuterAddress", 5);
        self.add("SetJob", 5);
        self.add("SetKernelObjectSecurity", 3);
        self.add("SetKeyboardState", 1);
        self.add("SetLastError", 1);
        self.add("SetLastErrorEx", 2);
        self.add("SetLayeredWindowAttributes", 4);
        self.add("SetLayout", 2);
        self.add("setlocale", 2);
        self.add("SetLocaleInfo", 3);
        self.add("SetLocalTime", 1);
        self.add("SetLogArchiveMode", 2);
        self.add("SetLogArchiveTail", 3);
        self.add("SetLogFileSizeWithPolicy", 3);
        self.add("SetMailslotInfo", 2);
        self.add("SetMapMode", 2);
        self.add("SetMapperFlags", 2);
        self.add("setmaxstdio", 1);
        self.add("setmbcp", 1);
        self.add("SetMenu", 2);
        self.add("SetMenuContextHelpId", 2);
        self.add("SetMenuDefaultItem", 3);
        self.add("SetMenuInfo", 2);
        self.add("SetMenuItemBitmaps", 5);
        self.add("SetMenuItemInfo", 4);
        self.add("SetMessageExtraInfo", 1);
        self.add("SetMetaFileBitsEx", 2);
        self.add("SetMetaRgn", 1);
        self.add("SetMiterLimit", 3);
        self.add("setmode", 2);
        self.add("SetMonitorBrightness", 2);
        self.add("SetMonitorColorTemperature", 2);
        self.add("SetMonitorContrast", 2);
        self.add("SetMonitorDisplayAreaPosition", 3);
        self.add("SetMonitorDisplayAreaSize", 3);
        self.add("SetMonitorRedGreenOrBlueDrive", 3);
        self.add("SetMonitorRedGreenOrBlueGain", 3);
        self.add("SetMouseWheelParameterInteractionContext", 3);
        self.add("SetNamedPipeHandleState", 4);
        self.add("SetNamedSecurityInfo", 7);
        self.add("SetNetScheduleAccountInformation", 3);
        self.add("?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z", 1);
        self.add("?_set_new_mode@@YAHH@Z", 1);
        self.add("SetOaNoCache", 0);
            self.add("SeTokenGetNoChildProcessRestricted", 4);
        self.add("SeTokenIsAdmin", 1);
            self.add("SeTokenIsNoChildProcessRestrictionEnforced", 2);
        self.add("SeTokenIsRestricted", 1);
            self.add("SeTokenSetNoChildProcessRestricted", 3);
        self.add("SeTokenType", 1);
        self.add("set_output_format", 1);
        self.add("SetPaletteEntries", 4);
        self.add("SetParent", 2);
        self.add("SetPartnerID", 1);
        self.add("SetPerTcp6ConnectionEStats", 6);
        self.add("SetPerTcpConnectionEStats", 6);
        self.add("SetPhysicalCursorPos", 2);
        self.add("SetPivotInteractionContext", 4);
        self.add("SetPixel", 4);
        self.add("SetPixelFormat", 3);
        self.add("SetPixelV", 4);
        self.add("SetPolyFillMode", 2);
        self.add("SetPort", 4);
        self.add("SetPrinter", 4);
        self.add("SetPrinterData", 5);
        self.add("SetPrinterDataEx", 6);
        self.add("set_printf_count_output", 1);
        self.add("SetPriorityClass", 2);
        self.add("SetPrivateObjectSecurity", 5);
        self.add("SetPrivateObjectSecurityEx", 6);
        self.add("SetProcessAffinityMask", 2);
        self.add("SetProcessAffinityUpdateMode", 2);
        self.add("SetProcessDefaultLayout", 1);
        self.add("SetProcessDEPPolicy", 1);
        self.add("SetProcessDPIAware", 0);
        self.add("SetProcessDPIAware", 1);
            self.add("SetProcessDynamicEnforcedCetCompatibleRanges", 3);
        self.add("SetProcessInformation", 4);
        self.add("SetProcessMitigationPolicy", 3);
        self.add("SetProcessPreferredUILanguages", 3);
        self.add("SetProcessPriorityBoost", 2);
        self.add("SetProcessReference", 1);
        self.add("SetProcessRestrictionExemption", 1);
        self.add("SetProcessShutdownParameters", 2);
        self.add("SetProcessWindowStation", 1);
        self.add("SetProcessWorkingSetSize", 3);
        self.add("SetProcessWorkingSetSizeEx", 4);
        self.add("SetProp", 3);
        self.add("SetPropA", 3);
        self.add("SetPropertyInteractionContext", 3);
        self.add("SetPropW", 3);
        self.add("SetProtectedPolicy", 3);
        self.add("set_purecall_handler", 1);
        self.add("SetRect", 5);
        self.add("SetRectEmpty", 1);
        self.add("SetRectRgn", 5);
        self.add("SetResourceManagerCompletionPort", 3);
        self.add("SetRestrictedErrorInfo", 1);
        self.add("SetROP2", 2);
        self.add("set_sbh_threshold", 1);
        self.add("SetScrollInfo", 4);
        self.add("SetScrollPos", 4);
        self.add("SetScrollRange", 5);
        self.add("SetSearchPathMode", 1);
        self.add("SetSecurityAccessMask", 2);
        self.add("SetSecurityDescriptorControl", 3);
        self.add("SetSecurityDescriptorDacl", 4);
        self.add("SetSecurityDescriptorGroup", 3);
        self.add("SetSecurityDescriptorOwner", 3);
        self.add("SetSecurityDescriptorRMControl", 2);
        self.add("SetSecurityDescriptorSacl", 4);
        self.add("SetSecurityInfo", 7);
        self.add("SetService", 6);
        self.add("SetServiceBits", 4);
        self.add("SetServiceObjectSecurity", 3);
        self.add("SetServiceStatus", 2);
        self.add("?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z", 1);
        self.add("setsockopt", 5);
        self.add("set_SSE2_enable", 1);
        self.add("SetStandardColorSpaceProfile", 3);
        self.add("SetStdHandle", 2);
        self.add("SetStdHandleEx", 3);
        self.add("SetStretchBltMode", 2);
        self.add("SetSuspendState", 3);
        self.add("SetSysColors", 3);
        self.add("SetSystemCursor", 2);
        self.add("SetSystemFileCacheSize", 3);
        self.add("SetSystemPaletteUse", 2);
        self.add("SetSystemPowerState", 2);
        self.add("SetSystemTime", 1);
        self.add("SetSystemTimeAdjustment", 2);
        self.add("setsystime", 2);
        self.add("SetTapeParameters", 3);
        self.add("SetTapePosition", 6);
        self.add("SetTcpEntry", 1);
        self.add("?set_terminate@@YAP6AXXZP6AXXZ@Z", 1);
        self.add("SetTextAlign", 2);
        self.add("SetTextCharacterExtra", 2);
        self.add("SetTextColor", 2);
        self.add("SetTextJustification", 3);
        self.add("SetThemeAppProperties", 1);
        self.add("SetThreadAffinityMask", 2);
        self.add("SetThreadContext", 2);
        self.add("SetThreadDescription", 2);
        self.add("SetThreadDesktop", 1);
        self.add("SetThreadErrorMode", 2);
        self.add("SetThreadExecutionState", 1);
        self.add("SetThreadGroupAffinity", 2);
        self.add("SetThreadIdealProcessor", 2);
        self.add("SetThreadIdealProcessorEx", 3);
        self.add("SetThreadInformation", 4);
        self.add("SetThreadLocale", 1);
        self.add("SetThreadpoolStackInformation", 2);
        self.add("SetThreadpoolThreadMaximum", 2);
        self.add("SetThreadpoolThreadMinimum", 2);
        self.add("SetThreadpoolTimer", 4);
        self.add("SetThreadpoolWait", 3);
        self.add("SetThreadPreferredUILanguages", 3);
        self.add("SetThreadPriority", 2);
        self.add("SetThreadPriorityBoost", 2);
        self.add("SetThreadStackGuarantee", 1);
        self.add("SetThreadToken", 2);
        self.add("SetThreadUILanguage", 1);
        self.add("SetTimer", 4);
        self.add("SetTimeZoneInformation", 1);
        self.add("SetTokenInformation", 4);
        self.add("SetTraceCallback", 2);
        self.add("SetTransactionInformation", 5);
        self.add("SetUmsThreadInformation", 4);
        self.add("?set_unexpected@@YAP6AXXZP6AXXZ@Z", 1);
        self.add("SetUnhandledExceptionFilter", 1);
        self.add("SetUnicastIpAddressEntry", 1);
        self.add("SetupAddInstallSectionToDiskSpaceList", 6);
        self.add("SetupAddSectionToDiskSpaceList", 7);
        self.add("SetupAddToDiskSpaceList", 6);
        self.add("SetupAddToSourceList", 2);
        self.add("SetupAdjustDiskSpaceList", 5);
        self.add("SetupBackupError", 6);
        self.add("SetupCancelTemporarySourceList", 0);
        self.add("SetupCloseFileQueue", 1);
        self.add("SetupCloseInfFile", 1);
        self.add("SetupCloseLog", 0);
        self.add("SetupColorMatching", 1);
        self.add("SetupComm", 3);
        self.add("SetupCommitFileQueue", 4);
        self.add("SetupConfigureWmiFromInfSection", 3);
        self.add("SetupCopyError", 11);
        self.add("SetupCopyOEMInf", 8);
        self.add("SetupCreateDiskSpaceList", 3);
        self.add("SetupDecompressOrCopyFile", 3);
        self.add("SetupDefaultQueueCallback", 4);
        self.add("SetupDeleteError", 5);
        self.add("SetupDestroyDiskSpaceList", 1);
        self.add("SetupDiAskForOEMDisk", 2);
        self.add("SetupDiBuildClassInfoList", 4);
        self.add("SetupDiBuildClassInfoListEx", 6);
        self.add("SetupDiBuildDriverInfoList", 3);
        self.add("SetupDiCallClassInstaller", 3);
        self.add("SetupDiCancelDriverInfoSearch", 1);
        self.add("SetupDiChangeState", 2);
        self.add("SetupDiClassGuidsFromName", 4);
        self.add("SetupDiClassGuidsFromNameEx", 6);
        self.add("SetupDiClassNameFromGuid", 4);
        self.add("SetupDiClassNameFromGuidEx", 6);
        self.add("SetupDiCreateDeviceInfo", 7);
        self.add("SetupDiCreateDeviceInfoList", 2);
        self.add("SetupDiCreateDeviceInfoListEx", 4);
        self.add("SetupDiCreateDeviceInterface", 6);
        self.add("SetupDiCreateDeviceInterfaceRegKey", 6);
        self.add("SetupDiCreateDevRegKey", 7);
        self.add("SetupDiDeleteDeviceInfo", 2);
        self.add("SetupDiDeleteDeviceInterfaceData", 2);
        self.add("SetupDiDeleteDeviceInterfaceRegKey", 3);
        self.add("SetupDiDeleteDevRegKey", 5);
        self.add("SetupDiDestroyClassImageList", 1);
        self.add("SetupDiDestroyDeviceInfoList", 1);
        self.add("SetupDiDestroyDriverInfoList", 3);
        self.add("SetupDiDrawMiniIcon", 4);
        self.add("SetupDiEnumDeviceInfo", 3);
        self.add("SetupDiEnumDeviceInterfaces", 5);
        self.add("SetupDiEnumDriverInfo", 5);
        self.add("SetupDiFinishInstallAction", 2);
        self.add("SetupDiGetActualModelsSection", 6);
        self.add("SetupDiGetActualSectionToInstall", 6);
        self.add("SetupDiGetActualSectionToInstallEx", 8);
        self.add("SetupDiGetClassBitmapIndex", 2);
        self.add("SetupDiGetClassDescription", 4);
        self.add("SetupDiGetClassDescriptionEx", 6);
        self.add("SetupDiGetClassDevPropertySheets", 6);
        self.add("SetupDiGetClassDevs", 4);
        self.add("SetupDiGetClassDevsEx", 7);
        self.add("SetupDiGetClassImageIndex", 3);
        self.add("SetupDiGetClassImageList", 1);
        self.add("SetupDiGetClassImageListEx", 3);
        self.add("SetupDiGetClassInstallParams", 5);
        self.add("SetupDiGetClassPropertyExW", 9);
        self.add("SetupDiGetClassPropertyKeys", 5);
        self.add("SetupDiGetClassPropertyKeysExW", 7);
        self.add("SetupDiGetClassPropertyW", 7);
        self.add("SetupDiGetClassRegistryProperty", 8);
        self.add("SetupDiGetCustomDeviceProperty", 8);
        self.add("SetupDiGetDeviceInfoListClass", 2);
        self.add("SetupDiGetDeviceInfoListDetail", 2);
        self.add("SetupDiGetDeviceInstallParams", 3);
        self.add("SetupDiGetDeviceInstanceId", 5);
        self.add("SetupDiGetDeviceInterfaceAlias", 4);
        self.add("SetupDiGetDeviceInterfaceDetail", 6);
        self.add("SetupDiGetDeviceInterfacePropertyKeys", 6);
        self.add("SetupDiGetDeviceInterfacePropertyW", 8);
        self.add("SetupDiGetDevicePropertyKeys", 6);
        self.add("SetupDiGetDevicePropertyW", 8);
        self.add("SetupDiGetDeviceRegistryProperty", 7);
        self.add("SetupDiGetDriverInfoDetail", 6);
        self.add("SetupDiGetDriverInstallParams", 4);
        self.add("SetupDiGetHwProfileFriendlyName", 4);
        self.add("SetupDiGetHwProfileFriendlyNameEx", 6);
        self.add("SetupDiGetHwProfileList", 4);
        self.add("SetupDiGetHwProfileListEx", 6);
        self.add("SetupDiGetINFClass", 5);
        self.add("SetupDiGetSelectedDevice", 2);
        self.add("SetupDiGetSelectedDriver", 3);
        self.add("SetupDiGetWizardPage", 5);
        self.add("SetupDiInstallClass", 4);
        self.add("SetupDiInstallClassEx", 7);
        self.add("SetupDiInstallDevice", 2);
        self.add("SetupDiInstallDeviceInterfaces", 2);
        self.add("SetupDiInstallDriverFiles", 2);
        self.add("SetupDiLoadClassIcon", 3);
        self.add("SetupDiLoadDeviceIcon", 6);
        self.add("SetupDiMoveDuplicateDevice", 2);
        self.add("SetupDiOpenClassRegKey", 2);
        self.add("SetupDiOpenClassRegKeyEx", 5);
        self.add("SetupDiOpenDeviceInfo", 5);
        self.add("SetupDiOpenDeviceInterface", 4);
        self.add("SetupDiOpenDeviceInterfaceRegKey", 4);
        self.add("SetupDiOpenDevRegKey", 6);
        self.add("SetupDiRegisterCoDeviceInstallers", 2);
        self.add("SetupDiRegisterDeviceInfo", 6);
        self.add("SetupDiRemoveDevice", 2);
        self.add("SetupDiRemoveDeviceInterface", 2);
        self.add("SetupDiRestartDevices", 2);
        self.add("SetupDiSelectBestCompatDrv", 2);
        self.add("SetupDiSelectDevice", 2);
        self.add("SetupDiSelectOEMDrv", 3);
        self.add("SetupDiSetClassInstallParams", 4);
        self.add("SetupDiSetClassPropertyExW", 7);
        self.add("SetupDiSetClassPropertyW", 6);
        self.add("SetupDiSetClassRegistryProperty", 6);
        self.add("SetupDiSetDeviceInstallParams", 3);
        self.add("SetupDiSetDeviceInterfaceDefault", 4);
        self.add("SetupDiSetDeviceInterfacePropertyW", 7);
        self.add("SetupDiSetDevicePropertyW", 7);
        self.add("SetupDiSetDeviceRegistryProperty", 5);
        self.add("SetupDiSetDriverInstallParams", 4);
        self.add("SetupDiSetSelectedDevice", 2);
        self.add("SetupDiSetSelectedDriver", 3);
        self.add("SetupDiUnremoveDevice", 2);
        self.add("SetupDuplicateDiskSpaceList", 4);
        self.add("SetupEnumInfSections", 5);
        self.add("SetupFindFirstLine", 4);
        self.add("SetupFindNextLine", 2);
        self.add("SetupFindNextMatchLine", 3);
        self.add("SetupFreeSourceList", 2);
        self.add("SetupGetBinaryField", 5);
        self.add("SetupGetFieldCount", 1);
        self.add("SetupGetFileCompressionInfo", 5);
        self.add("SetupGetFileCompressionInfoEx", 7);
        self.add("SetupGetFileQueueCount", 3);
        self.add("SetupGetFileQueueFlags", 2);
        self.add("SetupGetInfDriverStoreLocation", 6);
        self.add("SetupGetInfFileList", 5);
        self.add("SetupGetInfInformation", 5);
        self.add("SetupGetInfPublishedName", 4);
        self.add("SetupGetIntField", 3);
        self.add("SetupGetLineByIndex", 4);
        self.add("SetupGetLineCount", 2);
        self.add("SetupGetLineText", 7);
        self.add("SetupGetMultiSzField", 5);
        self.add("SetupGetNonInteractiveMode", 0);
        self.add("SetupGetSourceFileLocation", 7);
        self.add("SetupGetSourceFileSize", 6);
        self.add("SetupGetSourceInfo", 6);
        self.add("SetupGetStringField", 5);
        self.add("SetupGetTargetPath", 6);
        self.add("SetupGetThreadLogToken", 0);
        self.add("SetupInitDefaultQueueCallback", 1);
        self.add("SetupInitDefaultQueueCallbackEx", 5);
        self.add("SetupInitializeFileLog", 2);
        self.add("SetupInstallFile", 8);
        self.add("SetupInstallFileEx", 9);
        self.add("SetupInstallFilesFromInfSection", 6);
        self.add("SetupInstallFromInfSection", 11);
        self.add("SetupInstallServicesFromInfSection", 3);
        self.add("SetupInstallServicesFromInfSectionEx", 7);
        self.add("SetupIterateCabinet", 4);
        self.add("SetupLogError", 2);
        self.add("SetupLogFile", 9);
        self.add("SetupOpenAppendInfFile", 3);
        self.add("SetupOpenFileQueue", 0);
        self.add("SetupOpenInfFile", 4);
        self.add("SetupOpenLog", 1);
        self.add("SetupOpenMasterInf", 0);
        self.add("SetupPersistentIScsiDevices", 0);
        self.add("SetupPromptForDisk", 10);
        self.add("SetupPromptReboot", 3);
        self.add("SetupQueryDrivesInDiskSpaceList", 4);
        self.add("SetupQueryFileLog", 7);
        self.add("SetupQueryInfFileInformation", 5);
        self.add("SetupQueryInfOriginalFileInformation", 4);
        self.add("SetupQueryInfVersionInformation", 6);
        self.add("SetupQuerySourceList", 3);
        self.add("SetupQuerySpaceRequiredOnDrive", 5);
        self.add("SetupQueueCopy", 9);
        self.add("SetupQueueCopyIndirect", 1);
        self.add("SetupQueueCopySection", 6);
        self.add("SetupQueueDefaultCopy", 6);
        self.add("SetupQueueDelete", 3);
        self.add("SetupQueueDeleteSection", 4);
        self.add("SetupQueueRename", 5);
        self.add("SetupQueueRenameSection", 4);
        self.add("SetupRemoveFileLogEntry", 3);
        self.add("SetupRemoveFromDiskSpaceList", 5);
        self.add("SetupRemoveFromSourceList", 2);
        self.add("SetupRemoveInstallSectionFromDiskSpaceList", 6);
        self.add("SetupRemoveSectionFromDiskSpaceList", 7);
        self.add("SetupRenameError", 6);
        self.add("SetupScanFileQueue", 6);
        self.add("SetupSetDirectoryId", 3);
        self.add("SetupSetDirectoryIdEx", 6);
        self.add("SetupSetFileQueueAlternatePlatform", 3);
        self.add("SetupSetFileQueueFlags", 3);
        self.add("SetupSetNonInteractiveMode", 1);
        self.add("SetupSetPlatformPathOverride", 1);
        self.add("SetupSetSourceList", 3);
        self.add("SetupSetThreadLogToken", 1);
        self.add("SetupTermDefaultQueueCallback", 1);
        self.add("SetupTerminateFileLog", 1);
        self.add("SetupUninstallNewlyCopiedInfs", 3);
        self.add("SetupUninstallOEMInf", 3);
        self.add("SetupVerifyInfFile", 3);
        self.add("SetupWriteTextLog", 4);
        self.add("SetupWriteTextLogError", 5);
        self.add("SetupWriteTextLogInfLine", 4);
        self.add("SetUrlCacheConfigInfo", 2);
        self.add("SetUrlCacheEntryGroup", 6);
        self.add("SetUrlCacheEntryGroupA", 6);
        self.add("SetUrlCacheEntryGroupW", 6);
        self.add("SetUrlCacheEntryInfo", 3);
        self.add("SetUrlCacheEntryInfoA", 3);
        self.add("SetUrlCacheEntryInfoW", 3);
        self.add("SetUrlCacheGroupAttribute", 5);
        self.add("SetUrlCacheGroupAttributeA", 5);
        self.add("SetUrlCacheGroupAttributeW", 5);
        self.add("SetUrlCacheHeaderData", 2);
        self.add("SetUserFileEncryptionKey", 1);
        self.add("SetUserGeoID", 1);
        self.add("setusermatherr", 1);
        self.add("SetUserObjectInformation", 4);
        self.add("SetUserObjectSecurity", 3);
        self.add("SetVarConversionLocaleSetting", 1);
        self.add("setvbuf", 4);
        self.add("SetVCPFeature", 3);
        self.add("SetViewportExtEx", 4);
        self.add("SetViewportOrgEx", 4);
        self.add("SetVirtualDiskInformation", 2);
        self.add("SetVirtualDiskMetadata", 4);
        self.add("SetVolumeLabel", 2);
        self.add("SetVolumeMountPoint", 2);
        self.add("SetWaitableTimer", 6);
        self.add("SetWaitableTimerEx", 7);
        self.add("SetWindowCompositionAttribute", 2);
        self.add("SetWindowContextHelpId", 2);
        self.add("SetWindowDisplayAffinity", 2);
        self.add("SetWindowExtEx", 4);
        self.add("SetWindowFeedbackSetting", 5);
        self.add("SetWindowLong", 3);
        self.add("SetWindowLongA", 3);
        self.add("SetWindowLongPtrA", 3);
        self.add("SetWindowLongPtrW", 3);
        self.add("SetWindowLongW", 3);
        self.add("SetWindowOrgEx", 4);
        self.add("SetWindowPlacement", 2);
        self.add("SetWindowPos", 7);
        self.add("SetWindowRgn", 3);
        self.add("SetWindowsHookEx", 4);
        self.add("SetWindowsHookExA", 4);
        self.add("SetWindowsHookExW", 4);
        self.add("SetWindowSubclass", 4);
        self.add("SetWindowText", 2);
        self.add("SetWindowTextA", 2);
        self.add("SetWindowTextW", 2);
        self.add("SetWindowTheme", 3);
        self.add("SetWindowThemeAttribute", 4);
        self.add("SetWinEventHook", 7);
        self.add("SetWinMetaFileBits", 4);
        self.add("SetWorldTransform", 2);
        self.add("SetXStateFeaturesMask", 2);
        self.add("SeUnlockSubjectContext", 1);
            self.add("SeUnregisterLogonSessionTerminatedRoutine", 1);
        self.add("SeValidSecurityDescriptor", 2);
        self.add("SfcFileException", 3);
        self.add("SfcGetFiles", 2);
        self.add("SfcGetNextProtectedFile", 2);
        self.add("SfcIsFileProtected", 2);
        self.add("SfcIsKeyProtected", 3);
        self.add("SfcTerminateWatcherThread", 0);
        self.add("SfpVerifyFile", 3);
        self.add("SHAddDefaultPropertiesByExt", 2);
        self.add("SHAddFromPropSheetExtArray", 3);
        self.add("SHAddToRecentDocs", 2);
        self.add("SHAlloc", 1);
        self.add("SHAllocShared", 3);
        self.add("SHAnsiToAnsi", 3);
        self.add("SHAnsiToUnicode", 3);
        self.add("SHAnsiToUnicodeCPAlloc", 3);
        self.add("SHAppBarMessage", 2);
        self.add("SHAreIconsEqual", 2);
        self.add("SHAssocEnumHandlers", 3);
        self.add("SHAssocEnumHandlersForProtocolByApplication", 3);
        self.add("SHAutoComplete", 2);
        self.add("SHBindToFolderIDListParent", 5);
        self.add("SHBindToObject", 5);
        self.add("SHBindToParent", 4);
        self.add("SHBoolSystemParametersInfo", 2);
        self.add("SHBrowseForFolder", 1);
        self.add("SHChangeNotification_Lock", 4);
        self.add("SHChangeNotification_Unlock", 1);
        self.add("SHChangeNotify", 4);
        self.add("SHChangeNotifyDeregister", 1);
        self.add("SHChangeNotifyRegister", 6);
        self.add("SHChangeNotifyRegisterThread", 1);
        self.add("SHCloneSpecialIDList", 3);
        self.add("SHCLSIDFromString", 2);
        self.add("SHCoCreateInstance", 5);
        self.add("SHCopyKey", 4);
        self.add("SHCopyKeyA", 4);
        self.add("SHCopyKeyW", 4);
        self.add("SHCreateAssociationRegistration", 2);
        self.add("SHCreateDataObject", 6);
        self.add("SHCreateDefaultContextMenu", 3);
        self.add("SHCreateDefaultExtractIcon", 2);
        self.add("SHCreateDefaultPropertiesOp", 2);
        self.add("SHCreateDirectory", 2);
        self.add("SHCreateDirectoryEx", 3);
        self.add("SHCreateFileExtractIconW", 4);
        self.add("SHCreateItemFromIDList", 3);
        self.add("SHCreateItemFromParsingName", 4);
        self.add("SHCreateItemFromRelativeName", 5);
        self.add("SHCreateItemInKnownFolder", 5);
        self.add("SHCreateItemWithParent", 5);
        self.add("SHCreateMemStream", 2);
        self.add("SHCreateProcessAsUserW", 1);
        self.add("SHCreatePropertyBagOnMemory", 3);
        self.add("SHCreatePropertyStoreOnXML", 5);
        self.add("SHCreatePropSheetExtArray", 3);
        self.add("SHCreateQueryCancelAutoPlayMoniker", 1);
        self.add("SHCreateShellFolderView", 2);
        self.add("SHCreateShellFolderViewEx", 2);
        self.add("SHCreateShellItem", 4);
        self.add("SHCreateShellItemArray", 5);
        self.add("SHCreateShellItemArrayFromDataObject", 3);
        self.add("SHCreateShellItemArrayFromIDLists", 3);
        self.add("SHCreateShellItemArrayFromShellItem", 3);
        self.add("SHCreateShellPalette", 1);
        self.add("SHCreateStdEnumFmtEtc", 3);
        self.add("SHCreateStreamOnDllResourceW", 4);
        self.add("SHCreateStreamOnFile", 3);
        self.add("SHCreateStreamOnFileA", 3);
        self.add("SHCreateStreamOnFileEx", 6);
        self.add("SHCreateStreamOnFileW", 3);
        self.add("SHCreateStreamOnModuleResourceW", 4);
        self.add("SHCreateThread", 4);
        self.add("SHCreateThreadRef", 2);
        self.add("SHCreateThreadWithHandle", 5);
        self.add("SHDefExtractIcon", 6);
        self.add("SHDeleteEmptyKey", 2);
        self.add("SHDeleteEmptyKeyA", 2);
        self.add("SHDeleteEmptyKeyW", 2);
        self.add("SHDeleteKey", 2);
        self.add("SHDeleteKeyA", 2);
        self.add("SHDeleteKeyW", 2);
        self.add("SHDeleteValue", 3);
        self.add("SHDeleteValueA", 3);
        self.add("SHDeleteValueW", 3);
        self.add("SHDestroyPropSheetExtArray", 1);
        self.add("SHDoDragDrop", 5);
        self.add("ShellAbout", 4);
        self.add("ShellAboutA", 4);
        self.add("ShellAboutW", 4);
        self.add("ShellDDEInit", 1);
        self.add("ShellExecCmdLine", 6);
        self.add("ShellExecute", 6);
        self.add("ShellExecuteA", 6);
        self.add("ShellExecuteEx", 1);
        self.add("ShellExecuteExA", 1);
        self.add("ShellExecuteExW", 1);
        self.add("ShellExecuteW", 6);
        self.add("Shell_GetCachedImageIndex", 3);
        self.add("Shell_GetImageLists", 2);
        self.add("Shell_MergeMenus", 6);
        self.add("ShellMessageBox", 5);
        self.add("ShellMessageBoxA", 6);
        self.add("ShellMessageBoxW", 6);
        self.add("Shell_NotifyIcon", 2);
        self.add("Shell_NotifyIconA", 2);
        self.add("Shell_NotifyIconGetRect", 2);
        self.add("Shell_NotifyIconW", 2);
        self.add("SHEmptyRecycleBin", 3);
        self.add("SHEmptyRecycleBinA", 3);
        self.add("SHEmptyRecycleBinW", 3);
        self.add("SHEnumerateUnreadMailAccountsA", 4);
        self.add("SHEnumerateUnreadMailAccountsW", 4);
        self.add("SHEnumKeyEx", 4);
        self.add("SHEnumKeyExA", 4);
        self.add("SHEnumKeyExW", 4);
        self.add("SHEnumValue", 7);
        self.add("SHEnumValueA", 7);
        self.add("SHEnumValueW", 7);
        self.add("SHEvaluateSystemCommandTemplate", 4);
        self.add("SHExpandEnvironmentStringsAlloc", 2);
        self.add("SHExtractIconsW", 8);
        self.add("SHFileOperation", 1);
        self.add("SHFileOperationA", 1);
        self.add("SHFileOperationW", 1);
        self.add("SHFindFiles", 2);
        self.add("SHFind_InitMenuPopup", 4);
        self.add("SHFlushClipboard", 0);
        self.add("SHFlushSFCache", 0);
        self.add("SHFormatDateTime", 4);
        self.add("SHFormatDateTimeA", 4);
        self.add("SHFormatDateTimeW", 4);
        self.add("SHFormatDrive", 4);
        self.add("SHForwardContextMenuMsg", 6);
        self.add("SHFree", 1);
        self.add("SHFreeNameMappings", 1);
        self.add("SHFreeShared", 2);
        self.add("SHGetAssocKeys", 3);
        self.add("SHGetAttributesFromDataObject", 4);
        self.add("SHGetDataFromIDList", 5);
        self.add("SHGetDesktopFolder", 1);
        self.add("SHGetDiskFreeSpace", 4);
        self.add("SHGetDiskFreeSpaceEx", 4);
        self.add("SHGetDiskFreeSpaceExA", 4);
        self.add("SHGetDiskFreeSpaceExW", 4);
        self.add("SHGetDriveMedia", 2);
        self.add("SHGetFileInfo", 5);
        self.add("SHGetFileInfoA", 5);
        self.add("SHGetFileInfoW", 5);
        self.add("SHGetFolderLocation", 5);
        self.add("SHGetFolderPath", 5);
        self.add("SHGetFolderPathAndSubDir", 6);
        self.add("SHGetIconOverlayIndex", 2);
        self.add("SHGetIDListFromObject", 2);
        self.add("SHGetImageList", 3);
        self.add("SHGetInstanceExplorer", 1);
        self.add("SHGetInverseCMAP", 2);
        self.add("SHGetItemFromDataObject", 4);
        self.add("SHGetItemFromObject", 3);
        self.add("SHGetKnownFolderIDList", 4);
        self.add("SHGetKnownFolderItem", 5);
        self.add("SHGetKnownFolderPath", 4);
        self.add("SHGetLocalizedName", 4);
        self.add("SHGetMalloc", 1);
        self.add("SHGetNameFromIDList", 3);
        self.add("SHGetNameFromPropertyKey", 2);
        self.add("SHGetNewLinkInfo", 5);
        self.add("SHGetNewLinkInfoA", 5);
        self.add("SHGetNewLinkInfoW", 5);
        self.add("SHGetPathFromIDList", 2);
        self.add("SHGetPathFromIDListEx", 4);
        self.add("SHGetPropertyStoreForWindow", 3);
        self.add("SHGetPropertyStoreFromIDList", 4);
        self.add("SHGetPropertyStoreFromParsingName", 5);
        self.add("SHGetRealIDL", 3);
        self.add("SHGetSetFolderCustomSettings", 3);
        self.add("SHGetSetSettings", 3);
        self.add("SHGetSettings", 2);
        self.add("SHGetShellStyleHInstance", 0);
        self.add("SHGetSizeShared", 1);
        self.add("SHGetSpecialFolderLocation", 3);
        self.add("SHGetSpecialFolderPath", 4);
        self.add("SHGetStockIconInfo", 3);
        self.add("SHGetTemporaryPropertyForItem", 3);
        self.add("SHGetThreadRef", 1);
        self.add("SHGetUnreadMailCountA", 6);
        self.add("SHGetUnreadMailCountW", 6);
        self.add("SHGetUserDisplayName", 2);
        self.add("SHGetUserPicturePathEx", 7);
        self.add("SHGetValue", 6);
        self.add("SHGetValueA", 6);
        self.add("SHGetValueW", 6);
        self.add("SHGetViewStatePropertyBag", 5);
        self.add("SHGlobalCounterDecrement", 1);
        self.add("SHGlobalCounterGetValue", 1);
        self.add("SHGlobalCounterIncrement", 1);
        self.add("SHHandleUpdateImage", 1);
        self.add("SHHelpShortcuts_RunDLL", 4);
        self.add("SHILCreateFromPath", 3);
        self.add("SHInvokeCommandOnContextMenu", 6);
        self.add("SHInvokeCommandOnContextMenuEx", 7);
        self.add("SHInvokeCommandsOnContextMenuEx", 8);
        self.add("SHInvokeCommandWithFlagsAndSite", 6);
        self.add("SHInvokePrinterCommand", 5);
        self.add("SHInvokePrinterCommandA", 5);
        self.add("SHInvokePrinterCommandW", 5);
        self.add("SHIsChildOrSelf", 2);
        self.add("SHIsFileAvailableOffline", 2);
        self.add("SHIsLowMemoryMachine", 1);
        self.add("SHLimitInputEdit", 2);
        self.add("SHLoadIndirectString", 4);
        self.add("SHLoadInProc", 1);
        self.add("SHLoadNonloadedIconOverlayIdentifiers", 0);
            self.add("SHLoadNonloadedIconOverlayIdentifiers", 1);
        self.add("SHLoadOLE", 1);
        self.add("SHLocalStrDup", 2);
        self.add("SHLocalStrDupA", 2);
        self.add("SHLocalStrDupW", 2);
        self.add("SHLockShared", 2);
        self.add("SHMapIDListToImageListIndexAsync", 9);
        self.add("SHMapPIDLToSystemImageListIndex", 3);
        self.add("SHMessageBoxCheck", 6);
        self.add("SHMessageBoxCheckA", 6);
        self.add("SHMessageBoxCheckW", 6);
        self.add("SHMultiFileProperties", 2);
        self.add("SHObjectProperties", 4);
        self.add("SHOpenFolderAndSelectItems", 4);
        self.add("SHOpenPropSheetW", 7);
        self.add("SHOpenRegStream2", 4);
        self.add("SHOpenRegStream2A", 4);
        self.add("SHOpenRegStream2W", 4);
        self.add("SHOpenRegStream", 4);
        self.add("SHOpenRegStreamA", 4);
        self.add("SHOpenRegStreamW", 4);
        self.add("SHOpenWithDialog", 2);
        self.add("ShortSizeFormatExportW", 2);
        self.add("ShouldBlockRevert", 2);
        self.add("ShouldBlockRevertInternal", 2);
        self.add("ShowCaret", 1);
        self.add("ShowClientAuthCerts", 1);
        self.add("ShowConsoleCursor", 2);
        self.add("ShowCursor", 1);
        self.add("ShowHideMenuCtl", 3);
        self.add("ShowOwnedPopups", 2);
        self.add("ShowScrollBar", 3);
        self.add("ShowSecurityInfo", 2);
        self.add("ShowShareFolderUI", 2);
        self.add("ShowWindow", 2);
        self.add("ShowWindowAsync", 2);
        self.add("ShowX509EncodedCertificate", 3);
        self.add("SHParseDisplayName", 5);
        self.add("SHPathPrepareForWrite", 4);
        self.add("SHPropStgCreate", 8);
        self.add("SHPropStgReadMultiple", 5);
        self.add("SHPropStgWriteMultiple", 6);
        self.add("SHQueryInfoKey", 5);
        self.add("SHQueryInfoKeyA", 5);
        self.add("SHQueryInfoKeyW", 5);
        self.add("SHQueryRecycleBin", 2);
        self.add("SHQueryRecycleBinA", 2);
        self.add("SHQueryRecycleBinW", 2);
        self.add("SHQueryUserNotificationState", 1);
        self.add("SHQueryValueEx", 6);
        self.add("SHQueryValueExA", 6);
        self.add("SHQueryValueExW", 6);
        self.add("SHRegCloseUSKey", 1);
        self.add("SHRegCreateUSKey", 5);
        self.add("SHRegCreateUSKeyA", 5);
        self.add("SHRegCreateUSKeyW", 5);
        self.add("SHRegDeleteEmptyUSKey", 3);
        self.add("SHRegDeleteEmptyUSKeyA", 3);
        self.add("SHRegDeleteEmptyUSKeyW", 3);
        self.add("SHRegDeleteUSValue", 3);
        self.add("SHRegDeleteUSValueA", 3);
        self.add("SHRegDeleteUSValueW", 3);
        self.add("SHRegDuplicateHKey", 1);
        self.add("SHRegEnumUSKey", 5);
        self.add("SHRegEnumUSKeyA", 5);
        self.add("SHRegEnumUSKeyW", 5);
        self.add("SHRegEnumUSValue", 8);
        self.add("SHRegEnumUSValueA", 8);
        self.add("SHRegEnumUSValueW", 8);
        self.add("SHRegGetBoolUSValue", 4);
        self.add("SHRegGetBoolUSValueA", 4);
        self.add("SHRegGetBoolUSValueW", 4);
        self.add("SHRegGetBoolValueFromHKCUHKLM", 3);
        self.add("SHRegGetIntW", 3);
        self.add("SHRegGetPath", 5);
        self.add("SHRegGetPathA", 5);
        self.add("SHRegGetPathW", 5);
        self.add("SHRegGetUSValue", 8);
        self.add("SHRegGetUSValueA", 8);
        self.add("SHRegGetUSValueW", 8);
        self.add("SHRegGetValue", 7);
        self.add("SHRegGetValueA", 7);
        self.add("SHRegGetValueFromHKCUHKLM", 6);
        self.add("SHRegGetValueW", 7);
        self.add("SHRegOpenUSKey", 5);
        self.add("SHRegOpenUSKeyA", 5);
        self.add("SHRegOpenUSKeyW", 5);
        self.add("SHRegQueryInfoUSKey", 6);
        self.add("SHRegQueryInfoUSKeyA", 6);
        self.add("SHRegQueryInfoUSKeyW", 6);
        self.add("SHRegQueryUSValue", 8);
        self.add("SHRegQueryUSValueA", 8);
        self.add("SHRegQueryUSValueW", 8);
        self.add("SHRegSetPath", 5);
        self.add("SHRegSetPathA", 5);
        self.add("SHRegSetPathW", 5);
        self.add("SHRegSetUSValue", 6);
        self.add("SHRegSetUSValueA", 6);
        self.add("SHRegSetUSValueW", 6);
        self.add("SHRegSetValue", 7);
        self.add("SHRegWriteUSValue", 6);
        self.add("SHRegWriteUSValueA", 6);
        self.add("SHRegWriteUSValueW", 6);
        self.add("SHReleaseThreadRef", 0);
        self.add("SHReleaseThreadRef", 1);
        self.add("SHRemoveLocalizedName", 1);
        self.add("SHReplaceFromPropSheetExtArray", 4);
        self.add("SHResolveLibrary", 1);
        self.add("SHResolveUserNames", 3);
        self.add("SHRestricted", 1);
        self.add("SHRunControlPanel", 2);
        self.add("SHRunIndirectRegClientCommand", 2);
        self.add("SHSendMessageBroadcast", 3);
        self.add("SHSendMessageBroadcastA", 3);
        self.add("SHSendMessageBroadcastW", 3);
        self.add("SHSetDefaultProperties", 4);
        self.add("SHSetFolderPath", 4);
        self.add("SHSetInstanceExplorer", 1);
        self.add("SHSetKnownFolderPath", 4);
        self.add("SHSetLocalizedName", 3);
        self.add("SHSetTemporaryPropertyForItem", 3);
        self.add("SHSetThreadRef", 1);
        self.add("SHSettingsChanged", 2);
        self.add("SHSetUnreadMailCountA", 3);
        self.add("SHSetUnreadMailCountW", 3);
        self.add("SHSetValue", 6);
        self.add("SHSetValueA", 6);
        self.add("SHSetValueW", 6);
        self.add("SHShellFolderView_Message", 3);
        self.add("SHShouldShowWizards", 1);
        self.add("SHShowManageLibraryUI", 5);
        self.add("SHSimpleIDListFromPath", 1);
        self.add("SHSkipJunction", 2);
        self.add("SHStartNetConnectionDialogW", 3);
        self.add("SHStrDup", 2);
        self.add("SHStrDupA", 2);
        self.add("SHStrDupW", 2);
        self.add("SHStripMneumonic", 1);
        self.add("SHStripMneumonicA", 1);
        self.add("SHStripMneumonicW", 1);
        self.add("SHTestTokenMembership", 2);
        self.add("SHTestTokenPrivilegeW", 2);
        self.add("SHUnicodeToAnsi", 3);
        self.add("SHUnicodeToAnsiCPAlloc", 3);
        self.add("SHUnicodeToUnicode", 3);
        self.add("SHUnlockShared", 1);
        self.add("SHUpdateImage", 4);
        self.add("SHUserGetPasswordHint", 2);
        self.add("SHUserSetPasswordHint", 2);
        self.add("shutdown", 2);
        self.add("ShutdownBlockReasonCreate", 2);
        self.add("ShutdownBlockReasonDestroy", 1);
        self.add("ShutdownBlockReasonQuery", 3);
        self.add("SHValidateUNC", 3);
        self.add("signal", 2);
        self.add("SignalFileOpen", 1);
        self.add("SignalObjectAndWait", 4);
        self.add("SignerFreeSignerContext", 1);
        self.add("SignError", 0);
        self.add("SignerSign", 7);
        self.add("SignerSignEx2", 13);
        self.add("SignerSignEx", 9);
        self.add("SignerTimeStamp", 4);
        self.add("SignerTimeStampEx2", 7);
        self.add("SignerTimeStampEx", 6);
        self.add("sin", 1);
        self.add("sinf", 1);
        self.add("SinglePhaseReject", 2);
        self.add("sinh", 1);
        self.add("sinhf", 1);
        self.add("SisCreateBackupStructure", 5);
        self.add("SisCreateRestoreStructure", 5);
        self.add("SisCSFilesToBackupForLink", 7);
        self.add("SisFreeAllocatedMemory", 1);
        self.add("SisFreeBackupStructure", 1);
        self.add("SisFreeRestoreStructure", 1);
        self.add("SisRestoredLink", 6);
        self.add("SizeofResource", 2);
        self.add("SkipPointerFrameMessages", 1);
        self.add("SLAcquireGenuineTicket", 5);
        self.add("SLActivateProduct", 7);
        self.add("SLClose", 1);
        self.add("SLConsumeRight", 5);
        self.add("SLDepositMigrationBlob", 1);
        self.add("SLDepositOfflineConfirmationId", 4);
        self.add("SLDepositOfflineConfirmationIdEx", 5);
        self.add("sleep", 1);
        self.add("Sleep", 1);
        self.add("SleepConditionVariableCS", 3);
        self.add("SleepConditionVariableSRW", 4);
        self.add("SleepEx", 2);
        self.add("SLFireEvent", 3);
        self.add("SLGatherMigrationBlob", 3);
        self.add("SLGenerateOfflineInstallationId", 3);
        self.add("SLGenerateOfflineInstallationIdEx", 4);
        self.add("SLGetApplicationInformation", 6);
        self.add("SLGetApplicationPolicy", 5);
        self.add("SLGetAuthenticationResult", 3);
        self.add("SLGetGenuineInformation", 5);
        self.add("SLGetGenuineInformationEx", 5);
        self.add("SLGetInstalledProductKeyIds", 4);
        self.add("SLGetInstalledSAMLicenseApplications", 2);
        self.add("SLGetLicense", 4);
        self.add("SLGetLicenseFileId", 4);
        self.add("SLGetLicenseInformation", 6);
        self.add("SLGetLicensingStatusInformation", 6);
        self.add("SLGetPKeyId", 6);
        self.add("SLGetPKeyInformation", 6);
        self.add("SLGetPolicyInformation", 5);
        self.add("SLGetPolicyInformationDWORD", 3);
        self.add("SLGetProductSkuInformation", 6);
        self.add("SLGetReferralInformation", 5);
        self.add("SLGetSAMLicense", 3);
        self.add("SLGetServerStatus", 5);
        self.add("SLGetServiceInformation", 5);
        self.add("SLGetSLIDList", 6);
        self.add("SLGetWindowsInformation", 4);
        self.add("SLGetWindowsInformationDWORD", 2);
        self.add("SLInstallLicense", 4);
        self.add("SLInstallProofOfPurchase", 6);
        self.add("SLInstallProofOfPurchaseEx", 8);
        self.add("SLInstallSAMLicense", 3);
        self.add("SLIsGenuineLocal", 3);
        self.add("SLIsGenuineLocalEx", 3);
        self.add("SLLoadApplicationPolicies", 4);
        self.add("SLOpen", 1);
        self.add("SLPersistApplicationPolicies", 3);
        self.add("SLPersistRTSPayloadOverride", 5);
        self.add("SLReArm", 4);
        self.add("SLRegisterEvent", 4);
        self.add("SLSetAuthenticationData", 3);
        self.add("SLSetCurrentProductKey", 3);
        self.add("SLSetGenuineInformation", 5);
        self.add("SLUninstallLicense", 2);
        self.add("SLUninstallProofOfPurchase", 2);
        self.add("SLUninstallSAMLicense", 1);
        self.add("SLUnloadApplicationPolicies", 2);
        self.add("SLUnregisterEvent", 4);
        self.add("sndPlaySound", 2);
        self.add("SnmpMgrClose", 1);
        self.add("SnmpMgrCtl", 7);
        self.add("SnmpMgrGetTrap", 6);
        self.add("SnmpMgrGetTrapEx", 8);
        self.add("SnmpMgrOidToStr", 2);
        self.add("SnmpMgrOpen", 4);
        self.add("SnmpMgrRequest", 5);
        self.add("SnmpMgrStrToOid", 2);
        self.add("SnmpMgrTrapListen", 1);
        self.add("SnmpSvcGetUptime", 0);
        self.add("SnmpSvcSetLogLevel", 1);
        self.add("SnmpSvcSetLogType", 1);
        self.add("SnmpUtilAsnAnyCpy", 2);
        self.add("SnmpUtilAsnAnyFree", 1);
        self.add("SnmpUtilDbgPrint", 2);
        self.add("SnmpUtilIdsToA", 2);
        self.add("SnmpUtilMemAlloc", 1);
        self.add("SnmpUtilMemFree", 1);
        self.add("SnmpUtilMemReAlloc", 2);
        self.add("SnmpUtilOctetsCmp", 2);
        self.add("SnmpUtilOctetsCpy", 2);
        self.add("SnmpUtilOctetsFree", 1);
        self.add("SnmpUtilOctetsNCmp", 3);
        self.add("SnmpUtilOidAppend", 2);
        self.add("SnmpUtilOidCmp", 2);
        self.add("SnmpUtilOidCpy", 2);
        self.add("SnmpUtilOidFree", 1);
        self.add("SnmpUtilOidNCmp", 3);
        self.add("SnmpUtilOidToA", 1);
        self.add("SnmpUtilPrintAsnAny", 1);
        self.add("SnmpUtilPrintOid", 1);
        self.add("SnmpUtilVarBindCpy", 2);
        self.add("SnmpUtilVarBindFree", 1);
        self.add("SnmpUtilVarBindListCpy", 2);
        self.add("SnmpUtilVarBindListFree", 1);
        self.add("snprintf", 3);
        self.add("snprintf_l", 4);
        self.add("snprintf_s", 4);
        self.add("snprintf_s_l", 5);
        self.add("snscanf", 3);
        self.add("snscanf_l", 4);
        self.add("snscanf_s", 3);
        self.add("snscanf_s_l", 4);
        self.add("snwprintf", 3);
        self.add("snwprintf_l", 4);
        self.add("snwprintf_s", 4);
        self.add("snwprintf_s_l", 5);
        self.add("snwscanf", 3);
        self.add("snwscanf_l", 4);
        self.add("snwscanf_s", 3);
        self.add("snwscanf_s_l", 4);
        self.add("socket", 3);
            self.add("SocketNotificationRetrieveEvents", 1);
        self.add("SoftwareUpdateMessageBox", 4);
        self.add("sopen", 4);
        self.add("sopen_s", 5);
        self.add("SoundSentry", 0);
        self.add("SoundSentry", 1);
        self.add("spawnl", 3);
        self.add("spawnle", 3);
        self.add("spawnlp", 3);
        self.add("spawnlpe", 3);
        self.add("spawnv", 3);
        self.add("spawnve", 4);
        self.add("spawnvp", 3);
        self.add("spawnvpe", 4);
        self.add("splitpath", 5);
        self.add("splitpath_s", 9);
        self.add("SplitSymbols", 4);
        self.add("sprintf", 2);
        self.add("sprintf_l", 3);
        self.add("sprintf_p", 3);
        self.add("sprintf_p_l", 4);
        self.add("sprintf_s", 3);
        self.add("sprintf_s_l", 4);
        self.add("SQLAllocConnect", 2);
        self.add("SQLAllocEnv", 1);
        self.add("SQLAllocHandle", 3);
        self.add("SQLAllocStmt", 2);
        self.add("SQLBindCol", 6);
        self.add("SQLBindParam", 8);
        self.add("SQLBindParameter", 10);
        self.add("SQLBrowseConnect", 6);
        self.add("SQLBulkOperations", 2);
        self.add("SQLCancel", 1);
        self.add("SQLCancelHandle", 2);
        self.add("SQLCloseCursor", 1);
        self.add("SQLColAttribute", 7);
        self.add("SQLColAttributes", 7);
        self.add("SQLColumnPrivileges", 9);
        self.add("SQLColumns", 9);
        self.add("SQLCompleteAsync", 3);
        self.add("SQLConfigDataSource", 4);
        self.add("SQLConfigDriver", 7);
        self.add("SQLConnect", 7);
        self.add("SQLCopyDesc", 2);
        self.add("SQLCreateDataSource", 2);
        self.add("SQLDataSources", 8);
        self.add("SQLDescribeCol", 9);
        self.add("SQLDescribeParam", 6);
        self.add("SQLDisconnect", 1);
        self.add("SQLDriverConnect", 8);
        self.add("SQLDrivers", 8);
        self.add("SQLEndTran", 3);
        self.add("SQLError", 8);
        self.add("SQLExecDirect", 3);
        self.add("SQLExecute", 1);
        self.add("SQLExtendedFetch", 5);
        self.add("SQLFetch", 1);
        self.add("SQLFetchScroll", 3);
        self.add("SQLForeignKeys", 13);
        self.add("SQLFreeConnect", 1);
        self.add("SQLFreeEnv", 1);
        self.add("SQLFreeHandle", 2);
        self.add("SQLFreeStmt", 2);
        self.add("SQLGetConfigMode", 1);
        self.add("SQLGetConnectAttr", 5);
        self.add("SQLGetConnectOption", 3);
        self.add("SQLGetCursorName", 4);
        self.add("SQLGetData", 6);
        self.add("SQLGetDescField", 6);
        self.add("SQLGetDescRec", 11);
        self.add("SQLGetDiagField", 7);
        self.add("SQLGetDiagRec", 8);
        self.add("SQLGetEnvAttr", 5);
        self.add("SQLGetFunctions", 3);
        self.add("SQLGetInfo", 5);
        self.add("SQLGetInstalledDrivers", 3);
        self.add("SQLGetPrivateProfileString", 6);
        self.add("SQLGetStmtAttr", 5);
        self.add("SQLGetStmtOption", 3);
        self.add("SQLGetTranslator", 8);
        self.add("SQLGetTypeInfo", 2);
        self.add("SQLInstallDriverEx", 7);
        self.add("SQLInstallDriverManager", 3);
        self.add("SQLInstallerError", 5);
        self.add("SQLInstallTranslator", 8);
        self.add("SQLInstallTranslatorEx", 7);
        self.add("SQLManageDataSources", 1);
        self.add("SQLMoreResults", 1);
        self.add("SQLNativeSql", 6);
        self.add("SQLNumParams", 2);
        self.add("SQLNumResultCols", 2);
        self.add("SQLParamData", 2);
        self.add("SQLParamOptions", 3);
        self.add("SQLPostInstallerError", 2);
        self.add("SQLPrepare", 3);
        self.add("SQLPrimaryKeys", 7);
        self.add("SQLProcedureColumns", 9);
        self.add("SQLProcedures", 7);
        self.add("SQLPutData", 3);
        self.add("SQLReadFileDSN", 6);
        self.add("SQLRemoveDriver", 3);
        self.add("SQLRemoveDriverManager", 1);
        self.add("SQLRemoveDSNFromIni", 1);
        self.add("SQLRemoveTranslator", 2);
        self.add("SQLRowCount", 2);
        self.add("SQLSetConfigMode", 1);
        self.add("SQLSetConnectAttr", 4);
        self.add("SQLSetConnectOption", 3);
        self.add("SQLSetCursorName", 3);
        self.add("SQLSetDescField", 5);
        self.add("SQLSetDescRec", 10);
        self.add("SQLSetEnvAttr", 4);
        self.add("SQLSetParam", 8);
        self.add("SQLSetPos", 4);
        self.add("SQLSetScrollOptions", 4);
        self.add("SQLSetStmtAttr", 4);
        self.add("SQLSetStmtOption", 3);
        self.add("SQLSpecialColumns", 10);
        self.add("SQLStatistics", 9);
        self.add("SQLTablePrivileges", 7);
        self.add("SQLTables", 9);
        self.add("SQLTransact", 3);
        self.add("SQLValidDSN", 1);
        self.add("SQLWriteDSNToIni", 2);
        self.add("SQLWriteFileDSN", 4);
        self.add("SQLWritePrivateProfileString", 4);
        self.add("sqrt", 1);
        self.add("sqrtf", 1);
        self.add("srand", 1);
        self.add("SRRemoveRestorePoint", 1);
        self.add("SRSetRestorePointA", 2);
        self.add("SRSetRestorePointInternal", 3);
        self.add("SRSetRestorePointW", 2);
        self.add("sscanf", 2);
        self.add("sscanf_l", 3);
        self.add("sscanf_s", 2);
        self.add("sscanf_s_l", 3);
        self.add("SSL_AuthCertificate", 4);
        self.add("SSL_AuthCertificateHook", 3);
        self.add("SSL_BadCertHook", 3);
        self.add("SslChangeNotify", 2);
        self.add("SSL_CipherPolicyGet", 2);
        self.add("SSL_CipherPolicySet", 2);
        self.add("SSL_CipherPrefGet", 3);
        self.add("SSL_CipherPrefGetDefault", 2);
        self.add("SSL_CipherPrefSet", 3);
        self.add("SSL_CipherPrefSetDefault", 2);
        self.add("SSL_ClearSessionCache", 0);
        self.add("SslComputeClientAuthHash", 8);
        self.add("SslComputeEapKeyBlock", 8);
        self.add("SslComputeFinishedHash", 6);
        self.add("SSL_ConfigMPServerSIDCache", 4);
        self.add("SSL_ConfigSecureServer", 4);
        self.add("SSL_ConfigServerSessionIDCache", 4);
        self.add("SslCrackCertificate", 4);
        self.add("SslCreateClientAuthHash", 6);
        self.add("SslCreateEphemeralKey", 9);
        self.add("SslCreateHandshakeHash", 5);
        self.add("SSL_DataPending", 1);
        self.add("SslDecrementProviderReferenceCount", 1);
        self.add("SslDecryptPacket", 9);
        self.add("SslEmptyCache", 2);
        self.add("SslEncryptPacket", 10);
        self.add("SslEnumCipherSuites", 5);
        self.add("SslEnumProtocolProviders", 3);
        self.add("SslExportKey", 7);
        self.add("SSL_ForceHandshake", 1);
        self.add("SslFreeBuffer", 1);
        self.add("SslFreeCertificate", 1);
        self.add("SslFreeObject", 2);
        self.add("SslGenerateMasterKey", 11);
        self.add("SslGenerateSessionKeys", 6);
        self.add("SslGetCipherSuitePRFHashAlgorithm", 6);
        self.add("SSL_GetClientAuthDataHook", 3);
        self.add("SslGetKeyProperty", 5);
        self.add("SslGetProviderProperty", 6);
        self.add("SslGetServerIdentity", 5);
        self.add("SSL_GetSessionID", 1);
        self.add("SSL_HandshakeCallback", 3);
        self.add("SslHashHandshake", 5);
        self.add("SSL_ImportFD", 2);
        self.add("SslImportKey", 6);
        self.add("SslImportMasterKey", 9);
        self.add("SslIncrementProviderReferenceCount", 1);
        self.add("SSL_InheritMPServerSIDCache", 1);
        self.add("SSL_InvalidateSession", 1);
        self.add("SslLookupCipherLengths", 7);
        self.add("SslLookupCipherSuiteInfo", 6);
        self.add("SslOpenPrivateKey", 4);
        self.add("SslOpenProvider", 3);
        self.add("SSL_OptionGet", 3);
        self.add("SSL_OptionGetDefault", 2);
        self.add("SSL_OptionSet", 3);
        self.add("SSL_OptionSetDefault", 2);
        self.add("SSL_PeerCertificate", 1);
        self.add("SSL_ReHandshake", 2);
        self.add("SSL_ResetHandshake", 2);
        self.add("SSL_RevealPinArg", 1);
        self.add("SSL_RevealURL", 1);
        self.add("SSL_SecurityStatus", 7);
        self.add("SSL_SetPKCS11PinArg", 2);
        self.add("SSL_SetSockPeerID", 2);
        self.add("SSL_SetURL", 2);
        self.add("SslSignHash", 8);
        self.add("SslVerifySignature", 7);
        self.add("SspiCompareAuthIdentities", 4);
        self.add("SspiCopyAuthIdentity", 2);
        self.add("SspiDecryptAuthIdentity", 1);
        self.add("SspiEncodeAuthIdentityAsStrings", 4);
        self.add("SspiEncodeStringsAsAuthIdentity", 4);
        self.add("SspiEncryptAuthIdentity", 1);
        self.add("SspiExcludePackage", 3);
        self.add("SspiFreeAuthIdentity", 1);
        self.add("SspiGetCredUIContext", 5);
        self.add("SspiGetTargetHostName", 2);
        self.add("SspiIsAuthIdentityEncrypted", 1);
        self.add("SspiIsPromptingNeeded", 1);
        self.add("SspiLocalFree", 1);
        self.add("SspiMarshalAuthIdentity", 3);
        self.add("SspiPrepareForCredRead", 4);
        self.add("SspiPrepareForCredWrite", 7);
        self.add("SspiPromptForCredentials", 8);
        self.add("SspiUnmarshalAuthIdentity", 3);
        self.add("SspiUnmarshalCredUIContext", 3);
        self.add("SspiUpdateCredentials", 4);
        self.add("SspiValidateAuthIdentity", 1);
        self.add("SspiZeroAuthIdentity", 1);
        self.add("StackWalk64", 9);
        self.add("StackWalk", 9);
        self.add("StartDoc", 2);
        self.add("StartDocPrinter", 3);
        self.add("StartPage", 1);
        self.add("StartPagePrinter", 1);
        self.add("StartService", 3);
        self.add("StartServiceCtrlDispatcher", 1);
        self.add("StartThreadpoolIo", 1);
        self.add("StartTrace", 3);
        self.add("stat", 2);
        self.add("stat32", 2);
        self.add("stat32i64", 2);
        self.add("stat64", 2);
        self.add("stat64i32", 2);
        self.add("stati64", 2);
        self.add("statusfp", 0);
        self.add("StgConvertPropertyToVariant", 4);
        self.add("StgConvertVariantToProperty", 7);
        self.add("StgCreateDocfile", 4);
        self.add("StgCreateDocfileOnILockBytes", 4);
        self.add("StgCreatePropSetStg", 3);
        self.add("StgCreatePropStg", 6);
        self.add("StgCreateStorageEx", 8);
        self.add("StgDeserializePropVariant", 3);
        self.add("StgGetIFillLockBytesOnFile", 2);
        self.add("StgGetIFillLockBytesOnILockBytes", 2);
        self.add("StgIsStorageFile", 1);
        self.add("StgIsStorageILockBytes", 1);
        self.add("StgMakeUniqueName", 5);
        self.add("StgOpenAsyncDocfileOnIFillLockBytes", 4);
        self.add("StgOpenPropStg", 5);
        self.add("StgOpenStorage", 6);
        self.add("StgOpenStorageEx", 8);
        self.add("StgOpenStorageOnILockBytes", 6);
        self.add("StgPropertyLengthAsVariant", 4);
        self.add("StgSerializePropVariant", 3);
        self.add("StgSetTimes", 4);
        self.add("StopInteractionContext", 1);
        self.add("StopTrace", 3);
        self.add("StopWatchFlush", 0);
        self.add("StopWatchFlush", 1);
        self.add("StopWatchMode", 0);
        self.add("StopWatchMode", 1);
        self.add("strcat", 2);
        self.add("StrCat", 2);
        self.add("StrCatBuff", 3);
        self.add("StrCatBuffA", 3);
        self.add("StrCatBuffW", 3);
        self.add("StrCatChainW", 4);
        self.add("strcat_s", 3);
        self.add("StrCatW", 2);
        self.add("strchr", 2);
        self.add("StrChr", 2);
        self.add("StrChrA", 2);
        self.add("StrChrI", 2);
        self.add("StrChrIA", 2);
        self.add("StrChrIW", 2);
        self.add("StrChrNIW", 3);
        self.add("StrChrNW", 3);
        self.add("StrChrW", 2);
        self.add("strcmp", 2);
        self.add("StrCmp", 2);
        self.add("StrCmpC", 2);
        self.add("StrCmpCA", 2);
        self.add("StrCmpCW", 2);
        self.add("strcmpi", 2);
        self.add("StrCmpI", 2);
        self.add("StrCmpIC", 2);
        self.add("StrCmpICA", 2);
        self.add("StrCmpICW", 2);
        self.add("StrCmpIW", 2);
        self.add("StrCmpLogicalW", 2);
        self.add("StrCmpN", 3);
        self.add("StrCmpNA", 3);
        self.add("StrCmpNC", 3);
        self.add("StrCmpNCA", 3);
        self.add("StrCmpNCW", 3);
        self.add("StrCmpNI", 3);
        self.add("StrCmpNIA", 3);
        self.add("StrCmpNIC", 3);
        self.add("StrCmpNICA", 3);
        self.add("StrCmpNICW", 3);
        self.add("StrCmpNIW", 3);
        self.add("StrCmpNW", 3);
        self.add("StrCmpW", 2);
        self.add("strcoll", 2);
        self.add("strcoll_l", 3);
        self.add("strcpy", 2);
        self.add("StrCpy", 2);
        self.add("StrCpyN", 3);
        self.add("StrCpyNW", 3);
        self.add("strcpy_s", 3);
        self.add("StrCpyW", 2);
        self.add("strcspn", 2);
        self.add("StrCSpn", 2);
        self.add("StrCSpnA", 2);
        self.add("StrCSpnI", 2);
        self.add("StrCSpnIA", 2);
        self.add("StrCSpnIW", 2);
        self.add("StrCSpnW", 2);
        self.add("strdate", 1);
        self.add("strdate_s", 2);
        self.add("strdup", 1);
        self.add("StrDup", 1);
        self.add("StrDupA", 1);
        self.add("strdup_dbg", 4);
        self.add("StrDupW", 1);
        self.add("strerror", 1);
        self.add("strerror_s", 3);
        self.add("StretchBlt", 11);
        self.add("StretchDIB", 12);
        self.add("StretchDIBits", 13);
        self.add("StrFormatByteSize64", 3);
        self.add("StrFormatByteSize64A", 3);
        self.add("StrFormatByteSizeA", 3);
        self.add("StrFormatByteSizeEx", 4);
        self.add("StrFormatByteSizeW", 3);
        self.add("StrFormatKBSize", 3);
        self.add("StrFormatKBSizeA", 3);
        self.add("StrFormatKBSizeW", 3);
        self.add("StrFromTimeInterval", 4);
        self.add("StrFromTimeIntervalA", 4);
        self.add("StrFromTimeIntervalW", 4);
        self.add("strftime", 4);
        self.add("strftime_l", 5);
        self.add("Str_GetPtr", 3);
        self.add("stricmp", 2);
        self.add("stricmp_l", 3);
        self.add("stricoll", 2);
        self.add("stricoll_l", 3);
        self.add("StringFromCLSID", 2);
        self.add("StringFromGUID2", 3);
        self.add("StringFromIID", 2);
        self.add("StrIsIntlEqual", 4);
        self.add("StrIsIntlEqualA", 4);
        self.add("StrIsIntlEqualW", 4);
        self.add("strlen", 1);
        self.add("strlwr", 1);
        self.add("strlwr_l", 2);
        self.add("strlwr_s", 2);
        self.add("strlwr_s_l", 3);
        self.add("strncat", 3);
        self.add("StrNCat", 3);
        self.add("StrNCatA", 3);
        self.add("strncat_s", 4);
        self.add("StrNCatW", 3);
        self.add("strncmp", 3);
        self.add("strncnt", 2);
        self.add("strncoll", 3);
        self.add("strncoll_l", 4);
        self.add("strncpy", 3);
        self.add("strncpy_s", 4);
        self.add("strnicmp", 3);
        self.add("strnicmp_l", 4);
        self.add("strnicoll", 3);
        self.add("strnicoll_l", 4);
        self.add("strnlen", 2);
        self.add("strnset", 3);
        self.add("strnset_s", 4);
        self.add("StrokeAndFillPath", 1);
        self.add("StrokePath", 1);
        self.add("strpbrk", 2);
        self.add("StrPBrk", 2);
        self.add("StrPBrkA", 2);
        self.add("StrPBrkW", 2);
        self.add("strrchr", 2);
        self.add("StrRChr", 3);
        self.add("StrRChrA", 3);
        self.add("StrRChrI", 3);
        self.add("StrRChrIA", 3);
        self.add("StrRChrIW", 3);
        self.add("StrRChrW", 3);
        self.add("StrRetToBSTR", 3);
        self.add("StrRetToBuf", 4);
        self.add("StrRetToBufA", 4);
        self.add("StrRetToBufW", 4);
        self.add("StrRetToStr", 3);
        self.add("StrRetToStrA", 3);
        self.add("StrRetToStrN", 4);
        self.add("StrRetToStrW", 3);
        self.add("strrev", 1);
        self.add("StrRStrI", 3);
        self.add("StrRStrIA", 3);
        self.add("StrRStrIW", 3);
        self.add("strset", 2);
        self.add("Str_SetPtr", 2);
        self.add("strset_s", 3);
        self.add("strspn", 2);
        self.add("StrSpn", 2);
        self.add("StrSpnA", 2);
        self.add("StrSpnW", 2);
        self.add("strstr", 2);
        self.add("StrStr", 2);
        self.add("StrStrA", 2);
        self.add("StrStrI", 2);
        self.add("StrStrIA", 2);
        self.add("StrStrIW", 2);
        self.add("StrStrNIW", 3);
        self.add("StrStrNW", 3);
        self.add("StrStrW", 2);
        self.add("strtime", 1);
        self.add("strtime_s", 2);
        self.add("strtod", 2);
        self.add("strtod_l", 3);
        self.add("strtoi64", 3);
        self.add("strtoi64_l", 4);
        self.add("StrToInt", 1);
        self.add("StrToInt64Ex", 3);
        self.add("StrToInt64ExA", 3);
        self.add("StrToInt64ExW", 3);
        self.add("StrToIntA", 1);
        self.add("StrToIntEx", 3);
        self.add("StrToIntExA", 3);
        self.add("StrToIntExW", 3);
        self.add("StrToIntW", 1);
        self.add("strtok", 2);
        self.add("strtok_s", 3);
        self.add("strtol", 3);
        self.add("strtol_l", 4);
        self.add("strtoui64", 3);
        self.add("strtoui64_l", 4);
        self.add("strtoul", 3);
        self.add("strtoul_l", 4);
        self.add("StrTrim", 2);
        self.add("StrTrimA", 2);
        self.add("StrTrimW", 2);
        self.add("strupr", 1);
        self.add("strupr_l", 2);
        self.add("strupr_s", 2);
        self.add("strupr_s_l", 3);
        self.add("strxfrm", 3);
        self.add("strxfrm_l", 4);
        self.add("SubmitThreadpoolWork", 1);
        self.add("SubtractRect", 3);
        self.add("SuspendThread", 1);
        self.add("swab", 3);
        self.add("SwapBuffers", 1);
        self.add("SwapMouseButton", 1);
        self.add("SwitchDesktop", 1);
        self.add("SwitchToFiber", 1);
        self.add("SwitchToThisWindow", 2);
        self.add("SwitchToThread", 0);
        self.add("SwitchToThread", 1);
        self.add("swprintf", 3);
        self.add("swprintf_l", 3);
        self.add("swprintf_p", 3);
        self.add("swprintf_p_l", 4);
        self.add("swprintf_s", 3);
        self.add("swprintf_s_l", 4);
        self.add("swscanf", 2);
        self.add("swscanf_l", 3);
        self.add("swscanf_s", 2);
        self.add("swscanf_s_l", 3);
        self.add("SymAddSourceStream", 5);
        self.add("SymAddSymbol", 6);
        self.add("SymCleanup", 1);
        self.add("SymDeleteSymbol", 5);
        self.add("SymEnumerateModules", 3);
        self.add("SymEnumerateModules64", 3);
        self.add("SymEnumerateModulesW64", 3);
        self.add("SymEnumerateSymbols", 4);
        self.add("SymEnumerateSymbols64", 4);
        self.add("SymEnumerateSymbolsW64", 4);
        self.add("SymEnumLines", 6);
        self.add("SymEnumProcesses", 2);
        self.add("SymEnumSourceFiles", 5);
        self.add("SymEnumSourceFileTokens", 3);
        self.add("SymEnumSourceLines", 8);
        self.add("SymEnumSymbols", 5);
        self.add("SymEnumSymbolsForAddr", 4);
        self.add("SymEnumTypes", 4);
        self.add("SymEnumTypesByName", 5);
        self.add("SymFindDebugInfoFile", 5);
        self.add("SymFindExecutableImage", 5);
        self.add("SymFindFileInPath", 10);
        self.add("SymFromAddr", 4);
        self.add("SymFromIndex", 4);
        self.add("SymFromName", 3);
        self.add("SymFromToken", 4);
        self.add("SymFunctionTableAccess", 2);
        self.add("SymFunctionTableAccess64", 2);
        self.add("SymGetFileLineOffsets64", 5);
        self.add("SymGetHomeDirectory", 3);
        self.add("SymGetLineFromAddr", 4);
        self.add("SymGetLineFromAddr64", 4);
        self.add("SymGetLineFromAddrW64", 4);
        self.add("SymGetLineFromName", 6);
        self.add("SymGetLineFromName64", 6);
        self.add("SymGetLineFromNameW64", 6);
        self.add("SymGetLineNext", 2);
        self.add("SymGetLineNext64", 2);
        self.add("SymGetLineNextW64", 2);
        self.add("SymGetLinePrev", 2);
        self.add("SymGetLinePrev64", 2);
        self.add("SymGetLinePrevW64", 2);
        self.add("SymGetModuleBase", 2);
        self.add("SymGetModuleBase64", 2);
        self.add("SymGetModuleInfo", 3);
        self.add("SymGetModuleInfo64", 3);
        self.add("SymGetModuleInfoW64", 3);
        self.add("SymGetOmaps", 6);
        self.add("SymGetOptions", 0);
        self.add("SymGetScope", 4);
        self.add("SymGetSearchPath", 3);
        self.add("SymGetSourceFile", 6);
        self.add("SymGetSourceFileFromToken", 5);
        self.add("SymGetSourceFileToken", 5);
        self.add("SymGetSourceVarFromToken", 6);
        self.add("SymGetSymbolFile", 8);
        self.add("SymGetSymFromAddr", 4);
        self.add("SymGetSymFromAddr64", 4);
        self.add("SymGetSymFromName", 3);
        self.add("SymGetSymFromName64", 3);
        self.add("SymGetSymNext", 2);
        self.add("SymGetSymNext64", 2);
        self.add("SymGetSymPrev", 2);
        self.add("SymGetSymPrev64", 2);
        self.add("SymGetTypeFromName", 4);
        self.add("SymGetTypeInfo", 5);
        self.add("SymGetTypeInfoEx", 3);
        self.add("SymInitialize", 3);
        self.add("SymLoadModule", 6);
        self.add("SymLoadModule64", 6);
        self.add("SymLoadModuleEx", 8);
        self.add("SymMatchFileName", 4);
        self.add("SymMatchString", 3);
        self.add("SymNext", 2);
        self.add("SymPrev", 2);
        self.add("SymRefreshModuleList", 1);
        self.add("SymRegisterCallback", 3);
        self.add("SymRegisterCallback64", 3);
        self.add("SymRegisterCallbackW64", 3);
        self.add("SymRegisterFunctionEntryCallback", 3);
        self.add("SymRegisterFunctionEntryCallback64", 3);
        self.add("SymSearch", 9);
        self.add("SymSetContext", 3);
        self.add("SymSetHomeDirectory", 2);
        self.add("SymSetOptions", 1);
        self.add("SymSetParentWindow", 1);
        self.add("SymSetScopeFromAddr", 2);
        self.add("SymSetScopeFromIndex", 3);
        self.add("SymSetSearchPath", 2);
        self.add("SymSrvDeltaName", 5);
        self.add("SymSrvGetFileIndexes", 5);
        self.add("SymSrvGetFileIndexInfo", 3);
        self.add("SymSrvGetFileIndexString", 6);
        self.add("SymSrvGetSupplement", 4);
        self.add("SymSrvIsStore", 2);
        self.add("SymSrvStoreFile", 4);
        self.add("SymSrvStoreSupplement", 5);
        self.add("SymUnDName", 3);
        self.add("SymUnDName64", 3);
        self.add("SymUnloadModule", 2);
        self.add("SymUnloadModule64", 2);
        self.add("SysAllocString", 1);
        self.add("SysAllocStringByteLen", 2);
        self.add("SysAllocStringLen", 2);
        self.add("SysFreeString", 1);
        self.add("SysReAllocString", 2);
        self.add("SysReAllocStringLen", 3);
        self.add("SysStringByteLen", 1);
        self.add("SysStringLen", 1);
        self.add("system", 1);
        self.add("SystemFunction036", 2);
        self.add("SystemFunction040", 3);
        self.add("SystemFunction041", 3);
        self.add("SystemParametersInfo", 4);
        self.add("SystemParametersInfoA", 4);
        self.add("SystemParametersInfoW", 4);
        self.add("SystemTimeToFileTime", 2);
        self.add("SystemTimeToTzSpecificLocalTime", 3);
        self.add("SystemTimeToVariantTime", 2);
        self.add("SzFindCh", 2);
        self.add("SzFindLastCh", 2);
        self.add("SzFindSz", 2);
        self.add("TabbedTextOut", 8);
        self.add("TabbedTextOutA", 8);
        self.add("TabbedTextOutW", 8);
        self.add("tan", 1);
        self.add("tanf", 1);
        self.add("tanh", 1);
        self.add("tanhf", 1);
        self.add("TaskDialog", 8);
        self.add("TaskDialogIndirect", 4);
        self.add("TcAddFilter", 3);
        self.add("TcAddFlow", 5);
        self.add("TcCloseInterface", 1);
        self.add("TcDeleteFilter", 1);
        self.add("TcDeleteFlow", 1);
        self.add("TcDeregisterClient", 1);
        self.add("TcEnumerateFlows", 5);
        self.add("TcEnumerateInterfaces", 3);
        self.add("TcGetFlowName", 3);
        self.add("TcModifyFlow", 2);
        self.add("TcOpenInterface", 4);
        self.add("TcQueryFlow", 4);
        self.add("TcQueryInterface", 5);
        self.add("TcRegisterClient", 4);
        self.add("TcSetFlow", 4);
        self.add("TcSetInterface", 4);
        self.add("TdhCloseDecodingHandle", 1);
        self.add("TdhEnumerateProviderFieldInformation", 4);
        self.add("TdhEnumerateProviderFilters", 6);
        self.add("TdhEnumerateProviders", 2);
        self.add("TdhFormatProperty", 11);
        self.add("TdhGetDecodingParameter", 2);
        self.add("TdhGetEventInformation", 5);
        self.add("TdhGetEventMapInformation", 4);
        self.add("TdhGetProperty", 7);
        self.add("TdhGetPropertySize", 6);
        self.add("TdhGetWppMessage", 4);
        self.add("TdhGetWppProperty", 5);
        self.add("TdhLoadManifest", 1);
        self.add("TdhLoadManifestFromBinary", 1);
        self.add("TdhOpenDecodingHandle", 1);
        self.add("TdhQueryProviderFieldInformation", 5);
        self.add("TdhSetDecodingParameter", 2);
        self.add("TdhUnloadManifest", 1);
        self.add("tell", 1);
        self.add("telli64", 1);
        self.add("tempnam", 2);
        self.add("tempnam_dbg", 5);
        self.add("TerminateJobObject", 2);
        self.add("TerminateLogArchive", 1);
        self.add("TerminateProcess", 2);
        self.add("TerminateReadLog", 1);
        self.add("TerminateThread", 2);
        self.add("?terminate@@YAXXZ", 0);
        self.add("TestApplyPatchToFile", 3);
        self.add("TestApplyPatchToFileByBuffers", 5);
        self.add("TestApplyPatchToFileByHandles", 3);
        self.add("TextOut", 5);
        self.add("TextOutA", 5);
        self.add("TextOutW", 5);
        self.add("TF_CreateCategoryMgr", 1);
        self.add("TF_CreateDisplayAttributeMgr", 1);
        self.add("TF_CreateInputProcessorProfiles", 1);
        self.add("TF_CreateLangBarItemMgr", 1);
        self.add("TF_CreateLangBarMgr", 1);
        self.add("TF_CreateThreadMgr", 1);
        self.add("TF_GetThreadMgr", 1);
        self.add("TF_InvalidAssemblyListCacheIfExist", 0);
        self.add("Thread32First", 2);
        self.add("Thread32Next", 2);
        self.add("TileWindows", 5);
        self.add("time", 1);
        self.add("time32", 1);
        self.add("time64", 1);
        self.add("timeBeginPeriod", 1);
        self.add("timeEndPeriod", 1);
        self.add("timeGetDevCaps", 2);
        self.add("timeGetSystemTime", 2);
        self.add("timeGetTime", 0);
        self.add("timeKillEvent", 1);
        self.add("Timerproc", 4);
        self.add("timeSetEvent", 5);
        self.add("TlsAlloc", 0);
        self.add("TlsAlloc", 1);
        self.add("TlsFree", 1);
        self.add("TlsGetValue", 1);
        self.add("TlsSetValue", 2);
        self.add("TmCommitComplete", 2);
        self.add("TmCommitEnlistment", 2);
        self.add("TmCommitTransaction", 2);
        self.add("TmCreateEnlistment", 9);
        self.add("TmDereferenceEnlistmentKey", 2);
        self.add("TmEnableCallbacks", 3);
        self.add("TmGetTransactionId", 2);
        self.add("TmInitializeTransactionManager", 4);
        self.add("TmIsTransactionActive", 1);
        self.add("tmpfile", 0);
        self.add("tmpfile_s", 1);
        self.add("tmpnam", 1);
        self.add("tmpnam_s", 2);
        self.add("TmPrepareComplete", 2);
        self.add("TmPrepareEnlistment", 2);
        self.add("TmPrePrepareComplete", 2);
        self.add("TmPrePrepareEnlistment", 2);
        self.add("TmReadOnlyEnlistment", 2);
        self.add("TmRecoverEnlistment", 2);
        self.add("TmRecoverResourceManager", 1);
        self.add("TmRecoverTransactionManager", 2);
        self.add("TmReferenceEnlistmentKey", 2);
        self.add("TmRenameTransactionManager", 2);
        self.add("TmRequestOutcomeEnlistment", 2);
        self.add("TmRollbackComplete", 2);
        self.add("TmRollbackEnlistment", 2);
        self.add("TmRollbackTransaction", 2);
        self.add("TmSinglePhaseReject", 2);
        self.add("toascii", 1);
        self.add("ToAscii", 5);
        self.add("ToAsciiEx", 6);
        self.add("tolower", 1);
        self.add("tolower_l", 2);
        self.add("Toolhelp32ReadProcessMemory", 5);
        self.add("TouchFileTimes", 2);
        self.add("ToUnicode", 6);
        self.add("ToUnicodeEx", 7);
        self.add("toupper", 1);
        self.add("toupper_l", 2);
        self.add("towlower", 1);
        self.add("towlower_l", 2);
        self.add("towupper", 1);
        self.add("towupper_l", 2);
        self.add("TraceEvent", 2);
        self.add("TraceEventInstance", 4);
        self.add("TraceMessage", 4);
        self.add("TraceMessageVa", 5);
        self.add("TraceQueryInformation", 5);
        self.add("TraceSetInformation", 4);
        self.add("TrackMouseEvent", 1);
        self.add("TrackPopupMenu", 7);
        self.add("TrackPopupMenuEx", 6);
        self.add("TransactNamedPipe", 7);
        self.add("TranslateAccelerator", 3);
        self.add("TranslateBitmapBits", 11);
        self.add("TranslateBusAddress", 5);
        self.add("TranslateCharsetInfo", 3);
        self.add("TranslateColors", 6);
        self.add("TranslateMDISysAccel", 2);
        self.add("TranslateMessage", 1);
        self.add("TranslateName", 5);
        self.add("TranslateURL", 3);
        self.add("TransmitCommChar", 2);
        self.add("TransmitFile", 7);
        self.add("TransparentBlt", 11);
        self.add("TreeResetNamedSecurityInfo", 11);
        self.add("TreeSetNamedSecurityInfo", 11);
        self.add("TruncateLog", 3);
        self.add("TryAcquireSRWLockExclusive", 1);
        self.add("TryAcquireSRWLockShared", 1);
        self.add("TryEnterCriticalSection", 1);
        self.add("TrySubmitThreadpoolCallback", 3);
        self.add("TxfLogCreateFileReadContext", 5);
        self.add("TxfLogDestroyReadContext", 1);
        self.add("TxfLogReadRecords", 5);
        self.add("tzset", 0);
        self.add("TzSpecificLocalTimeToSystemTime", 3);
        self.add("UFromSz", 1);
        self.add("ui64toa", 3);
        self.add("ui64toa_s", 4);
        self.add("ui64tow", 3);
        self.add("ui64tow_s", 4);
        self.add("UlAddRef", 1);
        self.add("UlFromSzHex", 1);
        self.add("UlPropSize", 1);
        self.add("UlRelease", 1);
        self.add("ultoa", 3);
        self.add("ultoa_s", 4);
        self.add("ultow", 3);
        self.add("ultow_s", 4);
        self.add("UlValidateParameters", 2);
        self.add("UlValidateParms", 2);
        self.add("umask", 1);
        self.add("umask_s", 2);
        self.add("UmsThreadYield", 1);
        self.add("uncaught_exception", 0);
        self.add("UnDecorateSymbolName", 4);
        self.add("UnenableRouter", 2);
        self.add("?unexpected@@YAXXZ", 0);
        self.add("ungetc", 2);
        self.add("ungetch", 1);
        self.add("ungetch_nolock", 1);
        self.add("ungetc_nolock", 2);
        self.add("ungetwc", 2);
        self.add("ungetwch", 1);
        self.add("ungetwch_nolock", 1);
        self.add("ungetwc_nolock", 2);
        self.add("UnhandledExceptionFilter", 1);
        self.add("UnhookWindowsHookEx", 1);
        self.add("UnhookWinEvent", 1);
        self.add("UninitializeFlatSB", 1);
        self.add("UninitLocalMsCtfMonitor", 0);
        self.add("UninstallApplication", 2);
        self.add("UninstallColorProfile", 3);
        self.add("UnionRect", 3);
        self.add("unlink", 1);
        self.add("unloaddll", 1);
        self.add("UnloadKeyboardLayout", 1);
        self.add("UnloadPerfCounterTextStrings", 2);
        self.add("UnloadUserProfile", 2);
        self.add("unlock", 1);
        self.add("unlock_file", 1);
        self.add("UnlockFile", 5);
        self.add("UnlockFileEx", 5);
        self.add("UnlockServiceDatabase", 1);
        self.add("UnlockUrlCacheEntryFile", 2);
        self.add("UnlockUrlCacheEntryFileA", 2);
        self.add("UnlockUrlCacheEntryFileW", 2);
        self.add("UnlockUrlCacheEntryStream", 2);
        self.add("UnMapAndLoad", 1);
        self.add("UnmapDebugInformation", 1);
        self.add("UnmapViewOfFile", 1);
        self.add("UnmountVHD", 2);
        self.add("UnpackDDElParam", 4);
        self.add("UnrealizeObject", 1);
        self.add("UnregisterApplicationRecoveryCallback", 0);
        self.add("UnregisterApplicationRestart", 0);
        self.add("UnregisterBadMemoryNotification", 1);
        self.add("UnregisterClass", 2);
        self.add("UnregisterClassA", 2);
        self.add("UnregisterClassW", 2);
        self.add("UnregisterCMM", 2);
        self.add("UnregisterDeviceNotification", 1);
        self.add("UnRegisterForPrintAsyncNotifications", 1);
        self.add("UnregisterGPNotification", 1);
        self.add("UnregisterHotKey", 2);
        self.add("UnregisterPage", 2);
        self.add("UnregisterPagesLink", 2);
        self.add("UnregisterPowerSettingNotification", 1);
        self.add("UnregisterSuspendResumeNotification", 1);
        self.add("UnregisterTouchWindow", 1);
        self.add("UnregisterTraceGuids", 1);
        self.add("UnRegisterTypeLib", 5);
        self.add("UnRegisterTypeLibForUser", 5);
        self.add("UnregisterWait", 1);
        self.add("UnregisterWaitEx", 2);
        self.add("UpdateCalendarDayOfWeek", 1);
        self.add("UpdateColors", 1);
        self.add("UpdateDebugInfoFile", 4);
        self.add("UpdateDebugInfoFileEx", 5);
        self.add("UpdateDriverForPlugAndPlayDevices", 5);
        self.add("UpdateICMRegKey", 4);
        self.add("UpdateLayeredWindow", 9);
        self.add("UpdateLayeredWindowIndirect", 2);
        self.add("UpdatePanningFeedback", 4);
        self.add("UpdateProcThreadAttribute", 7);
        self.add("UpdateResource", 6);
        self.add("UpdateTrace", 3);
        self.add("UpdateUrlCacheContentPath", 1);
        self.add("UpdateWindow", 1);
        self.add("UpdateWindowTransform", 3);
        self.add("UploadPrinterDriverPackage", 7);
        self.add("UrlApplyScheme", 4);
        self.add("UrlApplySchemeA", 4);
        self.add("UrlApplySchemeW", 4);
        self.add("URLAssociationDialog", 6);
        self.add("UrlCacheCheckEntriesExist", 3);
        self.add("UrlCacheCloseEntryHandle", 1);
        self.add("UrlCacheContainerSetEntryMaximumAge", 2);
        self.add("UrlCacheCreateContainer", 5);
        self.add("UrlCacheFreeEntryInfo", 1);
        self.add("UrlCacheGetContentPaths", 2);
        self.add("UrlCacheGetEntryInfo", 3);
        self.add("UrlCacheGetGlobalLimit", 2);
        self.add("UrlCacheReadEntryStream", 5);
        self.add("UrlCacheReloadSettings", 0);
        self.add("UrlCacheRetrieveEntryFile", 4);
        self.add("UrlCacheRetrieveEntryStream", 5);
        self.add("UrlCacheSetGlobalLimit", 2);
        self.add("UrlCacheUpdateEntryExtraData", 4);
        self.add("UrlCanonicalize", 4);
        self.add("UrlCanonicalizeA", 4);
        self.add("UrlCanonicalizeW", 4);
        self.add("UrlCombine", 5);
        self.add("UrlCombineA", 5);
        self.add("UrlCombineW", 5);
        self.add("UrlCompare", 3);
        self.add("UrlCompareA", 3);
        self.add("UrlCompareW", 3);
        self.add("UrlCreateFromPath", 4);
        self.add("UrlCreateFromPathA", 4);
        self.add("UrlCreateFromPathW", 4);
        self.add("URLDownloadToCacheFile", 6);
        self.add("URLDownloadToFile", 5);
        self.add("UrlEscape", 4);
        self.add("UrlEscapeA", 4);
        self.add("UrlEscapeSpaces", 3);
        self.add("UrlEscapeW", 4);
        self.add("UrlFixupW", 3);
        self.add("UrlGetLocation", 1);
        self.add("UrlGetLocationA", 1);
        self.add("UrlGetLocationW", 1);
        self.add("UrlGetPart", 5);
        self.add("UrlGetPartA", 5);
        self.add("UrlGetPartW", 5);
        self.add("UrlHash", 3);
        self.add("UrlHashA", 3);
        self.add("UrlHashW", 3);
        self.add("UrlIs", 2);
        self.add("UrlIsA", 2);
        self.add("UrlIsFileUrl", 1);
        self.add("UrlIsNoHistory", 1);
        self.add("UrlIsNoHistoryA", 1);
        self.add("UrlIsNoHistoryW", 1);
        self.add("UrlIsOpaque", 1);
        self.add("UrlIsOpaqueA", 1);
        self.add("UrlIsOpaqueW", 1);
        self.add("UrlIsW", 2);
        self.add("UrlMkGetSessionOption", 5);
        self.add("UrlMkSetSessionOption", 4);
        self.add("URLOpenBlockingStream", 5);
        self.add("URLOpenPullStream", 4);
        self.add("URLOpenStream", 4);
        self.add("UrlUnescape", 4);
        self.add("UrlUnescapeA", 4);
        self.add("UrlUnescapeInPlace", 2);
        self.add("UrlUnescapeW", 4);
        self.add("UrlZonesDetach", 0);
        self.add("UserHandleGrantAccess", 3);
        self.add("utime", 2);
        self.add("utime32", 2);
        self.add("utime64", 2);
        self.add("UuidCompare", 3);
        self.add("UuidCreate", 1);
        self.add("UuidCreateNil", 1);
        self.add("UuidCreateSequential", 1);
        self.add("UuidEqual", 3);
        self.add("UuidFromString", 2);
        self.add("UuidHash", 2);
        self.add("UuidIsNil", 2);
        self.add("UuidToString", 2);
        self.add("??_U@YAPAXI@Z", 1);
        self.add("??_U@YAPEAX_K@Z", 1);
        self.add("ValidateLog", 4);
        self.add("ValidateParameters", 2);
        self.add("ValidateParms", 2);
        self.add("ValidateRect", 2);
        self.add("ValidateRgn", 2);
        self.add("VarAbs", 2);
        self.add("VarAdd", 3);
        self.add("VarAnd", 3);
        self.add("VarBoolFromCy", 2);
        self.add("VarBoolFromDate", 2);
        self.add("VarBoolFromDec", 2);
        self.add("VarBoolFromDisp", 3);
        self.add("VarBoolFromI1", 2);
        self.add("VarBoolFromI2", 2);
        self.add("VarBoolFromI4", 2);
        self.add("VarBoolFromI8", 2);
        self.add("VarBoolFromR4", 2);
        self.add("VarBoolFromR8", 2);
        self.add("VarBoolFromStr", 4);
        self.add("VarBoolFromUI1", 2);
        self.add("VarBoolFromUI2", 2);
        self.add("VarBoolFromUI4", 2);
        self.add("VarBoolFromUI8", 2);
        self.add("VarBstrCat", 3);
        self.add("VarBstrCmp", 4);
        self.add("VarBstrFromBool", 4);
        self.add("VarBstrFromCy", 4);
        self.add("VarBstrFromDate", 4);
        self.add("VarBstrFromDec", 4);
        self.add("VarBstrFromDisp", 4);
        self.add("VarBstrFromI1", 4);
        self.add("VarBstrFromI2", 4);
        self.add("VarBstrFromI4", 4);
        self.add("VarBstrFromI8", 4);
        self.add("VarBstrFromR4", 4);
        self.add("VarBstrFromR8", 4);
        self.add("VarBstrFromUI1", 4);
        self.add("VarBstrFromUI2", 4);
        self.add("VarBstrFromUI4", 4);
        self.add("VarBstrFromUI8", 4);
        self.add("VarCat", 3);
        self.add("VarCmp", 4);
        self.add("VarCyAbs", 2);
        self.add("VarCyAdd", 3);
        self.add("VarCyCmp", 2);
        self.add("VarCyCmpR8", 2);
        self.add("VarCyFix", 2);
        self.add("VarCyFromBool", 2);
        self.add("VarCyFromDate", 2);
        self.add("VarCyFromDec", 2);
        self.add("VarCyFromDisp", 3);
        self.add("VarCyFromI1", 2);
        self.add("VarCyFromI2", 2);
        self.add("VarCyFromI4", 2);
        self.add("VarCyFromI8", 2);
        self.add("VarCyFromR4", 2);
        self.add("VarCyFromR8", 2);
        self.add("VarCyFromStr", 4);
        self.add("VarCyFromUI1", 2);
        self.add("VarCyFromUI2", 2);
        self.add("VarCyFromUI4", 2);
        self.add("VarCyFromUI8", 2);
        self.add("VarCyInt", 2);
        self.add("VarCyMul", 3);
        self.add("VarCyMulI4", 3);
        self.add("VarCyMulI8", 3);
        self.add("VarCyNeg", 2);
        self.add("VarCyRound", 3);
        self.add("VarCySub", 3);
        self.add("VarDateFromBool", 2);
        self.add("VarDateFromCy", 2);
        self.add("VarDateFromDec", 2);
        self.add("VarDateFromDisp", 3);
        self.add("VarDateFromI1", 2);
        self.add("VarDateFromI2", 2);
        self.add("VarDateFromI4", 2);
        self.add("VarDateFromI8", 2);
        self.add("VarDateFromR4", 2);
        self.add("VarDateFromR8", 2);
        self.add("VarDateFromStr", 4);
        self.add("VarDateFromUdate", 3);
        self.add("VarDateFromUdateEx", 4);
        self.add("VarDateFromUI1", 2);
        self.add("VarDateFromUI2", 2);
        self.add("VarDateFromUI4", 2);
        self.add("VarDateFromUI8", 2);
        self.add("VarDecAbs", 2);
        self.add("VarDecAdd", 3);
        self.add("VarDecCmp", 2);
        self.add("VarDecCmpR8", 2);
        self.add("VarDecDiv", 3);
        self.add("VarDecFix", 2);
        self.add("VarDecFromBool", 2);
        self.add("VarDecFromCy", 2);
        self.add("VarDecFromDate", 2);
        self.add("VarDecFromDisp", 3);
        self.add("VarDecFromI1", 2);
        self.add("VarDecFromI2", 2);
        self.add("VarDecFromI4", 2);
        self.add("VarDecFromI8", 2);
        self.add("VarDecFromR4", 2);
        self.add("VarDecFromR8", 2);
        self.add("VarDecFromStr", 4);
        self.add("VarDecFromUI1", 2);
        self.add("VarDecFromUI2", 2);
        self.add("VarDecFromUI4", 2);
        self.add("VarDecFromUI8", 2);
        self.add("VarDecInt", 2);
        self.add("VarDecMul", 3);
        self.add("VarDecNeg", 2);
        self.add("VarDecRound", 3);
        self.add("VarDecSub", 3);
        self.add("VarDiv", 3);
        self.add("VarEqv", 3);
        self.add("VarFix", 2);
        self.add("VarFormat", 6);
        self.add("VarFormatCurrency", 7);
        self.add("VarFormatDateTime", 4);
        self.add("VarFormatFromTokens", 6);
        self.add("VarFormatNumber", 7);
        self.add("VarFormatPercent", 7);
        self.add("VarI1FromBool", 2);
        self.add("VarI1FromCy", 2);
        self.add("VarI1FromDate", 2);
        self.add("VarI1FromDec", 2);
        self.add("VarI1FromDisp", 3);
        self.add("VarI1FromI2", 2);
        self.add("VarI1FromI4", 2);
        self.add("VarI1FromI8", 2);
        self.add("VarI1FromR4", 2);
        self.add("VarI1FromR8", 2);
        self.add("VarI1FromStr", 4);
        self.add("VarI1FromUI1", 2);
        self.add("VarI1FromUI2", 2);
        self.add("VarI1FromUI4", 2);
        self.add("VarI1FromUI8", 2);
        self.add("VarI2FromBool", 2);
        self.add("VarI2FromCy", 2);
        self.add("VarI2FromDate", 2);
        self.add("VarI2FromDec", 2);
        self.add("VarI2FromDisp", 3);
        self.add("VarI2FromI1", 2);
        self.add("VarI2FromI4", 2);
        self.add("VarI2FromI8", 2);
        self.add("VarI2FromR4", 2);
        self.add("VarI2FromR8", 2);
        self.add("VarI2FromStr", 4);
        self.add("VarI2FromUI1", 2);
        self.add("VarI2FromUI2", 2);
        self.add("VarI2FromUI4", 2);
        self.add("VarI2FromUI8", 2);
        self.add("VarI4FromBool", 2);
        self.add("VarI4FromCy", 2);
        self.add("VarI4FromDate", 2);
        self.add("VarI4FromDec", 2);
        self.add("VarI4FromDisp", 3);
        self.add("VarI4FromI1", 2);
        self.add("VarI4FromI2", 2);
        self.add("VarI4FromI8", 2);
        self.add("VarI4FromR4", 2);
        self.add("VarI4FromR8", 2);
        self.add("VarI4FromStr", 4);
        self.add("VarI4FromUI1", 2);
        self.add("VarI4FromUI2", 2);
        self.add("VarI4FromUI4", 2);
        self.add("VarI4FromUI8", 2);
        self.add("VarI8FromBool", 2);
        self.add("VarI8FromCy", 2);
        self.add("VarI8FromDate", 2);
        self.add("VarI8FromDec", 2);
        self.add("VarI8FromDisp", 3);
        self.add("VarI8FromI1", 2);
        self.add("VarI8FromI2", 2);
        self.add("VarI8FromR4", 2);
        self.add("VarI8FromR8", 2);
        self.add("VarI8FromStr", 4);
        self.add("VarI8FromUI1", 2);
        self.add("VarI8FromUI2", 2);
        self.add("VarI8FromUI4", 2);
        self.add("VarI8FromUI8", 2);
        self.add("VariantChangeType", 4);
        self.add("VariantChangeTypeEx", 5);
        self.add("VariantClear", 1);
        self.add("VariantCopy", 2);
        self.add("VariantCopyInd", 2);
        self.add("VariantInit", 1);
        self.add("VariantTimeToDosDateTime", 3);
        self.add("VariantTimeToSystemTime", 2);
        self.add("VARIANT_UserFree", 2);
        self.add("VARIANT_UserFree64", 2);
        self.add("VARIANT_UserMarshal", 3);
        self.add("VARIANT_UserMarshal64", 3);
        self.add("VARIANT_UserSize", 3);
        self.add("VARIANT_UserSize64", 3);
        self.add("VARIANT_UserUnmarshal", 3);
        self.add("VARIANT_UserUnmarshal64", 3);
        self.add("VarIdiv", 3);
        self.add("VarImp", 3);
        self.add("VarInt", 2);
        self.add("VarMod", 3);
        self.add("VarMonthName", 4);
        self.add("VarMul", 3);
        self.add("VarNeg", 2);
        self.add("VarNot", 2);
        self.add("VarNumFromParseNum", 4);
        self.add("VarOr", 3);
        self.add("VarParseNumFromStr", 5);
        self.add("VarPow", 3);
        self.add("VarR4CmpR8", 2);
        self.add("VarR4FromBool", 2);
        self.add("VarR4FromCy", 2);
        self.add("VarR4FromDate", 2);
        self.add("VarR4FromDec", 2);
        self.add("VarR4FromDisp", 3);
        self.add("VarR4FromI1", 2);
        self.add("VarR4FromI2", 2);
        self.add("VarR4FromI4", 2);
        self.add("VarR4FromI8", 2);
        self.add("VarR4FromR8", 2);
        self.add("VarR4FromStr", 4);
        self.add("VarR4FromUI1", 2);
        self.add("VarR4FromUI2", 2);
        self.add("VarR4FromUI4", 2);
        self.add("VarR4FromUI8", 2);
        self.add("VarR8FromBool", 2);
        self.add("VarR8FromCy", 2);
        self.add("VarR8FromDate", 2);
        self.add("VarR8FromDec", 2);
        self.add("VarR8FromDisp", 3);
        self.add("VarR8FromI1", 2);
        self.add("VarR8FromI2", 2);
        self.add("VarR8FromI4", 2);
        self.add("VarR8FromI8", 2);
        self.add("VarR8FromR4", 2);
        self.add("VarR8FromStr", 4);
        self.add("VarR8FromUI1", 2);
        self.add("VarR8FromUI2", 2);
        self.add("VarR8FromUI4", 2);
        self.add("VarR8FromUI8", 2);
        self.add("VarR8Pow", 3);
        self.add("VarR8Round", 3);
        self.add("VarRound", 3);
        self.add("VarSub", 3);
        self.add("VarTokenizeFormatString", 7);
        self.add("VarUdateFromDate", 3);
        self.add("VarUI1FromBool", 2);
        self.add("VarUI1FromCy", 2);
        self.add("VarUI1FromDate", 2);
        self.add("VarUI1FromDec", 2);
        self.add("VarUI1FromDisp", 3);
        self.add("VarUI1FromI1", 2);
        self.add("VarUI1FromI2", 2);
        self.add("VarUI1FromI4", 2);
        self.add("VarUI1FromI8", 2);
        self.add("VarUI1FromR4", 2);
        self.add("VarUI1FromR8", 2);
        self.add("VarUI1FromStr", 4);
        self.add("VarUI1FromUI2", 2);
        self.add("VarUI1FromUI4", 2);
        self.add("VarUI1FromUI8", 2);
        self.add("VarUI2FromBool", 2);
        self.add("VarUI2FromCy", 2);
        self.add("VarUI2FromDate", 2);
        self.add("VarUI2FromDec", 2);
        self.add("VarUI2FromDisp", 3);
        self.add("VarUI2FromI1", 2);
        self.add("VarUI2FromI2", 2);
        self.add("VarUI2FromI4", 2);
        self.add("VarUI2FromI8", 2);
        self.add("VarUI2FromR4", 2);
        self.add("VarUI2FromR8", 2);
        self.add("VarUI2FromStr", 4);
        self.add("VarUI2FromUI1", 2);
        self.add("VarUI2FromUI4", 2);
        self.add("VarUI2FromUI8", 2);
        self.add("VarUI4FromBool", 2);
        self.add("VarUI4FromCy", 2);
        self.add("VarUI4FromDate", 2);
        self.add("VarUI4FromDec", 2);
        self.add("VarUI4FromDisp", 3);
        self.add("VarUI4FromI1", 2);
        self.add("VarUI4FromI2", 2);
        self.add("VarUI4FromI4", 2);
        self.add("VarUI4FromI8", 2);
        self.add("VarUI4FromR4", 2);
        self.add("VarUI4FromR8", 2);
        self.add("VarUI4FromStr", 4);
        self.add("VarUI4FromUI1", 2);
        self.add("VarUI4FromUI2", 2);
        self.add("VarUI4FromUI8", 2);
        self.add("VarUI8FromBool", 2);
        self.add("VarUI8FromCy", 2);
        self.add("VarUI8FromDate", 2);
        self.add("VarUI8FromDec", 2);
        self.add("VarUI8FromDisp", 3);
        self.add("VarUI8FromI1", 2);
        self.add("VarUI8FromI2", 2);
        self.add("VarUI8FromI8", 2);
        self.add("VarUI8FromR4", 2);
        self.add("VarUI8FromR8", 2);
        self.add("VarUI8FromStr", 4);
        self.add("VarUI8FromUI1", 2);
        self.add("VarUI8FromUI2", 2);
        self.add("VarUI8FromUI4", 2);
        self.add("VarWeekdayName", 5);
        self.add("VarXor", 3);
        self.add("vcprintf", 2);
        self.add("vcprintf_l", 3);
        self.add("vcprintf_p", 2);
        self.add("vcprintf_p_l", 3);
        self.add("vcprintf_s", 2);
        self.add("vcprintf_s_l", 3);
        self.add("vcwprintf", 2);
        self.add("vcwprintf_l", 3);
        self.add("vcwprintf_p", 2);
        self.add("vcwprintf_p_l", 3);
        self.add("vcwprintf_s", 2);
        self.add("vcwprintf_s_l", 3);
        self.add("vDbgPrintEx", 4);
        self.add("vDbgPrintExWithPrefix", 5);
        self.add("VectorFromBstr", 2);
        self.add("VerFindFile", 8);
        self.add("VerifyScripts", 5);
        self.add("VerifySignature", 4);
        self.add("VerifyVersionInfo", 3);
        self.add("VerInstallFile", 8);
        self.add("VerLanguageName", 3);
        self.add("VerQueryValue", 4);
        self.add("VerSetConditionMask", 3);
        self.add("vfprintf", 3);
        self.add("vfprintf_l", 4);
        self.add("vfprintf_p", 3);
        self.add("vfprintf_p_l", 4);
        self.add("vfprintf_s", 3);
        self.add("vfprintf_s_l", 4);
        self.add("vfwprintf", 3);
        self.add("vfwprintf_l", 4);
        self.add("vfwprintf_p", 3);
        self.add("vfwprintf_p_l", 4);
        self.add("vfwprintf_s", 3);
        self.add("vfwprintf_s_l", 4);
        self.add("VirtualAlloc", 4);
        self.add("VirtualAllocEx", 5);
        self.add("VirtualAllocExNuma", 6);
        self.add("VirtualFree", 3);
        self.add("VirtualFreeEx", 4);
        self.add("VirtualLock", 2);
        self.add("VirtualProtect", 4);
        self.add("VirtualProtectEx", 5);
        self.add("VirtualQuery", 3);
        self.add("VirtualQueryEx", 4);
        self.add("VirtualUnlock", 2);
        self.add("VkKeyScan", 1);
        self.add("VkKeyScanEx", 2);
        self.add("vprintf", 2);
        self.add("vprintf_l", 3);
        self.add("vprintf_p", 2);
        self.add("vprintf_p_l", 3);
        self.add("vprintf_s", 2);
        self.add("vprintf_s_l", 3);
        self.add("vscprintf", 2);
        self.add("vscprintf_l", 3);
        self.add("vscprintf_p", 2);
        self.add("vscprintf_p_l", 3);
        self.add("vscwprintf", 2);
        self.add("vscwprintf_l", 3);
        self.add("vscwprintf_p", 2);
        self.add("vscwprintf_p_l", 3);
        self.add("VslCreateSecureSection", 5);
        self.add("VslDeleteSecureSection", 1);
        self.add("vsnprintf", 4);
        self.add("vsnprintf_l", 5);
        self.add("vsnprintf_s", 5);
        self.add("vsnprintf_s_l", 6);
        self.add("vsnwprintf", 4);
        self.add("vsnwprintf_l", 5);
        self.add("vsnwprintf_s", 5);
        self.add("vsnwprintf_s_l", 6);
        self.add("vsprintf", 3);
        self.add("vsprintf_l", 4);
        self.add("vsprintf_p", 4);
        self.add("vsprintf_p_l", 5);
        self.add("vsprintf_s", 4);
        self.add("vsprintf_s_l", 5);
        self.add("VssFreeSnapshotProperties", 1);
        self.add("VssFreeSnapshotPropertiesInternal", 1);
        self.add("vswprintf", 3);
        self.add("vswprintf_l", 5);
        self.add("vswprintf_p", 4);
        self.add("vswprintf_p_l", 5);
        self.add("vswprintf_s", 4);
        self.add("vswprintf_s_l", 5);
        self.add("vwprintf", 2);
        self.add("vwprintf_l", 3);
        self.add("vwprintf_p", 2);
        self.add("vwprintf_p_l", 3);
        self.add("vwprintf_s", 2);
        self.add("vwprintf_s_l", 3);
        self.add("??_V@YAXPAX@Z", 1);
        self.add("??_V@YAXPEAX@Z", 1);
        self.add("WABOpen", 4);
        self.add("WABOpenEx", 7);
        self.add("waccess", 2);
        self.add("waccess_s", 2);
        self.add("WaitCommEvent", 3);
        self.add("WaitForDebugEvent", 2);
        self.add("WaitForInputIdle", 2);
        self.add("WaitForMultipleObjects", 4);
        self.add("WaitForMultipleObjectsEx", 5);
        self.add("WaitForSingleObject", 2);
        self.add("WaitForSingleObjectEx", 3);
        self.add("WaitForThreadpoolIoCallbacks", 2);
        self.add("WaitForThreadpoolTimerCallbacks", 2);
        self.add("WaitForThreadpoolWaitCallbacks", 2);
        self.add("WaitForThreadpoolWorkCallbacks", 2);
        self.add("WaitMessage", 0);
        self.add("WaitMessage", 1);
        self.add("WaitNamedPipe", 2);
        self.add("WaitOnAddress", 4);
        self.add("WakeAllConditionVariable", 1);
        self.add("WakeByAddressAll", 1);
        self.add("WakeByAddressSingle", 1);
        self.add("WakeConditionVariable", 1);
        self.add("wasctime", 1);
        self.add("wasctime_s", 2);
        self.add("waveInAddBuffer", 3);
        self.add("waveInClose", 1);
        self.add("waveInGetDevCaps", 3);
        self.add("waveInGetErrorText", 3);
        self.add("waveInGetID", 2);
        self.add("waveInGetNumDevs", 0);
        self.add("waveInGetPosition", 3);
        self.add("waveInMessage", 4);
        self.add("waveInOpen", 6);
        self.add("waveInPrepareHeader", 3);
        self.add("waveInReset", 1);
        self.add("waveInStart", 1);
        self.add("waveInStop", 1);
        self.add("waveInUnprepareHeader", 3);
        self.add("waveOutBreakLoop", 1);
        self.add("waveOutClose", 1);
        self.add("waveOutGetDevCaps", 3);
        self.add("waveOutGetErrorText", 3);
        self.add("waveOutGetID", 2);
        self.add("waveOutGetNumDevs", 0);
        self.add("waveOutGetPitch", 2);
        self.add("waveOutGetPlaybackRate", 2);
        self.add("waveOutGetPosition", 3);
        self.add("waveOutGetVolume", 2);
        self.add("waveOutMessage", 4);
        self.add("waveOutOpen", 6);
        self.add("waveOutPause", 1);
        self.add("waveOutPrepareHeader", 3);
        self.add("waveOutReset", 1);
        self.add("waveOutRestart", 1);
        self.add("waveOutSetPitch", 2);
        self.add("waveOutSetPlaybackRate", 2);
        self.add("waveOutSetVolume", 2);
        self.add("waveOutUnprepareHeader", 3);
        self.add("waveOutWrite", 3);
        self.add("wchdir", 1);
        self.add("wchmod", 2);
        self.add("WcmFreeMemory", 1);
        self.add("WcmGetProfileList", 2);
        self.add("WcmQueryProperty", 6);
        self.add("WcmSetProfileList", 4);
        self.add("WcmSetProperty", 6);
        self.add("wcreat", 2);
        self.add("wcrtomb", 3);
        self.add("wcrtomb_s", 5);
        self.add("WcsAssociateColorProfileWithDevice", 3);
        self.add("wcscat", 2);
        self.add("wcscat_s", 3);
        self.add("WcsCheckColors", 7);
        self.add("wcschr", 2);
        self.add("wcscmp", 2);
        self.add("wcscoll", 2);
        self.add("wcscoll_l", 3);
        self.add("wcscpy", 2);
        self.add("wcscpy_s", 3);
        self.add("WcsCreateIccProfile", 2);
        self.add("wcscspn", 2);
        self.add("WcsDisassociateColorProfileFromDevice", 3);
        self.add("wcsdup", 1);
        self.add("wcsdup_dbg", 4);
        self.add("WcsEnumColorProfiles", 5);
        self.add("WcsEnumColorProfilesSize", 3);
        self.add("wcserror", 1);
        self.add("wcserror_s", 3);
        self.add("wcsftime", 4);
        self.add("wcsftime_l", 5);
        self.add("WcsGetCalibrationManagementState", 1);
        self.add("WcsGetDefaultColorProfile", 7);
        self.add("WcsGetDefaultColorProfileSize", 6);
        self.add("WcsGetDefaultRenderingIntent", 2);
        self.add("WcsGetUsePerUserProfiles", 3);
        self.add("wcsicmp", 2);
        self.add("wcsicmp_l", 3);
        self.add("wcsicoll", 2);
        self.add("wcsicoll_l", 3);
        self.add("wcslen", 1);
        self.add("wcslwr", 1);
        self.add("wcslwr_l", 2);
        self.add("wcslwr_s", 2);
        self.add("wcslwr_s_l", 3);
        self.add("wcsncat", 3);
        self.add("wcsncat_s", 4);
        self.add("wcsncmp", 3);
        self.add("wcsncnt", 2);
        self.add("wcsncoll", 3);
        self.add("wcsncoll_l", 4);
        self.add("wcsncpy", 3);
        self.add("wcsncpy_s", 4);
        self.add("wcsnicmp", 3);
        self.add("wcsnicmp_l", 4);
        self.add("wcsnicoll", 3);
        self.add("wcsnicoll_l", 4);
        self.add("wcsnlen", 2);
        self.add("wcsnset", 3);
        self.add("wcsnset_s", 4);
        self.add("WcsOpenColorProfile", 7);
        self.add("wcspbrk", 2);
        self.add("wcsrchr", 2);
        self.add("wcsrev", 1);
        self.add("wcsrtombs", 4);
        self.add("wcsrtombs_s", 6);
        self.add("wcsset", 2);
        self.add("WcsSetCalibrationManagementState", 1);
        self.add("WcsSetDefaultColorProfile", 6);
        self.add("WcsSetDefaultRenderingIntent", 2);
        self.add("wcsset_s", 3);
        self.add("WcsSetUsePerUserProfiles", 3);
        self.add("wcsspn", 2);
        self.add("wcsstr", 2);
        self.add("wcstod", 2);
        self.add("wcstod_l", 3);
        self.add("wcstoi64", 3);
        self.add("wcstoi64_l", 4);
        self.add("wcstok", 2);
        self.add("wcstok_s", 3);
        self.add("wcstol", 3);
        self.add("wcstol_l", 4);
        self.add("wcstombs", 3);
        self.add("wcstombs_l", 4);
        self.add("wcstombs_s", 5);
        self.add("wcstombs_s_l", 6);
        self.add("wcstoui64", 3);
        self.add("wcstoui64_l", 4);
        self.add("wcstoul", 3);
        self.add("wcstoul_l", 4);
        self.add("WcsTranslateColors", 10);
        self.add("wcsupr", 1);
        self.add("wcsupr_l", 2);
        self.add("wcsupr_s", 2);
        self.add("wcsupr_s_l", 3);
        self.add("wcsxfrm", 3);
        self.add("wcsxfrm_l", 4);
        self.add("wctime", 1);
        self.add("wctime32", 1);
        self.add("wctime32_s", 3);
        self.add("wctime64", 1);
        self.add("wctime64_s", 3);
        self.add("wctob", 1);
        self.add("wctomb", 2);
        self.add("wctomb_l", 3);
        self.add("wctomb_s", 4);
        self.add("wctomb_s_l", 5);
        self.add("wctype", 1);
        self.add("WdsBpAddOption", 4);
        self.add("WdsBpCloseHandle", 1);
        self.add("WdsBpGetOptionBuffer", 4);
        self.add("WdsBpInitialize", 2);
        self.add("WdsBpParseInitialize", 4);
        self.add("WdsBpParseInitializev6", 4);
        self.add("WdsBpQueryOption", 5);
        self.add("WdsCliAuthorizeSession", 2);
        self.add("WdsCliCancelTransfer", 1);
        self.add("WdsCliClose", 1);
        self.add("WdsCliCreateSession", 3);
        self.add("WdsCliFindFirstImage", 2);
        self.add("WdsCliFindNextImage", 1);
        self.add("WdsCliFreeStringArray", 2);
        self.add("WdsCliGetDriverQueryXml", 2);
        self.add("WdsCliGetEnumerationFlags", 2);
        self.add("WdsCliGetImageArchitecture", 2);
        self.add("WdsCliGetImageDescription", 2);
        self.add("WdsCliGetImageGroup", 2);
        self.add("WdsCliGetImageHalName", 2);
        self.add("WdsCliGetImageHandleFromFindHandle", 2);
        self.add("WdsCliGetImageHandleFromTransferHandle", 2);
        self.add("WdsCliGetImageIndex", 2);
        self.add("WdsCliGetImageLanguage", 2);
        self.add("WdsCliGetImageLanguages", 3);
        self.add("WdsCliGetImageLastModifiedTime", 2);
        self.add("WdsCliGetImageName", 2);
        self.add("WdsCliGetImageNamespace", 2);
        self.add("WdsCliGetImagePath", 2);
        self.add("WdsCliGetImageSize", 2);
        self.add("WdsCliGetImageVersion", 2);
        self.add("WdsCliGetTransferSize", 2);
        self.add("WdsCliInitializeLog", 4);
        self.add("WdsCliLog", 3);
        self.add("WdsCliObtainDriverPackages", 4);
        self.add("WdsCliObtainDriverPackagesEx", 5);
        self.add("WdsCliRegisterTrace", 1);
        self.add("WdsCliTransferFile", 9);
        self.add("WdsCliTransferImage", 7);
        self.add("WdsCliWaitForTransfer", 1);
        self.add("WdsTransportClientAddRefBuffer", 1);
        self.add("WdsTransportClientCancelSession", 1);
        self.add("WdsTransportClientCloseSession", 1);
        self.add("WdsTransportClientCompleteReceive", 3);
        self.add("WdsTransportClientInitialize", 0);
        self.add("WdsTransportClientInitializeSession", 3);
        self.add("WdsTransportClientQueryStatus", 3);
        self.add("WdsTransportClientRegisterCallback", 3);
        self.add("WdsTransportClientReleaseBuffer", 1);
        self.add("WdsTransportClientShutdown", 0);
        self.add("WdsTransportClientStartSession", 1);
        self.add("WdsTransportClientWaitForCompletion", 2);
        self.add("WdsTransportServerAllocateBuffer", 2);
        self.add("WdsTransportServerCompleteRead", 4);
        self.add("WdsTransportServerFreeBuffer", 2);
        self.add("WdsTransportServerRegisterCallback", 3);
        self.add("WdsTransportServerTrace", 3);
        self.add("WdsTransportServerTraceV", 4);
        self.add("wdupenv_s", 3);
        self.add("wdupenv_s_dbg", 6);
        self.add("WebSocketAbortHandle", 1);
        self.add("WebSocketBeginClientHandshake", 9);
        self.add("WebSocketBeginServerHandshake", 8);
        self.add("WebSocketCompleteAction", 3);
        self.add("WebSocketCreateClientHandle", 3);
        self.add("WebSocketCreateServerHandle", 3);
        self.add("WebSocketDeleteHandle", 1);
        self.add("WebSocketEndClientHandshake", 6);
        self.add("WebSocketEndServerHandshake", 1);
        self.add("WebSocketGetAction", 8);
        self.add("WebSocketGetGlobalProperty", 3);
        self.add("WebSocketReceive", 3);
        self.add("WebSocketSend", 4);
        self.add("WerAddExcludedApplication", 2);
        self.add("WerGetFlags", 2);
        self.add("WerRegisterFile", 3);
        self.add("WerRegisterMemoryBlock", 2);
        self.add("WerRegisterRuntimeExceptionModule", 2);
        self.add("WerRemoveExcludedApplication", 2);
        self.add("WerReportAddDump", 7);
        self.add("WerReportAddFile", 4);
        self.add("WerReportCloseHandle", 1);
        self.add("WerReportCreate", 4);
        self.add("WerReportHang", 2);
        self.add("WerReportSetParameter", 4);
        self.add("WerReportSetUIOption", 3);
        self.add("WerReportSubmit", 4);
        self.add("WerSetFlags", 1);
        self.add("WerUnregisterFile", 1);
        self.add("WerUnregisterMemoryBlock", 1);
        self.add("WerUnregisterRuntimeExceptionModule", 2);
        self.add("wexecl", 2);
        self.add("wexecle", 2);
        self.add("wexeclp", 2);
        self.add("wexeclpe", 2);
        self.add("wexecv", 2);
        self.add("wexecve", 3);
        self.add("wexecvp", 2);
        self.add("wexecvpe", 3);
        self.add("WFDCancelOpenSession", 1);
        self.add("WFDCloseHandle", 1);
        self.add("WFDCloseSession", 1);
        self.add("wfdopen", 2);
        self.add("WFDOpenHandle", 3);
        self.add("WFDOpenLegacySession", 4);
        self.add("WFDStartOpenSession", 5);
        self.add("WFDUpdateDeviceVisibility", 1);
        self.add("wfindfirst", 2);
        self.add("wfindfirst32", 2);
        self.add("wfindfirst32i64", 2);
        self.add("wfindfirst64", 2);
        self.add("wfindfirst64i32", 2);
        self.add("wfindfirsti64", 2);
        self.add("wfindnext", 2);
        self.add("wfindnext32", 2);
        self.add("wfindnext32i64", 2);
        self.add("wfindnext64", 2);
        self.add("wfindnext64i32", 2);
        self.add("wfindnexti64", 2);
        self.add("wfopen", 2);
        self.add("wfopen_s", 3);
        self.add("wfreopen", 3);
        self.add("wfreopen_s", 4);
        self.add("wfsopen", 3);
        self.add("wfullpath", 3);
        self.add("wfullpath_dbg", 6);
        self.add("wgetcwd", 2);
        self.add("wgetcwd_dbg", 5);
        self.add("wgetdcwd", 3);
        self.add("wgetdcwd_dbg", 6);
        self.add("wgetdcwd_nolock", 3);
        self.add("wgetenv", 1);
        self.add("wgetenv_s", 4);
        self.add("wgetmainargs", 5);
        self.add("wglCopyContext", 3);
        self.add("wglCreateContext", 1);
        self.add("wglCreateLayerContext", 2);
        self.add("wglDeleteContext", 1);
        self.add("wglDescribeLayerPlane", 5);
        self.add("wglGetCurrentContext", 0);
        self.add("wglGetCurrentDC", 0);
        self.add("wglGetLayerPaletteEntries", 5);
        self.add("wglGetProcAddress", 1);
        self.add("wglMakeCurrent", 2);
        self.add("wglRealizeLayerPalette", 3);
        self.add("wglSetLayerPaletteEntries", 5);
        self.add("wglShareLists", 2);
        self.add("wglSwapLayerBuffers", 2);
        self.add("wglUseFontBitmaps", 4);
        self.add("wglUseFontOutlines", 8);
        self.add("WhichPlatform", 0);
        self.add("WhichPlatform", 1);
        self.add("WideCharToMultiByte", 8);
        self.add("WidenPath", 1);
        self.add("Win32DeleteFile", 1);
        self.add("WinBioAcquireFocus", 0);
        self.add("WinBioAsyncEnumBiometricUnits", 2);
        self.add("WinBioAsyncEnumDatabases", 2);
        self.add("WinBioAsyncEnumServiceProviders", 2);
        self.add("WinBioAsyncMonitorFrameworkChanges", 2);
        self.add("WinBioAsyncOpenFramework", 7);
        self.add("WinBioAsyncOpenSession", 13);
        self.add("WinBioCancel", 1);
        self.add("WinBioCaptureSample", 7);
        self.add("WinBioCaptureSampleWithCallback", 5);
        self.add("WinBioCloseFramework", 1);
        self.add("WinBioCloseSession", 1);
        self.add("WinBioControlUnit", 10);
        self.add("WinBioControlUnitPrivileged", 10);
        self.add("WinBioDeleteTemplate", 4);
        self.add("WinBioEnrollBegin", 3);
        self.add("WinBioEnrollCapture", 2);
        self.add("WinBioEnrollCaptureWithCallback", 3);
        self.add("WinBioEnrollCommit", 3);
        self.add("WinBioEnrollDiscard", 1);
        self.add("WinBioEnumBiometricUnits", 3);
        self.add("WinBioEnumDatabases", 3);
        self.add("WinBioEnumEnrollments", 5);
        self.add("WinBioEnumServiceProviders", 3);
        self.add("WinBioFree", 1);
        self.add("WinBioGetCredentialState", 3);
        self.add("WinBioGetDomainLogonSetting", 2);
        self.add("WinBioGetEnabledSetting", 2);
        self.add("WinBioGetLogonSetting", 2);
        self.add("WinBioGetProperty", 8);
        self.add("WinBioIdentify", 5);
        self.add("WinBioIdentifyWithCallback", 3);
        self.add("WinBioLocateSensor", 2);
        self.add("WinBioLocateSensorWithCallback", 3);
        self.add("WinBioLockUnit", 2);
        self.add("WinBioLogonIdentifiedUser", 1);
        self.add("WinBioOpenSession", 7);
        self.add("WinBioRegisterEventMonitor", 4);
        self.add("WinBioReleaseFocus", 0);
        self.add("WinBioRemoveAllCredentials", 0);
        self.add("WinBioRemoveAllDomainCredentials", 0);
        self.add("WinBioRemoveCredential", 2);
        self.add("WinBioSetCredential", 4);
        self.add("WinBioUnlockUnit", 2);
        self.add("WinBioUnregisterEventMonitor", 1);
        self.add("WinBioVerify", 6);
        self.add("WinBioVerifyWithCallback", 5);
        self.add("WinBioWait", 1);
        self.add("WindowFromAccessibleObject", 2);
        self.add("WindowFromDC", 1);
        self.add("WindowFromPhysicalPoint", 1);
        self.add("WindowFromPoint", 1);
        self.add("WindowsCompareStringOrdinal", 3);
        self.add("WindowsConcatString", 3);
        self.add("WindowsCreateString", 3);
        self.add("WindowsCreateStringReference", 4);
        self.add("WindowsDeleteString", 1);
        self.add("WindowsDeleteStringBuffer", 1);
        self.add("WindowsDuplicateString", 2);
        self.add("WindowsGetStringLen", 1);
        self.add("WindowsGetStringRawBuffer", 2);
        self.add("WindowsInspectString", 6);
        self.add("WindowsIsStringEmpty", 1);
        self.add("WindowsPreallocateStringBuffer", 3);
        self.add("WindowsPromoteStringBuffer", 2);
        self.add("WindowsReplaceString", 4);
        self.add("WindowsStringHasEmbeddedNull", 2);
        self.add("WindowsSubstring", 3);
        self.add("WindowsSubstringWithSpecifiedLength", 4);
        self.add("WindowsTrimStringEnd", 3);
        self.add("WindowsTrimStringStart", 3);
        self.add("WinExec", 2);
        self.add("WinHelp", 4);
        self.add("WinHttpAddRequestHeaders", 4);
        self.add("WinHttpAddRequestHeadersEx", 6);
        self.add("WinHttpCheckPlatform", 0);
        self.add("WinHttpCheckPlatform", 1);
        self.add("WinHttpCloseHandle", 1);
        self.add("WinHttpConnect", 4);
        self.add("WinHttpCrackUrl", 4);
        self.add("WinHttpCreateProxyResolver", 2);
        self.add("WinHttpCreateUrl", 4);
        self.add("WinHttpDetectAutoProxyConfigUrl", 2);
        self.add("WinHttpFreeProxyResult", 1);
        self.add("WinHttpFreeProxySettingsEx", 2);
            self.add("WinHttpFreeQueryConnectionGroupResult", 1);
            self.add("WinHttpGetDefaultProxyConfiguration", 1);
        self.add("WinHttpGetDefaultProxyConfiguration", 1);
            self.add("WinHttpGetIEProxyConfigForCurrentUser", 1);
        self.add("WinHttpGetIEProxyConfigForCurrentUser", 1);
        self.add("WinHttpGetProxyForUrl", 4);
        self.add("WinHttpGetProxyForUrlEx", 4);
        self.add("WinHttpGetProxyResult", 2);
        self.add("WinHttpGetProxySettingsEx", 4);
        self.add("WinHttpGetProxySettingsResultEx", 2);
        self.add("WinHttpOpen", 5);
        self.add("WinHttpOpenRequest", 7);
        self.add("WinhttpProxyChangeCallback", 2);
        self.add("WinHttpQueryAuthSchemes", 4);
        self.add("WinHttpQueryConnectionGroup", 4);
        self.add("WinHttpQueryDataAvailable", 2);
        self.add("WinHttpQueryHeaders", 6);
        self.add("WinHttpQueryHeadersEx", 10);
        self.add("WinHttpQueryOption", 4);
        self.add("WinHttpReadData", 4);
        self.add("WinHttpReadDataEx", 7);
        self.add("WinHttpReceiveResponse", 2);
            self.add("WinHttpRegisterProxyChangeNotification", 4);
        self.add("WinHttpResetAutoProxy", 2);
        self.add("WinHttpSendRequest", 7);
        self.add("WinHttpSetCredentials", 6);
            self.add("WinHttpSetDefaultProxyConfiguration", 1);
        self.add("WinHttpSetDefaultProxyConfiguration", 1);
        self.add("WinHttpSetOption", 4);
        self.add("WinHttpSetStatusCallback", 4);
        self.add("WinHttpSetTimeouts", 5);
        self.add("WinhttpStatusCallback", 5);
        self.add("WinHttpTimeFromSystemTime", 2);
        self.add("WinHttpTimeToSystemTime", 2);
            self.add("WinHttpUnregisterProxyChangeNotification", 1);
        self.add("WinHttpWebSocketClose", 4);
        self.add("WinHttpWebSocketCompleteUpgrade", 2);
            self.add("WinHttpWebSocketQueryCloseStatus", 5);
        self.add("WinHttpWebSocketQueryCloseStatus", 5);
        self.add("WinHttpWebSocketReceive", 5);
        self.add("WinHttpWebSocketSend", 4);
        self.add("WinHttpWebSocketShutdown", 4);
        self.add("WinHttpWriteData", 4);
        self.add("WintrustAddActionID", 3);
        self.add("WintrustGetRegPolicyFlags", 1);
        self.add("WintrustLoadFunctionPointers", 2);
        self.add("WintrustRemoveActionID", 1);
        self.add("WintrustSetDefaultIncludePEPageHashes", 1);
        self.add("WintrustSetRegPolicyFlags", 1);
        self.add("WinUsb_AbortPipe", 2);
        self.add("WinUsb_ControlTransfer", 6);
        self.add("WinUsb_FlushPipe", 2);
        self.add("WinUsb_Free", 1);
        self.add("WinUsb_GetAssociatedInterface", 3);
        self.add("WinUsb_GetCurrentAlternateSetting", 2);
        self.add("WinUsb_GetDescriptor", 7);
        self.add("WinUsb_GetOverlappedResult", 4);
        self.add("WinUsb_GetPipePolicy", 5);
        self.add("WinUsb_GetPowerPolicy", 4);
        self.add("WinUsb_Initialize", 2);
        self.add("WinUsb_ParseConfigurationDescriptor", 7);
        self.add("WinUsb_ParseDescriptors", 4);
        self.add("WinUsb_QueryDeviceInformation", 4);
        self.add("WinUsb_QueryInterfaceSettings", 3);
        self.add("WinUsb_QueryPipe", 4);
        self.add("WinUsb_ReadPipe", 6);
        self.add("WinUsb_ResetPipe", 2);
        self.add("WinUsb_SetCurrentAlternateSetting", 2);
        self.add("WinUsb_SetPipePolicy", 5);
        self.add("WinUsb_SetPowerPolicy", 4);
        self.add("WinUsb_WritePipe", 6);
        self.add("WinVerifyTrust", 3);
        self.add("WinVerifyTrustEx", 3);
        self.add("WlanAllocateMemory", 1);
        self.add("WlanCloseHandle", 2);
        self.add("WlanConnect", 4);
        self.add("WlanDeleteProfile", 4);
        self.add("WlanDisconnect", 3);
        self.add("WlanEnumInterfaces", 3);
        self.add("WlanExtractPsdIEDataList", 6);
        self.add("WlanFreeMemory", 1);
        self.add("WlanGetAvailableNetworkList", 5);
        self.add("WlanGetFilterList", 4);
        self.add("WlanGetInterfaceCapability", 4);
        self.add("WlanGetNetworkBssList", 7);
        self.add("WlanGetProfile", 7);
        self.add("WlanGetProfileCustomUserData", 6);
        self.add("WlanGetProfileList", 4);
        self.add("WlanGetSecuritySettings", 5);
        self.add("WlanHostedNetworkForceStart", 3);
        self.add("WlanHostedNetworkForceStop", 3);
        self.add("WlanHostedNetworkInitSettings", 3);
        self.add("WlanHostedNetworkQueryProperty", 6);
        self.add("WlanHostedNetworkQuerySecondaryKey", 7);
        self.add("WlanHostedNetworkQueryStatus", 3);
        self.add("WlanHostedNetworkRefreshSecuritySettings", 3);
        self.add("WlanHostedNetworkSetProperty", 6);
        self.add("WlanHostedNetworkSetSecondaryKey", 7);
        self.add("WlanHostedNetworkStartUsing", 3);
        self.add("WlanHostedNetworkStopUsing", 3);
        self.add("WlanIhvControl", 8);
        self.add("WlanOpenHandle", 4);
        self.add("WlanQueryAutoConfigParameter", 6);
        self.add("WlanQueryInterface", 7);
        self.add("WlanReasonCodeToString", 4);
        self.add("WlanRegisterNotification", 7);
        self.add("WlanRegisterVirtualStationNotification", 3);
        self.add("WlanRenameProfile", 5);
        self.add("WlanSaveTemporaryProfile", 7);
        self.add("WlanScan", 5);
        self.add("WlanSetAutoConfigParameter", 5);
        self.add("WlanSetFilterList", 4);
        self.add("WlanSetInterface", 6);
        self.add("WlanSetProfile", 8);
        self.add("WlanSetProfileCustomUserData", 6);
        self.add("WlanSetProfileEapUserData", 8);
        self.add("WlanSetProfileEapXmlUserData", 6);
        self.add("WlanSetProfileList", 5);
        self.add("WlanSetProfilePosition", 5);
        self.add("WlanSetPsdIEDataList", 4);
        self.add("WlanSetSecuritySettings", 3);
        self.add("WlanUIEditProfile", 7);
        self.add("wmakepath", 5);
        self.add("wmakepath_s", 6);
        self.add("wmemcpy_s", 4);
        self.add("wmemmove_s", 4);
        self.add("WmiQueryTraceInformation", 5);
        self.add("WmiTraceMessage", 5);
        self.add("WmiTraceMessageVa", 5);
        self.add("wmkdir", 1);
        self.add("wmktemp", 1);
        self.add("wmktemp_s", 2);
        self.add("Wndproc", 4);
        self.add("WNetAddConnection2", 4);
        self.add("WNetAddConnection", 3);
        self.add("WNetAddConnection3", 5);
        self.add("WNetCancelConnection", 2);
        self.add("WNetCancelConnection2", 3);
        self.add("WNetCloseEnum", 1);
        self.add("WNetConnectionDialog1", 1);
        self.add("WNetConnectionDialog", 2);
        self.add("WNetDisconnectDialog1", 1);
        self.add("WNetDisconnectDialog", 2);
        self.add("WNetEnumResource", 4);
        self.add("WNetGetConnection", 3);
        self.add("WNetGetLastError", 5);
        self.add("WNetGetNetworkInformation", 2);
        self.add("WNetGetProviderName", 3);
        self.add("WNetGetResourceInformation", 4);
        self.add("WNetGetResourceParent", 3);
        self.add("WNetGetUniversalName", 4);
        self.add("WNetGetUser", 3);
        self.add("WNetOpenEnum", 5);
        self.add("WNetRestoreConnectionW", 3);
        self.add("WNetSetLastError", 3);
        self.add("WNetUseConnection", 8);
        self.add("wnsprintf", 3);
        self.add("wnsprintfA", 4);
        self.add("wnsprintfW", 4);
        self.add("wopen", 3);
        self.add("Wow64DisableWow64FsRedirection", 1);
        self.add("Wow64EnableWow64FsRedirection", 1);
        self.add("Wow64GetThreadContext", 2);
        self.add("Wow64GetThreadSelectorEntry", 3);
        self.add("Wow64RevertWow64FsRedirection", 1);
        self.add("Wow64SetThreadContext", 2);
        self.add("Wow64SuspendThread", 1);
        self.add("WOWShellExecute", 7);
        self.add("wperror", 1);
        self.add("wpopen", 2);
        self.add("wprintf", 1);
        self.add("wprintf_l", 2);
        self.add("wprintf_p", 1);
        self.add("wprintf_p_l", 2);
        self.add("wprintf_s", 1);
        self.add("wprintf_s_l", 2);
        self.add("WPUGetQOSTemplate", 3);
        self.add("wputenv", 1);
        self.add("wputenv_s", 2);
        self.add("WrapCompressedRTFStream", 3);
        self.add("WrapStoreEntryID", 6);
        self.add("wremove", 1);
        self.add("wrename", 2);
        self.add("write", 3);
        self.add("WriteCabinetState", 1);
        self.add("WriteClassStg", 2);
        self.add("WriteClassStm", 2);
        self.add("WriteConsole", 5);
        self.add("WriteConsoleInput", 4);
        self.add("WriteConsoleOutput", 5);
        self.add("WriteConsoleOutputAttribute", 5);
        self.add("WriteConsoleOutputCharacter", 5);
        self.add("WriteEncryptedFileRaw", 3);
        self.add("WriteFile", 5);
        self.add("WriteFileEx", 5);
        self.add("WriteFileGather", 5);
        self.add("WriteFmtUserTypeStg", 3);
        self.add("WriteGlobalPwrPolicy", 1);
        self.add("WriteInt32NoFence", 2);
        self.add("WriteInt32Raw", 2);
        self.add("WriteInt32Release", 2);
        self.add("WriteLogRestartArea", 8);
        self.add("WRITE_PORT_BUFFER_UCHAR", 3);
        self.add("WRITE_PORT_BUFFER_ULONG", 3);
        self.add("WRITE_PORT_BUFFER_USHORT", 3);
        self.add("WRITE_PORT_UCHAR", 2);
        self.add("WRITE_PORT_ULONG", 2);
        self.add("WRITE_PORT_USHORT", 2);
        self.add("WritePrinter", 4);
        self.add("WritePrivateProfileSection", 3);
        self.add("WritePrivateProfileString", 4);
        self.add("WritePrivateProfileStruct", 5);
        self.add("WriteProcessMemory", 5);
        self.add("WriteProcessorPwrScheme", 2);
        self.add("WriteProfileSection", 2);
        self.add("WriteProfileString", 3);
        self.add("WritePwrScheme", 4);
        self.add("WRITE_REGISTER_BUFFER_UCHAR", 3);
        self.add("WRITE_REGISTER_BUFFER_ULONG", 3);
        self.add("WRITE_REGISTER_BUFFER_ULONG64", 3);
        self.add("WRITE_REGISTER_BUFFER_USHORT", 3);
        self.add("WRITE_REGISTER_UCHAR", 2);
        self.add("WRITE_REGISTER_ULONG", 2);
        self.add("WRITE_REGISTER_ULONG64", 2);
        self.add("WRITE_REGISTER_USHORT", 2);
        self.add("WriteTapemark", 4);
        self.add("WriteUInt32NoFence", 2);
        self.add("WriteUInt32Raw", 2);
        self.add("WriteUInt32Release", 2);
        self.add("wrmdir", 1);
        self.add("WSAAccept", 5);
        self.add("WSAAddressToString", 5);
        self.add("WSAAddressToStringA", 5);
        self.add("WSAAddressToStringW", 5);
        self.add("WSAAsyncGetHostByAddr", 7);
        self.add("WSAAsyncGetHostByName", 5);
        self.add("WSAAsyncGetProtoByName", 5);
        self.add("WSAAsyncGetProtoByNumber", 5);
        self.add("WSAAsyncGetServByName", 6);
        self.add("WSAAsyncGetServByPort", 6);
        self.add("WSAAsyncSelect", 4);
        self.add("WSACancelAsyncRequest", 1);
        self.add("WSACancelBlockingCall", 1);
        self.add("WSACleanup", 0);
        self.add("WSACleanup", 1);
        self.add("WSACloseEvent", 1);
        self.add("WSAConnect", 7);
        self.add("WSAConnectByList", 8);
        self.add("WSAConnectByName", 9);
        self.add("WSAConnectByNameA", 9);
        self.add("WSAConnectByNameW", 9);
        self.add("WSACreateEvent", 0);
        self.add("WSACreateEvent", 1);
        self.add("WSADeleteSocketPeerTargetName", 5);
        self.add("WSADuplicateSocket", 3);
        self.add("WSADuplicateSocketA", 3);
        self.add("WSADuplicateSocketW", 3);
        self.add("WSAEnumNameSpaceProviders", 2);
        self.add("WSAEnumNameSpaceProvidersA", 2);
        self.add("WSAEnumNameSpaceProvidersEx", 2);
        self.add("WSAEnumNameSpaceProvidersExA", 2);
        self.add("WSAEnumNameSpaceProvidersExW", 2);
        self.add("WSAEnumNameSpaceProvidersW", 2);
        self.add("WSAEnumNetworkEvents", 3);
        self.add("WSAEnumProtocols", 3);
        self.add("WSAEnumProtocolsA", 3);
        self.add("WSAEnumProtocolsW", 3);
        self.add("WSAEventSelect", 3);
        self.add("__WSAFDIsSet", 2);
        self.add("WSAGetLastError", 0);
        self.add("WSAGetLastError", 1);
        self.add("WSAGetOverlappedResult", 5);
        self.add("WSAGetQOSByName", 3);
        self.add("WSAGetServiceClassInfo", 4);
        self.add("WSAGetServiceClassInfoA", 4);
        self.add("WSAGetServiceClassInfoW", 4);
        self.add("WSAGetServiceClassNameByClassId", 3);
            self.add("WSAGetServiceClassNameByClassIdA", 3);
            self.add("WSAGetServiceClassNameByClassIdW", 3);
        self.add("WSAHtonl", 3);
        self.add("WSAHtons", 3);
        self.add("WSAImpersonateSocketPeer", 3);
        self.add("WSAInstallServiceClass", 1);
        self.add("WSAInstallServiceClassA", 1);
        self.add("WSAInstallServiceClassW", 1);
        self.add("WSAIoctl", 9);
        self.add("WSAIsBlocking", 0);
        self.add("WSAIsBlocking", 1);
        self.add("WSAJoinLeaf", 8);
        self.add("WSALookupServiceBegin", 3);
        self.add("WSALookupServiceBeginA", 3);
        self.add("WSALookupServiceBeginW", 3);
        self.add("WSALookupServiceEnd", 1);
        self.add("WSALookupServiceNext", 4);
        self.add("WSALookupServiceNextA", 4);
        self.add("WSALookupServiceNextW", 4);
        self.add("WSANSPIoctl", 8);
        self.add("WSANtohl", 3);
        self.add("WSANtohs", 3);
        self.add("WSAPoll", 2);
        self.add("WSAPoll", 3);
        self.add("WSAProviderConfigChange", 3);
        self.add("WSAQuerySocketSecurity", 7);
        self.add("WSARecv", 7);
        self.add("WSARecvDisconnect", 2);
        self.add("WSARecvEx", 4);
        self.add("WSARecvFrom", 9);
        self.add("WSARemoveServiceClass", 1);
        self.add("WSAResetEvent", 1);
        self.add("WSARevertImpersonation", 0);
        self.add("WSASend", 7);
        self.add("WSASendDisconnect", 2);
        self.add("WSASendMsg", 6);
        self.add("WSASendTo", 9);
        self.add("WSASetBlockingHook", 1);
        self.add("WSASetEvent", 1);
        self.add("WSASetLastError", 1);
        self.add("WSASetService", 3);
        self.add("WSASetServiceA", 3);
        self.add("WSASetServiceW", 3);
        self.add("WSASetSocketPeerTargetName", 5);
        self.add("WSASetSocketSecurity", 5);
        self.add("WSASocket", 6);
        self.add("WSASocketA", 6);
        self.add("WSASocketW", 6);
        self.add("WSAStartup", 2);
        self.add("WSAStringToAddress", 5);
        self.add("WSAStringToAddressA", 5);
        self.add("WSAStringToAddressW", 5);
        self.add("WSAUnhookBlockingHook", 1);
        self.add("WSAWaitForMultipleEvents", 5);
        self.add("wscanf", 1);
        self.add("wscanf_l", 2);
        self.add("wscanf_s", 1);
        self.add("wscanf_s_l", 2);
        self.add("WSCInstallQOSTemplate", 3);
        self.add("WSCRemoveQOSTemplate", 2);
        self.add("WSDAllocateLinkedMemory", 2);
        self.add("WSDAttachLinkedMemory", 2);
        self.add("WSDCreateDeviceHost", 3);
        self.add("WSDCreateDeviceHostAdvanced", 5);
        self.add("WSDCreateDeviceProxy", 4);
        self.add("WSDCreateDeviceProxyAdvanced", 5);
        self.add("WSDCreateDiscoveryProvider", 2);
        self.add("WSDCreateDiscoveryProvider2", 4);
        self.add("WSDCreateDiscoveryPublisher", 2);
        self.add("WSDCreateDiscoveryPublisher2", 4);
        self.add("WSDCreateHttpAddress", 1);
        self.add("WSDCreateHttpMessageParameters", 1);
        self.add("WSDCreateOutboundAttachment", 1);
        self.add("WSDCreateUdpAddress", 1);
        self.add("WSDCreateUdpMessageParameters", 1);
        self.add("WSDDetachLinkedMemory", 1);
        self.add("WSDFreeLinkedMemory", 1);
        self.add("WSDGenerateFault", 6);
        self.add("WSDGenerateFaultEx", 5);
        self.add("WSDGetConfigurationOption", 3);
        self.add("WSDSetConfigurationOption", 3);
        self.add("WSDUriDecode", 4);
        self.add("WSDUriEncode", 4);
        self.add("WSDXMLAddChild", 2);
        self.add("WSDXMLAddSibling", 2);
        self.add("WSDXMLBuildAnyForSingleElement", 3);
        self.add("WSDXMLCleanupElement", 1);
        self.add("WSDXMLCreateContext", 1);
        self.add("WSDXMLGetNameFromBuiltinNamespace", 3);
        self.add("WSDXMLGetValueFromAny", 4);
        self.add("wsearchenv", 3);
        self.add("wsearchenv_s", 4);
        self.add("wsetlocale", 2);
        self.add("WSManCloseCommand", 3);
        self.add("WSManCloseOperation", 2);
        self.add("WSManCloseSession", 2);
        self.add("WSManCloseShell", 3);
        self.add("WSManConnectShell", 8);
        self.add("WSManConnectShellCommand", 7);
        self.add("WSManCreateSession", 6);
        self.add("WSManCreateShell", 8);
        self.add("WSManCreateShellEx", 9);
        self.add("WSManDeinitialize", 2);
        self.add("WSManDisconnectShell", 4);
        self.add("WSManGetErrorMessage", 7);
        self.add("WSManGetSessionOptionAsDword", 3);
        self.add("WSManGetSessionOptionAsString", 5);
        self.add("WSManInitialize", 2);
        self.add("WSManReceiveShellOutput", 6);
        self.add("WSManReconnectShell", 3);
        self.add("WSManReconnectShellCommand", 3);
        self.add("WSManRunShellCommand", 7);
        self.add("WSManRunShellCommandEx", 8);
        self.add("WSManSendShellInput", 8);
        self.add("WSManSetSessionOption", 3);
        self.add("WSManSignalShell", 6);
        self.add("wsopen", 4);
        self.add("wsopen_s", 5);
        self.add("wspawnl", 3);
        self.add("wspawnle", 3);
        self.add("wspawnlp", 3);
        self.add("wspawnlpe", 3);
        self.add("wspawnv", 3);
        self.add("wspawnve", 4);
        self.add("wspawnvp", 3);
        self.add("wspawnvpe", 4);
        self.add("wsplitpath", 5);
        self.add("wsplitpath_s", 9);
        self.add("wsprintf", 2);
        self.add("wstat", 2);
        self.add("wstat32", 2);
        self.add("wstat32i64", 2);
        self.add("wstat64", 2);
        self.add("wstat64i32", 2);
        self.add("wstati64", 2);
        self.add("wstrdate", 1);
        self.add("wstrdate_s", 2);
        self.add("wstrtime", 1);
        self.add("wstrtime_s", 2);
        self.add("wsystem", 1);
        self.add("wtempnam", 2);
        self.add("wtempnam_dbg", 5);
        self.add("WTHelperCertCheckValidSignature", 1);
        self.add("WTHelperCertFindIssuerCertificate", 7);
        self.add("WTHelperCertIsSelfSigned", 2);
        self.add("WTHelperGetFileHash", 6);
        self.add("WTHelperGetProvCertFromChain", 2);
        self.add("WTHelperGetProvPrivateDataFromChain", 2);
        self.add("WTHelperGetProvSignerFromChain", 4);
        self.add("WTHelperProvDataFromStateData", 1);
        self.add("wtmpnam", 1);
        self.add("wtmpnam_s", 2);
        self.add("wtof", 1);
        self.add("wtof_l", 2);
        self.add("wtoi", 1);
        self.add("wtoi64", 1);
        self.add("wtoi64_l", 2);
        self.add("wtoi_l", 2);
        self.add("wtol", 1);
        self.add("wtol_l", 2);
        self.add("WTSCloseServer", 1);
        self.add("WTSConnectSession", 4);
        self.add("WTSCreateListener", 6);
        self.add("WTSDisconnectSession", 3);
        self.add("WTSEnableChildSessions", 1);
        self.add("WTSEnumerateListeners", 5);
        self.add("WTSEnumerateProcesses", 5);
        self.add("WTSEnumerateProcessesEx", 5);
        self.add("WTSEnumerateServers", 5);
        self.add("WTSEnumerateSessions", 5);
        self.add("WTSEnumerateSessionsEx", 5);
        self.add("WTSFreeMemory", 1);
        self.add("WTSFreeMemoryEx", 3);
        self.add("WTSGetActiveConsoleSessionId", 0);
        self.add("WTSGetChildSessionId", 1);
        self.add("WTSGetListenerSecurity", 8);
        self.add("WTSIsChildSessionsEnabled", 1);
        self.add("WTSLogoffSession", 3);
        self.add("WTSOpenServer", 1);
        self.add("WTSOpenServerEx", 1);
        self.add("WTSQueryListenerConfig", 5);
        self.add("WTSQuerySessionInformation", 5);
        self.add("WTSQueryUserConfig", 5);
        self.add("WTSQueryUserToken", 2);
        self.add("WTSRegisterSessionNotification", 2);
        self.add("WTSRegisterSessionNotificationEx", 3);
        self.add("WTSSendMessage", 10);
        self.add("WTSSetListenerSecurity", 6);
        self.add("WTSSetRenderHint", 5);
        self.add("WTSSetUserConfig", 5);
        self.add("WTSShutdownSystem", 2);
        self.add("WTSStartRemoteControlSession", 4);
        self.add("WTSStopRemoteControlSession", 1);
        self.add("WTSTerminateProcess", 3);
        self.add("WTSUnRegisterSessionNotification", 1);
        self.add("WTSUnRegisterSessionNotificationEx", 2);
        self.add("WTSVirtualChannelClose", 1);
        self.add("WTSVirtualChannelOpen", 3);
        self.add("WTSVirtualChannelOpenEx", 3);
        self.add("WTSVirtualChannelPurgeInput", 1);
        self.add("WTSVirtualChannelPurgeOutput", 1);
        self.add("WTSVirtualChannelQuery", 4);
        self.add("WTSVirtualChannelRead", 5);
        self.add("WTSVirtualChannelWrite", 4);
        self.add("WTSWaitSystemEvent", 3);
        self.add("wunlink", 1);
        self.add("wutime", 2);
        self.add("wutime32", 2);
        self.add("wutime64", 2);
        self.add("wvnsprintf", 4);
        self.add("wvnsprintfA", 4);
        self.add("wvnsprintfW", 4);
        self.add("wvsprintf", 3);
        self.add("XcptFilter", 2);
        self.add("XPProviderInit", 9);
        self.add("y0", 1);
        self.add("y1", 1);
        self.add("yn", 2);
        self.add("ZombifyActCtx", 1);
        self.add("ZwClose", 1);
        self.add("ZwCommitComplete", 2);
        self.add("ZwCommitEnlistment", 2);
        self.add("ZwCommitTransaction", 2);
        self.add("ZwCreateDirectoryObject", 3);
        self.add("ZwCreateEnlistment", 8);
        self.add("ZwCreateFile", 11);
        self.add("ZwCreateKey", 7);
        self.add("ZwCreateKeyTransacted", 8);
        self.add("ZwCreateResourceManager", 7);
        self.add("ZwCreateSection", 7);
        self.add("ZwCreateTransaction", 10);
        self.add("ZwCreateTransactionManager", 6);
        self.add("ZwDeleteKey", 1);
        self.add("ZwDeleteValueKey", 2);
        self.add("ZwEnumerateKey", 6);
        self.add("ZwEnumerateTransactionObject", 5);
        self.add("ZwEnumerateValueKey", 6);
        self.add("ZwFlushKey", 1);
        self.add("ZwGetNotificationResourceManager", 7);
        self.add("ZwLoadDriver", 1);
        self.add("ZwMakeTemporaryObject", 1);
        self.add("ZwMapViewOfSection", 10);
        self.add("ZwOpenEnlistment", 5);
        self.add("ZwOpenEvent", 3);
        self.add("ZwOpenFile", 6);
        self.add("ZwOpenKey", 3);
        self.add("ZwOpenKeyEx", 4);
        self.add("ZwOpenKeyTransacted", 4);
        self.add("ZwOpenKeyTransactedEx", 5);
        self.add("ZwOpenResourceManager", 5);
        self.add("ZwOpenSection", 3);
        self.add("ZwOpenSymbolicLinkObject", 3);
        self.add("ZwOpenTransaction", 5);
        self.add("ZwOpenTransactionManager", 6);
        self.add("ZwPrepareComplete", 2);
        self.add("ZwPrepareEnlistment", 2);
        self.add("ZwPrePrepareComplete", 2);
        self.add("ZwPrePrepareEnlistment", 2);
        self.add("ZwQueryFullAttributesFile", 2);
        self.add("ZwQueryInformationByName", 5);
        self.add("ZwQueryInformationEnlistment", 5);
        self.add("ZwQueryInformationFile", 5);
        self.add("ZwQueryInformationResourceManager", 5);
        self.add("ZwQueryInformationTransaction", 5);
        self.add("ZwQueryInformationTransactionManager", 5);
        self.add("ZwQueryKey", 5);
        self.add("ZwQuerySymbolicLinkObject", 3);
        self.add("ZwQueryValueKey", 6);
        self.add("ZwReadFile", 9);
        self.add("ZwReadOnlyEnlistment", 2);
        self.add("ZwRecoverEnlistment", 2);
        self.add("ZwRecoverResourceManager", 1);
        self.add("ZwRecoverTransactionManager", 1);
        self.add("ZwRollbackComplete", 2);
        self.add("ZwRollbackEnlistment", 2);
        self.add("ZwRollbackTransaction", 2);
        self.add("ZwRollforwardTransactionManager", 2);
        self.add("ZwSetInformationEnlistment", 4);
        self.add("ZwSetInformationFile", 5);
        self.add("ZwSetInformationResourceManager", 4);
        self.add("ZwSetInformationTransaction", 4);
        self.add("ZwSetValueKey", 6);
        self.add("ZwSinglePhaseReject", 2);
        self.add("ZwUnloadDriver", 1);
        self.add("ZwUnmapViewOfSection", 2);
        self.add("ZwWriteFile", 9);
        */
    }
}
