from .configs.od_config import GenerateSubindex, IndexObject, SubindexObject

STD_OBJS = [
    IndexObject(
        index=0x1000,
        name="device_type",
        object_type="variable",
        bit_definitions={"additional_info": "31-16", "device_profile_number": "15-0"},
        data_type="uint32",
        access_type="ro",
    ),
    IndexObject(
        index=0x1001,
        name="error_register",
        object_type="variable",
        bit_definitions={
            "manufacturer_specific": 7,
            "device_profile_specfic": 5,
            "communication_error": 4,
            "temperature": 3,
            "voltage": 2,
            "current": 1,
            "generic_error": 0,
        },
        data_type="uint8",
        access_type="ro",
    ),
    IndexObject(
        index=0x1003,
        name="predefined_error_field",
        description="emcy history for device",
        object_type="array",
        generate_subindexes=GenerateSubindex(
            name="error",
            subindexes=8,  # can be between 1 and 255
            data_type="uint32",
            access_type="ro",
            bit_definitions={"additional_info": "31-16", "error_code": "15-0"},
        ),
    ),
    IndexObject(
        index=0x1005,
        name="cob_id_sync",
        description="COB-ID of the SYNC message",
        data_type="uint32",
        default=0x80,
        bit_definitions={"gen": 30, "frame": 29, "can_id": "10-0"},
    ),
    IndexObject(
        index=0x1006,
        name="communication_cycle_period",
        object_type="variable",
        description="SYNC interval in mircoseconds",
        data_type="uint32",
    ),
    IndexObject(
        index=0x1014,
        name="cob_id_emergency_message",
        object_type="variable",
        bit_definitions={"not_valid": 31, "frame": 29, "can_id": "10-0"},
        data_type="uint32",
        default=0x80,
    ),
    IndexObject(
        index=0x1015,
        name="inhibit_time_emcy",
        object_type="variable",
        description="inhibit time for emcy messages",
        data_type="uint16",
        unit="ms",
        scale_factor=0.1,
    ),
    IndexObject(
        index=0x1016,
        name="consumer_heartbeat_time",
        object_type="array",
        description="expected heartbeat cycle times for all other nodes",
        generate_subindexes=GenerateSubindex(
            subindexes=0x7F,
            name="node_id",
            data_type="uint32",
            default=1000,
            unit="ms",
        ),
    ),
    IndexObject(
        index=0x1017,
        name="producer_heartbeat_time",
        object_type="variable",
        description="heartbeat producer time or 0 to disable",
        data_type="uint16",
        default=1000,
        unit="ms",
    ),
    IndexObject(
        index=0x1018,
        name="identity",
        object_type="record",
        subindexes=[
            SubindexObject(
                subindex=0x1,
                name="vendor_id",
                description="manufacturer vendor id set by CiA",
                data_type="uint32",
                access_type="ro",
            ),
            SubindexObject(
                subindex=0x2,
                name="product_code",
                description="ids a specific type of CANopen devices",
                data_type="uint32",
                access_type="ro",
            ),
            SubindexObject(
                subindex=0x3,
                name="revision_number",
                bit_definitions={
                    "major": "31-16",
                    "minor": "15-0",
                },
                data_type="uint32",
                access_type="ro",
            ),
            SubindexObject(
                subindex=0x4,
                name="serial_number",
                description="unqiue device id for a product group or revision",
                data_type="uint32",
                access_type="ro",
            ),
        ],
    ),
    IndexObject(
        index=0x1019,
        name="synchronous_counter_overflow_value",
        object_type="variable",
        description="highest supported value of the synchronous counter",
        data_type="uint8",
        high_limit=240,
    ),
    IndexObject(
        index=0x1023,
        name="os_command",
        object_type="record",
        subindexes=[
            SubindexObject(
                subindex=0x1,
                name="command",
                description="OS command",
                data_type="bytes",
            ),
            SubindexObject(
                subindex=0x2,
                name="status",
                value_descriptions={
                    "no_error_no_reply": 0x00,
                    "no_error_reply": 0x01,
                    "error_no_reply": 0x02,
                    "error_reply": 0x03,
                    "executing": 0xFF,
                },
                data_type="uint8",
                access_type="ro",
            ),
            SubindexObject(
                subindex=0x3,
                name="reply",
                description="OS command reply",
                data_type="bytes",
                access_type="ro",
            ),
        ],
    ),
    IndexObject(
        index=0x1200,
        name="sdo_server_parameter",
        object_type="record",
        subindexes=[
            SubindexObject(
                subindex=0x1,
                name="cob_id_client_to_server",
                data_type="uint32",
                access_type="ro",
                default=0x80000000,
                bit_definitions={
                    "not_valid": 31,
                    "dyn": 30,
                    "frame": 29,
                    "can_id": "10-0",
                },
            ),
            SubindexObject(
                subindex=0x2,
                name="cob_id_server_to_client",
                data_type="uint32",
                access_type="ro",
                default=0x80000000,
                bit_definitions={
                    "not_valid": 31,
                    "dyn": 30,
                    "frame": 29,
                    "can_id": "10-0",
                },
            ),
            SubindexObject(
                subindex=0x3,
                name="node_id_od_sdo_client",
                data_type="uint8",
                access_type="ro",
                low_limit=0x1,
                high_limit=0x7F,
                default=0x1,
            ),
        ],
    ),
    IndexObject(
        index=0x1280,
        name="sdo_client_parameter",
        object_type="record",
        subindexes=[
            SubindexObject(
                subindex=0x1,
                name="cob_id_client_to_server",
                data_type="uint32",
                default=0x80000000,
                bit_definitions={
                    "not_valid": 31,
                    "dyn": 30,
                    "frame": 29,
                    "can_id": "10-0",
                },
            ),
            SubindexObject(
                subindex=0x2,
                name="cob_id_server_to_client",
                data_type="uint32",
                default=0x80000000,
                bit_definitions={
                    "not_valid": 31,
                    "dyn": 30,
                    "frame": 29,
                    "can_id": "10-0",
                },
            ),
            SubindexObject(
                subindex=0x3,
                name="node_id_of_sdo_server",
                data_type="uint8",
                low_limit=0x1,
                high_limit=0x7F,
                default=0x1,
            ),
        ],
    ),
    IndexObject(
        index=0x2010,
        name="scet",
        object_type="variable",
        description="CCSDS Unsegmented Time Code (CUC) object for Spacecraft Elapsed Time (SCET)",
        data_type="uint64",
    ),
    IndexObject(
        index=0x2011,
        name="utc",
        object_type="variable",
        description="CCSDS Day Segmented Time Code (CDS) object for UTC time",
        data_type="uint64",
    ),
]
