from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.assistant_message_role import AssistantMessageRole
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.assistant_message_function_call import AssistantMessageFunctionCall
    from ..models.chat_completion_message_tool_call import ChatCompletionMessageToolCall


T = TypeVar("T", bound="AssistantMessage")


@_attrs_define
class AssistantMessage:
    """
    Attributes:
        role (AssistantMessageRole): The role of the messages author, in this case `assistant`.
        content (Union[None, Unset, str]): The contents of the assistant message. Required unless `tool_calls` or
            `function_call` is specified.
        name (Union[Unset, str]): An optional name for the participant. Provides the model information to differentiate
            between participants of the same role.
        tool_calls (Union[Unset, List['ChatCompletionMessageToolCall']]): The tool calls generated by the model, such as
            function calls.
        function_call (Union[Unset, AssistantMessageFunctionCall]): Deprecated and replaced by `tool_calls`. The name
            and arguments of a function that should be called, as generated by the model.
    """

    role: AssistantMessageRole
    content: Union[None, Unset, str] = UNSET
    name: Union[Unset, str] = UNSET
    tool_calls: Union[Unset, List["ChatCompletionMessageToolCall"]] = UNSET
    function_call: Union[Unset, "AssistantMessageFunctionCall"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        role = self.role.value

        content: Union[None, Unset, str]
        if isinstance(self.content, Unset):
            content = UNSET
        else:
            content = self.content

        name = self.name

        tool_calls: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.tool_calls, Unset):
            tool_calls = []
            for componentsschemas_chat_completion_message_tool_calls_item_data in self.tool_calls:
                componentsschemas_chat_completion_message_tool_calls_item = (
                    componentsschemas_chat_completion_message_tool_calls_item_data.to_dict()
                )
                tool_calls.append(componentsschemas_chat_completion_message_tool_calls_item)

        function_call: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.function_call, Unset):
            function_call = self.function_call.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "role": role,
            }
        )
        if content is not UNSET:
            field_dict["content"] = content
        if name is not UNSET:
            field_dict["name"] = name
        if tool_calls is not UNSET:
            field_dict["tool_calls"] = tool_calls
        if function_call is not UNSET:
            field_dict["function_call"] = function_call

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.assistant_message_function_call import AssistantMessageFunctionCall
        from ..models.chat_completion_message_tool_call import ChatCompletionMessageToolCall

        d = src_dict.copy()
        role = AssistantMessageRole(d.pop("role"))

        def _parse_content(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        content = _parse_content(d.pop("content", UNSET))

        name = d.pop("name", UNSET)

        tool_calls = []
        _tool_calls = d.pop("tool_calls", UNSET)
        for componentsschemas_chat_completion_message_tool_calls_item_data in _tool_calls or []:
            componentsschemas_chat_completion_message_tool_calls_item = ChatCompletionMessageToolCall.from_dict(
                componentsschemas_chat_completion_message_tool_calls_item_data
            )

            tool_calls.append(componentsschemas_chat_completion_message_tool_calls_item)

        _function_call = d.pop("function_call", UNSET)
        function_call: Union[Unset, AssistantMessageFunctionCall]
        if isinstance(_function_call, Unset):
            function_call = UNSET
        else:
            function_call = AssistantMessageFunctionCall.from_dict(_function_call)

        assistant_message = cls(
            role=role,
            content=content,
            name=name,
            tool_calls=tool_calls,
            function_call=function_call,
        )

        assistant_message.additional_properties = d
        return assistant_message

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
