import { Dialog } from '@jupyterlab/apputils';
import { DocumentRegistry } from '@jupyterlab/docregistry';
import { INotebookModel, NotebookPanel } from '@jupyterlab/notebook';
import { JupyterFrontEnd } from '@jupyterlab/application';
import { JSONObject, JSONValue } from '@phosphor/coreutils';
import { Widget } from '@phosphor/widgets';
import { IDisposable } from '@phosphor/disposable';
/**
 * Details about notebook submission configuration, including
 * details about the remote runtime and any other
 * user details required to access/start the job
 */
export interface ISubmitNotebookConfiguration extends JSONObject {
    runtime_config: string;
    framework: string;
    dependencies: string[];
    env: string[];
}
/**
 * Details about notebook submission task, includes the submission
 * configuration plus the notebook contents that is being submitted
 */
export interface ISubmitNotebookOptions extends ISubmitNotebookConfiguration {
    kernelspec: string;
    notebook_name: string;
    notebook_path: string;
    notebook: JSONValue;
}
/**
 * Submit notebook button extension
 *  - Attach button to notebook toolbar and launch a dialog requesting
 *  information about the remote location to where submit the notebook
 *  for execution
 */
export declare class SubmitNotebookButtonExtension implements DocumentRegistry.IWidgetExtension<NotebookPanel, INotebookModel> {
    private panel;
    constructor(app: JupyterFrontEnd);
    readonly app: JupyterFrontEnd;
    showWidget: () => void;
    createNew(panel: NotebookPanel, context: DocumentRegistry.IContext<INotebookModel>): IDisposable;
}
/**
 * Submit notebook dialog extension
 * - Request information about the remote location to where submit the
 * notebook for execution
 */
export declare class SubmitNotebook extends Widget implements Dialog.IBodyWidget<ISubmitNotebookConfiguration> {
    _envVars: string[];
    _runtimes: any;
    constructor(envVars: string[], runtimes: any);
    /**
     * Render the dialog widget used to gather configuration information
     * required to submit/run the notebook remotely
     */
    renderHtml(): HTMLElement;
    getEnvHtml(): string;
    getValue(): ISubmitNotebookConfiguration;
}
