import { showErrorMessage } from '@jupyterlab/apputils';
import * as React from 'react';
import { classes } from 'typestyle';
import { branchDropdownButtonStyle, branchHeaderCenterContent, branchLabelStyle, branchListItemStyle, branchStyle, branchTrackingLabelStyle, expandedBranchStyle, headerButtonDisabledStyle, historyLabelStyle, newBranchButtonStyle, openHistorySideBarButtonStyle, selectedHeaderStyle, unSelectedHeaderStyle } from '../style/BranchHeaderStyle';
import { NewBranchBox } from './NewBranchBox';
const CHANGES_ERR_MSG = 'You have files with changes in current branch. Please commit or discard changed files before';
export class BranchHeader extends React.Component {
    constructor(props) {
        super(props);
        this.createNewBranch = async (branchName) => {
            const result = await this.props.model.checkout({
                newBranch: true,
                branchname: branchName
            });
            if (result.code !== 0) {
                showErrorMessage('Error creating new branch', result.message);
            }
            this.toggleNewBranchBox();
        };
        this.toggleNewBranchBox = () => {
            this.props.refresh();
            if (!this.props.disabled) {
                this.setState({
                    showNewBranchBox: !this.state.showNewBranchBox,
                    dropdownOpen: false
                });
            }
            else {
                showErrorMessage('Creating new branch disabled', CHANGES_ERR_MSG + 'creating a new branch.');
            }
        };
        this.state = {
            dropdownOpen: false,
            showNewBranchBox: false
        };
    }
    /** Switch current working branch */
    async switchBranch(branchName) {
        const result = await this.props.model.checkout({ branchname: branchName });
        if (result.code !== 0) {
            showErrorMessage('Error switching branch', result.message);
        }
        this.toggleSelect();
    }
    toggleSelect() {
        this.props.refresh();
        if (!this.props.disabled) {
            this.setState({
                dropdownOpen: !this.state.dropdownOpen
            });
        }
        else {
            showErrorMessage('Switching branch disabled', CHANGES_ERR_MSG + 'switching to another branch.');
        }
    }
    getBranchStyle() {
        if (this.state.dropdownOpen) {
            return classes(branchStyle, expandedBranchStyle);
        }
        else {
            return branchStyle;
        }
    }
    getHistoryHeaderStyle() {
        if (this.props.sideBarExpanded) {
            return classes(openHistorySideBarButtonStyle, selectedHeaderStyle);
        }
        return classes(unSelectedHeaderStyle, openHistorySideBarButtonStyle);
    }
    getBranchHeaderStyle() {
        if (this.props.sideBarExpanded) {
            return classes(branchHeaderCenterContent, unSelectedHeaderStyle);
        }
        return classes(selectedHeaderStyle, branchHeaderCenterContent);
    }
    render() {
        return (React.createElement("div", { className: this.getBranchStyle() },
            React.createElement("div", { style: { display: 'flex' } },
                React.createElement("div", { className: this.getHistoryHeaderStyle(), onClick: this.props.sideBarExpanded
                        ? null
                        : () => this.props.toggleSidebar(), title: 'Show commit history' },
                    React.createElement("h3", { className: historyLabelStyle }, "History")),
                React.createElement("div", { className: this.getBranchHeaderStyle(), onClick: this.props.sideBarExpanded
                        ? () => this.props.toggleSidebar()
                        : null },
                    React.createElement("h3", { className: branchLabelStyle }, this.props.currentBranch),
                    React.createElement("div", { className: this.props.disabled
                            ? classes(branchDropdownButtonStyle, headerButtonDisabledStyle)
                            : branchDropdownButtonStyle, title: 'Change the current branch', onClick: () => this.toggleSelect() }),
                    !this.state.showNewBranchBox && (React.createElement("div", { className: this.props.disabled
                            ? classes(newBranchButtonStyle, headerButtonDisabledStyle)
                            : newBranchButtonStyle, title: 'Create a new branch', onClick: () => this.toggleNewBranchBox() })),
                    this.state.showNewBranchBox && (React.createElement(NewBranchBox, { createNewBranch: this.createNewBranch, toggleNewBranchBox: this.toggleNewBranchBox })),
                    this.props.upstreamBranch != null &&
                        this.props.upstreamBranch !== '' && (React.createElement("h3", { className: branchTrackingLabelStyle }, this.props.upstreamBranch)))),
            !this.props.sideBarExpanded && (React.createElement(React.Fragment, null,
                this.state.dropdownOpen && (React.createElement("div", null, this.props.data.map((branch, branchIndex) => (React.createElement("li", { className: branchListItemStyle, key: branchIndex, onClick: () => this.switchBranch(branch.name) }, branch.name))))),
                this.state.showNewBranchBox && (React.createElement("div", null,
                    "Branching from ",
                    this.props.currentBranch))))));
    }
}
//# sourceMappingURL=BranchHeader.js.map