import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
export interface IFileItemProps {
    file: Git.IStatusFileResult;
    stage: string;
    model: GitExtension;
    moveFile: (file: string) => Promise<void>;
    discardFile: (file: string) => Promise<void>;
    moveFileIconClass: string;
    moveFileIconSelectedClass: string;
    moveFileTitle: string;
    contextMenu: (event: any, typeX: string, typeY: string, file: string, index: number, stage: string) => void;
    selectedFile: number;
    updateSelectedFile: (file: number, stage: string) => void;
    fileIndex: number;
    selectedStage: string;
    selectedDiscardFile: number;
    updateSelectedDiscardFile: (index: number) => void;
    disableFile: boolean;
    toggleDisableFiles: () => void;
    renderMime: IRenderMimeRegistry;
}
export declare class FileItem extends React.Component<IFileItemProps, {}> {
    constructor(props: IFileItemProps);
    checkSelected(): boolean;
    getFileChangedLabel(change: string): string;
    showDiscardWarning(): boolean;
    getFileChangedLabelClass(change: string): string;
    getFileLabelIconClass(): string;
    getFileClass(): string;
    getFileLabelClass(): string;
    getMoveFileIconClass(): string;
    getDiffFileIconClass(): string;
    getDiscardFileIconClass(): string;
    /**
     * Callback method discarding unstanged changes for selected file.
     * It shows modal asking for confirmation and when confirmed make
     * server side call to git checkout to discard changes in selected file.
     */
    discardSelectedFileChanges(): Promise<void>;
    render(): JSX.Element;
    /**
     * Creates a button element which is used to request diff from within the
     * Git panel.
     *
     * @param currentRef the ref to diff against the git 'HEAD' ref
     */
    private diffButton;
}
