import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
export interface IGitMarkBoxProps {
    fname: string;
    model: GitExtension;
    stage: string;
}
export declare class GitMarkBox extends React.Component<IGitMarkBoxProps> {
    constructor(props: IGitMarkBoxProps);
    protected _onClick(event: React.ChangeEvent<HTMLInputElement>): void;
    render(): JSX.Element;
}
export interface IFileItemSimpleProps {
    file: Git.IStatusFileResult;
    stage: string;
    model: GitExtension;
    discardFile: (file: string) => Promise<void>;
    renderMime: IRenderMimeRegistry;
}
export declare class FileItemSimple extends React.Component<IFileItemSimpleProps> {
    getDiffFileIconClass(): string;
    getDiscardFileIconClass(): string;
    /**
     * Callback method discarding unstanged changes for selected file.
     * It shows modal asking for confirmation and when confirmed make
     * server side call to git checkout to discard changes in selected file.
     */
    discardSelectedFileChanges(): Promise<void>;
    render(): JSX.Element;
    /**
     * Creates a button element which is used to request diff from within the
     * Git panel.
     *
     * @param currentRef the ref to diff against the git 'HEAD' ref
     */
    private diffButton;
}
