import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
export interface IGitStageSimpleProps {
    heading: string;
    files: Git.IStatusFileResult[];
    model: GitExtension;
    discardAllFiles: () => Promise<void>;
    discardFile: (file: string) => Promise<void>;
    renderMime: IRenderMimeRegistry;
}
export declare class GitStageSimple extends React.Component<IGitStageSimpleProps> {
    constructor(props: IGitStageSimpleProps);
    checkContents(): boolean;
    /**
     * Callback method discarding all unstanged changes.
     * It shows modal asking for confirmation and when confirmed make
     * server side call to git checkout to discard all unstanged changes.
     */
    discardAllChanges(): Promise<void>;
    render(): JSX.Element;
}
