import * as React from 'react';
import { classes } from 'typestyle';
import { buttonStyle, cancelNewBranchButtonStyle, newBranchBoxStyle, newBranchButtonStyle, newBranchInputAreaStyle } from '../style/NewBranchBoxStyle';
export class NewBranchBox extends React.Component {
    constructor(props) {
        super(props);
        /** Handle input inside commit message box */
        this.handleChange = (event) => {
            this.setState({
                value: event.target.value
            });
        };
        this.state = {
            value: ''
        };
    }
    /** Prevent enter key triggered 'submit' action during input */
    onKeyPress(event) {
        if (event.which === 13) {
            event.preventDefault();
            this.setState({ value: this.state.value + '\n' });
        }
    }
    render() {
        return (React.createElement("div", { className: newBranchInputAreaStyle, onKeyPress: event => this.onKeyPress(event) },
            React.createElement("input", { className: newBranchBoxStyle, placeholder: 'New branch', value: this.state.value, onChange: this.handleChange, autoFocus: true }),
            React.createElement("input", { className: classes(buttonStyle, newBranchButtonStyle), type: "button", title: "Create New", onClick: () => this.props.createNewBranch(this.state.value) }),
            React.createElement("input", { className: classes(buttonStyle, cancelNewBranchButtonStyle), type: "button", title: "Cancel", onClick: () => this.props.toggleNewBranchBox() })));
    }
}
//# sourceMappingURL=NewBranchBox.js.map