import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
export interface IPastCommitNodeProps {
    pastCommit: Git.ISingleCommitInfo;
    branches: Git.IBranch[];
    model: GitExtension;
    renderMime: IRenderMimeRegistry;
}
export interface IPastCommitNodeState {
    expanded: boolean;
}
export declare class PastCommitNode extends React.Component<IPastCommitNodeProps, IPastCommitNodeState> {
    constructor(props: IPastCommitNodeProps);
    getBranchesForCommit(): Git.IBranch[];
    expand(): void;
    collapse(): void;
    getNodeClass(): string;
    render(): JSX.Element;
}
