import * as React from 'react';
import { classes } from 'typestyle';
import { branchesStyle, branchStyle, collapseStyle, localBranchStyle, pastCommitBodyStyle, pastCommitExpandedStyle, pastCommitHeaderItemStyle, pastCommitHeaderStyle, pastCommitNodeStyle, remoteBranchStyle, workingBranchStyle } from '../style/PastCommitNodeStyle';
import { SinglePastCommitInfo } from './SinglePastCommitInfo';
export class PastCommitNode extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            expanded: false
        };
    }
    getBranchesForCommit() {
        const currentCommit = this.props.pastCommit.commit;
        const branches = [];
        for (let i = 0; i < this.props.branches.length; i++) {
            const branch = this.props.branches[i];
            if (branch.top_commit && branch.top_commit === currentCommit) {
                branches.push(branch);
            }
        }
        return branches;
    }
    expand() {
        this.setState(() => ({ expanded: true }));
    }
    collapse() {
        this.setState(() => ({ expanded: false }));
    }
    getNodeClass() {
        if (this.state.expanded) {
            return classes(pastCommitNodeStyle, pastCommitExpandedStyle);
        }
        return pastCommitNodeStyle;
    }
    render() {
        return (React.createElement("li", { onClick: () => {
                // tslint:disable-next-line: no-unused-expression
                !this.state.expanded && this.expand();
            }, className: this.getNodeClass() },
            React.createElement("div", { className: pastCommitHeaderStyle },
                React.createElement("div", { className: pastCommitHeaderItemStyle }, this.props.pastCommit.author),
                React.createElement("div", { className: pastCommitHeaderItemStyle }, this.props.pastCommit.commit.slice(0, 7)),
                React.createElement("div", { className: pastCommitHeaderItemStyle }, this.props.pastCommit.date)),
            React.createElement("div", { className: branchesStyle }, this.getBranchesForCommit().map((branch, id) => (React.createElement(React.Fragment, { key: id },
                branch.is_current_branch && (React.createElement("span", { className: classes(branchStyle, workingBranchStyle) }, "working")),
                React.createElement("span", { className: classes(branchStyle, branch.is_remote_branch ? remoteBranchStyle : localBranchStyle) }, branch.name))))),
            React.createElement("div", { className: pastCommitBodyStyle },
                this.props.pastCommit.commit_msg,
                this.state.expanded && (React.createElement(React.Fragment, null,
                    React.createElement(SinglePastCommitInfo, { data: this.props.pastCommit, model: this.props.model, renderMime: this.props.renderMime }),
                    React.createElement("div", { className: collapseStyle, onClick: () => this.collapse() }, "Collapse"))))));
    }
}
//# sourceMappingURL=PastCommitNode.js.map