import * as React from 'react';
import { classes } from 'typestyle';
import { button, cancelButton, messageInput, resetDeleteButton, resetDeleteDisabledButton, warningLabel } from '../style/SinglePastCommitInfoStyle';
export class ResetDeleteSingleCommit extends React.Component {
    constructor(props) {
        super(props);
        this.onCancel = () => {
            this.setState({
                message: '',
                resetDeleteDisabled: true
            });
            this.props.onCancel();
        };
        this.updateMessage = (value) => {
            this.setState({
                message: value,
                resetDeleteDisabled: value === ''
            });
        };
        this.handleResetDelete = async () => {
            if (this.props.action === 'reset') {
                await this.props.model.resetToCommit(this.props.commitId);
            }
            else {
                await this.props.model.deleteCommit(this.state.message, this.props.commitId);
            }
            this.props.onCancel();
        };
        this.state = {
            message: '',
            resetDeleteDisabled: true
        };
    }
    render() {
        return (React.createElement("div", null,
            React.createElement("div", { className: warningLabel }, this.props.action === 'delete'
                ? "These changes will be gone forever. Commit if you're sure?"
                : "All changes after this will be gone forever. Commit if you're sure?"),
            React.createElement("input", { type: "text", className: messageInput, onChange: event => this.updateMessage(event.currentTarget.value), placeholder: "Add a commit message to make changes" }),
            React.createElement("button", { className: classes(button, cancelButton), onClick: this.onCancel }, "Cancel"),
            React.createElement("button", { className: this.state.resetDeleteDisabled
                    ? classes(button, resetDeleteDisabledButton)
                    : classes(button, resetDeleteButton), disabled: this.state.resetDeleteDisabled, onClick: this.handleResetDelete }, this.props.action === 'delete'
                ? 'Delete these changes'
                : 'Revert to this commit')));
    }
}
//# sourceMappingURL=ResetDeleteSingleCommit.js.map