import { JupyterFrontEnd } from '@jupyterlab/application';
import { FileBrowser } from '@jupyterlab/filebrowser';
import { IGitExtension } from './tokens';
import { ISettingRegistry } from '@jupyterlab/coreutils';
/**
 * The command IDs used by the git plugin.
 */
export declare namespace CommandIDs {
    const gitUI = "git:ui";
    const gitTerminalCommand = "git:terminal-command";
    const gitInit = "git:init";
    const gitOpenUrl = "git:open-url";
    const gitToggleSimpleStaging = "git:toggle-simple-staging";
}
/**
 * Add the commands for the git extension.
 */
export declare function addCommands(app: JupyterFrontEnd, model: IGitExtension, fileBrowser: FileBrowser, settings: ISettingRegistry.ISettings): void;
