import { Kernel } from '@jupyterlab/services';
import { CodeEditor } from '@jupyterlab/codeeditor';
/**
 * Class: An enhanced Python Script Editor that enables developing and running the script
 */
export declare class PythonRunner {
    kernel: Kernel.IKernel;
    model: CodeEditor.IModel;
    kernelSettings: Kernel.IOptions;
    /**
     * Construct a new runner.
     */
    constructor(model: CodeEditor.IModel);
    /**
     * Function: Starts a python kernel and executes code from file editor.
     */
    runPython: (kernelSettings: Kernel.IOptions, handleKernelMsg: Function) => Promise<any>;
    /**
     * Function: Gets available kernel specs.
     */
    getKernelSpecs: () => Promise<Kernel.ISpecModels>;
    /**
     * Function: Starts new kernel.
     */
    startKernel: (options: Kernel.IOptions) => Promise<Kernel.IKernel>;
    /**
     * Function: Shuts down kernel.
     */
    shutDownKernel: () => Promise<void>;
}
