import * as React from 'react';
import { Git, IGitExtension } from '../tokens';
export interface IBranchHeaderState {
    dropdownOpen: boolean;
    showNewBranchBox: boolean;
}
export interface IBranchHeaderProps {
    model: IGitExtension;
    currentBranch: string;
    upstreamBranch: string;
    stagedFiles: Git.IStatusFileResult[];
    data: Git.IBranch[];
    refresh: () => Promise<void>;
    disabled: boolean;
    toggleSidebar: () => void;
    sideBarExpanded: boolean;
}
export declare class BranchHeader extends React.Component<IBranchHeaderProps, IBranchHeaderState> {
    constructor(props: IBranchHeaderProps);
    /** Switch current working branch */
    switchBranch(branchName: string): Promise<void>;
    createNewBranch: (branchName: string) => Promise<void>;
    toggleSelect(): void;
    getBranchStyle(): string;
    toggleNewBranchBox: () => void;
    getHistoryHeaderStyle(): string;
    getBranchHeaderStyle(): string;
    render(): JSX.Element;
}
