import * as React from 'react';
export interface ICommitBoxProps {
    hasFiles: boolean;
    commitFunc: (message: string) => Promise<void>;
}
export interface ICommitBoxState {
    /**
     * Commit message
     */
    value: string;
}
export declare class CommitBox extends React.Component<ICommitBoxProps, ICommitBoxState> {
    constructor(props: ICommitBoxProps);
    /** Prevent enter key triggered 'submit' action during commit message input */
    onKeyPress(event: any): void;
    /** Initalize commit message input box */
    initializeInput: () => void;
    /** Handle input inside commit message box */
    handleChange: (event: any) => void;
    /** Update state of commit message input box */
    commitButtonStyle: (hasStagedFiles: boolean) => string;
    render(): JSX.Element;
}
