import * as React from 'react';
import { classes } from 'typestyle';
import { stagedCommitButtonDisabledStyle, stagedCommitButtonReadyStyle, stagedCommitButtonStyle, stagedCommitMessageStyle, stagedCommitStyle, textInputStyle } from '../style/BranchHeaderStyle';
export class CommitBox extends React.Component {
    constructor(props) {
        super(props);
        /** Initalize commit message input box */
        this.initializeInput = () => {
            this.setState({
                value: ''
            });
        };
        /** Handle input inside commit message box */
        this.handleChange = (event) => {
            this.setState({
                value: event.target.value
            });
        };
        /** Update state of commit message input box */
        this.commitButtonStyle = (hasStagedFiles) => {
            if (hasStagedFiles) {
                if (this.state.value.length === 0) {
                    return classes(stagedCommitButtonStyle, stagedCommitButtonReadyStyle);
                }
                else {
                    return stagedCommitButtonStyle;
                }
            }
            else {
                return classes(stagedCommitButtonStyle, stagedCommitButtonDisabledStyle);
            }
        };
        this.state = {
            value: ''
        };
    }
    /** Prevent enter key triggered 'submit' action during commit message input */
    onKeyPress(event) {
        if (event.which === 13) {
            event.preventDefault();
            this.setState({ value: this.state.value + '\n' });
        }
    }
    render() {
        return (React.createElement("form", { className: stagedCommitStyle, onKeyPress: event => this.onKeyPress(event) },
            React.createElement("textarea", { className: classes(textInputStyle, stagedCommitMessageStyle), disabled: !this.props.hasFiles, placeholder: this.props.hasFiles
                    ? 'Input message to commit staged changes'
                    : 'Stage your changes before commit', value: this.state.value, onChange: this.handleChange }),
            React.createElement("input", { className: this.commitButtonStyle(this.props.hasFiles), type: "button", title: "Commit", disabled: !(this.props.hasFiles && this.state.value), onClick: () => {
                    this.props.commitFunc(this.state.value);
                    this.initializeInput();
                } })));
    }
}
//# sourceMappingURL=CommitBox.js.map