import { ISettingRegistry } from '@jupyterlab/coreutils';
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { Menu } from '@phosphor/widgets';
import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
export declare namespace CommandIDs {
    const gitFileOpen = "gf:Open";
    const gitFileUnstage = "gf:Unstage";
    const gitFileStage = "gf:Stage";
    const gitFileTrack = "gf:Track";
    const gitFileDiscard = "gf:Discard";
    const gitFileDiffWorking = "gf:DiffWorking";
    const gitFileDiffIndex = "gf:DiffIndex";
}
export interface IFileListState {
    commitMessage: string;
    disableCommit: boolean;
    showStaged: boolean;
    showUnstaged: boolean;
    showUntracked: boolean;
    contextMenuStaged: Menu;
    contextMenuUnstaged: Menu;
    contextMenuUntracked: Menu;
    contextMenuTypeX: string;
    contextMenuTypeY: string;
    contextMenuFile: string;
    contextMenuIndex: number;
    contextMenuStage: string;
    selectedFile: number;
    selectedStage: string;
    selectedDiscardFile: number;
    disableStaged: boolean;
    disableUnstaged: boolean;
    disableUntracked: boolean;
    disableFiles: boolean;
}
export interface IFileListProps {
    stagedFiles: Git.IStatusFileResult[];
    unstagedFiles: Git.IStatusFileResult[];
    untrackedFiles: Git.IStatusFileResult[];
    model: GitExtension;
    renderMime: IRenderMimeRegistry;
    settings: ISettingRegistry.ISettings;
}
export declare class FileList extends React.Component<IFileListProps, IFileListState> {
    constructor(props: IFileListProps);
    /** Handle right-click on a staged file */
    contextMenuStaged: (event: any, typeX: string, typeY: string, file: string, index: number, stage: string) => void;
    /** Handle right-click on an unstaged file */
    contextMenuUnstaged: (event: any, typeX: string, typeY: string, file: string, index: number, stage: string) => void;
    /** Handle right-click on an untracked file */
    contextMenuUntracked: (event: any, typeX: string, typeY: string, file: string, index: number, stage: string) => void;
    /** Toggle display of staged files */
    displayStaged: () => void;
    /** Toggle display of unstaged files */
    displayUnstaged: () => void;
    /** Toggle display of untracked files */
    displayUntracked: () => void;
    updateSelectedStage: (stage: string) => void;
    /** Reset all staged files */
    resetAllStagedFiles: () => Promise<void>;
    /** Reset a specific staged file */
    resetStagedFile: (file: string) => Promise<void>;
    /** Add all unstaged files */
    addAllUnstagedFiles: () => Promise<void>;
    /** Discard changes in all unstaged files */
    discardAllUnstagedFiles: () => Promise<void>;
    /** Discard changes in all unstaged and staged files */
    discardAllChanges: () => Promise<void>;
    /** Add a specific unstaged file */
    addFile: (...file: string[]) => Promise<void>;
    /** Discard changes in a specific unstaged or staged file */
    discardChanges: (file: string) => Promise<void>;
    /** Add all untracked files */
    addAllUntrackedFiles: () => Promise<void>;
    addAllMarkedFiles: () => Promise<void>;
    disableStagesForDiscardAll: () => void;
    updateSelectedDiscardFile: (index: number) => void;
    toggleDisableFiles: () => void;
    updateSelectedFile: (file: number, stage: string) => void;
    /** Commit all staged files */
    commitAllStagedFiles: (message: string) => Promise<void>;
    /** Commit all marked files */
    commitAllMarkedFiles: (message: string) => Promise<void>;
    readonly markedFiles: Git.IStatusFileResult[];
    readonly allFilesExcludingUnmodified: Git.IStatusFileResult[];
    render(): JSX.Element;
    /**
     * Does the user have an known git identity.
     *
     * @param path Top repository path
     * @returns Success status
     */
    private _hasIdentity;
    private _previousTopRepoPath;
}
