import { ISettingRegistry } from '@jupyterlab/coreutils';
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
/** Interface for GitPanel component state */
export interface IGitSessionNodeState {
    inGitRepository: boolean;
    branches: Git.IBranch[];
    currentBranch: string;
    upstreamBranch: string;
    pastCommits: Git.ISingleCommitInfo[];
    stagedFiles: Git.IStatusFileResult[];
    unstagedFiles: Git.IStatusFileResult[];
    untrackedFiles: Git.IStatusFileResult[];
    isHistoryVisible: boolean;
}
/** Interface for GitPanel component props */
export interface IGitSessionNodeProps {
    model: GitExtension;
    renderMime: IRenderMimeRegistry;
    settings: ISettingRegistry.ISettings;
}
/** A React component for the git extension's main display */
export declare class GitPanel extends React.Component<IGitSessionNodeProps, IGitSessionNodeState> {
    constructor(props: IGitSessionNodeProps);
    refreshBranch: () => Promise<void>;
    refreshHistory: () => Promise<void>;
    setStatus: () => void;
    refreshStatus: () => Promise<void>;
    /**
     * Refresh widget, update all content
     */
    refresh: () => Promise<void>;
    toggleSidebar: () => void;
    render(): JSX.Element;
}
