import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
export interface IGitStageProps {
    heading: string;
    files: Git.IStatusFileResult[];
    model: GitExtension;
    showFiles: boolean;
    displayFiles: () => void;
    moveAllFiles: () => Promise<void>;
    discardAllFiles: () => Promise<void>;
    discardFile: (file: string) => Promise<void>;
    moveFile: (file: string) => Promise<void>;
    moveFileIconClass: string;
    moveFileIconSelectedClass: string;
    moveAllFilesTitle: string;
    moveFileTitle: string;
    contextMenu: (event: any, typeX: string, typeY: string, file: string, index: number, stage: string) => void;
    selectedFile: number;
    updateSelectedFile: (file: number, stage: string) => void;
    selectedStage: string;
    selectedDiscardFile: number;
    updateSelectedDiscardFile: (index: number) => void;
    disableFiles: boolean;
    toggleDisableFiles: () => void;
    updateSelectedStage: (stage: string) => void;
    isDisabled: boolean;
    disableOthers: () => void;
    renderMime: IRenderMimeRegistry;
}
export interface IGitStageState {
    showDiscardWarning: boolean;
}
export declare class GitStage extends React.Component<IGitStageProps, IGitStageState> {
    constructor(props: IGitStageProps);
    checkContents(): boolean;
    checkDisabled(): string;
    toggleDiscardChanges(): void;
    /**
     * Callback method discarding all unstanged changes.
     * It shows modal asking for confirmation and when confirmed make
     * server side call to git checkout to discard all unstanged changes.
     */
    discardAllChanges(): Promise<void>;
    render(): JSX.Element;
}
