import { Dialog, showDialog } from '@jupyterlab/apputils';
import * as React from 'react';
import { classes } from 'typestyle';
import { caretdownImageStyle, caretrightImageStyle, changeStageButtonLeftStyle, changeStageButtonStyle, discardFileButtonStyle, sectionAreaStyle, sectionFileContainerDisabledStyle, sectionFileContainerStyle, sectionHeaderLabelStyle } from '../style/GitStageStyle';
import { FileItem } from './FileItem';
export class GitStage extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            showDiscardWarning: false
        };
    }
    checkContents() {
        if (this.props.files.length > 0) {
            return false;
        }
        else {
            return true;
        }
    }
    checkDisabled() {
        return this.props.isDisabled
            ? classes(sectionFileContainerStyle, sectionFileContainerDisabledStyle)
            : sectionFileContainerStyle;
    }
    toggleDiscardChanges() {
        this.setState({ showDiscardWarning: !this.state.showDiscardWarning }, () => this.props.disableOthers());
    }
    /**
     * Callback method discarding all unstanged changes.
     * It shows modal asking for confirmation and when confirmed make
     * server side call to git checkout to discard all unstanged changes.
     */
    async discardAllChanges() {
        this.toggleDiscardChanges();
        const result = await showDialog({
            title: 'Discard all changes',
            body: `Are you sure you want to permanently discard changes to all files? This action cannot be undone.`,
            buttons: [Dialog.cancelButton(), Dialog.warnButton({ label: 'Discard' })]
        });
        if (result.button.accept) {
            this.props.discardAllFiles();
        }
        this.toggleDiscardChanges();
    }
    render() {
        return (React.createElement("div", { className: this.checkDisabled() },
            React.createElement("div", { className: sectionAreaStyle },
                React.createElement("span", { className: sectionHeaderLabelStyle },
                    this.props.heading,
                    "(",
                    this.props.files.length,
                    ")"),
                this.props.files.length > 0 && (React.createElement("button", { className: this.props.showFiles
                        ? `${changeStageButtonStyle} ${caretdownImageStyle}`
                        : `${changeStageButtonStyle} ${caretrightImageStyle}`, onClick: () => this.props.displayFiles() })),
                React.createElement("button", { disabled: this.checkContents(), className: `${this.props.moveFileIconClass} ${changeStageButtonStyle}
               ${changeStageButtonLeftStyle}`, title: this.props.moveAllFilesTitle, onClick: () => this.props.moveAllFiles() }),
                this.props.heading === 'Changed' && (React.createElement("button", { disabled: this.checkContents(), className: classes(changeStageButtonStyle, discardFileButtonStyle), title: 'Discard All Changes', onClick: () => this.discardAllChanges() }))),
            this.props.showFiles && (React.createElement("ul", { className: sectionFileContainerStyle }, this.props.files.map((file, fileIndex) => {
                return (React.createElement(FileItem, { key: fileIndex, stage: this.props.heading, file: file, model: this.props.model, moveFile: this.props.moveFile, discardFile: this.props.discardFile, moveFileIconClass: this.props.moveFileIconClass, moveFileIconSelectedClass: this.props.moveFileIconSelectedClass, moveFileTitle: this.props.moveFileTitle, contextMenu: this.props.contextMenu, selectedFile: this.props.selectedFile, updateSelectedFile: this.props.updateSelectedFile, fileIndex: fileIndex, selectedStage: this.props.selectedStage, selectedDiscardFile: this.props.selectedDiscardFile, updateSelectedDiscardFile: this.props.updateSelectedDiscardFile, disableFile: this.props.disableFiles, toggleDisableFiles: this.props.toggleDisableFiles, renderMime: this.props.renderMime }));
            })))));
    }
}
//# sourceMappingURL=GitStage.js.map