import { Dialog, showDialog } from '@jupyterlab/apputils';
import * as React from 'react';
import { classes } from 'typestyle';
import { changeStageButtonStyle, discardFileButtonStyle, sectionAreaStyle, sectionFileContainerStyle, sectionHeaderLabelStyle } from '../style/GitStageStyle';
import { FileItemSimple } from './FileItemSimple';
import { decodeStage } from '../utils';
export class GitStageSimple extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            showDiscardWarning: false
        };
    }
    checkContents() {
        if (this.props.files.length > 0) {
            return false;
        }
        else {
            return true;
        }
    }
    /**
     * Callback method discarding all unstanged changes.
     * It shows modal asking for confirmation and when confirmed make
     * server side call to git checkout to discard all unstanged changes.
     */
    async discardAllChanges() {
        const result = await showDialog({
            title: 'Discard all changes',
            body: `Are you sure you want to permanently discard changes to all files? This action cannot be undone.`,
            buttons: [Dialog.cancelButton(), Dialog.warnButton({ label: 'Discard' })]
        });
        if (result.button.accept) {
            this.props.discardAllFiles();
        }
    }
    render() {
        return (React.createElement("div", null,
            React.createElement("div", { className: sectionAreaStyle },
                React.createElement("span", { className: sectionHeaderLabelStyle },
                    this.props.heading,
                    "(",
                    this.props.files.length,
                    ")"),
                this.props.heading === 'Changed' && (React.createElement("button", { disabled: this.checkContents(), className: classes(changeStageButtonStyle, discardFileButtonStyle), title: 'Discard All Changes', onClick: () => this.discardAllChanges() }))),
            React.createElement("ul", { className: sectionFileContainerStyle }, this.props.files.map((file, fileIndex) => {
                return (React.createElement(FileItemSimple, { key: fileIndex, file: file, stage: decodeStage(file.x, file.y), model: this.props.model, discardFile: this.props.discardFile, renderMime: this.props.renderMime }));
            }))));
    }
}
//# sourceMappingURL=GitStageSimple.js.map