import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
export interface ISinglePastCommitInfoProps {
    data: Git.ISingleCommitInfo;
    model: GitExtension;
    renderMime: IRenderMimeRegistry;
}
export interface ISinglePastCommitInfoState {
    displayDelete: boolean;
    displayReset: boolean;
    info: string;
    filesChanged: string;
    insertionCount: string;
    deletionCount: string;
    modifiedFiles: Git.ICommitModifiedFile[];
    loadingState: 'loading' | 'error' | 'success';
}
export declare class SinglePastCommitInfo extends React.Component<ISinglePastCommitInfoProps, ISinglePastCommitInfoState> {
    constructor(props: ISinglePastCommitInfoProps);
    showPastCommitWork: () => Promise<void>;
    showDeleteCommit: () => void;
    hideDeleteCommit: () => void;
    showResetToCommit: () => void;
    hideResetToCommit: () => void;
    render(): JSX.Element;
}
