import { DefaultIconReact } from '@jupyterlab/ui-components';
import * as React from 'react';
import { classes } from 'typestyle/';
import { fileIconStyle } from '../style/FileItemStyle';
import { changeStageButtonStyle, discardFileButtonStyle } from '../style/GitStageStyle';
import { commitDetailFilePathStyle, commitDetailFileStyle, commitDetailHeader, commitDetailStyle, commitOverviewNumbers, commitStyle, diffIconStyle, fileList, floatRightStyle, iconStyle, revertButtonStyle } from '../style/SinglePastCommitInfoStyle';
import { parseFileExtension } from '../utils';
import { isDiffSupported } from './diff/Diff';
import { openDiffView } from './diff/DiffWidget';
import { ResetDeleteSingleCommit } from './ResetDeleteSingleCommit';
export class SinglePastCommitInfo extends React.Component {
    constructor(props) {
        super(props);
        this.showPastCommitWork = async () => {
            let detailedLogData;
            try {
                detailedLogData = await this.props.model.detailedLog(this.props.data.commit);
            }
            catch (err) {
                console.error(`Error while gettting detailed log for commit ${this.props.data.commit} and path ${this.props.model.pathRepository}`, err);
                this.setState(() => ({ loadingState: 'error' }));
                return;
            }
            if (detailedLogData.code === 0) {
                this.setState({
                    info: detailedLogData.modified_file_note,
                    filesChanged: detailedLogData.modified_files_count,
                    insertionCount: detailedLogData.number_of_insertions,
                    deletionCount: detailedLogData.number_of_deletions,
                    modifiedFiles: detailedLogData.modified_files,
                    loadingState: 'success'
                });
            }
        };
        this.showDeleteCommit = () => {
            this.setState({
                displayDelete: true,
                displayReset: false
            });
        };
        this.hideDeleteCommit = () => {
            this.setState({
                displayDelete: false
            });
        };
        this.showResetToCommit = () => {
            this.setState({
                displayReset: true,
                displayDelete: false
            });
        };
        this.hideResetToCommit = () => {
            this.setState({
                displayReset: false
            });
        };
        this.state = {
            displayDelete: false,
            displayReset: false,
            info: '',
            filesChanged: '',
            insertionCount: '',
            deletionCount: '',
            modifiedFiles: [],
            loadingState: 'loading'
        };
        this.showPastCommitWork();
    }
    render() {
        if (this.state.loadingState === 'loading') {
            return React.createElement("div", null, "...");
        }
        if (this.state.loadingState === 'error') {
            return React.createElement("div", null, "Error loading commit data");
        }
        return (React.createElement("div", null,
            React.createElement("div", { className: commitStyle },
                React.createElement("div", { className: commitOverviewNumbers },
                    React.createElement("span", null,
                        React.createElement(DefaultIconReact, { name: "file", className: iconStyle, tag: "span", title: "# Files Changed" }),
                        this.state.filesChanged),
                    React.createElement("span", null,
                        React.createElement(DefaultIconReact, { name: "git-insertionsMade", className: iconStyle, tag: "span", title: "# Insertions" }),
                        this.state.insertionCount),
                    React.createElement("span", null,
                        React.createElement(DefaultIconReact, { name: "git-deletionsMade", className: iconStyle, tag: "span", title: "# Deletions" }),
                        this.state.deletionCount))),
            React.createElement("div", { className: commitDetailStyle },
                React.createElement("div", { className: commitDetailHeader },
                    "Changed",
                    React.createElement("button", { className: classes(changeStageButtonStyle, floatRightStyle, discardFileButtonStyle), onClick: this.showDeleteCommit }),
                    React.createElement("button", { className: classes(changeStageButtonStyle, floatRightStyle, revertButtonStyle), onClick: this.showResetToCommit })),
                React.createElement("div", null,
                    this.state.displayDelete && (React.createElement(ResetDeleteSingleCommit, { action: "delete", commitId: this.props.data.commit, model: this.props.model, onCancel: this.hideDeleteCommit })),
                    this.state.displayReset && (React.createElement(ResetDeleteSingleCommit, { action: "reset", commitId: this.props.data.commit, model: this.props.model, onCancel: this.hideResetToCommit }))),
                React.createElement("ul", { className: fileList }, this.state.modifiedFiles.length > 0 &&
                    this.state.modifiedFiles.map((modifiedFile, modifiedFileIndex) => {
                        return (React.createElement("li", { className: commitDetailFileStyle, key: modifiedFileIndex },
                            React.createElement("span", { className: `${fileIconStyle} ${parseFileExtension(modifiedFile.modified_file_path)}`, onDoubleClick: () => {
                                    window.open('https://github.com/search?q=' +
                                        this.props.data.commit +
                                        '&type=Commits&utf8=%E2%9C%93');
                                } }),
                            React.createElement("span", { className: commitDetailFilePathStyle }, modifiedFile.modified_file_name),
                            isDiffSupported(modifiedFile.modified_file_path) && (React.createElement("button", { className: `${diffIconStyle}`, title: 'View file changes', onClick: async () => {
                                    await openDiffView(modifiedFile.modified_file_path, this.props.model, {
                                        previousRef: {
                                            gitRef: this.props.data.pre_commit
                                        },
                                        currentRef: { gitRef: this.props.data.commit }
                                    }, this.props.renderMime);
                                } }))));
                    })))));
    }
}
//# sourceMappingURL=SinglePastCommitInfo.js.map