import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import * as React from 'react';
import { IDiffContext } from './model';
/**
 * Determines if a given file is supported for diffs.
 *
 * This will be removed when "Plaintext" diffs are supported since that will be used
 * for cases where there is not a dedicated diff provider.
 *
 * @param path the file path
 */
export declare function isDiffSupported(path: string): boolean;
export interface IDiffProps {
    path: string;
    diffContext: IDiffContext;
}
/**
 * The parent diff component which maintains a registry of various diff providers.
 * Based on the extension of the file, it delegates to the relevant diff provider.
 */
export declare function Diff(props: IDiffProps): JSX.Element;
export declare const RenderMimeProvider: React.ProviderExoticComponent<React.ProviderProps<IRenderMimeRegistry>>;
export declare const RenderMimeConsumer: React.ExoticComponent<React.ConsumerProps<IRenderMimeRegistry>>;
